<?php

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}
require_once '../config/db.php';
require_once '../config/conexion.php';

$json = file_get_contents('php://input');
$data = json_decode($json);


if(isset($data->leadId)){
    $leadId = $data->leadId;
} else {
    $leadId= 1;
}
if(isset($data->gestor)){
    $gestor = $data->gestor;
} else {
    $gestor = 'MGR512';
}

$fecharegistro = date("Y-m-d H:i:s");

//Actualizar Gestor en la tabla leadId
actualizarGestorTV($leadId, $gestor);

$datosLead = consultaDatosGestor($gestor);

//GENERAR VENTA
$arregloResultado = generarVentaNuevo($leadId,$datosLead);

echo json_encode($arregloResultado);



function actualizarGestorTV($leadId, $gestor){

    global $con;
    global $fecharegistro;
    $estado = 'Transferido';
    
    try {
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblLeadCC SET GestorTV = ?, EstadoLead=?,FechaHoraAsignacion=? WHERE IdLeadCC = ?");
        $stmt->bind_param('sssi', $gestor, $estado, $fecharegistro,$leadId);
        $stmt->execute();
        $respuesta = $con->insert_id;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
        echo $respuesta;
        exit;
    }
}

function actualizarGestorTV_VENTA($leadId, $IdUsuario,$Matricula,$Comercial){

    global $con;
    global $fecharegistro;
    
    
    try {
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET IdUsuario=?,Matricula=?,Comercial=?,TCGestor = ?,FechaHoraREG=? WHERE IdLead = ?");
        $stmt->bind_param('issssi', $IdUsuario,$Matricula,$Comercial,$Matricula,$fecharegistro,$leadId);
        $stmt->execute();
        $respuesta = $con->insert_id;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
        echo $respuesta;
        exit;
    }
}

function consultaDatosGestor($Gestor){
    global $con;
    
    $sql_venta = "SELECT u.IdUsuario,u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Comercial FROM yifi58ge_dbUSUARIO.tblusuario u WHERE u.Matricula = ?";
    $data = array();
    
	try{       
        $stmt = $con->prepare($sql_venta);
        $stmt->bind_param('s', $Gestor);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdUsuario, $Matricula, $Comercial);
        
        if($stmt->num_rows > 0){
            while($row = $stmt->fetch()){
                $data[] = array_map("utf8_encode",['IdUsuario'=>$IdUsuario,'Matricula'=>$Matricula, 'Comercial'=>$Comercial]); 
            }
        }      
        
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
    return $data;
}

function generarVentaNuevo($leadId,$datosLead){
    
    global $con;
    global $fecharegistro;
    
    $IdUsuario=intval($datosLead[0]['IdUsuario']);
    $Matricula=$datosLead[0]['Matricula'];
    $Comercial=$datosLead[0]['Comercial'];
    //REGISTRAR DATOS EN LA TABLA VENTA
    $IdVenta = actualizarGestorTV_VENTA($leadId, $IdUsuario,$Matricula,$Comercial);
    $resultado = array(
            'respuesta' => 'exito',
            'IdVenta' => $IdVenta
        );
    return $resultado;
    
}

function actualizarGestorEstado($leadId, $gestor){

    global $con;
    global $fecharegistro;
    $estado = 'Transferido';
    
    try {
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tbllead SET GestorTV = ?, EstadoLead=?,FechaHoraAsignacion=? WHERE IdLead = ?");
        $stmt->bind_param('sssi', $gestor, $estado, $fecharegistro,$leadId);
        $stmt->execute();
        $respuesta = $con->insert_id;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
        echo $respuesta;
        exit;
    }
}

function generarVenta($datosLead){
    
    global $con;
    global $fecharegistro;

    $IdGeografico = $datosLead[0]['IdGeografico'];
    $NombreCompleto = $datosLead[0]['Nombre'].' '.$datosLead[0]['Apellido'];
    $Telefonouno = $datosLead[0]['Telefono'];
    $Segmento = $datosLead[0]['Segmento'];
    $TipoDocumento = $datosLead[0]['TipoDocumento'];
    $Documento = $datosLead[0]['Documento'];
    $GestorTV = $datosLead[0]['GestorTV'];
    //REGISTRAR DATOS EN LA TABLA DOCUMENTO
    $IdDocTV = registrarDocumento($TipoDocumento, $Documento);
    
    //REGISTRAR DATOS EN LA TABLA CLIENTE 
    $IdCliente = registrarCliente($IdGeografico, $NombreCompleto, $Telefonouno, $Segmento, $IdDocTV);
    
    $IdUsuario = intval($datosLead[0]['IdUsuario']);
    $Matricula = $datosLead[0]['GestorTV'];
    $Comercial = $datosLead[0]['NombresTV'].' '.$datosLead[0]['ApellidosTV'];
    $GestorMKT = $datosLead[0]['AgenteCall'];
    //REGISTRAR DATOS EN LA TABLA VENTA
    $IdVenta = registrarVenta($IdUsuario, $IdCliente, $Matricula, $Comercial, $Segmento, $GestorMKT, $GestorTV);
    $GestionOrigen = 'VENTA';
    
    $sqlagenda=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagenda(IdVenta, FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
    $sqlagenda->bind_param('iss',$IdVenta,$fecharegistro,$GestionOrigen);
    $sqlagenda->execute();
    
    $sqlfacturacion=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblfacturacion(IdVenta, FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
    $sqlfacturacion->bind_param('iss',$IdVenta,$fecharegistro,$GestionOrigen);
    $sqlfacturacion->execute();
    
    $resultado = array(
            'respuesta' => 'exito',
            'IdDocTV' => $IdDocTV,
            'IdCliente' => $IdCliente,
            'IdVenta' => $IdVenta
        );
        
    return $resultado;
    
}

function registrarDocumento($TipoDocumento, $Documento){
    
    global $con;
    global $fecharegistro;
    
    try {
        $stmt = $con->prepare("INSERT yifi58ge_dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES (?, ?, ?)");
        $stmt->bind_param('sss', $TipoDocumento, $Documento, $fecharegistro);
        $stmt->execute();
        $IdDocTV = $con->insert_id;
        $stmt->close();
        
        return $IdDocTV;
    } catch (\Exception $e) {
        $respuesta = 'error';
        echo $respuesta;
        exit;
    }
    
}

function registrarCliente($IdGeografico, $NombreCompleto, $Telefonouno, $Segmento, $IdDocTV){
    global $con;
    
    try {
        $stmt = $con->prepare("INSERT yifi58ge_dbVENTAS.tblcliente(IdGeografico, NombApellido, Telefonouno, Segmento, IdDocTV) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param('isssi', $IdGeografico, $NombreCompleto, $Telefonouno, $Segmento, $IdDocTV);
        $stmt->execute();
        $IdCliente = $con->insert_id;
        $stmt->close();
        
        return $IdCliente;
    } catch (\Exception $e) {
        $respuesta = 'error';
        echo $respuesta;
        exit;
    }

}

function registrarVenta($IdUsuario, $IdCliente, $Matricula, $Comercial, $Segmento, $GestorMKT, $gestor){
    global $con;
    global $fecharegistro;
    global $leadId;
    
    $tipoVenta = 'RE';
    $cc = '512';
    $TCTipoVenta='Televenta';
    $JefeVenta='MGR512';
    $EstadoVenta='';
    
    try {
        $stmt = $con->prepare("INSERT yifi58ge_dbVENTAS.tblventa(IdUsuario, IdCliente, FechaHoraREG, Matricula, Comercial, JefeVenta, CC, TipoVenta, Segmento, EstadoVenta, TCTipoVenta, GestorMKT, TCGestor, IdLead) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param('iisssssssssssi', $IdUsuario, $IdCliente, $fecharegistro, $Matricula, $Comercial, $JefeVenta, $cc, $tipoVenta, $Segmento, $EstadoVenta, $TCTipoVenta, $GestorMKT, $gestor, $leadId);
        $stmt->execute();
        $IdVenta = $con->insert_id;
        $stmt->close();
        
        return $IdVenta;
    } catch (\Exception $e) {
        $respuesta = 'error';
        echo $respuesta;
        exit;
    }
}