<?php

include('is_logged.php');
date_default_timezone_set('America/Lima');
//FUNCIONES UFT8 Y Fecha
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}
//CONEXION A LA BASE DE Datos
require '../config/db.php';
require '../config/conexion.php';
include 'funciones/stringtonull.php';

$gestion=stringtonull($_POST['lblgestion']);
$leadid=stringtonull($_POST['lblleadid']);
$distrito=stringtonull($_POST['lbldistritoz']);
$telefono=stringtonull($_POST['lbltelefono']);
$categoria="Contactado";
$fvisita=$_POST['lblfvisita'];
$hvisita=$_POST['lblhvisita'];
$fechaconvertfvisita=  myUrlEncode($fvisita);
$fechagrabarfvisita=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfvisita));

$horaconvertvisita=  myUrlEncode($hvisita);
$horagrabarvisita=  date("H:i", strtotime(str_replace("+"," ",$horaconvertvisita)));


$apellidos=stringtonull($_POST['lblapellidos']);
$nombres=stringtonull($_POST['lblnombres']);
$comentariolead=stringtonull($_POST['lblcomentariolead']);
$tipotransf=stringtonull($_POST['lbltipotransf']);
$resultadoscoring=stringtonull($_POST['lblresultadoscoring']);
$segmentoz=stringtonull($_POST['lblsegmentoz']);
$asignadopor=stringtonull($_POST['lblasignadopor']);
$origen=$_POST['lblorigen'];
$tipodoc=stringtonull($_POST['lbltipodoc']);
$documento=stringtonull($_POST['lbldocumento']);
$ValAsocial=stringtonull($_POST['ValAsocial']);
$gestortv=stringtonull($_POST['lblgestortv']);

$fecharegistrolead = date("Y-m-d H:i:s");
$fecharegistro = date("Y-m-d H:i:s");

if($tipotransf=="EnLinea"){
if($gestion=="Outbound"){
  $IdLead = insertarLead();
  if($IdLead>0){
    //Actualizar Gestor en la tabla leadId
    actualizarGestorEstadoCodigo($IdLead, $gestortv);
    $datosLead = consultaDatosLeadId($IdLead);
     //GENERAR VENTA
    $arregloResultado = generarVenta($datosLead,$IdLead);
    $resultadoFinal = array(
    'respuesta' => 'exito',
    'tipo' => 'Outbound',
    'id_lead' => $leadid
    );
    echo json_encode($resultadoFinal);
  }
}else if($gestion=="Inbound"){
  $IdLead = insertarLead();
     if($IdLead>0){
        //Actualizar Gestor en la tabla leadId
        actualizarGestorEstadoCodigo($IdLead, $gestortv);
        $datosLead = consultaDatosLeadId($IdLead);
         //GENERAR VENTA
        $arregloResultado = generarVenta($datosLead,$IdLead);
        $resultadoFinal = array(
        'respuesta' => 'exito',
        'tipo' => 'Inbound',
        'id_lead' => 'Inbound'.$IdLead
        );
        echo json_encode($resultadoFinal);
      }  
}

}else{
    if($gestion=="Outbound"){
  $IdLead = insertarLead();
  if($IdLead>0){
    //Actualizar Gestor en la tabla leadId
    actualizarGestorEstadoCodigo($IdLead, $gestortv);
    $datosLead = consultaDatosLeadId($IdLead);
     //GENERAR VENTA
    $arregloResultado = generarVentaBD($datosLead,$IdLead);
    $resultadoFinal = array(
    'respuesta' => 'exito',
    'tipo' => 'Outbound',
    'id_lead' => $leadid
    );
    echo json_encode($resultadoFinal);
  }
}else if($gestion=="Inbound"){
  $IdLead = insertarLead();
     if($IdLead>0){
        //Actualizar Gestor en la tabla leadId
        actualizarGestorEstadoCodigo($IdLead, $gestortv);
        $datosLead = consultaDatosLeadId($IdLead);
         //GENERAR VENTA
        $arregloResultado = generarVentaBD($datosLead,$IdLead);
        $resultadoFinal = array(
        'respuesta' => 'exito',
        'tipo' => 'Inbound',
        'id_lead' => 'Inbound'.$IdLead
        );
        echo json_encode($resultadoFinal);
      }  
}


}


//Funcion  Lead
function insertarLead(){
global $con;
global $categoria;
global $gestion;
global $leadid;
global $distrito;
global $telefono;
global $fechagrabarfvisita;
global $horagrabarvisita;
global $apellidos;
global $nombres;
global $comentariolead;
global $tipotransf;
global $resultadoscoring;
global $segmentoz;
global $asignadopor;
global $fecharegistrolead;
global $origen;

global $tipodoc;
global $documento;
global $ValAsocial;
global $gestortv;


        try {
          $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tbllead(Categoria, TipoTransferencia, AgenteCall,Gestion,Telefono,FechaCotizacion,HoraCotizacion,LeadID,IdGeografico,Comentario,ResultadoScoring,FechaHoraREG,Apellido,Nombre,Origen,Segmento,Asocial,TipoDocumento,Documento,GestorTV) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
          $stmt->bind_param('ssssssssisssssssssss', $categoria,$tipotransf,$asignadopor,$gestion,$telefono,$fechagrabarfvisita,$horagrabarvisita,$leadid,$distrito,$comentariolead,$resultadoscoring,$fecharegistrolead,$apellidos,$nombres,$origen,$segmentoz,$ValAsocial,$tipodoc,$documento,$gestortv);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = 'error';
        }
        return $respuesta;
}

//Funcion  Lead
function updateCodigoLead($id){
global $con;
global $codigoleadid;
$codigoleadid="Inbound".$id;
    try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tbllead as led SET led.LeadID=? Where led.IdLead=?");
        $stmt->bind_param('si', $codigoleadid,$id);
        $stmt->execute();
        $respuesta = $stmt->affected_rows;
        $stmt->close();  
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    return $respuesta; 
}

function actualizarGestorEstado($leadId, $gestor){

    global $con;
    $estado = 'Transferido';
    
    try {
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tbllead SET GestorTV = ?, EstadoLead=? WHERE IdLead = ?");
        $stmt->bind_param('ssi', $gestor, $estado, $leadId);
        $stmt->execute();
        $respuesta = $con->insert_id;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
        echo $respuesta;
        exit;
    }
}

function actualizarGestorEstadoCodigo($leadId, $gestor){

    global $con;
    global $tipotransf;
    global $gestion;
    global $leadid;
    global $fecharegistro;
    
    if($tipotransf=="EnLinea"){
    $estado = 'Transferido';    
    }else{
    $estado = NULL;
    }
    if($gestion=="Inbound"){
    $codigoleadid="Inbound".$leadId;    
    }else{
    $codigoleadid=$leadid;
    }
    
    
    try {
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tbllead SET GestorTV = ?, EstadoLead=?,LeadID=?,FechaHoraAsignacion=? WHERE IdLead = ?");
        $stmt->bind_param('ssssi', $gestor, $estado,$codigoleadid,$fecharegistro,$leadId);
        $stmt->execute();
        $respuesta = $con->insert_id;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
        echo $respuesta;
        exit;
    }
}


function consultaDatosLeadId($leadId){
    global $con;
    
    $sql_venta = $con->prepare("SELECT 
        l.IdLead, 
        l.Categoria, 
        l.TipoTransferencia, 
        l.AgenteCall,
        u.Nombres as NombresAgenteCall,
        u.Apellidos as ApellidossAgenteCall,
        l.Gestion, 
        l.Telefono,
        DATE_FORMAT(l.FechaCotizacion,'%d/%m/%Y') FechaCotizacion,
    	TIME_FORMAT(l.HoraCotizacion,'%r') HoraCotizacion,
        l.LeadID,
        l.IdGeografico,
        g.Distrito,
        g.Provincia,    
        l.Comentario, 
        l.ResultadoScoring, 
        DATE_FORMAT(l.FechaHoraREG, '%Y-%m-%d %r') FechaHoraREG, 
        l.Apellido, 
        l.Nombre, 
        l.Origen, 
        l.Segmento, 
        l.Asocial, 
        l.TipoDocumento, 
        l.Documento, 
        l.GestorTV,
        utv.IdUsuario,
        utv.Nombres as NombresTV,
        utv.Apellidos as ApellidosTV,
        v.IdLead as IdLeadVenta
        FROM tbllead l
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=l.IdGeografico
        INNER JOIN yifi58ge_dbUSUARIO.tblusuario u on u.Matricula=l.AgenteCall
        LEFT JOIN yifi58ge_dbUSUARIO.tblusuario utv on utv.Matricula=l.GestorTV
        LEFT JOIN yifi58ge_dbVENTAS.tblventa v on v.IdLead=l.IdLead
    WHERE  l.IdLead=? ");

    $sql_venta->bind_param('i',$leadId);
    $sql_venta->execute();
    $sql_venta->store_result();
    $sql_venta->bind_result(
        $IdLead, 
        $Categoria, 
        $TipoTransferencia, 
        $AgenteCall,
        $NombresAgenteCall,
        $ApellidossAgenteCall,
        $Gestion, 
        $Telefono,
        $FechaCotizacion,
    	$HoraCotizacion,
        $LeadID,
        $IdGeografico,
        $Distrito,
        $Provincia,    
        $Comentario, 
        $ResultadoScoring, 
        $FechaHoraREG, 
        $Apellido, 
        $Nombre, 
        $Origen, 
        $Segmento, 
        $Asocial, 
        $TipoDocumento, 
        $Documento, 
        $GestorTV,
        $IdUsuario,
        $NombresTV,
        $ApellidosTV,
        $IdLeadVenta
    );

    $numrows_venta = $sql_venta->num_rows;
    
    if ($numrows_venta > 0) {
        while ($sql_venta->fetch()) {
            $json[] = array_map("utf8_encode",['IdLead' => $IdLead,
                                                'Categoria' => $Categoria,
                                                'TipoTransferencia' => $TipoTransferencia,
                                                'AgenteCall' => $AgenteCall,
                                                'NombresAgenteCall' => $NombresAgenteCall,
                                                'ApellidossAgenteCall' => $ApellidossAgenteCall,
                                                'Gestion' => $Gestion,
                                                'Telefono' => $Telefono,
                                                'FechaCotizacion' => $FechaCotizacion,
                                                'HoraCotizacion' => $HoraCotizacion,
                                                'LeadID' => $LeadID,
                                                'IdGeografico' => $IdGeografico,
                                                'Distrito' => $Distrito,
                                                'Provincia' => $Provincia,
                                                'Comentario' => $Comentario,
                                                'ResultadoScoring' => $ResultadoScoring,
                                                'FechaHoraREG' => $FechaHoraREG,
                                                'Apellido' => $Apellido,
                                                'Nombre' => $Nombre,
                                                'Origen' => $Origen,
                                                'Segmento' => $Segmento,
                                                'Asocial' => $Asocial,
                                                'TipoDocumento' => $TipoDocumento,
                                                'Documento' => $Documento,
                                                'GestorTV' => $GestorTV,
                                                'IdUsuario' => $IdUsuario,
                                                'NombresTV' => $NombresTV,
                                                'ApellidosTV' => $ApellidosTV,
                                                'IdLeadVenta'=> $MIdLeadVenta]);
            // $data[] = $row;
        }
    }
    
    return $json;
}

function generarVenta($datosLead,$leadId){
    
    global $con;
    global $fecharegistro;

    $IdGeografico = $datosLead[0]['IdGeografico'];
    $NombreCompleto = $datosLead[0]['Nombre'].' '.$datosLead[0]['Apellido'];
    $Telefonouno = $datosLead[0]['Telefono'];
    $Segmento = $datosLead[0]['Segmento'];
    $TipoDocumento = $datosLead[0]['TipoDocumento'];
    $Documento = $datosLead[0]['Documento'];
    $GestorTV = $datosLead[0]['GestorTV'];
    //REGISTRAR DATOS EN LA TABLA DOCUMENTO
    $IdDocTV = registrarDocumento($TipoDocumento, $Documento);
    
    //REGISTRAR DATOS EN LA TABLA CLIENTE 
    $IdCliente = registrarCliente($IdGeografico, $NombreCompleto, $Telefonouno, $Segmento, $IdDocTV);
    
    $IdUsuario = intval($datosLead[0]['IdUsuario']);
    $Matricula = $datosLead[0]['GestorTV'];
    $Comercial = $datosLead[0]['NombresTV'].' '.$datosLead[0]['ApellidosTV'];
    $GestorMKT = $datosLead[0]['AgenteCall'];
    //REGISTRAR DATOS EN LA TABLA VENTA
    $IdVenta = registrarVenta($IdUsuario, $IdCliente, $Matricula, $Comercial, $Segmento, $GestorMKT, $GestorTV,$leadId);
    $GestionOrigen = 'VENTA';
    
    $sqlagenda=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagenda(IdVenta, FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
    $sqlagenda->bind_param('iss',$IdVenta,$fecharegistro,$GestionOrigen);
    $sqlagenda->execute();

    $sqlfacturacion=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblfacturacion(IdVenta, FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
    $sqlfacturacion->bind_param('iss',$IdVenta,$fecharegistro,$GestionOrigen);
    $sqlfacturacion->execute();


    $resultado = array(
            'respuesta' => 'exito',
            'IdDocTV' => $IdDocTV,
            'IdCliente' => $IdCliente,
            'IdVenta' => $IdVenta
        );
        
    return $resultado;
    
}

function generarVentaBD($datosLead,$leadId){
    
    global $con;
    global $fecharegistro;

    $IdGeografico = $datosLead[0]['IdGeografico'];
    $NombreCompleto = $datosLead[0]['Nombre'].' '.$datosLead[0]['Apellido'];
    $Telefonouno = $datosLead[0]['Telefono'];
    $Segmento = NULL;
    $TipoDocumento = $datosLead[0]['TipoDocumento'];
    $Documento = $datosLead[0]['Documento'];
    $GestorTV = NULL;
    //REGISTRAR DATOS EN LA TABLA DOCUMENTO
    $IdDocTV = NULL;
    
    //REGISTRAR DATOS EN LA TABLA CLIENTE 
    $IdCliente = registrarCliente($IdGeografico, $NombreCompleto, $Telefonouno, $Segmento, $IdDocTV);
    
    $IdUsuario = 608;
    $Matricula = "MGR512";
    $Comercial = "RAUL RUBIO";
    $GestorMKT = $datosLead[0]['AgenteCall'];
    //REGISTRAR DATOS EN LA TABLA VENTA
    $IdVenta = registrarVenta($IdUsuario, $IdCliente, $Matricula, $Comercial, $Segmento, $GestorMKT, $GestorTV,$leadId);
    $GestionOrigen = 'VENTA';
    
    
    $sqlagenda=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagenda(IdVenta, FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
    $sqlagenda->bind_param('iss',$IdVenta,$fecharegistro,$GestionOrigen);
    $sqlagenda->execute();

    $sqlfacturacion=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblfacturacion(IdVenta, FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
    $sqlfacturacion->bind_param('iss',$IdVenta,$fecharegistro,$GestionOrigen);
    $sqlfacturacion->execute();

    $resultado = array(
            'respuesta' => 'exito',
            'IdCliente' => $IdCliente,
            'IdVenta' => $IdVenta
        );
        
    return $resultado;
    
}

function registrarDocumento($TipoDocumento, $Documento){
    
    global $con;
    global $fecharegistro;
    
    try {
        $stmt = $con->prepare("INSERT yifi58ge_dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES (?, ?, ?)");
        $stmt->bind_param('sss', $TipoDocumento, $Documento, $fecharegistro);
        $stmt->execute();
        $IdDocTV = $con->insert_id;
        $stmt->close();
        
        return $IdDocTV;
    } catch (\Exception $e) {
        $respuesta = 'error';
        echo $respuesta;
        exit;
    }
    
}

function registrarCliente($IdGeografico, $NombreCompleto, $Telefonouno, $Segmento, $IdDocTV){
    global $con;
    
    try {
        $stmt = $con->prepare("INSERT yifi58ge_dbVENTAS.tblcliente(IdGeografico, NombApellido, Telefonouno, Segmento, IdDocTV) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param('isssi', $IdGeografico, $NombreCompleto, $Telefonouno, $Segmento, $IdDocTV);
        $stmt->execute();
        $IdCliente = $con->insert_id;
        $stmt->close();
        
        return $IdCliente;
    } catch (\Exception $e) {
        $respuesta = 'error';
        echo $respuesta;
        exit;
    }

}

function registrarVenta($IdUsuario, $IdCliente, $Matricula, $Comercial, $Segmento, $GestorMKT, $gestor,$leadId){
    global $con;
    global $fecharegistro;
    
    $tipoVenta = 'RE';
    $cc = '512';
    $TCTipoVenta='Televenta';
    $JefeVenta='MGR512';
    $EstadoVenta='';
    
    try {
        $stmt = $con->prepare("INSERT yifi58ge_dbVENTAS.tblventa(IdUsuario, IdCliente, FechaHoraREG, Matricula, Comercial, JefeVenta, CC, TipoVenta, Segmento, EstadoVenta, TCTipoVenta, GestorMKT, TCGestor, IdLead,CCOriginal) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)");
        $stmt->bind_param('iisssssssssssis', $IdUsuario, $IdCliente, $fecharegistro, $Matricula, $Comercial, $JefeVenta, $cc, $tipoVenta, $Segmento, $EstadoVenta, $TCTipoVenta, $GestorMKT, $gestor, $leadId,$cc);
        $stmt->execute();
        $IdVenta = $con->insert_id;
        $stmt->close();
        
        return $IdVenta;
    } catch (\Exception $e) {
        $respuesta = 'error';
        echo $respuesta;
        exit;
    }
}

