<?php

include('is_logged.php');

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}

require_once '../config/db.php';
require_once '../config/conexion.php';

$direccion = $_POST['direccion'];
$telefono = $_POST['telefono'];
$objGeofinder = $_POST['objGeofinder'];
$tipo = $_POST['tipo'];
$Busqueda = $_POST['Busqueda'];
//Nueva microzona 
$microzona = $_POST['microzona'];
$asignacion = consultaAsignacion($microzona);

$fecharegistro = date("Y-m-d H:i:s");
$user = $_SESSION['matriculausuario'];

try {
        
    $stmt = $con->prepare("INSERT INTO tbltmpdirecciones(Direccion, ObjGeofinder, Telefono, FechaHoraReg, Gestor, TipoDireccion, Busqueda, Asignacion) VALUES(?, ?, ?, ?, ?, ?, ?, ?) ");
    $stmt->bind_param('ssssssss', $direccion, $objGeofinder, $telefono, $fecharegistro, $user, $tipo, $Busqueda, $asignacion);
    $stmt->execute();
    
    $idDireccion = $con->insert_id;
    
    if($idDireccion > 0){
        $resultado = array(
            'respuesta' => 'Exito',
            'asignacion' => $asignacion,
            'idDireccion' => $idDireccion
        );
    } else {
        $resultado = array(
            'respuesta' => 'SinCambios'
        );
    }

    $stmt->close();
    
} catch (\Exception $e) {
    $resultado = array(
            'respuesta' => 'error'
        );
}

echo json_encode($resultado);

function consultaAsignacion($microzona){
    global $con;
    
    $sql = "SELECT * FROM tblzonificacion WHERE Microzona = '".$microzona."' AND Distrito = 'RIMAC'";
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
        $fila = $resultado->fetch_assoc();
    
        $asignacion = $fila['Asignacion'];
    } else {
        $asignacion = '';
    }
    
    return $asignacion;
}