<?php

function generarIdGeografico($CodUbigeo){
    global $con;
    
    try{
        $sql = $con->prepare("SELECT IdGeografico FROM tblgeografico WHERE CodUbigeoReniec = ?");
        $sql->bind_param('s',$CodUbigeo);
        $sql->execute();
        $sql->store_result();
        $sql->bind_result(
            $IdGeograficoRow
            );
        $respuesta = $sql->num_rows;
        
        if($respuesta > 0){
            while($sql->fetch()){
                $idGeografico = $IdGeograficoRow;
            }
        } else {
            $idGeografico = 0;
        }
        
        $sql->close();
        return $idGeografico;
    } catch (\Exception $e) {
        $respuesta = 'error';
        echo $respuesta;
        exit;
    }    
}

function registrarDocumento($TipoDocumento, $Documento){
    
    global $con;
    global $fecharegistro;
    
    try {
        $stmt = $con->prepare("INSERT yifi58ge_dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES (?, ?, ?)");
        $stmt->bind_param('sss', $TipoDocumento, $Documento, $fecharegistro);
        $stmt->execute();
        $IdDocTV = $con->insert_id;
        
        $stmt->close();
        
        return $IdDocTV;
    } catch (\Exception $e) {
        $respuesta = 'error';
        echo $respuesta;
        exit;
    }
    
}

function registrarCliente($IdGeografico, $NombreCompleto, $Telefonouno, $Segmento, $IdDocTV,$npiso=null,$tiposegmento=null){
    global $con;
    
    try {
        $stmt = $con->prepare("INSERT yifi58ge_dbVENTAS.tblcliente(IdGeografico, NombApellido, Telefonouno, Segmento, IdDocTV,NPiso,TipoSegmento) VALUES (?, ?, ?, ?, ?,?,?)");
        $stmt->bind_param('isssiis', $IdGeografico, $NombreCompleto, $Telefonouno, $Segmento, $IdDocTV,$npiso,$tiposegmento);
        $stmt->execute();
        $IdCliente = $con->insert_id;
        $stmt->close();
        
        return $IdCliente;
    } catch (\Exception $e) {
        $respuesta = 'error';
        echo $respuesta;
        exit;
    }

}

function consultaDatosGestor($Gestor){
    global $con;
    
    $sql_venta = $con->prepare("SELECT u.IdUsuario, u.Matricula, CONCAT(u.Nombres,' ',u.Apellidos) Comercial FROM yifi58ge_dbUSUARIO.tblusuario u WHERE u.Matricula = ?");
    $sql_venta->bind_param('s',$Gestor);
    $sql_venta->execute();
    $sql_venta->store_result();
    $sql_venta->bind_result(
        $IdUsuarioRow,
        $MatriculaRow,
        $ComercialRow
        );
    $numrows_venta = $sql_venta->num_rows;
    
    if ($numrows_venta > 0) {
        while ($sql_venta->fetch()) {
        $data[] = ['IdUsuario'=>$IdUsuarioRow,
                   'Matricula'=>$MatriculaRow,
                   'Comercial'=>$ComercialRow];
        }
    }else{
        $data[]=['IdUsuario'=>null,
                'Matricula'=>null,
                'Comercial'=>null];
    }
    
    return $data;
}

function generarVenta($idCli, $datosLead, $segmento, $gestorTV,$GestorMKT){
    
    global $con;
    global $fecharegistro;
    global $IdLeadCC;
    global $origen;
    global $leadid;
    
    $IdUsuario=intval($datosLead[0]['IdUsuario']);
    $Matricula=$datosLead[0]['Matricula'];
    $Comercial=$datosLead[0]['Comercial'];
    //$GestorMKT = null;

    $sql = $con->prepare("SELECT IdVenta FROM tblventa WHERE IdLead =?");
    $sql->bind_param('i',$IdLeadCC);
    $sql->execute();
    $sql->store_result();
    $sql->bind_result(
        $IdVentaRow
        );
        
    $row_cnt = $sql->num_rows;
    
    if($row_cnt > 0){

        while ($sql->fetch()) {
            $IdVenta=$IdVentaRow;
        }        
        
        $resultado_update=actualizarVenta($IdVenta,$IdUsuario, $Matricula, $Comercial, $Segmento, $GestorMKT);

        return $IdVenta;
    }else{
        //REGISTRAR DATOS EN LA TABLA VENTA
        $IdVenta = registrarVenta($IdUsuario, $idCli, $Matricula, $Comercial, $segmento, $GestorMKT);
        
        $GestionOrigen = 'VENTA';
        
        $sqlagenda=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagenda(IdVenta,FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
        $sqlagenda->bind_param('iss',$IdVenta,$fecharegistro,$GestionOrigen);
        $sqlagenda->execute();
        $sqlfacturacion=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblfacturacion(IdVenta, FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
        $sqlfacturacion->bind_param('iss',$IdVenta,$fecharegistro,$GestionOrigen);
        $sqlfacturacion->execute();
        return $IdVenta;
    }

    
    
}

function registrarVenta($IdUsuario, $IdCliente, $Matricula, $Comercial, $Segmento, $GestorMKT){
    global $con;
    global $fecharegistro;
    global $IdLeadCC;
    global $origen;
    global $leadid;
    
    $tipoVenta = 'RE';
    $cc = '512';
    $TCTipoVenta='Televenta';
    $TipoTV='Transferencia';
    $JefeVenta='MGR512';
    $EstadoVenta='';
    
    try {
        $stmt = $con->prepare("INSERT yifi58ge_dbVENTAS.tblventa(IdUsuario, IdCliente, FechaHoraREG, Matricula, Comercial, JefeVenta, CC, TipoVenta, Segmento, EstadoVenta, TCTipoVenta, GestorMKT, TCGestor, IdLead,CCOriginal,TipoTV,OrigenVisita,LeadID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?)");
        $stmt->bind_param('iisssssssssssissss', $IdUsuario, $IdCliente, $fecharegistro, $Matricula, $Comercial, $JefeVenta, $cc, $tipoVenta, $Segmento, $EstadoVenta, $TCTipoVenta, $GestorMKT, $Matricula, $IdLeadCC,$cc,$TipoTV,$origen,$leadid);
        $stmt->execute();
        
        $IdVenta = $con->insert_id;
        
        $stmt->close();
        
        return $IdVenta;
    } catch (\Exception $e) {
        $respuesta = 'error';
        return $respuesta;
        exit;
    }
}

function actualizarVenta($IdVenta,$IdUsuario, $Matricula, $Comercial, $Segmento, $GestorMKT){
    global $con;
    global $fecharegistro;
    global $IdLeadCC;

    $tipoVenta = 'RE';
    $cc = '512';
    $TCTipoVenta='Televenta';
    $TipoTV='Transferencia';
    $JefeVenta='MGR512';
    $EstadoVenta='';    
    try {
        $stmt = $con->prepare("update yifi58ge_dbVENTAS.tblventa SET IdUsuario=?, FechaHoraREG=?, Matricula=?, Comercial=?, JefeVenta=?, CC=?, TipoVenta=?, Segmento=?, EstadoVenta=?, TCTipoVenta=?, GestorMKT=?, TCGestor=?, CCOriginal=?,TipoTV=? where IdLead=?");
        $stmt->bind_param('isssssssssssssi', $IdUsuario, $fecharegistro, $Matricula, $Comercial, $JefeVenta, $cc, $tipoVenta, $Segmento, $EstadoVenta, $TCTipoVenta, $GestorMKT, $Matricula, $cc,$TipoTV,$IdLeadCC);
        $stmt->execute();
        $respuesta = $stmt->affected_rows;
        $stmt->close();
        
        return $respuesta;
    } catch (\Exception $e) {
        $respuesta = 'error';
        echo $respuesta;
        exit;
    }    
}

?>