<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
//LIBRERIA DE EXPORTACION
require_once 'libreria/Spout/Autoloader/autoload.php';

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}

$fechainicial = $_GET['lblfinicial'];
$fechafinal = $_GET['lblffinal'];

$fechaconvertfinicial=  myUrlEncode($fechainicial);
$fechagrabarfinicial=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfinicial));
$fechaconvertffinal=  myUrlEncode($fechafinal);
$fechagrabarffinal=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertffinal));

$delegacion = $_GET['delegacion'];

$fileName = 'CheckINRP_DEL.csv';

$writer = WriterEntityFactory::createCSVWriter();

$writer->openToBrowser($fileName);

$head = array(
    'IdProspectoRP',
    'EstadoProspecto',
    'CC',
    'Segmento',
    'TipoVenta',
    'FechaHoraREG',
    'FechaVisitaRP',
    'HoraVisitaRP',
    'Comercial',
    'JefeVenta',
    'NombApellido',
    'Telefonouno',
    'Telefonodos',
    'Direccion',
    'Distrito',
    'Provincia',
    'CheckinRP'
);
$rowFromValues = WriterEntityFactory::createRowFromArray($head);
$writer->addRow($rowFromValues);

date_default_timezone_set('America/Lima');

$fecharegistro=date("Y-m-d H:i:s");

$query="SELECT 
    p.IdProspectoRP,
    p.EstadoProspecto,
    p.CC,
    p.Segmento,
    p.TipoVenta,
    p.FechaHoraREG,
    p.FechaVisitaRP,
    p.HoraVisitaRP,
    p.Comercial,
    p.JefeVenta,
    c.NombApellido,
    c.Telefonouno,
    c.Telefonodos,
    c.Direccion,
    g.Distrito,
    g.Provincia,
    p.CheckinRP
    FROM tblprospectorp p
    INNER JOIN tblcliente c ON p.IdCliente = c.IdCliente
    INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
    WHERE p.CC='".$delegacion."' AND ( FechaVisitaRP BETWEEN '".$fechagrabarfinicial." 00:00' AND '".$fechagrabarffinal." 23:59')
";

$result = $con->query($query);

while ($Venta = $result->fetch_assoc()){
  $rowData = WriterEntityFactory::createRowFromArray($Venta);
  $writer->addRow($rowData);
}


$result->close();

$writer->close();

$con->close();

?>
