<?php

require_once '../config/db.php';
require_once '../config/conexion.php';

$json = file_get_contents('php://input');

if(!empty($json)){
    $data = json_decode($json);
    $fechadiahoy= $data->mesvisita;
} else {
    $fechadiahoy='Jan-2021';
}

//DECLARAR ARREGLO DE DATOS PARA LAS CONSULTAS
$data = array();

$gestores = consultaGestores($fechadiahoy);

if ($gestores == ''){
    $arregloDatos =  array(
        'Resultado' => 'SinGenerar' 
    );
} else {

    $arregloFacturadas = consultaFacturadaTV($fechadiahoy);
    $arregloInstaladas = consultaInstaladaTV($fechadiahoy);
    $arregloAgendadas = consultaAgendadaTV($fechadiahoy);
    $arregloPendienteAgenda = consultaPendienteAgendaTV($fechadiahoy);
    $arregloIncidencia = consultaIncidenciaTV($fechadiahoy);
    
    //NUEVOS DATOS SOBRE PAGOS
    $arregloPreciokit = consultaPromedioVenta($fechadiahoy);
    $arregloCantidadExtra = consultaCantidadExtra($fechadiahoy);
    $arregloPrecioExtras = consultaPromedioExtras($fechadiahoy);
    $arregloRegalo = consultaCantidadRegalo($fechadiahoy);
    $arregloCantidadDescuento3Meses = consultaCantidadDescuento3meses($fechadiahoy);
    
    $arregloSegmento = consultaDataSegmento($fechadiahoy);
    $arregloScoring = consultaDataScoring($fechadiahoy);
    $arregloTipoKit = consultaDataTipoKit($fechadiahoy);
    
    $arregloDatos = array();
    
    $arregloDatosTC = array();  //511
    $arregloDatosTV = array(); //512


    //VARIABLES TOTALES
    $totalfacturadas = 0;
    $totalinstaldas = 0;
    $totalagendadas = 0;
    $totalpendienteagenda = 0;
    $totalincidencia = 0;
    $totalventasbrutas = 0;
    $totalobjetivo = 0;
    $totalxmorxven = 0;
    $totalventasnetas = 0;
    //VARIABLES TOTALES COSTO
    $totalPromVenta = 0;
    $totalDispExtras = 0;
    $totalPVentaExtras =0;
    $totalRegalos = 0;
    $totalDescuento = 0;
    $totalPromVtaRegalo = 0;

    //511
    //VARIABLES TOTALES
    $totalfacturadas511 = 0;
    $totalinstaldas511 = 0;
    $totalagendadas511 = 0;
    $totalpendienteagenda511 = 0;
    $totalincidencia511 = 0;
    $totalventasbrutas511 = 0;
    $totalobjetivo511 = 0;
    $totalxmorxve511n = 0;
    $totalventasnetas511 = 0;
    //VARIABLES TOTALES COSTO
    $totalPromVenta511 = 0;
    $totalDispExtras511 = 0;
    $totalPVentaExtras511 =0;
    $totalRegalos511 = 0;
    $totalDescuento511 = 0;
    $totalPromVtaRegalo511 = 0;
    //512
    //VARIABLES TOTALES
    $totalfacturadas512 = 0;
    $totalinstaldas512 = 0;
    $totalagendadas512 = 0;
    $totalpendienteagenda512 = 0;
    $totalincidencia512 = 0;
    $totalventasbrutas512 = 0;
    $totalobjetivo512 = 0;
    $totalxmorxven512 = 0;
    $totalventasnetas512 = 0;
    //VARIABLES TOTALES COSTO
    $totalPromVenta512 = 0;
    $totalDispExtras512 = 0;
    $totalPVentaExtras512 =0;
    $totalRegalos512 = 0;
    $totalDescuento512 = 0;
    $totalPromVtaRegalo512 = 0;

    //CANTIDAD GESTORES
    $cantidadGestores = count($gestores);
    
    $cantidadGestores511 = 0;
    $cantidadGestores512 = 0;

    for($i=0; $i<count($gestores); $i++){
    
        $gestor = $gestores[$i]['Matricula'];
        
        $facturadas = cantidadTV($gestor, $arregloFacturadas);
        $instaladas = cantidadTV($gestor, $arregloInstaladas);
        $agendadas = cantidadTV($gestor, $arregloAgendadas);
        $pendienteagenda = cantidadTV($gestor, $arregloPendienteAgenda);
        $incidencia = cantidadTV($gestor, $arregloIncidencia);
        
        $VentasBrutas = $facturadas+$instaladas+$agendadas+$pendienteagenda+$incidencia;
        
        $objetivo = $gestores[$i]['Objetivo'];
        $xmorxven = $gestores[$i]['Xmor'];
        
        $VentasNetas = $VentasBrutas-$xmorxven;
        if ($objetivo > 0){
            $Cumplimiento = number_format(round(($VentasNetas/$objetivo)*100, 2), 2, ',', ' '); 
        } else {
            $Cumplimiento = "0,00";
        }
    
        //TOTALES
        $totalfacturadas += $facturadas;
        $totalinstaldas += $instaladas;
        $totalagendadas += $agendadas;
        $totalpendienteagenda += $pendienteagenda;
        $totalincidencia += $incidencia;
        $totalventasbrutas += $VentasBrutas;
        $totalobjetivo += $objetivo;
        $totalxmorxven += $xmorxven;
        $totalventasnetas += $VentasNetas;
        
        //NUEVOS VALORES
        $sumPreciokit = cantidadTV($gestor, $arregloPreciokit);
        $sumExtras = cantidadTV($gestor, $arregloPrecioExtras);
        if($VentasBrutas > 0){
            $promPrecioKit = number_format(round($sumPreciokit/$VentasBrutas, 2), 2, ',', '');
            $promExtras = number_format(round($sumExtras/$VentasBrutas, 2), 2, ',', '');
            
            $promVentaExtras = $promPrecioKit+$promExtras;
            $promVentaExtras = number_format(round($promVentaExtras, 2), 2, ',', '');
        } else {
            $promPrecioKit = "0,00";
            $promExtras = "0,00";
            
            $promVentaExtras = "0,00";
        }
        
    
        $cantidadExtra = cantidadTV($gestor, $arregloCantidadExtra);
        $cantidadRegalo = cantidadTV($gestor, $arregloRegalo);
        $cantidadMesesDescuento = cantidadTV($gestor, $arregloCantidadDescuento3Meses);
        
        $totalPromVenta += $promPrecioKit;
        $totalPromVentaExtras  += $promVentaExtras;
        
        $totalDispExtras += $cantidadExtra;
        $totalRegalos += $cantidadRegalo;
        $totalDescuento += $cantidadMesesDescuento;
        
        //VentaRegalo
        if($VentasBrutas > 0){
            $ventaRegalo = number_format(round(($cantidadMesesDescuento/$VentasBrutas)*100, 2), 2, ',', ' ');
        }else {
            $ventaRegalo = "0,00";
        }
        
        $arregloDatos[$i] = array(
                'MesVisita' => $fechadiahoy,
                'Gestor' => $gestores[$i]['Matricula'].' - '.$gestores[$i]['Gestor'],
                'CC' => $gestores[$i]['CC'],
                'Estado' => $gestores[$i]['Estado'],
                'Facturadas' => $facturadas,
                'Instaladas' => $instaladas,
                'Agendadas' => $agendadas,
                'PenAgenda' => $pendienteagenda,
                'Incidencia' => $incidencia,
                'VentasBrutas' => $VentasBrutas,
                'Objetivo' => $objetivo,
                'XmorXven' => $xmorxven,
                'VentasNetas' => $VentasNetas,
                'Cumplimiento' => $Cumplimiento,
                'PromedioVenta' => $promPrecioKit,
                'CantidadExtra' => $cantidadExtra,
                'PromedioVentaExtras' => $promVentaExtras,
                'CantidadMesesDescuento' => $cantidadMesesDescuento,
                'CantidadRegalo' => $cantidadRegalo,
                'VentaRegalo' => $ventaRegalo
            );
            
        if($gestores[$i]['CC'] == '511'){
            
                $facturadas511 = cantidadTV($gestor, $arregloFacturadas);
                $instaladas511 = cantidadTV($gestor, $arregloInstaladas);
                $agendadas511 = cantidadTV($gestor, $arregloAgendadas);
                $pendienteagenda511 = cantidadTV($gestor, $arregloPendienteAgenda);
                $incidencia511 = cantidadTV($gestor, $arregloIncidencia);
                
                $VentasBrutas511 = $facturadas511+$instaladas511+$agendadas511+$pendienteagenda511+$incidencia511;
                
                $objetivo511 = $gestores[$i]['Objetivo'];
                $xmorxven511 = $gestores[$i]['Xmor'];
                
                $VentasNetas511 = $VentasBrutas511-$xmorxven511;
                if ($objetivo511 > 0){
                    $Cumplimiento511 = number_format(round(($VentasNetas511/$objetivo511)*100, 2), 2, ',', ' '); 
                } else {
                    $Cumplimiento511 = "0,00";
                }
            
                //TOTALES
                $totalfacturadas511 += $facturadas511;
                $totalinstaldas511 += $instaladas511;
                $totalagendadas511 += $agendadas511;
                $totalpendienteagenda511 += $pendienteagenda511;
                $totalincidencia511 += $incidencia511;
                $totalventasbrutas511 += $VentasBrutas511;
                $totalobjetivo511 += $objetivo511;
                $totalxmorxven511 += $xmorxven511;
                $totalventasnetas511 += $VentasNetas511;
                
                //NUEVOS VALORES
                $sumPreciokit511 = cantidadTV($gestor, $arregloPreciokit);
                $sumExtras511 = cantidadTV($gestor, $arregloPrecioExtras);
                if($VentasBrutas511 > 0){
                    $promPrecioKit511 = number_format(round($sumPreciokit511/$VentasBrutas511, 2), 2, ',', '');
                    $promExtras511 = number_format(round($sumExtras511/$VentasBrutas511, 2), 2, ',', '');
                    
                    $promVentaExtras511 = $promPrecioKit511+$promExtras511;
                    $promVentaExtras511 = number_format(round($promVentaExtras511, 2), 2, ',', '');
                } else {
                    $promPrecioKit511 = "0,00";
                    $promExtras511 = "0,00";
                    
                    $promVentaExtras511 = "0,00";
                }
                
            
                $cantidadExtra511 = cantidadTV($gestor, $arregloCantidadExtra);
                $cantidadRegalo511 = cantidadTV($gestor, $arregloRegalo);
                $cantidadMesesDescuento511 = cantidadTV($gestor, $arregloCantidadDescuento3Meses);
                
                $totalPromVenta511 += $promPrecioKit511;
                $totalPromVentaExtras511  += $promVentaExtras511;
                
                $totalDispExtras511 += $cantidadExtra511;
                $totalRegalos511 += $cantidadRegalo511;
                $totalDescuento511 += $cantidadMesesDescuento511;
                
                //VentaRegalo
                if($VentasBrutas511 > 0){
                    $ventaRegalo511 = number_format(round(($cantidadMesesDescuento511/$VentasBrutas511)*100, 2), 2, ',', ' ');
                }else {
                    $ventaRegalo511 = "0,00";
                }
            
            
            
            $arregloDatos['511'][$cantidadGestores511] = array(
                'MesVisita' => $fechadiahoy,
                'Gestor' => $gestores[$i]['Matricula'].' - '.$gestores[$i]['Gestor'],
                'CC' => $gestores[$i]['CC'],
                'Estado' => $gestores[$i]['Estado'],
                'Facturadas' => $facturadas511,
                'Instaladas' => $instaladas511,
                'Agendadas' => $agendadas511,
                'PenAgenda' => $pendienteagenda511,
                'Incidencia' => $incidencia511,
                'VentasBrutas' => $VentasBrutas511,
                'Objetivo' => $objetivo511,
                'XmorXven' => $xmorxven511,
                'VentasNetas' => $VentasNetas511,
                'Cumplimiento' => $Cumplimiento511,
                'PromedioVenta' => $promPrecioKit511,
                'CantidadExtra' => $cantidadExtra511,
                'PromedioVentaExtras' => $promVentaExtras511,
                'CantidadMesesDescuento' => $cantidadMesesDescuento511,
                'CantidadRegalo' => $cantidadRegalo511,
                'VentaRegalo' => $ventaRegalo511
            );
            
            $cantidadGestores511++;
        }
        
        if($gestores[$i]['CC'] == '512'){
            
                $facturadas512 = cantidadTV($gestor, $arregloFacturadas);
                $instaladas512 = cantidadTV($gestor, $arregloInstaladas);
                $agendadas512 = cantidadTV($gestor, $arregloAgendadas);
                $pendienteagenda512 = cantidadTV($gestor, $arregloPendienteAgenda);
                $incidencia512 = cantidadTV($gestor, $arregloIncidencia);
                
                $VentasBrutas512 = $facturadas512+$instaladas512+$agendadas512+$pendienteagenda512+$incidencia512;
                
                $objetivo512 = $gestores[$i]['Objetivo'];
                $xmorxven512 = $gestores[$i]['Xmor'];
                
                $VentasNetas512 = $VentasBrutas512-$xmorxven512;
                if ($objetivo512 > 0){
                    $Cumplimiento512 = number_format(round(($VentasNetas512/$objetivo512)*100, 2), 2, ',', ' '); 
                } else {
                    $Cumplimiento512 = "0,00";
                }
            
                //TOTALES
                $totalfacturadas512 += $facturadas512;
                $totalinstaldas512 += $instaladas512;
                $totalagendadas512 += $agendadas512;
                $totalpendienteagenda512 += $pendienteagenda512;
                $totalincidencia512 += $incidencia512;
                $totalventasbrutas512 += $VentasBrutas512;
                $totalobjetivo512 += $objetivo512;
                $totalxmorxven512 += $xmorxven512;
                $totalventasnetas512 += $VentasNetas512;
                
                //NUEVOS VALORES
                $sumPreciokit512 = cantidadTV($gestor, $arregloPreciokit);
                $sumExtras512 = cantidadTV($gestor, $arregloPrecioExtras);
                if($VentasBrutas512 > 0){
                    $promPrecioKit512 = round($sumPreciokit512/$VentasBrutas512, 2);
                    $promExtras512 = round($sumExtras512/$VentasBrutas512, 2);
                    $promVentaExtras512 = $promPrecioKit512+$promExtras512;
                    
                    $promPrecioKit512 = number_format($promPrecioKit512, 2, ',', '');
                    $promExtras512 = number_format($promExtras512, 2, ',', '');
                    $promVentaExtras512 = number_format($promVentaExtras512, 2, ',', '');
                } else {
                    $promPrecioKit512 = "0,00";
                    $promExtras512 = "0,00";
                    
                    $promVentaExtras512 = "0,00";
                }
                
            
                $cantidadExtra512 = cantidadTV($gestor, $arregloCantidadExtra);
                $cantidadRegalo512 = cantidadTV($gestor, $arregloRegalo);
                $cantidadMesesDescuento512 = cantidadTV($gestor, $arregloCantidadDescuento3Meses);
                
                $totalPromVenta512 += $promPrecioKit512;
                $totalPromVentaExtras512  += $promVentaExtras512;
                
                $totalDispExtras512 += $cantidadExtra512;
                $totalRegalos512 += $cantidadRegalo512;
                $totalDescuento512 += $cantidadMesesDescuento512;
                
                //VentaRegalo
                if($VentasBrutas512 > 0){
                    $ventaRegalo512 = number_format(round(($cantidadMesesDescuento512/$VentasBrutas512)*100, 2), 2, ',', ' ');
                }else {
                    $ventaRegalo512 = "0,00";
                }
            
            
            $arregloDatos['512'][$cantidadGestores512] = array(
                'MesVisita' => $fechadiahoy,
                'Gestor' => $gestores[$i]['Matricula'].' - '.$gestores[$i]['Gestor'],
                'CC' => $gestores[$i]['CC'],
                'Estado' => $gestores[$i]['Estado'],
                'Facturadas' => $facturadas512,
                'Instaladas' => $instaladas512,
                'Agendadas' => $agendadas512,
                'PenAgenda' => $pendienteagenda512,
                'Incidencia' => $incidencia512,
                'VentasBrutas' => $VentasBrutas512,
                'Objetivo' => $objetivo512,
                'XmorXven' => $xmorxven512,
                'VentasNetas' => $VentasNetas512,
                'Cumplimiento' => $Cumplimiento512,
                'PromedioVenta' => $promPrecioKit512,
                'CantidadExtra' => $cantidadExtra512,
                'PromedioVentaExtras' => $promVentaExtras512,
                'CantidadMesesDescuento' => $cantidadMesesDescuento512,
                'CantidadRegalo' => $cantidadRegalo512,
                'VentaRegalo' => $ventaRegalo512,
                'sumPreciokit512' => $sumPreciokit512,
                '$sumExtras512' => $sumExtras512,
                '$promPrecioKit512' => $promPrecioKit512,
                '$promExtras512' => $promExtras512,
                '$promVentaExtras512' => $promVentaExtras512
            );
            
            $cantidadGestores512++;
        }
    }

    $totalPromVenta = number_format(round($totalPromVenta/$cantidadGestores, 2), 2, ',', '');
    $totalPromVentaExtras = number_format(round($totalPromVentaExtras/$cantidadGestores, 2), 2, ',', '');

    $arregloDatos['Totales'] = array(
        'totalfacturadas' => $totalfacturadas,
        'totalinstaldas' => $totalinstaldas,
        'totalagendadas' => $totalagendadas,
        'totalpendienteagenda' => $totalpendienteagenda,
        'totalincidencia' => $totalincidencia,
        'totalventasbrutas' => $totalventasbrutas,
        'totalobjetivo' => $totalobjetivo,
        'totalxmorxven' => $totalxmorxven,
        'totalventasnetas' => $totalventasnetas,
        'totalPromVentas' => $totalPromVenta,
        'totalDispExtras' => $totalDispExtras,
        'totalPromVentasExtras' => $totalPromVentaExtras,
        'totalRegalos' => $totalRegalos,
        'TotalDescuento' => $totalDescuento
    );
    
    $totalPromVenta511 = number_format(round($totalPromVenta511/$cantidadGestores511, 2), 2, ',', '');
    $totalPromVentaExtras511 = number_format(round($totalPromVentaExtras511/$cantidadGestores511, 2), 2, ',', '');
    
    $arregloDatos['511']['Totales511'] = array(
        'totalfacturadas' => $totalfacturadas511,
        'totalinstaldas' => $totalinstaldas511,
        'totalagendadas' => $totalagendadas511,
        'totalpendienteagenda' => $totalpendienteagenda511,
        'totalincidencia' => $totalincidencia511,
        'totalventasbrutas' => $totalventasbrutas511,
        'totalobjetivo' => $totalobjetivo511,
        'totalxmorxven' => $totalxmorxven511,
        'totalventasnetas' => $totalventasnetas511,
        'totalPromVentas' => $totalPromVenta511,
        'totalDispExtras' => $totalDispExtras511,
        'totalPromVentasExtras' => $totalPromVentaExtras511,
        'totalRegalos' => $totalRegalos511,
        'TotalDescuento' => $totalDescuento511
    );
    
    $totalPromVenta512 = number_format(round($totalPromVenta512/$cantidadGestores512, 2), 2, ',', '');
    $totalPromVentaExtras512 = number_format(round($totalPromVentaExtras512/$cantidadGestores512, 2), 2, ',', '');
    
    $arregloDatos['512']['Totales512'] = array(
        'totalfacturadas' => $totalfacturadas512,
        'totalinstaldas' => $totalinstaldas512,
        'totalagendadas' => $totalagendadas512,
        'totalpendienteagenda' => $totalpendienteagenda512,
        'totalincidencia' => $totalincidencia512,
        'totalventasbrutas' => $totalventasbrutas512,
        'totalobjetivo' => $totalobjetivo512,
        'totalxmorxven' => $totalxmorxven512,
        'totalventasnetas' => $totalventasnetas512,
        'totalPromVentas' => $totalPromVenta512,
        'totalDispExtras' => $totalDispExtras512,
        'totalPromVentasExtras' => $totalPromVentaExtras512,
        'totalRegalos' => $totalRegalos512,
        'TotalDescuento' => $totalDescuento512
    );
    
    $arregloDatos['Segmento'] = $arregloSegmento;
    $arregloDatos['Scoring'] = $arregloScoring;
    $arregloDatos['TipoKit'] = $arregloTipoKit;
}

    echo json_encode($arregloDatos);

function consultaGestores($fechadiahoy){
    global $con;
    /*
    $sql = "SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Gestor FROM yifi58ge_dbUSUARIO.tblusuario u
                INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea
                WHERE (a.IdArea='40') AND u.IdPerfil = 36 and u.Estado='Activo'";
    */
    $sql = "SELECT Detalle FROM tbtmpdashboardtv WHERE N590 ='".$fechadiahoy."'";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    if ($row_cnt > 0){
        while($usuarios = $resultado->fetch_assoc()){
            //$arreglousuarios = JSON_DECODE($usuarios['User590']);
            $arreglo[] = $usuarios;
            
            //$data = json_decode($arreglo[0]['User590']);
            
            $data = json_decode($arreglo[0]['Detalle']);
            
            foreach ($data as $fila){
                
                $matricula = $fila->matricula;
                
                $sqlGestor = "SELECT CC, Estado FROM yifi58ge_dbUSUARIO.tblusuario WHERE Matricula = '".$matricula."'";
                $resultadoGestor = $con->query($sqlGestor);
                
                while($ccGestor = $resultadoGestor->fetch_assoc()){
                    
                    $gestor = array(
                        'Matricula' => $fila->matricula,
                        'Gestor' => $fila->gestor,
                        'Objetivo' => $fila->objetivo,
                        'Xmor' => $fila->xmorxven,
                        'CC' => $ccGestor['CC'],
                        'Estado' => $ccGestor['Estado']
                    );
                    
                    $gestores[] = $gestor;
                    
                }
            }
        }
    } else {
        $gestores = '';
    }
    
    return $gestores;
}

function consultaFacturadaTV($fechadiahoy){
    global $con;
    
    $sql = "SELECT DISTINCT v.TCGestor,count(v.TCGestor) Total
            FROM tblventa v
            WHERE N590 = '".$fechadiahoy."' AND (v.EstadoVenta =  'Nodoc' OR v.EstadoVenta =  'DocEnvi' OR v.EstadoVenta =  'PorFacturar'  or v.EstadoVenta='Facturada' OR v.EstadoVenta =  'IncidenciaGestValija' OR v.EstadoVenta =  'incidenciaGestCorreo'  )
            AND v.CC IN ('511', '512')
            GROUP BY v.TCGestor";
    $resultado = $con->query($sql);
    while($gestor = $resultado->fetch_assoc()){
        $data[] = $gestor;
    }
    
    return $data;
}

function consultaInstaladaTV($fechadiahoy){
    global $con;
    
    $sql = "SELECT DISTINCT v.TCGestor,count(v.TCGestor) Total
            FROM tblventa v
            WHERE N590 = '".$fechadiahoy."' AND (v.EstadoVenta='Instalada') AND v.CC IN ('511', '512')
            GROUP BY v.TCGestor";
    $resultado = $con->query($sql);
    while($gestor = $resultado->fetch_assoc()){
        $data[] = $gestor;
    }
    
    return $data;
}

function consultaAgendadaTV($fechadiahoy){
    global $con;
    
    $sql = "SELECT DISTINCT v.TCGestor,count(v.TCGestor) Total
            FROM tblventa v
            WHERE N590 = '".$fechadiahoy."' AND (v.EstadoVenta = 'AgendadaTEC' OR v.EstadoVenta = 'AgendadaDEL' OR v.EstadoVenta = 'Postergada') AND v.CC IN ('511', '512')
            GROUP BY v.TCGestor";
    $resultado = $con->query($sql);
    while($gestor = $resultado->fetch_assoc()){
        $data[] = $gestor;
    }
    
    return $data;
}

function consultaPendienteAgendaTV($fechadiahoy){
    global $con;
    
    $sql = "SELECT DISTINCT v.TCGestor,count(v.TCGestor) Total
            FROM tblventa v
            WHERE N590 = '".$fechadiahoy."' AND (v.EstadoVenta = 'PendienteData' OR v.EstadoVenta = 'PendienteAgenda') AND v.CC IN ('511', '512')
            GROUP BY v.TCGestor";
    $resultado = $con->query($sql);
    while($gestor = $resultado->fetch_assoc()){
        $data[] = $gestor;
    }
    
    return $data;
}

function consultaIncidenciaTV($fechadiahoy){
    global $con;
    
    $sql = "SELECT DISTINCT v.TCGestor,count(v.TCGestor) Total
            FROM tblventa v
            WHERE N590 = '".$fechadiahoy."' AND (v.EstadoVenta =  'Incidencia') AND v.CC IN ('511', '512')
            GROUP BY v.TCGestor";
    $resultado = $con->query($sql);
    while($gestor = $resultado->fetch_assoc()){
        $data[] = $gestor;
    }

    return $data;
}

function consultaPromedioVenta($fechadiahoy){
    global $con;
    
    $sql = "SELECT DISTINCT v.TCGestor, sum(v.PrecioKit) Total
            FROM tblventa v 
            WHERE N590 = '".$fechadiahoy."' AND v.CC IN ('511', '512')
            AND v.EstadoVenta IN ('Instalada', 'NoDoc', 'DocEnvi', 'PorFacturar', 'IncidenciaGestValija', 'IncidenciaGestCorreo', 'Facturada', 'AgendadaTEC', 'AgendadaDEL', 'Postergada', 'PendienteData', 'PendienteAgenda', 'Incidencia')
            GROUP BY v.TCGestor";
    $resultado = $con->query($sql);
    while($gestor = $resultado->fetch_assoc()){
        $data[] = $gestor;
    }

    return $data;        
}

function consultaPromedioExtras($fechadiahoy){
    global $con;
    
    $sql = "SELECT DISTINCT v.TCGestor, sum(v.TotalExtra) Total
            FROM tblventa v 
            WHERE N590 = '".$fechadiahoy."' AND v.CC IN ('511', '512')
            AND v.EstadoVenta IN ('Instalada', 'NoDoc', 'DocEnvi', 'PorFacturar', 'IncidenciaGestValija', 'IncidenciaGestCorreo', 'Facturada', 'AgendadaTEC', 'AgendadaDEL', 'Postergada', 'PendienteData', 'PendienteAgenda', 'Incidencia')
            GROUP BY v.TCGestor";
    $resultado = $con->query($sql);
    while($gestor = $resultado->fetch_assoc()){
        $data[] = $gestor;
    }

    return $data;        
}

function consultaCantidadExtra($fechadiahoy){
    global $con;
    
    $sql = "SELECT DISTINCT v.TCGestor, SUM(CantidadExtras) Total
            FROM tblventa v 
            WHERE N590 = '".$fechadiahoy."' AND v.CC IN ('511', '512')
            AND v.EstadoVenta IN ('Instalada', 'NoDoc', 'DocEnvi', 'PorFacturar', 'IncidenciaGestValija', 'IncidenciaGestCorreo', 'Facturada', 'AgendadaTEC', 'AgendadaDEL', 'Postergada', 'PendienteData', 'PendienteAgenda', 'Incidencia')
            GROUP BY v.TCGestor";
    $resultado = $con->query($sql);
    while($gestor = $resultado->fetch_assoc()){
        $data[] = $gestor;
    }

    return $data;

}

function consultaCantidadRegalo($fechadiahoy){
    global $con;
    
    $sql = "SELECT DISTINCT v.TCGestor, COUNT(*) Total
            FROM tblventa v 
            WHERE N590 = '".$fechadiahoy."' AND v.CC IN ('511', '512')
            AND v.EstadoVenta IN ('Instalada', 'NoDoc', 'DocEnvi', 'PorFacturar', 'IncidenciaGestValija', 'IncidenciaGestCorreo', 'Facturada', 'AgendadaTEC', 'AgendadaDEL', 'Postergada', 'PendienteData', 'PendienteAgenda', 'Incidencia')
            AND ExtraAutorizado NOT IN ('Ninguno', '0', 'Seleccione')
            GROUP BY v.TCGestor";
    $resultado = $con->query($sql);
    while($gestor = $resultado->fetch_assoc()){
        $data[] = $gestor;
    }

    return $data;
    
}

function consultaCantidadDescuento3meses($fechadiahoy){
    global $con;
    
    $sql = "SELECT DISTINCT v.TCGestor, count(DescMeses) Total
            FROM tblventa v 
            WHERE N590 = '".$fechadiahoy."' AND v.CC IN ('511', '512')
            AND v.EstadoVenta IN ('Instalada', 'NoDoc', 'DocEnvi', 'PorFacturar', 'IncidenciaGestValija', 'IncidenciaGestCorreo', 'Facturada', 'AgendadaTEC', 'AgendadaDEL', 'Postergada', 'PendienteData', 'PendienteAgenda', 'Incidencia')
            AND v.DescMeses = 'SI'
            GROUP BY v.TCGestor";
    $resultado = $con->query($sql);
    while($gestor = $resultado->fetch_assoc()){
        $data[] = $gestor;
    }

    return $data;

}

function consultaDataSegmento($fechadiahoy){
    global $con;
    
    $sql = "SELECT CC, Segmento, COUNT(*) Total
            FROM tblventa v
            WHERE N590 = '".$fechadiahoy."' AND CC IN ('511', '512')
            AND v.EstadoVenta IN ('Instalada', 'NoDoc', 'DocEnvi', 'PorFacturar', 'IncidenciaGestValija', 'IncidenciaGestCorreo', 'Facturada', 'AgendadaTEC', 'AgendadaDEL', 'Postergada', 'PendienteData', 'PendienteAgenda', 'Incidencia')
            GROUP BY CC, Segmento";
    $resultado = $con->query($sql);
    while($gestor = $resultado->fetch_assoc()){
        $data[] = $gestor;
    }

    return $data;
}

function consultaDataTipoKit($fechadiahoy){
    global $con;
    
    $sql = "SELECT CC, TipoKIT, COUNT(*) Total
            FROM tblventa v
            WHERE N590 = '".$fechadiahoy."' AND CC IN ('511', '512')
            AND v.EstadoVenta IN ('Instalada', 'NoDoc', 'DocEnvi', 'PorFacturar', 'IncidenciaGestValija', 'IncidenciaGestCorreo', 'Facturada', 'AgendadaTEC', 'AgendadaDEL', 'Postergada', 'PendienteData', 'PendienteAgenda', 'Incidencia')
            GROUP BY CC, TipoKIT";
    $resultado = $con->query($sql);
    while($gestor = $resultado->fetch_assoc()){
        $data[] = $gestor;
    }

    return $data;
}

function consultaDataScoring($fechadiahoy){
    global $con;
    
    $sql = "SELECT CC, TCScoring, COUNT(*) Total
            FROM tblventa v
            WHERE N590 = '".$fechadiahoy."' AND CC IN ('511', '512')
            AND v.EstadoVenta IN ('Instalada', 'NoDoc', 'DocEnvi', 'PorFacturar', 'IncidenciaGestValija', 'IncidenciaGestCorreo', 'Facturada', 'AgendadaTEC', 'AgendadaDEL', 'Postergada', 'PendienteData', 'PendienteAgenda', 'Incidencia')
            GROUP BY CC, TCScoring";
    $resultado = $con->query($sql);
    while($gestor = $resultado->fetch_assoc()){
        $data[] = $gestor;
    }

    return $data;    
}

function cantidadTV($gestor, $arreglo){
    $cant = 0;
    for($i=0; $i<count($arreglo); $i++){
        if ($gestor == $arreglo[$i]['TCGestor']){
            //echo $arregloVisitasTotales[$i]['visitas'];
            $cant =  $arreglo[$i]['Total'];
            break;
        } 
    }
    return $cant;
    
}

