<?php
header("Content-Type: text/html;charset=utf-8");
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require '../config/db.php';
require '../config/conexion.php';
include '../helper/helper_validacion.php';

//DATOS DE AMPLIACION
$idprospectorp = sanitizaCampo($_POST['idprospectorp'],'sanitizeint|scapestring|htmlspecialchars|stringtonull',$con);
$tipoventa = sanitizaCampo($_POST['tipoventa'],'sanitizestring|scapestring|htmlspecialchars|stringtonull',$con);
$refhabilitada = sanitizaCampo($_POST['refhabilitada'],'sanitizestring|scapestring|htmlspecialchars|stringtonull',$con);
if($tipoventa=='RE' || $tipoventa=='RPMKT' || $tipoventa=='REGGCC'){
    $resultadoAmpliacion = actualizarVenta($idprospectorp);
}else{
    $resultadoAmpliacion = actualizarProspectoRP($idprospectorp);
    $resultadoexiste=consultaExisteVentaRP($idprospectorp);
    if ($resultadoexiste > 0) {
        $resultadoVentaRP = actualizarVentaRP($idprospectorp);
    }
}

if($resultadoAmpliacion>0){
    echo 1;
}else{
    echo 0;
}

function actualizarProspectoRP($idprospectorp){
    
    global $con;
    
    global $refhabilitada;

    try{
        $stmt = $con->prepare("UPDATE tblprospectorp SET referidoHabilitado=? WHERE IdProspectoRP = ?");
        $stmt->bind_param('si', $refhabilitada, $idprospectorp);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();    
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function actualizarVenta($idprospectorp){
    
    global $con;
    
    global $refhabilitada;

    try{
        $stmt = $con->prepare("UPDATE tblventa SET referidoHabilitado=? WHERE IdVenta = ?");
        $stmt->bind_param('si', $refhabilitada, $idprospectorp);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();    
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function actualizarVentaRP($idprospectorp){
    
    global $con;
    
    global $refhabilitada;

    try{
        $stmt = $con->prepare("UPDATE tblventa SET referidoHabilitado=? WHERE IdProspectoRP = ?");
        $stmt->bind_param('si', $refhabilitada, $idprospectorp);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();    
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function consultaExisteVentaRP($idprospectorp){
    global $con;

    try{
        $stmt = $con->prepare( "SELECT 1 FROM tblventa WHERE IdProspectoRP = ?");
        $stmt->bind_param('i', $idprospectorp);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($num);
        
        if($stmt->num_rows>0){
            $data=1;
        }else{
            $data=0;
        }
             
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
    return $data;
}


function stringtonull($val){
    
    if ($val == '' || empty($val)){
        $resultado = NULL;
    }
    else if(!isset($val)){
        $resultado = NULL;
    }
    else {
        $resultado = $val;
    }
    
    return $resultado;
}
