<?php 

function consultaDatosCorreo($idventa){
    global $con;
    
    try{
        $stmt = $con->prepare( "SELECT 
    v.Matricula MatriculaComercial, 
    v.Comercial, 
    v.CC Delegacion,
    v.CCOriginal DelegacionOriginal, 
    u.Manager MatriculaJefeVenta, 
    u.Correo CorreoComercial, 
    CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta, 
    m.Correo CorreoJefeVenta, 
    CONCAT(del.Nombres,' ',del.Apellidos) NombDelegado, 
    del.Correo CorreoDelegado,  
    v.EstadoVenta, 
    v.TipoVenta, 
    v.Segmento, 
    v.NProspecto, 
    v.N590, 
    v.TCGestor,
    CONCAT(tc.Nombres,' ',tc.Apellidos) NombTCGestor,
    tc.Correo CorreoTCGestor,
    c.IdCliente, 
    c.NombApellido as NombCliente
    FROM tblventa v
    INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario u ON v.IdUsuario = u.IdUsuario
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario m ON u.Manager = m.Matricula
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario del ON m.Manager = del.Matricula
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario ori ON v.GestorOrigen = ori.Matricula
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario tc ON v.TCGestor = tc.Matricula
    WHERE v.IdVenta=?");
        $stmt->bind_param('i', $idventa);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($MatriculaComercial,
        $Comercial,
        $Delegacion,
        $DelegacionOriginal,
        $MatriculaJefeVenta,
        $CorreoComercial,
        $NombJefeVenta,
        $CorreoJefeVenta,
        $NombDelegado,
        $CorreoDelegado,
        $EstadoVenta,
        $TipoVenta,
        $Segmento,
        $NProspecto,
        $N590,
        $TCGestor,
        $NombTCGestor,
        $CorreoTCGestor,
        $IdCliente,
        $NombCliente);
        $data = [];        
        while ($stmt->fetch()){
        $data[] = array_map("utf8_encode",
        ['MatriculaComercial'=>$MatriculaComercial,
            'Comercial'=>$Comercial,
            'Delegacion'=>$Delegacion,
            'DelegacionOriginal'=>$DelegacionOriginal,
            'MatriculaJefeVenta'=>$MatriculaJefeVenta,
            'CorreoComercial'=>$CorreoComercial,
            'NombJefeVenta'=>$NombJefeVenta,
            'CorreoJefeVenta'=>$CorreoJefeVenta,
            'NombDelegado'=>$NombDelegado,
            'CorreoDelegado'=>$CorreoDelegado,
            'EstadoVenta'=>$EstadoVenta,
            'TipoVenta'=>$TipoVenta,
            'Segmento'=>$Segmento,
            'NProspecto'=>$NProspecto,
            'N590'=>$N590,
            'TCGestor'=>$TCGestor,
            'NombTCGestor'=>$NombTCGestor,
            'CorreoTCGestor'=>$CorreoTCGestor,
            'IdCliente'=>$IdCliente,
            'NombCliente'=>$NombCliente
            ]);            
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
    return $data;
}

function consultaDatosCorreo_v2($idventa){
    global $con;
    
    try{
        $stmt = $con->prepare( "SELECT 
    v.Matricula MatriculaComercial, 
    v.Comercial, 
    v.CC Delegacion,
    v.CCOriginal DelegacionOriginal, 
    u.Manager MatriculaJefeVenta, 
    u.Correo CorreoComercial, 
    CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta, 
    m.Correo CorreoJefeVenta, 
    CONCAT(del.Nombres,' ',del.Apellidos) NombDelegado, 
    del.Correo CorreoDelegado,  
    v.EstadoVenta, 
    v.TipoVenta, 
    v.Segmento, 
    v.NProspecto,
    v.NContrato,    
    v.N590, 
    v.TCGestor,
    CONCAT(tc.Nombres,' ',tc.Apellidos) NombTCGestor,
    tc.Correo CorreoTCGestor,
    c.IdCliente, 
    c.NombApellido as NombCliente,
    att.IdAttec,
    DATE_FORMAT(att.FechaAuditoria, '%d/%m/%Y') FechaAuditoria,
    att.EstadoAttec,
    att.DatosSbn,
    att.DatosSbn_NoCoincide,
    DATE_FORMAT(att.F_CorreccionDatosSbn, '%d/%m/%Y') F_CorreccionDatosSbn,
    att.SegIncorrecto,
    DATE_FORMAT(att.F_CorreccionSegIncorrecto, '%d/%m/%Y') F_CorreccionSegIncorrecto,
    att.Seg_DebeDecir,
    att.Imagen,
    DATE_FORMAT(att.F_Imagen, '%d/%m/%Y') F_Imagen,
    att.Imagen_Motivo,
    att.IngresoProgramacion,
    DATE_FORMAT(att.F_CorreccionIngresoProgramacion, '%d/%m/%Y') F_CorreccionIngresoProgramacion,
    att.FallosCobertura,
    DATE_FORMAT(att.F_CorreccionFallosCobertura, '%d/%m/%Y') F_CorreccionFallosCobertura,
    att.MissingTest,
    DATE_FORMAT(att.F_CorreccionMissingTest, '%d/%m/%Y') F_CorreccionMissingTest,
    att.ZeroVision,
    DATE_FORMAT(att.F_CorreccionZeroVision, '%d/%m/%Y') F_CorreccionZeroVision,
    att.FalloSupervision,
    DATE_FORMAT(att.F_CorreccionFalloSupervision, '%d/%m/%Y') F_CorreccionFalloSupervision,
    att.FalloSupervision_Dispotivos,
    att.Tamper,
    DATE_FORMAT(att.F_CorreccionTamper, '%d/%m/%Y') F_CorreccionTamper,
    att.Tamper_Dispotivos,
    att.Comentario as ComentarioAttec,
    att.Zerovision_motivo
    FROM tblventa v
    INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario u ON v.IdUsuario = u.IdUsuario
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario m ON u.Manager = m.Matricula
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario del ON m.Manager = del.Matricula
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario ori ON v.GestorOrigen = ori.Matricula
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario tc ON v.TCGestor = tc.Matricula
    LEFT JOIN yifi58ge_dbVENTAS.tblattec att on att.IdVenta=v.IdVenta    
    WHERE v.IdVenta=?");
        $stmt->bind_param('i', $idventa);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($MatriculaComercial,
$Comercial,
$Delegacion,
$DelegacionOriginal,
$MatriculaJefeVenta,
$CorreoComercial,
$NombJefeVenta,
$CorreoJefeVenta,
$NombDelegado,
$CorreoDelegado,
$EstadoVenta,
$TipoVenta,
$Segmento,
$NProspecto,
$NContrato,
$N590,
$TCGestor,
$NombTCGestor,
$CorreoTCGestor,
$IdCliente,
$NombCliente,
$IdAttec,
$FechaAuditoria,
$EstadoAttec,
$DatosSbn,
$DatosSbn_NoCoincide,
$F_CorreccionDatosSbn,
$SegIncorrecto,
$F_CorreccionSegIncorrecto,
$Seg_DebeDecir,
$Imagen,
$F_Imagen,
$Imagen_Motivo,
$IngresoProgramacion,
$F_CorreccionIngresoProgramacion,
$FallosCobertura,
$F_CorreccionFallosCobertura,
$MissingTest,
$F_CorreccionMissingTest,
$ZeroVision,
$F_CorreccionZeroVision,
$FalloSupervision,
$F_CorreccionFalloSupervision,
$FalloSupervision_Dispotivos,
$Tamper,
$F_CorreccionTamper,
$Tamper_Dispotivos,
$ComentarioAttec,
$Zerovision_motivo);
        $data = [];        
        while ($stmt->fetch()){
        $data[] = array_map("utf8_encode",
        ['MatriculaComercial'=>$MatriculaComercial,
            'Comercial'=>$Comercial,
            'Delegacion'=>$Delegacion,
            'DelegacionOriginal'=>$DelegacionOriginal,
            'MatriculaJefeVenta'=>$MatriculaJefeVenta,
            'CorreoComercial'=>$CorreoComercial,
            'NombJefeVenta'=>$NombJefeVenta,
            'CorreoJefeVenta'=>$CorreoJefeVenta,
            'NombDelegado'=>$NombDelegado,
            'CorreoDelegado'=>$CorreoDelegado,
            'EstadoVenta'=>$EstadoVenta,
            'TipoVenta'=>$TipoVenta,
            'Segmento'=>$Segmento,
            'NProspecto'=>$NProspecto,
            'NContrato'=>$NContrato,
            'N590'=>$N590,
            'TCGestor'=>$TCGestor,
            'NombTCGestor'=>$NombTCGestor,
            'CorreoTCGestor'=>$CorreoTCGestor,
            'IdCliente'=>$IdCliente,
            'NombCliente'=>$NombCliente,
            'IdAttec'=>$IdAttec,
            'FechaAuditoria'=>$FechaAuditoria,
            'EstadoAttec'=>$EstadoAttec,
            'DatosSbn'=>$DatosSbn,
            'DatosSbn_NoCoincide'=>$DatosSbn_NoCoincide,
            'F_CorreccionDatosSbn'=>$F_CorreccionDatosSbn,
            'SegIncorrecto'=>$SegIncorrecto,
            'F_CorreccionSegIncorrecto'=>$F_CorreccionSegIncorrecto,
            'Seg_DebeDecir'=>$Seg_DebeDecir,
            'Imagen'=>$Imagen,
            'F_Imagen'=>$F_Imagen,
            'Imagen_Motivo'=>$Imagen_Motivo,
            'IngresoProgramacion'=>$IngresoProgramacion,
            'F_CorreccionIngresoProgramacion'=>$F_CorreccionIngresoProgramacion,
            'FallosCobertura'=>$FallosCobertura,
            'F_CorreccionFallosCobertura'=>$F_CorreccionFallosCobertura,
            'MissingTest'=>$MissingTest,
            'F_CorreccionMissingTest'=>$F_CorreccionMissingTest,
            'ZeroVision'=>$ZeroVision,
            'F_CorreccionZeroVision'=>$F_CorreccionZeroVision,
            'FalloSupervision'=>$FalloSupervision,
            'F_CorreccionFalloSupervision'=>$F_CorreccionFalloSupervision,
            'FalloSupervision_Dispotivos'=>$FalloSupervision_Dispotivos,
            'Tamper'=>$Tamper,
            'F_CorreccionTamper'=>$F_CorreccionTamper,
            'Tamper_Dispotivos'=>$Tamper_Dispotivos,
            'ComentarioAttec'=>$ComentarioAttec,
            'Zerovision_motivo'=>$Zerovision_motivo
            ]);            
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
    return $data;
}


function enviarNotifiacionCorreo_test($idventa,$comentarioagenda,$dc){
    global $con;
    $datosCorreos=consultaDatosCorreo_v2($idventa);
    
    $MatriculaComer=$datosCorreos[0]['MatriculaComercial'];
    $CorreoComercial =$datosCorreos[0]['CorreoComercial'];
    $CorreoJefeVenta =$datosCorreos[0]['CorreoJefeVenta'];
    $CorreoDelegado=$datosCorreos[0]['CorreoDelegado'];
    $Cliente= $datosCorreos[0]['NombCliente'];
    $TCGestor =$datosCorreos[0]['TCGestor'];
    $CorreoTCGestor = $datosCorreos[0]['CorreoTCGestor'];
    
    

    $tituloCorreo = "NOTIFICACION AUDITORIA - ".$idventa;
    
            $mensajeCorreo = '
            <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                <html xmlns="http://www.w3.org/1999/xhtml">
                    <head>
                        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                        <title>A Simple Responsive HTML Email</title>
                        <style type="text/css">
                            body {
                                margin: 0;
                                padding: 0;
                                min-width: 100%!important;
                            }
                            
                            img {
                                height: auto;
                            }
                            
                            .content {
                                width: 100%;
                                max-width: 600px;
                            }
                            
                            .header {
                                padding: 5px 20px 5px 20px;
                            }
                            
                            .innerpadding {
                                padding: 20px 30px 0px 30px;
                            }
                            
                            .borderbottom {
                                border-bottom: 1px solid #f2eeed;
                            }
                            
                            .subhead {
                                font-size: 15px;
                                color: #ffffff;
                                font-family: sans-serif;
                                letter-spacing: 10px;
                            }
                            
                            .h1 {
                                font-family: sans-serif;
                                color: #ffffff;
                                font-size: 23px;
                                line-height: 38px;
                                font-weight: bold;
                            }
                            
                            .h2 {
                                color: #000000;
                                font-family: sans-serif;
                                padding: 0 0 15px 0;
                                font-size: 24px;
                                line-height: 28px;
                                font-weight: bold;
                            }
                            
                            .h3 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 14px;
                                line-height: 22px;
                                font-weight: bold;
                            }
                            
                            .h4 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 16px;
                                line-height: 30px;
                                font-weight: bold;
                            }
                            
                            .bodycopy {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 14px;
                                line-height: 22px;
                            }
                            
                            .button {
                                text-align: center;
                                font-size: 18px;
                                font-family: sans-serif;
                                font-weight: bold;
                                padding: 0 30px 0 30px;
                            }
                            
                            .button a {
                                color: #ffffff;
                                text-decoration: none;
                            }
                            
                            .footer {
                                padding: 20px 30px 15px 30px;
                            }
                            
                            .footercopy {
                                font-family: sans-serif;
                                font-size: 14px;
                                color: #ffffff;
                            }
                            
                            .footercopy a {
                                color: #ffffff;
                                text-decoration: underline;
                            }
                            
                            .coldiv115 {
                                width: 115px;
                            }
                            
                            ;
                            .coldiv380 {
                                width: 380px;
                            }
                            
                            ;
                            @media only screen and (max-width: 550px),
                            screen and (max-device-width: 550px) {
                                body[yahoo] .hide {
                                    display: none!important;
                                }
                                body[yahoo] .buttonwrapper {
                                    background-color: transparent!important;
                                }
                                body[yahoo] .button {
                                    padding: 0px!important;
                                }
                                body[yahoo] .button a {
                                    background-color: #e05443;
                                    padding: 15px 15px 13px!important;
                                }
                                body[yahoo] .unsubscribe {
                                    display: block;
                                    margin-top: 20px;
                                    padding: 10px 50px;
                                    background: #2f3942;
                                    border-radius: 5px;
                                    text-decoration: none!important;
                                    font-weight: bold;
                                }
                            }
                        </style>
                    </head>

                    <body yahoo bgcolor="#f2f2f2">
                        <table width="100%" bgcolor="#f2f2f2" border="0" cellpadding="0" cellspacing="0">
                            <tr>
                                <td>
                                    <table bgcolor="#ffffff" class="content" align="center" cellpadding="0" cellspacing="0" border="0">
                                        <tr>
                                            <td bgcolor="#ffffff" class="header">
                                                <table width="70" align="center" border="0" cellpadding="0" cellspacing="0">
                                                    <tr>
                                                        <td height="70" style="padding: 0 20px 20px 0;">
                                                            <img class="fix" src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png" border="0" alt="" />
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                    
                                        <tr>
                                            <td bgcolor="#dc0000" class="header">
                                                <table class="col425" align="center" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 425px;">
                                                    <tr>
                                                        <td height="70">
                                                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                                <tr>
                                                                    <h1 class="h1" align="center" style="padding: 0 0 0 0;">VERISMART</h1>
                                                                    <h1 class="h1" align="center" style="padding: 0 0 0 0;">NOTIFICACION ATTEC</h1>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                    
                                        <tr>
                                            <td class="innerpadding">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td class="h2">
                                                            Estimado usuario,
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="bodycopy">
                                                            <p>Nos complace informarle que se ha enviado una notificación por Auditoria</p>
                                                            <p>Cliente: '.$Cliente.'</p>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="innerpadding">
                                                <p>Se realizo: '.$comentarioagenda.'</p>
                                              
                                                <p>Por favor, para cualquier consulta, contacta con ATTEC al 015147304.</p>
                                                <p>Muchas gracias y un saludo.</p>
                                                <p>IT Perú</p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="footer" bgcolor="#44525f">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td align="center" class="footercopy">
                                                            2021 &reg; Verisure Perú SAC<br/> Av. Primavera 1050 – Oficina 501<br/> Santiago de Surco – Urbanización Chacarilla del Estanque<br/> Lima – Perú
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </body>
            
            </html>
        ';

        //Destinatario
        //$paraCorreo = $correoDelegado.", joseenrique.nanquen@verisure.pe, janpierre.vargas@verisure.pe";
        
        if($dc==512 || $dc==511){
            $paraCorreo = "agendacomercial@verisure.pe,alessandra.reupo@verisure.pe,alejandro.delsante@verisure.pe,sonia.chavez@verisure.pe,jocelyn.delgado@verisure.pe"."\r\n";
        }else{
             $paraCorreo = $CorreoComercial.", ".$CorreoJefeVenta."\r\n";
        }
        $correoadministrativo1="marco.llontop@verisure.pe";
        $correoadministrativo2="eldaviviana.mechato@verisure.pe";
        $correoadministrativo3="joseenrique.nanquen@verisure.pe";
        $correoadministrativo4="claudia.santoya@verisure.pe";
        $correoadministrativo5="victor.tello@verisure.pe";
        $correoadministrativo6="jocelyn.delgado@verisure.pe";
        $correoadministrativo7="luisangel.cardenas@verisure.pe";
        
        //para el envío en formato HTML 
        $headersCorreo = "MIME-Version: 1.0\r\n";
        $headersCorreo .= "Content-type: text/html; charset=utf-8\r\n";
        
        //dirección del remitente 
            $headersCorreo .= "From: Sistema de Ventas Verismart - Verisure Perú <soporteit@verismart.com.pe>\r\n";
        
        //dirección de respuesta, si queremos que sea distinta que la del remitente 
            $headersCorreo .= "Reply-To: attec@verisure.pe\r\n";
        
        //ruta del mensaje desde origen a destino 
            $headersCorreo .= "Return-path: soporteit@verismart.com.pe\r\n";
        
        //direcciones que recibián copia
            $headersCorreo .= "cc: ".$correoadministrativo1.", ".$correoadministrativo2.", ".$correoadministrativo3.", ".$correoadministrativo4.", ".$correoadministrativo5.",".$correoadministrativo7."\r\n"; 
        
        //direcciones que recibirán copia oculta 
        //$headersCorreo .= "Bcc: ".$correo_prueba."\r\n"; 
        
        mail($paraCorreo, $tituloCorreo, $mensajeCorreo, $headersCorreo);
}

function enviarNotifiacionCorreo_test_v2($idventa,$comentarioagenda,$dc){
    global $con;
    $datosCorreos=consultaDatosCorreo_v2($idventa);
    
    $MatriculaComer=$datosCorreos[0]['MatriculaComercial'];
    $CorreoComercial =$datosCorreos[0]['CorreoComercial'];
    $CorreoJefeVenta =$datosCorreos[0]['CorreoJefeVenta'];
    $CorreoDelegado=$datosCorreos[0]['CorreoDelegado'];
    $cliente= $datosCorreos[0]['NombCliente'];
    $TCGestor =$datosCorreos[0]['TCGestor'];
    $CorreoTCGestor = $datosCorreos[0]['CorreoTCGestor'];
    $estadoventa= $datosCorreos[0]['EstadoVenta'];
    $ncontrato = $datosCorreos[0]['NContrato'];
    
        $idattec = $datosCorreos[0]['IdAttec'];
        $FechaAuditoria = $datosCorreos[0]['FechaAuditoria'];
        $EstadoAttec = $datosCorreos[0]['EstadoAttec'];
        $DatosSbn = $datosCorreos[0]['DatosSbn'];
        $DatosSbn_NoCoincide = $datosCorreos[0]['DatosSbn_NoCoincide'];
        $F_CorreccionDatosSbn = $datosCorreos[0]['F_CorreccionDatosSbn'];
        $SegIncorrecto = $datosCorreos[0]['SegIncorrecto'];
        $F_CorreccionSegIncorrecto = $datosCorreos[0]['F_CorreccionSegIncorrecto'];
        $Seg_DebeDecir = $datosCorreos[0]['Seg_DebeDecir'];
        $Imagen = $datosCorreos[0]['Imagen'];
        $F_Imagen = $datosCorreos[0]['F_Imagen'];
        $Imagen_Motivo = $datosCorreos[0]['Imagen_Motivo'];
        $IngresoProgramacion = $datosCorreos[0]['IngresoProgramacion'];
        $F_CorreccionIngresoProgramacion = $datosCorreos[0]['F_CorreccionIngresoProgramacion'];
        $FallosCobertura = $datosCorreos[0]['FallosCobertura'];
        $F_CorreccionFallosCobertura = $datosCorreos[0]['F_CorreccionFallosCobertura'];
        $MissingTest = $datosCorreos[0]['MissingTest'];
        $F_CorreccionMissingTest = $datosCorreos[0]['F_CorreccionMissingTest'];
        $ZeroVision = $datosCorreos[0]['ZeroVision'];
        $F_CorreccionZeroVision = $datosCorreos[0]['F_CorreccionZeroVision'];
        $FalloSupervision = $datosCorreos[0]['FalloSupervision'];
        $F_CorreccionFalloSupervision = $datosCorreos[0]['F_CorreccionFalloSupervision'];
        $FalloSupervision_Dispotivos = $datosCorreos[0]['FalloSupervision_Dispotivos'];
        $Tamper = $datosCorreos[0]['Tamper'];
        $F_CorreccionTamper = $datosCorreos[0]['F_CorreccionTamper'];
        $Tamper_Dispotivos = $datosCorreos[0]['Tamper_Dispotivos'];
        $ComentarioAttec= $datosCorreos[0]['ComentarioAttec'];
        $Zerovision_motivo= $datosCorreos[0]['Zerovision_motivo'];
        
        $incidencia="";

        if($DatosSbn=="SI"){
            $incidencia.="- Direferencia entre datos de IBS y Verismart, no coincide:".$DatosSbn_NoCoincide."<br>";
        }
        if($SegIncorrecto=="SI"){
            $incidencia.="- Error en Segmento, debe decir:".$Seg_DebeDecir."<br>";
        }
        if($Imagen=="SI"){
            $incidencia.="- Error en Imagen, motivo:".$Imagen_Motivo."<br>";
        }
        if($IngresoProgramacion=="SI"){
            $incidencia.="- Ingreso en programacion despues de validar";
        }
        if($FallosCobertura=="SI"){
            $incidencia.="- Fallo de Comunicacion (Cobertura)";
        }
        if($MissingTest=="SI"){
            $incidencia.="- Missing TEST";
        }
        if($ZeroVision=="SI"){
            $incidencia.="- Error testeo ZERO VISION, motivo:".$Zerovision_motivo."<br>";
        }
        if($FalloSupervision=="SI"){
            $incidencia.="- Fallo de Supervision:";
                if(!empty($FalloSupervision_Dispotivos) || !is_null($FalloSupervision_Dispotivos)){
                    $FalloSupervision_Dispotivos = json_decode($FalloSupervision_Dispotivos, true);
                    foreach ($FalloSupervision_Dispotivos as $index=>$Dispotivo){
                        if($index != count($Tamper_Dispotivos) - 1) {
                            // Este código se ejecutará para todos menos el último
                            $incidencia.=$Dispotivo["Item"].'('.$Dispotivo["cantidadProductos"].'),';
                         }else{
                            $incidencia.=$Dispotivo["Item"].'('.$Dispotivo["cantidadProductos"].')</br>';    
                         }
                        
                    }
                }
        } 
        if($Tamper=="SI"){
            $incidencia.="- Manipulacion dispositivos posterior a la validacion:";
                if(!empty($Tamper_Dispotivos) || !is_null($Tamper_Dispotivos)){
                    $Tamper_Dispotivos = json_decode($Tamper_Dispotivos, true);
                    //echo $Tamper_Dis[1]['Item'];
                    foreach ($Tamper_Dispotivos as $index=>$Dispotivo){
                        if($index != count($Tamper_Dispotivos) - 1) {
                            // Este código se ejecutará para todos menos el último
                            $incidencia.=$Dispotivo["Item"].'('.$Dispotivo["cantidadProductos"].'),';
                         }else{
                            $incidencia.=$Dispotivo["Item"].'('.$Dispotivo["cantidadProductos"].')</br>';    
                         }                   
                        
                    }
                }
            
            
        }
        
        
        $solucion="";
        if($DatosSbn=="SI" || $SegIncorrecto=="SI"){
        
        $solucion.="Corregir datos en ficha de Verismart o IBS con ATTEC";
        }
        if($DatosSbn=="SI" || $SegIncorrecto=="SI"){
            //SOLUCION
            if($FallosCobertura=="SI" || $FalloSupervision=="SI" || $MissingTest=="SI" || $Imagen=="SI" || $Tamper=="SI" || $IngresoProgramacion=="SI"){
                $solucion.=",";
            }else{
                $solucion.="";
            }
        }
        //SOLUCION
        if($FallosCobertura=="SI" || $FalloSupervision=="SI" || $MissingTest=="SI" || $ZeroVision=="SI"){
            $solucion.=" Ir a la instalación y llamar a ATTEC para abrir MTO, revisar las observaciones y volver a pasar el validador, antes de salir de la instalacion verificar con ATTEC para confirmar la solucion de incidencia y cambio de estado de la venta en Verismart";
            //$solucion.=" IR A LA INSTALACION + LLAMAR A ATTEC Y CREAR MTO + FIJAR EL PANEL A LA PARED + CORREGIR INCIDENCIA + PASAR VALIDADO DE SEÑALES E IMAGEN + LLAMAR A ATTEC PARA CERRAR MTO";
        }else if($Imagen=="SI" || $Tamper=="SI" || $IngresoProgramacion=="SI" || $ZeroVision=="SI"){
            $solucion.=" Ir a la instalación y llamar a ATTEC para abrir MTO, revisar las observaciones y volver a pasar el validador, antes de salir de la instalacion verificar con ATTEC para confirmar la solucion de incidencia y cambio de estado de la venta en Verismart";
            //$solucion.=" IR A LA INSTALACION Y LLAMAR A ATTEC (01 514 73 04) PARA ABRIR MTO, REVISAR LAS OBSERVACIONES Y VOLVER A PASAR EL VALIDADOR. ANTES DE SALIR DE LA INSTALACION VERIFICAR CON ATTEC(01 514 73 04) PARA CONFIRMAR LA SUBSANACION Y CAMBIO DE ESTADO DE LA VENTA EN VERISMART";
        }else{
            $solucion.="";
        } 
    
    
         if(!empty($ncontrato)){
             if($estadoventa=="IncidenciaAuditoria"){
                $tituloCorreo = "NOTIFICACION AUDITORIA - ".$ncontrato." CON INCIDENCIA";  
             }else{
                $tituloCorreo = "NOTIFICACION AUDITORIA - ".$ncontrato;   
             }
            
         }else{
             $tituloCorreo = "NOTIFICACION AUDITORIA";
         }
    
            $mensajeCorreo = '
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                <html xmlns="http://www.w3.org/1999/xhtml">
                    <head>
                        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                        <title>A Simple Responsive HTML Email</title>
                        <style type="text/css">
                            body {
                                margin: 0;
                                padding: 0;
                                min-width: 100%!important;
                                font-family: sans-serif;
                                font-size: 14px;
                            }
                            
                            img {
                                height: auto;
                            }
                            
                            .content {
                                width: 100%;
                                max-width: 600px;
                            }
                            
                            .header {
                                padding: 5px 20px 5px 20px;
                            }
                            
                            .innerpadding {
                                padding: 20px 30px 0px 30px;
                            }
                            
                            .borderbottom {
                                border-bottom: 1px solid #f2eeed;
                            }
                            
                            .subhead {
                                font-size: 15px;
                                color: #ffffff;
                                font-family: sans-serif;
                                letter-spacing: 10px;
                            }
                            
                            .h1 {
                                font-family: sans-serif;
                                color: #ffffff;
                                font-size: 23px;
                                line-height: 38px;
                                font-weight: bold;
                            }
                            
                            .h2 {
                                color: #000000;
                                font-family: sans-serif;
                                padding: 0 0 15px 0;
                                font-size: 24px;
                                line-height: 28px;
                                font-weight: bold;
                            }
                            
                            .h3 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 14px;
                                line-height: 22px;
                                font-weight: bold;
                            }
                            
                            .h4 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 16px;
                                line-height: 30px;
                                font-weight: bold;
                            }
                            
                            .bodycopy {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 12px;
                                line-height: 22px;
                            }
                            
                            .button {
                                text-align: center;
                                font-size: 18px;
                                font-family: sans-serif;
                                font-weight: bold;
                                padding: 0 30px 0 30px;
                            }
                            
                            .button a {
                                color: #ffffff;
                                text-decoration: none;
                            }
                            
                            .footer {
                                padding: 20px 30px 15px 30px;
                            }
                            
                            .footercopy {
                                font-family: sans-serif;
                                font-size: 14px;
                                color: #ffffff;
                            }
                            
                            .footercopy a {
                                color: #ffffff;
                                text-decoration: underline;
                            }
                            
                            .coldiv115 {
                                width: 115px;
                            }
                            
                            .coldiv380 {
                                width: 380px;
                            }
                            
                            @media only screen and (max-width: 550px),
                            screen and (max-device-width: 550px) {
                                body[yahoo] .hide {
                                    display: none!important;
                                }
                                body[yahoo] .buttonwrapper {
                                    background-color: transparent!important;
                                }
                                body[yahoo] .button {
                                    padding: 0px!important;
                                }
                                body[yahoo] .button a {
                                    background-color: #e05443;
                                    padding: 15px 15px 13px!important;
                                }
                                body[yahoo] .unsubscribe {
                                    display: block;
                                    margin-top: 20px;
                                    padding: 10px 50px;
                                    background: #2f3942;
                                    border-radius: 5px;
                                    text-decoration: none!important;
                                    font-weight: bold;
                                }
                            }
                        </style>
                    </head>

                    <body yahoo bgcolor="#f2f2f2">
                        <table width="100%" bgcolor="#f2f2f2" border="0" cellpadding="0" cellspacing="0">
                            <tr>
                                <td>
                                    <table bgcolor="#ffffff" class="content" align="center" cellpadding="0" cellspacing="0" border="0">
                                        <tr>
                                            <td bgcolor="#ffffff" class="header">
                                                <table width="70" align="center" border="0" cellpadding="0" cellspacing="0">
                                                    <tr>
                                                        <td height="70" style="padding: 0 20px 20px 0;">
                                                            <img class="fix" src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png" border="0" alt="" />
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                    
                                        <tr>
                                            <td bgcolor="#dc0000" class="header">
                                                <table class="col425" align="center" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 425px;">
                                                    <tr>
                                                        <td height="70">
                                                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                                <tr>
                                                                    <h1 class="h1" align="center" style="padding: 0 0 0 0;">NOTIFICACION DE ATTEC</h1>';                
            if($estadoventa=="IncidenciaAuditoria"){
                 $mensajeCorreo.='<h1 class="h1" align="center" style="padding: 0 0 0 0;">VALIDACION PARALIZADA</h1>';
                }
                 $mensajeCorreo.='</tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>';
                 $mensajeCorreo.='     
                                        <tr>
                                            <td class="innerpadding">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td class="h2">
                                                            Estimado usuario,
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>';
                 
                                                      if($estadoventa=="IncidenciaAuditoria"){
                                                          
                                                             $mensajeCorreo.='<p>Se observan las siguientes incidencia de instalación tras la revision del cliente:</p>
                                                            <p>'.$ncontrato.' '.$cliente.'</p>';
                                                      }else{
                                                           $mensajeCorreo.=' 
                                                            <p>Se observa siguiente comentario tras la revision del cliente:</p>
                                                            <p>'.$ncontrato.' '.$cliente.'</p>';
                                                        }
                                                    $mensajeCorreo.='    
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>';
                                        
                                      if($estadoventa=="IncidenciaAuditoria"){
                                        $mensajeCorreo.='<tr>
                                            <td class="innerpadding">
                                                <p><strong>Indiencia:</strong></p>
                                                <p>'.$incidencia.'</p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="innerpadding">
                                                <p><strong>Solucion:</strong></p>
                                                <p>'.$solucion.'</p>
                                            </td>
                                        </tr>';
                                       }else{
                                        $mensajeCorreo.='<tr>
                                            <td class="innerpadding">
                                                <p><strong>Comentario:</strong></p>
                                                <p>'.$comentarioagenda.'</p>
                                            </td>
                                        </tr>';              
                                       }
                                        $mensajeCorreo.='<tr>
                                            <td class="innerpadding">
                                                <p>Por favor, para cualquier consulta llamar al telefono de ATTEC (01 5147304), <strong>NO RESPONDER A ESTE CORREO</strong></p>
                                                <p>Muchas gracias y un saludo.</p>
                                                <p>IT Perú</p>
                                            </td>
                                        </tr>                                           
                                        <tr>
                                            <td class="footer" bgcolor="#44525f">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td align="center" class="footercopy">
                                                            2021 &reg; Verisure Perú SAC<br/> Av. Primavera 1050 – Oficina 501<br/> Santiago de Surco – Urbanización Chacarilla del Estanque<br/> Lima – Perú
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </body>
            
            </html>
        ';

        //Destinatario
        //$paraCorreo = $correoDelegado.", joseenrique.nanquen@verisure.pe, janpierre.vargas@verisure.pe";
        
        if($dc==512 || $dc==511){
            $paraCorreo = "agendacomercial@verisure.pe,alejandro.delsante@verisure.pe,sonia.chavez@verisure.pe,jocelyn.delgado@verisure.pe"."\r\n";
        }else{
             $paraCorreo = $CorreoComercial.", ".$CorreoJefeVenta."\r\n";
        }
        $correoadministrativo1="marco.llontop@verisure.pe";
        $correoadministrativo2="eldaviviana.mechato@verisure.pe";
        $correoadministrativo3="joseenrique.nanquen@verisure.pe";
        $correoadministrativo4="claudia.santoya@verisure.pe";
        $correoadministrativo5="victor.tello@verisure.pe";
        $correoadministrativo7="luisangel.cardenas@verisure.pe";

        $correoadministrativo8="diego.mancilla@verisure.pe";
        $correoadministrativo9="kenny.rejas@verisure.pe";
        
        //para el envío en formato HTML 
        $headersCorreo = "MIME-Version: 1.0\r\n";
        $headersCorreo .= "Content-type: text/html; charset=utf-8\r\n";
        
        //dirección del remitente 
            $headersCorreo .= "From: Sistema de Ventas Verismart - Verisure Perú <soporteit@verismart.com.pe>\r\n";
        
        //dirección de respuesta, si queremos que sea distinta que la del remitente 
            $headersCorreo .= "Reply-To: attec@verisure.pe\r\n";
        
        //ruta del mensaje desde origen a destino 
            $headersCorreo .= "Return-path: soporteit@verismart.com.pe\r\n";
        
        //direcciones que recibián copia

        if($dc==512 || $dc==511){
            $headersCorreo .= "cc: ".$correoadministrativo1.", ".$correoadministrativo2.", ".$correoadministrativo3.", ".$correoadministrativo4.", ".$correoadministrativo5.", ".$correoadministrativo7.", ".$correoadministrativo8.", ".$correoadministrativo9."\r\n";
        }else{
            $headersCorreo .= "cc: ".$correoadministrativo1.", ".$correoadministrativo2.", ".$correoadministrativo3.", ".$correoadministrativo4.", ".$correoadministrativo5.", ".$correoadministrativo7."\r\n"; 
            
        }        
        
            
        
        //direcciones que recibirán copia oculta 
        //$headersCorreo .= "Bcc: ".$correo_prueba."\r\n"; 
        
        mail($paraCorreo, $tituloCorreo, $mensajeCorreo, $headersCorreo);
}

function enviarNotifiacionCorreo_Telecierre($idventa,$comentarioagenda,$dc){
    global $con;
    $datosCorreos=consultaDatosCorreo($idventa);
    
    $MatriculaComer=$datosCorreos[0]['MatriculaComercial'];
    $Delegacion=$datosCorreos[0]['Delegacion'];
    $DelegacionOriginal=$datosCorreos[0]['DelegacionOriginal'];
    $CorreoComercial =$datosCorreos[0]['CorreoComercial'];
    $CorreoJefeVenta =$datosCorreos[0]['CorreoJefeVenta'];
    $CorreoDelegado=$datosCorreos[0]['CorreoDelegado'];
    $Cliente= $datosCorreos[0]['NombCliente'];
    $TCGestor =$datosCorreos[0]['TCGestor'];
    $NProspecto=$datosCorreos[0]['NProspecto'];
    $CorreoTCGestor = $datosCorreos[0]['CorreoTCGestor'];
    $EstadoVenta=$datosCorreos[0]['EstadoVenta'];
    
    /*
    $sql = "SELECT 
    v.Matricula MatriculaComercial, 
    v.Comercial, 
    v.CC Delegacion, 
    v.CCOriginal DelegacionOriginal, 
    u.Manager MatriculaJefeVenta, 
    u.Correo CorreoComercial, 
    CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta, 
    m.Correo CorreoJefeVenta, 
    CONCAT(del.Nombres,' ',del.Apellidos) NombDelegado, 
    del.Correo CorreoDelegado,  
    v.EstadoVenta, 
    v.TipoVenta, 
    v.Segmento, 
    v.NProspecto, 
    v.N590, 
    v.TCGestor,
    CONCAT(tc.Nombres,' ',tc.Apellidos) NombTCGestor,
    tc.Correo CorreoTCGestor,
    c.IdCliente, 
    c.NombApellido as NombCliente
    FROM tblventa v
    INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario u ON v.IdUsuario = u.IdUsuario
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario m ON u.Manager = m.Matricula
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario del ON m.Manager = del.Matricula
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario ori ON v.GestorOrigen = ori.Matricula
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario tc ON v.TCGestor = tc.Matricula
    
    WHERE v.IdVenta='.$idventa.'";
    
        $resultado = mysqli_query($con, $sql);
        
        while($data = $resultado->fetch_assoc()){
            $MatriculaComer=$data['MatriculaComercial'];
            $Delegacion=$data['Delegacion'];
            $DelegacionOriginal=$data['DelegacionOriginal'];
            $CorreoComercial = $data['CorreoComercial'];
            $CorreoJefeVenta = $data['CorreoJefeVenta'];
            $CorreoDelegado=$data['CorreoDelegado'];
            $Cliente=$data['NombCliente'];
            $TCGestor = $data['TCGestor'];
            $NProspecto=$data['NProspecto'];
            $CorreoTCGestor = $data['CorreoTCGestor'];
            $EstadoVenta=$data['EstadoVenta'];
        }
    
*/

    $tituloCorreo = "NOTIFICACION TELECIERRE - PROSPECTO ".$NProspecto;
    
            $mensajeCorreo = '
            <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                <html xmlns="http://www.w3.org/1999/xhtml">
                    <head>
                        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                        <title>A Simple Responsive HTML Email</title>
                        <style type="text/css">
                            body {
                                margin: 0;
                                padding: 0;
                                min-width: 100%!important;
                            }
                            
                            img {
                                height: auto;
                            }
                            
                            .content {
                                width: 100%;
                                max-width: 600px;
                            }
                            
                            .header {
                                padding: 5px 20px 5px 20px;
                            }
                            
                            .innerpadding {
                                padding: 20px 30px 0px 30px;
                            }
                            
                            .borderbottom {
                                border-bottom: 1px solid #f2eeed;
                            }
                            
                            .subhead {
                                font-size: 15px;
                                color: #ffffff;
                                font-family: sans-serif;
                                letter-spacing: 10px;
                            }
                            
                            .h1 {
                                font-family: sans-serif;
                                color: #ffffff;
                                font-size: 23px;
                                line-height: 38px;
                                font-weight: bold;
                            }
                            
                            .h2 {
                                color: #000000;
                                font-family: sans-serif;
                                padding: 0 0 15px 0;
                                font-size: 24px;
                                line-height: 28px;
                                font-weight: bold;
                            }
                            
                            .h3 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 14px;
                                line-height: 22px;
                                font-weight: bold;
                            }
                            
                            .h4 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 16px;
                                line-height: 30px;
                                font-weight: bold;
                            }
                            
                            .bodycopy {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 14px;
                                line-height: 22px;
                            }
                            
                            .button {
                                text-align: center;
                                font-size: 18px;
                                font-family: sans-serif;
                                font-weight: bold;
                                padding: 0 30px 0 30px;
                            }
                            
                            .button a {
                                color: #ffffff;
                                text-decoration: none;
                            }
                            
                            .footer {
                                padding: 20px 30px 15px 30px;
                            }
                            
                            .footercopy {
                                font-family: sans-serif;
                                font-size: 14px;
                                color: #ffffff;
                            }
                            
                            .footercopy a {
                                color: #ffffff;
                                text-decoration: underline;
                            }
                            
                            .coldiv115 {
                                width: 115px;
                            }
                            
                            ;
                            .coldiv380 {
                                width: 380px;
                            }
                            
                            ;
                            @media only screen and (max-width: 550px),
                            screen and (max-device-width: 550px) {
                                body[yahoo] .hide {
                                    display: none!important;
                                }
                                body[yahoo] .buttonwrapper {
                                    background-color: transparent!important;
                                }
                                body[yahoo] .button {
                                    padding: 0px!important;
                                }
                                body[yahoo] .button a {
                                    background-color: #e05443;
                                    padding: 15px 15px 13px!important;
                                }
                                body[yahoo] .unsubscribe {
                                    display: block;
                                    margin-top: 20px;
                                    padding: 10px 50px;
                                    background: #2f3942;
                                    border-radius: 5px;
                                    text-decoration: none!important;
                                    font-weight: bold;
                                }
                            }
                        </style>
                    </head>

                    <body yahoo bgcolor="#f2f2f2">
                        <table width="100%" bgcolor="#f2f2f2" border="0" cellpadding="0" cellspacing="0">
                            <tr>
                                <td>
                                    <table bgcolor="#ffffff" class="content" align="center" cellpadding="0" cellspacing="0" border="0">
                                        <tr>
                                            <td bgcolor="#ffffff" class="header">
                                                <table width="70" align="center" border="0" cellpadding="0" cellspacing="0">
                                                    <tr>
                                                        <td height="70" style="padding: 0 20px 20px 0;">
                                                            <img class="fix" src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png" border="0" alt="" />
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                    
                                        <tr>
                                            <td bgcolor="#dc0000" class="header">
                                                <table class="col425" align="center" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 425px;">
                                                    <tr>
                                                        <td height="70">
                                                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                                <tr>
                                                                    <h1 class="h1" align="center" style="padding: 0 0 0 0;">VERISMART</h1>
                                                                    <h1 class="h1" align="center" style="padding: 0 0 0 0;">NOTIFICACION AGENDA</h1>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                    
                                        <tr>
                                            <td class="innerpadding">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td class="h2">
                                                            Estimado usuario,
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="bodycopy">
                                                            <p>Nos complace informarle que se ha enviado una notificación por Agenda</p>
                                                            <p>Cliente: '.$Cliente.'</p>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="innerpadding">
                                                <p>Se realizo: '.$EstadoVenta.' a TELECIERRE - PROSPECTO '.$NProspecto.' </p>
                                                <p>Por favor, para cualquier consulta, contacta con Telecierre (telecierre@verisure.pe) o Raul Rubio (raul.rubio@verisure.pe) .</p>
                                                <p>Muchas gracias.</p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="footer" bgcolor="#44525f">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td align="center" class="footercopy">
                                                            2021 &reg; Verisure Perú SAC<br/> Av. Primavera 1050 – Oficina 501<br/> Santiago de Surco – Urbanización Chacarilla del Estanque<br/> Lima – Perú
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </body>
            
            </html>
        ';

        //Destinatario
        //$paraCorreo = $correoDelegado.", joseenrique.nanquen@verisure.pe, janpierre.vargas@verisure.pe";
        
        if( $DelegacionOriginal == 150 || $DelegacionOriginal == 152||$DelegacionOriginal == 157 || $DelegacionOriginal == 159 || $DelegacionOriginal == 251 || $DelegacionOriginal == 100){
            $correoTerritorial="renzobranchi.branez@verisure.pe";
        } else if ($DelegacionOriginal == 151 || $DelegacionOriginal == 156 || $DelegacionOriginal == 154 || $DelegacionOriginal == 120 || $DelegacionOriginal == 121 || $DelegacionOriginal == 140 || $DelegacionOriginal == 200){
            $correoTerritorial="manuel.sgonzalez@securitasdirect.es";
        } else if ($DelegacionOriginal == 153 || $DelegacionOriginal == 155 || $DelegacionOriginal == 250 || $DelegacionOriginal == 158 || $DelegacionOriginal == 40 || $DelegacionOriginal == 41 ){
            $correoTerritorial="monicamaria.sanchez@verisure.pe";
        }
        
        
        $paraCorreo = "joseenrique.nanquen@verisure.pe, raul.rubio@verisure.pe ,janpierre.vargas@verisure.pe,agendacomercial@verisure.pe,alessandra.reupo@verisure.pe,alejandro.delsante@verisure.pe,sonia.chavez@verisure.pe,".$CorreoDelegado.",".$correoTerritorial."\r\n";
        
        //para el envío en formato HTML 
        $headersCorreo = "MIME-Version: 1.0\r\n";
        $headersCorreo .= "Content-type: text/html; charset=utf-8\r\n";
        
        //dirección del remitente 
            $headersCorreo .= "From: Sistema de Ventas Verismart - Verisure Perú <soporteit@verismart.com.pe>\r\n";
        
        //dirección de respuesta, si queremos que sea distinta que la del remitente 
            $headersCorreo .= "Reply-To: telecierre@verisure.pe\r\n";
        
        //ruta del mensaje desde origen a destino 
            $headersCorreo .= "Return-path: soporteit@verismart.com.pe\r\n";
        
        //direcciones que recibián copia 
            //$headersCorreo .= "cc: ".$correojefe.", ".$copia1."\r\n"; 
        
        //direcciones que recibirán copia oculta 
        //$headersCorreo .= "Bcc: ".$correo_prueba."\r\n"; 
        
        mail($paraCorreo, $tituloCorreo, $mensajeCorreo, $headersCorreo);
        
        
}

