<?php
// require "bd/Conection.php";
// require $_SERVER['DOCUMENT_ROOT']."/trabajo/bd/Conection.php";

//use PHP_CodeSniffer\Standards\Squiz\Sniffs\Strings\EchoedStringsSniff;
//use PhpParser\Node\Stmt\TryCatch;

/**
 * 
 */
class ConexionTeleVenta
{


	private $db;
	private $usuario;

	function __construct()
	{

		$this->db =  Database::connect();

		// $this->db = new mysqli('localhost','root','','prueba');

	}

	public function SelectIdDepartamental($idgeografico){

		$query = $this->db->prepare("SELECT p.IdDepartamental,g.prioridadChip,g.Provincia FROM yifi58ge_dbVENTAS.tblgeografico g
INNER JOIN yifi58ge_dbVENTAS.tbldistrital d on d.CodUbigeoReniec=g.CodUbigeoReniec
INNER JOIN yifi58ge_dbVENTAS.tblprovincial p on p.IdProvincial=d.IdProvincial
WHERE g.IdGeografico=?");
        $query->execute(array($idgeografico));

        $respuesta = $query->rowCount();
        if($respuesta>0){
            $fila = $query->fetch(PDO::FETCH_ASSOC);
            if($fila['IdDepartamental']==7){
              $fila= array('IdDepartamental'=>'15');  
            }
        }else{
            $fila= array('IdDepartamental'=>'15');
        }
		return $fila;

	}



	/* INSERTAR DOCUMENTOS*/ 

	public function insertarDocumento($lbltipodoc,$lbldocumento,$fecharegistro){
		try {

			$query = $this->db->prepare("INSERT INTO yifi58ge_dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES (?,?,?) ");
			$query->execute(array($lbltipodoc,$lbldocumento,$fecharegistro));
			
			$idDocumento = $this->db->lastInsertId(); 

			$respuesta = $idDocumento;
		
		} catch (\Exception $e) {
			$respuesta = array(
                'respuesta' => 'error'
            );
        }

		return $respuesta;
	}

	/* ACTUALIZAR DOCUMENTOS */ 

	public function actualizarDocumento($lblIdDocTV,$lbltipodoc,$lbldocumento){
		try {
			$query = $this->db->prepare("UPDATE tbldocumento SET TipoDocumento = ? , Documento = ? WHERE IdDoc = ? ");
			$query->execute(array($lbltipodoc,$lbldocumento,$lblIdDocTV));
			
			$respuesta = $query->rowCount();
		} catch (\Exception $e) {
			$respuesta = array(
                'respuesta' => 'error'
            );
        }

		return $respuesta;	
	}

	/* LISTAR SCORING */
	public function ListarScoring($valcodigoOperacionScoring)
	{
		
		$query = $this->db->prepare("SELECT t.IdConsultaScoring,t.PerfilScoring,t.Accion,t.TipoDocumento,t.NumeroDocumento FROM yifi58ge_dbVENTAS.tbltmpscoring t WHERE t.NumeroOperacion = ?");
		$query->execute(array($valcodigoOperacionScoring));

		$retorno = [];
		$i = 0;
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[$i] = $fila;
			$i++;
		}

		return $retorno;
		
	}
	///......-------......./////


	function actualizarTeleventa_v5($lblidagenda,$ediventa,$instaladoXAgenda,$tecnicoAgenda,$fechaAgenda,$horaAgenda,$comentarioAgenda,$repercucionAgenda,$catgventa,$lblestadoventa,$mesano,$lblestadotelecierre,$lbltipoventatc,$lblmovivonoventatc,$lblcctc,$lblgestortc,$lblpreciokittc,$lbltotalextratc,$ingresokit,$ingresoextras,$ingresototal,$lblextraautorizadotc,$lblmesesautorizadostc,$lblformadepagotc,$lblPAItc,$lblresumenventatc,$lblcomentariotc,$lblestadovisita,$lblsco,$tccompetencia,$lblnprospecto,$lblnprospectocc,$lblmesteleventa,$lblleadid,$lblfrellamadaTC,$lblhrellamadaTC,$lbltipokittc,$lblcantidadextratc,$prioridad,$lblformapagocuota,$fecharegistro,$lblTotalCuotaMonitoreo,$HidDesc3meses,$HidpagoAdelantado,$lblsegmento,$TotalIntentos,$cantidadDias,$lblcantidadregalotc,$lblorigen,$lblnivel1,$lblnivel2,$lblvueltas,$lblfechaultimagestion,$FechaTCFI,$lblIteraccionAgenda,$IdConsultaScoring,$lbltipoaccion,$ultimaestado,$lbldistrito,$comentariocancelacion,$gestor,$prospectoAbierto,$fechaProspectoAbierto,$IdTCTVgestion=null)
	{	   

		$habilitadoTV = "NO";
		
		if($lbltipoaccion=='gestion'){
			
		  if($ultimaestado=="Cancelada" || $ultimaestado=="Inviable" || $ultimaestado=="Ilocalizable" || $ultimaestado=="NoAgendada" || $ultimaestado==""){
			  if($lblestadoventa=='PendienteAgenda' || $lblestadoventa=='PendienteData' || $lblestadoventa=='AgendadaTEC'){
				  $lblIteraccionAgenda++;
				  $fechaprogramacion=$fechaAgenda.' '.$horaAgenda;
				  $query = $this->db->prepare("INSERT INTO tblagendareporte(IdVenta, FechaVenta, Matricula, CC, Vueltas, IdGeografico,FechaProgramacion) VALUES (?,?,?,?,?,?,?)");
		          $query->execute(array($ediventa,$fecharegistro,$lblgestortc,$lblcctc,$lblIteraccionAgenda,$lbldistrito,$fechaprogramacion));				
				
				
			  }
			  
		  }
			
          if($lblestadoventa=='AgendadaTEC'){
			  if ($FechaTCFI == ''){
				  $FechaTCFI=date("Y-m-d H:i:s");
			  }else{
				  $FechaTCFI=$FechaTCFI;
			  }
          }
          
          $FechaProspectoAbierto = NULL;
		  
		  if($prospectoAbierto == NULL || $prospectoAbierto == ''){
		      if($lblestadotelecierre == 'ProspectoAbierto'){
    		        $prospectoAbierto = 'SI';
    		        $FechaProspectoAbierto = date("Y-m-d H:i:s");
		      } else {
    		      if($prospectoAbierto != '' || $prospectoAbierto != NULL){
    		          $FechaProspectoAbierto = $fechaProspectoAbierto;
    		      } else {
        		      $prospectoAbierto = NULL;
        		      $FechaProspectoAbierto = NULL;
    		      }
		      }
		  } else {

		      if($prospectoAbierto != '' || $prospectoAbierto != NULL){
    		          $FechaProspectoAbierto = $fechaProspectoAbierto;
		      } else {
    		      $prospectoAbierto = NULL;
    		      $FechaProspectoAbierto = NULL;
		      }
		  }
		  
			try{


			  $query = $this->db->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET CategoriaVenta=?, EstadoVenta=?, N590=?, EstadoTelecierre=?, TCTipoVenta=?, TCMotivoNoVenta=?, CC=?, TCGestor=?, PrecioKit=?, TotalExtra=?, IngresoKIT=?, IngresoExtras=?, IngresoTotal=?, ExtraAutorizado=?, MesesAutorizado=?, FormaPago=?, PAI=?, ResumenVenta=?, TCComentario=?, EstadoVisita=?, TCScoring=?, TCCompetencia=?, NProspecto=?, NProspectoCC=?, MesTeleventa=?, LeadID=?, TCFechaRellamada=?, TCHoraRellamada=?,TipoKIT=?,CantidadExtras=?,Prioridad=?,FormaPagoCuota=?, FechaGestionTC=?, HabilitadoTV=?, TotalCuotaMonitoreo=?, DescMeses=?, pagoAdelantado=?, Segmento=?, TotalIntentos=?, CantidadDiasA=?, CantidadRegalo=?,OrigenVisita=?,Nivel_1=?,Nivel_2=?,Vueltas=?,FechaUltimaGestion=?,FechaTCFI=?,IteraccionAgenda=?,IdConsultaScoringTCTV=?,ComentarioCancelacion=?, ProspectoAbierto=?, FechaProspectoAbierto=?,IdTCTVgestion=? WHERE IdVenta=?");
              $query->execute(array($catgventa,$lblestadoventa,$mesano,$lblestadotelecierre,$lbltipoventatc,$lblmovivonoventatc,$lblcctc,$lblgestortc,$lblpreciokittc,$lbltotalextratc,$ingresokit,$ingresoextras,$ingresototal,$lblextraautorizadotc,$lblmesesautorizadostc,$lblformadepagotc,$lblPAItc,$lblresumenventatc,$lblcomentariotc,$lblestadovisita,$lblsco,$tccompetencia,$lblnprospecto,$lblnprospectocc,$lblmesteleventa,$lblleadid,$lblfrellamadaTC,$lblhrellamadaTC,$lbltipokittc,$lblcantidadextratc,$prioridad,$lblformapagocuota,$fecharegistro,$habilitadoTV,$lblTotalCuotaMonitoreo,$HidDesc3meses,$HidpagoAdelantado,$lblsegmento,$TotalIntentos,$cantidadDias,$lblcantidadregalotc,$lblorigen,$lblnivel1,$lblnivel2,$lblvueltas,$lblfechaultimagestion,$FechaTCFI,$lblIteraccionAgenda,$IdConsultaScoring,$comentariocancelacion,$prospectoAbierto,$FechaProspectoAbierto,$IdTCTVgestion,$ediventa));
              $filaAfectada = $query->rowCount();	

			  if ($filaAfectada > 0) {
				
	  		    if($lblestadoventa=='AgendadaTEC'){
	  		        
    			  $queryActualizarAgenda = $this->db->prepare("UPDATE yifi58ge_dbVENTAS.tblagenda SET FechaInst=?, HoraInst=?, InstaladoX=?, MatriculaTec=?, Comentario=?, Repercusion=? WHERE IdAgenda=?");
                  $queryActualizarAgenda->execute(array($fechaAgenda,$horaAgenda,$instaladoXAgenda,$tecnicoAgenda,$comentarioAgenda,$repercucionAgenda,$lblidagenda));
                  $filaAfectadaActualizarAgenda = $queryActualizarAgenda->rowCount();
                  
    			  $queryInsertarVenta = $this->db->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagendahist(IdAgenda, IdVenta,Comentario, FechaHoraREG,GestorAgenda,EstadoVenta,FechaInst,HoraInst,InstaladoX,MatriculaTec) VALUES (?,?,?,?,?,?,?,?,?,?)");
                  $queryInsertarVenta->execute(array($lblidagenda,$ediventa,$comentarioAgenda,$fecharegistro,$gestor,$lblestadoventa,$fechaAgenda,$horaAgenda,$instaladoXAgenda,$tecnicoAgenda));                  
                  
                  
		        }
				$respuesta = array(
					'respuesta' => 'exito',
					'id_actualizado' => $ediventa,
					'tipo' => 'televenta',
					'FechaGestionTC' => $fecharegistro
				);
			  } else {
				  $respuesta = array(
					  'respuesta' => 'nada',
					  'tipo' => 'televenta'
				  );
			  }

			} catch (\Exception $e) {
				$respuesta = array(
				  'respuesta' => 'error',
				  'mensaje' => $e->getMessage(),
				  'tipo' => 'televenta'
				);
			}
	  
		}else if($lbltipoaccion=='informacion'){
	  
			try{

			  $query = $this->db->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET CategoriaVenta=?, EstadoVenta=?, N590=?, TCTipoVenta=?, CC=?, TCGestor=?, PrecioKit=?, TotalExtra=?, IngresoKIT=?, IngresoExtras=?, IngresoTotal=?, ExtraAutorizado=?, MesesAutorizado=?, FormaPago=?, PAI=?, ResumenVenta=?, TCComentario=?, EstadoVisita=?, TCScoring=?, NProspecto=?, NProspectoCC=?, MesTeleventa=?, LeadID=?,TipoKIT=?,CantidadExtras=?,Prioridad=?,FormaPagoCuota=?, FechaGestionTC=?, HabilitadoTV=?, TotalCuotaMonitoreo=?, DescMeses=?, pagoAdelantado=?, Segmento=?, TotalIntentos=?, CantidadDiasA=?, CantidadRegalo=?,OrigenVisita=?,IdConsultaScoringTCTV=?,ComentarioCancelacion=? WHERE IdVenta=?");
              $query->execute(array($catgventa,$lblestadoventa,$mesano,$lbltipoventatc,$lblcctc,$lblgestortc,$lblpreciokittc,$lbltotalextratc,$ingresokit,$ingresoextras,$ingresototal,$lblextraautorizadotc,$lblmesesautorizadostc,$lblformadepagotc,$lblPAItc,$lblresumenventatc,$lblcomentariotc,$lblestadovisita,$lblsco,$lblnprospecto,$lblnprospectocc,$lblmesteleventa,$lblleadid,$lbltipokittc,$lblcantidadextratc,$prioridad,$lblformapagocuota,$fecharegistro,$habilitadoTV,$lblTotalCuotaMonitoreo,$HidDesc3meses,$HidpagoAdelantado,$lblsegmento,$TotalIntentos,$cantidadDias,$lblcantidadregalotc,$lblorigen,$IdConsultaScoring,$comentariocancelacion,$ediventa));
            
			  $filaAfectada = $query->rowCount();
			  if ($filaAfectada > 0) {
				$respuesta = array(
					'respuesta' => 'exito',
					'id_actualizado' => $ediventa,
					'tipo' => 'televenta',
					'FechaGestionTC' => $fecharegistro
				);
			  } else {
				  $respuesta = array(
					  'respuesta' => 'nada',
					  'tipo' => 'televenta'
				  );
			  }

			} catch (\Exception $e) {
				$respuesta = array(
				  'respuesta' => 'error',
				  'mensaje' => $e->getMessage(),
				  'tipo' => 'televenta'
				);
			}
	  
		}else{
			  $respuesta = array(
			  'respuesta' => 'error',
			  'mensaje' => 'error',
			  'tipo' => 'televenta'
			);
		}
		 return $respuesta;
	}

    function registrarHistoricoTeleventa_v3($idventa, $estadovisita, $estadoventa, $estadotelecierre, $tipoventatc, $movivonoventatc, $cctc, $gestortc, $preciokittc, $totalextratc, $resumenventatc, $extraautorizadotc, $formadepagotc, $mesesautorizadostc, $PAItc, $comentariotc, $n590, $gestor, $fecharegistro, $ccorigen, $tcscoring, $tccompetencia, $prioridad,$lbltipoaccion,$lblnivel1,$lblnivel2,$lblvueltas,$lblfrellamadaTC,$lblhrellamadaTC,$comentariocancelacion)
    {


	    try {

			$query = $this->db->prepare("INSERT INTO yifi58ge_dbVENTAS.tbltelecierrehist(IdVenta, EstadoVisita, EstadoVenta, EstadoTelecierre, TCTipoVenta, TCMotivoNoVenta, TCCC, TCGestor, TCPrecioKIT, TCTotalExtra, TCResumenVenta, TCExtraAutorizado, TCFormaPago, TCMesesAutorizado, TCPAI, TCComentario, TC590, GestorOrigen, FechaHoraREG,CCOriginal,TCScoring,TCCompetencia,Prioridad,Gestion,Nivel_1,Nivel_2,Vueltas,TCFechaRellamada,TCHoraRellamada,ComentarioCancelacion) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?)");
			$query->execute(array($idventa, $estadovisita, $estadoventa, $estadotelecierre, $tipoventatc, $movivonoventatc, $cctc, $gestortc, $preciokittc, $totalextratc, $resumenventatc, $extraautorizadotc, $formadepagotc, $mesesautorizadostc, $PAItc, $comentariotc, $n590, $gestor, $fecharegistro, $ccorigen, $tcscoring, $tccompetencia, $prioridad,$lbltipoaccion,$lblnivel1,$lblnivel2,$lblvueltas,$lblfrellamadaTC,$lblhrellamadaTC,$comentariocancelacion));
			$idDocumento = $this->db->lastInsertId(); 

			$respuesta = $idDocumento;
		
		} catch (\Exception $e) {
			$respuesta = array(
                'respuesta' => 'error'
            );
        }

		return $respuesta;

        
    }
    
    



	////.......-------....../////

	/* ACTUALIZAR IMAGEN VENTA*/

	public function UltimoEstadoVenta($ediventa){

		$query = $this->db->prepare("SELECT EstadoVenta FROM tblventa WHERE IdVenta = ?");
		$query->execute(array($ediventa));

		$fila = $query->fetch(PDO::FETCH_ASSOC);

		return $fila['EstadoVenta'];

	}

	public function totalRegistros($ediventa){

		$query = $this->db->prepare("SELECT count(*) totalRegistros FROM tbltelecierrehist WHERE IdVenta = ?");
		$query->execute(array($ediventa));

		$fila = $query->fetch(PDO::FETCH_ASSOC);

		return $fila['totalRegistros'];

	}

	public function consultaCliente_nuevo($lblidcliente){
		$query = $this->db->prepare("SELECT IdGeografico, NombApellido, Telefonouno, Telefonodos, Correo, Direccion, Segmento, Ncliente FROM tblcliente 
									WHERE IdCliente  = ?");
		$query->execute(array($lblidcliente));

		$fila = $query->fetch(PDO::FETCH_ASSOC);

		return $fila;
	}

	//Funcion nueva Cliente
	public function actualizarClienteDoc($lblidcliente,$lblnombcliente,$lblcorreo,$lbldireccion,$lbldistrito,$lblmovil,$lblfijo,$lblsegmento,$lblncontrato,$lblIdDocTV,$Referencia){

		try{
		    
			//$query = $this->db->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente SET IdGeografico = $lbldistrito, NombApellido = '$lblnombcliente', Correo = '$lblcorreo', Direccion = '$lbldireccion', Telefonouno = $lblmovil, Telefonodos=$lblfijo, Segmento='$lblsegmento', NCliente='$lblncontrato', IdDocTV=$lblIdDocTV, Referencia='$Referencia' WHERE IdCliente = $lblidcliente");
    
            $query = $this->db->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente SET IdGeografico = ?, NombApellido = ?, Correo = ?, Direccion = ?, Telefonouno = ?, Telefonodos=?, Segmento=?, NCliente=?, IdDocTV=?, Referencia=? WHERE IdCliente = ?");
            $query->execute(array($lbldistrito,$lblnombcliente,$lblcorreo,$lbldireccion,$lblmovil,$lblfijo,$lblsegmento,$lblncontrato,$lblIdDocTV,$Referencia,$lblidcliente));
            //$query->rowCount();
    

			$rows = $query->rowCount();

			if ($rows > 0) {
				$respuesta = array(
					'respuesta' => 'exito',
					'id_actualizado' => $lblidcliente,
					'tipo' => 'cliente'
				);
			} else {
				$respuesta = array(
					'respuesta' => 'nada',
					'tipo' => 'cliente'
				);
			}

		} catch (\Exception $e) {
			$respuesta = array(
				'respuesta' => 'error',
				'mensaje' => $e->getMessage(),
				'tipo' => 'cliente'
			);
		}

		return $respuesta;
	}



	public function consultaTeleventa($ediventa){
    
        $arrayactual = null;
        
        $query = $this->db->prepare("SELECT 
        v.CategoriaVenta,
        v.EstadoVenta,
        v.N590,
        v.EstadoTelecierre,
        v.TCTipoVenta,
        v.TCMotivoNoVenta,
        v.CC,
        v.TCGestor,
        v.PrecioKit,
        v.TotalExtra,
        v.IngresoKIT,
        v.IngresoExtras,
        v.IngresoTotal,
        v.ExtraAutorizado,
        v.MesesAutorizado,
        v.FormaPago,
        v.PAI,
        v.ResumenVenta,
        v.TCComentario,
        v.EstadoVisita,
        v.TCScoring,
        v.TCCompetencia,
        v.NProspecto,
        v.NProspectoCC,
        v.MesTeleventa,
        v.LeadID
        FROM tblventa v
        WHERE v.IdVenta=?");
        $query->execute(array($ediventa));
        
		$arrayactual = $query->fetch(PDO::FETCH_ASSOC);

        
        return $arrayactual;
    }
	

    public function mostarGestorCC()
    {
        $query = $this->db->prepare("SELECT u.IdUsuario,u.Matricula,u.Nombres,u.Apellidos,u.TCTV,u.RemarketingTV FROM yifi58ge_dbUSUARIO.tblusuario u WHERE u.Estado='Activo' and u.CC=512");
        
        $query->execute();

		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}
		return $retorno;		
    }


    /* LISTAR COTIZACIONES*/
	public function mostrarTodosTeleventaTC($function)
	{
        $new_total_rows = 0;
        $contador=1;
        
        $pagenum=htmlspecialchars(filter_var($function->pagenum, FILTER_SANITIZE_NUMBER_INT));
        $pagesize=htmlspecialchars(filter_var($function->pagesize, FILTER_SANITIZE_NUMBER_INT));
        
        $starts = $pagenum * $pagesize;
        

        $queryexec="SELECT 
                    IdVenta,
                    IdCliente,
                    Telefonouno,
                    Telefonodos,
                    NombApellido,
                    EstadoTelecierre,
                    EstadoVenta,
                    TipoVenta,
                    FechaHoraREG,
                    TipoTV,
                    TCGestor,
                    NombreTV,
                    Segmento,
                    PrecioKit,
                    N590,
                    Departamento,
                    Provincia,
                    Distrito,
                    Zonas,
                    Canal,
                    Vueltas,
                    OrigenVisita,
                    FechaInst,
                    HoraInst,
                    CC,
                    MatriculaTVOriginal,
                    NProspecto,
                    NContrato,
                    TCFechaRellamada,
                    TCMotivoNoVenta,
                    TCHoraRellamada,
                    Contacto,
                    Gestionable,
                    SubCompetencia,
                    ObsTransferencia,
                    TipoTransferencia,
                    FechaUltimaGestionCC,
                    Observaciones,
                    FechaUltimaGestion,
                    TCTipoVenta,
                    FechaHoraTransferenciaTVRemarketing,
                    FechaHoraTransferenciaTCTeleventa,
                    vueltasTCTeleventa,
                    vueltasTVRemarketing
                    FROM televenta";
        $query = $queryexec." LIMIT :starts,:pagesize";


        $where="";
        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = htmlspecialchars($function->filterscount);
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = htmlspecialchars($function->{"filtervalue".$i});
        			// get the filter's condition.
        			$filtercondition =htmlspecialchars($function->{"filtercondition".$i});
        			// get the filter's column.
        			$filterdatafield =htmlspecialchars($function->{"filterdatafield".$i});
        			// get the filter's operator.
        			$filteroperator =htmlspecialchars($function->{"filteroperator".$i});
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        				case "NULL":
        					$where .= " " . $filterdatafield . " IS NULL";
        					break;
        				case "NOT_NULL":
        					$where .= " " . $filterdatafield . " NOT NULL";
        					break;
        				case "GREATER_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ." 00:00:00'";
        					break;
        				case "LESS_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ." 23:59:59'";
        					break;
        					
        					
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }
        if (isset($function->sortdatafield)){
        	$sortfield = htmlspecialchars($function->sortdatafield);
        	$sortorder = htmlspecialchars($function->sortorder);
        	$filterscount = htmlspecialchars($function->filterscount);
        	if ($sortorder != '')
        		{
        		if ($filterscount == 0)
        			{
        			if ($sortorder == "desc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}

        			}
        		else
        			{
        			if ($sortorder == "desc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}
        			$query = $queryexec." " .$where.$filterquery;
        			}
        		}
        }



		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(
            'IdVenta' => $row['IdVenta'],
            'IdCliente' => $row['IdCliente'],
            'Telefonouno' => $row['Telefonouno'],
            'Telefonodos' => $row['Telefonodos'],
            'NombApellido' => $row['NombApellido'],
            'EstadoTelecierre' => $row['EstadoTelecierre'],
            'EstadoVenta' => $row['EstadoVenta'],
            'TipoVenta' => $row['TipoVenta'],
            'FechaHoraREG' => $row['FechaHoraREG'],
            'TipoTV' => $row['TipoTV'],
            'TCGestor' => $row['TCGestor'],
            'NombreTV' => $row['NombreTV'],
            'Segmento' => $row['Segmento'],
            'PrecioKit' => $row['PrecioKit'],
            'N590' => $row['N590'],
            'Departamento' => $row['Departamento'],
            'Provincia' => $row['Provincia'],
            'Distrito' => $row['Distrito'],
            'Zonas' => $row['Zonas'],
            'Canal' => $row['Canal'],
            'Vueltas' => $row['Vueltas'],
            'OrigenVisita' => $row['OrigenVisita'],
            'FechaInst' => $row['FechaInst'],
            'HoraInst' => $row['HoraInst'],
            'CC' => $row['CC'],
            'MatriculaTVOriginal' => $row['MatriculaTVOriginal'],
            'NProspecto' => $row['NProspecto'],
            'NContrato' => $row['NContrato'],
            'TCFechaRellamada' => $row['TCFechaRellamada'],
            'TCMotivoNoVenta' => $row['TCMotivoNoVenta'],
            'TCHoraRellamada' => $row['TCHoraRellamada'],
            'Contacto' => $row['Contacto'],
            'Gestionable' => $row['Gestionable'],
            'SubCompetencia' => $row['SubCompetencia'],
            'ObsTransferencia' => $row['ObsTransferencia'],
            'TipoTransferencia' => $row['TipoTransferencia'],
            'FechaUltimaGestionCC' => $row['FechaUltimaGestionCC'],
            'Observaciones' => $row['Observaciones'],
            'FechaUltimaGestion' => $row['FechaUltimaGestion'],
            'TCTipoVenta'=> $row['TCTipoVenta'],
            'FechaHoraTransferenciaTVRemarketing'=> $row['FechaHoraTransferenciaTVRemarketing'],
            'FechaHoraTransferenciaTCTeleventa'=> $row['FechaHoraTransferenciaTCTeleventa'],
            'vueltasTCTeleventa'=> $row['vueltasTCTeleventa'],
            'vueltasTVRemarketing'=> $row['vueltasTVRemarketing']
            
                	);
$contador++;                	
            
        }
        
	    $query = "SELECT COUNT(*) AS found_rows FROM televenta ".$where;
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	} 

	public function UpdateGestorRMKT($idUsuario,$checked,$tipo)
	{
	    
		if($tipo=='TCTV'){
    		$sql="UPDATE yifi58ge_dbUSUARIO.tblusuario SET TCTV=? WHERE IdUsuario=?";
		}else{
		    $sql="UPDATE yifi58ge_dbUSUARIO.tblusuario SET RemarketingTV=? WHERE IdUsuario=?";
		}
		$query = $this->db->prepare($sql);
	    $query->execute(array($checked,$idUsuario));
        $retorno = $query->rowCount();

		return $retorno;

	}

	/* INSERTAR TCTVgestion*/ 



	public function insertarTCTVgestion($lbltipoventatc,$vueltas,$ResultadoGestion,$ultimoGestor,$TCMotivoNoVenta=null,$TCCompetencia=null){
		try {
            
            if($lbltipoventatc=='TCTeleventa'){
                $sql="INSERT INTO yifi58ge_dbVENTAS.tblTCTVgestion(vueltasTCTeleventa, ultimoGestorTCTeleventa, ResultadoGestionTCTeleventa,SubtipificacionTCTeleventa,MotivoSubtipificacionTCTeleventa) VALUES (?,?,?,?,?)";

            }else if($lbltipoventatc=='TVRemarketing'){
                $sql="INSERT INTO yifi58ge_dbVENTAS.tblTCTVgestion(vueltasTVRemarketing, ultimoGestorTVRemarketing, ResultadoGestionTVRemarketing,SubtipificacionTVRemarketing,MotivoSubtipificacionTVRemarketing) VALUES (?,?,?,?,?)";
                
            }else{
                $sql="INSERT INTO yifi58ge_dbVENTAS.tblTCTVgestion(vueltasTeleventa, ultimoGestorTeleventa, ResultadoGestionTeleventa,SubtipificacionTeleventa,MotivoSubtipificacionTeleventa) VALUES (?,?,?,?,?)";
                
            }
            
			$query = $this->db->prepare($sql);
			$query->execute(array($vueltas,$ultimoGestor,$ResultadoGestion,$TCMotivoNoVenta,$TCCompetencia));
			
			$idDocumento = $this->db->lastInsertId(); 

			$respuesta = $idDocumento;
		
		} catch (\Exception $e) {
			$respuesta = array(
                'respuesta' => 'error'
            );
        }

		return $respuesta;
	}

	public function updateTCTVgestion($lbltipoventatc,$vueltas,$ResultadoGestion,$ultimoGestor,$id,$TCMotivoNoVenta=null,$TCCompetencia=null){

		try {
            
            if($lbltipoventatc=='TCTeleventa'){
                $sql="UPDATE yifi58ge_dbVENTAS.tblTCTVgestion SET vueltasTCTeleventa=?, ultimoGestorTCTeleventa=?, ResultadoGestionTCTeleventa=?,SubtipificacionTCTeleventa=?,MotivoSubtipificacionTCTeleventa=? where id=?";

            }else if($lbltipoventatc=='TVRemarketing'){
                $sql="UPDATE yifi58ge_dbVENTAS.tblTCTVgestion SET vueltasTVRemarketing=?, ultimoGestorTVRemarketing=?, ResultadoGestionTVRemarketing=?,SubtipificacionTVRemarketing=?,MotivoSubtipificacionTVRemarketing=? where id=?";
                
            }else{
                $sql="UPDATE yifi58ge_dbVENTAS.tblTCTVgestion SET vueltasTeleventa=?, ultimoGestorTeleventa=?, ResultadoGestionTeleventa=?,SubtipificacionTeleventa=?,MotivoSubtipificacionTeleventa=? where id=?";
                
            }
            
    		$query = $this->db->prepare($sql);
    	    $query->execute(array($vueltas,$ultimoGestor,$ResultadoGestion,$TCMotivoNoVenta,$TCCompetencia,$id));
            $retorno = $query->rowCount();
    
    		return $retorno;			
			
		
		} catch (\Exception $e) {
			return $respuesta = array(
                'respuesta' => 'error'
            );
        }

		return $respuesta;
	}

   	public function selectListarTeleventa_pre($function)
	{
        $new_total_rows = 0;
        $contador=1;
        
        $pagenum=htmlspecialchars(filter_var($function->pagenum, FILTER_SANITIZE_NUMBER_INT));
        $pagesize=htmlspecialchars(filter_var($function->pagesize, FILTER_SANITIZE_NUMBER_INT));
        
        $starts = $pagenum * $pagesize;
        

        $queryexec="SELECT 
IdVenta,
IdCliente,
Telefonouno,
Telefonodos,
NombApellido,
EstadoTelecierre,
EstadoVenta,
TipoVenta,
FechaHoraREG,
TipoTV,
TCGestor,
NombreTV,
Segmento,
PrecioKit,
N590,
Departamento,
Provincia,
Distrito,
Zonas,
Canal,
Vueltas,
OrigenVisita,
FechaInst,
HoraInst,
CC,
MatriculaTVOriginal,
NProspecto,
NContrato,
TCFechaRellamada,
TCMotivoNoVenta,
TCHoraRellamada,
Contacto,
Gestionable,
SubCompetencia,
ObsTransferencia,
TipoTransferencia,
FechaUltimaGestionCC,
Observaciones,
FechaUltimaGestion,
FechaHoraTransferenciaTVRemarketing,
FechaHoraTransferenciaTCTeleventa,
vueltasTCTeleventa,
vueltasTVRemarketing
FROM televentaaux";
        $query = $queryexec." LIMIT :starts,:pagesize";


        $where="";
        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = htmlspecialchars($function->filterscount);
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = htmlspecialchars($function->{"filtervalue".$i});
        			// get the filter's condition.
        			$filtercondition =htmlspecialchars($function->{"filtercondition".$i});
        			// get the filter's column.
        			$filterdatafield =htmlspecialchars($function->{"filterdatafield".$i});
        			// get the filter's operator.
        			$filteroperator =htmlspecialchars($function->{"filteroperator".$i});
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        				case "NULL":
        					$where .= " " . $filterdatafield . " IS NULL";
        					break;
        				case "NOT_NULL":
        					$where .= " " . $filterdatafield . " NOT NULL";
        					break;
        				case "GREATER_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ." 00:00:00'";
        					break;
        				case "LESS_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ." 23:59:59'";
        					break;
        					
        					
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }
        if (isset($function->sortdatafield)){
        	$sortfield = htmlspecialchars($function->sortdatafield);
        	$sortorder = htmlspecialchars($function->sortorder);
        	$filterscount = htmlspecialchars($function->filterscount);
        	if ($sortorder != '')
        		{
        		if ($filterscount == 0)
        			{
        			if ($sortorder == "desc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}

        			}
        		else
        			{
        			if ($sortorder == "desc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}
        			$query = $queryexec." " .$where.$filterquery;
        			}
        		}
        }



		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(

'IdVenta' => $row['IdVenta'],
'IdCliente' => $row['IdCliente'],
'Telefonouno' => $row['Telefonouno'],
'Telefonodos' => $row['Telefonodos'],
'NombApellido' => $row['NombApellido'],
'EstadoTelecierre' => $row['EstadoTelecierre'],
'EstadoVenta' => $row['EstadoVenta'],
'TipoVenta' => $row['TipoVenta'],
'FechaHoraREG' => $row['FechaHoraREG'],
'TipoTV' => $row['TipoTV'],
'TCGestor' => $row['TCGestor'],
'NombreTV' => $row['NombreTV'],
'Segmento' => $row['Segmento'],
'PrecioKit' => $row['PrecioKit'],
'N590' => $row['N590'],
'Departamento' => $row['Departamento'],
'Provincia' => $row['Provincia'],
'Distrito' => $row['Distrito'],
'Zonas' => $row['Zonas'],
'Canal' => $row['Canal'],
'Vueltas' => $row['Vueltas'],
'OrigenVisita' => $row['OrigenVisita'],
'FechaInst' => $row['FechaInst'],
'HoraInst' => $row['HoraInst'],
'CC' => $row['CC'],
'MatriculaTVOriginal' => $row['MatriculaTVOriginal'],
'NProspecto' => $row['NProspecto'],
'NContrato' => $row['NContrato'],
'TCFechaRellamada' => $row['TCFechaRellamada'],
'TCMotivoNoVenta' => $row['TCMotivoNoVenta'],
'TCHoraRellamada' => $row['TCHoraRellamada'],
'Contacto' => $row['Contacto'],
'Gestionable' => $row['Gestionable'],
'SubCompetencia' => $row['SubCompetencia'],
'ObsTransferencia' => $row['ObsTransferencia'],
'TipoTransferencia' => $row['TipoTransferencia'],
'FechaUltimaGestionCC' => $row['FechaUltimaGestionCC'],
'Observaciones' => $row['Observaciones'],
'FechaUltimaGestion' => $row['FechaUltimaGestion'],
'FechaHoraTransferenciaTVRemarketing' =>$row['FechaHoraTransferenciaTVRemarketing'],
'FechaHoraTransferenciaTCTeleventa' =>$row['FechaHoraTransferenciaTCTeleventa'],
'vueltasTCTeleventa' =>$row['vueltasTCTeleventa'],
'vueltasTVRemarketing' =>$row['vueltasTVRemarketing']

                	);
$contador++;                	
            
        }
        
	    $query = "SELECT COUNT(*) AS found_rows FROM televenta ".$where;
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	} 	

    public function registrarExtrasRegalos($idventa,$detalleExtras){
        
        $fecharegistro = date("Y-m-d H:i:s");
    	$query = $this->db->prepare("SELECT Detalle FROM tblventacotizaciontctv WHERE IdVenta=?");
    	$query->execute(array($idventa));
    	
    	$rows = $query->rowCount();
        if($rows > 0){
            try{
                $query = $this->db->prepare("UPDATE tblventacotizaciontctv SET Detalle=? WHERE IdVenta = ?");
                $query->execute(array($detalleExtras,$idventa));
                $respuesta = $query->rowCount();
                
                
            }catch (\Exception $e) {
                $respuesta = 'error';
            }            
            
            
        } else {
            try{
                $query = $this->db->prepare("INSERT INTO tblventacotizaciontctv (IdVenta, FechaHoraREG, Detalle) VALUES (?, ?, ?)");
                $query->execute(array($idventa,$fecharegistro,$detalleExtras));
                $respuesta = $this->db->lastInsertId(); 
                
            }catch (\Exception $e) {
                $respuesta = 'error';
            }            
            
            
        }
    	
    	return $respuesta;
    }
    
	

}
