<?php
class ConexionCalendarioAsignacionTecnico
{

	private $db;
	private $usuario;

	function __construct()
	{

		$this->db =  Database::connect();

	}
	
	public function InsertarMotivoTecnico($fechaInicio,$hourInicio,$fechaFin,$hourFin,$idUsuario,$motivo,$comentario,$estado,$idHistoricoTecnico)
	{
	    
        if($idHistoricoTecnico > 0 )
        {
            	$query = $this->db->prepare("UPDATE yifi58ge_dbUSUARIO.historico_tecnico_calendario SET fecha_inicio = ?, fecha_fin = ?, hora_inicio = ?, hora_fin = ?, motivo = ?, comentario = ?, estado = ? WHERE id_historicotecnico = ? ");
            	$query->execute(array($fechaInicio,$fechaFin,$hourInicio,$hourFin,$motivo,$comentario,$estado,$idHistoricoTecnico));
        }else{
            
            
            if($estado==1)
            {
                $query = $this->db->prepare("INSERT INTO yifi58ge_dbUSUARIO.historico_tecnico_calendario (fecha_inicio,fecha_fin,hora_inicio,hora_fin,motivo,id_usuario,estado,comentario) VALUES (?,?,?,?,?,?,?,?)");
                $query->execute(array($fechaInicio,$fechaFin,$hourInicio,$hourFin,$motivo,$idUsuario,$estado,$comentario));
                
            }
        }
        
		return $query?true:false;
		
	}



    public function ListaTecnicosMotivosNoLaboral($idusuario)
	{
		
		$query = $this->db->prepare("SELECT h.id_historicotecnico,h.estado,h.fecha_inicio,h.fecha_fin,h.hora_inicio,h.hora_fin,h.motivo FROM yifi58ge_dbUSUARIO.tblusuario u INNER JOIN yifi58ge_dbUSUARIO.historico_tecnico_calendario h on h.id_usuario=u.IdUsuario
                                    WHERE u.IdUsuario=? and h.estado=1"); //traer el idAsignacionTecnicos AND `htc`.idAsignacionTecnico = 25
        $query->execute(array($idusuario));
		
		// $numeroRegistros = $query->rowCount();

		$retorno = [];
		$i = 0;
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
			$i++;
		}
		return $retorno;
		
	}
	
	
	public function getIdHistoricoecnico($idUsuario,$fechaInicio,$fechaFin)
	{

		$query = $this->db->prepare("SELECT h.id_historicotecnico,h.fecha_inicio,h.motivo
		                            FROM yifi58ge_dbUSUARIO.historico_tecnico_calendario h 
                                    WHERE h.id_usuario=? and h.estado = 1 AND h.fecha_inicio BETWEEN ? AND ?"); //traer el idAsignacionTecnicos AND `htc`.idAsignacionTecnico = 25 
		$query->execute(array($idUsuario,$fechaInicio,$fechaFin));
		// $numeroRegistros = $query->rowCount();
    
		$retorno = [];
		$i = 0;
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
			$i++;
		}
		return $retorno;
		
	}

	public function getDatosHistorico($idHistorico)
	{
        $query = $this->db->prepare("SELECT h.fecha_inicio,h.fecha_fin,h.hora_inicio,h.hora_fin,h.motivo,h.comentario
		                            FROM yifi58ge_dbUSUARIO.historico_tecnico_calendario h 
                                    WHERE h.id_historicotecnico=?");
        $query->execute(array($idHistorico));

		$retorno = [];
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}

		return $retorno;
		
	}

}