<?php

class ConexionAgenda
{


	private $db;
	private $usuario;

	function __construct()
	{

		$this->db =  Database::connect();

	}


	/**** VERIFICACION DE LA EXISTENCIA DE IMAGEN *****/
    public function MostrarTecnicos($matricula)
    
	{
		
		$query = $this->db->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador,u.NumeroDoc,u.Cargo,u.FechaIngreso
                                    FROM yifi58ge_dbUSUARIO.tblusuario u  
                                    INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea
									WHERE u.LN=33 And u.Matricula = ? ");
        $query->execute(array($matricula));

		$retorno = [];
		$i = 0;
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[$i] = $fila;
			$i++;
		}

		return $retorno;
		
	}

	public function AsignacionTecnicos($value,$idDepartamento)
	{

		$query = $this->db->prepare("SELECT IdUsuario FROM yifi58ge_dbUSUARIO.tblusuario u WHERE u.LN=33 And u.Matricula = ? ");
		$query->execute(array($value));
		

		$dataUsuario = $query->fetch(PDO::FETCH_ASSOC); 

		$idUsuario = $dataUsuario['IdUsuario'];

		$query = $this->db->prepare("SELECT id_asignacion_tecnico FROM yifi58ge_dbUSUARIO.usuario_asignacion_tecnico WHERE id_usuario = ?");
		$query->execute(array($idUsuario));

		$dataAsignacionTecnico = $query->fetch(PDO::FETCH_ASSOC);

		if ($dataAsignacionTecnico == true) {

			$idAsignacionTecnico = $dataAsignacionTecnico['id_asignacion_tecnico'];
			
			$query = $this->db->prepare("SELECT estado FROM yifi58ge_dbUSUARIO.asignacion_tecnico WHERE id = ?");
			$query->execute(array($idAsignacionTecnico));
			
			// print_r($query);
			$dataEstado = $query->fetch(PDO::FETCH_ASSOC);

			$estado = $dataEstado['estado'];
			
			if ($estado == 0) {
				
				$query = $this->db->prepare("UPDATE yifi58ge_dbUSUARIO.asignacion_tecnico SET estado = 1, id_departamental = ? WHERE id = ? ");
				$query->execute(array($idDepartamento,$idAsignacionTecnico));
				
				return $query ? true: false;
			}
			
		}else{

				$estado = 1;
				$query2 = $this->db->prepare("INSERT INTO yifi58ge_dbUSUARIO.asignacion_tecnico (estado,id_departamental) VALUES (?,?)");
				$query2->execute(array($estado,$idDepartamento));
				$idAsignacionTecnico = $this->db->lastInsertId();
		
				$query = $this->db->prepare("INSERT INTO yifi58ge_dbUSUARIO.usuario_asignacion_tecnico (id_usuario,id_asignacion_tecnico) VALUES (?,?) ");
				$query->execute(array($idUsuario,$idAsignacionTecnico));

				$idUsuarioAsignacionTecnico = $this->db->lastInsertId();

				return $idUsuarioAsignacionTecnico > 0 ? true : false ;
				// var_dump($idUsuarioAsignacionTecnico);
	
		}



	}


	public function ListarTecnicos()
    
	{
		
		$query = $this->db->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador,u.NumeroDoc,u.Cargo,u.FechaIngreso
                                    FROM yifi58ge_dbUSUARIO.tblusuario u
                                    LEFT JOIN yifi58ge_dbUSUARIO.usuario_asignacion_tecnico ua on ua.id_usuario=u.IdUsuario
                                    LEFT JOIN yifi58ge_dbUSUARIO.asignacion_tecnico att on att.id=ua.id_asignacion_tecnico
									WHERE u.LN=33 and u.Estado='Activo' and IFNULL(att.estado,0)=0");
		$query->execute();							

		$retorno = [];
		$i = 0;
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[$i] = $fila;
			$i++;
		}

		return $retorno;
		
	}

	public function ListaTecnicosAsignados()
    
	{
		
		$query = $this->db->prepare("SELECT (@a:=@a+1) AS contadorTecnicos,d.Departamento,aste.estado, u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador ,u.NumeroDoc,u.Cargo,u.FechaIngreso
									FROM yifi58ge_dbUSUARIO.tblusuario u 
									INNER JOIN yifi58ge_dbUSUARIO.usuario_asignacion_tecnico uat ON u.IdUsuario = uat.id_usuario 
									INNER JOIN yifi58ge_dbUSUARIO.asignacion_tecnico aste ON aste.id = uat.id_asignacion_tecnico
									INNER JOIN yifi58ge_dbVENTAS.tbldepartamental d ON aste.id_departamental = d.IdDepartamental 
									JOIN (SELECT @a:= 0) T 
									WHERE aste.estado = 1 AND u.LN = 33
									");
		$query->execute();							

		$retorno = [];
		$i = 0;
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[$i] = $fila;
			$i++;
		}
	
		return $retorno;

		
	}
	

	public function CambiarEstadoTecnico($IdUsuario,$idestado,$checked)
	{

		if($idestado>0){

		$query = $this->db->prepare("UPDATE yifi58ge_dbUSUARIO.asignacion_tecnico SET estado = ? WHERE id = ?");
		$query->execute(array($checked,$idestado));
		return $query ? true: false;

		}else{
		    
	    $query = $this->db->prepare("INSERT INTO yifi58ge_dbUSUARIO.asignacion_tecnico (estado) VALUES (?)");
		$query->execute(array($checked));
		
		$idAsignacionTecnico = $this->db->lastInsertId();
		
		$query = $this->db->prepare("INSERT INTO yifi58ge_dbUSUARIO.usuario_asignacion_tecnico (id_usuario,id_asignacion_tecnico) VALUES (?,?) ");
		$query->execute(array($IdUsuario,$idAsignacionTecnico));

		$idUsuarioAsignacionTecnico = $this->db->lastInsertId();

		return $idUsuarioAsignacionTecnico > 0 ? true : false ;
		    
		}

	}

	public function CambiarZonaTecnico($IdUsuario,$idestado,$iddepartamental)
	{

		if($idestado>0){

		$query = $this->db->prepare("UPDATE yifi58ge_dbUSUARIO.asignacion_tecnico SET id_departamental = ? WHERE id = ?");
		$query->execute(array($iddepartamental,$idestado));
		return $query ? true: false;

		}else{
		$estado=0;    
	    $query = $this->db->prepare("INSERT INTO yifi58ge_dbUSUARIO.asignacion_tecnico (estado,id_departamental) VALUES (?,?)");
		$query->execute(array($estado,$iddepartamental));
		$idAsignacionTecnico = $this->db->lastInsertId();
		
		$query = $this->db->prepare("INSERT INTO yifi58ge_dbUSUARIO.usuario_asignacion_tecnico (id_usuario,id_asignacion_tecnico) VALUES (?,?) ");
		$query->execute(array($IdUsuario,$idAsignacionTecnico));

		$idUsuarioAsignacionTecnico = $this->db->lastInsertId();

		return $idUsuarioAsignacionTecnico > 0 ? true : false ;
		    
		}

	}
	
	
	public function AsignacionDepartamentos()
    
	{
		
		$query = $this->db->prepare("SELECT * FROM yifi58ge_dbVENTAS.tbldepartamental WHERE IdDepartamental<>7");
		$query->execute();

		$retorno = [];
		$i = 0;
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[$i] = $fila;
			$i++;
		}

		return $retorno;
		
	}

		public function MostrarTecnicosTotal($function)
	{
        $new_total_rows = 0;
        $pagenum=$function->pagenum;
        $pagesize=$function->pagesize;
        
        $starts = $pagenum * $pagesize;
        


        $queryexec="SELECT SQL_CALC_FOUND_ROWS
        IdUsuario,
        id_departamental,
        Departamento,
        estado,
        Matricula,
        Instalador,
        NumeroDoc,
        Cargo,
        FechaIngreso,
        id
         FROM yifi58ge_dbUSUARIO.totaltecnicos";
        
        $query = $queryexec." LIMIT :starts,:pagesize";



        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = $function->filterscount;
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = $function->{"filtervalue".$i};
        			// get the filter's condition.
        			$filtercondition =$function->{"filtercondition".$i};
        			// get the filter's column.
        			$filterdatafield =$function->{"filterdatafield".$i};
        			// get the filter's operator.
        			$filteroperator =$function->{"filteroperator".$i};
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }

		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            
            $orders[] = array(
                'IdUsuario'=>$row['IdUsuario'],
                'id_departamental'=>$row['id_departamental'],
                'Departamento'=>$row['Departamento'],
                'estado'=>$row['estado'],
                'Matricula'=>$row['Matricula'],
                'Instalador'=>$row['Instalador'],
                'NumeroDoc'=>$row['NumeroDoc'],
                'Cargo'=>$row['Cargo'],
                'FechaIngreso'=>$row['FechaIngreso'],
                'id'=>$row['id']
                	);
            
        }
        
	    $query = "SELECT FOUND_ROWS() AS found_rows";
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	}


    public function MostrarTecnicosSelect2($q)
    
	{
		$q = "%{$q}%";
		$query = $this->db->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador
                                    FROM yifi58ge_dbUSUARIO.tblusuario u  
									WHERE u.LN=33 and u.Estado='Activo' And (u.Matricula like ? or u.Nombres like ?)");

        $query->execute(array($q,$q));

		$retorno = [];
		$i = 0;
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = array_map("utf8_encode",['id'=>$fila['Matricula'], 'text'=>$fila['Matricula']." - ".$fila['Instalador']]);
			
		}

		return $retorno;
		
	}
	
	    public function MostrarAgendaTecnicoporFecha($Fecha,$Matricula)
	{
		
		$query = $this->db->prepare("SELECT a.MatriculaTec,a.FechaInst,a.HoraInst,DATE_FORMAT(CONCAT(a.FechaInst,' ',a.HoraInst),'%Y-%m-%d %H:%i:%s') as FechaInsthoras,DATE_ADD(DATE_FORMAT(CONCAT(a.FechaInst,' ',a.HoraInst),'%Y-%m-%d %H:%i:%s'),INTERVAL 3 hour) as FechaInst3horas
                                    FROM yifi58ge_dbVENTAS.tblagenda a 
                                    INNER JOIN yifi58ge_dbVENTAS.tblventa v on v.IdVenta=a.IdVenta 
                                    WHERE v.EstadoVenta='AgendadaTEC' and a.MatriculaTec=? and a.FechaInst= ?");

        $query->execute(array($Matricula,$Fecha));

		$retorno = [];
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}
		return $retorno;
		
	}



}
