<?php
require dirname(__DIR__).'/ajax/is_logged.php';
require dirname(__DIR__).'/Connection/Conection.php';
require dirname(__DIR__).'/Model/ConexionLead.php';


date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}

if (isset($_POST['function']) && !empty($_POST['function'])) {

    $function = json_decode($_POST['function']);

    switch ($function->array) {
        case 'array1':
            $consulta = new Lead;
            $consulta->ListarLeads();
            break;
        case 'array2':
            $consulta = new Lead;
            $consulta->ListarLeadsR();
            break;
        case 'array3':
            $consulta = new Lead;
            $consulta->ListarGestorCC();
            break;
        case 'array4':
            $consulta = new Lead;
            $consulta->UpdateGestorRMKT();
            break;
        case 'array5':
            $consulta = new Lead;
            $consulta->guardarReferidoLead();
            break;
        case 'array6':
            $consulta = new Lead;
            $consulta->ListarLeadsReferidos();
            break;
        case 'array7':
            $consulta = new Lead;
            $consulta->UpdateGestorPUSH();
            break;
        case 'array8':
            $consulta = new Lead;
            $consulta->UpdateGestorPULL();
            break;
        case 'array9':
            $consulta = new Lead;
            $consulta->UpdateEquipo();
            break;
        case 'array10':
            $consulta = new Lead;
            $consulta->ListarLeadsAux();
            break;
        case 'array11':
            $consulta = new Lead;
            $consulta->ListarOrigenes();
            break;      
        default:
            echo "error_data";
            break;
    }

}

class Lead
{

    public function ListarOrigenes(){
        $function = json_decode($_POST['function']);
        $q=$function->term;
        
        $conexion = new ConexionLead();
        $datos=$conexion->listarOrigenesMKT($q);

        print_r(json_encode($datos));        
        
        
    }    

    public function ListarLeadsAux()
    {
        $function = json_decode($_POST['function']);

        $conexion = new ConexionLead();
        
        $datos=$conexion->mostrarTodosLeadsAux($function);

        print_r(json_encode($datos));
    }           

    public function ListarLeads()
    {
        $function = json_decode($_POST['function']);

        $conexion = new ConexionLead();
        
        $datos=$conexion->mostrarTodosLeads($function);

        print_r(json_encode($datos));
        
    }
    
    public function ListarLeadsR()
    {
        $function = json_decode($_POST['function']);

        $conexion = new ConexionLead();
        
        $datos=$conexion->mostrarTodosLeadsRemarketing($function);

        print_r(json_encode($datos));
        
    }    
    public function ListarGestorCC()
    {
        $function=json_decode($_POST['function']);
        
        $conexion= new ConexionLead();
        
        $datos= $conexion->mostarGestorCC();
        
        print_r(json_encode($datos));

    }
    public function UpdateGestorRMKT()
    {
        $function=json_decode($_POST['function']);
        $idUsuario=$function->employee_id;
        $checked=$function->checked;

        $conexion= new ConexionLead();
        
        $datos=$conexion->UpdateGestorRMKT($idUsuario,$checked);
        
        print_r(json_encode($datos));        

        
    }
    
    public function UpdateGestorPUSH()
    {
        $function=json_decode($_POST['function']);
        $idUsuario=$function->employee_id;
        $checked=$function->checked;

        $conexion= new ConexionLead();
        
        $datos=$conexion->UpdateGestorPUSH($idUsuario,$checked);
        
        print_r(json_encode($datos));        

        
    }
    
    public function UpdateGestorPULL()
    {
        $function=json_decode($_POST['function']);
        $idUsuario=$function->employee_id;
        $checked=$function->checked;

        $conexion= new ConexionLead();
        
        $datos=$conexion->UpdateGestorPULL($idUsuario,$checked);
        
        print_r(json_encode($datos));        

    }
    public function UpdateEquipo()
    {
        $function=json_decode($_POST['function']);
        $idUsuario=$function->employee_id;
        $equipo=$function->equipo;

        $conexion= new ConexionLead();
        
        $datos=$conexion->UpdateEquipo($idUsuario,$equipo);
        
        print_r(json_encode($datos));        

    }      

    
    public function guardarReferidoLead(){
        
        $function=json_decode($_POST['function']);
        $matriculaAgente=$function->matriculaAgente;
        
        $nombresREF=htmlspecialchars($function->nombresREF);
        $apellidosREF=htmlspecialchars($function->apellidosREF);
        $segmentoREF=htmlspecialchars($function->segmentoREF);
        $telefonoREF=htmlspecialchars($function->telefonoREF);
        $gestionREF=htmlspecialchars($function->gestionREF);
        $observacionesREF=htmlspecialchars($function->observacionesREF);
        $leadidREF=htmlspecialchars($function->LeadId);
        $campana='Primer intento';

        $IdLeadCC=htmlspecialchars($function->IdLeadCC);
        
        
        
        $origen='Referido de Lead';
        
        $conexion= new ConexionLead();
        
        $idUsuario=$conexion->obtenerIdUsuario($matriculaAgente);
        
        $fecharegistro=date('Y-m-d H:i:s');
        
        $datos=$conexion->insertarLeadReferido($idUsuario, $fecharegistro, $gestionREF, $nombresREF, $apellidosREF, $telefonoREF, $origen, $leadidREF, $observacionesREF, $segmentoREF,$IdLeadCC,$campana);
        
        print_r(json_encode($datos)); 
        
        
    }
    
    public function ListarLeadsReferidos()
    {
        $function = json_decode($_POST['function']);

        $conexion = new ConexionLead();
        
        $datos=$conexion->mostrarTodosLeadsReferidos($function);

        print_r(json_encode($datos));
        
    }    

    
}