// to satisfy server side compilation

declare let global: any;
let globalObj = typeof global === 'undefined' ? {} : global;
globalObj.HTMLElement = typeof HTMLElement === 'undefined' ? {} : HTMLElement;
globalObj.HTMLButtonElement = typeof HTMLButtonElement === 'undefined' ? {} : HTMLButtonElement;
globalObj.HTMLSelectElement = typeof HTMLSelectElement === 'undefined' ? {} : HTMLSelectElement;
globalObj.HTMLInputElement = typeof HTMLInputElement === 'undefined' ? {} : HTMLInputElement;
globalObj.Node = typeof Node === 'undefined' ? {} : Node;

// columnController
export {BalancedColumnTreeBuilder} from "./dist/lib/columnController/balancedColumnTreeBuilder";
export {ColumnController} from "./dist/lib/columnController/columnController";
export {ColumnKeyCreator} from "./dist/lib/columnController/columnKeyCreator";
export {ColumnUtils} from "./dist/lib/columnController/columnUtils";
export {DisplayedGroupCreator} from "./dist/lib/columnController/displayedGroupCreator";
export {GroupInstanceIdCreator} from "./dist/lib/columnController/groupInstanceIdCreator";

// components
export {ComponentUtil} from "./dist/lib/components/componentUtil";
export {ColDefUtil} from "./dist/lib/components/colDefUtil";
export {ComponentProvider} from "./dist/lib/components/framework/componentProvider";
export {initialiseAgGridWithAngular1} from "./dist/lib/components/agGridNg1";
export {initialiseAgGridWithWebComponents} from "./dist/lib/components/agGridWebComponent";

// context
export {BeanStub} from "./dist/lib/context/beanStub";
export {
    Context,
    Autowired,
    PostConstruct,
    PreConstruct,
    Optional,
    Bean,
    Qualifier,
    PreDestroy
} from "./dist/lib/context/context";
export {QuerySelector, Listener, RefSelector} from "./dist/lib/widgets/componentAnnotations";

// excel
export {
    ExcelCell,
    ExcelExportParams,
    ExcelRow,
    ExcelStyle,
    ExcelWorksheet,
    ExcelBorder,
    ExcelColumn,
    ExcelData,
    ExcelDataType
} from "./dist/lib/interfaces/iExcelCreator";

// dragAndDrop
export {
    DragAndDropService,
    DragSourceType,
    HDirection,
    VDirection,
    DropTarget,
    DragSource,
    DraggingEvent
} from "./dist/lib/dragAndDrop/dragAndDropService";
export {DragService} from "./dist/lib/dragAndDrop/dragService";

// entities
export {Column} from "./dist/lib/entities/column";
export {ColumnGroup} from "./dist/lib/entities/columnGroup";
export {GridCell} from "./dist/lib/entities/gridCell";
export {GridRow} from "./dist/lib/entities/gridRow";
export {OriginalColumnGroup} from "./dist/lib/entities/originalColumnGroup";
export {RowNode} from "./dist/lib/entities/rowNode";

// filter
export {BaseFilter} from "./dist/lib/filter/baseFilter";
export {DateFilter} from "./dist/lib/filter/dateFilter";
export {FilterManager, FilterWrapper} from "./dist/lib/filter/filterManager";
export {NumberFilter} from "./dist/lib/filter/numberFilter";
export {TextFilter,SerializedTextFilter} from "./dist/lib/filter/textFilter";
export {IFloatingFilter, IFloatingFilterParams} from "./dist/lib/filter/floatingFilter";

// gridPanel
export {GridPanel} from "./dist/lib/gridPanel/gridPanel";
export {ScrollVisibleService} from "./dist/lib/gridPanel/scrollVisibleService";
export {MouseEventService} from "./dist/lib/gridPanel/mouseEventService";

// headerRendering
export {BodyDropPivotTarget} from "./dist/lib/headerRendering/bodyDropPivotTarget";
export {BodyDropTarget} from "./dist/lib/headerRendering/bodyDropTarget";
export {CssClassApplier} from "./dist/lib/headerRendering/cssClassApplier";
export {HeaderContainer} from "./dist/lib/headerRendering/headerContainer";
export {HeaderRenderer} from "./dist/lib/headerRendering/headerRenderer";
export {HeaderRowComp} from "./dist/lib/headerRendering/headerRowComp";
export {HorizontalDragService} from "./dist/lib/headerRendering/horizontalDragService";
export {MoveColumnController} from "./dist/lib/headerRendering/moveColumnController";
export {StandardMenuFactory} from "./dist/lib/headerRendering/standardMenu";

// layout
export {BorderLayout} from "./dist/lib/layout/borderLayout";
export {TabbedLayout} from "./dist/lib/layout/tabbedLayout";
export {VerticalStack} from "./dist/lib/layout/verticalStack";
export {TabbedItem} from "./dist/lib/layout/tabbedLayout"

// misc
export {simpleHttpRequest} from "./dist/lib/misc/simpleHttpRequest";

// editing / cellEditors
export {ICellEditor, ICellEditorComp, ICellEditorParams} from "./dist/lib/rendering/cellEditors/iCellEditor";
export {LargeTextCellEditor} from "./dist/lib/rendering/cellEditors/largeTextCellEditor";
export {PopupEditorWrapper} from "./dist/lib/rendering/cellEditors/popupEditorWrapper";
export {PopupSelectCellEditor} from "./dist/lib/rendering/cellEditors/popupSelectCellEditor";
export {PopupTextCellEditor} from "./dist/lib/rendering/cellEditors/popupTextCellEditor";
export {SelectCellEditor} from "./dist/lib/rendering/cellEditors/selectCellEditor";
export {TextCellEditor} from "./dist/lib/rendering/cellEditors/textCellEditor";

// rendering / cellRenderers
export {ICellRenderer, ICellRendererFunc, ICellRendererComp} from "./dist/lib/rendering/cellRenderers/iCellRenderer";
export {AnimateShowChangeCellRenderer} from "./dist/lib/rendering/cellRenderers/animateShowChangeCellRenderer";
export {AnimateSlideCellRenderer} from "./dist/lib/rendering/cellRenderers/animateSlideCellRenderer";
export {GroupCellRenderer} from "./dist/lib/rendering/cellRenderers/groupCellRenderer";

// overlays
export {ILoadingOverlayComp, ILoadingOverlayParams} from "./dist/lib/rendering/overlays/loadingOverlayComponent";
export {INoRowsOverlayComp, INoRowsOverlayParams} from "./dist/lib/rendering/overlays/noRowsOverlayComponent";

// features
export {SetLeftFeature} from "./dist/lib/rendering/features/setLeftFeature";

// rendering
export {AutoWidthCalculator} from "./dist/lib/rendering/autoWidthCalculator";
export {CellEditorFactory} from "./dist/lib/rendering/cellEditorFactory";
export {CellRendererFactory} from "./dist/lib/rendering/cellRendererFactory";
export {CellRendererService} from "./dist/lib/rendering/cellRendererService";
export {CheckboxSelectionComponent} from "./dist/lib/rendering/checkboxSelectionComponent";
export {CellComp} from "./dist/lib/rendering/cellComp";
export {RowComp} from "./dist/lib/rendering/rowComp";
export {RowRenderer} from "./dist/lib/rendering/rowRenderer";
export {ValueFormatterService} from "./dist/lib/rendering/valueFormatterService";
export {TextFormatter} from "./dist/lib/filter/textFilter";

// rowControllers/inMemory
export {FilterStage} from "./dist/lib/rowModels/inMemory/filterStage";
export {FlattenStage} from "./dist/lib/rowModels/inMemory/flattenStage";
export {SortStage} from "./dist/lib/rowModels/inMemory/sortStage";

// row models
export {PinnedRowModel} from "./dist/lib/rowModels/pinnedRowModel";
export {InMemoryRowModel, RowNodeTransaction} from "./dist/lib/rowModels/inMemory/inMemoryRowModel";
export {ChangedPath} from "./dist/lib/rowModels/inMemory/changedPath";
export {InMemoryNodeManager} from "./dist/lib/rowModels/inMemory/inMemoryNodeManager";
export {InfiniteRowModel} from "./dist/lib/rowModels/infinite/infiniteRowModel";
export {IEnterpriseGetRowsParams} from "./dist/lib/interfaces/iEnterpriseDatasource";
export {IEnterpriseGetRowsRequest} from "./dist/lib/interfaces/iEnterpriseDatasource";
export {InfiniteCacheParams} from "./dist/lib/rowModels/infinite/infiniteCache";
export {RowNodeBlock} from "./dist/lib/rowModels/cache/rowNodeBlock";
export {RowNodeBlockLoader} from "./dist/lib/rowModels/cache/rowNodeBlockLoader";
export {IEnterpriseRowModel} from "./dist/lib/interfaces/iEnterpriseRowModel";
export {IEnterpriseCache} from "./dist/lib/interfaces/iEnterpriseCache";
export {IEnterpriseDatasource, ColumnVO} from "./dist/lib/interfaces/iEnterpriseDatasource";
export {IToolPanel} from "./dist/lib/interfaces/iToolPanel";
export {RowNodeCache, RowNodeCacheParams} from "./dist/lib/rowModels/cache/rowNodeCache";
export {IGetRowsParams, IDatasource} from "./dist/lib/rowModels/iDatasource";

//styling
export {StylingService} from "./dist/lib/styling/stylingService";

// widgets
export {AgCheckbox} from "./dist/lib/widgets/agCheckbox";
export {Component} from "./dist/lib/widgets/component";
export {PopupService} from "./dist/lib/widgets/popupService";
export {TouchListener, TapEvent, LongTapEvent} from "./dist/lib/widgets/touchListener";

// range
export {RangeSelection, AddRangeSelectionParams} from "./dist/lib/interfaces/iRangeController"
export {IRangeController} from "./dist/lib/interfaces/iRangeController"

// root
export {BaseFrameworkFactory} from "./dist/lib/baseFrameworkFactory";
export {CellNavigationService} from "./dist/lib/cellNavigationService";
export {AlignedGridsService} from "./dist/lib/alignedGridsService";
export {Constants} from "./dist/lib/constants";
export {CsvCreator, BaseCreator} from "./dist/lib/csvCreator";
export {Downloader} from "./dist/lib/downloader";
export {Grid, GridParams} from "./dist/lib/grid";
export {GridApi, RedrawRowsParams, RefreshCellsParams, StartEditingCellParams, DetailGridInfo} from "./dist/lib/gridApi";
export {Events} from "./dist/lib/events";
export {FocusedCellController} from "./dist/lib/focusedCellController";
export {defaultGroupComparator} from "./dist/lib/functions";
export {GridOptionsWrapper} from "./dist/lib/gridOptionsWrapper";
export {EventService} from "./dist/lib/eventService";
export {GridCore} from "./dist/lib/gridCore";
export {Logger} from "./dist/lib/logger";
export {SelectionController} from "./dist/lib/selectionController";
export {SortController} from "./dist/lib/sortController";
export {TemplateService} from "./dist/lib/templateService";
export {Utils, NumberSequence, _, Promise, ExternalPromise} from "./dist/lib/utils";
export {ValueService} from "./dist/lib/valueService/valueService";
export {ExpressionService} from "./dist/lib/valueService/expressionService";
export {XmlFactory} from "./dist/lib/xmlFactory";
export {GridSerializer, BaseGridSerializingSession, RowType} from "./dist/lib/gridSerializer";
export {CsvExportParams, ExportParams} from "./dist/lib/exportParams"
export {XmlElement} from "./dist/lib/xmlFactory"
export {LoggerFactory} from "./dist/lib/logger";
export {RowAccumulator, RowSpanningAccumulator} from "./dist/lib/gridSerializer"

// uncatalogued
export {IRowModel, RowBounds} from "./dist/lib/interfaces/iRowModel"
export {IAggFuncService} from "./dist/lib/interfaces/iAggFuncService"
export {IClipboardService} from "./dist/lib/interfaces/iClipboardService"
export {IExcelCreator} from "./dist/lib/interfaces/iExcelCreator"
export {IMenuFactory} from "./dist/lib/interfaces/iMenuFactory"
export {IAggFunc, ColGroupDef} from "./dist/lib/entities/colDef"
export {GridCellDef} from "./dist/lib/entities/gridCell"
export {ColDef} from "./dist/lib/entities/colDef"
export {ProcessCellForExportParams, ProcessHeaderForExportParams} from "./dist/lib/exportParams"
export {
    GridOptions,
    GetContextMenuItemsParams,
    GetContextMenuItems,
    GetDataPath,
    MenuItemDef,
    GetNodeChildDetails,
    NodeChildDetails,
    GetMainMenuItemsParams,
    GetMainMenuItems,
    GetRowNodeIdFunc,
    ProcessRowParams,
    NavigateToNextCellParams,
    TabToNextCellParams,
    PostProcessPopupParams
} from "./dist/lib/entities/gridOptions"
export {OriginalColumnGroupChild} from "./dist/lib/entities/originalColumnGroupChild"
export {IViewportDatasource, IViewportDatasourceParams} from "./dist/lib/interfaces/iViewportDatasource"
export {IContextMenuFactory} from "./dist/lib/interfaces/iContextMenuFactory"
export {ICompFactory} from "./dist/lib/interfaces/iCompFactory"
export {IRowNodeStage, StageExecuteParams} from "./dist/lib/interfaces/iRowNodeStage"
export {IFilterParams, IDoesFilterPassParams} from "./dist/lib/interfaces/iFilter"
export {ISetFilterParams, SetFilterValues, SetFilterValuesFunc, SetFilterValuesFuncParams} from "./dist/lib/interfaces/iSetFilterParams"
export {IDateParams, IDate, IDateComp} from "./dist/lib/rendering/dateComponent";
export {IAfterGuiAttachedParams, IComponent} from "./dist/lib/interfaces/iComponent";
export {IFilter, IFilterComp} from "./dist/lib/interfaces/iFilter";
export {IHeaderParams} from "./dist/lib/headerRendering/header/headerComp";
export {GetQuickFilterTextParams} from "./dist/lib/entities/colDef";
export {IHeaderGroupParams, IHeaderGroup} from "./dist/lib/headerRendering/headerGroup/headerGroupComp";
export {TextAndNumberFilterParameters} from "./dist/lib/filter/textAndNumberFilterParameters";
export {IsColumnFunc} from "./dist/lib/entities/colDef";
export {ColumnApi} from "./dist/lib/columnController/columnController";
export {IHeader} from "./dist/lib/headerRendering/header/headerComp";
export {ICellRendererParams} from "./dist/lib/rendering/cellRenderers/iCellRenderer";
export {IRichCellEditorParams} from "./dist/lib/interfaces/iRichCellEditorParams";
export {WrapableInterface} from "./dist/lib/components/framework/frameworkComponentWrapper";
export {BaseComponentWrapper} from "./dist/lib/components/framework/frameworkComponentWrapper";
export {FrameworkComponentWrapper} from "./dist/lib/components/framework/frameworkComponentWrapper";
export {IFrameworkFactory} from "./dist/lib/interfaces/iFrameworkFactory";
export {SerializedNumberFilter} from "./dist/lib/filter/numberFilter";
export {Environment} from "./dist/lib/environment";

// events
export {AgEvent, AgGridEvent, ModelUpdatedEvent, ColumnPivotModeChangedEvent, VirtualColumnsChangedEvent,
    ColumnEverythingChangedEvent, NewColumnsLoadedEvent, GridColumnsChangedEvent, DisplayedColumnsChangedEvent,
    RowDataChangedEvent, RowDataUpdatedEvent, PinnedRowDataChangedEvent, SelectionChangedEvent, FilterChangedEvent,
    FilterModifiedEvent, SortChangedEvent, GridReadyEvent, DragStartedEvent, DragStoppedEvent,
    DisplayedColumnsWidthChangedEvent, ColumnHoverChangedEvent, BodyHeightChangedEvent, ComponentStateChangedEvent,
    GridSizeChangedEvent, ViewportChangedEvent, RangeSelectionChangedEvent, ColumnGroupOpenedEvent, ItemsAddedEvent,
    BodyScrollEvent, FlashCellsEvent, PaginationChangedEvent, CellFocusedEvent, ColumnEvent, ColumnResizedEvent,
    ColumnPivotChangedEvent, ColumnRowGroupChangedEvent, ColumnValueChangedEvent, ColumnMovedEvent, ColumnVisibleEvent,
    ColumnPinnedEvent, RowEvent, RowGroupOpenedEvent, RowValueChangedEvent, RowSelectedEvent, VirtualRowRemovedEvent,
    RowClickedEvent, RowDoubleClickedEvent, RowEditingStartedEvent, RowEditingStoppedEvent, CellEvent, CellClickedEvent,
    CellDoubleClickedEvent, CellMouseOverEvent, CellMouseOutEvent, CellContextMenuEvent, CellEditingStartedEvent,
    CellEditingStoppedEvent, CellValueChangedEvent, ColumnRequestEvent, ColumnRowGroupChangeRequestEvent,
    ColumnPivotChangeRequestEvent, ColumnValueChangeRequestEvent, ColumnAggFuncChangeRequestEvent, ScrollVisibilityChangedEvent}
    from "./dist/lib/events";
