<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9"> <![endif]-->
<!--[if !IE]><!--> <html lang="en"> <!--<![endif]-->
<!-- BEGIN HEAD -->
<head>
	<meta charset="utf-8" />
	<title>Verisure | VeriSmart</title>
	<meta content="width=device-width, initial-scale=1.0" name="viewport" />
	<meta content="" name="description" />
	<meta content="" name="author" />
        
	<!-- BEGIN GLOBAL MANDATORY STYLES -->
    <link rel="icon" type="image/png" href="../admin/dist/img/-apple-touch-icon-144x144.png" >
	<link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
	<link href="assets/plugins/bootstrap/css/bootstrap-responsive.min.css" rel="stylesheet" type="text/css"/>
	<link href="assets/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
	<link href="assets/css/style-metro.css" rel="stylesheet" type="text/css"/>

	<link href="assets/css/style.css" rel="stylesheet" type="text/css"/>
	<link href="assets/css/style-responsive.css" rel="stylesheet" type="text/css"/>
	<link href="assets/css/themes/default.css" rel="stylesheet" type="text/css" id="style_color"/>
	<!-- END GLOBAL MANDATORY STYLES -->
	<!-- BEGIN PAGE LEVEL STYLES -->
	<link href="assets/css/pages/login-soft.css" rel="stylesheet" type="text/css"/>
	<!-- END PAGE LEVEL STYLES -->
    <style>
        .center {
            max-width: 100%;
            vertical-align: middle;
            border: 0;
            display: block;
            margin-left: auto;
            margin-right: auto;
            width: 60%;
        }
    </style>

    </head>
    <!-- END HEAD -->
    <!-- BEGIN BODY -->
    <body class="login">
    	<!-- BEGIN LOGO -->
    	<div class="logo">
    		<!-- PUT YOUR LOGO HERE -->
            <img src="../admin/dist/img/logo_nuevo_rojo.png" alt="">
    	</div>
    	<!-- END LOGO -->
	    <!-- BEGIN LOGIN -->
	    <div class="content">
		    <!-- BEGIN LOGIN FORM -->
		    <form class="form-vertical login-form"  method="post">
			    <h3 class="form-title">Iniciar sesión</h3>
			    <div class="alert alert-error hide">
				    <button class="close" data-dismiss="alert"></button>
				    <span>Ingrese usuario y contraseña.</span>
			    </div>
                <div id="result"></div>
                        
    			<div class="control-group">
    				<!--ie8, ie9 does not support html5 placeholder, so we just show field title for that-->
    				<label class="control-label visible-ie8 visible-ie9">Usuario</label>
    				<div class="controls">
    					<div class="input-icon left">
    						<i class="icon-user"></i>
    						<input class="m-wrap placeholder-no-fix" type="text" autocomplete="off" placeholder="Usuario" name="username" maxlength="30" onkeypress="return ((event.charCode >= 48 && event.charCode <= 57) || (event.charCode >= 97 && event.charCode <= 122) || (event.charCode == 46))"/>
    					</div>
    				</div>
    			</div>
    			<div class="control-group">
    				<label class="control-label visible-ie8 visible-ie9">Contraseña</label>
    				<div class="controls">
    					<div class="input-icon left">
    						<i class="icon-lock"></i>
    						<input class="m-wrap placeholder-no-fix" type="password" autocomplete="off" placeholder="Contraseña" name="password" maxlength="20" />
    					</div>
    				</div>
    			</div>
			    <div class="form-actions">
                    <button type="submit" class="btn red pull-right" id="btnAcceder">Acceder <i class="m-icon-swapright m-icon-white"></i></button>          
                </div>
                <!--
        			<div class="forget-password">
        				<p>
        					Iniciar sesion con <a style="color:red" href="../saml"  id="">Office 365</a>
        				</p>
        			</div>
               -->
		    </form>
		    <!-- END LOGIN FORM -->
    		<!-- BEGIN FORGOT PASSWORD FORM --> 
    		<form class="form-vertical forget-form" method="post">
    			<h3>Restaurar contraseña</h3>
    			<p>Te solicitaremos restablecer la contraseña para prevenir el acceso no autorizado.<a style="color: #fff !important;" data-toggle="modal" data-target="#verinfo">(<i class="icon-info"></i>)</a> </p>
                <div class="alert alert-error hide">
    				<button class="close" data-dismiss="alert"></button>
                    <span>Password incorrecto,Su password debe tener al menos:\n</span>
    			</div>
                <div id="result_c"></div>
    			<div class="control-group">
    				<label class="control-label visible-ie8 visible-ie9">Nuevo Password</label>
    				<div class="controls">
    					<div class="input-icon left">
    						<i class="icon-lock"></i>
                            <input class="m-wrap placeholder-no-fix" type="password" autocomplete="off" id="register_password" placeholder="Nuevo Password" name="npassword"/>
                            <input type="hidden" autocomplete="off" id="u" name="u"/>
    					</div>
    				</div>
    			</div>
    			<div class="control-group">
    				<label class="control-label visible-ie8 visible-ie9">Repetir Password</label>
    				<div class="controls">
    					<div class="input-icon left">
    						<i class="icon-ok"></i>
    						<input class="m-wrap placeholder-no-fix" type="password" autocomplete="off" id="repetir_password" placeholder="Repetir Password" name="rpassword"/>
    					</div>
    				</div>
    			</div>
    			<div class="form-actions">
    				<button type="button" id="back-btn" class="btn">
    				<i class="m-icon-swapleft"></i> Regresar
    				</button>
    				<button type="submit" class="btn red pull-right">
    				    Guardar <i class="m-icon-swapright m-icon-white"></i>
    				</button>         
    			</div>
    		</form>
    
            <div class="modal fade bs-modal-sm" id="verinfo" role="basic" style="display:none;">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style=" color:#fff;background:#e4002b">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                            <h3 class="modal-title">CAMBIO DE CONTRASEÑA</h3>
                        </div>
                        <div class="modal-body">
                            <form id="frmPasswrod" method="POST">
                                <img src="../admin/dist/img/verismart-logo_trans.png" class="center">
                                <table  cellspacing="0"  style="width:100%;border-collapse: separate;border: #dfdfdf 1px solid;border-radius: 5px; padding-top: 40px;padding-right: 20px;padding-bottom: 40px;padding-left: 20px;" >
                                    <tr>
                                        <td  style="font-size: 16px">Su contraseña debe tener al menos: </td>
                                    </tr>
                                    <tr>
                                        <td style="font-size: 16px">
                                            <span style="color:red"><i class="icon-check"></i></span> Entre 10 a más caracteres
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="font-size: 16px">   
                                            <span style="color:red"><i class="icon-check"></i></span> 1 letra(s) en minúscula y al menos 1 letra(s) en MAYÚSCULA
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="font-size: 16px">
                                            <span style="color:red"><i class="icon-check"></i></span> 1 dígito(s) y un carácter especial (@,-,*,.,%...)
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="font-size: 16px">
                                            <span style="color:red"><i class="icon-check"></i></span> No puede coincidir con ninguna de las 3 últimas utilizadas
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="font-size: 16px">
                                            <span style="color:red"><i class="icon-check"></i></span> No puede contener su nombre o apellido
                                        </td>
                                    </tr>
                                </table>
                            </form>
                            <div class="espacio"></div>
                        </div>
                    </div>  
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>
            <!-- /.modal -->
    		<!-- END FORGOT PASSWORD FORM -->
	    </div>
	    <!-- END LOGIN -->
	    <!-- BEGIN COPYRIGHT -->
	    <div class="copyright">
            2020 &copy; Verisure Per&uacute; SAC - VeriSmart v.1.0
	    </div>
	    <!-- END COPYRIGHT -->
    	<!-- BEGIN JAVASCRIPTS(Load javascripts at bottom, this will reduce page load time) -->
    	<!-- BEGIN CORE PLUGINS -->
        <script src="assets/plugins/jquery-1.10.1.min.js" type="text/javascript"></script>
    	<script src="assets/plugins/jquery-migrate-1.2.1.min.js" type="text/javascript"></script>
    	<!-- IMPORTANT! Load jquery-ui-1.10.1.custom.min.js before bootstrap.min.js to fix bootstrap tooltip conflict with jquery ui tooltip -->
    	<script src="assets/plugins/jquery-ui/jquery-ui-1.10.1.custom.min.js" type="text/javascript"></script>      
    	<script src="assets/plugins/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
    	<!--[if lt IE 9]>
    	<script src="assets/plugins/excanvas.min.js"></script>
    	<script src="assets/plugins/respond.min.js"></script>  
    	<![endif]-->   
    	<script src="assets/plugins/jquery-slimscroll/jquery.slimscroll.min.js" type="text/javascript"></script>
    	<script src="assets/plugins/jquery.blockui.min.js" type="text/javascript"></script>  
    	<script src="assets/plugins/jquery.cookie.min.js" type="text/javascript"></script>
    	<!-- END CORE PLUGINS -->
    	<!-- BEGIN PAGE LEVEL PLUGINS -->
    	<script src="assets/plugins/jquery-validation/dist/jquery.validate.min.js" type="text/javascript"></script>
    	<script src="assets/plugins/backstretch/jquery.backstretch.min.js" type="text/javascript"></script>
    	<!-- END PAGE LEVEL PLUGINS -->
    	<!-- BEGIN PAGE LEVEL SCRIPTS -->
    	<script src="assets/scripts/app.js" type="text/javascript"></script>
    	<script src="assets/scripts/login-soft.js" type="text/javascript"></script>      
    	<!-- END PAGE LEVEL SCRIPTS --> 
        
        <!-- SCRIPT ACCIONES -->
        <script>
            $('#btnAcceder').click(function () {
               handleLogin();
            });
            
            jQuery('#forget-pass').click(function () {
                jQuery('.login-form').hide();
                jQuery('.forget-form').show();
            });
    
            jQuery('#back-btn').click(function () {
                jQuery('.login-form').show();
                jQuery('.forget-form').hide();
            });
            
        </script>
        <!-- FUNCIONES -->
        <script>
            function handleLogin() {
                $('.login-form').validate({
    	            errorElement: 'label', //default input error message container
    	            errorClass: 'help-inline', // default input error message class
    	            focusInvalid: false, // do not focus the last invalid input
    	            rules: {
    	                username: {
    	                    required: true
    	                },
    	                password: {
    	                    required: true
    	                }
    	            },
    
    	            messages: {
    	                username: {
    	                    required: "Usuario es requerido."
    	                },
    	                password: {
    	                    required: "Password es requerido."
    	                }
    	            },
    
    	            invalidHandler: function (event, validator) { //display error alert on form submit   
    	                $("#result").html('<div class="alert alert-error">\n\
                                    <button class="close" data-dismiss="alert">\n\
                                       </button><span>Ingrese usuario y contraseña.\n\
                                        </span></div>'); 
                            
                            
    	            },
    
    	            highlight: function (element) { // hightlight error inputs
    	                $(element)
    	                    .closest('.control-group').addClass('error'); // set error class to the control group
    	            },
    
    	            success: function (label) {
    	                label.closest('.control-group').removeClass('error');
    	                label.remove();
    	            },
    
    	            errorPlacement: function (error, element) {
    	                error.addClass('help-small no-left-padding').insertAfter(element.closest('.input-icon'));
    	            },
    
    	            submitHandler: function (form) {
                             
    	            var datos = $('.login-form').serialize();
                        $.ajax({
                            type: 'POST',
                            url: '../ajax/Login_v2.php',
                            data:  datos,
                            success: function (data) {
                              $("#result").html(data); 
                            }
                        });
    	            }
    	        });
    
    	        $('.login-form input').keypress(function (e) {
    	            if (e.which == 13) {
    	                if ($('.login-form').validate().form()) {
    	                    $('.login-form').submit();
    	                }
    	                return false;
    	            }
    	        });
            }
            
            function handleForgetPassword(){
                $('.forget-form').validate({
	            errorElement: 'label', //default input error message container
	            errorClass: 'help-inline', // default input error message class
	            focusInvalid: false, // do not focus the last invalid input
	            ignore: "",
	            rules: {

                        npassword: {
	                    required: true
	                },
	                rpassword: {
	                    required: true
	                }
	            },

	            messages: {

                        npassword: {
	                    required: "Nuevo Password es requerido."
	                },
	                rpassword: {
	                    required: "Repetir Password es requerido."
	                }
	            },

	            invalidHandler: function (event, validator) { 

                    $("#result_c").html('<div class="alert alert-error" id="mensajec">\n\
                                <button class="close" data-dismiss="alert">\n\
                                   </button><span>Ingrese nueva contraseña.\n\
                                    </span></div>'); 
                        
	            },

	            highlight: function (element) { // hightlight error inputs
	                $(element)
	                    .closest('.control-group').addClass('error'); // set error class to the control group
	            },

	            success: function (label) {
	                label.closest('.control-group').removeClass('error');
	                label.remove();
	            },

	            errorPlacement: function (error, element) {
	                error.addClass('help-small no-left-padding').insertAfter(element.closest('.input-icon'));
	            },

	            submitHandler: function (form) {
	        var frpass = $('.forget-form').serialize();
                  if(validar_clave()){
                    $.ajax({
                        type: 'POST',
                        url: '../ajax/updateLoginPassword_copia.php',
                        data:  frpass,
                        success: function (result) {
                           if(result==1){
                        $("#result").html('<div class="alert alert-success">\n\
                                <button class="close" data-dismiss="alert">\n\
                                   </button><span>Modificado con éxito.\n\
                                    </span></div>'); 
                        $('.login-form').show();
	                $('.forget-form').hide();
                        $('.login-form')[0].reset();
                       }else if(result==2){
                        $("#result_c").html('<div class="alert alert-error" id="mensajec">\n\
                         <button class="close" data-dismiss="alert">\n\
                                   </button><span>Ya se registro esta contraseña, vuelva a colocar otra.\n\
                                    </span></div>'); 

                       }
                         
                        }
                    });
        }
	            }
	        });
	        
                $('.forget-form input').keypress(function (e) {
    	            if (e.which == 13) {
    	                if ($('.forget-form').validate().form()) {
    	                    $('.forget-form').submit();
    	                }
    	                return false;
    	            }
    	        });
    
    	        jQuery('#forget-password').click(function () {
    	            jQuery('.login-form').hide();
    	            jQuery('.forget-form').show();
    	        });
    
    	        jQuery('#back-btn').click(function () {
    	            jQuery('.login-form').show();
    	            jQuery('.forget-form').hide();
                        jQuery('.login-form')[0].reset();
                        $("#mensaje").toggleClass("hide");  
    	        });
            }
            
            function loging(u){
                $('.forget-form')[0].reset();
                $('.login-form').hide();
                $('.forget-form').show();
                $('#u').val(u);
                $("#mensajec").toggleClass("hide"); 
            }
            
            function validar_clave(){
                if($(".forget-form #register_password").val() == ""){
                    $("#result_c").html('<div class="alert alert-error" id="mensajec">\n\
                                        <button class="close" data-dismiss="alert">\n\
                                           </button><span>Por favor ingresar los datos.\n\
                                            </span></div>'); 
                      return false;
                }
                if($(".forget-form #register_password").val().length  <= 9){
        
                    $("#result_c").html('<div class="alert alert-error" id="mensajec">\n\
                                        <button class="close" data-dismiss="alert">\n\
                                       </button><span>La clave debe tener al menos 10 caracteres.\n\
                                        </span></div>'); 
                    return false;
                }
                if (!/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[$@$!%*?&-\u002E])([A-Za-z\d$@$!%*?&-\u002E]|[^ ]){10,50}$/i.test($(".forget-form #register_password").val())){
                    $("#result_c").html('<div class="alert alert-error" id="mensajec">\n\
                                    <button class="close" data-dismiss="alert">\n\
                                       </button><span>La contraseña debe tener al menos 10 caracteres, 1 letra(s) en minúscula y al menos 1 letra(s) en MAYÚSCULA, 1 dígito(s) y un carácter especial (. , @, $, %,*,..).\n\<br> No puede coincidir con ninguna de las 3 últimas utilizadas.\n\ No puede contener su nombre o apellido\n\
                                        </span></div>'); 
    
                    return false;
                }
                if ( $(".forget-form #register_password").val()!=$(".forget-form #repetir_password").val() ){
                    $("#result_c").html('<div class="alert alert-error" id="mensajec">\n\
                                    <button class="close" data-dismiss="alert">\n\
                                       </button><span>Las contraseñas no coincide.\n\
                                        </span></div>'); 
                    return false;
                }
                return true;
            }
            
        </script>
        <!-- DOCUMENT READY -->
    	<script>
            $(document).ready(function() {
                handleForgetPassword();
    		    App.init();
    		    //CAMBIO DE FONDO
                $.backstretch(["assets/img/bg/verisure_1.jpg", "assets/img/bg/verisure_2.jpg", "assets/img/bg/verisure_3.jpg"], {fade: 1000,duration: 8000});
    		});
    	</script>
    	<!-- END JAVASCRIPTS -->
    </body>
<!-- END BODY -->
</html>