<?php

namespace Kendo\UI;

class EditorMessages extends \Kendo\SerializableObject {
//>> Properties

    /**
    * The title of the Accessibility in the Table Wizard dialog.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function accessibilityTab($value) {
        return $this->setProperty('accessibilityTab', $value);
    }

    /**
    * The title of the tool that adds table columns on the left of the selection.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function addColumnLeft($value) {
        return $this->setProperty('addColumnLeft', $value);
    }

    /**
    * The title of the tool that adds table columns on the right of the selection.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function addColumnRight($value) {
        return $this->setProperty('addColumnRight', $value);
    }

    /**
    * The title of the tool that adds table rows above the selection.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function addRowAbove($value) {
        return $this->setProperty('addRowAbove', $value);
    }

    /**
    * The title of the tool that adds table rows below the selection.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function addRowBelow($value) {
        return $this->setProperty('addRowBelow', $value);
    }

    /**
    * The title of the tool that aligns the cell text.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function alignCenter($value) {
        return $this->setProperty('alignCenter', $value);
    }

    /**
    * The title of the tool that aligns the cell text.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function alignCenterBottom($value) {
        return $this->setProperty('alignCenterBottom', $value);
    }

    /**
    * The title of the tool that aligns the cell text.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function alignCenterMiddle($value) {
        return $this->setProperty('alignCenterMiddle', $value);
    }

    /**
    * The title of the tool that aligns the cell text.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function alignCenterTop($value) {
        return $this->setProperty('alignCenterTop', $value);
    }

    /**
    * The title of the tool that aligns the cell text.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function alignLeft($value) {
        return $this->setProperty('alignLeft', $value);
    }

    /**
    * The title of the tool that aligns the cell text.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function alignLeftBottom($value) {
        return $this->setProperty('alignLeftBottom', $value);
    }

    /**
    * The title of the tool that aligns the cell text.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function alignLeftMiddle($value) {
        return $this->setProperty('alignLeftMiddle', $value);
    }

    /**
    * The title of the tool that aligns the cell text.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function alignLeftTop($value) {
        return $this->setProperty('alignLeftTop', $value);
    }

    /**
    * The title of the tool that removes the cell text's alignment.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function alignRemove($value) {
        return $this->setProperty('alignRemove', $value);
    }

    /**
    * The title of the tool that aligns the cell text.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function alignRight($value) {
        return $this->setProperty('alignRight', $value);
    }

    /**
    * The title of the tool that aligns the cell text.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function alignRightBottom($value) {
        return $this->setProperty('alignRightBottom', $value);
    }

    /**
    * The title of the tool that aligns the cell text.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function alignRightMiddle($value) {
        return $this->setProperty('alignRightMiddle', $value);
    }

    /**
    * The title of the tool that aligns the cell text.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function alignRightTop($value) {
        return $this->setProperty('alignRightTop', $value);
    }

    /**
    * The title of the tool that aligns the cell text.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function alignment($value) {
        return $this->setProperty('alignment', $value);
    }

    /**
    * The title of the Associate cells with headers tool.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function associateCellsWithHeaders($value) {
        return $this->setProperty('associateCellsWithHeaders', $value);
    }

    /**
    * The title of the tool that changes the text background color.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function backColor($value) {
        return $this->setProperty('backColor', $value);
    }

    /**
    * The title of the tool that changes the text background of the tables/cells.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function background($value) {
        return $this->setProperty('background', $value);
    }

    /**
    * The title of the tool that makes text bold.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function bold($value) {
        return $this->setProperty('bold', $value);
    }

    /**
    * The title of the tool that changes the border of tables.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function border($value) {
        return $this->setProperty('border', $value);
    }

    /**
    * The title of the tool that applies styling to elements. Deprecated.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function style($value) {
        return $this->setProperty('style', $value);
    }

    /**
    * The title of the tool that adds caption to tables.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function caption($value) {
        return $this->setProperty('caption', $value);
    }

    /**
    * The title of the tool that applies margin to table cells.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function cellMargin($value) {
        return $this->setProperty('cellMargin', $value);
    }

    /**
    * The title of the tool that applies padding to table cells.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function cellPadding($value) {
        return $this->setProperty('cellPadding', $value);
    }

    /**
    * The title of the tool that applies spacing to table cells.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function cellSpacing($value) {
        return $this->setProperty('cellSpacing', $value);
    }

    /**
    * The title of the Cell tab in Table Wizard dialog.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function cellTab($value) {
        return $this->setProperty('cellTab', $value);
    }

    /**
    * The title of the Clean Formatting tool.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function cleanFormatting($value) {
        return $this->setProperty('cleanFormatting', $value);
    }

    /**
    * The title of the Collapse borders option in Table Wizard.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function collapseBorders($value) {
        return $this->setProperty('collapseBorders', $value);
    }

    /**
    * The title of the Columns tool in Table Wizard.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function columns($value) {
        return $this->setProperty('columns', $value);
    }

    /**
    * The title of the tool that creates hyperlinks.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function createLink($value) {
        return $this->setProperty('createLink', $value);
    }

    /**
    * The title of the tool that inserts tables.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function createTable($value) {
        return $this->setProperty('createTable', $value);
    }

    /**
    * The status text of the tool that inserts tables, which indicates the dimensions of the inserted table.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function createTableHint($value) {
        return $this->setProperty('createTableHint', $value);
    }

    /**
    * The title of the CSS Class dropdown tool.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function cssClass($value) {
        return $this->setProperty('cssClass', $value);
    }

    /**
    * The title of the tool that deletes selected table columns.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function deleteColumn($value) {
        return $this->setProperty('deleteColumn', $value);
    }

    /**
    * The title of the tool that deletes selected table rows.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function deleteRow($value) {
        return $this->setProperty('deleteRow', $value);
    }

    /**
    * The label of the cancel button in all editor dialogs.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function dialogCancel($value) {
        return $this->setProperty('dialogCancel', $value);
    }

    /**
    * The label of the insert button in all editor dialogs.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function dialogInsert($value) {
        return $this->setProperty('dialogInsert', $value);
    }

    /**
    * The title of the OK buttons in editor's dialogs.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function dialogOk($value) {
        return $this->setProperty('dialogOk', $value);
    }

    /**
    * The label of the update button in all editor dialogs.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function dialogUpdate($value) {
        return $this->setProperty('dialogUpdate', $value);
    }

    /**
    * The title of the iframe editing area when a sandboxed editor is used. Used as a hint for screen readers.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function editAreaTitle($value) {
        return $this->setProperty('editAreaTitle', $value);
    }

    /**
    * The caption for the file title in the insertFile dialog.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function fileTitle($value) {
        return $this->setProperty('fileTitle', $value);
    }

    /**
    * The caption for the file URL in the insertFile dialog.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function fileWebAddress($value) {
        return $this->setProperty('fileWebAddress', $value);
    }

    /**
    * The title of the tool that changes the text font.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function fontName($value) {
        return $this->setProperty('fontName', $value);
    }

    /**
    * The text that is shown when the text font will be inherited from the surrounding page.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function fontNameInherit($value) {
        return $this->setProperty('fontNameInherit', $value);
    }

    /**
    * The title of the tool that changes the text size.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function fontSize($value) {
        return $this->setProperty('fontSize', $value);
    }

    /**
    * The text that is shown when the text size will be inherited from the surrounding page.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function fontSizeInherit($value) {
        return $this->setProperty('fontSizeInherit', $value);
    }

    /**
    * The title of the tool that changes the text color.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function foreColor($value) {
        return $this->setProperty('foreColor', $value);
    }

    /**
    * The title of the tool that lets users choose block formats. Deprecated.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function formatBlock($value) {
        return $this->setProperty('formatBlock', $value);
    }

    /**
    * The title of the tool that lets users choose block formats.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function formatting($value) {
        return $this->setProperty('formatting', $value);
    }

    /**
    * The title of the height fields.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function height($value) {
        return $this->setProperty('height', $value);
    }

    /**
    * The title of the id fields.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function id($value) {
        return $this->setProperty('id', $value);
    }

    /**
    * The caption for the image alternate text in the insertImage dialog.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function imageAltText($value) {
        return $this->setProperty('imageAltText', $value);
    }

    /**
    * The caption for the image height in the insertImage dialog.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function imageHeight($value) {
        return $this->setProperty('imageHeight', $value);
    }

    /**
    * The caption for the image URL in the insertImage dialog.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function imageWebAddress($value) {
        return $this->setProperty('imageWebAddress', $value);
    }

    /**
    * The caption for the image width in the insertImage dialog.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function imageWidth($value) {
        return $this->setProperty('imageWidth', $value);
    }

    /**
    * The title of the tool that indents the content.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function indent($value) {
        return $this->setProperty('indent', $value);
    }

    /**
    * The title of the tool that inserts links to files.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function insertFile($value) {
        return $this->setProperty('insertFile', $value);
    }

    /**
    * The title of the tool that inserts HTML snippets.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function insertHtml($value) {
        return $this->setProperty('insertHtml', $value);
    }

    /**
    * The title of the tool that inserts images.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function insertImage($value) {
        return $this->setProperty('insertImage', $value);
    }

    /**
    * The title of the tool that inserts an ordered list.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function insertOrderedList($value) {
        return $this->setProperty('insertOrderedList', $value);
    }

    /**
    * The title of the tool that inserts an unordered list.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function insertUnorderedList($value) {
        return $this->setProperty('insertUnorderedList', $value);
    }

    /**
    * The title of the tool that makes text italicized.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function italic($value) {
        return $this->setProperty('italic', $value);
    }

    /**
    * The title of the tool that shows the overflow tools.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function overflowAnchor($value) {
        return $this->setProperty('overflowAnchor', $value);
    }

    /**
    * The title of the tool that aligns text in the center.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function justifyCenter($value) {
        return $this->setProperty('justifyCenter', $value);
    }

    /**
    * The title of the tool that justifies text both left and right.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function justifyFull($value) {
        return $this->setProperty('justifyFull', $value);
    }

    /**
    * The title of the tool that aligns text on the left.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function justifyLeft($value) {
        return $this->setProperty('justifyLeft', $value);
    }

    /**
    * The title of the tool that aligns text on the right.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function justifyRight($value) {
        return $this->setProperty('justifyRight', $value);
    }

    /**
    * The caption for the checkbox for opening the link in a new window in the createLink dialog.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function linkOpenInNewWindow($value) {
        return $this->setProperty('linkOpenInNewWindow', $value);
    }

    /**
    * The caption for the link text in the createLink dialog.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function linkText($value) {
        return $this->setProperty('linkText', $value);
    }

    /**
    * The caption for the link Tooltip in the createLink dialog.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function linkToolTip($value) {
        return $this->setProperty('linkToolTip', $value);
    }

    /**
    * The caption for the URL in the createLink dialog.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function linkWebAddress($value) {
        return $this->setProperty('linkWebAddress', $value);
    }

    /**
    * The title of the tool that outdents the content.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function outdent($value) {
        return $this->setProperty('outdent', $value);
    }

    /**
    * The title of the Print tool.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function _print($value) {
        return $this->setProperty('print', $value);
    }

    /**
    * The title of the Rows field in Table Wizard.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function rows($value) {
        return $this->setProperty('rows', $value);
    }

    /**
    * The title of the Select All Cells tool.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function selectAllCells($value) {
        return $this->setProperty('selectAllCells', $value);
    }

    /**
    * The title of the tool that strikes through text.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function strikethrough($value) {
        return $this->setProperty('strikethrough', $value);
    }

    /**
    * The title of the tool that makes text subscript.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function subscript($value) {
        return $this->setProperty('subscript', $value);
    }

    /**
    * The title of the Summary field in Table Wizard.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function summary($value) {
        return $this->setProperty('summary', $value);
    }

    /**
    * The title of the tool that makes text superscript.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function superscript($value) {
        return $this->setProperty('superscript', $value);
    }

    /**
    * The title of the Table tab in Table Wizard.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function tableTab($value) {
        return $this->setProperty('tableTab', $value);
    }

    /**
    * The title of the Table Wizard tool.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function tableWizard($value) {
        return $this->setProperty('tableWizard', $value);
    }

    /**
    * The title of the tool that underlines text.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function underline($value) {
        return $this->setProperty('underline', $value);
    }

    /**
    * The label of the Units dropdowns in TableWizard dialog.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function units($value) {
        return $this->setProperty('units', $value);
    }

    /**
    * The title of the tool that removes hyperlinks.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function unlink($value) {
        return $this->setProperty('unlink', $value);
    }

    /**
    * The title of the tool that shows the editor value as HTML.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function viewHtml($value) {
        return $this->setProperty('viewHtml', $value);
    }

    /**
    * The title of the Width fields.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function width($value) {
        return $this->setProperty('width', $value);
    }

    /**
    * The title of the Wrap Text option in Table Wizard.
    * @param string $value
    * @return \Kendo\UI\EditorMessages
    */
    public function wrapText($value) {
        return $this->setProperty('wrapText', $value);
    }

//<< Properties
}

?>
