const contenedor = document.querySelector('#tblVentas tbody');

function cargarDatos() {
    var mesvisita=document.getElementById("lblmesvisit").value;  
    data = {mesvisita: mesvisita};
    
    fetch('./ajax/dataDashboardVisita.php', {method: 'POST', body: JSON.stringify(data)})
        .then(function(res) {
            return res.json();
        })
        .then(function(datos) {
            for (let [llave, valor] of Object.entries(datos)){
                const row = document.createElement('tr');
                row.style = "height:1vw!important";
                if(llave != 'Totales'){
                    
                    row.innerHTML = `
                        <td class="tblBody text-left">
                            ${valor.Delegacion.Id} - ${valor.Delegacion.Titulo} - ${valor.Delegacion.Delegado}
                        </td>
                        <td class="tblBody text-center">
                            ${valor.Visitas}
                        </td>
                        <td class="tblBody text-center">
                            ${valor.VisitasAsignadas}
                        </td>
                        <td class="tblBody text-center">
                            ${valor.VisitasAnuladasOP}
                        </td>
                        <td class="tblBody text-center">
                            ${valor.VisitasAnuladasTEC}
                        </td>
                        <td class="tblBody text-center">
                            ${valor.VisitasAnuladasCLI}
                        </td>
                        <td class="tblBody text-center">
                            ${valor.VisitasVenta}
                        </td>
                        <td class="tblBody text-center">
                            ${valor.VisitasNoVenta}
                        </td>
                        <td></td>
                        <td class="tblBody text-center">
                            ${valor.VisitasReAsignadas}
                        </td>
                        <td class="tblBody text-center">
                            ${valor.VisitasReAsignadasActual}
                        </td>
                        <td class="tblBody text-center">
                            ${valor.VisitasCheckIN}
                        </td>
                        <td class="tblBody text-center tblBodyNumber">
                            ${valor.PorcentajeCheckIN} %
                        </td>
                    `;
                    //Agrega el HTML del carrito en el tbody 
                    contenedor.appendChild(row);
                    switch(true){
                        case valor.PorcentajeCheckIN >= 90:
                            row.lastElementChild.style.background = 'green';
                            break;
                        case valor.PorcentajeCheckIN >= 75 && valor.PorcentajeCheckIN < 90:
                            row.lastElementChild.style.background = '#FFC300';
                            break;
                        default:
                            row.lastElementChild.style.background = 'red';
                            break;
                    }
                    
                    
                    //console.log();
                } else {
                    row.style = "height:2vw!important;";
                    row.innerHTML = `
                        <td class="tblBody text-center tblFooter tblBodyNumber">PERU</td>
                        <td class="tblBody text-center tblFooter tblBodyNumber">${valor.TotalVisitas}</td>
                        <td class="tblBody text-center tblFooter tblBodyNumber">${valor.TotalVisitasAsignadas}</td>
                        <td class="tblBody text-center tblFooter tblBodyNumber">${valor.TotalVisitasAnuladasOP}</td>
                        <td class="tblBody text-center tblFooter tblBodyNumber">${valor.TotalVisitasAnuladasTEC}</td>
                        <td class="tblBody text-center tblFooter tblBodyNumber">${valor.TotalVisitasAnuladasCLI}</td>
                        <td class="tblBody text-center tblFooter tblBodyNumber">${valor.TotalVisitasVenta}</td>
                        <td class="tblBody text-center tblFooter tblBodyNumber">${valor.TotalVisitasNoVenta}</td>
                        <td></td>
                        <td class="tblBody text-center tblFooter tblBodyNumber">${valor.TotalVisitasReAsignadas}</td>
                        <td class="tblBody text-center tblFooter tblBodyNumber">${valor.TotalVisitasReAsignadasActual}</td>
                        <td class="tblBody text-center tblFooter tblBodyNumber">${valor.TotalVisitasCheckIN}</td>
                        <td class="tblBody text-center tblBodyNumber ">${valor.TotalPorcentajeCheckIN} %</td>
                    
                    `;
                    //Agrega el HTML del carrito en el tbody
                    contenedor.appendChild(row);
                    switch(true){
                        case valor.TotalPorcentajeCheckIN >= 90:
                            row.lastElementChild.style.background = 'green';
                            break;
                        case valor.TotalPorcentajeCheckIN >= 75 && valor.TotalPorcentajeCheckIN < 90:
                            row.lastElementChild.style.background = '#FFC300';
                            break;
                        default:
                            row.lastElementChild.style.background = 'red';
                            break;
                    }
                }
                
            }
        })
        .catch(function(error) {
            console.log(error);
        })
}

$(document).ready(function () {
    
    $('#lblmesvisit').datepicker({
        autoclose: true,
        language: 'en',
        firstDay: 1, format: 'M-yyyy',
        viewMode: "years",
        minViewMode: "months"
    }).datepicker("setDate", new Date());

    $('#mesano').datepicker({
        autoclose: true,
        language: 'en',
        firstDay: 1, format: 'M-yyyy',
        viewMode: "years",
        minViewMode: "months"
    
    });
});

    $("#lblmesvisit").on("change", function(){
        $('#divLoading').show();
        limpiarHTML();
        cargarDatos();
        setTimeout(() => {$('#divLoading').hide();} , 2000);
        
    });
//Elimina los cursos del tbody
function limpiarHTML() {
    //forma lenta
    //contenedorCarrito.innerHTML = '';

    //forma recomendada
    while (contenedor.firstChild) {
        contenedor.removeChild(contenedor.firstChild);
    }
}

