<?php
    
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
    }
    
    date_default_timezone_set('America/Lima');
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }
    
    include 'config/db.php';
    include 'config/conexion.php';
    
?>

<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
       <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <link href="//cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.37/css/bootstrap-datetimepicker.css" rel="stylesheet"/>
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <!-- DataTables -->
        <link rel="stylesheet" href="admin/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
        <!-- Toogle -->
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
        <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css"/>
        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>


        <style>

            .tbinput {
                background: none!important;
                border: none;
                -webkit-appearance: none;
            }

            .classMantenimiento, .ClsLlamada, .clsInfoCTz, .clsNInt, .clsNIntMot, .clsNProc{
                display: none;
            }

            .ocultar {
                display: none;
            }

            .selected{
                background-color: #e0e0e0;
            }

            .subtitulo{
                text-decoration: underline;
                font-weight: bold;
            }

            label{
                font-weight: normal;
                font-size: 12px;
                text-align: left!important;
            }

            .botonTabla{
                background:none;
                border:none;
                display: none;
            }

            .swal2-popup{
                font-size: 1.5rem!important;
            }

            .swal2-styled.swal2-confirm{
                background-color: #e4002b!important;
            }

            .bordeRojo{
                border: 1px solid #e4002b;
            }

            .obligatorio{
                display: none;
                color: red;
            }

            .derecha{
                text-align: right;
            }

            #tinviable, #tinviableespacio, #tcanceladoespacio, #tcancelado{
                display: none;
            }

            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;
            }


            .preloader{
                background-color:#FFF;
                width: 100%;
                height: 100%;
                position: absolute;
                z-index: 1;
            }

            .dataTables_wrapper .myfilter .dataTables_filter{float:left}
            .dataTables_wrapper .mylength .dataTables_length{float:right}
            div.dataTables_scrollBody thead th {
                vertical-align: top;
            }
            td {
                max-width: 250px;
                overflow: hidden;
                white-space: nowrap;
                text-overflow: ellipsis;

            }
            .espacio{
                height:10px;
            }

           .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #frmEditarVenta .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }
            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo {
                color: #FFFFFF;
                background-color: #444444;
                border-color: #444444;
            }

            .btn-nuevo:hover,
            .btn-nuevo:focus,
            .btn-nuevo:active,
            .btn-nuevo.active,
            .open .dropdown-toggle.btn-nuevo {
                color: #FFFFFF;
                background-color: #616161;
                border-color: #444444;
            }

            .btn-nuevo:active,
            .btn-nuevo.active,
            .open .dropdown-toggle.btn-nuevo {
                background-image: none;
            }

            .btn-nuevo.disabled,
            .btn-nuevo[disabled],
            fieldset[disabled] .btn-nuevo,
            .btn-nuevo.disabled:hover,
            .btn-nuevo[disabled]:hover,
            fieldset[disabled] .btn-nuevo:hover,
            .btn-nuevo.disabled:focus,
            .btn-nuevo[disabled]:focus,
            fieldset[disabled] .btn-nuevo:focus,
            .btn-nuevo.disabled:active,
            .btn-nuevo[disabled]:active,
            fieldset[disabled] .btn-nuevo:active,
            .btn-nuevo.disabled.active,
            .btn-nuevo[disabled].active,
            fieldset[disabled] .btn-nuevo.active {
                background-color: #444444;
                border-color: #444444;
            }

        </style>

        <style>
            .main-header,.main-sidebar,.left-side{
                position:fixed
            }
            
            .main-header {
                top: 0;
                right: 0;
                left: 0
            }
            
            .content-wrapper,
            .right-side {
                padding-top: 50px
            }
            
            @media (max-width:767px) {
                 .content-wrapper,
                 .right-side {
                    padding-top: 100px
                }
            }
            
            .layout-boxed .wrapper {
                max-width: 100%
            }
            
            .wrapper {
                overflow: hidden
            }
            
            .control-sidebar {
                position: fixed;
                height: 100%;
                overflow-y: auto;
                padding-bottom: 50px
            }
        </style>

        <style>
            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                   -moz-border-radius: 5px;
                        border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                   -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            
                    z-index: 1051 !important;
            
            }
            
            hr {
              height: 4px;
              width: 100%;
              background-color: #ecf0f5;
            
            }

            hr {
                /* margin-top: 20px; */
                margin-bottom: 20px;
                border: 0;
                /* border-top: 1px solid #eee; */
            }
            
            hr {
                display: block;
                unicode-bidi: isolate;
                -webkit-margin-before: 0.5em;
                -webkit-margin-after: 0.5em;
                -webkit-margin-start: auto;
                -webkit-margin-end: auto;
                overflow: hidden;
                border-style: inset;
            
            }

            .box.box-custom {
                border-top-color: #ffffff;
            }
            
            .box {
                position: relative;
                border-radius: 3px;
                background: #ffffff;
                border-top: 3px solid #d2d6de;
                margin-bottom: 5px;
                width: 100%;
                box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            }

        </style>
                
        <style>
            .btn-blanco {
              background-color: white;
            }
    
            .btn-blanco{
              border: none;
            }
    
            .btn-blanco i{
              color: #E4002B;
            }
    
            .blanco-sinborde{
              background: white!important;
              border: none;
            }
            
            .info-tec label{
                text-align:left; 
                padding: 8px 15px;    
            }
            
            .info-tec button{
                padding: 4px 10px; 
                font-size: 16px;    
            }
            
            .info-tec p{
                padding: 4px 10px; 
                font-size: 16px; 
                font-weight: 600;
                display: inline-block;
            }
            
            
            .texto-derecha{
                text-align: right;
            }
    
        </style>
        
        <style>
            .red{
                color: #E4002B;
            }
            .green{
                color: green;
            }
            .orange{
                color: orange;
            }
            
            select + span.select2:focus, select + span.select2 *:focus { 	outline-color: #7d3c8c; 	outline-width: 1px; }
            .select2-container--default.select2-container--focus, .select2-selection.select2-container--focus, .select2-container--default:focus, .select2-selection:focus, .select2-container--default:active, .select2-selection:active {
                outline: none;
                border: 1px solid #3c8dbc;
                border-radius: 4px;
            }
            
            .btn-verisure { 
                color: #ffffff; 
                background-color: #FF0033; 
                border-color: #FF0033; 
            } 
             
            .btn-verisure:hover, 
            .btn-verisure:focus, 
            .btn-verisure:active, 
            .btn-verisure.active, 
            .open .dropdown-toggle.btn-verisure { 
                color: #ffffff; 
                background-color: #a62828; 
                border-color: #a62828; 
            } 
             
            .btn-verisure:active, 
            .btn-verisure.active, 
            .open .dropdown-toggle.btn-verisure { 
                background-image: none; 
            } 
             
            .btn-verisure.disabled, 
            .btn-verisure[disabled], 
            fieldset[disabled] .btn-verisure, 
            .btn-verisure.disabled:hover, 
            .btn-verisure[disabled]:hover, 
            fieldset[disabled] .btn-verisure:hover, 
            .btn-verisure.disabled:focus, 
            .btn-verisure[disabled]:focus, 
            fieldset[disabled] .btn-verisure:focus, 
            .btn-verisure.disabled:active, 
            .btn-verisure[disabled]:active, 
            fieldset[disabled] .btn-verisure:active, 
            .btn-verisure.disabled.active, 
            .btn-verisure[disabled].active, 
            fieldset[disabled] .btn-verisure.active { 
              background-color: #555758; 
              border-color: #555758; 
            } 
        </style>
        
        <style>
            #divLoading {
                  background: rgba(66,118,164,0.4);
                  width: 100%;
                  height: 100%;
                  min-height: 100%;
                  position: absolute;
                  top: 0;
                  left: 0;
                  z-index: 999999999;
                  display:none;
                }
            
            .spinner {
              margin: 300px auto 0;
              width: 70px;
              text-align: center;
            }
            
            .spinner > div {
              background-color: #e4002b;
              width: 18px;
              height: 18px;
              border-radius: 100%;
              display: inline-block;
              -webkit-animation: sk-bouncedelay 1.4s infinite ease-in-out both;
              animation: sk-bouncedelay 1.4s infinite ease-in-out both;
            }
            
            .spinner .bounce1 {
              -webkit-animation-delay: -0.32s;
              animation-delay: -0.32s;
            }
            
            .spinner .bounce2 {
              -webkit-animation-delay: -0.16s;
              animation-delay: -0.16s;
            }
            
            @-webkit-keyframes sk-bouncedelay {
              0%, 80%, 100% { -webkit-transform: scale(0) }
              40% { -webkit-transform: scale(1.0) }
            }
            
            @keyframes sk-bouncedelay {
              0%, 80%, 100% {
                -webkit-transform: scale(0);
                transform: scale(0);
              } 40% {
                -webkit-transform: scale(1.0);
                transform: scale(1.0);
              }
            }
            
            .centrar-texto {
                text-align: center;
            }
            
            .m_get_started.fix {
                height: 100%;
                padding: 0;
                text-align: center;
                opacity: 1;
            }
            
            .callout {
                border-radius: 3px;
                margin: 0 0 20px 0;
                padding: 15px 30px 15px 15px;
                border-left: 5px solid #f03;
                -webkit-box-shadow: 10px 10px 5px -9px rgba(0,0,0,0.75);
                -moz-box-shadow: 10px 10px 5px -9px rgba(0,0,0,0.75);
                box-shadow: 10px 10px 5px -9px rgba(0,0,0,0.75);
            }
            .bg-deuda{
                color: #000;
                background-color: #ffffff !important;
            }
            
            .bg-visita{
                color: #fff;
                background-color: #008000 !important;
            }
            .bg-gestion{
             color: #fff;
            background-color: #6a6659 !important;   
            }
            .bg-televenta{
                color: #fff;
                background-color: #f39c12 !important;
                cursor: pointer;
            }
            
            input#nombres { text-transform: uppercase; }
            input#apellido_p { text-transform: uppercase; }
            input#apellido_m { text-transform: uppercase; }
        </style>

    </head>

    <body class="sidebar-collapse skin-red sidebar-mini">
        
        <div id="divLoading" style="display: none;height: auto; min-height: 100%;">
            <div class="spinner">
              <div class="bounce1"></div>
              <div class="bounce2"></div>
              <div class="bounce3"></div>
            </div>
        </div>

        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php include 'admin/main-sidebar.php'; ?>

            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        Visita
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="dashboard1.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Registrar Visita</li>
                    </ol>
                </section>
                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-md-2"></div>
                        <div class="col-md-8">
                            <div class="box box-danger">
                                <div class="box-header">
                                    <h3 class="box-title">Visita N° - </h3>
                                    <div class="box-tools pull-right">
                                        <button class="btn btn-nuevo btn-sm" id="btnGuardar"><i class="fa fa-save"></i></button>
                                        <!-- <a href="#" class="btn btn-danger btn-sm"><i class="fa fa-reply"></i></a> -->
                                    </div>
                                </div>
                                <div class="espacio"></div>
                            </div>
                            <div id="frmRegistrarVisita" method="post">
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                        <h5>INFORMACION DE LA VISITA</h5>
                                        <div class="box-tools pull-aca right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="box-body">
                                        <div class="form-horizontal" style="padding: 10px 20px 0">
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">NPROSPECTO: </label>
                                                <div class="col-lg-3">
                                                    <input type='text' class="form-control input-sm" id="NProspecto" name="NProspecto" maxlength="6" readonly/>
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label"></label>
                                                <div class="col-lg-3">
                                                    
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">CLIENTE: </label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control input-sm" id="nombres"  name="nombres" value="">
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label">CORREO:</label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control input-sm" name="correo" id="correo" value=""  >
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">TIPO DOCUMENTO VISITA: </label>
                                                <div class="col-lg-3">
                                                    <select class="form-control input-sm" name="lbltipodoc" id="lbltipodoc">
                                                        <option value="">Seleccione</option>
                                                        <option value="DNI">DNI</option>
                                                        <option value="RUC">RUC</option>
                                                        <option value="CE">CE</option>
                                                    </select>
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label">DOCUMENTO VISITA:</label>
                                                <div class="col-lg-3">
                                                    <div class="input-group" style="width: 100%">
                                                        <input type="text" class="form-control input-sm" name="ndocumento" id="ndocumento" maxlength="12" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                                                        <div class="input-group-addon btn" id="setAccion">
                                                            <i class="fa fa-dashboard"></i>
                                                        </div>
                                                    </div>        
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">ACCION: </label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control input-sm" name="lblaccion" id="lblaccion" maxlength="70" readonly>    
                                                    
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label">FECHA CONSULTA:</label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control input-sm" name="lblFechaHoraReg" id="lblFechaHoraReg" readonly>
                                                    <input type="hidden" name="idResultadoScoring" id="idResultadoScoring">
                                                    <input type="hidden" name="lblperfilscoring" id="lblperfilscoring">
                                                </div>
                                                
                                                
                                            </div>
                                            <div class="form-group ocultar">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">TELÉFONO INBOUND:</label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control pull-right input-sm" name="telefonopantalla" id="telefonopantalla" value="" maxlength="9" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');" >
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label"></label>
                                                <div class="col-lg-3">
                                                </div>
                                            </div>                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">TELÉFONO: <span style="color:red"> * </span></label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control pull-right input-sm" name="telefono" id="telefono" value="" maxlength="9" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');" >
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label">TELÉFONO 2: </label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control input-sm"  name="telefono2" id="telefono2" value=""  maxlength="9" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">DIRECCIÓN: </label>
                                                <div class="col-lg-8">
                                                    <div class="input-group" style="width: 100%">
                                                        <input type="text" class="form-control input-sm" id="lbldireccion" name="lbldireccion" placeholder="Ingresar dirección ..." value="">
                                                    </div>
                                                </div>
                                                <div class="col-lg-2">
                                                    <select class="form-control selectdistrito input-sm" name="lbldistrito" id="lbldistrito" style="width: 100%;">
                                                        
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">TIPO DIRECCIÓN: </label>
                                                <div class="col-lg-3">
                                                    <select class="form-control input-sm selecttipodireccion" name="tipovial" id="tipovial" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Alameda">Alameda</option>
                                                        <option value="Asenamiento Humano">Asenamiento Humano</option>
                                                        <option value="Avenida">Avenida</option>
                                                        <option value="Calle">Calle</option>
                                                        <option value="Centro Poblado">Centro Poblado</option>
                                                        <option value="Jiron">Jiron</option>
                                                        <option value="Malecon">Malecon</option>
                                                        <option value="Ovalo">ovalo</option>
                                                        <option value="Pasaje">Pasaje</option>
                                                        <option value="Pueblo Joven">Pueblo Joven</option>
                                                        <option value="Urbanizacion">Urbanizacion</option>
                                                        <option value="Ampliacion">Ampliacion</option>
                                                        <option value="Upis">Upis</option>
                                                        <option value="Prolongacion">Prolongacion</option>
                                                        <option value="Caserio">Caserio</option>
                                                        <option value="Fundo">Fundo</option>
                                                        <option value="Asociacion">Asociación</option>
                                                        <option value="Cooperativa">Cooperativa</option>
                                                        <option value="Conjunto habitacional">Conjunto habitacional</option>
                                                        <option value="APV">Asociacion Pro Vivienda</option>
                                                        <option value="Variante">Variante</option>
                                                        <option value="Zona">Zona</option>
                                                        <option value="Sector">Sector</option>
                                                        <option value="Grupo">Grupo</option>
                                                        <option value="Kilometro">Kilometro</option>
                                                        <option value="Parcela">Parcela</option>
                                                        <option value="Agrupacion">Agrupacion</option>
                                                    </select>                                                    
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label"></label>
                                                <div class="col-lg-3">

                                                </div>                                                
                                            </div>  
                                            
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">DIRECCIÓN GEO: </label>
                                                <div class="col-lg-8">
                                                    <div class="input-group" style="width: 100%">
                                                        <input type="text" class="form-control input-sm" id="lbldireccionAprox" name="lbldireccionAprox" placeholder="" value="" readonly>
                                                        <div class="input-group-addon btn" id="setDireccion">
                                                            <i class="fa fa-map-marker"></i>
                                                        </div>
                                                        <input type="hidden" id="objGeofinderFinal" name="objGeofinderFinal" value=''>
                                                        <input type="hidden" id="IdDireccion" name="IdDireccion" value="">
                                                        <input type="hidden" id="idZonificacion" name="idZonificacion">
                                                        <input type="hidden" id="objZonificacionVerisure" name="objZonificacionVerisure">
                                                        <input type="hidden" id="microzona" name="microzona">
                                                    </div>
                                                </div>
                                                <div class="col-lg-2">
                                                    <select class="form-control input-sm" name="lbltipoDireccion" id="lbltipoDireccion" style="width: 100%;">
                                                        <option value="" disabled selected>Seleccione</option>
                                                        <option value="Exacta">Exacta</option>
                                                        <option value="Aproximada">Aproximada</option>
                                                    </select>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">INTERIOR: </label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control input-sm" name="lblinterior" id="lblinterior" value="">
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label">REFERENCIA: </label>
                                                <div class="col-lg-3">
                                                    <div class="input-group" style="display: flex">
                                                        <input type="text" class="form-control input-sm" id="lblreferencia" name="lblreferencia" value="">
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">ORIGEN: </label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control pull-right input-sm" id="origen"  name="origen" value="">
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label">LEAD ID: <span style="color:red"> * </span></label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control input-sm"  name="leadid" id="leadid" value="">
                                                </div>
                                            </div>
                                            <div class="form-group" >
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;"></label>
                                                <div class="col-lg-3">

                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label">OPENUMBER: </label>
                                                <div class="col-lg-3">
                                                    <div class="input-group" style="width: 100%">
                                                        <input type="text" class="form-control input-sm"  name="openumber" id="openumber" value="">
                                                    </div>                                                    
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">SEGMENTO: </label>
                                                <div class="col-lg-3">
                                                    <select class="form-control input-sm" name="segmento" id="segmento" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="RES">RES</option>
                                                        <option value="NEG">NEG</option>
                                                    </select>
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label">FECHA HORA ENTRADA: <span style="color:red"> * </span></label>
                                                <div class="col-lg-3">
                                                    <div class='input-group'>
                                                        <input type='text' class="form-control input-sm datetimepicker" id="fechahoraCotizacion" name="fechahoraCotizacion" />
                                                        <span class="input-group-addon">
                                                            <span class="glyphicon glyphicon-calendar"></span>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="Lead__tiposegmento ocultar">
                                                <div class="form-group">
                                                    <label class="col-lg-2 control-label" style="padding-left: 35px;">N° PISO:</label>
                                                    <div class="col-lg-3">
                                                       <input type="number" class="form-control input-sm" id="npiso" name="npiso" max="99"  min="0">
                                                    </div>
                                                    <div class="col-lg-2">&nbsp</div>
                                                    <label class="col-lg-2 control-label">TIPO RESIDENCIAL:</label>
                                                    <div class="col-lg-3">
                                                        <select class="form-control input-sm" name="tiposegmento" id="tiposegmento" style="width: 100%">
                                                            <option value="">Seleccione</option>
                                                            <option value="Casa">Casa</option>
                                                            <option value="Departamento">Departamento</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="Lead__tiposegmento ocultar">
                                                <div class="form-group">
                                                    <label class="col-lg-2 control-label" style="padding-left: 35px;">VIVE PISO A PROTEGER:<span style="color:red"> * </span></label>
                                                    <div class="col-lg-3">
                                                        <select class="form-control input-sm" name="visePiso" id="visePiso" style="width: 100%">
                                                            <option value="">Seleccione</option>
                                                            <option value="Si">Si</option>
                                                            <option value="No - para familiar">No, para familiar</option>
                                                            <option value="No - para alquiler">No, para alquiler</option>
                                                            <option value="No - para turismo">No, para turismo</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>                                            
                                            <div class="Lead__nlocales ocultar">
                                                <div class="form-group">
                                                    <label class="col-lg-2 control-label" style="padding-left: 35px;">RUBRO DE NEGOCIO:<span style="color:red"> * </span></label>
                                                    <div class="col-lg-3">
                                                       <input type="text" class="form-control input-sm" id="rubroNeg" name="rubroNeg">
                                                    </div>
                                                    <div class="col-lg-2">&nbsp</div>
                                                    <label class="col-lg-2 control-label">PUERTA A CALLE:<span style="color:red"> * </span></label>
                                                    <div class="col-lg-3">
                                                        <select class="form-control input-sm" name="puertaCalle" id="puertaCalle" style="width: 100%">
                                                            <option value="">Seleccione</option>
                                                            <option value="Si">Si</option>
                                                            <option value="No">No</option>
                                                        </select>
                                                    </div>                                                    
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">PAREDES - LADRILLO Y CEMENTO:<span style="color:red"> * </span></label>
                                                <div class="col-lg-3">
                                                    <select class="form-control input-sm" name="nobleParedes" id="nobleParedes" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Si">Si</option>
                                                        <option value="No">No</option>
                                                    </select>
                                                </div>
                                                <div class="col-lg-2">&nbsp</div>
                                                <label class="col-lg-2 control-label">TECHO - LADRILLO Y CEMENTO:<span style="color:red"> * </span></label>
                                                <div class="col-lg-3">
                                                    <select class="form-control input-sm" name="nobleTecho" id="nobleTecho" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Si">Si</option>
                                                        <option value="No">No</option>
                                                    </select>
                                                </div>                                                
                                            </div>
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">M2<span style="color:red"> * </span></label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control input-sm" id="mcuadrados"  name="mcuadrados" value="" maxlength="50" onkeypress="return (event.charCode >= 46 && event.charCode <= 57)">
                                                </div>
                                                <div class="col-lg-2">&nbsp</div>
                                                <label class="col-lg-2 control-label">MOTIVO INTERÉS</label>
                                                <div class="col-lg-3">
                                                    <select class="form-control input-sm" name="motivoInteres" id="motivoInteres" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Robo">Robo</option>
                                                        <option value="Prevencion">Prevención</option>
                                                    </select>
                                                </div>                                                
                                            </div>
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">CON SISTEMA DE ALARMAS<span style="color:red"> * </span></label>
                                                <div class="col-lg-3">
                                                    <select class="form-control input-sm" name="conSistema" id="conSistema" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Si">Si</option>
                                                        <option value="No">No</option>
                                                    </select>
                                                </div>
                                                <div class="col-lg-2">&nbsp</div>
                                                <div class="Lead__empresaAlarmas ocultar">
                                                    <label class="col-lg-2 control-label">EMPRESA ALARMAS<span style="color:red"> * </span></label>
                                                    <div class="col-lg-3">
                                                        <input type="text" class="form-control input-sm" id="empresaSistema"  name="empresaSistema" value="" maxlength="50">
                                                    </div>   
                                                </div> 
                                            </div>
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">CLIENTE BANCARIZADO<span style="color:red"> * </span></label>
                                                <div class="col-lg-3">
                                                    <select class="form-control input-sm" name="bancarizado" id="bancarizado" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Si">Si</option>
                                                        <option value="No">No</option>
                                                    </select>
                                                </div>
                                            </div>                                             
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">GRUPO ACD: </label>
                                                <div class="col-lg-3">
                                                    <select class="form-control input-sm select2" name="cboGrupoACD" id="cboGrupoACD" style="width: 100%">
                                                        <option value="" selected disabled>Seleccione</option>
                                                        <option value="LEADS_INT - LEADS_ INTERNET_ PRIMER INT.">LEADS_INT - LEADS_ INTERNET_ PRIMER INT.</option>
                                                        <option value="CORTO - WWW CORTO">CORTO - WWW CORTO</option>
                                                        <option value="LARGO - WWW LARGO">LARGO - WWW LARGO</option>
                                                        <option value="61317 - SEO">61317 - SEO</option>
                                                        <option value="61315 - SEM GENERICO - 514 73 22">61315 - SEM GENERICO - 514 73 22</option>
                                                        <option value="61314 - SEM MARCA - 514 73 18">61314 - SEM MARCA - 514 73 18</option>
                                                        <option value="61324 - CAMARAS - 514 81 97">61324 - CAMARAS - 514 81 97</option>
                                                        <option value="61308 - FACEBOOK INBOUND">61308 - FACEBOOK INBOUND</option>
                                                        <option value="61318 - RADIO CRP 576 56 31">61318 - RADIO CRP 576 56 31</option>
                                                        <option value="61281 - MKT RE - 514 73 00">61281 - MKT RE - 514 73 00</option>
                                                        <option value="61322 - RADIO RPP 514 8190">61322 - RADIO RPP 514 8190</option>
                                                        <option value="61366 - PERU_MKT_TV_AMERICA">61366 - PERU_MKT_TV_AMERICA</option>
                                                        <option value="61364 - PERU_MKT_TV_CANALN">61364 - PERU_MKT_TV_CANALN</option>
                                                        <option value="61367 - PERU_MKT_TV_MOVISTAR">61367 - PERU_MKT_TV_MOVISTAR</option>
                                                        <option value="61368 - PERU_MKT_TV_ROLA">61368 - PERU_MKT_TV_ROLA</option>
                                                        <option value="61365 - PERU_MKT_TV_RPP">61365 - PERU_MKT_TV_RPP</option>
                                                        <option value="61370 - PERU_MKT_TV_SONY">61370 - PERU_MKT_TV_SONY</option>
                                                        <option value="61369 - PERU_MKT_TV_TURNER">61369 - PERU_MKT_TV_TURNER</option>
                                                        <option value="61329 - PERU_MKT_SMS_NC">61329 - PERU_MKT_SMS_NC</option>
                                                        <option value="61280 - ATENCION AL CLIENTE 5147302">61280 - ATENCION AL CLIENTE 5147302</option>
                                                        <option value="61280 - MKT_RP - 514 7301">61280 - MKT_RP - 514 7301</option>
                                                        <option value="61323 - PERU_MKT_BACKUP1">61323 - PERU_MKT_BACKUP1</option>
                                                        <option value="61313 - RELLAMADA INTERNET 5148210">61313 - RELLAMADA INTERNET 5148210</option>
                                                        <option value="61325 - RELLAMADA RECOVERY 5148198">61325 - RELLAMADA RECOVERY 5148198</option>
                                                        <option value="61325 - RELLAMADA RECOVERY 7102339">61325 - RELLAMADA RECOVERY 7102339</option>
                                                        <option value="TELEVENTA - TELEVENTA">TELEVENTA - TELEVENTA</option>
                                                        <option value="B12 - CALL B12">B12 - CALL B12</option>
                                                        <option value="TV_ABIERTA_04 - LLAMADAS TELEVISION">TV_ABIERTA_04 - LLAMADAS TELEVISION</option>
                                                    </select>
                                                    <input type='hidden' class="form-control input-sm" id="grupoACD" name="grupoACD" />
                                                    
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <div class="Lead__recurso ocultar">
                                                    <label class="col-lg-2 control-label">RECURSO: </label>
                                                    <div class="col-lg-3">
                                                        <select class="form-control input-sm" name="lbltipoventa" id="lbltipoventa">
                                                            <option value="RE" >RE</option>
                                                            <option value="RPMKT" >RPMKT</option>
                                                            <option value="REGGCC">REGGCC</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;" id="txtFvisita">Fecha Visita:</label>
                                                <div class="col-lg-3">
                                                    <div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control pull-right input-sm" id="lblfvisita"  name="lblfvisita" value=""  data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                        <input type="hidden" class="form-control pull-right input-sm" id="lblfvencimientob" value="" name="lblfvencimientob" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                        <input type="hidden" class="form-control pull-right input-sm" id="lblfvencimiento" value=""  name="lblfvencimiento">
                                                    </div>
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label">HORA VISITA: </label>
                                                <div class="col-lg-3">
                                                    <div class="bootstrap-timepicker timepicker">
                                                        <div class="input-group">
                                                            <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhvisita" id="lblhvisita" value=""  >
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-clock-o"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">OBRAS: </label>
                                                <div class="col-lg-3">
                                                    <input type="checkbox" name="FObras" id="FObras" data-size="small">
                                                    <input type="hidden" name="ValFObras" id="ValFObras" value="NO">
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <div class="ocultar" id="dpFVisitaReal">
                                                    <label class="col-lg-2 control-label">FECHA VISITA ORIGINAL: </label>
                                                    <div class="col-lg-3">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblFVisitaReal"  name="lblFVisitaReal" value=""  data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">ESTADO VISITA: </label>
                                                <div class="col-lg-3">
                                                    <input type='text' class="form-control input-sm" id="lblestadovisita" name="lblestadovisita" value="VGenerada" disabled />
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label">ESTADO VENTA: </label>
                                                <div class="col-lg-3">
                                                    <input type='text' class="form-control input-sm" id="lblestadoventa" name="lblestadoventa" value="VGenerada" disabled />
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">COMENTARIOS: </label>
                                                <div class="col-lg-10">
                                                    <div class="input-group">
                                                            <textarea class="form-control input-sm" name="observaciones" id="observaciones" rows="3" style="resize:none" placeholder="Ingresar..."></textarea>
                                                            <input type="hidden" id="detalleObservaciones">
                                                            <div class="btn input-group-addon input-sm" id="btnDetalleObservaciones" disabled>
                                                                <i class="fa fa-pencil-square-o"></i>
                                                            </div>
                                                        </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                        
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">

                        </div>
                    </div>
                </section>
            </div>

            <div class="modal fade" id="mapgeofinder">
                <div class="modal-dialog modal-lg" style="width: 80%">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4 class="modal-title">DIRECCION</h4>
                        </div>
                        <div class="modal-body" style="width: 100%;height:100%;">
                            <div class="row">
                                <div class="col-md-2"></div>
                                <div class="form-horizontal col-md-8">
                                    <div class="form-group">
                                        <label for="microzona" class="col-md-2 control-label">DIRECCION:</label>
                
                                        <div class="col-md-4">
                                            <input type="text" class="form-control input-sm" id="GeofinderDireccion" name="GeofinderDireccion" placeholder="Ingresar dirección ..." readonly>
                                            <input type="hidden" id="objGeofinder" name="objGeofinder">
                                            <input type="hidden" id="microzona" name="microzona">
                                        </div>
                                        
                                        <label for="lbltelefono" class="col-md-2 control-label">TELÉFONO:</label>
                
                                        <div class="col-md-4">
                                            <input type="text" class="form-control input-sm" id="GeofinderTelefono" name="GeofinderTelefono" placeholder="Ingresar telefono ..." disabled>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="Tipo" class="col-md-2 control-label">Tipo:</label>
                                        <div class="col-md-4">
                                            <div class="radio">
                                                <label>
                                                    <input type="radio" name="GeofinderTipoDireccion" id="Exacta" value="Exacta" checked="">
                                                    Exacta
                                                </label>
                                            </div>
                                            <div class="radio">
                                                <label>
                                                    <input type="radio" name="GeofinderTipoDireccion" id="Aproximada" value="Aproximada">
                                                    Aproximada
                                                </label>
                                            </div>
                                        </div>
                                        <label for="Busqueda" class="col-md-2 control-label">Busqueda:</label>
                                        <div class="col-md-4">
                                            <div class="Busqueda">
                                                <label>
                                                    <input class"" type="radio" name="Busqueda" id="Online" value="En Linea" checked="">
                                                    En Linea
                                                </label>
                                            </div>
                                            <div class="Busqueda">
                                                <label>
                                                    <input class"Busqueda" type="radio" name="Busqueda" id="Offline" value="Fuera de la llamada">
                                                    Fuera de la llamada
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="ocultar" id="Asignacion">
                                        
                                    </div>
                                    <div class="form-group">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-2"><button class="btn btn-danger" id="btnGuardarGeofinderDireccion"><i class="fa fa-save"></i> Guardar</button></div>
                                        <div class="col-md-2"><button class="btn btn-default" id="btnNuevaDireccion"><i class="fa fa-plus"></i> Nueva Consulta</button></div>
                                        <div class="col-md-4"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-1"></div>
                                <div class="col-md-10">
                                    <iframe id="map" height="550"  allowTransparency="true" frameborder="0" scrolling="yes" style="width:100%;" src="GFWIDGET-PE-v2/index.html" type= "text/javascript"></iframe>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <!--<button type="button" class="btn btn-danger pull-irght" id="btnDireccionManual">MANUAL</button> -->
                            <button type="button" class="btn btn-default pull-right" data-dismiss="modal">CERRAR</button>
                        </div>
                    </div>
                    <!-- /.modal-content -->

                </div>
                <!-- /.modal-dialog -->
            </div>
            <!-- MODAL SCORING -->
            <div class="modal fade" id="modal-consultascoring">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4>CONSULTAR SCORING</h4>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-horizontal" style="padding: 10px 20px 0">
                                        <div class="form-group">
                                            <label style="text-align: left;">TIPO DOCUMENTO:</label>
                                            <select class="form-control input-sm" name="EquifaxTipoDocumento" id="EquifaxTipoDocumento">
                                                <option value="">Seleccione</option>
                                                <option value="1">DNI</option>
                                                <option value="3">Carnet Extranjeria</option>
                                                <option value="6">RUC</option>
                                            </select>
                                            <a href="https://soluciones.equifax.com.pe/efx-portal-web/" target="_blank" title="Modal de Busqueda de Documento" id="btnBusquedaDocumento">(No tengo el Número de Documento)</a>
                                        </div>
                                        <div class="form-group">
                                            <label id="labeltelefono">DOCUMENTO: </label>
                                            <input type="text" class="form-control input-sm" name="EquifaxDocumento" id="EquifaxDocumento" maxlength="12" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                                        </div>
                                        <div class="form-group">
                                        <label>DEPARTAMENTO: </label>
                                            <select class="form-control input-sm select2full" name="EquifaxDepartamental" id="EquifaxDepartamental" style="width: 100%">
                                                    <option value="" selected>Seleccione</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                        <label>PROVINCIA: </label>
                                             <select class="form-control input-sm select2full" name="EquifaxProvincial" id="EquifaxProvincial" style="width: 100%">
                                                    <option value="">Seleccione</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                        <label>DISTRITO: </label>
                                            <select class="form-control input-sm select2full" name="EquifaxDistrital" id="EquifaxDistrital" style="width: 100%">
                                                    <option value="">Seleccione</option>
                                            </select>
                                         </div>
                                        <div class="form-group" style="margin-top:40px;">
                                            <button class="btn  btn-block btn-verisure" id="btnScoring">Consultar Scoring</button>
                                            <button class="btn  btn-block btn-verisure" style="display:none" id="btnNuevaScoring">Nueva Consulta</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <main class="contenedor ocultar box box-danger" id="ResultadoEquifax">
                                        <div id="resultado">
                                            <div class="callout bg-deuda">
                                                <h4><i class="fa fa-bullhorn"></i> Resultado de la Consulta:</h4>
                                                <h2 style="text-align: center;"><small class="label bg-visita"><span class="TextoAccion"></span></small><small class="label bg-televenta"><span class="TextoAccion"></span></small><small class="label bg-gestion"><span class="TextoAccion"></span></small></h2>
                                                <input type="hidden" id="idscoring">
                                                <!--<strong>N°Operación: </strong><span id="NOperacion">S32012280000162</span><br>-->
                                                <strong>Fecha Consulta: </strong><span id="FechaConsulta">13/11/2019 12:24:34</span><br><br>
                                                <div class="row">
                                                    <div class="col-xs-12">
                                                        <strong><i class="fa fa-user text-danger"></i> Nombre del Solicitante:</strong><br><span id="NombreCompleto">DUBOIS DORIBAL DUBOIS DORIBAL GLADYS ELVIRA</span><br>
                                                        <strong><i class="fa fa-folder-open text-danger"></i> <span id="TDocumento">DNI:</span></strong><br><span id="NumeroDocumento">00007039332</span><br>
                                                    </div>
                                       
                                                    <div class="col-xs-12">
                                                        <div class="contenido-score">
                                                            <div class="score-info">
                                                                <div>
                                                                    <strong>SCORE - RIESGO</strong>
                                                                    <br>
                                                
                                                                    <span id="Riesgo">Bajo</span>
                                                                </div>
                                                                <div>
                                                                    <strong>SCORE - VALOR</strong>
                                                                    <br>
                                                                    <div id="ValorScoring">952</div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                  </main>    
                                </div>
                             </div> 
                        </div>

                    </div>
                </div>
            </div>
            
            <div class="control-sidebar-bg"></div>
            
        </div><!-- ./wrapper -->
        
        <!-- jQuery v1.11 -->
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>$.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
        <!-- momentjs -->
        <script src="//cdnjs.cloudflare.com/ajax/libs/moment.js/2.15.2/moment.min.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <script src="//cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.37/js/bootstrap-datetimepicker.min.js"></script>
        <!-- bottstrap toogle -->
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
        <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- SweetAlert -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <!-- DataTables -->
        <script src="admin/bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
        <script src="admin/bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
        <!-- iCheck 1.0.1 -->
        <script src="admin//plugins/iCheck/icheck.min.js"></script>
        
        <!-- CONSTANTES GLOBALES -->
        <script>
            const queryString = window.location.search;
            const urlParams = new URLSearchParams(queryString);
            const accion = urlParams.get('accion');
            const IdLeadCC = urlParams.get('IdLeadCC');
            const PerfilUsuario = $('#headerPerfilUsuario').val();

        </script>
        <!-- INICIALIZADORES -->
        <script>

            $('.select2').select2();
            
            $('.select2full').select2({
              selectOnClose: true
            });

            $('.selecttipodireccion').select2({
              placeholder: 'Seleccione Tipo Dirección',
              selectOnClose: true,
              minimumInputLength: 2,
              language: {
                        errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {
                        return "Buscando..";
                    },
                    inputTooShort: function() {
                        return "Escribir minimo 2 caracteres";
                    }                    
                },              
            });            
            
            $('.selectdistrito').select2({
                placeholder: 'Seleccione Distrito - Provincia',
                allowClear: true,
                language: {
                        errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {
                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectDistrito.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });
              
            $('#lblfvisita').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1
            }).on('changeDate', function (selected) {
                var minDate = new Date(selected.date.valueOf() + (1000 * 60 * 60 * 24 * 5)); // agregar 5 días 
                $('#lblfvencimiento').datepicker('setStartDate', minDate); // bloquea de la fecha inicial
                $('#lblfvencimiento').datepicker('setDate', minDate); // mostrar fecha
                $('#lblfvencimientob').datepicker('setStartDate', minDate);
                $('#lblfvencimientob').datepicker('setDate', minDate);
            });

            $('#lblFVisitaReal').datepicker({
              autoclose: true,
              language: 'es',
              firstDay: 1
            });

            $('#lblhvisita').timepicker({
              showInputs: true,
              minuteStep: 1
            });
        
            $('#FObras').bootstrapToggle({
                  on:'SI',
                  off:'NO',
                  onstyle:'success',
                  offstyle:'danger'
            });
            
            $('#lblfvencimiento').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1,
                    format: 'dd/mm/yyyy'
                });
            
            $('#lblfvencimientob').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1,
                format: 'dd/mm/yyyy',
                startDate: ''
            }).on('changeDate', function (selected) {
                var minDate = new Date(selected.date.valueOf()); // agregar 5 días 
                $('#lblfvencimiento').datepicker('setStartDate', minDate); // bloquea de la fecha inicial
                $('#lblfvencimiento').datepicker('setDate', minDate); // mostrar fecha
            });
            
        </script>
        <!-- DOM -->
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                
                cargarDatos(IdLeadCC);
                
            });
        </script>
        <!-- EVENTOS -->
        <script>
        
            $('#FObras').change(function(){
                if($(this).prop('checked')){
                   $('#ValFObras').val('SI');
                   $('#txtFVisitaReal').show();
                   $('#dpFVisitaReal').show();
                   $('#txtFvisita').html("FECHA VISITA (OBRAS):");
                   $('#txtFVisitaReal').html("FECHA VISITA ORIGINAL:");
                }else{
                  $('#ValFObras').val('NO');
                   $('#txtFVisitaReal').hide();
                   $('#dpFVisitaReal').hide();
                   $('#txtFvisita').html("FECHA VISITA:");
                   $('#txtFVisitaReal').html("");
                 }
            });
            
            $("#Departamental").change(function () {
                $("#Departamental option:selected").each(function () {
                    var Provincial = $(this).val();
                    var datos={
                        Provincial:Provincial
                    };
                    var provincia= $("#Provincial");
                    var distrito= $("#Distrital");
                    
                     $.ajax({
                        data:datos,
                        url:   './ajax/selectProvincial.php',
                        type:  'POST',
                        dataType: 'json',
                        beforeSend: function () {
                            //provincia.prop('disabled', true);
                            //distrito.prop('disabled', true);
                        },
                        success:  function (r) {
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                            
                            // Limpiamos el select de Provincia
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            // Limpiamos el select de Distrito
                            distrito.find('option').remove();
                            distrito.append('<option value="">Seleccione</option>');
                            
                            $(r).each(function(i, v){ // indice, valor
                                provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                            })
                            
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                        },
                        error: function(){
                            //alert('Ocurrio un error en el servidor ..');
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                        }
                    });

                });
            });
            
            $('#EquifaxDepartamental').change(() => {
                $("#EquifaxDepartamental option:selected").each(function () {
                    //Obtener valor del Departamento y asignarlo a la variable provincia (mala definicion de la funcion)
                    const Provincial = $(this).val();
                    //Genera un objeto provincia (departamento) para traer los datos de la provincia
                    const datos={
                        Provincial:Provincial
                    };
                    //Definir las variables del select de provincia y distrito. Se modifica a const por se constantes
                    const provincia= $("#EquifaxProvincial");
                    const distrito= $("#EquifaxDistrital");
                    //Ajax para traer los datos de la base de datos. //CONSULTAR PROVINCIA
                    $.ajax({
                        data:datos,
                        url:   './ajax/selectProvincial.php',
                        type:  'POST',
                        dataType: 'json',
                        success:  function (r) {
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                            
                            // Limpiamos el select de Provincia
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            // Limpiamos el select de Distrito
                            distrito.find('option').remove();
                            distrito.append('<option value="">Seleccione</option>');
                            
                            $(r).each(function(i, v){ // indice, valor
                                provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                            })
                            
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                        },
                        error: function()
                        {
                            //alert('Ocurrio un error en el servidor ..');
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                        }
                    });
                })      
            })
                
            $("#Provincial").change(function () {
                    $("#Provincial option:selected").each(function () {
                        var Provincial = $(this).val();
                        var datos={
                            Provincial:Provincial
                        };
                        var provincia= $("#Distrital");
                         $.ajax({
                        data:datos,
                        url:   './ajax/selectDistrital.php',
                        type:  'POST',
                        dataType: 'json',
                        beforeSend: function () 
                        {
                           //provincia.prop('disabled', true);
                        },
                        success:  function (r) 
                        {
                            provincia.prop('disabled', false);
                            
                            // Limpiamos el select
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            
                            $(r).each(function(i, v){ // indice, valor
                                provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                            })
                            
                            provincia.prop('disabled', false);
                        },
                        error: function()
                        {
                            //alert('Ocurrio un error en el servidor ..');
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            provincia.prop('disabled', false);
                        }
                    });
    
                    });
                });
                
            $("#EquifaxProvincial").change(function () {
                $("#EquifaxProvincial option:selected").each(function () {
                    var Provincial = $(this).val();
                    var datos={
                        Provincial:Provincial
                    };
                    var provincia= $("#EquifaxDistrital");
                     $.ajax({
                        data:datos,
                        url:   './ajax/selectDistrital.php',
                        type:  'POST',
                        dataType: 'json',
                        success:  function (r) {
                            provincia.prop('disabled', false);
                            
                            // Limpiamos el select
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            
                            $(r).each(function(i, v){ // indice, valor
                                provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                            })
                            
                            provincia.prop('disabled', false);
                        },
                        error: function(){
                            //alert('Ocurrio un error en el servidor ..');
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            provincia.prop('disabled', false);
                        } //END ERROR
                    }); //END AJAX
                }); //END OPTION SELECTED
            });
            
            $('#setDireccion').on('click', function(e){
                e.preventDefault();
                if($('#telefono').val() === ''){
                    Swal.fire('Ingresar el ntelefono para georeferenciar', '', 'warning')
                }else{
                    $('#mapgeofinder').modal('show');
                }
                
            })
            
            $('#mapgeofinder').on('shown.bs.modal', function(){

                buscarDireccionLocalStorage();
                
                $('#GeofinderTelefono').val($('#telefono').val());
            })
            
            $('#cboGrupoACD').on('change', function(){
                $('#grupoACD').val($('#cboGrupoACD').val());
            })

            $('#segmento').change(function(){
                if($('#segmento').val() == 'NEG'){
                    $('.Lead__nlocales').removeClass('ocultar');
                    $('.Lead__tiposegmento').addClass('ocultar');
                    $("#tiposegmento").val("");
                } else{
                    $('.Lead__tiposegmento').removeClass('ocultar');
                    $('.Lead__nlocales').addClass('ocultar');
                }

            })
            $('#conSistema').change(function(){
                if($('#conSistema').val() == 'Si'){
                    $('.Lead__empresaAlarmas').removeClass('ocultar');
                } else{
                    $('.Lead__empresaAlarmas').addClass('ocultar');
                    $("#empresaSistema").val("");
                }
            })            
            
    
        </script>
        <!-- BTN GUARDAR -->
        <script>
            $('#btnGuardar').on('click', function(){
                
                $('#btnGuardar').prop('disabled', true);
                
                //DATOS
                // --DATOS DEL CLIENTE --
                const nombres = $('#nombres').val();
                const correo = $('#correo').val();
                const lbltipodoc = $('#lbltipodoc').val();
                const ndocumento = $('#ndocumento').val();
                const telefono = $('#telefono').val();
                const telefono2 = $('#telefono2').val();
                const lbldireccion = $('#lbldireccion').val();
                const lbldistrito = $('#lbldistrito').val();
                const lbldireccionAprox = $('#lbldireccionAprox').val();
                const lbltipoDireccion = $('#lbltipoDireccion').val();
                const lblinterior = $('#lblinterior').val();
                const lblreferencia = $('#lblreferencia').val();
                const objGeofinder = $('#objGeofinderFinal').val();
                const IdDireccion = $('#IdDireccion').val();
                //DATOS DE ZONIFICACION
                const idZonificacion = $('#idZonificacion').val();
                const objZonificacionVerisure = $('#objZonificacionVerisure').val();
                //SCORING
                
                // --DATOS DE LA VISITA --
                const origen = $('#origen').val();
                const leadid = $('#leadid').val();
                const openumber = $('#openumber').val();
                
                const segmento = $('#segmento').val();
                const npiso = $('#npiso').val();
                const tiposegmento = $('#tiposegmento').val();
                const tipovial = $('#tipovial').val();
                const fechahoraCotizacion = $('#fechahoraCotizacion').val();
                const grupoACD = $('#grupoACD').val();
                const lbltipoventa = $('#lbltipoventa').val();
                const lblfvisita = $('#lblfvisita').val();
                const lblhvisita = $('#lblhvisita').val();
                const FObras = $('#ValFObras').val();
                const lblFVisitaReal = $('#lblFVisitaReal').val();
                const lblfvencimiento = $('#lblfvencimiento').val();
                const lblestadovisita = $('#lblestadovisita').val();
                const lblestadoventa = $('#lblestadoventa').val();
                const observaciones = $('#observaciones').val();
                const gestorMKT = $('#headerMatriculaUsuario').val();
                const NProspecto = $('#NProspecto').val();
                //SCORING
                const idResultadoScoring = $('#idResultadoScoring').val();
                const lblaccion = $('#lblaccion').val();
                const lblFechaHoraReg = $('#lblFechaHoraReg').val();
                const lblperfilscoring = $('#lblperfilscoring').val();
                //OBSERVACIONES
                const detalleObservaciones = $('#detalleObservaciones').val();

                const visePiso =$('#visePiso option:selected').val();
                const rubroNeg =$('#rubroNeg').val();
                const puertaCalle =$('#puertaCalle').val();
                const nobleParedes =$('#nobleParedes').val();
                const nobleTecho =$('#nobleTecho').val();
                const mcuadrados =$('#mcuadrados').val();
                const motivoInteres =$('#motivoInteres').val();
                const conSistema =$('#conSistema').val();
                const empresaSistema =$('#empresaSistema').val();
                const bancarizado =$('#bancarizado').val();
                const telefonopantalla =$('#telefonopantalla').val();
                
                //CONSTRUIR OBJETO
                const data = {
                    nombres,
                    correo,
                    lbltipodoc,
                    ndocumento,
                    telefono,
                    telefono2,
                    lbldireccion,
                    lbldistrito,
                    lbldireccionAprox,
                    lbltipoDireccion,
                    tipovial,
                    lblinterior,
                    lblreferencia,
                    objGeofinder,
                    IdDireccion,
                    origen,
                    leadid,
                    openumber,
                    segmento,
                    npiso,
                    tiposegmento,                    
                    fechahoraCotizacion,
                    grupoACD,
                    lbltipoventa,
                    lblfvisita,
                    lblhvisita,
                    FObras,
                    lblFVisitaReal,
                    lblestadovisita,
                    lblestadoventa,
                    observaciones,
                    IdLeadCC,
                    gestorMKT,
                    NProspecto,
                    idZonificacion,
                    objZonificacionVerisure,
                    idResultadoScoring,
                    lblaccion,
                    lblFechaHoraReg,
                    lblperfilscoring,
                    lblfvencimiento,
                    detalleObservaciones,
                    visePiso,
                    rubroNeg,
                    puertaCalle,
                    nobleParedes,
                    nobleTecho,
                    mcuadrados,
                    motivoInteres,
                    conSistema,
                    empresaSistema,
                    bancarizado,
                    telefonopantalla
                };
                
                console.log(data);
                //VALIDAR DATOS
                
                if(validarDatos(data)){
                    
                    Swal.fire({
                        title: '¿Desea guardar los cambios?',
                        showCancelButton: true,
                        confirmButtonText: `Guardar`,
                        icon: 'info',
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                type: 'post',
                                url: 'ajax/insertVisita_Lead.php',
                                data: data,
                                dataType: 'json',
                                success: function (data) {
                                    console.log(data);
                                    
                                    const respuesta = data.respuesta;
                                    
                                    if(respuesta == 'exito'){
                                        Swal.fire('Visita Generada correctamente', '', 'success');
                                    } else {
                                        Swal.fire('Error al generar la visita', data.detalle, 'error');
                                        $('#btnGuardar').prop('disabled', false);
                                    }
                                }
                            })
                            
                        } else {
                            Swal.fire('No se guardó la visita', '', 'warning');
                            $('#btnGuardar').prop('disabled', false);
                        }
                    })
                } else {
                    $('#btnGuardar').prop('disabled', false);
                }
                
                
                
                
            })
        </script>
        <!-- FUNCIONES -->
        <script>
        
            function cargarDatos(IdLeadCC){
                
                datos ={IdLeadCC: IdLeadCC, 
                        tipo: 'formulario'};
                        
                console.log(datos);
                
                $.ajax({
                    type: 'POST',
                    url: 'ajax/selectListarLeadsCC.php',
                    data: datos,
                    dataType: 'json',
                    success: function (data) {
                        
                        if(data.resultado == 'exito'){
                            
                            const datosLead = data.lead;
                            
                            completarFormulario(datosLead);
                        }
                        
                    }
                })
            }
            
            function validarDatos(data){
                const {nombres, correo, lbltipodoc, telefono, lbldireccion, lbldistrito, lbltipoDireccion, leadid, segmento, lbltipoventa, lblfvisita, lblhvisita, FObras, lblFVisitaReal, NProspecto, grupoACD, origen, lblreferencia, lblinterior, observaciones, detalleObservaciones,npiso,tiposegmento,tipovial,visePiso,rubroNeg,puertaCalle,nobleParedes,nobleTecho,mcuadrados,motivoInteres,conSistema,empresaSistema,bancarizado } = data;
                
                console.log(NProspecto.length);
                
                if(nombres == '' || nombres == null || !nombres.trim()){
                    Swal.fire('Faltan datos', 'Completar el nombre del cliente', 'warning');
                    return false;
                }
                
                if (correo == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(correo)) {
                    Swal.fire('Faltan datos', 'Por favor ingresar correo válido', 'warning');
                    return false;
                }
                
                if(lbltipodoc == '' || lbltipodoc == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar tipo documento', 'warning');
                    return false;
                }
                
                if(telefono == '' || telefono == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar numero de telefono', 'warning');
                    return false;
                }
                
                if(lbldireccion == '' || lbldireccion == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar direccion del cliente', 'warning');
                    return false;
                }
                
                if(lbldistrito == '' || lbldistrito == null || lbldistrito == "0" || lbldistrito == 0){
                    Swal.fire('Faltan datos', 'Por favor ingresar Distrito correcto', 'warning');
                    return false;
                }

                // if(tipovial == '' || tipovial == null || tipovial == 'Seleccione'){
                //     Swal.fire('Faltan datos', 'Por favor ingresar Tipo Direccion correcto', 'warning');
                //     return false;
                // } 
                
                
                if(lbltipoDireccion == '' || lbltipoDireccion == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar tipo Geolocalización (Exacta/Aproximada)', 'warning');
                    return false;
                }
                
                if(lblreferencia == '' || lblreferencia == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar Referencia', 'warning');
                    return false;
                }
                
                if(leadid == '' || leadid == ''){
                    Swal.fire('Faltan datos', 'Por favor ingresar leadid correcto', 'warning');
                    return false;
                }
                
                if(segmento == '' || segmento == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar segmento correcto', 'warning');
                    return false;
                }

                if(segmento == 'RES'){
                    if(tiposegmento == '' || tiposegmento == null || tiposegmento == 'Seleccione'){
                        Swal.fire('Faltan datos', 'Por favor ingresar tipo residencial correcto', 'warning');
                        return false;
                    }

                    if(npiso == '' || npiso == ''){
                        Swal.fire('Faltan datos', 'Por favor ingresar N°Piso correcto', 'warning');
                        return false;
                    }
                    
                    if(visePiso == '' || visePiso == null){
                        Swal.fire('Faltan datos', 'Vive en piso a proteger', 'warning');
                        return false;
                    }                     
                    
                    
                    
                }
                if(segmento == 'NEG'){
                    if(rubroNeg == '' || rubroNeg == null){
                        Swal.fire('Faltan datos', 'Por favor ingresar Rubro Negocio correcto', 'warning');
                        return false;
                    }

                    if(puertaCalle == ''){
                        Swal.fire('Faltan datos', 'Por favor selecionar vi el negocio esta puerta calle', 'warning');
                        return false;
                    }
                    
                }                
                
 
                
                
                if(lbltipoventa == '' || lbltipoventa ==''){
                    Swal.fire('Faltan datos', 'Por favor ingresar tipo venta correcto', 'warning');
                    return false;
                }
                
                if(lblfvisita == '' || lblfvisita == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar fvisita correcto', 'warning');
                    return false;
                }
                
                if(lblhvisita == '' || lblhvisita == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar hvisita correcto', 'warning');
                    return false;
                }
                
                if(FObras == 'SI'){
                    if(lblFVisitaReal == '' || lblFVisitaReal == null){
                        Swal.fire('Faltan datos', 'Por favor ingresar FECHA VISITA ORIGINAL correcto', 'warning');
                        return false;
                    }
                }
                /*
                if(NProspecto == '' || NProspecto == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar NProspecto', 'warning');
                    return false;
                } else {
                    if(NProspecto.length < 6){
                        Swal.fire('Faltan datos', 'Por favor ingresar NProspecto valido', 'warning');
                        return false;
                    }
                }
                */
                
                if(grupoACD == '' || grupoACD == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar grupoACD', 'warning');
                    return false;
                }
                
                if(origen == '' || origen == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar Origen', 'warning');
                    return false;
                }
                
                if(observaciones == '' || observaciones == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar Observaciones', 'warning');
                    return false;
                }
                console.log(detalleObservaciones);

                if(observaciones == '' || observaciones == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar Observaciones', 'warning');
                    return false;
                }                
                
                if(detalleObservaciones != '' ){
                    const arraydetalleObservaciones = JSON.parse(detalleObservaciones);
                    console.log(arraydetalleObservaciones);
                    if(arraydetalleObservaciones[0] == 'departamento'){
                        if(lblinterior == '' || lblinterior == null){
                            Swal.fire('Faltan datos', 'Por favor ingresar Interior', 'warning');
                            return false;
                        }
                    }
                }

                if(observaciones == '' || observaciones == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar Observaciones', 'warning');
                    return false;
                }
                
                if(nobleParedes == '' || nobleParedes == null){
                    Swal.fire('Faltan datos', 'Paredes Ladrillo - Cemento', 'warning');
                    return false;
                }
                if(nobleTecho == '' || nobleTecho == null){
                    Swal.fire('Faltan datos', 'Paredes Ladrillo - Cemento', 'warning');
                    return false;
                }
                if(mcuadrados == ''){
                    Swal.fire('Faltan datos', 'Metros cuadrados?', 'warning');
                    return false;
                }
                if(motivoInteres == '' || motivoInteres == null){
                    Swal.fire('Faltan datos', 'Motivo de interes', 'warning');
                    return false;
                }
                if(conSistema == '' || conSistema == null){
                    Swal.fire('Faltan datos', 'Con Sistema?', 'warning');
                    return false;
                }
                if(conSistema == 'Si'){
                    if(empresaSistema == '' || nobleParedes == null){
                    Swal.fire('Faltan datos', 'Por favor de ingresar empresa de sistema de alarma', 'warning');
                    return false;
                    }
                }
                if(bancarizado == ''){
                    Swal.fire('Faltan datos', 'Bancarizado?', 'warning');
                    return false;
                }
            
                return true;
            }
            
            function completarFormulario(datosLead){
                
                console.log(datosLead);

                const {Nombres, Apellidos, Telefono, Telefono2, Origen, LeadID, Segmento, FechaHoraCotizacion, NDocumento, Direccion, IdDireccion, ObjGeofinder, TipoDireccion, TipoDocumento, IdGeografico, DistritoGeo, DireccionLead, Observaciones, Accion, FechaConsultaScoring, IdScoring, PerfilScoring,NPiso,TipoSegmento,visePiso,rubroNeg,puertaCalle,nobleParedes,nobleTecho,metros,motivoInteres,conSistema,empresaSistema,bancarizado, OPENumber} = datosLead;
                
                const cliente = `${Nombres} ${Apellidos}`;
                $('#nombres').val(`${Nombres} ${Apellidos}`);
                
                $('#ndocumento').val(NDocumento);
                
                $('#telefono').val(Telefono);
                $('#telefono2').val(Telefono2);
                $('#telefonopantalla').val(Telefono);
                
                $('#lbldireccionAprox').val(Direccion);
                
                $('#origen').val(Origen);
                $('#leadid').val(LeadID);
                $('#openumber').val(OPENumber);
                
                $('#segmento').val(Segmento);

                $('#npiso').val(NPiso);
                $('#tiposegmento').val(TipoSegmento);

                if(Segmento == 'NEG'){
                    $('.Lead__nlocales').removeClass('ocultar');
                    $('.Lead__tiposegmento').addClass('ocultar');
                } else{
                    $('.Lead__nlocales').addClass('ocultar');
                    $('.Lead__tiposegmento').removeClass('ocultar');
                }                
                
                
                $('#fechahoraCotizacion').val(FechaHoraCotizacion);
                
                $('#lbldireccion').val(DireccionLead);
                $('#IdDireccion').val(IdDireccion);
                
                console.log(ObjGeofinder);
                if(ObjGeofinder != null){
                    console.log('Ingreso al objgeofinder');
                    $('#objGeofinderFinal').val(ObjGeofinder);
                    //AGREGAR FUNCIONES ZONIFICACION 
                    //GENERAR ZONAS
                    const objetoGEOFINDER = JSON.parse(ObjGeofinder);
                    console.log(objetoGEOFINDER);
                    
                    let zonas = objetoGEOFINDER.zonas;
                    let microzona = zonas[1].valor;
                    //Funcion para convertir la microzona al valor antiguo
                   // microzona = convertirMicrozona(microzona);
                    console.log(microzona);
                    consultarZonaCC(microzona);
                    //LLENA LA MICROZONA CON LA INFORMACION DEL OBJGEOFINDER
                    $('#microzona').val(microzona);
                    
                    $('#lbltipoDireccion').val(TipoDireccion);
                }
                //$('#lbldistrito').val(IdGeografico);
                //$('#lbldistrito').val(IdGeografico).trigger("change");
                
                var newOption = new Option(DistritoGeo, IdGeografico, true, true);
                $('#lbldistrito').append(newOption).trigger('change');
                
                if(TipoDocumento == 1){
                    $('#lbltipodoc').val('DNI');
                }
                
                $('#observaciones').val(Observaciones);
                
                $('#lblaccion').val(Accion);
                $('#lblFechaHoraReg').val(FechaConsultaScoring);
                $('#idResultadoScoring').val(IdScoring);
                $('#lblperfilscoring').val(PerfilScoring);

                $('#visePiso').val(visePiso);
                $('#rubroNeg').val(rubroNeg);
                $('#puertaCalle').val(puertaCalle);
                $('#nobleParedes').val(nobleParedes);
                $('#nobleTecho').val(nobleTecho);
                $('#mcuadrados').val(metros);
                $('#motivoInteres').val(motivoInteres);
                $('#conSistema').val(conSistema);

                if(conSistema == 'Si'){
                    $('.Lead__empresaAlarmas').removeClass('ocultar');
                } else{
                    $('.Lead__empresaAlarmas').addClass('ocultar');
                }                
                
                $('#empresaSistema').val(empresaSistema);
                $('#bancarizado').val(bancarizado);                   
                
            }
            
            function bloquearCampos(){
                
                if(PerfilUsuario == '55' || PerfilUsuario == '1'){
                    $('#gestion').prop("disabled", true);
                    $('#telefono').prop("disabled", true);
                    $('#origen').prop("disabled", true);
                    $('#leadid').prop("disabled", true);
                    $('#openumber').prop("disabled", true);
                    
                    
                    $('#fechahoraCotizacion').prop('disabled', true);
                } else {
                    $('#setScoring').prop("disabled", true);
                    //ACTIVAR FUNCION
                    $('#fechahoraCotizacion').prop("disabled", false);
                }
            }
            
            function limpiarHTML(cont) {
                //forma recomendada
                while (cont.firstChild) {
                    cont.removeChild(cont.firstChild);
                }
            }
            
        </script>
        <!-- FUNCIONES DIRECCIONES -->
        <script>
            function buscarDireccionLocalStorage(){
                if($('#GeofinderDireccion').val() == ''){
                    
                    localStorage.setItem('intervalBusquedaDireccion', true);
                    
                    let interval = setInterval(() => {
                        if(localStorage.getItem("ObjGeofinder") !== null){
                            const ObjGeofinder = JSON.parse(localStorage.getItem("ObjGeofinder"));
                            
                            //LLENA EL CAMPO OCULTAR CON EL OBJGEOFINDER EN FORMATO JSON
                            $('#objGeofinder').val(JSON.stringify(ObjGeofinder));
                            //CREA LA VARIABLE DIRECCION PARA OBTENER LA DIRECCION COMPLETA
                            let direccion = ObjGeofinder.fulladdress;
                            //GENERAR ZONAS
                            let zonas = ObjGeofinder.zonas;
                            let microzona = zonas[1].valor;
                            //Funcion para convertir la microzona al valor antiguo
                            microzona = convertirMicrozona(microzona);
                            //LLENA LA MICROZONA CON LA INFORMACION DEL OBJGEOFINDER
                            $('#microzona').val(microzona);
                            //LLENA EL PUNTO DIRECCION CON LA INFORMACION DEL OBJGEOFINDER
                            $('#GeofinderDireccion').val(direccion);
                            //LIMPIA EL INTERVALO DE BUSUQEDA
                            clearInterval(interval);
                            //BORRA EL OBJGEOFINDER DEL LOCALSTORAGE
                            localStorage.removeItem("ObjGeofinder");
                            //INTERVALO DE BUSUQEDA DE DIRECCION
                            localStorage.setItem('intervalBusquedaDireccion', false);
                        }
                    }, 2000); 
                }
                
            }
            
            function convertirMicrozona(microzona){
                let nuevaMicrozona = '';
                
                if(microzona.includes('-')){
                
                arraymicrozona = microzona.split("-");
                
                const ubigeo = arraymicrozona[0];
                
                let correlativo = '';
                
                //LISTA DE UBIGEOS CON 3 CARACTERES DE CORRELATIVOS
                
                const arregloUbigeos = ['150132',
                                        '150133',
                                        '130101',
                                        '130104',
                                        '130105',
                                        '130111',
                                        '130103',
                                        '130106',
                                        '130107',
                                        '130109',
                                        '130102',
                                        '200101',
                                        '200104',
                                        '200105',
                                        '200107',
                                        '200108',
                                        '200109',
                                        '200110',
                                        '200111',
                                        '200114',
                                        '200115',
                                        '040122',
                                        '040117',
                                        '040112',
                                        '040129',
                                        '040128',
                                        '040104',
                                        '040103',
                                        '040126',
                                        '040101',
                                        '040111',
                                        '040116',
                                        '040107',
                                        '040109',
                                        '040110',
                                        '040123',
                                        '040124',
                                        '040102',
                                        '040120',
                                        '040118',
                                        '040108',
                                        '040125',
                                        '040121',
                                        '040114',
                                        '040113',
                                        '040119',
                                        '040105',
                                        '040106'];

                if(arregloUbigeos.includes(ubigeo)){
                    
                    correlativo = arraymicrozona[1];
                    
                    if(ubigeo == '150132'){
                        if(correlativo == '0100' || correlativo == '0101' || correlativo == '0102'){
                            correlativo = correlativo.slice(1, 4)
                            nuevaMicrozona = `${ubigeo}${correlativo}`;
                        } else {
                            correlativo = correlativo.slice(2, 4);
                    
                            nuevaMicrozona = `${ubigeo}${correlativo}`;
                        }
                    } else {
                    
                        correlativo = correlativo.slice(1, 4)
                    
                        nuevaMicrozona = `${ubigeo}${correlativo}`;
                    }
                } else {
                    correlativo = arraymicrozona[1];
                    correlativo = correlativo.slice(2, 4);
                    
                    nuevaMicrozona = `${ubigeo}${correlativo}`;
                }
                
                } else {
                    nuevaMicrozona = microzona;
                }
                
                return nuevaMicrozona;
                
            }
            
            $('#Offline').on('click', () => {
                $("#Offline").prop('checked', true);
                $('#Online').prop('checked', false);
            })
            
            $('#Online').on('click', () => {
                $("#Offline").prop('checked', false);
                $('#Online').prop('checked', true);
            })
            
            $('#btnNuevaDireccion').on('click', () => {
                $('#map').attr("src", $('#map').attr("src"));
                limpiarFormulario();
                buscarDireccionLocalStorage();
            })
            
            function limpiarFormulario(){
                $('#GeofinderDireccion').val('');
                $('#objGeofinder').val('');
                $('#microzona').val('');
            }
            
            $('#btnGuardarGeofinderDireccion').on('click', (e) => {
                
                e.preventDefault();
                
                if($('#GeofinderDireccion').val() === '' || $('#GeofinderTelefono').val() ==='' || $('#objGeofinder').val() === ''){
                    Swal.fire(
                      'Alerta!',
                      'Por favor, completar los datos.',
                      'warning'
                    )
                    return;
                }
                    
                let datos = {
                    direccion: $('#GeofinderDireccion').val(),
                    telefono: $('#GeofinderTelefono').val(),
                    objGeofinder: $('#objGeofinder').val(),
                    microzona: $('#microzona').val(),
                    tipo: $('input:radio[name=GeofinderTipoDireccion]:checked').val(),
                    Busqueda: $('input:radio[name=Busqueda]:checked').val()
                };
                
                $.ajax({
                    type: 'POST',
                    url: 'ajax/insertDireccion.php',
                    data: datos,
                    dataType: 'Json',
                    success: function (data) {
                        
                        console.log(data);
                        
                        if(data.respuesta == 'Exito'){
                            
                            let MatriculaUsuario = $('#headerMatriculaUsuario').val();
                            
                            const usuariosPermitos = ['RO8382', 'EU8028', 'Q07435', 'Q09668', 'CI9479', 'OR1248', 'EX3980', 'Q02527', 'AW8955', 'CI9479', 'RO8382', 'EX3980', 'LD8209', 'MM8655', 'Q09668', 'Q13523', 'Q10823', 'Q11124', 'JU9001', 'Q24466', 'Q25649', 'Q25648', 'Q28362'];
                            
                            if((data.asignacion !== null || data.asignacion !== '') && (usuariosPermitos.includes(MatriculaUsuario))){
                                
                                let mensaje;
                                
                                if(data.asignacion == 'Field'){
                                    mensaje = "Se registro la dirección correctamente, GENERAR VISITA";
                                }
                                else if (data.asignacion == 'TV'){
                                    mensaje = "Se registro la dirección correctamente, <span style='color: red; font-weight: bold'>ENVIAR A TELEVENTA</span>";
                                }
                                else {
                                    mensaje = "Se registro la dirección correctamente";
                                }
                                
                                
                                Swal.fire(
                                    'Registro Exitoso!',
                                    mensaje,
                                    'success'
                                )
                                
                            } else {
                                Swal.fire(
                                  'Registro Exitoso!',
                                  'Se registro la dirección correctamente',
                                  'success'
                                )
                            }
                            
                            $('#lbldireccionAprox').val($('#GeofinderDireccion').val());
                            
                            const idDireccion = data.idDireccion;
                            $('#IdDireccion').val(idDireccion);
                            //DATOS DE GEOFINDER Y ZONIFICACION
                            $('#objGeofinderFinal').val($('#objGeofinder').val());
                            
                            consultarZonaCC($('#microzona').val())
                            
                            limpiarFormulario();
                            buscarDireccionLocalStorage();
                            $('#map').attr("src", $('#map').attr("src"));
                            
                            $('#mapgeofinder').modal('hide');
                            
                        } else {
                            Swal.fire(
                              'Error!',
                              'Ocurrio un error, por favor verificar.',
                              'error'
                            )
                        }
                        
                    }
                })
            })
            
            function consultarZonaCC(microzona){
                
                microzona = convertirMicrozona(microzona);
                
                console.log(microzona);
                
                data = {microzona: microzona};
                
                fetch('ajax/findDataZonificacion.php', {method: 'POST', body: JSON.stringify(data)})
                .then(function(res) {
                    return res.json();
                })
                .then(function(datos) {
                    console.log(datos);
                    if(datos.resultado === "exito"){
                        
                        let datosZonficacion = datos.datos;
                        
                        //<p> <strong>Codigo Zonificacion:</strong> ${datosZonficacion.CodigoDelegacion} </p> 
                        //<p> <strong>Delegado:</strong> ${datosZonficacion.Delegado} (${datosZonficacion.MatriculaDelegado}) </p>
                        
                        $('#objZonificacionVerisure').val(JSON.stringify(datosZonficacion));
                        $('#idZonificacion').val(datosZonficacion.IdZonificacion);
                        $('#microzona').val(datosZonficacion.Microzona);
                        //$('#lbldcobjzonificacion').val(datosZonficacion.CodigoDelegacion);
                    } 
                    /*
                    else {
                        Swal.fire(
                          'Error!',
                          'El prospecto no pudo ser zonificado, comuniquese con soporte',
                          'error'
                        )
                    }
                    */
                })
                .catch(function(error) {
                    console.log(error);
                })
            }
        </script>
        <!-- SCORING -->
        <script>
            
            $('#setAccion').on('click', function(e){
                e.preventDefault();
                
                if($('#lblaccion').val() == ''){
                    $('#modal-consultascoring').modal('show');
                } else {
                    Swal.fire({
                        title: '¿Quieres Scorear?',
                        text: "El prospecto ya cuenta con un score",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '##454141',
                        confirmButtonText: 'Si, Scorear'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $('#modal-consultascoring').modal('show');
                            }
                    } ) //END RESULT
                }
            })
            
            $('#EquifaxDepartamental').change(() => {
                $("#EquifaxDepartamental option:selected").each(function () {
                    //Obtener valor del Departamento y asignarlo a la variable provincia (mala definicion de la funcion)
                    const Provincial = $(this).val();
                    //Genera un objeto provincia (departamento) para traer los datos de la provincia
                    const datos={
                        Provincial:Provincial
                    };
                    //Definir las variables del select de provincia y distrito. Se modifica a const por se constantes
                    const provincia= $("#EquifaxProvincial");
                    const distrito= $("#EquifaxDistrital");
                    //Ajax para traer los datos de la base de datos. //CONSULTAR PROVINCIA
                    $.ajax({
                        data:datos,
                        url:   './ajax/selectProvincial.php',
                        type:  'POST',
                        dataType: 'json',
                        success:  function (r) {
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                            
                            // Limpiamos el select de Provincia
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            // Limpiamos el select de Distrito
                            distrito.find('option').remove();
                            distrito.append('<option value="">Seleccione</option>');
                            
                            $(r).each(function(i, v){ // indice, valor
                                provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                            })
                            
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                        },
                        error: function()
                        {
                            //alert('Ocurrio un error en el servidor ..');
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                        }
                    });
                })      
            })
            
            $("#EquifaxProvincial").change(function () {
                $("#EquifaxProvincial option:selected").each(function () {
                    var Provincial = $(this).val();
                    var datos={
                        Provincial:Provincial
                    };
                    var provincia= $("#EquifaxDistrital");
                     $.ajax({
                        data:datos,
                        url:   './ajax/selectDistrital.php',
                        type:  'POST',
                        dataType: 'json',
                        success:  function (r) {
                            provincia.prop('disabled', false);
                            
                            // Limpiamos el select
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            
                            $(r).each(function(i, v){ // indice, valor
                                provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                            })
                            
                            provincia.prop('disabled', false);
                        },
                        error: function(){
                            //alert('Ocurrio un error en el servidor ..');
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            provincia.prop('disabled', false);
                        } //END ERROR
                    }); //END AJAX
                }); //END OPTION SELECTED
            });
            
            $("#modal-consultascoring" ).on('shown.bs.modal', function(){
                cargardepartamentoEquifax();
            });
            
            $('#btnScoring').on('click', function(){
                $('#btnScoring').prop('disabled', true);
                
                $('#divLoading').show();
                
                var matriculausuario=$('#matriculausuario').val(); 
                var nombreusuario=$('#nombreusuario').val();
                var TipoDocumento = $('#EquifaxTipoDocumento').val();
                var Documento = $('#EquifaxDocumento').val();
                var Departamental=$("#EquifaxDepartamental option:selected").text();
                var Provincial=$("#EquifaxProvincial option:selected").text();
                var Distrital=$("#EquifaxDistrital option:selected").text();
                var Ubigeo=$("#EquifaxDistrital").val();
                
                var datos = {
                    matriculausuario:matriculausuario,
                    nombreusuario:nombreusuario,
                    TipoDocumento: TipoDocumento,
                    Documento: Documento,
                    Departamental:Departamental,
                    Provincial:Provincial,
                    Distrital:Distrital,
                    Ubigeo:Ubigeo
                }
                
                if(validaFormEquifax(datos)){
                    
                    $.ajax({
                        type: "Post",
                        data: datos,
                        url: "ajax/funciones/soap2_pre.php",
                        dataType: "Json",
                        success: function (data){
                            
                            console.log(data);
                            
                            if (data.tipo == 'exito'){
                                
                                //AGREGA EL NDOCUMENTO AL INPUT
                                $('#ndocumento').val($('#EquifaxDocumento').val());
                                //GENERAR RESULTADO PARA EL MODAL
                                $('#FechaConsulta').html(data.fecha);
                                //AGREGAR FECHA SCORING AL CAMPO FECHA ULTIMA CONSULTA
                                $('#fechaConsultaScoring').val(data.fecha);
                                //ARREGLO DE DATOS DEL RESULTADO
                                var resultado = data.datos;
                                //RESULTADO DE SCORING
                                //var resultadooperacion=resultado.respuestaSVC11Type.GrupoCampos.Campo[1].Valor;
                                var resultadooperacion=data.AccionMKT;
                                //PEGAR RESULTADO DE SCORING Y ID EN LOS CAMPOS
                                $('#lblaccion').val(resultadooperacion);
                                $('#idResultadoScoring').val(data.id_scoring);
                                $('#lblFechaHoraReg').val(data.fecha);
                                $('#lblperfilscoring').val(data.PerfilScoring);
                                
                                $('.TextoAccion').html(resultadooperacion);
                                
                                if(resultadooperacion=="Generar Visita"){
                                    $('.bg-visita').show();
                                    $('.bg-televenta').hide();
                                    $('.bg-gestion').hide();
                                }else if(resultadooperacion=="Pasar a base de datos-48 horas" || resultadooperacion=="Pasar a Televenta"){
                                    $('.bg-visita').hide();
                                    $('.bg-televenta').show();
                                    $('.bg-gestion').hide();
                                }else{
                                    $('.bg-visita').hide();
                                    $('.bg-televenta').hide();
                                    $('.bg-gestion').show();
                                }
                                
                                $('#idscoring').val(data.id_scoring);
                                //$('#ResultadoOperacion').html(resultado.respuestaSVC11Type.GrupoCampos.Campo[1].Valor);
                               //$('#NOperacion').html(resultado.respuestaSVC11Type.Header.NumeroOperacion);
                                $('#Riesgo').html(resultado.respuestaSVC11Type.Scores.Score.Riesgo + ' Riesgo');
                                if (resultado.respuestaSVC11Type.Integrante.TipoDocumento == 1){
                                    $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno +' '+resultado.respuestaSVC11Type.Integrante.ApellidoMaterno +' '+resultado.respuestaSVC11Type.Integrante.Nombres);
                                    $('#TDocumento').html("DNI:");
                                }
                                else if (resultado.respuestaSVC11Type.Integrante.TipoDocumento == 6){
                                    if(resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0,2)==10 || resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0,2)==15 || resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0,2)==17){
                                        $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno +' '+resultado.respuestaSVC11Type.Integrante.ApellidoMaterno +' '+resultado.respuestaSVC11Type.Integrante.Nombres);
                                    }else{
                                        $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.RazonSocial);
                                    }
                                    $('#TDocumento').html("RUC:");
                                }else{
                                    $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno +' '+resultado.respuestaSVC11Type.Integrante.ApellidoMaterno +' '+resultado.respuestaSVC11Type.Integrante.Nombres);
                                    $('#TDocumento').html("CE:");
                                }
            
                                $('#NumeroDocumento').html(resultado.respuestaSVC11Type.Integrante.NumeroDocumento);
            
                                $('#ValorScoring').html(resultado.respuestaSVC11Type.Scores.Score.Valor);
                                
                                if(resultadooperacion=="Pasar a base de datos-48 horas"){
                                      $('#lbltipotransf').val('BD48horas');
                                 }else{
                                      $('#lbltipotransf').val('');
                                  }
                                            
                                $('#divLoading').hide();

                                $('#ResultadoEquifax').show();
                                $('#EquifaxTipoDocumento').prop('disabled', true); 
                                $('#EquifaxDocumento').prop('disabled', true);
                                
                                $("#EquifaxDepartamental").prop('disabled', true); 
                                $("#EquifaxProvincial").prop('disabled', true); 
                                $("#EquifaxDistrital").prop('disabled', true);
                                //$('#btnScoring').hide();
                                //$('#btnScoring').prop('disabled', false);
                                $('#btnNuevaScoring').show();
                            } else {
                                $('#divLoading').hide();
                                alert(data.mensaje);
                                $('#btnScoring').show();
                                $('#btnScoring').prop('disabled', false);
                                $('#btnNuevaScoring').hide();
                            }
                        } //END SUCCESS
                    }) //END AJAX
                } else{
                    
                    $('#divLoading').hide();
                    $('#btnScoring').prop('disabled', false);
                }
                
            })
            
            $('#btnNuevaScoring').on('click',function(){
                    $('#ResultadoEquifax').hide();
                    $('#EquifaxTipoDocumento').prop('disabled', false); 
                    $('#EquifaxDocumento').prop('disabled', false);
                    
                    $("#EquifaxDepartamental").prop('disabled', false); 
                    $("#EquifaxProvincial").prop('disabled', false); 
                    $("#EquifaxDistrital").prop('disabled', false);
                    
                    $('#btnNuevaScoring').hide();
                    $('#btnScoring').show();
                    $('#btnScoring').prop('disabled', false);
                    
                    $('#idscoring').val("");
                    
                    $('#EquifaxTipoDocumento').val("1"); 
                    $('#EquifaxDocumento').val("");
                    
                    $("#EquifaxDepartamental").val("");
                    $("#EquifaxProvincial").find('option').remove();
                    $("#EquifaxProvincial").append('<option value="">Seleccione</option>');
                    $("#EquifaxDistrital").find('option').remove();
                    $("#EquifaxDistrital").append('<option value="">Seleccione</option>');
                    
                    cargardepartamentoEquifax();
                    
          });
            
            function cargardepartamentoEquifax(departamento, provincia, distrito){
                const EquifaxDepartamental = $('#EquifaxDepartamental');
                
                $.ajax({
                    url:   './ajax/selectDepartamental.php',
                    type:  'POST',
                    dataType: 'json',
                    success:  function (datos) {
                        //Departamento equifax
                        EquifaxDepartamental.find('option').remove();
                        EquifaxDepartamental.append('<option value="">Seleccione</option>');
                        //LLENAR LOS CAMPOS DEPARTAMENTO 
                        $(datos).each(function(i, v){ // indice, valor
                            if(v.id == departamento ){
                                EquifaxDepartamental.append('<option value="' + v.id + '">' + v.text + '</option>');
                            } else {
                                EquifaxDepartamental.append('<option value="' + v.id + '">' + v.text + '</option>');
                            }
                            
                            //Seleccionar al departamento de Lima si es un nuevo registro
                            if(departamento == '' || departamento == null){
                                $("#Departamental option[value='15']").attr("selected",true);
                            }
                            
                            $("#EquifaxDepartamental option[value='15']").attr("selected",true);
                        
                            $("#EquifaxDepartamental option:selected").each(function () {

                            const datos={
                                Provincial: $(this).val()
                            };
                            
                            const EquifaxProvincial= $("#EquifaxProvincial");
                            const EquifaxDistrital= $("#EquifaxDistrital");
                            
                            $.ajax({
                                data:datos,
                                url:   './ajax/selectProvincial.php',
                                type:  'POST',
                                dataType: 'json',
                                success:  function (data) {
                                    // Limpiamos el select de Provincia
                                    EquifaxProvincial.find('option').remove();
                                    EquifaxProvincial.append('<option value="">Seleccione</option>');
                                    // Limpiamos el select de Distrito
                                    EquifaxDistrital.find('option').remove();
                                    EquifaxDistrital.append('<option value="">Seleccione</option>');
                                    
                                    $(data).each(function(i, v){ // indice, valor
                                        EquifaxProvincial.append('<option value="' + v.id + '">' + v.text + '</option>');
                                    })
                                    
                                    $("#EquifaxProvincial option[value='128']").attr("selected",true);
                                    
                                    $("#EquifaxProvincial option:selected").each(function () {
                                        
                                        const datos={
                                            Provincial: $(this).val()
                                        };
                                    
                                        $.ajax({
                                            data:datos,
                                            url:   './ajax/selectDistrital.php',
                                            type:  'POST',
                                            dataType: 'json',
                                            success:  function (data) {
                                                // Limpiamos el select
                                                EquifaxDistrital.find('option').remove();
                                                EquifaxDistrital.append('<option value="">Seleccione</option>');
                                                
                                                $(data).each(function(i, v){ // indice, valor
                                                    EquifaxDistrital.append('<option value="' + v.id + '">' + v.text + '</option>');
                                                })
                                                EquifaxDistrital.trigger('change');
                                                
                                                EquifaxDistrital.prop('disabled', false);
                                            }
                                        });

                                    });
                            
                                }
                            });

                        });
                        })
                    }
                })
            }
            
            function validaFormEquifax(datos){
                const {TipoDocumento, Documento, Departamental, Provincial, Distrital} = datos;
                
                if (TipoDocumento == "") {
                    alertify.warning("Por favor ingresar Tipo de Documento");
                    return false;
                }
                
                if (Documento == "") {
                   alertify.warning("Por favor ingresar Número de Documento");
                   return false;
                }
                
                if (TipoDocumento == "6") {
                    if (Documento.length!=11) {
                       alertify.warning("Por favor ingresar los 11 digitos del RUC");
                       $("#EquifaxDocumento").focus();
                       return false;
                    }
                    
                    if (Documento.substr(0,2)==10 || Documento.substr(0,2)==20 || Documento.substr(0,2)==15 || Documento.substr(0,2)==17) {
                              
                    }else{
                        alertify.warning("Por favor ingresar correctamente el RUC debe comenzar 10 o 20");
                        $("#EquifaxDocumento").focus();
                        return false;
                    }
                }
                
                if (TipoDocumento == "1") {
                    if (Documento.length!=8) {
                        alertify.warning("Por favor ingresar los 8 digitos del DNI");
                        $("#EquifaxDocumento").focus();
                        return false;
                    }
                }
                
                if (TipoDocumento == "3") {
                    if (Documento.length==0) {
                       alertify.warning("Por favor ingresar CE");
                       $("#EquifaxDocumento").focus();
                       return false;
                    }
                }
                
                if (Departamental == "") {
                    alertify.warning("Por favor ingresar Departamento correspondiente");
                    $("#EquifaxDepartamental").focus();
                    return false;
                }
                if (Provincial == "") {
                    alertify.warning("Por favor ingresar Pronvincia correspondiente");
                    $("#EquifaxProvincial").focus();
                    return false;
                }
                if (Distrital == "") {
                    alertify.warning("Por favor ingresar Distrito correspondiente");
                    $("#EquifaxDistrital").focus();
                    return false;
                }
                
                return true;
            }
        </script>
        
        <!-- CALIFICACION -->
        <script>
            $('#btnDetalleObservaciones').on('click', async function(){
                const { value: formValues } = await Swal.fire({
                  title: 'Observaciones',
                  html:
                    `<select style="width: 100%;" id="tipoInstalacion" class="swal2-select">
                        <option value="" disabled selected>TIPO INSTALACION</option>
                        <option value="casa">CASA</option>
                        <option value="departamento">DEPARTAMENTO</option>
                        <option value="NEGOCIO AL PUBLICO">NEGOCIO AL PUBLICO</option>
                        <option value="OTROS">OTROS</option>
                        <option value="BODEGA">BODEGA</option>
                    </select>
                    <select style="width: 100%;" id="robo" class="swal2-select">
                        <option value="" disabled selected>SUFRIO ROBO</option>
                        <option value="SI">SI</option>
                        <option value="NO">NO</option>
                    </select>
                    <input type="number" style="width: 100%;" class="swal2-select" id="metrosCuadrados" placeholder="Ingresar metros cuadrados a proteger"/>
                    <input type="number" style="width: 100%;" class="swal2-select" id="pisos" placeholder="Ingresar numero de pisos"/>
                    `,
                  focusConfirm: false,
                  preConfirm: () => {
                    return [
                      document.getElementById('tipoInstalacion').value,
                      document.getElementById('robo').value,
                      document.getElementById('metrosCuadrados').value,
                      document.getElementById('pisos').value
                    ]
                  }
                })
                
                console.log(formValues);
                
                if (formValues) {
                    
                    const arregloDetallesObservacion = JSON.stringify(formValues);
                    
                    $('#detalleObservaciones').val(arregloDetallesObservacion);
                    
                    const textObservaciones =  `TIPO DE INSTALACION O VIVIENDA: ${formValues[0]}, SUFRIO ROBO: ${formValues[1]}, 
                                                M2 a PROTEGER: ${formValues[2]}, PISOS A PROTEGER: ${formValues[3]}`;
                                                
                    Swal.fire(textObservaciones, '', 'success');                            
                    
                    //$('#lblcalificarGestion').val(arregloCalificacion);
                    //Swal.fire('Calificada', '', 'success');
                }
            })
        </script>

    </body>

</html>