<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
    	exit;
    }

    if ($_SESSION['pzmktmarketing']==0) {
        header("location: ./denegado.php");
		exit;
    }
        
    $user = $_SESSION['id_usuario']; //MODIFICACION EMU 16.05

    date_default_timezone_set('America/Lima');
    
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }

    include 'config/db.php';
    include 'config/conexion.php';
    include 'helper/helper_validacion.php';


    if (isset($_GET['idventa'])) {
        $idventa = sanitizaCampo($_GET['idventa'], 'sanitizeint|scapestring|htmlspecialchars',$con);
        $idventa = htmlspecialchars($idventa);
    }
    
    if (isset($_GET['visitarelacionada'])) {
        $visitarelacionada = sanitizaCampo($_GET['visitarelacionada'], 'scapestring|htmlspecialchars',$con);
        $visitarelacionada = htmlspecialchars(visitarelacionada);
    }    
    
    

    $fechames=date("M-Y");

    $sql_venta = $con->prepare("SELECT
        u.IdUsuario,
        v.Matricula,
        v.Comercial,
        v.CC,
        v.JefeVenta,
        CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
        v.EstadoVenta,
        v.CategoriaVenta,
        v.TipoVenta,
        v.Segmento,
        v.MesesAutorizado,
        v.NProspecto,
        v.NContrato,
        v.IdCliente,
        c.NombApellido Cliente,
        c.Correo,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        c.Referencia,
        c.Interior,
        c.objGeofinder,
        g.IdGeografico,
        g.Distrito,
        g.Provincia,
        v.PrecioKit,
        v.TotalExtra,
        v.ResumenVenta,
        v.ExtraAutorizado,
        v.FormaPago,
        v.N590,
        v.PAI,
        v.CCOriginal,
    	v.EstadoVisita,
    	DATE_FORMAT(v.FechaVisita,'%d/%m/%Y') FechaVisita,
    	TIME_FORMAT(v.HoraVisita,'%r') HoraVisita,
    	DATE_FORMAT(v.FVencimientoVisita,'%d/%m/%Y') FVencimientoVisita,
    	DATE_FORMAT(v.FVisitaObras, '%d/%m/%Y') FVisitaObras,
    	v.FObras, 
    	v.GestorMKT,
    	CONCAT(mk.Nombres,' ',mk.Apellidos) Operador,
    	v.OrigenVisita,
    	v.ComentarioVisita,
        v.Checkin,
        v.InfoCheckIn,
        v.VisitaNoVisitable,
        v.infoVNOV,
        v.LeadID,
        agen.IdAgenda,
        agen.InstaladoX,
        agen.MatriculaTec,
        CONCAT(t.Nombres,' ',t.Apellidos) Instalador,
        t.LN LNInstalador,
        DATE_FORMAT(agen.FechaInst, '%d/%m/%Y') FechaInst, 
        TIME_FORMAT(agen.HoraInst,'%r') HoraInst,
        agen.Comentario,
        agen.MotivoInviable,
        agen.MotivoCancelada,
        agen.Repercusion,
        f.MotivoIncidencia,
        DATE_FORMAT(f.FechaRecepcionDOC, '%d/%m/%Y') FechaRecepcionDOC,
        DATE_FORMAT(f.FechaFacturacion, '%d/%m/%Y') FechaFacturacion,
        f.DOCOriginal,
        f.Segmentacion,
        f.Pago,
        f.Autoriza,
        f.DNI,
        f.ElementosCTOPS,
        f.DOCPAI,
        f.FaltaDOC,
        f.RehacerCTO,
        f.Afiliacion,
        f.Prospecto_NroGuia,
        f.FueraHora,
        v.EstadoTelecierre,
        v.TCGestor,
        v.TCComentario,
        v.PrecioKITOriginal,
        v.TotalExtraOriginal,
        v.ResumenVentaOriginal,
        v.ExtraAutorizadoOriginal,
        v.FormaPagoOriginal,
        v.MesesAutorizadoOriginal,
        v.PAIOriginal,
        v.TCMotivoNoVenta,
        v.TCTipoVenta,
        v.MesVisita,
        c.IdDocVisita,
        docv.TipoDocumento,
        docv.Documento,
        c.DireccionAprox,
        c.TipoDireccion,
        tmp.IdConsultaScoring,
        tmp.AccionMKT,
        tmp.FechaHoraReg,
        v.PerfilScoring,
        c.TipoSegmento,
        c.NPiso,
        c.TipoVial,
        v.MotivoAsignacion,
        v.ContactoAsignacion,
        v.CumpleRanking,
        v.visePiso,
        v.rubroNeg,
        v.puertaCalle,
        v.nobleParedes,
        v.nobleTecho,
        v.metros,
        v.motivoInteres,
        v.conSistema,
        v.empresaSistema,
        v.bancarizado,
        v.SeAnula,
        v.ComentariosAnulacion,
        v.DetalleAnulacion,
        v.errorGestion,
        v.segundaDireccion
        FROM dbVENTAS.tblventa v 
        LEFT JOIN dbUSUARIO.tblusuario u on v.IdUsuario=u.IdUsuario 
        LEFT JOIN dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
        LEFT JOIN dbUSUARIO.tblusuario m on m.Matricula=u.Manager
        INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
        INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
        INNER JOIN dbVENTAS.tblagenda agen on agen.IdVenta=v.IdVenta
        INNER JOIN dbVENTAS.tblfacturacion f on f.IdVenta=v.IdVenta
        LEFT JOIN dbUSUARIO.tblusuario t on t.Matricula=agen.MatriculaTec
        LEFT JOIN dbUSUARIO.tblusuario mk on mk.Matricula=v.GestorMKT
        LEFT JOIN dbVENTAS.tbldocumento docv on docv.IdDoc=c.IdDocVisita
        LEFT JOIN dbVENTAS.tbltmpscoring tmp on tmp.IdConsultaScoring=v.IdConsultaScoring
        WHERE v.IdVenta=?");
        $sql_venta->bind_param('i',$idventa);
        $sql_venta->execute();
        $sql_venta->store_result();
        $sql_venta->bind_result(
            $IdUsuarioRow,
            $MatriculaRow,
            $ComercialRow,
            $CCRow,
            $JefeVentaRow,
            $NombJefeVentaRow,
            $EstadoVentaRow,
            $CategoriaVentaRow,
            $TipoVentaRow,
            $SegmentoRow,
            $MesesAutorizadoRow,
            $NProspectoRow,
            $NContratoRow,
            $IdClienteRow,
            $ClienteRow,
            $CorreoRow,
            $TelefonounoRow,
            $TelefonodosRow,
            $DireccionRow,
            $ReferenciaRow,
            $InteriorRow,
            $objGeofinderRow,
            $IdGeograficoRow,
            $DistritoRow,
            $ProvinciaRow,
            $PrecioKitRow,
            $TotalExtraRow,
            $ResumenVentaRow,
            $ExtraAutorizadoRow,
            $FormaPagoRow,
            $N590Row,
            $PAIRow,
            $CCOriginalRow,
            $EstadoVisitaRow,
            $FechaVisitaRow,
            $HoraVisitaRow,
            $FVencimientoVisitaRow,
            $FVisitaObrasRow,
            $FObrasRow, 
            $GestorMKTRow,
            $OperadorRow,
            $OrigenVisitaRow,
            $ComentarioVisitaRow,
            $CheckinRow,
            $InfoCheckInRow,
            $VisitaNoVisitableRow,
            $infoVNOVRow,
            $LeadIDRow,
            $IdAgendaRow,
            $InstaladoXRow,
            $MatriculaTecRow,
            $InstaladorRow,
            $LNInstaladorRow,
            $FechaInstRow, 
            $HoraInstRow,
            $ComentarioRow,
            $MotivoInviableRow,
            $MotivoCanceladaRow,
            $RepercusionRow,
            $MotivoIncidenciaRow,
            $FechaRecepcionDOCRow,
            $FechaFacturacionRow,
            $DOCOriginalRow,
            $SegmentacionRow,
            $PagoRow,
            $AutorizaRow,
            $DNIRow,
            $ElementosCTOPSRow,
            $DOCPAIRow,
            $FaltaDOCRow,
            $RehacerCTORow,
            $AfiliacionRow,
            $Prospecto_NroGuiaRow,
            $FueraHoraRow,
            $EstadoTelecierreRow,
            $TCGestorRow,
            $TCComentarioRow,
            $PrecioKITOriginalRow,
            $TotalExtraOriginalRow,
            $ResumenVentaOriginalRow,
            $ExtraAutorizadoOriginalRow,
            $FormaPagoOriginalRow,
            $MesesAutorizadoOriginalRow,
            $PAIOriginalRow,
            $TCMotivoNoVentaRow,
            $TCTipoVentaRow,
            $MesVisitaRow,
            $IdDocVisitaRow,
            $TipoDocumentoRow,
            $DocumentoRow,
            $DireccionAproxRow,
            $TipoDireccionRow,
            $IdConsultaScoringRow,
            $AccionMKTRow,
            $FechaHoraRegRow,
            $PerfilScoringRow,
            $TipoSegmentoRow,
            $NPisoRow,
            $TipoVialRow,
            $MotivoAsignacionRow,
            $ContactoAsignacionRow,
            $CumpleRankingRow,
            $visePisoRow,
            $rubroNegRow,
            $puertaCalleRow,
            $nobleParedesRow,
            $nobleTechoRow,
            $metrosRow,
            $motivoInteresRow,
            $conSistemaRow,
            $empresaSistemaRow,
            $bancarizadoRow,
            $SeAnulaRow,
            $ComentariosAnulacionRow,
            $DetalleAnulacionRow,
            $errorGestionRow,
            $segundaDireccion
            );
        
    $numrows_venta = $sql_venta->num_rows;


    if ($numrows_venta > 0) {
        while ($sql_venta->fetch()) {
            $idu= $IdUsuarioRow;
            $matricula= $MatriculaRow;
            $comercial= $ComercialRow;
            $matjefe= $JefeVentaRow;
            $jefeventa= $NombJefeVentaRow;
            $dc= $CCRow;
            $estadoventa= $EstadoVentaRow;
            $categoriaventa= $CategoriaVentaRow;
            $tipoventa= $TipoVentaRow;
            $segmento= $SegmentoRow;
            $mesesautorizados= $MesesAutorizadoRow;
            $nprospecto= $NProspectoRow;
            $ncontrato= $NContratoRow;
            $idcliente= $IdClienteRow;
            $cliente= $ClienteRow;
            $correo= $CorreoRow;
            $movil= $TelefonounoRow;
            $fijo= $TelefonodosRow;
            $direccion= $DireccionRow;
            $preciokit= $PrecioKitRow;
            $totalextra= $TotalExtraRow;
            $resumenventa= $ResumenVentaRow;
            $regaloutorizado= $ExtraAutorizadoRow;
            $formadepago= $FormaPagoRow;
            $n590= $N590Row;
            $PAI= $PAIRow;
            $idgeografico= $IdGeograficoRow;
            $distrito= $DistritoRow;
            $provincia= $ProvinciaRow;
            $lninstalador= $LNInstaladorRow;
            $idagenda= $IdAgendaRow;
            $instaladox= $InstaladoXRow;
            $matriculatec= $MatriculaTecRow;
            $nomreinstalador= $InstaladorRow;
            $fechainstalacionver= $FechaInstRow;
            $horainstalacionver= $HoraInstRow;
            $comentarioagenda= $ComentarioRow;
            $motivoinviable= $MotivoInviableRow;
            $motivocancelado= $MotivoCanceladaRow;
            $repercucion= $RepercusionRow;
            $CCOriginal= $CCOriginalRow;
            $factmotivoincidencia= $MotivoIncidenciaRow;
            $factfecharecepciondoc= $FechaRecepcionDOCRow;
            $factfechafacturacion= $FechaFacturacionRow;
            $factdocoriginal= $DOCOriginalRow;
            $factsegmentacion= $SegmentacionRow;
            $factpago= $PagoRow;
            $factautoriza= $AutorizaRow;
            $factdni= $DNIRow;
            $factelementosctops= $ElementosCTOPSRow;
            $factdocpai= $DOCPAIRow;
            $factfaltadoc= $FaltaDOCRow;
            $factrehacercto= $RehacerCTORow;
            $factafiliacion= $AfiliacionRow;
            $factprospecto_nroguia= $Prospecto_NroGuiaRow;
            $factfuerahora= $FueraHoraRow;
    
            //Visita
    
            $estadovisita= $EstadoVisitaRow;
            $fechavisita= $FechaVisitaRow;
            $horavisita= $HoraVisitaRow;
            $fvencimientovisita= $FVencimientoVisitaRow;
            $FVisitaObras= $FVisitaObrasRow;
            $matriculagestormkt= $GestorMKTRow;
            $operadormkt= $OperadorRow;
            $origenvisita= $OrigenVisitaRow;
            $comentariovisita= desanitizaCampo($ComentarioVisitaRow,'htmlspecialchars|scapestring');
            $checkin= $CheckinRow;
            $mesvisita= $MesVisitaRow;
            $LeadID= $LeadIDRow;
            $FObras= $FObrasRow; //MODIFICACION EMU 16.05
    
            $estadotelecierre= $EstadoTelecierreRow;
            $TCGestor= $TCGestorRow;
            $TCComentario= $TCComentarioRow;
            $PrecioKITOriginal= $PrecioKITOriginalRow;
            $TotalExtraOriginal= $TotalExtraOriginalRow;
            $ResumenVentaOriginal= $ResumenVentaOriginalRow;
            $ExtraAutorizadoOriginal= $ExtraAutorizadoOriginalRow;
            $MesesAutorizadoOriginal= $MesesAutorizadoOriginalRow;
            $PAIOriginal= $PAIOriginalRow;
            $TCMotivoNoVenta= $TCMotivoNoVentaRow;
            $TCTipoVenta= $TCTipoVentaRow;
            $FormaPagoOriginal= $FormaPagoOriginalRow;
        
            //Modificacion Cliente
            $IdDocVisita= $IdDocVisitaRow;
            $TipoDocumento= $TipoDocumentoRow;
            $Documento= $DocumentoRow;
            $Referencia= $ReferenciaRow;
            $Interior= $InteriorRow;
            $objGeofinder=desanitizaCampo($objGeofinderRow,'htmlspecialchars|htmlspecialchars|scapestring');
            $DireccionAprox=$DireccionAproxRow;
            $DireccionAprox = str_replace('/', '', $DireccionAprox);
            
            $TipoDireccion=$TipoDireccionRow;
            
            $InfoCheckIn=$InfoCheckInRow;
            
            if($InfoCheckIn != '' || $InfoCheckIn != null){
                $objCheckIn=json_decode($InfoCheckIn, true);
                
                $Distancia= number_format (floatval($objCheckIn['Distancia']), 2);
                $FechaEnvio=$objCheckIn['FechaEnvio'];
                $Tipo=$objCheckIn['Tipo'];
                $MatriculaCheckIn=$objCheckIn['Matricula'];
                $lblnombcomercial=$objCheckIn['lblnombcomercial'];
                
                
                //$ComentariosCheckIN= $row['ComentariosCheckIN'];
                
                $ObservacionesCheckIN= $objCheckIn['ObservacionesCheckIN'];
            } else {
                $Distancia='';
                $FechaEnvio='';
                $Tipo='';
                $MatriculaCheckIn='';
                $lblnombcomercial='';
                $ObservacionesCheckIN='';
            }
            $VisitaNoVisitable= $VisitaNoVisitableRow;
            $infoVNOV=$infoVNOVRow;
            if($infoVNOV != '' || $infoVNOV != null){
                $objVNOV=json_decode($infoVNOV, true);
                $MotivoVNOV = $objVNOV['Motivo'];
            } else {
                $objVNOV = '';
                $MotivoVNOV = '';
            }
            //Scoring
            $lblIdConsultaScoring=$IdConsultaScoringRow;
            $lblAccion=$AccionMKTRow;
            $lblFechaHoraReg=$FechaHoraRegRow;
            $lblPerfilScoring=$PerfilScoringRow;
            
            $TipoSegmento=$TipoSegmentoRow;
            $NPiso=$NPisoRow;
            $TipoVial=$TipoVialRow;
            $MotivoAsignacion=$MotivoAsignacionRow;
            $CumpleRanking=$CumpleRankingRow;
            $ContactoAsignacion=$ContactoAsignacionRow;
            
            $visePiso=$visePisoRow;
            $rubroNeg=$rubroNegRow;
            $puertaCalle=$puertaCalleRow;
            $nobleParedes=$nobleParedesRow;
            $nobleTecho=$nobleTechoRow;
            $metros=$metrosRow;
            $motivoInteres=$motivoInteresRow;
            $conSistema=$conSistemaRow;
            $empresaSistema=$empresaSistemaRow;
            $bancarizado=$bancarizadoRow;
            
            /* ANULACIONES */
            $SeAnula = $SeAnulaRow;
            $ComentariosAnulacion = $ComentariosAnulacionRow;
            $DetalleAnulacion = $DetalleAnulacionRow;
            $errorGestion = $errorGestionRow;

        }
    }
    
    /* JEFES DE DELEGACION */
    $htmlJ = NULL;
    
    $sqlJ = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) GerenteDelegacion FROM dbUSUARIO.tblusuario u WHERE u.Categoria ='DEL' AND Estado = 'Activo'"); 
    //$sql->bind_param('i',$CCOriginal);
    $sqlJ->execute();
    $sqlJ->store_result();
    $sqlJ->bind_result(
        $MatriculaRowJ,
        $GerenteDelegacionRow
    ); 
    
    if ($sqlJ->num_rows > 0) {
        while ($sqlJ->fetch()) { 
            $Matricula = $MatriculaRowJ;
            $GerenteDelegacion = $GerenteDelegacionRow;
            if($ContactoAsignacion == $Matricula){
                $htmlJ .= '<option value="'.$Matricula.'" selected>'.$Matricula.' - '.utf8_encode($GerenteDelegacion).' </option>';
            } else {
                $htmlJ .= '<option value="'.$Matricula.'">'.$Matricula.' - '.utf8_encode($GerenteDelegacion).' </option>';                
            }
        }
    }else{
        $htmlJ .= '<option>No se encontraron resultado</option>';
    }

    $html=NULL;
    
    $sql = $con->prepare("SELECT  u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) JefeVenta FROM dbUSUARIO.tblusuario u  where u.CC=? AND u.LN='11' AND (u.Categoria ='JE' OR u.Categoria ='COACH' OR u.Categoria ='DEL' or u.Categoria='JE/DEL' or u.Categoria='GERENTE TERRITORIAL') LIMIT 50"); 
    $sql->bind_param('i',$CCOriginal);
    $sql->execute();
    $sql->store_result();
    $sql->bind_result(
        $MatriculaRow,
        $JefeVentaRow
    );
    
    if ($sql->num_rows > 0) {
        while ($sql->fetch()) { 
            $Matricula = $MatriculaRow;
            $JefeVenta = $JefeVentaRow;
           if($Matricula==$matjefe){
                $html .= '<option value="'.$Matricula.'" selected>'.$Matricula.' - '.utf8_encode($JefeVenta).' </option>';
            }else{
                $html .= '<option value="'.$Matricula.'">'.$Matricula.' - '.utf8_encode($JefeVenta).' </option>';
            }
        }
    }else{
        $html .= '<option>No se encontraron resultado</option>';
    }

    $html_tecnico=NULL;
    if($lninstalador=="" || empty($lninstalador)){
        $html_tecnico.= '<option></option>';
    }else{
        $sql_tecnico = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador FROM dbUSUARIO.tblusuario u  
        INNER JOIN dbUSUARIO.tblarea a on a.IdArea=u.IdArea
        WHERE u.LN=? "); 
        $sql_tecnico->bind_param('i',$lninstalador);
        $sql_tecnico->execute();
        $sql_tecnico->store_result();
        $sql_tecnico->bind_result(
            $MatriculaRow,
            $InstaladorRow
            );

        
        if ($sql_tecnico->num_rows > 0) {
            while ($sql_tecnico->fetch()) {         
                $Matricula = $MatriculaRow;
                $Instalador = $InstaladorRow;
                if($Matricula==$matriculatec){
                    $html_tecnico.= '<option value="'.$Matricula.'" selected>'.$Matricula.' - '.utf8_encode($Instalador).' </option>';
                }else{
                    $html_tecnico.= '<option value="'.$Matricula.'">'.$Matricula.' - '.utf8_encode($Instalador).' </option>';
                }
            }
        }else{
             $html_tecnico.= '<option>No se encontraron resultado</option>';
        }
    }
    
    $html_tc=NULL;
    
    if($TCGestor=="" || empty($TCGestor)){
        $html_tc.= '<option></option>';
    }else{
        $sql_tc = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Telecierre FROM dbUSUARIO.tblusuario u WHERE u.IdPerfil='12'"); 
        $sql_tc->execute();
        $sql_tc->store_result();
        $sql_tc->bind_result(
            $MatriculaRow,
            $TelecierreRow
            );
    
        if ($sql_tc->num_rows > 0) {
            while ($sql_tc->fetch()) {   
                $Matricula = $MatriculaRow;
                $Telecierre = $TelecierreRow;
                if($Matricula==$TCGestor){
                    $html_tc.= '<option value="'.$Matricula.'" selected>'.$Matricula.' - '.utf8_encode($Telecierre).' </option>';
                }else{
                    $html_tc.= '<option value="'.$Matricula.'">'.$Matricula.' - '.utf8_encode($Telecierre).' </option>';
                }
            }
        }else{
             $html_tc.= '<option>No se encontraron resultado</option>';
        }
    }

            if(isset($visitarelacionada)) {
                
            $aleatorio = rand(10000000000, 999999999999);
            $LeadID = "VREL" . $aleatorio;
            $matricula="";
            $idu="";
            $comercial="";
            $estadovisita="";
            $estadoventa="";
            $checkin="SI";
            $fechavisita="";
            $horavisita="";     
            $fvencimientovisita="";
            $nprospecto="";
            
            } 
    
    

?>


<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
        <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css"/>
        
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
        <!-- LEAFLET -->
        <link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css"
           integrity="sha512-xodZBNTC5n17Xt2atTPuE1HxjVMSvLVW9ocqUKLsCC5CXdbqCmblAshOMAS6/keqq/sMZMZ19scR4PsZChSR7A=="
           crossorigin=""/>
        <link rel="stylesheet" href="lib/leaflet_AwesomeMarkers/dist/leaflet.awesome-markers.css">
  
        <style>
        
            #map { height: 450px; }

            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;              
            }
            .modal-header-success {
                color:#fff;
                background-color: #008d4c;
            }

            .preloader{
                background-color:#FFF;
                width: 100%;
                height: 100%;
                position: absolute;
                z-index: 1;
            }

            .dataTables_wrapper .myfilter .dataTables_filter{float:left}
            .dataTables_wrapper .mylength .dataTables_length{float:right}
            div.dataTables_scrollBody thead th {
                vertical-align: top;
            } 
            td {
                max-width: 250px;
                overflow: hidden;
                white-space: nowrap;
                text-overflow: ellipsis;

            }
            .espacio{
                height:10px;
            }
            
           .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #frmEditarVenta .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }
            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo { 
                color: #FFFFFF; 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                color: #FFFFFF; 
                background-color: #616161;  
                border-color: #444444; 
            } 

            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                background-image: none; 
            } 

            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
                background-color: #444444; 
                border-color: #444444; 
            } 


        </style>
        
        <style>
            .main-header,.main-sidebar,.left-side{position:fixed}
       
            .main-header {
                top: 0;
                right: 0;
                left: 0
            }
            .content-wrapper,
            .right-side {
                padding-top: 50px
            }

            @media (max-width:767px) {
                 .content-wrapper,
                 .right-side {
                    padding-top: 100px
                }
            }

            .layout-boxed .wrapper {
                max-width: 100%
            }

            .wrapper {
                overflow: hidden
            
                .control-sidebar {
                position: fixed;
                height: 100%;
                overflow-y: auto;
                padding-bottom: 50px
            }       
        
        </style>
     
        <style>
            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                   -moz-border-radius: 5px;
                        border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                   -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        
                    z-index: 1051 !important;    
                        
            }

            hr {
                height: 4px;
                width: 100%;
                background-color: #ecf0f5;
            }

            hr {
                /* margin-top: 20px; */
                margin-bottom: 20px;
                border: 0;
                /* border-top: 1px solid #eee; */
            }

            hr {
                display: block;
                unicode-bidi: isolate;
                -webkit-margin-before: 0.5em;
                -webkit-margin-after: 0.5em;
                -webkit-margin-start: auto;
                -webkit-margin-end: auto;
                overflow: hidden;
                border-style: inset;
               
            }

            .box.box-custom {
                border-top-color: #ffffff;
            }

            .box {
                position: relative;
                border-radius: 3px;
                background: #ffffff;
                border-top: 3px solid #d2d6de;
                margin-bottom: 5px;
                width: 100%;
                box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            }
            .ocultar{
                display:none;
            }

        </style>

    </head>

    <body class="sidebar-collapse skin-red sidebar-mini">
        <input type="hidden" id="idVenta" value="<?php echo $idventa; ?>">
        <input type="hidden" id="fVencimientoVista" value="<?php echo $fvencimientovisita; ?>">
        <input type="hidden" id="estadoVenta" value="<?php echo $estadoventa; ?>">

        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php
                $visita = "active";
                $marketing="active";
                include 'admin/main-sidebar.php';
            ?>
            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        
                        <?php if (isset($visitarelacionada)) { ?>
                            GENERAR VISITA RELACIONADA
                        <?php }else{ ?>
                             EDITAR VISITA
                        <?php } ?>
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li><a href="visita.php">Visitas</a></li>
                        <li class="active">Editar de Visita</li>
                    </ol>
                </section>
                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-md-2"></div>
                        <div class="col-md-8">
                            <!-- /.box-header -->
                            <div class="box box-danger">
                                <div class="box-header">
                                    <h3 class="box-title">EDITAR 
                                        <?php $nombc = "";
                                            if ($categoriaventa == "Online"){
                                                $nombc="VENTA ONLINE";
                                            }else if($categoriaventa == "Ficha"){
                                                $nombc="VENTA FICHA";
                                            }else if($categoriaventa == "VAsignada"){

                                                    if(isset($visitarelacionada)) {
                                                        
                                                        $nombc="VISITA RELACIONADA";
                                                    
                                                    } else{
                                                        $nombc="VISITA ASIGNADA";
                                                    }
   
                                            }else if($categoriaventa == "Anulada"){
                                                $nombc="ANULADA";
                                            }else if($categoriaventa == "Cancelada"){
                                                $nombc="CANCELADA";
                                            }else if($categoriaventa == "NoVendida"){
                                                $nombc="NO VENDIDA";
                                            }else if($categoriaventa == "Delegacion"){
                                                $nombc="VENTA DELEGACIÓN";
                                            }
                                            echo $nombc." - ".$nprospecto." | ".$ncontrato 
                                        ?>
                                    </h3>
                                    <input id="lblcat" name="lblcat" value="<?php echo $categoriaventa;?>" hidden="">
                                    <div class="box-tools pull-right">
                                        <div class="btn-group">
                                          <button type="button" id="infoZonificacion" class="btn btn-sm btn-warning">Errores de Gestión</button>
                                          <button type="button" class="btn btn-sm btn-warning dropdown-toggle" data-toggle="dropdown">
                                            <span class="caret"></span>
                                            <span class="sr-only">Toggle Dropdown</span>
                                          </button>
                                          <ul class="dropdown-menu" role="menu">
                                            <li><a href="#" id="errorGestion"><i class="fa fa-exclamation-circle"></i> Tipificar error</a></li>
                                          </ul>
                                        </div>
                                        <?php if (!isset($visitarelacionada)) { ?>
                                        <button type="button" class="btn btn-default btn-sm" id="btnPreviewSC"><i class="fa fa-file-image-o"></i> Security Check Apertura</button>
                                        <button type="button" class="btn btn-default btn-sm" id="btnPreviewSC-R"><i class="fa fa-file-image-o"></i> Security Check Reasignación</button>
                                        <a class="btn btn-default btn-sm" id="ModEnviar" name="ModEnviar"><i class="fa fa-envelope"></i> Descargar</a>
                                        <a download="message.eml" id="downloadlink" class="btn btn-nuevo" style="display: none">Descargar</a>
                                         <?php }?>
                                        <?php if($estadovisita=='VGenerada'){ ?>
                                        <a class="btn btn-primary btn-sm" href="#" id="lognumero"><i class="fa fa-pencil-square-o"></i> Validacion por Telf.</a>
                                        <?php }                                             
                                            if($estadoventa=='Facturada' || $estadoventa=='PorFacturar' || $nombacceso=='test'){
                                            }else{ 
                                        ?>

                                            <?php if (isset($visitarelacionada)) { ?>
                                                  <a class="btn btn-nuevo btn-sm" id="btnGenerarvisitarelacionada" href="#"><i class="fa fa-save"></i> Guardar Visita Relacionada</a>
                                            <?php }else{ ?>
                                                 <a class="btn btn-nuevo btn-sm" id="btnGuardarEditarVenta" href="#"><i class="fa fa-save"></i> Guardar</a>
                                            <?php } ?>
                                        
                                        
                                        <?php   
                                            }
                                        ?>
                                         <a href="visita.php" class="btn btn-danger btn-sm" ><i class="fa fa-reply"></i> Regresar</a>
                                    </div>
                                </div>
                                <div class="espacio"></div>
                            </div>
                            <form id="frmEditarVenta" method="POST">
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                        <h5>INFORMACION DE VENTA</h5>
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                        <table cellspacing="0"  style="width:100%;border-collapse: separate;padding: 20px;" >
                                            <tr>
                                                <td style="width:15%;font-size: 12px">LEAD ID:</td>
                                                <td style="width:25%;">
                                                    <input name="lblleadid" id="lblleadid" maxlength="18" class="form-control input-sm" value="<?php echo $LeadID;?>" style="width: 100%;"/>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">
                                                    
                                                <?php if (!isset($visitarelacionada)) { ?>
                                                      VISITA RELACIONADA:
                                                <?php }?>
                                                    </td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                <?php if (!isset($visitarelacionada)) { ?>
                                                      <a class="btn btn-default btn-sm" id="btnvisitarelacionada" href="#"><i class="fa fa-pencil-square-o"></i> GENERAR VISITA RELACIONADA</a>
                                                <?php }?>                                                    
                                                    
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">ASIGNACION:</td>
                                                <td style="width:25%;">
                                                    <select class="form-control input-sm" name="lblasignacion" id="lblasignacion" style="width: 100%;">
                                                        <option value="">Seleccione</option>
                                                        <option value="Gerente" <?php if ($MotivoAsignacion == "Gerente") {echo "selected";}?>>Gerente</option>
                                                        <option value="BO" <?php if ($MotivoAsignacion == "BO") {echo "selected";}?>>BO</option>
                                                        <option value="Ranking" <?php if ($MotivoAsignacion == "Ranking") {echo "selected";}?>>Ranking</option>
                                                        <option value="Otros" <?php if ($MotivoAsignacion == "Otros") {echo "selected";}?>>Otros</option>
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">COMENTARIOS ERROR GESTION:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <input type="hidden" id="lblErrorGestion" name="lblErrorGestion" value="">
                                                    <input name="lblcomentarioserrorgestion" id="lblcomentarioserrorgestion" class="form-control input-sm" value="" style="width: 100%;" disabled>
                                                </td>
                                            </tr>         
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">CONTACTO ASIGNACIÓN:</td>
                                                <td style="width:25%;">
                                                    <select class="form-control input-sm" name="lblcontactoasignacion" id="lblcontactoasignacion" style="width: 100%;">
                                                        <option value="">Seleccione</option>
                                                        <?php echo $htmlJ;?>
                                                        <option value="Otros">Otros</option>
                                                        <!--<option value="1" <?php if ($ContactoAsignacion == "1") {echo "selected";}?>>1</option>
                                                        <option value="2" <?php if ($ContactoAsignacion == "2") {echo "selected";}?>>2</option>
                                                        <option value="3" <?php if ($ContactoAsignacion == "3") {echo "selected";}?>>3</option>-->
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">CUMPLE RANKING:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="lblcumpleranking" id="lblcumpleranking" style="width: 100%;">
                                                        <option value="">Seleccione</option>
                                                        <option value="Sí - Top 3" <?php if ($CumpleRanking == "Sí - Top 3") {echo "selected";}?>>Sí - Top 3</option>
                                                        <option value="Estrella" <?php if ($CumpleRanking == "Estrella") {echo "selected";}?>>Estrella</option>
                                                        <option value="Apto" <?php if ($CumpleRanking == "Apto") {echo "selected";}?>>Apto</option>
                                                        <option value="No" <?php if ($CumpleRanking == "No") {echo "selected";}?>>No</option>
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">CHECK-IN:</td>
                                                <td style="width:25%;">
                                                    <input type="checkbox" name="checki" id="checki" <?php if($checkin=="SI"){echo 'checked';}else{echo '';}?> data-size="small"/>
                                                    <input type="hidden" name="hidden_checki" id="hidden_checki" value="<?php echo $checkin;?>">
                                                    <input type="hidden" name="info_checkin" id="info_checkin" value='<?php echo $InfoCheckIn; ?>'>
                                                    <button type="button" class="btn btn-danger btn-sm" id="btnInfoCheckIn" href="#" data-toggle="modal" data-target="#modal-checkin">Info. Check-IN</button>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">MES VISITA:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input name="lblmesvisita" class="form-control input-sm" id="lblmesvisit" value="<?php if(isset($mesvisita)){ echo $mesvisita;}else{echo $fechames;}?>" style="width: 100%;cursor:pointer;background-color: #fff;" readonly="readonly"/> 
                                                    </div> 
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">MATRICULA:</td>

                                                <td style="width:25%;"><input name="lblmatricula" id="lblmatricula" class="form-control input-sm" value="<?php echo $matricula;?>" style="width: 100%;"/>
                                                   
                                                    <input id="lblidusuario" name="lblidusuario" value="<?php echo $idu;?>" hidden="">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">COMERCIAL:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><input name="lblnombcomercial" id="lblnombcomercial" class="form-control input-sm" style="width: 100%;" value="<?php echo $comercial;?>" readonly="readonly"></td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">DC:</td>
                                                <td style="width:25%;">
                                                    <select class="form-control input-sm" name="lbldc" id="lbldc" style="width: 100%;">
                                                        <option>Seleccione</option>
                                                        <option value="40" <?php if ($CCOriginal == "40") {echo "selected";}?>>40</option>
                                                        <option value="41" <?php if ($CCOriginal == "41") {echo "selected";}?>>41</option>
                                                        <option value="42" <?php if ($CCOriginal == "42") {echo "selected";}?>>42</option>
                                                        <option value="80" <?php if ($CCOriginal == "80") {echo "selected";}?>>80</option>
                                                        <option value="100" <?php if ($CCOriginal == "100") {echo "selected";}?>>100</option>
                                                        <option value="120" <?php if ($CCOriginal == "120") {echo "selected";}?>>120</option>
                                                        <option value="121" <?php if ($CCOriginal == "121") {echo "selected";}?>>121</option>
                                                        <option value="140" <?php if ($CCOriginal == "140") {echo "selected";}?>>140</option>
                                                        <option value="141" <?php if ($CCOriginal == "141") {echo "selected";}?>>141</option>
                                                        <option value="150" <?php if ($CCOriginal == "150") {echo "selected";}?>>150</option>
                                                        <option value="151" <?php if ($CCOriginal == "151") {echo "selected";}?>>151</option>
                                                        <option value="152" <?php if ($CCOriginal == "152") {echo "selected";}?>>152</option>
                                                        <option value="153" <?php if ($CCOriginal == "153") {echo "selected";}?>>153</option>
                                                        <option value="154" <?php if ($CCOriginal == "154") {echo "selected";}?>>154</option>
                                                        <option value="155" <?php if ($CCOriginal == "155") {echo "selected";}?>>155</option>
                                                        <option value="156" <?php if ($CCOriginal == "156") {echo "selected";}?>>156</option>
                                                        <option value="157" <?php if ($CCOriginal == "157") {echo "selected";}?>>157</option>
                                                        <option value="158" <?php if ($CCOriginal == "158") {echo "selected";}?>>158</option>
                                                        <option value="159" <?php if ($CCOriginal == "159") {echo "selected";}?>>159</option>
                                                        <option value="200" <?php if ($CCOriginal == "200") {echo "selected";}?>>200</option>
                                                        <option value="250" <?php if ($CCOriginal == "250") {echo "selected";}?>>250</option>
                                                        <option value="251" <?php if ($CCOriginal == "251") {echo "selected";}?>>251</option>
                                                        <option value="252" <?php if ($CCOriginal == "252") {echo "selected";}?>>252</option>
                                                        <option value="20" <?php if ($CCOriginal == "20") {echo "selected";}?>>20</option>
                                                        <option value="511" <?php if ($CCOriginal == "511") {echo "selected";}?>>511</option>
                                                        <option value="513" <?php if ($CCOriginal == "513") {echo "selected";}?>>513</option>
                                                        <option value="512" <?php if ($CCOriginal == "512") {echo "selected";}?> hidden="">512</option>
                                                        <option value="601" <?php if ($CCOriginal == "601") {echo "selected";}?> hidden="">601</option>
                                                        <option value="701" <?php if ($CCOriginal == "701") {echo "selected";}?>>701</option>
                                                        <option value="702" <?php if ($CCOriginal == "702") {echo "selected";}?>>702</option>
                                                        <option value="901" <?php if ($CCOriginal == "901") {echo "selected";}?>>901</option>
                                                        <option value="130" <?php if ($CCOriginal == "130") {echo "selected";}?>>130</option>
                                                        <option value="230" <?php if ($CCOriginal == "230") {echo "selected";}?>>230</option>
                                                        <option value="60" <?php if ($CCOriginal == "60") {echo "selected";}?>>60</option>
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">JEFE VENTA:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="lbljefeventa" id="lbljefeventa" style="width: 100%;">
                                                        <?php echo $html;?>
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">ESTADO VISITA:</td>
                                                <td style="width:25%;">
                                                    <select name="lblestadovisita" id="lblestadovisita" class="form-control input-sm">
                                                        <option value="">Seleccione</option>
                                                        <option value="Asignada"<?php if ($estadovisita == "Asignada") {echo "selected";}?>>Asignada</option>
                                                        <option value="AnuladaCC" <?php if ($estadovisita == "AnuladaCC") {echo "selected";}?>>AnuladaCC</option>
                                                        <option value="PendienteValidarVnoV" <?php if($estadovisita == "PendienteValidarVnoV") {echo "selected";} ?> disabled>PendienteValidarVnoV</option>
                                                        <option value="AnuladaTEC"<?php if ($estadovisita == "AnuladaTEC") {echo "selected";}?>>AnuladaTEC</option>
                                                        <option value="AnuladaOP"<?php if ($estadovisita == "AnuladaOP") {echo "selected";}?>>AnuladaOP</option>
                                                        <option value="AnuladaCLI"<?php if ($estadovisita == "AnuladaCLI") {echo "selected";}?>>AnuladaCLI</option>
                                                        <option value="AnuladaporCruce"<?php if ($estadovisita == "AnuladaporCruce") {echo "selected";}?>>Anulada por Cruce</option>
                                                        <option value="AnuladaNoImputableOper"<?php if ($estadovisita == "AnuladaNoImputableOper") {echo "selected";}?>>Anulada No Imputable Oper</option>
                                                        <option value="AnuladaTECAudio"<?php if ($estadovisita == "AnuladaTECAudio") {echo "selected";}?>>AnuladaTECAudio</option>
                                                        <option value="Vendida"<?php if ($estadovisita == "Vendida") {echo "selected";}?> hidden="">Vendida</option>
                                                        <option value="NoVendida"<?php if ($estadovisita == "NoVendida") {echo "selected";}?>>NoVendida</option>
                                                    </select>
                                                    <input id="lblestvisita" name="lblestvisita" value="<?php echo $estadovisita; ?>" hidden="" />
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">ESTADO VENTA:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <input type="text" name="lblestadoventa" id="lblestadoventa" value="<?php echo $estadoventa ;?>" class="form-control input-sm" style="width: 100%;" readonly="readonly"/>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr class="trAnulaciones <?php if($SeAnula == '') { echo "ocultar"; } ?>">
                                                <td style="width:15%;font-size: 12px">SE ANULA:</td>
                                                <td style="width:25%;">
                                                    <input type="checkbox" name="seanula" id="seanula" <?php if($SeAnula=="SI"){echo 'checked';}else{echo '';}?> data-size="small"/>
                                                    <input type="hidden" name="lblseanula" id="lblseanula" value='<?= $SeAnula; ?>'>
                                                    <input type="hidden" name="lblseanulaH" id="lblseanulaH" value='<?= $SeAnula; ?>'>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">DETALLE:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%;">
                                                    <select name="lbldetalle" id="lbldetalle" class="form-control input-sm">
                                                        <option value="">Seleccione</option>
                                                        <option value="AAHH"<?php if ($DetalleAnulacion == "AAHH") {echo "selected";}?>>AAHH</option>
                                                        <option value="CAMARAS" <?php if ($DetalleAnulacion == "CAMARAS") {echo "selected";}?>>CAMARAS</option>
                                                        <option value="COBERTURA" <?php if($DetalleAnulacion == "COBERTURA") {echo "selected";} ?>>COBERTURA</option>
                                                        <option value="CRUCE-RE"<?php if ($DetalleAnulacion == "CRUCE-RE") {echo "selected";}?>>CRUCE-RE</option>
                                                        <option value="CRUCE-RP"<?php if ($DetalleAnulacion == "CRUCE-RP") {echo "selected";}?>>CRUCE-RP</option>
                                                        <option value="CRUCE-YA ES CLIENTE"<?php if ($DetalleAnulacion == "CRUCE-YA ES CLIENTE") {echo "selected";}?>>CRUCE-YA ES CLIENTE</option>
                                                        <option value="DATO INCORRECTO"<?php if ($DetalleAnulacion == "DATO INCORRECTO") {echo "selected";}?>>DATO INCORRECTO</option>
                                                        <option value="DECISOR"<?php if ($DetalleAnulacion == "DECISOR") {echo "selected";}?>>DECISOR</option>
                                                        <option value="DIRECCION"<?php if ($DetalleAnulacion == "DIRECCION") {echo "selected";}?>>DIRECCION</option>
                                                        <option value="DOCUMENTO"<?php if ($DetalleAnulacion == "DOCUMENTO") {echo "selected";}?>>DOCUMENTO</option>
                                                        <option value="FALTA DE AUDIO"<?php if ($DetalleAnulacion == "FALTA DE AUDIO") {echo "selected";}?>>FALTA DE AUDIO</option>
                                                        <option value="FILTRO DE OBRAS"<?php if ($DetalleAnulacion == "FILTRO DE OBRAS") {echo "selected";}?>>FILTRO DE OBRAS</option>
                                                        <option value="INFORMACION FALSA"<?php if ($DetalleAnulacion == "INFORMACION FALSA") {echo "selected";}?>>INFORMACION FALSA</option>
                                                        <option value="INVIABLE"<?php if ($DetalleAnulacion == "INVIABLE") {echo "selected";}?>>INVIABLE</option>
                                                        <option value="PAGO MENSUAL"<?php if ($DetalleAnulacion == "PAGO MENSUAL") {echo "selected";}?>>PAGO MENSUAL</option>
                                                        <option value="SIN CONFIRMACION"<?php if ($DetalleAnulacion == "SIN CONFIRMACION") {echo "selected";}?>>SIN CONFIRMACION</option>
                                                        <option value="VISITA CANCELADA"<?php if ($DetalleAnulacion == "VISITA CANCELADA") {echo "selected";}?>>VISITA CANCELADA</option>
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr class="trAnulaciones <?php if($ComentariosAnulacion == '') { echo "ocultar"; } ?>">
                                                <td style="width:15%;"></td>
                                                <td style="width:25%;">
                                                    
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">COMENTARIOS ANULACIÓN:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%;">
                                                    <input name="lblcomentarios" id="lblcomentarios" class="form-control input-sm" value="<?= $ComentariosAnulacion ?>" style="width: 100%;">
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">SEGMENTO:</td>
                                                <td style="width:25%;">
                                                    <select class="form-control input-sm" name="lblsegmento" id="lblsegmento">
                                                        <option>Seleccione</option>
                                                        <option value="RES"<?php if ($segmento == "RES") {echo "selected";}?>>RES</option>
                                                        <option value="NEG"<?php if ($segmento == "NEG") {echo "selected";}?>>NEG</option>
                                                    </select></td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">RECURSO:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="lbltipoventa" id="lbltipoventa">
                                                            <option value="RE" <?php if ($tipoventa== "RE") {echo "selected";}?>>RE</option>
                                                            <option value="RPMKT" <?php if ($tipoventa== "RPMKT") {echo "selected";}?>>RPMKT</option>
                                                            <option value="REGGCC" <?php if ($tipoventa== "REGGCC") {echo "selected";}?>>REGGCC</option>
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr class="espacio Lead__tiposegmento  <?php if ($segmento == "NEG") {echo "ocultar";}?>"></tr>
                                            <tr class="Lead__tiposegmento  <?php if ($segmento == "NEG") {echo "ocultar";}?>">
                                                <td style="width:15%;font-size: 12px"><span class="Lead__tiposegmento <?php if ($segmento == "NEG") {echo "ocultar";}?>">TIPO RESIDENCIAL:</span></td>
                                                <td style="width:25%;">
                                                    <select class="form-control input-sm Lead__tiposegmento <?php if ($segmento == "NEG") {echo "ocultar";}?>" name="lbltiposegmento" id="lbltiposegmento">
                                                        <option value="">Seleccione</option>
                                                        <option value="Casa"<?php if ($TipoSegmento == "Casa") {echo "selected";}?>>Casa</option>
                                                        <option value="Departamento"<?php if ($TipoSegmento == "Departamento") {echo "selected";}?>>Departamento</option>
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">N° PISO:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <input type="number" class="form-control input-sm" id="lblnpiso" name="lblnpiso" max="99"  min="0" value="<?php echo $NPiso;?>">
                                                </td>
                                            </tr>
                                            <tr class="espacio Lead__tiposegmento  <?php if ($segmento == "NEG") {echo "ocultar";}?>"></tr>
                                            <tr class="Lead__tiposegmento  <?php if ($segmento == "NEG") {echo "ocultar";}?>">
                                                <td style="width:15%;font-size: 12px"><span class="Lead__tiposegmento <?php if ($segmento == "NEG") {echo "ocultar";}?>">VIVE PISO A PROTEGER:</span></td>
                                                <td style="width:25%;">
                                                        <select class="form-control input-sm" name="visePiso" id="visePiso" style="width: 100%">
                                                            <option value="">Seleccione</option>
                                                            <option value="Si" <?php if ($visePiso== "Si") {echo "selected";}?>>Si</option>
                                                            <option value="No - para familiar" <?php if ($visePiso== "No - para familiar") {echo "selected";}?>>No, para familiar</option>
                                                            <option value="No - para alquiler" <?php if ($visePiso== "No - para alquiler") {echo "selected";}?>>No, para alquiler</option>
                                                            <option value="No - para turismo" <?php if ($visePiso== "No - para turismo") {echo "selected";}?>>No, para turismo</option>
                                                        </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px"></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    
                                                </td>
                                            </tr>
                                            <tr class="espacio Lead__nlocales  <?php if ($segmento == "RES") {echo "ocultar";}?>"></tr>
                                            <tr class="Lead__nlocales  <?php if ($segmento == "RES") {echo "ocultar";}?>">
                                                <td style="width:15%;font-size: 12px"><span class="Lead__nlocales <?php if ($segmento == "RES") {echo "ocultar";}?>">RUBRO DE NEGOCIO:</span></td>
                                                <td style="width:25%;">
                                                       <input type="text" class="form-control input-sm" id="rubroNeg" name="rubroNeg" value="<?php echo $rubroNeg;?>">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">PUERTA A CALLE:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                     <select class="form-control input-sm" name="puertaCalle" id="puertaCalle" style="width: 100%">
                                                            <option value="">Seleccione</option>
                                                            <option value="Si" <?php if ($puertaCalle== "Si") {echo "selected";}?>>Si</option>
                                                            <option value="No" <?php if ($puertaCalle== "No") {echo "selected";}?>>No</option>
                                                     </select>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">PAREDES - LADRILLO Y CEMENTO:</td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="nobleParedes" id="nobleParedes" style="width: 100%" >
                                                        <option value="">Seleccione</option>
                                                        <option value="Si" <?php if ($nobleParedes== "Si") {echo "selected";}?>>Si</option>
                                                        <option value="No" <?php if ($nobleParedes== "No") {echo "selected";}?>>No</option>
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">TECHO - LADRILLO Y CEMENTO:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="nobleTecho" id="nobleTecho" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Si" <?php if ($nobleTecho== "Si") {echo "selected";}?>>Si</option>
                                                        <option value="No" <?php if ($nobleTecho== "No") {echo "selected";}?>>No</option>
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">M2:</td>
                                                <td style="width:25%">
                                                    <input type="text" class="form-control input-sm" id="mcuadrados"  name="mcuadrados" value="<?php echo $metros;?>" maxlength="50" onkeypress="return (event.charCode >= 46 && event.charCode <= 57)">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">MOTIVO INTERÉS:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="motivoInteres" id="motivoInteres" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Robo" <?php if ($motivoInteres== "Robo") {echo "selected";}?>>Robo</option>
                                                        <option value="Prevencion" <?php if ($motivoInteres== "Prevencion") {echo "selected";}?>>Prevención</option>
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">CON SISTEMA DE ALARMAS:</td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="conSistema" id="conSistema" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Si" <?php if ($conSistema== "Si") {echo "selected";}?>>Si</option>
                                                        <option value="No" <?php if ($conSistema== "No") {echo "selected";}?>>No</option>
                                                    </select>                                                    
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px"><span class="Lead__empresaAlarmas <?php if ($conSistema == "No" || $conSistema == "") {echo "ocultar";}?>">EMPRESA ALARMAS:</span></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <input type="text" class="form-control input-sm Lead__empresaAlarmas <?php if ($conSistema == "No" || $conSistema == "") {echo "ocultar";}?>" id="empresaSistema"  name="empresaSistema" value="<?php echo $empresaSistema;?>" maxlength="50">
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">CLIENTE BANCARIZADO:</td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="bancarizado" id="bancarizado" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Si" <?php if ($bancarizado== "Si") {echo "selected";}?>>Si</option>
                                                        <option value="No" <?php if ($bancarizado== "No") {echo "selected";}?>>No</option>
                                                    </select>                                                 
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px"></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    
                                                </td>
                                            </tr>                                              
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">N° PROSPECTO:</td>
                                                <td style="width:25%">
                                                    <input type="text" class="form-control input-sm" name="lblnprospecto" id="lblnprospecto" data-inputmask='"mask": "999999"' value="<?php echo $nprospecto;?>" data-mask>
                                                    <input type="text" name="lblnprospectohidden" id="lblnprospectohidden" value="<?php echo $nprospecto;?>" hidden>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">N° CONTRATO:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <input type="text" class="form-control input-sm" name="lblncontrato" id="lblncontrato" data-inputmask='"mask": "9999999"' value="<?php echo $ncontrato;?>" data-mask readonly="readonly">
                                                </td>
                                            </tr> 
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">ASIGNADO POR:</td>
                                                <td style="width:25%;">
                                                    <select class="form-control selectgestor input-sm" name="lblasignado" id="lblasignado" style="width: 100%;">
                                                        <option value="<?php echo $matriculagestormkt; ?>"><?php echo $matriculagestormkt.' - '.$operadormkt; ?></option>
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">ORIGEN:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><input class="form-control input-sm" name="lblorigen" id="lblorigen" value="<?php echo $origenvisita;?>" ></td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px" id="txtFvisita"><?php if ($FObras=='SI'){echo 'FECHA VISITA(OBRAS):';}else{echo 'FECHA VISITA:';} ?></td>
                                                <td style="width:25%"> <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfvisita"  name="lblfvisita" value="<?php echo $fechavisita;?>"  data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                        </div>
                                                
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">HORA VISITA:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <div class="bootstrap-timepicker timepicker">
                                                        <div class="input-group">
                                                            <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhvisita" id="lblhvisita" value="<?php echo $horavisita;?>"  >
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-clock-o"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">FECHA VENCIMIENTO:</td>
                                                <td style="width:25%;">
                                                    <div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control pull-right input-sm" id="lblfvencimientob" value="<?php echo $fvencimientovisita;?>" name="lblfvencimientob" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                        <input type="hidden" class="form-control pull-right input-sm" id="lblfvencimiento" value="<?php echo $fvencimientovisita;?>"  name="lblfvencimiento">
                                                    </div>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">MESES AUTORIZADOS:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><input type="text" maxlength="3" class="form-control input-sm" id="lblmesesautorizados" name="lblmesesautorizados"  value="<?php echo $mesesautorizados;?>" onkeypress="return filterFloat(event, this);" readonly="readonly"></td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">OBRAS:</td>
                                                <td style="width:25%;">
                                                    <input type="checkbox" name="FObras" id="FObras" <?php if ($FObras=='SI'){echo 'checked';}else{echo '';}?> data-size="small">
                                                    <input type="hidden" name="ValFObras" id="ValFObras" value="<?php if ($FObras=='SI'){echo 'SI';}else{echo 'NO';} ?>">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px; <?php if ($FObras=='NO' || $FObras=='' ){echo 'display: none;';} ?>"  id="txtFVisitaReal">FECHA VISITA REAL:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%; <?php if ($FObras=='NO' || $FObras==''){echo 'display: none;';} ?>" id="dpFVisitaReal"> 
                                                    <div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control pull-right input-sm" id="lblFVisitaReal"  name="lblFVisitaReal" value="<?php if($FVisitaObras!='0'){ echo $FVisitaObras; } else { echo '';} ?>" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">CLIENTE:</td>

                                                <td style="width:25%;"><input name="lblnombcliente" class="form-control input-sm" id="lblnombcliente" value="<?php echo $cliente;?>" style="width: 100%;"/></td>
                                                <input id="lblidcliente" name="lblidcliente" value="<?php echo $idcliente;?>" hidden="">
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">CORREO:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><input type="text"  class="form-control input-sm" id="lblcorreo" value="<?php echo $correo;?>" name="lblcorreo"></td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">TIPO DOCUMENTO VISITA:</td>
                                                <td style="width:25%;"> 
                                                    <select class="form-control input-sm" name="lbltipodoc" id="lbltipodoc">
                                                        <option value="">Seleccione</option>
                                                        <option value="DNI" <?php if ($TipoDocumento== "DNI") {echo "selected";}?>>DNI</option>
                                                        <option value="RUC" <?php if ($TipoDocumento== "RUC") {echo "selected";}?>>RUC</option>
                                                        <option value="CE" <?php if ($TipoDocumento== "CE") {echo "selected";}?>>CE</option>
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">DOCUMENTO VISITA:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"> <input id="lblIdDocVisita" name="lblIdDocVisita" value="<?php echo $IdDocVisita;?>" hidden="">
                                                    <input type="text" class="form-control input-sm" name="lbldocumento" id="lbldocumento" value="<?php echo $Documento ;?>" maxlength="12" onkeypress="return filterFloat(event, this);">
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                    <td style="width:15%;font-size: 12px">ACCION:</td>
                                                    <td style="width:25%;">
                                                    <input type="text" class="form-control input-sm" name="lblaccion" id="lblaccion" maxlength="70" value="<?php echo $lblAccion;?>"  readonly>
                                                    </td>
                                                    <td style="width:10%"></td>
                                                    <td style="width:15%;font-size: 12px">FECHA CONSULTA:</td>
                                                    <td style="width:2%"></td>
                                                    <td style="width:25%">
                                                      <input type="text" class="form-control input-sm" name="lblFechaHoraReg" id="lblFechaHoraReg" value="<?php echo $lblFechaHoraReg;?>"  readonly>
                                                      <input type="hidden" name="lblIdConsultaScoring" id="lblIdConsultaScoring" value="<?php echo $lblIdConsultaScoring;?>" >
                                                      <input type="hidden" name="lblperfilscoring" id="lblperfilscoring" value="<?php echo $lblPerfilScoring;?>" >
                                                    </td>
                                            </tr>                                               
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">DIRECCIÓN:</td>
                                                <td colspan="3" style="width:50%">
                                                    <div class="input-group" style="width: 100%">
                                                        <input type="text" class="form-control input-sm" id="lbldireccion" name="lbldireccion" placeholder="Ingresar dirección ..." value="<?php echo $direccion;?>">
                                                        <!--
                                                        <div class="input-group-addon btn" id="setDireccion">
                                                            <i class="fa fa-cart-plus"></i>
                                                        </div>
                                                        -->
                                                        
                                                    </div>
                                                </td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><select class="form-control selectdistrito input-sm" name="lbldistrito" id="lbldistrito" style="width: 100%;">
                                                    <option value="<?php echo $idgeografico; ?>"><?php echo $distrito.' - '.$provincia; ?></option>
                                                </select></td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">TIPO DIRECCION:</td>
                                                <td style="width:25%">
                                                     <select class="form-control input-sm selecttipodireccion" name="tipovial" id="tipovial" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Alameda" <?php if ($TipoVial== "Alameda") {echo "selected";}?>>Alameda</option>
                                                        <option value="Asenamiento Humano" <?php if ($TipoVial== "Asenamiento Humano") {echo "selected";}?>>Asenamiento Humano</option>
                                                        <option value="Avenida" <?php if ($TipoVial== "Avenida") {echo "selected";}?>>Avenida</option>
                                                        <option value="Calle" <?php if ($TipoVial== "Calle") {echo "selected";}?>>Calle</option>
                                                        <option value="Centro Poblado" <?php if ($TipoVial== "Centro Poblado") {echo "selected";}?>>Centro Poblado</option>
                                                        <option value="Jiron" <?php if ($TipoVial== "Jiron") {echo "selected";}?>>Jiron</option>
                                                        <option value="Malecon" <?php if ($TipoVial== "Malecon") {echo "selected";}?>>Malecon</option>
                                                        <option value="Ovalo" <?php if ($TipoVial== "ovalo") {echo "selected";}?>>ovalo</option>
                                                        <option value="Pasaje" <?php if ($TipoVial== "ovalo") {echo "selected";}?>>Pasaje</option>
                                                        <option value="Pueblo Joven" <?php if ($TipoVial== "Pueblo Joven") {echo "selected";}?>>Pueblo Joven</option>
                                                        <option value="Urbanizacion" <?php if ($TipoVial== "Urbanizacion") {echo "selected";}?>>Urbanizacion</option>
                                                        <option value="Ampliacion" <?php if ($TipoVial== "Ampliacion") {echo "selected";}?>>Ampliacion</option>
                                                        <option value="Upis" <?php if ($TipoVial== "Upis") {echo "selected";}?>>Upis</option>
                                                        <option value="Prolongacion" <?php if ($TipoVial== "Prolongacion") {echo "selected";}?>>Prolongacion</option>
                                                        <option value="Caserio" <?php if ($TipoVial== "Caserio") {echo "selected";}?>>Caserio</option>
                                                        <option value="Fundo" <?php if ($TipoVial== "Fundo") {echo "selected";}?>>Fundo</option>
                                                        <option value="Asociacion" <?php if ($TipoVial== "Asociacion") {echo "selected";}?>>Asociación</option>
                                                        <option value="Cooperativa" <?php if ($TipoVial== "Cooperativa") {echo "selected";}?>>Cooperativa</option>
                                                        <option value="Conjunto habitacional" <?php if ($TipoVial== "Conjunto habitacional") {echo "selected";}?>>Conjunto habitacional</option>
                                                        <option value="APV" <?php if ($TipoVial== "APV") {echo "selected";}?>>APV</option>
                                                        <option value="Variante" <?php if ($TipoVial== "Variante") {echo "selected";}?>>Variante</option>
                                                        <option value="Zona" <?php if ($TipoVial== "Zona") {echo "selected";}?>>Zona</option>
                                                        <option value="Sector" <?php if ($TipoVial== "Sector") {echo "selected";}?>>Sector</option>
                                                        <option value="Grupo" <?php if ($TipoVial== "Grupo") {echo "selected";}?>>Grupo</option>
                                                        <option value="Kilometro" <?php if ($TipoVial== "Kilometro") {echo "selected";}?>>Kilometro</option>
                                                        <option value="Parcela" <?php if ($TipoVial== "Parcela") {echo "selected";}?>>Parcela</option>
                                                        <option value="Agrupacion" <?php if ($TipoVial== "Agrupacion") {echo "selected";}?>>Agrupacion</option>                                                         
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px"></td>
                                                <td style="width:2%"></td>
                                                <td colspan="6" style="width:50%">
                                                   
                                                </td>
                                            </tr>                                            
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">INTERIOR:</td>
                                                <td style="width:25%">
                                                    <input type="text" class="form-control input-sm" name="lblinterior" id="lblinterior" value="<?php echo $Interior; ?>">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">REFERENCIA:</td>
                                                <td style="width:2%"></td>
                                                <td colspan="6" style="width:50%">
                                                    <div class="input-group" style="display: flex">
                                                        <input type="text" class="form-control input-sm" id="lblreferencia" name="lblreferencia" value="<?php echo $Referencia; ?>">
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">DIR. GEO:</td>
                                                <td colspan="3" style="width:50%">
                                                    <div class="input-group" style="width: 100%">
                                                        <input type="text" class="form-control input-sm" id="lbldireccionAprox" name="lbldireccionAprox" placeholder="" value="<?php echo $DireccionAprox;?>" readonly>
                                                        <div class="input-group-addon btn" id="setDireccion">
                                                            <i class="fa fa-map-marker"></i>
                                                        </div>
                                                        <input type="hidden" id="objGeofinder" name="objGeofinder" value='<?php echo $objGeofinder; ?>'>
                                                        <!--
                                                        <div class="input-group-addon btn" id="setDireccionAprox">
                                                            <i class="fa fa-map-marker"></i>
                                                        </div>
                                                        -->
                                                    </div>
                                                </td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="lbltipoDireccion" id="lbltipoDireccion" style="width: 100%;">
                                                        <option value="" disabled selected>Seleccione</option>
                                                        <option value="Exacta" <?php if ($TipoDireccion== "Exacta") {echo "selected";}?>>Exacta</option>
                                                        <option value="Aproximada" <?php if ($TipoDireccion== "Aproximada") {echo "selected";}?>>Aproximada</option>
                                                    </select>
                                                    <input type="hidden" id="hidTipoDireccion" value="<?php echo $TipoDireccion; ?>">
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">TELEFONO UNO:</td>
                                                <td style="width:25%">
                                                     <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-whatsapp irwhatsapp_telefonouno"></i>
                                                            </div>
                                                            <input type="text" class="form-control input-sm" name="lblmovil" id="lblmovil" value="<?php echo $movil;?>"  onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9">
                                                    </div>
                                                    
                                                    
                                                    
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">TELEFONO DOS:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><input type="text" class="form-control input-sm" name="lblfijo" id="lblfijo" value="<?php echo $fijo;?>" onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9">
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">COMENTARIO VISITA:</td>
                                                <td colspan="5" style="width:77%">
                                                    <textarea class="form-control input-sm" name="lblcomentariovisita" id="lblcomentariovisita" rows="3" style="resize:none"  placeholder="Ingresar..."><?php echo $comentariovisita;?></textarea>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">SEGUNDA DIRECCION</td>
                                                <td style="width:25%">
                                                    
                                                    <select class="form-control input-sm" name="segundaDireccion" id="segundaDireccion" style="width: 100%" >
                                                        <option value="">Seleccione</option>
                                                        <option value="Si" <?php if ($segundaDireccion== "Si") {echo "selected";}?>>Si</option>
                                                        <option value="No" <?php if ($segundaDireccion== "No") {echo "selected";}?>>No</option>
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px"></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
         
                                                </td>
                                            </tr>                                            
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">PRECIOKIT:</td>
    
                                                <td style="width:25%"><div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="">S/.</i>
                                                        </div>
                                                       <input type="text" class="form-control input-sm" name="lblpreciokit" id="lblpreciokit" value="<?php echo $preciokit;?>" onkeypress="return filterFloat(event, this);"  readonly="readonly"/>
                                                    </div>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">TOTAL EXTRA:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="">S/.</i>
                                                        </div>
                                                       <input type="text" class="form-control input-sm" name="lbltotalextra" id="lbltotalextra" value="<?php echo $totalextra;?>" onkeypress="return filterFloat(event, this);"  readonly="readonly" />
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                             <tr>
                                                <td style="width:15%;font-size: 12px">RESUMEN INST.:</td>
    
                                                <td colspan="5" style="width:77%"><textarea class="form-control input-sm" name="lblresumenventa" id="lblresumenventa" rows="1" style="resize:none"  placeholder="Ingresar..."  readonly="readonly"><?php echo $resumenventa;?></textarea></td>
    
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">REGALO AUTORIZADO:</td>
                                                <td style="width:25%;font-size: 12px">
                                                    <select class="form-control input-sm" name="lblextraautorizado" id="lblextraautorizado" disabled="disabled" >
                                                        <option>Seleccione</option>
                                                        <option value="Ninguno"<?php if ($regaloutorizado == "Ninguno") {echo "selected";}?>>Ninguno</option>
                                                        <option value="Mando a distancia"<?php if ($regaloutorizado == "Mando a distancia") {echo "selected";}?>>Mando a distancia</option>
                                                        <option value="Magnetico"<?php if ($regaloutorizado == "Magnetico") {echo "selected";}?>>Magnetico</option>
                                                        <option value="Pulsador"<?php if ($regaloutorizado == "Pulsador") {echo "selected";}?>>Pulsador</option>
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">FORMA DE PAGO:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="lblformadepago" id="lblformadepago" disabled="disabled">
                                                        <option value="">Seleccione</option>                                                                                
                                                        <option value="Cheque" <?php if ($formadepago == "Cheque") {echo "selected";}?>>Cheque</option>
                                                         <option value="Deposito" <?php if ($formadepago == "Deposito") {echo "selected";}?>>Depósito</option>
                                                        <option value="Transferencia" <?php if ($formadepago == "Transferencia") {echo "selected";}?>>Transferencia</option>
                                                        <option value="TransferenciaInterbancaria" <?php if ($formadepago == "TransferenciaInterbancaria") {echo "selected";}?>>Transferencia Interbancaria</option>
                                                        <option value="PagoPOSVisa" <?php if ($formadepago == "PagoPOSVisa") {echo "selected";}?>>Pago POSVisa</option>
                                                        <option value="PagoPOSMC" <?php if ($formadepago == "PagoPOSMC") {echo "selected";}?>>Pago POSMC</option>
                                                        <option value="TarjetadeCredito" <?php if ($formadepago == "TarjetadeCredito") {echo "selected";}?>>Tarjeta de Crédito</option>
                                                        <option value="PagoPasarella" <?php if ($formadepago == "PagoPasarella") {echo "selected";}?>>Pago Pasarella</option>
                                                    </select>
                                                </td>
                                            </tr> 
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">590:</td>

                                                <td style="width:25%"><div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control pull-right input-sm" id="mesano" value="<?php echo $n590;?>" name="lbl590" disabled="disabled">
                                                    </div>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">PAI:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><select class="form-control input-sm" name="lblPAI" id="lblPAI" disabled="disabled">
                                                        <option>Seleccione</option>
                                                        <option value="BBVA-DIN"<?php if ($PAI == "BBVA-DIN") {echo "selected";}?>>BBVA-DIN</option>
                                                        <option value="PAI 30x36"<?php if ($PAI == "PAI 30x36") {echo "selected";}?>>PAI 30x36</option>
                                                        <option value="PAI 30x48"<?php if ($PAI == "PAI 30x48") {echo "selected";}?>>PAI 30x48</option>
                                                        <option value="NO"<?php if ($PAI == "NO") {echo "selected";}?>>NO</option>
                                                       
                                                    </select>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                    <!-- /.box-body -->
                                </div>
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACIÓN DE TELECIERRE</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                     <table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
                        <tr>
                                                                                                <td style="width:15%;font-size: 12px">ESTADO TELECIERRE:</td>
                                                              <td style="width:25%"><select class="form-control input-sm" name="lblestadotelecierre" id="lblestadotelecierre" disabled="disabled">
                                                                                                        <option value="">Seleccione</option>
                           <option value="NoContactado" <?php if ($estadotelecierre== "NoContactado") {echo "selected";}?>>No Contactado</option>
                        <option value="NoVisitado" <?php if ($estadotelecierre== "NoVisitado") {echo "selected";}?>>No Visitado</option>
                        <option value="Contactado" <?php if ($estadotelecierre== "Contactado") {echo "selected";}?>>Contactado</option>
                        <option value="PendienteRespuesta" <?php if ($estadotelecierre== "PendienteRespuesta") {echo "selected";}?>>Pendiente Respuesta</option>
                        <option value="Online" <?php if ($estadotelecierre== "Online") {echo "selected";}?>>Vendida Online</option>
                        <option value="Ficha" <?php if ($estadotelecierre== "Ficha") {echo "selected";}?>>Vendida Ficha</option>
                        <option value="NoVendida" <?php if ($estadotelecierre== "NoVendida") {echo "selected";}?>>No Vendida</option>
                        
                                                                            </select>
                              
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px"></td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%">
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                              
                        <tr>
                                                                                                <td style="width:15%;font-size: 12px">TIPO VENTA TC:</td>
                                                              <td style="width:25%"><select class="form-control input-sm" name="lbltipoventatc" id="lbltipoventatc" disabled="disabled">
                                                                                                        <option value="">Seleccione</option>
                                        <option value="Telecierre" <?php if ($TCTipoVenta== "Telecierre") {echo "selected";}?>>Telecierre</option>
                                        <option value="Televenta" <?php if ($TCTipoVenta== "Televenta") {echo "selected";}?>>Televenta</option>
                        
                        
                                                                            </select>
                              
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">MOTIVO NO VENTA:</td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"><select class="form-control input-sm" name="lblmovivonoventatc" id="lblmovivonoventatc" disabled="disabled">
                                                                                             <option value="">Seleccione</option>
                                                                                             <option value="NoInteresado" <?php if ($TCMotivoNoVenta=== "NoInteresado") {echo "selected";}?>>No Interesado</option>
                                                                                             <option value="Economico" <?php if ($TCMotivoNoVenta=== "Economico") {echo "selected";}?>>Económico</option>
                                                                                             <option value="Competencia" <?php if ($TCMotivoNoVenta=== "Competencia") {echo "selected";}?>>Competencia</option>
                        <option value="NoVisitado" <?php if ($TCMotivoNoVenta=== "NoVisitado") {echo "selected";}?>>No Visitado</option>
                                                                                             <option value="TiempoContrato" <?php if ($TCMotivoNoVenta=== "TiempoContrato") {echo "selected";}?>>Tiempo Contrato</option>
                                                                                             <option value="Monitoreo" <?php if ($TCMotivoNoVenta=== "Monitoreo") {echo "selected";}?>>Monitoreo</option>
                                                                                             <option value="Especialista" <?php if ($TCMotivoNoVenta=== "Especialista") {echo "selected";}?>>Especialista</option>
                                                                                             <option value="Cliente" <?php if ($TCMotivoNoVenta=== "Cliente") {echo "selected";}?>>Cliente</option>
                                                                            </select>
                         
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                             <tr>
                                                                                                <td style="width:15%;font-size: 12px">CC TC:</td>
                                                              <td style="width:25%"> 
                            <select class="form-control input-sm" name="lblcctc" id="lblcctc">
                                <?php if ($dc == "511") { ?>
                                    <option value="511" <?php if ($dc == "511") {echo "selected";}?> >511</option>
                                    <option value="<?php 
                                            if ($CCOriginal == "150") {echo "150";}
                                            else if($CCOriginal == "151"){echo "151";}
                                            else if($CCOriginal == "152"){echo "152";}
                                            else if($CCOriginal == "153"){echo "153";}
                                            else if($CCOriginal == "154"){echo "154";}
                                            else if($CCOriginal == "155"){echo "155";}
                                            else if($CCOriginal == "156"){echo "156";}
                                            else if($CCOriginal == "157"){echo "157";}
                                            else if($CCOriginal == "158"){echo "158";}
                                            else if($CCOriginal == "159"){echo "159";}
                                            else if($CCOriginal == "200"){echo "200";}
                                            else if($CCOriginal == "250"){echo "250";}
                                            else if($CCOriginal == "251"){echo "251";}
                                            else if($CCOriginal == "252"){echo "252";}
                                            else if($CCOriginal == "20"){echo "20";}
                                            else if($CCOriginal == "140"){echo "140";}
                                            else if($CCOriginal == "141"){echo "141";}
                                            else if($CCOriginal == "120"){echo "120";}
                                            else if($CCOriginal == "121"){echo "121";}
                                            else if($CCOriginal == "100"){echo "100";}
                                            else if($CCOriginal == "80"){echo "80";}
                                            else if($CCOriginal == "40"){echo "40";}
                                            else if($CCOriginal == "41"){echo "41";}
                                            else if($CCOriginal == "42"){echo "42";}
                                            else if($CCOriginal == "601"){echo "601";}
                                            else if($CCOriginal == "701"){echo "701";}
                                            else if($CCOriginal == "702"){echo "702";}
                                            else if($CCOriginal == "901"){echo "901";}
                                            else if($CCOriginal == "130"){echo "130";}
                                            else if($CCOriginal == "230"){echo "230";}
                                            else if($CCOriginal == "60"){echo "60";}
                                            
                                            
                                            ?>">
                                            
                                            <?php 
                                                if ($CCOriginal == "150") {echo "150";}
                                                else if($CCOriginal == "151"){echo "151";}
                                                else if($CCOriginal == "152"){echo "152";}
                                                else if($CCOriginal == "153"){echo "153";}
                                                else if($CCOriginal == "154"){echo "154";}
                                                else if($CCOriginal == "155"){echo "155";}
                                                else if($CCOriginal == "156"){echo "156";}
                                                else if($CCOriginal == "157"){echo "157";}
                                                else if($CCOriginal == "158"){echo "158";}
                                                else if($CCOriginal == "159"){echo "159";}
                                                else if($CCOriginal == "200"){echo "200";}
                                                else if($CCOriginal == "250"){echo "250";}
                                                else if($CCOriginal == "251"){echo "251";}
                                                else if($CCOriginal == "252"){echo "252";}
                                                else if($CCOriginal == "20"){echo "20";}
                                                else if($CCOriginal == "140"){echo "140";}
                                                else if($CCOriginal == "141"){echo "141";}
                                                else if($CCOriginal == "120"){echo "120";}
                                                else if($CCOriginal == "121"){echo "121";}
                                                else if($CCOriginal == "100"){echo "100";}
                                                else if($CCOriginal == "80"){echo "80";}
                                                else if($CCOriginal == "40"){echo "40";}
                                                else if($CCOriginal == "41"){echo "41";}
                                                else if($CCOriginal == "42"){echo "42";}
                                                else if($CCOriginal == "601"){echo "601";}
                                                else if($CCOriginal == "701"){echo "701";}
                                                else if($CCOriginal == "702"){echo "702";}
                                                else if($CCOriginal == "901"){echo "901";}
                                                else if($CCOriginal == "130"){echo "130";}
                                                else if($CCOriginal == "230"){echo "230";}
                                                else if($CCOriginal == "60"){echo "60";}
                                            
                                            ?>
                                    </option>
                                <?php } else if($dc == "500"){?>
                                    <option value="500" <?php if ($dc == "500") {echo "selected";}?> hidden="">500</option>
                                <?php }else if($dc == "512"){?>
                                    <option value="512" <?php if ($dc == "512") {echo "selected";}?> hidden="">512</option>
                                <?php }else{?>
                                    <option value="150" <?php if ($dc == "150") {echo "selected";}?>>150</option>
                                    <option value="151" <?php if ($dc == "151") {echo "selected";}?>>151</option>
                                    <option value="152" <?php if ($dc == "152") {echo "selected";}?>>152</option>
                                    <option value="153" <?php if ($dc == "153") {echo "selected";}?>>153</option>
                                    <option value="154" <?php if ($dc == "154") {echo "selected";}?>>154</option>
                                    <option value="155" <?php if ($dc == "155") {echo "selected";}?>>155</option>
                                    <option value="156" <?php if ($dc == "156") {echo "selected";}?>>156</option>
                                    <option value="157" <?php if ($dc == "157") {echo "selected";}?>>157</option>
                                    <option value="158" <?php if ($dc == "158") {echo "selected";}?>>158</option>
                                    <option value="159" <?php if ($dc == "159") {echo "selected";}?>>159</option>
                                    <option value="200" <?php if ($dc == "200") {echo "selected";}?>>200</option>
                                    <option value="250" <?php if ($dc == "250") {echo "selected";}?>>250</option>
                                    <option value="251" <?php if ($dc == "251") {echo "selected";}?>>251</option>
                                    <option value="252" <?php if ($dc == "252") {echo "selected";}?>>252</option>
                                    <option value="20" <?php if ($dc == "20") {echo "selected";}?>>20</option>
                                    <option value="140" <?php if ($dc == "140") {echo "selected";}?>>140</option>
                                    <option value="141" <?php if ($dc == "141") {echo "selected";}?>>141</option>
                                    <option value="120" <?php if ($dc == "120") {echo "selected";}?>>120</option>
                                    <option value="121" <?php if ($dc == "121") {echo "selected";}?>>121</option>
                                    <option value="100" <?php if ($dc == "100") {echo "selected";}?>>100</option>
                                    <option value="80" <?php if ($dc == "80") {echo "selected";}?>>80</option>
                                    <option value="40" <?php if ($dc == "40") {echo "selected";}?>>40</option>
                                    <option value="41" <?php if ($dc == "41") {echo "selected";}?>>41</option>
                                    <option value="42" <?php if ($dc == "42") {echo "selected";}?>>42</option>
                                    <option value="511" <?php if ($dc == "511") {echo "selected";}?> >511</option>
                                    <option value="513" <?php if ($dc == "513") {echo "selected";}?>>513</option>
                                    <option value="601" <?php if ($dc == "601") {echo "selected";}?> hidden="">601</option>
                                    <option value="701" <?php if ($dc == "701") {echo "selected";}?>>701</option>
                                    <option value="702" <?php if ($dc == "702") {echo "selected";}?>>702</option>
                                    <option value="901" <?php if ($dc == "901") {echo "selected";}?>>901</option>
                                    <option value="130" <?php if ($dc == "130") {echo "selected";}?>>130</option>
                                    <option value="230" <?php if ($dc == "230") {echo "selected";}?>>230</option>
                                    <option value="60" <?php if ($dc == "60") {echo "selected";}?>>60</option>
                                <?php } ?>
                                                                                                        
                        
                        
                                                                            </select>
                               
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">GESTOR TC:</td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"> 
                        
                        <select name="lblgestortc" id="lblgestortc" class="form-control cbxtelecierre input-sm" style="width: 100%;" disabled="disabled">
                                                                                                      <?php echo $html_tc;?>
                                                       </select>
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                       
                                                                                            
                                                                                             <tr>
                                                                                                <td style="width:15%;font-size: 12px">PRECIOKIT TC:</td>
                        
                                                                                                <td style="width:25%"><div class="input-group" disabled="disabled">
                                                                                                        <div class="input-group-addon input-sm">
                                                                                                            <i class="">S/.</i>
                                                                                                        </div>
                                                                                                       <input type="text" class="form-control input-sm" name="lblpreciokittc" id="lblpreciokittc" value="<?php echo $preciokit;?>" onkeypress="return filterFloat(event, this);" disabled="disabled" />
                                                                                                    </div>
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">TOTAL EXTRA TC:</td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"><div class="input-group" disabled="disabled">
                                                                                                        <div class="input-group-addon input-sm">
                                                                                                            <i class="">S/.</i>
                                                                                                        </div>
                                                                                                       <input type="text" class="form-control input-sm" name="lbltotalextratc" id="lbltotalextratc" value="<?php echo $totalextra;?>" onkeypress="return filterFloat(event, this);" disabled="disabled"/>
                                                                                                    </div>
                                                                                                    
                                                                                                    
                                                                                                    
                                                                                                </td>
                                                                                            </tr>
                        <tr class="espacio"></tr>
                                                                                             <tr>
                                                                                                <td style="width:15%;font-size: 12px">RESUMEN INST. TC:</td>
                        
                                                                                                <td colspan="5" style="width:77%"><textarea class="form-control input-sm" name="lblresumenventatc" id="lblresumenventatc" rows="1" style="resize:none"  placeholder="Ingresar..." disabled="disabled"><?php echo $resumenventa;?></textarea></td>
                        
                                                                                            </tr>
                         <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">REGALO AUTORIZADO TC:</td>
                        
                                                                                                <td style="width:25%;font-size: 12px"><select class="form-control input-sm" name="lblextraautorizadotc" id="lblextraautorizadotc" disabled="disabled">
                                                                                                        <option>Seleccione</option>
                        <option value="Ninguno"<?php if ($regaloutorizado == "Ninguno") {echo "selected";}?>>Ninguno</option>
                                                                                                         <option value="Mando a distancia"<?php if ($regaloutorizado == "Mando a distancia") {echo "selected";}?>>Mando a distancia</option>
                                                                                                          <option value="Magnetico"<?php if ($regaloutorizado == "Magnetico") {echo "selected";}?>>Magnetico</option>
                                                                                                           <option value="Pulsador"<?php if ($regaloutorizado == "Pulsador") {echo "selected";}?>>Pulsador</option>
                                                                                                      
                        
                                                                                                    </select>
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">FORMA DE PAGO TC:</td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%">
                                                                                                   <select class="form-control input-sm" name="lblformadepagotc" id="lblformadepagotc" disabled="disabled">
                        <option value="">Seleccione</option>                                                                                
                        <option value="Cheque" <?php if ($formadepago == "Cheque") {echo "selected";}?>>Cheque</option>
                                                                                                         <option value="Deposito" <?php if ($formadepago == "Deposito") {echo "selected";}?>>Depósito</option>
                                                                                                        <option value="Transferencia" <?php if ($formadepago == "Transferencia") {echo "selected";}?>>Transferencia</option>
                                                                                                        <option value="TransferenciaInterbancaria" <?php if ($formadepago == "TransferenciaInterbancaria") {echo "selected";}?>>Transferencia Interbancaria</option>
                                                                                                        <option value="PagoPOSVisa" <?php if ($formadepago == "PagoPOSVisa") {echo "selected";}?>>Pago POSVisa</option>
                                                                                                        <option value="PagoPOSMC" <?php if ($formadepago == "PagoPOSMC") {echo "selected";}?>>Pago POSMC</option>
                                                                                                        <option value="TarjetadeCredito" <?php if ($formadepago == "TarjetadeCredito") {echo "selected";}?>>Tarjeta de Crédito</option>
                                                                                                        <option value="PagoPasarella" <?php if ($formadepago == "PagoPasarella") {echo "selected";}?>>Pago Pasarella</option>
                                                                                                    </select>
                                                                                                </td>
                                                                                            </tr> 
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">MESES AUTORIZADOS TC:</td>
                        
                                                                                                <td style="width:25%"><input type="text" maxlength="3" class="form-control input-sm" id="lblmesesautorizadostc" name="lblmesesautorizadostc"  value="<?php echo $mesesautorizados;?>" onkeypress="return filterFloat(event, this);" disabled="disabled">
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">PAI TC:</td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"><select class="form-control input-sm" name="lblPAItc" id="lblPAItc" disabled="disabled">
                                                                                                        <option>Seleccione</option>
                                                                                                        <option value="BBVA-DIN"<?php if ($PAI == "BBVA-DIN") {echo "selected";}?>>BBVA-DIN</option>
                                                                                                        <option value="PAI 30x36"<?php if ($PAI == "PAI 30x36") {echo "selected";}?>>PAI 30x36</option>
                                                                                                        <option value="NO"<?php if ($PAI == "NO") {echo "selected";}?>>NO</option>
                                                                                                       
                                                                                                    </select>
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                           
                                                                                            <tr>
                                                          
                        
                        <td style="width:15%;font-size: 12px">COMENTARIO TC:</td>
                        
                        <td colspan="5" style="width:77%"><textarea class="form-control input-sm" name="lblcomentariotc" id="lblcomentariotc" rows="3" style="resize:none"  placeholder="Ingresar..." disabled="disabled"><?php echo $TCComentario;?></textarea></td>
                                                                                            </tr>
                                                                                            
                                                                                           
                                                                                        </table>
                                    </div>
                                    <!-- /.box-body -->
                        
                                  </div>
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACION DE AGENDA</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                     <table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
                                                                                              <tr>
                                                                                                <td style="width:15%;font-size: 12px">INSTALADOX:</td>
                        
                                                                                                <td style="width:25%"><select class="form-control input-sm" name="lblinstaladox" id="lblinstaladox" disabled="disabled">
                                                                                                        <option>Seleccione</option>
                                                                                                         <option value="TEC"<?php if ($instaladox == "TEC") {echo "selected";}?>>TEC</option>
                                                                                                        <option value="DEL"<?php if ($instaladox == "DEL") {echo "selected";}?>>DEL</option>
                                                                                                    </select>
                                                                                                    
                                                                                                    <input id="lblidagenda" name="lblidagenda" value="<?php echo $idagenda;?>" hidden="">
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">TÉCNICO:</td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"> 
                                                                                                    <select name="lbltecnico" id="lbltecnico" class="form-control cbxtecnico input-sm" style="width: 100%;" disabled="disabled">
                                                                                                        <?php echo $html_tecnico;?>
                                                                                                    </select>
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                       
                                                                                            
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">F.INSTALACIÓN:</td>
                        
                                                                                                <td style="width:25%"><div class="input-group" id="fi">
                                                                                                        <div class="input-group-addon input-sm">
                                                                                                            <i class="fa fa-calendar"></i>
                                                                                                        </div>
                                                                                                        <input type="text" class="form-control pull-right input-sm" id="fechainst" value="<?php echo $fechainstalacionver;?>"  name="lblfinstalacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled="disabled">
                                                                                                    </div>
                                                                                                    
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">H.INSTALACIÓN:</td>
                                                                                                <td style="width:2%"></td>
                                                                                                
                                                                                                <td style="width:25%">
                                                                     
                                                                                                    
                                                                                                    <div class="bootstrap-timepicker timepicker">
                                                                                                     <div class="input-group">
                                                                                                         <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhinstalacion" id="horainst" value="<?php echo $horainstalacionver;?>" disabled="disabled" >
                                                                                                            <div class="input-group-addon input-sm">
                                                                                                                <i class="fa fa-clock-o"></i>
                                                                                                            </div>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                       
                                                                                                    
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">REPERCUCIÓN:</td>
                                                                                                <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblrepercucion" id="lblrepercucion" rows="1" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php echo $repercucion;?></textarea></td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"><a class="btn btn-danger btn-sm"  href="#" data-toggle="modal" id="logcambios" data-target="#modal-default"><i class="fa fa-pencil-square-o"></i> Log Cambios</a></td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                            
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">COMENTARIO:</td>
                        
                                                                                                <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblcomentarioagenda" id="lblcomentarioagenda" rows="1" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php utf8_encode($comentarioagenda);?></textarea></td>
                        
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"> </td>
                                                                                            </tr>
                                                                                            
                                                                                            <tr class="espacio" id="tinviableespacio"></tr>
                                                                                            <tr id="tinviable">
                                                                                                <td style="width:15%;font-size: 12px">MOTIVO INVIABLE:</td>
                        
                                                                                                <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblinviable" id="lblinviable" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $motivoinviable;?></textarea></td>
                        
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"></td>
                                                                                            </tr>
                                                                                            
                                                                                            <tr class="espacio" id="tcanceladoespacio"></tr>
                                                                                            <tr id="tcancelado">
                                                                                                <td style="width:15%;font-size: 12px">MOTIVO CANCELADO:</td>
                        
                                                                                                <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblcancelado" id="lblcancelado" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $motivocancelado;?></textarea></td>
                        
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"></td>
                                                                                            </tr>
                        
                                                                                          
                                                                                        </table>
                                    </div>
                                    <!-- /.box-body -->
                        
                                  </div>
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                      <h5>INFORMACION DE FACTURACIÓN</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                  <table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">MOTIVO INCIDENCIA:</td>
                                                                                                <td colspan="7" style="width:77%"><textarea class="form-control input-sm" name="lblmotivoincidencia" id="lblmotivoincidencia" rows="1" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php echo $factmotivoincidencia;?></textarea></td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">FECHA RECEPCION DOC.:</td>
                                                                                                <td style="width:25%"><div class="input-group">
                                                                                                        <div class="input-group-addon input-sm">
                                                                                                            <i class="fa fa-calendar"></i>
                                                                                                        </div>
                                                                                                        <input type="text" class="form-control pull-right input-sm" id="lblfecharecpciondoc"  name="lblfecharecpciondoc" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfecharecepciondoc;?>" disabled="disabled" >
                                                                                                    </div>
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">FECHA DE FACTURACIÓN: <span style="font-size: 12px; color:red ">(*)</span></td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"><div class="input-group">
                                                                                                        <div class="input-group-addon input-sm">
                                                                                                            <i class="fa fa-calendar"></i>
                                                                                                        </div>
                                                                                                        <input type="text" class="form-control pull-right input-sm" id="lblfechafacturacion"  name="lblfechafacturacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfechafacturacion;?>" disabled="disabled" />
                                                                                                    </div></td>
                                                                                            </tr>
                                        </table>
                                        
                                        <table cellspacing="0"  style="width:100%;border-collapse: separate;padding: 20px">                                                  
                                                                                            <tr>
                                                                                                <td style="font-size: 12px; color:red ">MOTIVOS DE INCIDENCIA (*):</td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:8%;font-size: 12px">DOC. ORIGINAL:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdocoriginal" id="lblfactdocoriginal" value="<?php echo $factdocoriginal;?>" disabled="disabled" /></td>
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">FALTA DNI:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdni" id="lblfactdni" value="<?php echo $factdni;?>" disabled="disabled" /></td>
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">REHACER CTO:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactrehacercto" id="lblfactrehacercto" value="<?php echo $factrehacercto;?>" disabled="disabled" /></td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:8%;font-size: 12px">SEGMENTACIÓN:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactsegmentacion" id="lblfactsegmentacion" value="<?php echo $factsegmentacion;?>" disabled="disabled" /></td>
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">ELEMENTOS CTO PS:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactelementosctops" id="lblfactelementosctops" value="<?php echo $factelementosctops;?>" disabled="disabled" /></td>
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">AFILIACION:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactafiliacion" id="lblfactafiliacion" value="<?php echo $factafiliacion;?>" disabled="disabled" /></td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:8%;font-size: 12px">PAGO:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactpago" id="lblfactpago" value="<?php echo $factpago;?>" disabled="disabled" /></td>   
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">DOC PAI:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdocpai" id="lblfactdocpai" value="<?php echo $factdocpai;?>" disabled="disabled" /></td>
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">PROSPECTO/NRO GUIA:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactprospecto_nroguia" id="lblfactprospecto_nroguia" value="<?php echo $factprospecto_nroguia;?>" disabled="disabled" /></td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:8%;font-size: 12px">AUTORIZA:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactautoriza" id="lblfactautoriza" value="<?php echo $factautoriza;?>" disabled="disabled" /></td>
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">FALTA DOC (P.A./CTO):</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactfaltadoc" id="lblfactfaltadoc" value="<?php echo $factfaltadoc;?>" disabled="disabled" /></td>
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">FUERA DE HORA:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactfuerahora" id="lblfactfuerahora" value="<?php echo $factfuerahora;?>" disabled="disabled" /></td>
                                                                                            </tr>
                                            </table> 
                                    </div>
                                    <!-- /.box-body -->
                               
                                  </div>
                            </form>
                        </div>
                        <div class="col-md-2"></div>
                    </div>
                    <div class="modal fade" id="modal-default">
                        <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <div class="modal-header modal-header-danger">
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                <h4>GESTIONES DE AGENDAMIENTO</h4>
                            </div>
                            <div class="modal-body" id="vistaboy">
                                <div id="myGrid"  style="height: 100%" class="ag-theme-fresh"></div>
                                <div  id="ningunresultado"></div>
                            </div> 
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                            </div>                  
                        </div>
                    </div>  
                        <!-- /.modal-content -->
                    </div>
                </section>
                    <!-- /.modal-dialog -->
            </div>
                <!-- /.modal -->
                
            <div class="modal fade" id="mapgeofinder">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-success">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4 class="modal-title">DIRECCION</h4>
                        </div>
                        <div class="modal-body" style="width: 100%;height:100%;">
                           <iframe height="450"  allowTransparency="true" frameborder="0" scrolling="yes" style="width:100%;" src="GFWIDGET-PE-v2/buscadorDirExacta.html" type= "text/javascript"></iframe>
                        </div>
                        <div class="modal-footer">
                            <!--<button type="button" class="btn btn-danger pull-irght" id="btnDireccionManual">MANUAL</button> -->
                            <button type="button" class="btn btn-default pull-right" data-dismiss="modal">CERRAR</button>
                        </div>
                    </div>
                    <!-- /.modal-content -->

                </div>
                <!-- /.modal-dialog -->
            </div>
            
            <!--MODAL MAPA -->
            <div class="modal fade" id="mapgeofinderDirAprox">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4 class="modal-title"><i class=""></i> DIRECCION APROXIMADA</h4>
                        </div>
                        <div class="modal-body" style="width: 100%;height:100%;">
                           <iframe id="geofinderwidgetDirAprox" name="geofinderwidgetDirAprox" height="450"  allowTransparency="true" frameborder="0" scrolling="yes" style="width:100%;" src="GFWIDGET-PE-v2/buscadorDirAprox.html" type= "text/javascript"></iframe>
                        </div>
                        <div class="modal-footer">
                            <!--<button type="button" class="btn btn-danger pull-irght" id="btnGuardarDirAprox">Guardar</button>-->
                            <button type="button" class="btn btn-default pull-right" data-dismiss="modal">CERRAR</button>
                        </div>
                    </div>
                    <!-- /.modal-content -->

                </div>
                <!-- /.modal-dialog -->
            </div>
            <!-- MODAL CHECK IN -->
            <div class="modal fade" id="modal-checkin">
                        <div class="modal-dialog modal-log">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4>Validar Check-IN ...</h4>
                                </div>
                                <div class="modal-body">
                                    <div class="box box-solid">
                                        <div class="box-header with-border">
                                            <i class="fa fa-map-marker"></i>
                                            <h3 class="box-title">Información del Check-IN</h3>
                                        </div>
                                        <!-- /.box-header -->
                                        <div class="box-body">
                                            <dl class="dl-horizontal">
                                                <dt>Distancia: </dt>
                                                <dd><?php echo $Distancia.' metros'; ?></dd>
                                                <dt>Fecha envío:</dt>
                                                <dd><?php echo $FechaEnvio; ?></dd>
                                                <dt>Tipo:</dt>
                                                <dd><?php echo $Tipo; ?></dd>
                                                <dt>Matricula:</dt>
                                                <dd><?php echo $lblnombcomercial.' ('.$MatriculaCheckIn.')'; ?></dd>
                                                <!-- <dt>Visita No Visitable:</dt>
                                                <dd><?php //echo $VisitaNoVisitable; ?></dd> -->
                                                <dt>Observaciones Check-IN:</dt>
                                                <dd><?php echo $ObservacionesCheckIN; ?></dd>
                                            </dl>
                                        </div>
                                        <!-- /.box-body -->
                                    </div>
                                    <div class="box box-solid">
                                        <div class="box-header with-border">
                                            <i class="fa fa-map-marker"></i>
                                            <h3 class="box-title">Información de la VnoV</h3>
                                        </div>
                                        <div class="box-body">
                                            <dl class="dl-horizontal">
                                                <dt>MotivoVNOV: </dt>
                                                <dd><?php echo $MotivoVNOV; ?></dd>
                                            </dl>
                                        </div>
                                    </div>
                                    <div id="mapContenedor">
                                        <div id="map"></div>
                                    </div>
                                    
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-success" id="btnGuardarCheckIn">Validar</button>
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                                </div>  
                            </div>
                        </div>
                    </div>

            <!-- MODAL DE DUPLICODAD -->
<div class="modal fade" id="modal-numero">
    
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                <h3 id="myModalLabel">INFORMACIÓN - NUMERO</h3>
                        </div>
                        <div class="modal-body">
                                    <div class="row">
                                        <!-- left column -->
                                        <div class="col-xs-12">
                                            <!-- general form elements -->
                                            <div class="box box-danger">
                                                <div class="box-header with-border">
                                                  <h1 class="box-title">VALIDAR NÚMERO - <span id="spanNumero"></span></h1>
                                                </div>
                                                <!-- /.box-header -->
                                                <!-- form start -->
                                                <div class="box-body" id="bodyprincipal">
                                                    <p id="tot">Total de registros: <code><span id="countBUSCAR"></span></code></p>
                                                    <div  id="vistaboy9" style="height: 280px">
                                                    <div id="myGrid3"  style="height: 100%" class="ag-theme-fresh"></div>
                                                    <div  id="ningunresultadoNumero"></div>
                                                      </div>
                                                </div>
                                                <!-- /.box-body -->
                                            </div>
                                            <!-- /.box -->
                                        </div>
                                    </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                        </div>   
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>   


<!-- MODAL DE PREVIEW SECURITY CHECK -->
         <div class="modal fade" id="modal-previewsc">
                        <div class="modal-dialog modal-log">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4>SECURITY CHECK</h4>
                                </div>
                                <div class="modal-body">
                                    <div class="box box-solid">
                                        <div class="box-header with-border">
                                        </div>
                                        <!-- /.box-header -->
                                        <div class="box-body">

                                            <div id="canvasContenedor">
                                                    <iframe id="iframeSC" src="" style="border:0px" width="100%" height="500">
                                                    </iframe> 
                                            </div>

                                        </div>
                                        <!-- /.box-body -->
                                    </div>
                                    
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                                </div>  
                            </div>
                        </div>
                    </div>
                
                <!-- /.content -->
        </div>
        <!-- /.content-wrapper -->
           


            <div class="control-sidebar-bg"></div>
        </div>
        <!-- ./wrapper -->
        
        <!-- jQuery v1.11 -->
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>

        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
        $.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
       <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
        <!-- BOOTSTRAP TOOGLE -->
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
         <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- Notificaciones -->
        <script src="js/notificaciones.js" type="text/javascript"></script>
        <!-- SWAL -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <!-- LEAFLET -->
        <script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js" integrity="sha512-XQoYMqMTK8LvdxXYG3nZ448hOEQiglfqkJs1NOQV44cWnUrBc8PkAOcXy20w0vlaXaVUearIOBhiXZ5V3ynxwA==" crossorigin=""></script>
        <script src="lib/leaflet_AwesomeMarkers/dist/leaflet.awesome-markers.js"></script>
        <!-- HTML -->
        <script src="admin/plugins/html2canvas/html2canvas.js" type="text/javascript"></script>
        
        <!-- AGGRID -->
        <script>
            var columnDefs = [
                    {headerName: 'FechaHoraREG', field: 'FechaHoraREG', width: 140},
                    {headerName: 'FechaInst', field: 'FechaInst', width: 130, pinned: 'left'},
                    {headerName: 'HoraInst', field: 'HoraInst', width: 105, pinned: 'left'},
                    {headerName: 'InstaladoX', field: 'InstaladoX', width: 100},
                    {headerName: 'MatriculaTec', field: 'MatriculaTec', width: 110},
                    {headerName: 'Repercusion', field: 'Repercusion', width: 130},
                    {headerName: 'MotivoInviable', field: 'MotivoInviable', width: 150},
                    {headerName: 'Comentario', field: 'Comentario', width: 200},
                    {headerName: 'EstadoVenta', field: 'EstadoVenta', width: 120},
                    {headerName: 'Gestor', field: 'GestorAgenda', width: 120}
                ];

            var gridOptions = {
                columnDefs: columnDefs,
                rowData: null,
                enableFilter: true,
                enableColResize: true,
                localeText: {
                    // for filter panel
                    page: 'página',
                    more: 'Más',
                    to: 'a',
                    of: 'de',
                    next: 'Siguiente',
                    last: 'Último',
                    first: 'Primero',
                    previous: 'Anterior',
                    loadingOoo: 'Cargando...',
                    // for set filter
                    selectAll: 'Seleccionar todo',
                    searchOoo: 'Buscando...',
                    blanks: 'Espacios en blanco',
                    // for number filter and text filter
                    filterOoo: 'Filtrar...',
                    applyFilter: 'Aplicar Filtro',
                    // for number filter
                    equals: 'Igual',
                    notEqual: 'No es igual',
                    lessThanOrEqual: 'Menor o igual',
                    greaterThanOrEqual: 'Mayor que o igual',
                    inRange: 'En el rango',
                    lessThan: 'Menos que',
                    greaterThan: 'Mas grande que',
                    // for text filter
                    contains: 'Contiene',
                    startsWith: 'Comienza con',
                    endsWith: 'Termina con',
                    notContains:'No contiene',
                    // the header of the default group column
                    group: 'Grupo',
                    // tool panel
                    columns: 'columnas',
                    rowGroupColumns: 'Grupo columnas',
                    rowGroupColumnsEmptyMessage: 'No hay resultado',
                    valueColumns: 'Columna de valor',
                    pivotMode: 'Modo pivote',
                    groups: 'grupos',
                    values: 'valor',
                    pivots: 'pivote',
                    valueColumnsEmptyMessage: 'No hay resultado',
                    pivotColumnsEmptyMessage: 'No hay resultado',
                    // other
                    noRowsToShow: '<div class="callout callout-danger">\n\
                                    <span class="pull-left">\n\
                                    <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
                                    </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
                                    <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
                                    <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
                                    <br></div>',
                    // enterprise menu
                    pinColumn: 'Aclar columna',
                    valueAggregation: 'Agregar valor',
                    autosizeThiscolumn: 'Auto tamaño esta columna ',
                    autosizeAllColumns: 'Auto tamaño todas columnas',
                    groupBy: 'Agrupar',
                    ungroupBy: 'Agrupar uno',
                    resetColumns: 'Restaurar Columnas',
                    expandAll: 'expandir todo',
                    collapseAll: 'desplegar todo',
                    toolPanel: 'Panel de Heramientas',
                    export: 'Exportar',
                    csvExport: 'Exportar CSV',
                    excelExport: 'Exportar Excel',
                    // enterprise menu pinning
                    pinLeft: 'Anclar a derecha',
                    pinRight: 'Anclar a izquierda',
                    noPin: 'Desanclar',
                    // enterprise menu aggregation and status panel
                    sum: 'Sumar',
                    min: 'Minimo',
                    max: 'Maximo',
                    first: 'Primero',
                            last: 'Ultimo',
                            none: 'Nada',
                    count: 'Contador',
                    average: 'Promedio',
                    // standard menu
                    copy: 'Copiar',
                    copyWithHeaders: 'Copiar Cabecera',
                    ctrlC: 'Ctrl+C',
                    paste: 'Pegar',
                    ctrlV: 'Ctrl+V'
                },
                enableSorting: true
            };

            function onFilterChanged(value) {
                gridOptions.api.setQuickFilter(value);
            }
            function listar() {
             var idventa=$("#idVenta").val();
                $.ajax({
                    url: 'ajax/findDataHisAgenda.php?idventa='+idventa,
                    success: function (data) {
        
                        if (data == 1) {
                            var gridDiv = document.querySelector('#myGrid');
                            new agGrid.Grid(gridDiv, gridOptions);
        
                            agGrid.simpleHttpRequest({url: 'ajax/selectListarHistAgenda.php?idventa='+idventa}).then(function (data) {
        
                                gridOptions.api.setRowData(data);
                            });
                            $('#vistaboy').height(function (index, height) {
        
                                return $(window).height() * 35 / 100;
                            });
                           
                        } else {
        
                            $("#ningunresultado").html(data);
        
                            var gridDiv = document.querySelector('#myGrid');
                            new agGrid.Grid(gridDiv, gridOptions);
        
                            agGrid.simpleHttpRequest({url: 'ajax/selectListarHistAgenda.php?idventa='+idventa}).then(function (data) {
        
                                gridOptions.api.setRowData(data);
                            });
                            $('#myGrid').hide("fast");
        
                        }
        
                    }
                });
            }
            
            var refresh = function () {
                var idventa=$("#idVenta").val();
                $.ajax({
                    url: 'ajax/findDataHisAgenda.php?idventa='+idventa,
                    success: function (data) {
                        if (data == 1) {
                            var gridDiv = document.querySelector('#myGrid');
                            agGrid.simpleHttpRequest({url: 'ajax/selectListarHistAgenda.php?idventa='+idventa}).then(function (data) {
                                gridOptions.api.setRowData(data);
                            });
                            $('#vistaboy').height(function (index, height) {
        
                                return $(window).height() * 35 / 100;
                            });
                            $("#ningunresultado").hide("fast");
                            $('#myGrid').show(200);
                        } else {
        
                            $("#ningunresultado").html(data);
                            $('#myGrid').hide("fast");
        
                        }
                    }   
                });
            }

            // setup the grid after the page has finished loading
            
        </script>
    <!-- GRILLAS -->
        <script type="text/javascript">
            var columnDefsBUSCAR = [
                {headerName: 'ID', field: 'ID', width: 60},
                {headerName: 'FechaHoraREG', field: 'FechaHoraREG', width: 120},
                {headerName: 'Matricula', field: 'Matricula', width: 120},
                {headerName: 'Comercial', field: 'Comercial', width: 150},
                {headerName: 'CC', field: 'CC', width: 60},
                {headerName: 'NProspecto', field: 'NProspecto', width: 100},
                {headerName: 'TipoVenta', field: 'TipoVenta', width: 120},
                {headerName: 'Telefonouno', field: 'Telefonouno', width: 120},
                {headerName: 'Telefonodos', field: 'Telefonodos', width: 120},
                {headerName: 'OrigenVista', field: 'OrigenVista', width: 120}
            ];
            var gridOptionsBUSCAR = {
                    columnDefs: columnDefsBUSCAR,
                    onPaginationChanged: onPaginationChangedBUSCAR,
                    rowData: null,
                    enableFilter: true,
                    enableColResize: true,
                    localeText: {
                        // for filter panel
                        page: 'página',
                        more: 'Más',
                        to: 'a',
                        of: 'de',
                        next: 'Siguiente',
                        last: 'Último',
                        first: 'Primero',
                        previous: 'Anterior',
                        loadingOoo: 'Cargando...',
                        // for set filter
                        selectAll: 'Seleccionar todo',
                        searchOoo: 'Buscando...',
                        blanks: 'Espacios en blanco',
                        // for number filter and text filter
                        filterOoo: 'Filtrar...',
                        applyFilter: 'Aplicar Filtro',
                        // for number filter
                        equals: 'Igual',
                        notEqual: 'No es igual',
                        lessThanOrEqual: 'Menor o igual',
                        greaterThanOrEqual: 'Mayor que o igual',
                        inRange: 'En el rango',
                        lessThan: 'Menos que',
                        greaterThan: 'Mas grande que',
                        // for text filter
                        contains: 'Contiene',
                        startsWith: 'Comienza con',
                        endsWith: 'Termina con',
                        notContains:'No contiene',
                        // the header of the default group column
                        group: 'Grupo',
                        // tool panel
                        columns: 'columnas',
                        rowGroupColumns: 'Grupo columnas',
                        rowGroupColumnsEmptyMessage: 'No hay resultado',
                        valueColumns: 'Columna de valor',
                        pivotMode: 'Modo pivote',
                        groups: 'grupos',
                        values: 'valor',
                        pivots: 'pivote',
                        valueColumnsEmptyMessage: 'No hay resultado',
                        pivotColumnsEmptyMessage: 'No hay resultado',
                        // other
                        noRowsToShow: '<div class="callout callout-danger">\n\
                        <span class="pull-left">\n\
                        <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
                        </span>\n\<h4><i class="fa fa-search"></i> ¡ADVERTENCIA!</h4>\n\
                        <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
                        <br></div>',
                        // enterprise menu
                        pinColumn: 'Aclar columna',
                        valueAggregation: 'Agregar valor',
                        autosizeThiscolumn: 'Auto tamaño esta columna ',
                        autosizeAllColumns: 'Auto tamaño todas columnas',
                        groupBy: 'Agrupar',
                        ungroupBy: 'Agrupar uno',
                        resetColumns: 'Restaurar Columnas',
                        expandAll: 'expandir todo',
                        collapseAll: 'desplegar todo',
                        toolPanel: 'Panel de Heramientas',
                        export: 'Exportar',
                        csvExport: 'Exportar CSV',
                        excelExport: 'Exportar Excel',
                        // enterprise menu pinning
                        pinLeft: 'Anclar a derecha',
                        pinRight: 'Anclar a izquierda',
                        noPin: 'Desanclar',
                        // enterprise menu aggregation and status panel
                        sum: 'Sumar',
                        min: 'Minimo',
                        max: 'Maximo',
                        first: 'Primero',
                                last: 'Ultimo',
                                none: 'Nada',
                        count: 'Contador',
                        average: 'Promedio',
                        // standard menu
                        copy: 'Copiar',
                        copyWithHeaders: 'Copiar Cabecera',
                        ctrlC: 'Ctrl+C',
                        paste: 'Pegar',
                        ctrlV: 'Ctrl+V'
                    },
                    enableSorting: true,
                    onGridReady: function(params) {
                    var defaultSortModel = [
                            {colId: "Matricula", sort: "asc"}
                        ];
                    params.api.setSortModel(defaultSortModel);
                }
                };            

            function onPaginationChangedBUSCAR(params) {
               this.gridRowCount = params.api.paginationGetRowCount();
               $("#countBUSCAR").html(this.gridRowCount);
             }

             function onFilterChangedBUSCAR(value) {
                 gridOptions.api.setQuickFilter(value);
             }

             function listarBUSCAR() {
                 var numero='9';
               $.ajax({
                   url: 'ajax/findDataxNumero.php?numero=' + numero,
                   success: function (data) {
                       console.log(data);
                       if (data == 1) {
                           var gridDiv = document.querySelector('#myGrid3');
                           new agGrid.Grid(gridDiv, gridOptionsBUSCAR);
                           agGrid.simpleHttpRequest({url: 'ajax/selectListarXNumero.php?numero='+numero}).then(function (datos) {
                               console.log(datos);
                              gridOptionsBUSCAR.api.setRowData(datos);
                           });
                           /*$('#vistaboy9').height(function (index, height) {
                               return $(window).height() * 35 / 100;
                           });*/
                       } else {
                           $("#ningunresultadoNumero").html(data);
                           var gridDiv = document.querySelector('#myGrid3');
                           new agGrid.Grid(gridDiv, gridOptionsBUSCAR);
                           agGrid.simpleHttpRequest({url: 'ajax/selectListarXNumero.php?numero=' + numero}).then(function (datos) {
                               console.log(datos);
                               gridOptionsBUSCAR.api.setRowData(datos);
                           });
                           $('#tot').hide("fast");
                           $('#myGrid3').hide("fast");
                       }
                   }
               });
               }

             var refreshBUSCAR = function () {
                 var numero=$("#lblmovil").val();
                 $.ajax({
                     url: 'ajax/findDataxNumero.php?numero=' + numero,
                     success: function (data) {
                         if (data == 1) {
                             var gridDiv = document.querySelector('#myGrid3');
                             agGrid.simpleHttpRequest({url: 'ajax/selectListarXNumero.php?numero=' + numero}).then(function (data) {
                                 gridOptionsBUSCAR.api.setRowData(data);
                             });
                             /*$('#vistaboy9').height(function (index, height) {
                                 return $(window).height() * 35 / 100;
                             });*/
                             $("#ningunresultadoNumero").hide("fast");
                             $("#btnsiguiente").show("fast");
                             $('#myGrid3').show(200);
                              $('#tot').show(200);
                         } else {
                             $('#ningunresultadoNumero').show(200);
                             $("#ningunresultadoNumero").html(data);
                             $("#btnsiguiente").show("fast");
                             $('#myGrid3').hide("fast");
                             $('#tot').hide("fast");
                         }
                     }
                 });
               }

                 // setup the grid after the page has finished loading
        </script>

        <!-- ERROR DE GESTION -->
        <script>
            $('#errorGestion').on('click', async function(){
                const { value: formValues } = await Swal.fire({
                  title: 'Tipificar Error de Gestión',
                  html:
                    `<select style="width: 100%;" id="tipo_error" class="swal2-select">
                        <option value="" disabled selected>Colocar tipificación</option>
                        <option value='Segmento incorrecto'>Segmento incorrecto</option>
                        <option value='Sin rubro del negocio'>Sin rubro del negocio</option>
                        <option value='Error tipo residencial'>Error tipo residencial</option>
                        <option value='Error número de piso'>Error número de piso</option>
                        <option value='Origen incorrecto'>Origen incorrecto</option>
                        <option value='Grupo ACD erróneo '>Grupo ACD erróneo </option>
                        <option value='Fecha de visita incorrecta'>Fecha de visita incorrecta</option>
                        <option value='Acepta visita – menos 2 horas'>Acepta visita – menos 2 horas</option>
                        <option value='No acepta visita en Verismart'>No acepta visita en Verismart</option>
                        <option value='Horario incorrecto'>Horario incorrecto</option>
                        <option value='Fecha en obras'>Fecha en obras</option>
                        <option value='Nombre incompleto'>Nombre incompleto</option>
                        <option value='Visita sin scoring'>Visita sin scoring</option>
                        <option value='Orden de dirección'>Orden de dirección</option>
                        <option value='Dirección incompleta'>Dirección incompleta</option>
                        <option value='Dirección incorrecta'>Dirección incorrecta</option>
                        <option value='Zona restringida'>Zona restringida</option>
                        <option value='Distrito erróneo'>Distrito erróneo</option>
                        <option value='No ingresa tipo dirección'>No ingresa tipo dirección</option>
                        <option value='No ingresa número de dpto'>No ingresa número de dpto</option>
                        <option value='Referencias no exactas'>Referencias no exactas</option>
                        <option value='Geolocalización incorrecta'>Geolocalización incorrecta</option>
                        <option value='Teléfono erróneo'>Teléfono erróneo</option>
                        <option value='Comentarios incompletos'>Comentarios incompletos</option>
                        <option value='Datos no coincide'>Datos no coincide</option>
                        <option value='No acepta visita en Infopoint'>No acepta visita en Infopoint</option>
                        <option value='Error infopoint'>Error infopoint</option>
                        <option value='Error tipificación'>Error tipificación</option>
                        <option value='Otros'>Otros</option>
                    </select>`,
                  focusConfirm: false,
                  preConfirm: () => {
                      let tipoError = document.getElementById('tipo_error').value;
                        return [
                                  tipoError
                                ]
                  }
                })
                
                //console.log(formValues);
                
                if (formValues) {
                    const arregloError = JSON.stringify(formValues);
                    //console.log(arregloError);
                    $('#lblErrorGestion').val(formValues[0]);
                    $('#lblcomentarioserrorgestion').prop('disabled', false);
                    Swal.fire('Error de Gestión seleccionado', '', 'success');
                }
            })
        </script>
        
        <!-- DOCUMENT READY --> 
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                
                localStorage.setItem('PosicionObjExacta', '{}');
                localStorage.setItem('PosicionObjAprox', '{}');
                
                marcarUbicacionMapa();
        
                listar();
                listarBUSCAR();
        
            });
        </script>
        <!-- EVENTOS -->
        <script>
            //MODIFICACION EMU 16.05    
            $('#FObras').bootstrapToggle({
                on:'SI',
                off:'NO',
                onstyle:'success',
                offstyle:'danger'
            });
            //MODIFICACION EMU 21.05
            $('#FObras').change(function(){
              if($(this).prop('checked')){
                 $('#ValFObras').val('SI');
                 $('#txtFVisitaReal').show();
                 $('#dpFVisitaReal').show();
                $('#txtFvisita').html("FECHA VISITA (OBRAS):");
                 $('#txtFVisitaReal').html("FECHA VISITA ORIGINAL:");
                 
              }else{
                $('#ValFObras').val('NO');
                 $('#txtFVisitaReal').hide();
                 $('#dpFVisitaReal').hide();
                 $('#txtFvisita').html("FECHA VISITA:");
                 $('#txtFVisitaReal').html("");
               }
               
            });
            
            $("#lbldc").change(function () {
                $("#lbldc option:selected").each(function () {
                    var lbldc = $(this).val();
                    $.post("./ajax/selectJefeVenta.php", { lbldc: lbldc }, function(data){
                        $("#lbljefeventa").html(data);
                    });            
                });
            });
            
            $("#lblinstaladox").change(function () {
                $("#lblinstaladox option:selected").each(function () {
                    var lblinstaladox= $(this).val();
                    $.post("./ajax/selectTecnico.php", { lblinstaladox: lblinstaladox }, function(data){
                        $("#lbltecnico").html(data);
                    });            
                });
            });
   
            $('#checki').bootstrapToggle({
                on:'SI',
                off:'NO',
                onstyle:'success',
                offstyle:'danger'
            });

            $('#checki').change(function(){
              if($(this).prop('checked')){
                 $('#hidden_checki').val('SI');
              }else{
                $('#hidden_checki').val('NO');
               }
            });

            $("#lblestadoventa").change(function () {
                var condiciones = $("#lblestadoventa").val();
                bloquear(condiciones);
            });

            $("#lblcategoria").change(function () {
                var categoria = $("#lblcategoria").val();
                 $("#lblcat").val(categoria);
                bloquearxCategoria(categoria);
                    
            });
            
            /* ANULACIONES */

            $('#seanula').change(function(){
                if($(this).prop('checked')){
                    $('#lblseanula').val('SI');
                } else {
                    $('#lblseanula').val('NO');
                }
            });
   
            $('#seanula').bootstrapToggle({
                on:'SI',
                off:'NO',
                onstyle:'success',
                offstyle:'danger'
            });

            $("#lblestadovisita").change(function () {
                var estadovisita = $("#lblestadovisita").val();
                $("#lblestvisita").val(estadovisita);
                    
                if(estadovisita =="AnuladaTEC"){
                    $("#lblestadoventa").val("AnuladaTEC");
                    $("#lblcat").val("Anulada");
                }
                if(estadovisita =="AnuladaOP"){
                    $("#lblestadoventa").val("AnuladaOP");
                    $("#lblcat").val("Anulada");
                }
                if(estadovisita =="AnuladaCLI"){
                    $("#lblestadoventa").val("AnuladaCLI");
                    $("#lblcat").val("Anulada");
                }
                if(estadovisita =="AnuladaporCruce"){
                    $("#lblestadoventa").val("AnuladaporCruce");
                    $("#lblcat").val("Anulada");
                }
                if(estadovisita =="AnuladaNoImputableOper"){
                    $("#lblestadoventa").val("AnuladaNoImputableOper");
                    $("#lblcat").val("Anulada");
                }
                if(estadovisita =="AnuladaTECAudio"){
                    $("#lblestadoventa").val("AnuladaTECAudio");
                    $("#lblcat").val("Anulada");
                }                 
                
                
                if(estadovisita =="Asignada"){
                    $("#lblestadoventa").val("VAsignada");
                    $("#lblcat").val("VAsignada");
                }
                if(estadovisita =="NoVendida"){
                    $("#lblestadoventa").val("NoVendida");
                    $("#lblcat").val("NoVendida");
                }
                if(estadovisita =="PendienteValidarVnoV"){
                    $("#lblestadoventa").val("PendienteValidarVnoV");
                    $("#lblcat").val("VAsignada");
                }
                if(estadovisita =="AnuladaCC"){
                    $("#lblestadoventa").val("AnuladaCC");
                    $("#lblcat").val("AnuladaCC");
                }
                
                /* ANULACIONES */
                if(estadovisita =="Asignada" || estadovisita =="AnuladaTEC" || estadovisita =="AnuladaOP" || estadovisita =="AnuladaCLI" || estadovisita =="AnuladaporCruce" || estadovisita =="AnuladaNoImputableOper" || estadovisita =="AnuladaTECAudio" || estadovisita =="AnuladaCC" || estadovisita =="NoVendida"){
                    $(".trAnulaciones").removeClass("ocultar");
                    $("#lblseanula").val("SI");
                    
                    if(estadovisita =="Asignada"){
                        $("#lblmotivoanulacion").val("Asignada");
                    } else if (estadovisita =="AnuladaTEC"){
                        $("#lblmotivoanulacion").val("Técnico");
                    } else if (estadovisita =="AnuladaOP"){
                        $("#lblmotivoanulacion").val("Operador");
                    } else if (estadovisita =="AnuladaCLI"){
                        $("#lblmotivoanulacion").val("Cliente");
                    } else if (estadovisita =="AnuladaporCruce"){
                        $("#lblmotivoanulacion").val("Cruce");
                    } else if (estadovisita =="AnuladaNoImputableOper"){
                        $("#lblmotivoanulacion").val("NoImputableOper");
                    } else if (estadovisita =="AnuladaTECAudio"){
                        $("#lblmotivoanulacion").val("TECAudio");                          
                    } else if (estadovisita =="AnuladaCC"){
                        $("#lblmotivoanulacion").val("AnuladaCC");
                    } else if (estadovisita == "PendienteValidarVnoV") {
                        $("#lblmotivoanulacion").val("PendienteValidarVnoV");
                    } else if (estadovisita == "NoVendida") {
                        $("#lblmotivoanulacion").val("NoVendida");
                    } else {
                        $("#lblmotivoanulacion").val("SI");
                    }
                } else {
                    $(".trAnulaciones").addClass("ocultar");
                    $("#lblseanula").val("NO");
                }
            });
            
            
   
            $('#lblmatricula').on('keyup', function () {
                var dato = $('#lblmatricula').val();
                var url = 'ajax/findMatricula.php';
                $.ajax({
                    type: 'POST',
                    url: url,
                    data: 'dato=' + dato,
                    success: function (datos) {
                        $('.mensajematricula').html(datos);
                    }
                });
                return false;
            });
               
            $("#lblmatricula").autocomplete({
                source: "./ajax/selectMatricula.php",
                minLength: 2,
                select: function (event, ui) {
                    event.preventDefault();
                    $('#lblidusuario').val(ui.item.idusuario);
                    $('#lblmatricula').val(ui.item.matricula);
                    $('#lblnombcomercial').val(ui.item.comercial);
                }
            });

            $("#lblmatricula").on("keydown", function (event) {
                if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE){
                    $('#lblidusuario').val("");
                    $('#lblmatricula').val("");
                    $('#lblnombcomercial').val("");
                }
                if (event.keyCode == $.ui.keyCode.DELETE) {
                    $('#lblmatricula').val("");
                    $('#lblidusuario').val("");
                    $('#lblnombcomercial').val("");
                }
            });
            
            $("#lbltipodoc").change(function () {
                var tipodoc = $("#lbltipodoc").val();
                if(tipodoc=="DNI"){
                   $('#lbldocumento').attr('maxlength', 8);
                }else if(tipodoc=="RUC"){
                   $('#lbldocumento').attr('maxlength', 11);
                }else{
                   $('#lbldocumento').attr('maxlength', 12);
                }
            });
            $('#lblsegmento').change(function(){
                if($('#lblsegmento').val() == 'NEG'){
                    $('.Lead__nlocales').removeClass('ocultar');
                    $('.Lead__tiposegmento').addClass('ocultar');
                    $("#lbltiposegmento").val("");
                } else{
                    $('.Lead__tiposegmento').removeClass('ocultar');
                    $('.Lead__nlocales').addClass('ocultar');
                }

            });
            $('#conSistema').change(function(){
                if($('#conSistema').val() == 'Si'){
                    $('.Lead__empresaAlarmas').removeClass('ocultar');
                } else{
                    $('.Lead__empresaAlarmas').addClass('ocultar');
                    $("#empresaSistema").val("");
                }
            })             
        </script>
        <!-- OTRAS EVENTOS -->
        <script>
            $(document).ready(function () {
                                                                                
                notificacion();
                var estadoVenta = $("#estadoVenta").val();                                                                
                bloquear(estadoVenta);

                var alterClass = function () {
                    var ww = document.body.clientWidth;
                    if (ww < 767) {
                        $('body').removeClass('sidebar-collapse');
                    } else if (ww >= 768) {
                        $('body').addClass('sidebar-collapse');
                    }
                    ;
                };

                $(window).resize(function () {
                    alterClass();
                });
                //Fire it when the page first loads:
                alterClass();

                $('#btnGuardarEditarVenta').click(function () {
                                                                                  
                    var catgventa=$('#lblcat').val();
                    var ediventa=$("#idVenta").val();
                    //Algunas variables por default de alertify
                    alertify.defaults.theme.ok = "btn btn-nuevo";
                    alertify.defaults.theme.cancel = "btn btn-danger";
                    var lastX,lastY;
                        alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function(){ if (validaForm()) {
                        // Primero validará el formulario.
                        var datos = $('#frmEditarVenta').serialize();
                        $.ajax({
                            type: 'POST',
                            url: 'ajax/updateVisita_v4.php',
                            data: "lblcategoria=" + catgventa + "&lblidventa="+ediventa+"&" + datos,
                            success: function (r) { console.log(r);
                                if (r == 1) {
                                     alertify.success("Modificado con exito");
                                
                                }else if(r==2){
                                    alertify.warning("Ya existe N° prospecto");
                                }
                                else if(r==20){
                                    alertify.error("Debe realizar una modificación");
                                }
                                else {
                                    alertify.error("Fallo el server, comuniquese con soporte");
                                   
                                }
                            }
                        });
                    } }
                    , function(){ alertify.error('No se han guardado los cambios')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
                        lastX = window.scrollX;
                        lastY = window.scrollY;
                    },
                        'onfocus':function(){
                        window.scrollTo(lastX, lastY);
                    }  }).show(); 
                });
                //END BTN GUARDAR VENTA
                                                                                
                $('.selectdistrito').select2({
                    placeholder: 'Seleccione Distrito - Provincia',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {

                            return "Buscando..";
                        }
                    },
                    ajax: {
                        url: 'ajax/selectDistrito.php',
                        dataType: 'json',
                        delay: 250,
                        processResults: function (data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    }
                });
                                                                                
                $('.cbxtecnico').select2({
                    placeholder: 'Seleccione',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {
    
                            return "Buscando..";
                        }
                    }
                });

                $('.selectgestor').select2({
                    placeholder: 'Seleccione Gestor',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {
    
                            return "Buscando..";
                        }
                    },
                    ajax: {
                        url: 'ajax/selectGestor.php',
                        dataType: 'json',
                        delay: 250,
                        processResults: function (data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    }
                });
                $('.selecttipodireccion').select2({
                  placeholder: 'Seleccione Tipo Dirección',
                  selectOnClose: true,
                  minimumInputLength: 2,
                  language: {
                            errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {
                            return "Buscando..";
                        },
                        inputTooShort: function() {
                            return "Escribir minimo 2 caracteres";
                        }                    
                    },              
                })                 

                $('#datemask').inputmask('dd/mm/yyyy', {'placeholder': 'dd/mm/yyyy'});
                                                               
                $('#lblfecharecpciondoc').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                
                $('#lblfechafacturacion').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                //Money Euro
                $('[data-mask]').inputmask();
                //Date picker
                $('#fechainst').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                //Date picker
                $('#horainst').timepicker({
                    defaultTime:false,                                                                                    
                    showInputs: true,
                    minuteStep: 1
                });
                $('#mesano').datepicker({
                    autoclose: true,
                    language: 'en',
                    firstDay: 1, format: 'M-yyyy',
                    viewMode: "years",
                    minViewMode: "months"
    
                });
                $('#lblmesvisit').datepicker({
                    autoclose: true,
                    language: 'en',
                    firstDay: 1, format: 'M-yyyy',
                    viewMode: "years",
                    minViewMode: "months",
                    orientation: 'bottom',
                    todayBtn: 'linked',
                    todayHighlight:true
                });

                $('#lblfvencimiento').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1,
                    format: 'dd/mm/yyyy'
                });

                $('#lblfvencimientob').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1,
                    format: 'dd/mm/yyyy',
                    startDate: $("#fVencimientoVista").val()
                }).on('changeDate', function (selected) {
                    var minDate = new Date(selected.date.valueOf()); // agregar 5 días 
                    $('#lblfvencimiento').datepicker('setStartDate', minDate); // bloquea de la fecha inicial
                    $('#lblfvencimiento').datepicker('setDate', minDate); // mostrar fecha
                });
            
                $('#lblfvisita').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                }).on('changeDate', function (selected) {
                    var minDate = new Date(selected.date.valueOf() + (1000 * 60 * 60 * 24 * 5)); // agregar 5 días 
                    $('#lblfvencimiento').datepicker('setStartDate', minDate); // bloquea de la fecha inicial
                    $('#lblfvencimiento').datepicker('setDate', minDate); // mostrar fecha
                    $('#lblfvencimientob').datepicker('setStartDate', minDate);
                    $('#lblfvencimientob').datepicker('setDate', minDate);
                });

                $('#lblhvisita').timepicker({
                    defaultTime:false,                                                                                    
                    showInputs: true,
                    minuteStep: 1
                });
                                                                              
                $('#lblFVisitaReal').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1
                });

               $('#logcambios').click(function () {
                    refresh();
                });
                
                 $('#lognumero').on("click", function () {
            
                var numero=$("#lblmovil").val();
                $("#spanNumero").text(numero);
                $('#modal-numero').modal('show');
                if(numero==""){
                    alertify.warning("Número Vacio");
                    $("#lblmovil").focus();
                } else {
                    refreshBUSCAR();
                }
            });        

 var refreshBUSCAR = function () {
                 var numero=$("#lblmovil").val();
                 $.ajax({
                     url: 'ajax/findDataxNumero.php?numero=' + numero,
                     success: function (data) {
                         if (data == 1) {
                             var gridDiv = document.querySelector('#myGrid3');
                             agGrid.simpleHttpRequest({url: 'ajax/selectListarXNumero.php?numero=' + numero}).then(function (data) {
                                 gridOptionsBUSCAR.api.setRowData(data);
                             });
                             /*$('#vistaboy9').height(function (index, height) {
                                 return $(window).height() * 35 / 100;
                             });*/
                             $("#ningunresultadoNumero").hide("fast");
                             $("#btnsiguiente").show("fast");
                             $('#myGrid3').show(200);
                              $('#tot').show(200);
                         } else {
                             $('#ningunresultadoNumero').show(200);
                             $("#ningunresultadoNumero").html(data);
                             $("#btnsiguiente").show("fast");
                             $('#myGrid3').hide("fast");
                             $('#tot').hide("fast");
                         }
                     }
                 });
               }

                                        
                $('#ModEnviar').on('click', function(){
                    //textbox = document.getElementById('textbox');
                    var idVen = $("#idVenta").val();
                    var Nprospecto=$('#lblnprospecto').val();
    
                    //Algunas variables por default de alertify
                    alertify.defaults.theme.ok = "btn btn-nuevo";
                    alertify.defaults.theme.cancel = "btn btn-danger";
                    var lastX,lastY;
                    alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea descargar el archivo de envio?', function(){
                            // Primero validará el formulario.
                            var datos = {idVen:idVen};
                            console.log(datos);
                            $.ajax({
                               type: 'POST',
                               url: 'ajax/correoenviovisita.php',
                               data: datos,
                               success: function (r) {
                                   console.log(r);
                                   
                                   var link = document.getElementById('downloadlink');
                                    link.href = makeTextFile(r);
                                    //link.style.display = 'block';
    
                                    download("correo_"+Nprospecto+".eml", makeTextFile(r));
    
                               }
                            });
                    }, function(){ alertify.error('Se ha cancelado el envio de correo')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
                        lastX = window.scrollX;
                        lastY = window.scrollY;
                    },
                    'onfocus':function(){
                        window.scrollTo(lastX, lastY);
                    }  }).show();
                })                                        
                                        
            });
                                                                            
            var  bloquear = function (condiciones){
                                                                           
                $('#tinviable').hide();
                $('#lblinviable').hide();
                $('#lblinviable').disabled=true;
                $('#tinviableespacio').hide();
                        
                $('#tcancelado').hide();
                $('#lblcancelado').hide();
                $('#lblcancelado').disabled=true;
                $('#tcanceladoespacio').hide();
                                                      
                if (condiciones == "Inviable") {
                    $('#tinviable').show();
                    $('#lblinviable').show();
                    $('#lblinviable').show();
                    $('#lblinviable').disabled=false;
                    $('#tinviableespacio').show();
                }else if(condiciones=="Cancelado"){
                    $('#tcancelado').show();
                    $('#lblcancelado').show();
                    $('#lblcancelado').disabled=false;
                    $('#tcanceladoespacio').show();
                } 
                else {
                    $('#tinviable').hide();
                    $('#lblinviable').hide();
                    $('#lblinviable').disabled=true;
                    $('#tinviableespacio').hide();
                    
                    $('#tcancelado').hide();
                    $('#lblcancelado').hide();
                    $('#lblcancelado').disabled=true;
                    $('#tcanceladoespacio').hide();
                   
                }
    
            }

            function validaForm() {

            if ($("#frmEditarVenta #lblmatricula").val() == "" && $("#lblcat").val() != "Anulada") {
                alert($("#lblcat").val());
                alertify.warning("Por favor ingresar la Matricula correspondiente");
                $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            if ($("#frmEditarVenta #lblnombcomercial").val() == "" && $("#lblcat").val() != "Anulada") {
                alertify.warning("Por favor ingresar la Matricula valida");
                $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            if ($("#frmEditarVenta #lbldc").val() == "" || $("#frmEditarVenta #lbldc").val() == "Seleccione" && $("#lblcat").val() != "Anulada") {
                alertify.warning("Por favor ingresar CC correcto");
                $("#frmEditarVenta #lbldc").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            if ($("#frmEditarVenta #lbljefeventa").val() == "" || $("#frmEditarVenta #lbljefeventa").val() == "No se encontraron resultado" && $("#lblcat").val() != "Anulada") {
                alertify.warning("Por favor revisar Jefe de Estructura Comercial");
                $("#frmEditarVenta #lbljefeventa").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            if ($("#frmEditarVenta #lblestadovisita").val() == "Seleccione" || $("#frmEditarVenta #lblestadovisita").val() == "") {
                alertify.warning("Por favor ingresar Estado de Visita correcto");
                $("#frmEditarVenta #lblestadovisita").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblestadoventa").val() == "Seleccione" || $("#frmEditarVenta #lblestadoventa").val() == "") {
                alertify.warning("Por favor ingresar Estado de Venta correcto");
                $("#frmEditarVenta #lblestadoventa").focus();
                return false;
            }
            if ($("#frmEditarVenta #lbltipoventa").val() == "Seleccione") {
                alertify.warning("Por favor ingresar Recurso correcto");
                $("#frmEditarVenta #lbltipoventa").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblsegmento").val() == "Seleccione") {
                alertify.warning("Por favor ingresar Segmento correcto");
                $("#frmEditarVenta #lblsegmento").focus();
                return false;
            }

            if($("#frmEditarVenta #lblsegmento").val() == 'RES'){
                if($("#frmEditarVenta #lbltiposegmento").val() == '' || $("#frmEditarVenta #lbltiposegmento").val() == null || $("#frmEditarVenta #lbltiposegmento").val() == 'Seleccione'){
                    Swal.fire('Faltan datos', 'Por favor ingresar tipo residencial correcto', 'warning');
                    return false;
                    }

                if($("#frmEditarVenta #lblnpiso").val() == '' || $("#frmEditarVenta #lblnpiso").val() == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar N°Piso correcto', 'warning');
                    return false;
                } 
                    
            }
                
            
            
            if ($("#frmEditarVenta #lblnprospecto").val() == "" && $("#lblcat").val() != "Anulada") {
                alertify.warning("Por favor ingresar N° Prospecto");
                $("#frmEditarVenta #lblnprospecto").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblfvencimiento").val() == "") {
                alertify.warning("Por favor ingresar Fecha de Vencimiento");
                $("#frmEditarVenta #lblfvencimiento").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblorigen").val() == "") {
                alertify.warning("Por favor ingresar Origen");
                $("#frmEditarVenta #lblorigen").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblfvisita").val() == "") {
                alertify.warning("Por favor ingresar Fecha de Visita");
                $("#frmEditarVenta #lblfvisita").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblhvisita").val() == "") {
                alertify.warning("Por favor ingresar Hora de Visita");
                $("#frmEditarVenta #lblhvisita").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblnombcliente").val() == "") {
                alertify.warning("Por favor ingresar Nombre del Cliente");
                $("#frmEditarVenta #lblnombcliente").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblcorreo").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#frmEditarVenta #lblcorreo").val())) {
                alertify.warning("Por favor ingresar correo válido");
                $("#frmEditarVenta #lblcorreo").focus();
                return false;
            }
            //NUEVA FUNCION SI SELECCIONA DNI/RUC
            if ($("#frmEditarVenta #lbltipodoc").val() == "") {
               alertify.warning("Por favor Seleccionar Tipo Documento");
               $("#frmEditarVenta #lbltipodoc").focus();
               return false;
            }
            if ($("#frmEditarVenta #lbldocumento").val() == "") {
               alertify.warning("Por favor ingresar Documento");
               $("#frmEditarVenta #lbldocumento").focus();
               return false;
            }    
            if ($("#frmEditarVenta #lbltipodoc").val() == "RUC") {
                if ($("#frmEditarVenta #lbldocumento").val().length!=11) {
                   alertify.warning("Por favor ingresar los 11 digitos del RUC");
                   $("#frmEditarVenta #lbldocumento").focus();
                   return false;
                }
                if ($("#frmEditarVenta #lbldocumento").val().substr(0,2)==10 || $("#frmEditarVenta #lbldocumento").val().substr(0,2)==20 || $("#frmEditarVenta #lbldocumento").val().substr(0,2)==15) {
                }else{
                    alertify.warning("Por favor ingresar correctamente el RUC debe comenzar 10 o 20");
                   $("#frmEditarVenta #lbldocumento").focus();
                   return false;
                }
            }
            if ($("#frmEditarVenta #lbltipodoc").val() == "DNI") {
                if ($("#frmEditarVenta #lbldocumento").val().length!=8) {
                   alertify.warning("Por favor ingresar los 8 digitos del DNI");
                   $("#frmEditarVenta #lbldocumento").focus();
                   return false;
                }
            }                        
            if ($("#frmEditarVenta #lbltipodoc").val() == "CE") {
                if ($("#frmEditarVenta #lbldocumento").val().length==0) {
                   alertify.warning("Por favor ingresar CE");
                   $("#frmEditarVenta #lbldocumento").focus();
                   return false;
                }
            }                                     
            if ($("#frmEditarVenta #lbldireccion").val() == "") {
                alertify.warning("Por favor ingresar la Direccion del Cliente");
                $("#frmEditarVenta #lbldireccion").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblmesvisit").val() == "") {
                alertify.warning("Por favor ingresar Mes-Visita");
                $("#frmEditarVenta #lblmesvisit").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblasignado").val() == "") {
                alertify.warning("Por favor ingresar Gestor correcto");

                $("#frmEditarVenta #lblasignado").select2('open');
                return false;
            }
            if ($("#frmEditarVenta #lbldistrito").val() == "") {
                alertify.warning("Por favor ingresar Distrito correcto");

                $("#frmEditarVenta #lbldistrito").select2('open');
                return false;
            }
            if ($("#frmEditarVenta #lblmovil").val() == "") {
                alertify.warning("Por favor ingresar Telefono, de caso contrario digite: 0");
                $("#frmEditarVenta #lblmovil").focus();
                return false;
            }
            if (!/^([0-9])*$/.test($("#frmEditarVenta #lblfijo").val()) ) {
                    alertify.warning("El valor de Teléfono Dos no es un número");
                    $("#frmEditarVenta #lblfijo").focus();
                    return false;
            }
            if ($("#frmEditarVenta #lblleadid").val() == "") {
                alertify.warning("Por favor ingresar Lead ID"); 
                $("#frmEditarVenta #lblleadid").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblcomentariovisita").val() == "") {
                alertify.warning("Por favor ingresar Comentario de Visita");
                $("#frmEditarVenta #lblcomentariovisita").focus();
                return false;
            }
            /*if ($("#frmEditarVenta #lblcontactoasignacion").val() == "") {
                alertify.warning("Por favor ingresar el contacto asignación"); 
                $("#frmEditarVenta #lblcontactoasignacion").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblcumpleranking").val() == "") {
                alertify.warning("Por favor ingresar si cumple ranking"); 
                $("#frmEditarVenta #lblcumpleranking").focus();
                return false;
            }*/     
            
            
            if ($("#frmEditarVenta #lblErrorGestion").val() != "" && $("#frmEditarVenta #lblcomentarioserrorgestion").val() == "") {
                alertify.warning("Por favor ingresar comentarios de error de gestion"); 
                $("#frmEditarVenta #lblcomentarioserrorgestion").focus();
                return false;
            }      
            
            
             if ($("#frmEditarVenta #lblestadovisita").val() == "AnuladaCC" || $("#frmEditarVenta #lblestadovisita").val() == "AnuladaTEC" || $("#frmEditarVenta #lblestadovisita").val() == "AnuladaOP"
             || $("#frmEditarVenta #lblestadovisita").val() == "AnuladaCLI" || $("#frmEditarVenta #lblestadovisita").val() == "AnuladaporCruce" || $("#frmEditarVenta #lblestadovisita").val() == "AnuladaNoImputableOper" || $("#frmEditarVenta #lblestadovisita").val() == "AnuladaTECAudio") {
                if ($("#frmEditarVenta #lblseanula").val() == "SI" && $("#frmEditarVenta #lblcomentarios").val() == "") {
                    alertify.warning("Por favor ingresar comentarios de anulaciones"); 
                    $("#frmEditarVenta #lblcomentarios").focus();
                    return false;
                }      
                
                if ($("#frmEditarVenta #lblseanula").val() == "SI" && $("#frmEditarVenta #lbldetalle").val() == "") {
                    alertify.warning("Por favor ingresar detalles de anulaciones"); 
                    $("#frmEditarVenta #lbldetalle").focus();
                    return false;
                }  
            }
            
            
  

            
            return true; 
        }

            var calcDataTableHeight = function () {
                return $(window).height() * 65 / 100;
            };

            function filterFloat(evt, input) {
                // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
                var key = window.Event ? evt.which : evt.keyCode;
                var chark = String.fromCharCode(key);
                var tempValue = input.value + chark;
                if (key >= 48 && key <= 57) {
                    if (filter(tempValue) === false) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    if (key == 8 || key == 13 || key == 0) {
                        return true;
                    } else if (key == 46) {
                        if (filter(tempValue) === false) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
            }

            function filter(__val__) {
            var preg = /^([0-9]+\.?[0-9]{0,2})$/;
            if (preg.test(__val__) === true) {
                return true;
            } else {
                return false;
            }
            
            }

        </script>
        <!-- VALIDAR LEAD ID SIN LETRAS -->
        <script>
        /*
            $('#lblleadid').blur(function(){
                var ValidaLeadId = $("#lblleadid").val();
                if (!/^([0-9])*$/.test(ValidaLeadId)){
                    alertify.warning("El Lead ID solo debe contener números");
                    $("#lblleadid").val('');
                    $("#lblleadid").focus();
                }
            });
        */    
        </script>
        <!-- SCRIPT DIRECCION -->
        <script>
            const url = "GFWIDGET-PE-v2/index.html";
            let validarObjGeofinder;
            let validarObjGeofinderDirAprox;
            
            $('#setDireccion').on('click', function(e){
                e.preventDefault();
                if ($('#lbldireccionAprox').val() === ''){
                    $('#mapgeofinder').modal('show');
                    buscarDireccionLocalStorage();
                } else {
                    
                    let tipoDireccion = $('#hidTipoDireccion').val();
                    
                    if(tipoDireccion === 'Exacta'){
                        
                        $('#mapgeofinder').modal('show');
                        
                        buscarDireccionLocalStorage();
                        
                    }
                    else if(tipoDireccion === 'Aproximada'){
                        $('#mapgeofinderDirAprox').modal('show');
                    }
                    else{
                        $('#mapgeofinder').modal('show');
                        buscarDireccionLocalStorage();
                    }
                }
            })
            
            //BOTON PARA ABRIR MODAL DE DIRECCIONES APROXIMADAS
            
            $("#mapgeofinderDirAprox").on('shown.bs.modal', function(){
                
                //$('#geofinderwidgetDirAprox').attr("src", $('#geofinderwidgetDirAprox').attr("src"));
                
                //$('.leaflet-popup-content').width('310');
                
                if(localStorage.getItem("ObjGeofinderDirAprox") === null){
                    $('#mapgeofinderDirAprox').modal('show');
                }
                
                clearInterval(validarObjGeofinder);
                validarObjGeofinderDirAprox = setInterval(() => {
                    if(localStorage.getItem("ObjGeofinderDirAprox") !== null){
                        const ObjGeofinderDirAprox = JSON.parse(localStorage.getItem("ObjGeofinderDirAprox"));
                        //LLENA EL INPUT ObjGeofinder con la información guardada
                        $('#objGeofinder').val(JSON.stringify(ObjGeofinderDirAprox));
                        //OBTIENE DIRECCION DEL CAMPO GEOFINDER Y LO LLENA EN EL INPUT
                        let direccionAprox = ObjGeofinderDirAprox.fulladdress;
                        //
                        $('#lbldireccionAprox').val(direccionAprox);
                        
                        //LIMPIA EL INTERVALO DE VALIDACION DE OBJGEOFINDER    
                        clearInterval(validarObjGeofinderDirAprox);

                        $("#setDireccionAprox").removeAttr("href");
                        
                        //ELIMINA EL LOCAL STORAGE
                        localStorage.removeItem("ObjGeofinderDirAprox");
                        
                        //OCULTAR EL MODAL
                         $('#mapgeofinderDirAprox').modal('hide');
                    } 
                }, 2000);
            });
            
            $("#mapgeofinderDirAprox").on('hidden.bs.modal', function(){
                clearInterval(validarObjGeofinder);
            })
            
            $('#mapgeofinder').on('hidden.bs.modal', function(){
                clearInterval(validarObjGeofinder);
            })
        </script>
        <!-- BTN DIRECCION MANUAL-->
        <script>
            $('#btnDireccionManual').click(function(){
                Swal.fire({
                    title: '¿Estás seguro?',
                    text: "La dirección se registrará manualmente",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Si, manual'
                }).then((result) => {
                    if (result.isConfirmed) {
                        Swal.fire({
                            title: 'Ingrese la dirección del cliente:',
                            input: 'text',
                            showCancelButton: true,
                            confirmButtonText: 'Confirmar',
                            preConfirm: (direccion) => {
                                $('#lbldireccion').val(direccion);
                                $('#mapgeofinder').modal('hide');
                            }
                        })
                    }
                } ) //END RESULT
            });//END FUNCTION
        </script>
        <!-- DESCARGAR ARCHIVO PARA ENVIO CORREO -->
        <script>
            var textFile = null,
            makeTextFile = function (text) {
              var data = new Blob([text], {type: 'text/plain'});
              if (textFile !== null) {
                window.URL.revokeObjectURL(textFile);
              }
              textFile = window.URL.createObjectURL(data);
              return textFile;
            };

            var create = document.getElementById('create'),
            textbox = document.getElementById('textbox');
            /*
              create.addEventListener('click', function () {

              }, false);
              */

              function download(nombre, url) {
                  var link= document.createElement('a');
                  link.setAttribute('href', url);
                  link.setAttribute('download', nombre);
                  link.click();
              }
        </script> 
        <!-- SCRIPT FUNCIONES DIRECCIONES NUEVA -->
        <script>
            function buscarDireccionLocalStorage(){
                if(localStorage.getItem("ObjGeofinder") === null){
                    $('#mapgeofinder').modal('show'); 
                } 
                    
                validarObjGeofinder = setInterval(() => {
                    
                    console.log('Buscando ObjGeofinder');
                    
                    //VERIFICA QUE EL OBJGEOFINDER EXISTE EN EL LOCAL STORAGE
                    if(localStorage.getItem("ObjGeofinder") !== null){
                        const ObjGeofinder = JSON.parse(localStorage.getItem("ObjGeofinder"));
                        //LLENA EL INPUT ObjGeofinder con la información guardada
                        $('#objGeofinder').val(JSON.stringify(ObjGeofinder));
                        //OBTIENE DIRECCION DEL CAMPO GEOFINDER Y LO LLENA EN EL INPUT
                        let direccion = ObjGeofinder.fulladdress;
                        $('#lbldireccionAprox').val(direccion);
                        
                        //LIMPIA EL INTERVALO DE VALIDACION DE OBJGEOFINDER    
                        clearInterval(validarObjGeofinder);

                        $("#setDireccion").removeAttr("href");
                        
                        //ELIMINA EL LOCAL STORAGE
                        localStorage.removeItem("ObjGeofinder");
                        
                        //LIMPIA EL 
                         $('#mapgeofinder').modal('hide');
                    } 
                }, 2000);
                
            }
            
            function marcarUbicacionMapa(){
                let objGeofinder = $('#objGeofinder').val();
                let lbltipoDireccion = $('#lbltipoDireccion').val();
                
                if(objGeofinder){
                    
                    if(lbltipoDireccion === 'Exacta'){
                        $('#geofinderwidget').attr("src", $('#geofinderwidget').attr("src"))
                        localStorage.setItem('PosicionObjExacta', objGeofinder);
                        localStorage.setItem('PosicionObjAprox', '{}');
                    } else {
                        $('#geofinderwidgetDirAprox').attr("src", $('#geofinderwidgetDirAprox').attr("src"))
                        localStorage.setItem('PosicionObjExacta', '{}');
                        localStorage.setItem('PosicionObjAprox', objGeofinder);
                    }
                }
            }
            
            const map = L.map('map')
            
            $('#modal-checkin').on('shown.bs.modal', function(){
                
                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                    attribution: 'Map data &copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, Imagery © <a href="https://www.mapbox.com/">Mapbox</a>'
                }).addTo(map);
                
                let objGeofinder = $('#objGeofinder').val();
                let objCheckIn = $('#info_checkin').val();
                console.log(objGeofinder);
                console.log(objCheckIn);
                
                if(objGeofinder !== ''){
                    objGeofinder= JSON.parse(objGeofinder);
                    //Datos de la direccion georeferenciada
                    
                    const latitudCliente = objGeofinder.y;
                    const longitudCliente = objGeofinder.x;
                    
                    map.setView(new L.LatLng(latitudCliente, longitudCliente), 14);
                    
                    L.marker([latitudCliente,longitudCliente], {icon: L.AwesomeMarkers.icon({icon: 'home', prefix: 'fa', markerColor: 'green'}) }).addTo(map)
                    .bindPopup('Ubicación de cliente.<br>')
                    .openPopup();
                } else {
                    map.setView(new L.LatLng(-77.0311, 77), 14);
                }
                
                if(objCheckIn !== ''){
                    objCheckIn= JSON.parse(objCheckIn);
                    
                    const latitudComercial = objCheckIn.Latitud;
                    const longitudComercial = objCheckIn.Longitud;
                    
                    //const latitudReubicacion = objCheckIn.latitudReubicacion;
                    //const longitudReubicacion = objCheckIn.longitudReubicacion;

                        L.marker([latitudComercial, longitudComercial], {icon: L.AwesomeMarkers.icon({icon: 'user', prefix: 'fa', markerColor: 'blue'})})
                            .addTo(map).bindPopup('Check-In Comercial')
                            .openPopup();
                    /*
                    if(latitudReubicacion != '' || longitudReubicacion!=''){
                        L.marker([latitudReubicacion, longitudReubicacion], {icon: L.AwesomeMarkers.icon({icon: 'home', prefix: 'fa', markerColor: 'black'})})
                            .addTo(map).bindPopup('Reubicación del cliente')
                            .openPopup();
                    }
                    */
                } else {
                    Swal.fire(
                      'Check-IN RE!',
                      'Pendiente enviar check-in por el especialista',
                      'warning'
                    )
                }
                    
                
            })
            
            $('#btnGuardarCheckIn').on('click', () => {
                $('#hidden_checki').val('SI');
                
                $('#checki').bootstrapToggle('on');
                $('#modal-checkin').modal('hide')

            })
            
            $('#btnPreviewSC').on('click', () => {
               var idventa=$("#idVenta").val();
               $('#iframeSC').attr('src','plantilla_securty_check_apertura.php?IdVenta='+idventa+'&rc=1');
               $('#modal-previewsc').modal('show');

            })

            $('#btnPreviewSC-R').on('click', () => {
               var idventa=$("#idVenta").val();
               $('#iframeSC').attr('src','plantilla_securty_check_reasignacion.php?IdVenta='+idventa+'&rc=1');
               $('#modal-previewsc').modal('show');

            })            
            
            
            $('.irwhatsapp_telefonouno').on('click', () => {
               var lblmovil=$("#lblmovil").val();
               
               window.open("https://wa.me/"+lblmovil, '_blank');
            })            
            
            $('#btnvisitarelacionada').on('click', () => {
                var idVenta=$("#idVenta").val();
                window.open("https://www.verismart.com.pe/verismart/editarvisita_v5.php?idventa="+idVenta+"&visitarelacionada=SI", '_blank');
            })
            
                $('#btnGenerarvisitarelacionada').click(function () {
                                                                                  
                    var catgventa=$('#lblcat').val();
                    var ediventa=$("#idVenta").val();
                    //Algunas variables por default de alertify
                    alertify.defaults.theme.ok = "btn btn-nuevo";
                    alertify.defaults.theme.cancel = "btn btn-danger";
                    var lastX,lastY;
                        alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function(){ 
                            
                    if (validaForm()) {
                        // Primero validará el formulario.
                       // var datos = $('#frmEditarVenta').serialize();
                        
                        //var datos = $('#frmEditarVenta').serialize();
                       
                        var formData = $('#frmEditarVenta').serialize().replace(/\+/g, '%20').split('&');
       
                        
                        var dataArray = {array:'array1',lblcategoria:catgventa,lblidventa:ediventa};
                        
                        for (var i = 0; i < formData.length; i++) {
                            var keyValue = formData[i].split('=');
                            
                            var key = decodeURIComponent(keyValue[0]);
                            var value = decodeURIComponent(keyValue[1]);
                            dataArray[key] = value;
                        }        
                        

                        $.ajax({
                                    type: 'POST',
                                    url: './Controller/ControllerVisita.php',
    	                            data: {function: JSON.stringify(dataArray)},
                                    dataType: "Json",
                                    success: function(data) {
                                        console.log(data);
                                        if (data.respuesta == 'exito') {
                                            Swal.fire({
                                              title:'Registro con exito!',
                                              text:'La Visita Relacionado N° '+dataArray.lblnprospecto,
                                              icon:'success',
                                              showCancelButton:false,
                                              confirmButtonColor:'',
                                              confirmButtonText:'OK',
                                              closeOnConfirm: false,
                                              allowOutsideClick: false
                                            }).then((result)=>{
                                                if(result.isConfirmed){
                                                    location.href = 'editarvisita_v5.php?idventa='+data.id;
                                                }
                                            });
                                        } else if (data.respuesta == 'error') {
                                            alertify.warning(data.detalle);
    
                                        } else {
                                            alertify.error("Fallo el server");
    
                                        }
                                    }
                                });                       
                       
                       
                        // $.ajax({
                        //     type: 'POST',
                        //     url: 'ajax/updateVisita_v4.php',
                        //     data: "lblcategoria=" + catgventa + "&lblidventa="+ediventa+"&" + datos,
                        //     success: function (r) { console.log(r);
                        //         if (r == 1) {
                        //              alertify.success("Modificado con exito");
                                
                        //         }else if(r==2){
                        //             alertify.warning("Ya existe N° prospecto");
                        //         }
                        //         else if(r==20){
                        //             alertify.error("Debe realizar una modificación");
                        //         }
                        //         else {
                        //             alertify.error("Fallo el server, comuniquese con soporte");
                                   
                        //         }
                        //     }
                        // });
                   }
                            
                        }
                    , function(){ alertify.error('No se han guardado los cambios')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
                        lastX = window.scrollX;
                        lastY = window.scrollY;
                    },
                        'onfocus':function(){
                        window.scrollTo(lastX, lastY);
                    }  }).show(); 
                });            
            
   

        </script>
    </body>
</html>