<?php
    
    //ARCHIVO CARGADO EL 31 DE ENERO DEL 2020, CONTIENE LOS CAMBIOS HECHOS PARA EL PERFIL SUPERVISOR.
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
    	exit;
    }
    
    date_default_timezone_set('America/Lima');
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date)
    {
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date)
    {
        return date('Y-m-d', strtotime($date));
    }
    
    include 'config/db.php';
    include 'config/conexion.php';
    require (__DIR__) . '/helper/helper_validacion.php';
    
    $fechames=date("M-Y");
    
    $perfilUsuario = $_SESSION['id_perfil'];

    if(isset($_GET['idcliente']) && empty($_GET['idcliente'])){
        $tipocanal = sanitizaCampo($_GET['tipocanal'], 'sanitizeint|scapestring|htmlspecialchars', $con);
        $tipocanal = htmlspecialchars($tipocanal);
        
        $numcliente = sanitizaCampo($_GET['numcliente'], 'sanitizeint|scapestring|htmlspecialchars', $con);
        $numcliente = htmlspecialchars($numcliente);
        
        $titulo = "REGISTAR RETENCIÓN -".$numcliente;
        $titulo = htmlspecialchars($titulo);
        
        $condicion = "RegistrarCliente";
        $IdCliente = "";
        $NCliente = $numcliente;
        $IdGeografico = "";
        $Distrito = "";
        $Provincia = "";
        $htmldistrito = '<option value="">Seleccione</option>';
        $NombApellido = "";
        $Telefonouno = "";
        $Telefonodos = "";
        $Telefonotres = "";
        $Telefonocuatro = "";
        $Correo = "";
        $Direccion = "";
        $Correodos = "";
        $Correotres = "";
        $Correocuatro = "";
        $Segmento = "";
        
        $nombacceso = $_SESSION['NombreAcceso'];
        if($nombacceso == "GestorRetencion") {
            $Gestor = $_SESSION['matriculausuario'];
            $NombreGestor = $_SESSION["nombusuario"];
            $htmlGestor = '<option value="'.$Gestor.'" selected>'.$Gestor.' - '.$NombreGestor.'</option>';
        } else {
            $htmlGestor='<option value="" selected>Seleccione</option>';
        }
    
        $MotivoAviso = "";
        $FechaCierre = "";
        $MotivoCierre = "";
        $DuracionOferta = "";
        $Reincidente = "NO";
        $TipoCierre = "";      
        $EstadoFinGestion = "";
        $MotivoCierreTC = "";
        $Competencia = "";
    
    } else if(isset($_GET['idretencion'])) {
    
        $condicion = "ClienteAmpliado";
        $idretencion = sanitizaCampo($_GET['idretencion'], 'sanitizeint|scapestring|htmlspecialchars', $con);
        $idretencion = htmlspecialchars($idretencion);
        $titulo = "EDITAR RETENCIÓN - N°".$idretencion;
        
        /* CONSULTA PREPARADA N°21 */
        $queryRetencion = "SELECT
        C.IdCliente,
        C.IdGeografico,
        G.Distrito,
        G.Provincia,
        C.NombApellido,
        C.Telefonouno,
        C.Telefonodos,
        C.Telefonotres,
        C.Telefonocuatro,
        C.Correo,
        C.Direccion,
        C.NCliente,
        C.Correodos,
        C.correotres,
        C.correocuatro,
        C.Segmento,
        R.MotivoAviso,
        R.Gestor,
        CONCAT(ges.Nombres,' ',ges.Apellidos) NomGestor,
        R.FechaCierre,
        R.TipoCierre,
        R.MotivoCierre,
        R.EstadoFinGestion,
        R.TipoCanal,
        R.DuracionOferta,
        R.Reincidente,
        R.MotivoCierreTC,
        R.Competencia
        FROM
        tblretencion R INNER JOIN tblcliente C on R.IdCliente = C.IdCliente
        INNER JOIN tblgeografico G on C.IdGeografico = G.IdGeografico
        LEFT JOIN dbUSUARIO.tblusuario ges on ges.Matricula=R.Gestor
        WHERE R.IdRetencion=?";
        
    	try{       
            $stmt = $con->prepare($queryRetencion);
            $stmt->bind_param('i', $idretencion);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($IdCliente, $IdGeografico, $Distrito, $Provincia, $NombApellido, $Telefonouno, $Telefonodos, $Telefonotres, $Telefonocuatro, $Correo, $Direccion, $NCliente, $Correodos, $Correotres, $Correocuatro, 
            $Segmento, $MotivoAviso, $Gestor, $NombreGestor, $FechaCierre, $TipoCierre, $MotivoCierre, $EstadoFinGestion, $tipocanal, $DuracionOferta, $Reincidente, $MotivoCierreTC, $Competencia);
            $stmt->fetch();

            $htmlGestor='<option value="'.$Gestor.'">'.$Gestor.' - '.$NombreGestor.'</option>'; 
            if (empty($FechaCierre) || $FechaCierre == ''){
                $FechaCierre = '';
            } else {
                $FechaCierre = format_date_dd_mm_Y($FechaCierre);
            }
            
            $stmt->close();
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }        
    } else if(isset($_GET['idcliente']) && !empty($_GET['idcliente'])) {
    
        $tipocanal = sanitizaCampo($_GET['tipocanal'], 'sanitizestring|scapestring|htmlspecialchars', $con);
        $tipocanal = htmlspecialchars($tipocanal);
        $idcliente = sanitizaCampo($_GET['idcliente'], 'sanitizeint|scapestring|htmlspecialchars', $con);
        $idcliente = htmlspecialchars($idcliente);
        $condicion = "ClienteRegistrado";
        
        /* CONSULTA PREPARADA N°22 */
        $queryCliente = "SELECT
        c.IdCliente,
        c.NCliente,
        c.NombApellido,
        c.Direccion,
        c.Telefonouno,
        c.Telefonodos,
        c.Telefonotres,
        c.Telefonocuatro,
        g.Distrito,
        g.Provincia,
        c.Segmento,
        c.Correo,
        c.Correodos,
        c.correotres,
        c.correocuatro,
        c.IdGeografico
        FROM dbVENTAS.tblcliente c
        INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
        WHERE c.IdCliente=?";    	
        
        try{       
            $stmt = $con->prepare($queryCliente);
            $stmt->bind_param('i', $idcliente);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($IdCliente, $NCliente, $NombApellido, $Direccion, $Telefonouno, $Telefonodos, $Telefonotres, $Telefonocuatro, $Distrito, $Provincia, $Segmento, $Correo, $Correodos, $Correotres, $Correocuatro, $IdGeografico);
            $stmt->fetch();
            
            $htmldistrito='<option value="'.$IdGeografico.'">'.utf8_encode($Distrito).' - '.$Provincia.'</option>';
            
            $stmt->close();
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }
        
        $nombacceso = $_SESSION['NombreAcceso'];
        if($nombacceso == "GestorRetencion"){
            $Gestor = $_SESSION['matriculausuario'];
            $NombreGestor = $_SESSION["nombusuario"];
            $htmlGestor = '<option value="'.$Gestor.'" selected>'.$Gestor.' - '.$NombreGestor.'</option>';
        } else {
            $htmlGestor='<option value="" selected>Seleccione</option>';
        }
        
        $titulo = "REGISTAR RETENCIÓN -".$NCliente;
        $MotivoAviso = "";
        $FechaCierre = "";
        $MotivoCierre = "";
        $DuracionOferta = "";
        $Reincidente = "NO";
        $TipoCierre = '';      
        $EstadoFinGestion = "";
        $MotivoCierreTC = "";
        $Competencia = "";
    }
?>

<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge">

        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
       <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <!-- DataTables -->
        <link rel="stylesheet" href="admin/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
        <!-- bootstrap-toggle -->
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>


        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">

        <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css"/>
        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>

        <style>

            .tbinput {
                background: none!important;
                border: none;
                -webkit-appearance: none;
            }

            .classMantenimiento, .ClsLlamada, .clsInfoCTz, .clsNInt, .clsNIntMot, .clsNProc{
                display: none;
            }

            .ocultar {
                display: none;
            }

            .selected{
                background-color: #e0e0e0;
            }

            .subtitulo{
                text-decoration: underline;
                font-weight: bold;
            }

            label{
                font-weight: normal;
                font-size: 12px;
                text-align: left!important;
            }

            .botonTabla{
                background:none;
                border:none;
                display: none;
            }

            .swal2-popup{
                font-size: 1.5rem!important;
            }

            .swal2-styled.swal2-confirm{
                background-color: #e4002b!important;
            }

            .bordeRojo{
                border: 1px solid #e4002b;
            }

            .obligatorio{
                display: none;
                color: red;
            }

            .derecha{
                text-align: right;
            }

            #tinviable, #tinviableespacio, #tcanceladoespacio, #tcancelado{
                display: none;
            }

            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;
            }


            .preloader{
                background-color:#FFF;
                width: 100%;
                height: 100%;
                position: absolute;
                z-index: 1;
            }

            .dataTables_wrapper .myfilter .dataTables_filter{float:left}
            .dataTables_wrapper .mylength .dataTables_length{float:right}
            div.dataTables_scrollBody thead th {
                vertical-align: top;
            }
            td {
                max-width: 250px;
                overflow: hidden;
                white-space: nowrap;
                text-overflow: ellipsis;

            }
            .espacio{
                height:10px;
            }

           .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #frmEditarVenta .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }
            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo {
                color: #FFFFFF;
                background-color: #444444;
                border-color: #444444;
            }

            .btn-nuevo:hover,
            .btn-nuevo:focus,
            .btn-nuevo:active,
            .btn-nuevo.active,
            .open .dropdown-toggle.btn-nuevo {
                color: #FFFFFF;
                background-color: #616161;
                border-color: #444444;
            }

            .btn-nuevo:active,
            .btn-nuevo.active,
            .open .dropdown-toggle.btn-nuevo {
                background-image: none;
            }

            .btn-nuevo.disabled,
            .btn-nuevo[disabled],
            fieldset[disabled] .btn-nuevo,
            .btn-nuevo.disabled:hover,
            .btn-nuevo[disabled]:hover,
            fieldset[disabled] .btn-nuevo:hover,
            .btn-nuevo.disabled:focus,
            .btn-nuevo[disabled]:focus,
            fieldset[disabled] .btn-nuevo:focus,
            .btn-nuevo.disabled:active,
            .btn-nuevo[disabled]:active,
            fieldset[disabled] .btn-nuevo:active,
            .btn-nuevo.disabled.active,
            .btn-nuevo[disabled].active,
            fieldset[disabled] .btn-nuevo.active {
                background-color: #444444;
                border-color: #444444;
            }

        </style>

        <style>
            .main-header,.main-sidebar,.left-side{
                position:fixed
            }
            
            .main-header {
                top: 0;
                right: 0;
                left: 0
            }
            
            .content-wrapper,
            .right-side {
                padding-top: 50px
            }
            
            @media (max-width:767px) {
                 .content-wrapper,
                 .right-side {
                    padding-top: 100px
                }
            }
            
            .layout-boxed .wrapper {
                max-width: 100%
            }
            
            .wrapper {
                overflow: hidden
            }
            
            .control-sidebar {
                position: fixed;
                height: 100%;
                overflow-y: auto;
                padding-bottom: 50px
            }
        </style>

        <style>
            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                   -moz-border-radius: 5px;
                        border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                   -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            
                    z-index: 1051 !important;
            
            }
            
            hr {
              height: 4px;
              width: 100%;
              background-color: #ecf0f5;
            
            }

            hr {
                /* margin-top: 20px; */
                margin-bottom: 20px;
                border: 0;
                /* border-top: 1px solid #eee; */
            }
            
            hr {
                display: block;
                unicode-bidi: isolate;
                -webkit-margin-before: 0.5em;
                -webkit-margin-after: 0.5em;
                -webkit-margin-start: auto;
                -webkit-margin-end: auto;
                overflow: hidden;
                border-style: inset;
            
            }

            .box.box-custom {
                border-top-color: #ffffff;
            }
            
            .box {
                position: relative;
                border-radius: 3px;
                background: #ffffff;
                border-top: 3px solid #d2d6de;
                margin-bottom: 5px;
                width: 100%;
                box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            }

        </style>
                
        <style>
            .btn-blanco {
              background-color: white;
            }
    
            .btn-blanco{
              border: none;
            }
    
            .btn-blanco i{
              color: #E4002B;
            }
    
            .blanco-sinborde{
              background: white!important;
              border: none;
            }
            
            .info-tec label{
                text-align:left; 
                padding: 8px 15px;    
            }
            
            .info-tec button{
                padding: 4px 10px; 
                font-size: 16px;    
            }
            
            .info-tec p{
                padding: 4px 10px; 
                font-size: 16px; 
                font-weight: 600;
                display: inline-block;
            }
            
            
            .texto-derecha{
                text-align: right;
            }
    
        </style>
        
        <style>
            .red{
                color: #E4002B;
            }
            .green{
                color: green;
            }
            .orange{
                color: orange;
            }
            select + span.select2:focus, select + span.select2 *:focus { 	outline-color: #7d3c8c; 	outline-width: 1px; }
            .select2-container--default.select2-container--focus, .select2-selection.select2-container--focus, .select2-container--default:focus, .select2-selection:focus, .select2-container--default:active, .select2-selection:active {
                outline: none;
                border: 1px solid #3c8dbc;
                border-radius: 4px;
            }             
        </style>

    </head>

    <body class="sidebar-collapse skin-red sidebar-mini">

         <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php
            $configamp="active";
            $retencion="active";
            include 'admin/main-sidebar.php';
            ?>

            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        Retenciones
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Editar Retención</li>
                    </ol>
                </section>
                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-md-2"></div>
                        <div class="col-md-8">
                            <div class="box box-danger">
                                <div class="box-header">
                                    <table  style="width:90%;">
                                        <tr>
                                            <td style="width: 7%;">

                                                <h3 class="box-title cattitle"><?php echo $titulo;?></h3>
                                            </td>
                                        </tr>
                                    </table>
                                    <div class="box-tools pull-right">
                                        <a class="btn btn-nuevo btn-sm" id="btnguardar" name="btnguardar"><i class="fa fa-save"></i></a>
                                        <a href="retencion.php" class="btn btn-danger btn-sm" ><i class="fa fa-reply"></i> </a>
                                    </div>
                                </div>
                                <div class="espacio"></div>
                            </div>

                            <div id="frmEditarVenta" method="post">
                                <input type="hidden" id="idretencion" value="<?php echo $idretencion; ?>">
                                <input type="hidden" id="lblpermiso" value="<?php echo $nombacceso; ?>">
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                        <h5>INFORMACION DE LA RETENCIÓN</h5>
                                        <div class="box-tools pull-aca right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="box-body">
<div class="form-horizontal">

                                            <div>
                                                <h5 class="subtitulo">DATOS GENERALES DEL CLIENTE</h5>
                                            </div> 
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblncliente">NCLIENTE:<span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="tel" class="form-control input-sm" name="lblncliente" id="lblncliente" value="<?php echo $NCliente; ?>" readonly="readonly">
                                                     </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcliente">CLIENTE:<span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                    <input name="lblnombcliente" class="form-control input-sm" id="lblnombcliente" value="<?php echo $NombApellido; ?>" style="width: 100%;" />
                                                    <input id="lblidcliente" name="lblidcliente" value="<?php echo $IdCliente;?>" hidden="">
                                                    <input id="lblcondicion" name="lblcondicion" value="<?php echo $condicion;?>" hidden="">
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblrepresentante">CORREO:<span style="color:red"> * </span> </label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="text"  class="form-control input-sm" id="lblcorreo" value="<?php echo $Correo;?>" name="lblcorreo" >
                                                     </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblcorreo2">CORREO 2:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" id="lblcorreo2" value="<?php echo $Correodos;?>" name="lblcorreo2" >
                                                        </div>
                                                    </div>
                                               </div>
                                                
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblcorreo3">CORREO 3:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="text"  class="form-control input-sm" id="lblcorreo3" value="<?php echo $Correotres; ?>" name="lblcorreo3" >
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblcorreo4" style="text-align:left;">CORREO 4:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="text"  class="form-control input-sm" id="lblcorreo4" value="<?php echo $Correocuatro; ?>" name="lblcorreo4" >
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-8 col-md-8">
                                                    <div class="form-group">
                                                        <label class="col-sm-3 col-xs-4 control-label " for="lbldireccion" style="text-align:left;">DIRECCIÓN:<span style="color:red"> * </span></label>
                                                        <div class="col-sm-9 col-xs-8">
                                                         <textarea class="form-control input-sm" name="lbldireccion" id="lbldireccion" rows="1" style="resize:none" placeholder="Ingresar..." ><?php echo $Direccion;  ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>                                                    
                                                <div class="col-sm-4 col-md-4">
                                                    <div class="form-group">
                                                      
                                                        <div class="col-sm-12 col-xs-12">
                                                    <select class="form-control selectdistrito input-sm" name="lbldistrito" id="lbldistrito" style="width: 100%;" >
                                                        <?php echo $htmldistrito;?>
                                                    </select>
                                                        </div>
                                                    </div>
                                               </div>
                                                </div>                                                
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblmovil">TELEFONO UNO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="tel" class="form-control input-sm" name="lblmovil" id="lblmovil" value="<?php echo $Telefonouno; ?>"  onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9">
                                                        
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblfijo" style="text-align:left;">TELEFONO DOS:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="tel" class="form-control input-sm" name="lblfijo" id="lblfijo" value="<?php echo $Telefonodos;  ?>" onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9" >
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblmovil">TELEFONO TRES:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="tel" class="form-control input-sm" name="lblTelefono3" id="lblTelefono3" value="<?php echo $Telefonotres; ?>"  onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9" >
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblfijo" style="text-align:left;">TELEFONO CUATRO:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="tel" class="form-control input-sm" name="lblTelefono4" id="lblTelefono4" value="<?php echo $Telefonocuatro; ?>" onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9">
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>                                                
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                 <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lbltipodoc">SEGMENTO:<span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                          <select class="form-control input-sm" name="lblsegmento" id="lblsegmento">
                                                                <option value="">Seleccione</option>
                                                                <option value="RES" <?php if($Segmento=="RES"){echo "selected";}?>>RES</option>
                                                                <option value="NEG" <?php if($Segmento=="NEG"){echo "selected";}?>>NEG</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblruc" style="text-align:left;"></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div>
                                                    <h5 class="subtitulo">DATOS GESTIÓN DE SOLICITUD DE BAJA</h5>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblmovitoaviso">TIPO CANAL: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm select2full" name="lbltipocanal" id="lbltipocanal" style="width: 100%;">
                                                            <option value="">Seleccione</option>
                                                            </select>
                                                            <input type="hidden" name="hiddentipocanal" value="<?php echo $tipocanal; ?>" id="hiddentipocanal" />
                                                            <input type="hidden" name="tipocanal" value="<?php echo $tipocanal; ?>" id="tipocanal" />
                                                        </div>
                                                    </div>
                                               </div>
                                                </div>                                                
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblmovitoaviso">MOTIVO AVISO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm select2full" name="lblmovitoaviso" id="lblmovitoaviso" style="width: 100%;">
                                                            <option value="">Seleccione</option>
                                                            </select>
                                                            <input type="hidden" name="hiddenmovitoaviso" value="<?php echo $MotivoAviso; ?>" id="hiddenmovitoaviso" />
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblasignado" style="text-align:left;">GESTOR:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                    <select class="form-control selectgestor input-sm" name="lblasignado" id="lblasignado" style="width: 100%;">
                                                        <?php echo $htmlGestor; ?>
                                                    </select>
                                                    <input type="hidden" id="hidlblAsignadoRET" value="<?php echo $Gestor; ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblfechacierre">FECHA CIERRE: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="tel" class="form-control input-sm" name="lblfechacierre" id="lblfechacierre" value="<?php echo $FechaCierre; ?>" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                        
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblfijo" style="text-align:left;">TIPO DE CIERRE:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                              <select class="form-control input-sm select2full" name="lbltipocierre" id="lbltipocierre" style="width: 100%;">
                                                                  <option value="">Seleccione</option>
                                                              </select> 
                                                              <input type="hidden" name="hiddentipocierre" value="<?php echo $TipoCierre; ?>"  id="hiddentipocierre" />
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblestadofingestion" style="text-align:left;">STATUS FIN GESTIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm select2full" name="lblestadofingestion" id="lblestadofingestion" style="width: 100%;">
                                                            <option value="">Seleccione</option>
                                                        </select>
                                                        <input type="hidden" name="hiddenestadofingestion" value="<?php echo $EstadoFinGestion; ?>" id="hiddenestadofingestion" />                                                            
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6 motivocierre ocultar">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblmotivocierre">MOTIVO CIERRE: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm select2full" name="lblmotivocierre" id="lblmotivocierre" style="width: 100%;">
                                                            <option value="">Seleccione</option>
                                                        </select>
                                                        <input type="hidden" name="hiddenmotivocierre" value="<?php echo $MotivoCierre; ?>" id="hiddenmotivocierre" />
                                                        </div>
                                                    </div>
                                               </div>                                                
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6 motivocierretc ocultar">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblmotivocierretc">MOTIVO CIERRE TC: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm select2full" name="lblmotivocierretc" id="lblmotivocierretc" style="width: 100%;">
                                                            <option value="">Seleccione</option>
                                                        </select>
                                                        <input type="hidden" name="hiddenmotivocierretc" value="<?php echo $MotivoCierreTC; ?>" id="hiddenmotivocierretc" />
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6 competencia ocultar">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblcompetencia">COMPETENCIA:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm select2full" name="lblcompetencia" id="lblcompetencia" style="width: 100%;">
                                                            <option value="">Seleccione</option>
                                                        </select>
                                                        <input type="hidden" name="hiddencompetencia" value="<?php echo $Competencia; ?>" id="hiddencompetencia" />
                                                        </div>
                                                    </div>
                                               </div>                                                 
                                                </div>                                                
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblduracionoferta" style="text-align:left;">DURACION OFERTA: </label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm select2full" name="lblduracionoferta" id="lblduracionoferta" style="width: 100%;">
                                                            <option value="">Seleccione</option>
                                                        </select>
                                                        <input type="hidden" name="hiddenduracionoferta" value="<?php echo $DuracionOferta; ?>" id="hiddenduracionoferta" />                                                            
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblreincidente">REINCIDENTE:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="checkbox" name="lblreincidente" id="lblreincidente" <?php if($Reincidente=="SI"){echo 'checked';}else{echo '';}?> data-size="small"/>
                                                            <input type="hidden" name="hiddenreincidente" id="hiddenreincidente" value="<?php echo $Reincidente;?>">
                                                        </div>
                                                    </div>
                                               </div>                                                
                                                </div>                                                
                                                                                                  
                                        </div>                                        

                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="col-md-2">

                        </div>
                    </div>
                </section>
            </div>

            <div class="control-sidebar-bg"></div>
        </div><!-- ./wrapper -->


        <!-- jQuery v1.11 -->
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
        $.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
        <!-- bootstrap datepicker -->
        <!-- date-range-picker -->
        <script src="admin/bower_components/moment/min/moment.min.js"></script>
        <script src="admin/bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>        
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
        <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- SweetAlert -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
        <!-- DataTables -->
        <script src="admin/bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
        <script src="admin/bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
        <!-- iCheck 1.0.1 -->
        <script src="admin//plugins/iCheck/icheck.min.js"></script>
        <!-- BOOTSTRAP TOOGLE -->
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>        
        
        <!-- SCRIPT PARA EL DOM -->
        <script>

            $(document).ready(function(){
                var idcliente=$('#lblidcliente').val();
                var permiso=$('#lblpermiso').val();
                var idretencion=$('#idretencion').val();
                bloquear(idretencion,idcliente,permiso);
                var tipocanal=$('#tipocanal').val();
                cargarMotivoAviso();
                cargarTipoCierre();
                cargarStatusFinGestion();
                cargarDurecionOferta();
                cargarTipoCanal();
                $('#lbltipocanal').val(tipocanal);
                $('#lblmovitoaviso').val($('#hiddenmovitoaviso').val());
                $('#lbltipocierre').val($('#hiddentipocierre').val());
                $('#lblestadofingestion').val($('#hiddenestadofingestion').val());
                $('#lblduracionoferta').val($('#hiddenduracionoferta').val());
                cargarMotivoCierre(tipocanal,$('#lbltipocierre').val());
                $('#lblmotivocierre').val($('#hiddenmotivocierre').val());
                cargarMotivoCierreTC(tipocanal,$('#hiddenestadofingestion').val());
                cargarCompetencia($('#hiddenmovitoaviso').val());
                $('#lblcompetencia').val($('#hiddencompetencia').val());
                
                $('[data-mask]').inputmask();

                $('.selectgestor').select2({
                    placeholder: 'Seleccione Gestor',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {
                            return "Buscando..";
                        }
                    },
                    ajax: {
                        url: 'ajax/selectGestorRetencion.php',
                        dataType: 'json',
                        delay: 250,
                        processResults: function (data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    }
                });

                $('.selectdistrito').select2({
                placeholder: 'Seleccione Distrito - Provincia',
                allowClear: true,
                language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {

                        return "Buscando..";
                    }
                },

                ajax: {
                        url: 'ajax/selectDistrito.php',
                        dataType: 'json',
                        delay: 250,
                        processResults: function (data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    }
                });
                  
                $('.select2full').select2({
                  //selectOnClose: true
                });
                /*
                $(document).on('keydown', '.select2', function(e) {
                  if (e.originalEvent && e.which == 40) {
                    e.preventDefault();
                    $(this).siblings('select').select2('open');
                  } 
                });
                */
                $(document).on("select2:close", '.select2-hidden-accessible', function () { $(this).focus(); });
                
                                                                                               
                 $('#lblfechacierre').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                $('#lblreincidente').bootstrapToggle({
                    on:'SI',
                    off:'NO',
                    onstyle:'success',
                    offstyle:'danger'
                });
    
                $('#lblreincidente').change(function(){
                  if($(this).prop('checked')){
                     $('#hiddenreincidente').val('SI');
                  }else{
                    $('#hiddenreincidente').val('NO');
                   }
                });                

                
            })
        </script>

        <!-- SCRIPT PARA ACTUALIZAR RETENCION -->
        <script>
            $('#btnguardar').on('click', function(){
                //Datos de cliente//
                var lblcondicion=$('#lblcondicion').val();
                var lblidcliente=$('#lblidcliente').val();
                var lblncliente=$('#lblncliente').val();
                var lblnombcliente=$('#lblnombcliente').val();
                var lblcorreo=$('#lblcorreo').val();
                var lblcorreo2=$('#lblcorreo2').val();
                var lblcorreo3=$('#lblcorreo3').val();
                var lblcorreo4=$('#lblcorreo4').val();
                var lbldireccion=$('#lbldireccion').val();
                var lbldistrito=$('#lbldistrito').val();
                var lblmovil=$('#lblmovil').val();
                var lblfijo=$('#lblfijo').val();
                var lblTelefono3=$('#lblTelefono3').val();
                var lblTelefono4=$('#lblTelefono4').val();
                var lblsegmento=$('#lblsegmento').val();
                
                //Datos de retencion//
                var lblmovitoaviso=$('#lblmovitoaviso option:selected').val();
                var lblasignado=$('#lblasignado').val();
                var tipocanal=$('#tipocanal').val();
                var lblfechacierre=$('#lblfechacierre').val();
                var lblestadofingestion=$('#lblestadofingestion').val();
                var lblmotivocierre=$('#lblmotivocierre option:selected').val();
                var lblduracionoferta=$('#lblduracionoferta option:selected').val();
                var hiddenreincidente=$('#hiddenreincidente').val();
                var lbltipocierre=$('#lbltipocierre option:selected').val();
                //Datos de ampliacion editar//
                var idretencion = $('#idretencion').val();
                var lblmotivocierretc=$('#lblmotivocierretc option:selected').val();
                var lblcompetencia=$('#lblcompetencia option:selected').val();

                 //Algunas variables por default de alertify
                alertify.defaults.theme.ok = "btn btn-nuevo";
                alertify.defaults.theme.cancel = "btn btn-danger";

                var lastX,lastY;
                
                alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function(){
                    if (validaForm()) {
                        // Primero validará el formulario.

                        var datos = {lblcondicion:lblcondicion,
                                    lblncliente:lblncliente,
                                    lblidcliente:lblidcliente,
                                    lblnombcliente:lblnombcliente,
                                    lblcorreo:lblcorreo,
                                    lblcorreo2:lblcorreo2,
                                    lblcorreo3:lblcorreo3,
                                    lblcorreo4:lblcorreo4,
                                    lbldireccion:lbldireccion,
                                    lbldistrito:lbldistrito,
                                    lblmovil:lblmovil,
                                    lblfijo:lblfijo,
                                    lblTelefono3:lblTelefono3,
                                    lblTelefono4:lblTelefono4,
                                    lblsegmento:lblsegmento,

                                    lblmovitoaviso:lblmovitoaviso,
                                    lblasignado:lblasignado,
                                    tipocanal:tipocanal,
                                    lblfechacierre:lblfechacierre,
                                    lblmotivocierre:lblmotivocierre,
                                    idretencion:idretencion,
                                    lblestadofingestion: lblestadofingestion,
                                    lblduracionoferta:lblduracionoferta,
                                    hiddenreincidente:hiddenreincidente,
                                    lbltipocierre:lbltipocierre,
                                    lblmotivocierretc:lblmotivocierretc,
                                    lblcompetencia:lblcompetencia
                        };

                        console.log(datos);

                        $.ajax({
                           type: 'POST',
                           url: 'ajax/updateRetencion.php',
                           data: datos,
                           dataType: "Json",
                           success: function (r) {

                               console.log(r);

                                if (r.respuesta == "exito") {
                                    if(lbltipocierre=="BAJA EVITADA"){
                                        enviarEncuesta();
                                    }

                                    if(r.id_registro==""){
                                         swal.fire({
                                            title: 'Modificado!',
                                            text: 'Modificación exitosa',
                                            type: 'success'
                                        }).then((result) => {
                                                if (result.value) {
                                                   window.location.reload();
                                                }
                                        })
                                    }else{
                                        swal.fire({
                                            title: 'Registro exitoso!',
                                            text: "IDRETENCION "+r.id_registro,
                                            type: 'success'
                                        }).then((result) => {
                                                if (result.value) {
                                                   location.href = 'editarretencion.php?idretencion='+r.id_registro;
                                                }
                                        })
                                    }

                                }
                                else if (r.respuesta == "SinCambios"){
                                    alertify.warning("No se realizaron modificaciones");
                                }
                                else if (r.respuesta == 'error'){
                                    alertify.error(r.mensaje);
                                }
                                else {
                                    alertify.error("Fallo el server");
                                }
                           }
                        });
                  
                    } else {
                        alertify.error("Debe llenar el formulario");
                    }
                }, function(){ alertify.error('No se han guardado los cambios')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){

                    lastX = window.scrollX;
                    lastY = window.scrollY;
                },
                'onfocus':function(){
                    window.scrollTo(lastX, lastY);
                }  }).show();
            })
                    //FUNCION PARA LOS CAMBIOS EN LOS ESTADOS DE TC Y TV
            $("#lbltipocierre").change(function () {
                $("#lbltipocierre option:selected").each(function () {
                   var TipoCierre= $(this).val();
                   var tipocanal=$('#tipocanal').val();
                   console.log(TipoCierre);
                   console.log(tipocanal);
                   cargarMotivoCierre(tipocanal,TipoCierre);
                   
                 });
            });
            $("#lblestadofingestion").change(function () {
                $("#lblestadofingestion option:selected").each(function () {
                   var lblestadofingestion= $(this).val();
                   var tipocanal=$('#tipocanal').val();
                   cargarMotivoCierreTC(tipocanal,lblestadofingestion);  
                 });
            });
            $("#lblmovitoaviso").change(function () {
                $("#lblmovitoaviso option:selected").each(function () {
                   var lblmovitoaviso= $(this).val();
                   cargarCompetencia(lblmovitoaviso);  
                 });
            });
            $("#lbltipocanal").change(function () {
                $("#lbltipocanal option:selected").each(function () {
                   var lbltipocanal= $(this).val();
                   $('#hiddentipocanal').val(lbltipocanal);
                   $('#tipocanal').val(lbltipocanal);
                   $('#lbltipocanal').val(lbltipocanal);

                cargarMotivoAviso();
                cargarTipoCierre();
                cargarStatusFinGestion();
                cargarDurecionOferta();

                cargarMotivoCierre(lbltipocanal,$('#lbltipocierre').val());
                $('#lblmotivocierre').val($('#hiddenmotivocierre').val());
                cargarMotivoCierreTC(lbltipocanal,$('#hiddenestadofingestion').val());
                cargarCompetencia($('#hiddenmovitoaviso').val());
                $('#lblcompetencia').val($('#hiddencompetencia').val());

                 });
            });               

            function cargarMotivoAviso(){
                var tipocanal=$('#tipocanal').val();
                var lblmovitoaviso=$('#lblmovitoaviso');
                var arrayS6mmayor=[
                        {id:"1101-Motivos Economicos"},
                        {id:"1102-Falta de Uso"},
                        {id:"1103-Cambio de Empresa de Seguridad"},
                        {id:"1104-Incidencias en el Servicio"},
                        {id:"1105-Cambio de Domicilio o Cese de Negocio"},
                        {id:"1106-PreXCAN"},
                        {id:"1107-Subida del IPC"},
                        {id:"1108-Robos"},
                        {id:"1109-Red comercial"},
                        {id:"1112-Cobertura"}
                            ];
                var arrayS6mmenor=[
                        {id:"1601-Motivos Economicos"},
                        {id:"1602-Falta de Uso"},
                        {id:"1603-Cambio de Empresa de Seguridad"},
                        {id:"1604-Incidencias en el Servicio"},
                        {id:"1605-Cambio de Domicilio o Cese de Negocio"},
                        {id:"1606-PreXCAN"},
                        {id:"1607-Subida del IPC"},
                        {id:"1608-Robos"},
                        {id:"1609-Red comercial"},
                        {id:"1610-Rescate"}
                            ];
                var arrayBadDebt=[
                    {id:"1801-Motivo Economico"},
                    {id:"1802-Motivo No Uso"},
                    {id:"1803-Motivo Competencia"},
                    {id:"1804-Motivo Incidencia"},
                    {id:"1805-Motivo HM/BC"},
                    {id:"1806-Motivo IPC"},
                    {id:"1807-Motivo Robo"},
                    {id:"1808-Motivo Red Comercial"},
                    {id:"1809-Motivo Subida De Cuota Sin Sb"},
                            ];               
                var r=null;            
                
                lblmovitoaviso.find('option').remove();
                lblmovitoaviso.append('<option value="">Seleccione</option>');
                if(tipocanal=="S6mmayor"){
                    r=arrayS6mmayor;
                }else if(tipocanal=="S6mmenor"){
                    r=arrayS6mmenor;
                }else{
                    r=arrayBadDebt;
                }
                $(r).each(function(i, v){ // indice, valor
                lblmovitoaviso.append('<option value="' + v.id + '">' + v.id + '</option>');
                });
                
            }
            function cargarTipoCierre(){
                var tipocanal=$('#tipocanal').val();
                var lbltipocierre=$('#lbltipocierre');
                var r=[
                        {id:"AVISO GESTIONADO"},
                        {id:"BAJA DEFINITIVA"},
                        {id:"BAJA EVITADA"},
                        {id:"NO PROCEDE APERTURA"},
                        {id:"ILOCALIZADO"}
                            ];
                lbltipocierre.find('option').remove();
                lbltipocierre.append('<option value="">Seleccione</option>');
                $(r).each(function(i, v){ // indice, valor
                lbltipocierre.append('<option value="' + v.id + '">' + v.id + '</option>');
                });                
            }
            function cargarMotivoCierre(tipocanal,TipoCierre){
                var lblmotivocierre=$('#lblmotivocierre');
                var arrayBajaDefinitiva=[
                        {id:"BAJA DEFINITIVA CON DESMONTAJE"},
                        {id:"BAJA DEFINITIVA ILOCALIZADO"},
                        {id:"BAJA DEFINITIVA CON PENALIZACION"},
                        {id:"BAJA DEFINITIVA-UNILATERAL"},
                        {id:"BAJA DEFINITIVA"}
                            ];
                            
                var arrayBajaEvitadaS6mmayor=[
                        {id:"BE DESCUENTO 20% X M4M O IPC"},
                        {id:"BE DESCUENTO 15% X M4M O IPC"},
                        {id:"BE DESCUENTO 50% X M4M O IPC"},
                        {id:"BE Ampliacion facturable"},
                        {id:"BE Ampliacion Gratuita"},
                        {id:"BE ANP"},
                        {id:"ANP + TRASLADO"},
                        {id:"BE ANP + AMPLIACION GRATUITA"},
                        {id:"BE ANP + CoC Facturable"},
                        {id:"BE ANP + CoC No Facturable"},
                        {id:"BE Argumentacion"},
                        {id:"BE Ayuda Comercial"},
                        {id:"BE DEV/COMP/COND"},
                        {id:"BE DESCUENTO M4N (ARGUMENTACION)"},
                        {id:"BE DESCUENTO PERMANENTE"},
                        {id:"BE Descuento 15%"},
                        {id:"BE Descuento 20%"},
                        {id:"BE Descuento 30%"},
                        {id:"BE Descuento 40%"},
                        {id:"BE Descuento 50%"},
                        {id:"BE DESCTO + SERVICIO FACTURABLE"},
                        {id:"BE DESCTO + SERVICIO NO FACTURABLE"},
                        {id:"BE DESCTO EN OTRAS INSTALACIONES"},
                        {id:"BE HALL CASH"},
                        {id:"BE INCREMENTO DE CUOTA"},
                        {id:"BE REVOCACION POR SUBIDA M4N"},
                        {id:"BE Traslado"},
                        {id:"BE Traslado + Ampliacion Gratuita"},
                        {id:"BE Traslado + CoC Facturable"},
                        {id:"BE Traslado + CoC No Facturable"},
                        {id:"BE Visita Tecnica"},
                        {id:"BE Visita Tecnica + DEV/COND/COMP. DEUDA"},
                        {id:"BE Visita Tecnica + DSCTO TEMP. MENOR QUE 25%"},
                        {id:"BE Visita Tecnica + DSCTO TEMP. MAYOR QUE 25%"},
                        {id:"BE Visita Tecnica + DSCTO PERMANENTE"},
                        {id:"Coc con Coste"},
                        {id:"RPB SIN OFERTA"},
                        {id:"RPB CON OFERTA"},
                        {id:"CANCELADO CLIENTE"},
                        {id:"ILOCALIZADO"}
                            ];                            
                var arrayBajaEvitadaS6mmenor=[
                        {id:"CCC-Argumentacion"},
                        {id:"CCC-BE dcto permantente (<20%)"},
                        {id:"CCC-BE dcto en otra instalacion"},
                        {id:"CCC-BE dcto temporal (<20%)"},
                        {id:"CCC-BE Compensacion y/o devolucion"},
                        {id:"CCC-BE Visita Tecnica"},
                        {id:"BE ANP/Traslado"},
                        {id:"CCC-BE Ampliacion de elemento"},
                        {id:"CCC-BE Ampliacion de servicio"},
                        {id:"CCC-Renuncia al proceso de baja"},
                        {id:"CANCELADO CLIENTE"},
                        {id:"ILOCALIZADO"}
                            ];
                lblmotivocierre.find('option').remove();
                lblmotivocierre.append('<option value="">Seleccione</option>');
                if(tipocanal=="S6mmayor"){
                    if(TipoCierre=="BAJA DEFINITIVA"){
                        //$("#lblestadofingestion option[value='PENDIENTE DOCUMENTACION']").attr("selected",true);
                        $('#lblestadofingestion').val('PENDIENTE DOCUMENTACION').trigger('change'); 
                        r=arrayBajaDefinitiva;
                        $('.motivocierre').show();
                    }else if(TipoCierre=="BAJA EVITADA"){
                        $('#lblestadofingestion').val($('#hiddenestadofingestion').val()).trigger('change'); 
                        r=arrayBajaEvitadaS6mmayor;
                        $('.motivocierre').show();
                    }else{
                        $('#lblestadofingestion').val($('#hiddenestadofingestion').val()).trigger('change'); 
                        r=null;
                        $('.motivocierre').hide();
                    }
                    
                }else{
                    if(TipoCierre=="BAJA DEFINITIVA"){
                        //$("#lblestadofingestion option[value='PENDIENTE DOCUMENTACION']").attr("selected",true);
                        $('#lblestadofingestion').val('PENDIENTE DOCUMENTACION').trigger('change'); 
                        r=arrayBajaDefinitiva;
                        $('.motivocierre').show();
                    }else if(TipoCierre=="BAJA EVITADA"){
                        $('#lblestadofingestion').val($('#hiddenestadofingestion').val()).trigger('change'); 
                        r=arrayBajaEvitadaS6mmenor;
                        $('.motivocierre').show();
                    }else{
                        r=null;
                        $('#lblestadofingestion').val($('#hiddenestadofingestion').val()).trigger('change'); 
                        $('.motivocierre').hide();
                    }
                }
                if(r!=null){
                    $(r).each(function(i, v){ // indice, valor
                    lblmotivocierre.append('<option value="' + v.id + '">' + v.id + '</option>');
                    });
                }
            }
            function cargarStatusFinGestion(){
                var tipocanal=$('#tipocanal').val();
                var lblestadofingestion=$('#lblestadofingestion');
                var arrayS6mmayor=[
                        {id:"PENDIENTE DOCUMENTACION"},
                        {id:"PENDIENTE CORTE"},
                        {id:"BAJA EJECUTADA"},
                        {id:"TELECIERRE(2°LINEA)"},
                        {id:"QUITA DE PENDIENTE DOC"}
                            ];
                var arrayS6mmenor=[
                        {id:"PENDIENTE DOCUMENTACION"},
                        {id:"PENDIENTE CORTE"},
                        {id:"XVEN"},
                        {id:"TELECIERRE(2°LINEA)"},
                        {id:"QUITA DE PENDIENTE DOC"}
                            ];                            
                var r=null;            
                
                lblestadofingestion.find('option').remove();
                lblestadofingestion.append('<option value="">Seleccione</option>');
                if(tipocanal=="S6mmayor"){
                    r=arrayS6mmayor;
                }else{
                    r=arrayS6mmenor;
                }
                $(r).each(function(i, v){ // indice, valor
                lblestadofingestion.append('<option value="' + v.id + '">' + v.id + '</option>');
                });
                
            }
            function cargarMotivoCierreTC(tipocanal,lblestadofingestion){
            var lblmotivocierretc=$('#lblmotivocierretc');
            var arrayBajaEvitadaS6mmayor=[
                        {id:"BE DESCUENTO 20% X M4M O IPC"},
                        {id:"BE DESCUENTO 15% X M4M O IPC"},
                        {id:"BE DESCUENTO 50% X M4M O IPC"},
                        {id:"BE Ampliacion facturable"},
                        {id:"BE Ampliacion Gratuita"},
                        {id:"BE ANP"},
                        {id:"ANP + TRASLADO"},
                        {id:"BE ANP + AMPLIACION GRATUITA"},
                        {id:"BE ANP + CoC Facturable"},
                        {id:"BE ANP + CoC No Facturable"},
                        {id:"BE Argumentacion"},
                        {id:"BE Ayuda Comercial"},
                        {id:"BE DEV/COMP/COND"},
                        {id:"BE DESCUENTO M4N (ARGUMENTACION)"},
                        {id:"BE DESCUENTO PERMANENTE"},
                        {id:"BE Descuento 15%"},
                        {id:"BE Descuento 20%"},
                        {id:"BE Descuento 30%"},
                        {id:"BE Descuento 40%"},
                        {id:"BE Descuento 50%"},
                        {id:"BE DESCTO + SERVICIO FACTURABLE"},
                        {id:"BE DESCTO + SERVICIO NO FACTURABLE"},
                        {id:"BE DESCTO EN OTRAS INSTALACIONES"},
                        {id:"BE HALL CASH"},
                        {id:"BE INCREMENTO DE CUOTA"},
                        {id:"BE REVOCACION POR SUBIDA M4N"},
                        {id:"BE Traslado"},
                        {id:"BE Traslado + Ampliacion Gratuita"},
                        {id:"BE Traslado + CoC Facturable"},
                        {id:"BE Traslado + CoC No Facturable"},
                        {id:"BE Visita Tecnica"},
                        {id:"BE Visita Tecnica + DEV/COND/COMP. DEUDA"},
                        {id:"BE Visita Tecnica + DSCTO TEMP. MENOR QUE 25%"},
                        {id:"BE Visita Tecnica + DSCTO TEMP. MAYOR QUE 25%"},
                        {id:"BE Visita Tecnica + DSCTO PERMANENTE"},
                        {id:"Coc con Coste"},
                        {id:"RPB SIN OFERTA"},
                        {id:"RPB CON OFERTA"},
                        {id:"CANCELADO CLIENTE"},
                        {id:"ILOCALIZADO"}
                            ];                            
            var arrayBajaEvitadaS6mmenor=[
                        {id:"CCC-Argumentacion"},
                        {id:"CCC-BE dcto permantente (<20%)"},
                        {id:"CCC-BE dcto en otra instalacion"},
                        {id:"CCC-BE dcto temporal (<20%)"},
                        {id:"CCC-BE Compensacion y/o devolucion"},
                        {id:"CCC-BE Visita Tecnica"},
                        {id:"BE ANP/Traslado"},
                        {id:"CCC-BE Ampliacion de elemento"},
                        {id:"CCC-BE Ampliacion de servicio"},
                        {id:"CCC-Renuncia al proceso de baja"},
                        {id:"CANCELADO CLIENTE"},
                        {id:"ILOCALIZADO"}
                            ];
                lblmotivocierretc.find('option').remove();
                lblmotivocierretc.append('<option value="">Seleccione</option>');
                if(tipocanal=="S6mmayor"){
                    r=arrayBajaEvitadaS6mmayor;
                }else{
                    r=arrayBajaEvitadaS6mmenor;
                }

                if(lblestadofingestion=="TELECIERRE(2°LINEA)"){
                    $(r).each(function(i, v){ // indice, valor
                    lblmotivocierretc.append('<option value="' + v.id + '">' + v.id + '</option>');
                    });
                    $('.motivocierretc').show();
                }else{
                    $('.motivocierretc').hide();
                }
                
            }
            function cargarCompetencia(Aviso){
            var lblcompetencia=$('#lblcompetencia');
            var array=[
                        {id:"Prosegur"},
                        {id:"Qido"},
                        {id:"Mafre"},
                        {id:"Boxer"},
                        {id:"Liderman Alarmas"},
                        {id:"Otros"}
                            ];                            

                lblcompetencia.find('option').remove();
                lblcompetencia.append('<option value="">Seleccione</option>');
            if(Aviso=="1603-Cambio de Empresa de Seguridad" || Aviso=="1103-Cambio de Empresa de Seguridad"){
                $(array).each(function(i, v){ // indice, valor
                    lblcompetencia.append('<option value="' + v.id + '">' + v.id + '</option>');
                });
                $('.competencia').show();
            }else{
                $('.competencia').hide();
            }

            }            

            
            function cargarDurecionOferta(){
                var lblduracionoferta=$('#lblduracionoferta');
                var r=[
                        {id:"1 MES"},
                        {id:"2 MESES"},
                        {id:"3 MESES"},
                        {id:"4 MESES"},
                        {id:"5 MESES"},
                        {id:"6 MESES"},
                        {id:"7 MESES"},
                        {id:"8 MESES"},
                        {id:"9 MESES"},
                        {id:"PERMANENTE"}
                            ];
                lblduracionoferta.find('option').remove();
                lblduracionoferta.append('<option value="">Seleccione</option>');
                $(r).each(function(i, v){ // indice, valor
                lblduracionoferta.append('<option value="' + v.id + '">' + v.id + '</option>');
                });
                
            }
            function cargarTipoCanal(){
                var lbltipocanal=$('#lbltipocanal');
                var r=[
                        {id:"S6mmayor",text:"SB +6M"},
                        {id:"S6mmenor",text:"SB -6M"},
                        {id:"BadDebt",text:"BadDebt"},
                        
                            ];
                lbltipocanal.find('option').remove();
                lbltipocanal.append('<option value="">Seleccione</option>');
                $(r).each(function(i, v){ // indice, valor
                lbltipocanal.append('<option value="' + v.id + '">' + v.text + '</option>');
                });
                
            }            
            function bloquear(idretencion,idcliente,permiso){

                if(idcliente==""){
                    $('#lblnombcliente').prop('disabled', false);
                    $('#lblcorreo').prop('disabled', false);;
                    $('#lblcorreo2').prop('disabled', false);;
                    $('#lbldireccion').prop('disabled', false);
                    $('#lbldistrito').prop('disabled', false);
                    $('#lblmovil').prop('disabled', false);
                    $('#lblfijo').prop('disabled', false);
                    $('#lblsegmento').prop('disabled', false);
                }else{
                    $('#lblnombcliente').prop('disabled', true);
                    $('#lblcorreo').prop('disabled', true);
                    $('#lblcorreo2').prop('disabled', true);
                    $('#lbldireccion').prop('disabled', true);
                    $('#lbldistrito').prop('disabled', true);
                    $('#lblmovil').prop('disabled', true);
                    $('#lblfijo').prop('disabled', true);
                    $('#lblsegmento').prop('disabled', true);
                }

                if(permiso=="GestorRetencion"){
                    $('#lblasignado').prop('disabled', true);
                    $('#lblestadofingestion').prop('disabled', false);
                    $('#lbltipocanal').prop('disabled', true);
                    
                    
                }else{
                    if(idretencion!=""){
                        if($("#hidlblAsignadoRET").val()!=""){
                        $('#lblasignado').prop('disabled', false);
                        }else{
                        $('#lblasignado').prop('disabled', false);
                        }
                    $('#lblestadofingestion').prop('disabled', false);
                    $('#lbltipocanal').prop('disabled', false);
                    }else{
                    $('#lblasignado').prop('disabled', false);
                    $('#lblestadofingestion').prop('disabled', false);
                    $('#lbltipocanal').prop('disabled', false);
                    }
                }
            }
    function validaForm(){

                if ($("#lblncliente").val() == "") {
                    alertify.warning("Por favor ingresar NCliente correspondiente");
                    $("#lblncliente").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#lblnombcliente").val() == "") {
                    alertify.warning("Por favor ingresar Nombre del Cliente");
                    $('#lblnombcliente').addClass('bordeRojo');
                    $("#lblnombcliente").focus();
                    return false;
                }
                if ($("#lblcorreo").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#lblcorreo").val())) {
                    alertify.warning("Por favor ingresar correo válido");
                    $("#lblcorreo").focus();
                    $('#lblcorreo').addClass('bordeRojo');
                    return false;
                }
                if ($("#lblcorreo2").val() !== "") {
                    if (!/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#lblcorreo2").val())) {
                        alertify.warning("Por favor ingresar segundo correo válido");
                        $('#lblcorreo2').addClass('bordeRojo');
                        $("#lblcorreo2").focus();
                        return false;
                    }
                }
                if ($("#lbldireccion").val() == "") {
                    alertify.warning("Por favor ingresar la Direccion del Cliente");
                    $('#lbldireccion').addClass('bordeRojo');
                    $("#lbldireccion").focus();
                    return false;
                }
                if ($("#lbldistrito").val() == "") {
                    alertify.warning("Por favor ingresar Distrito correcto");
                    $('#lbldistrito').addClass('bordeRojo');
                    $("#lbldistrito").select2('open');
                    return false;
                }
                if ($("#lblmovil").val() == "") {
                    alertify.warning("Por favor ingresar Telefonouno");
                    $('#lblmovil').addClass('bordeRojo');
                    $("#lblmovil").focus();
                    return false;
                }
                if (!/^([0-9])*$/.test($("#lblmovil").val()) ) {
                    alertify.warning("El valor de Teléfono Uno no es un número");
                    $("# #lblmovil").focus();
                    return false;
                } 
                if (!/^([0-9])*$/.test($("#lblfijo").val()) ) {
                    alertify.warning("El valor de Teléfono Uno no es un número");
                    $("#lblfijo").focus();
                    return false;
                }  
                if (!/^([0-9])*$/.test($("#lblTelefono3").val()) ) {
                    alertify.warning("El valor de Teléfono Uno no es un número");
                    $("#lblTelefono3").focus();
                    return false;
                }
                if (!/^([0-9])*$/.test($("#lblTelefono4").val()) ) {
                    alertify.warning("El valor de Teléfono Uno no es un número");
                    $("#lblTelefono4").focus();
                    return false;
                }  

                if ($("#lblsegmento").val() == "Seleccione" || $("#lblsegmento").val() == "") {
                    alertify.warning("Por favor ingresar Segmento correcto");
                    $('#lblsegmento').addClass('bordeRojo');
                    $("#lblsegmento").focus();
                    return false;
                }
                if ($("#lbltipocanal").val() == "" || $("#lbltipocanal").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Tipo Canal");
                    $('#lbltipocanal').addClass('bordeRojo');
                    $("#lbltipocanal").select2('open');
                    return false;
                }    
                if ($("#lblasignado").val() == "") {
                    alertify.warning("Por favor ingresar Gestor correcto");
                    $('#lblasignado').addClass('bordeRojo');
                    $("#lblasignado").select2('open');
                    return false;
                }
                if ($("#lblmovitoaviso").val() == "" || $("#lblmovitoaviso").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Motivo Aviso");
                    $('#lblmovitoaviso').addClass('bordeRojo');
                    $("#lblmovitoaviso").select2('open');
                    return false;
                }
                if ($("#lblmovitoaviso").val() == "" || $("#lblmovitoaviso").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Motivo Aviso");
                    $('#lblmovitoaviso').addClass('bordeRojo');
                    $("#lblmovitoaviso").select2('open');
                    return false;
                }    
                if ($("#lbltipocierre").val() == "" || $("#lbltipocierre").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Tipo de Cierre");
                    $('#lbltipocierre').addClass('bordeRojo');
                    $("#lbltipocierre").select2('open');
                    return false;
                }
                if ($("#lbltipocierre").val() == "" || $("#lbltipocierre").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Tipo de Cierre");
                    $('#lbltipocierre').addClass('bordeRojo');
                    $("#lbltipocierre").select2('open');
                    return false;
                }
                if ($("#lbltipocierre").val() == "BAJA DEFINITIVA" || $("#lbltipocierre").val() == "BAJA EVITADA") {
                    if ($("#lblmotivocierre").val() == "" || $("#lblmotivocierre").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Motivo de Cierre");
                        $('#lblmotivocierre').addClass('bordeRojo');
                        $("#lblmotivocierre").select2('open');
                        return false;
                    }
                    /*
                     if ($("#lbltipocierre").val() == "BAJA EVITADA") {
                        if ($("#lblduracionoferta").val() == "" || $("#lblduracionoferta").val() == "Seleccione") {
                            alertify.warning("Por favor ingresar Duración de la Oferta");
                            $('#lblduracionoferta').addClass('bordeRojo');
                            $("#lblduracionoferta").select2('open');
                            return false;
                        }    
                      
                     }
                     */
                }
                if ($("#lblmovitoaviso").val() == "1603-Cambio de Empresa de Seguridad" || $("#lblmovitoaviso").val() == "1103-Cambio de Empresa de Seguridad") {
                        if ($("#lblcompetencia").val() == "" || $("#lblcompetencia").val() == "Seleccione") {
                            alertify.warning("Por favor ingresar Competencia");
                            $('#lblcompetencia').addClass('bordeRojo');
                            $("#lblcompetencia").select2('open');
                            return false;
                        }   
                }
            
                

                return true;
            }            
        </script>
    
        <script type="text/javascript">
            var scrolltotop={setting:{startline:100,scrollto:0,scrollduration:1e3,fadeduration:[500,100]},controlHTML:'<button type="button" class="btn btn-nuevo btn-xl" style="border-radius: 50%;"><i class="glyphicon glyphicon-chevron-up"></i></button>',controlattrs:{offsetx:5,offsety:5},anchorkeyword:"#top",state:{isvisible:!1,shouldvisible:!1},scrollup:function(){this.cssfixedsupport||this.$control.css({opacity:0});var t=isNaN(this.setting.scrollto)?this.setting.scrollto:parseInt(this.setting.scrollto);t="string"==typeof t&&1==jQuery("#"+t).length?jQuery("#"+t).offset().top:0,this.$body.animate({scrollTop:t},this.setting.scrollduration)},keepfixed:function(){var t=jQuery(window),o=t.scrollLeft()+t.width()-this.$control.width()-this.controlattrs.offsetx,s=t.scrollTop()+t.height()-this.$control.height()-this.controlattrs.offsety;this.$control.css({left:o+"px",top:s+"px"})},togglecontrol:function(){var t=jQuery(window).scrollTop();this.cssfixedsupport||this.keepfixed(),this.state.shouldvisible=t>=this.setting.startline?!0:!1,this.state.shouldvisible&&!this.state.isvisible?(this.$control.stop().animate({opacity:1},this.setting.fadeduration[0]),this.state.isvisible=!0):0==this.state.shouldvisible&&this.state.isvisible&&(this.$control.stop().animate({opacity:0},this.setting.fadeduration[1]),this.state.isvisible=!1)},init:function(){jQuery(document).ready(function(t){var o=scrolltotop,s=document.all;o.cssfixedsupport=!s||s&&"CSS1Compat"==document.compatMode&&window.XMLHttpRequest,o.$body=t(window.opera?"CSS1Compat"==document.compatMode?"html":"body":"html,body"),o.$control=t('<div id="topcontrol">'+o.controlHTML+"</div>").css({position:o.cssfixedsupport?"fixed":"absolute",bottom:o.controlattrs.offsety,right:o.controlattrs.offsetx,opacity:0,cursor:"pointer"}).attr({title:"Scroll to Top"}).click(function(){return o.scrollup(),!1}).appendTo("body"),document.all&&!window.XMLHttpRequest&&""!=o.$control.text()&&o.$control.css({width:o.$control.width()}),o.togglecontrol(),t('a[href="'+o.anchorkeyword+'"]').click(function(){return o.scrollup(),!1}),t(window).bind("scroll resize",function(t){o.togglecontrol()})})}};scrolltotop.init();
        </script>
        <!-- SCRIPT DE QSERVUS -->
        <script>
            function enviarEncuesta(){
                let lblcorreo=$('#lblcorreo').val();
                let lblnombcliente=$('#lblnombcliente').val();
                let lblncliente=$('#lblncliente').val();
                var tipocanal=$('#tipocanal').val();
                if(tipocanal=="S6mmayor"){
                    tipocanal="SB +6M(1100)";
                }else{
                    tipocanal="SB -6M(1600)";
                }
                let lblmovitoaviso=$('#lblmovitoaviso option:selected').val();
                let lblasignado=$('#lblasignado').val();
                let lblfechacierre = moment($('#lblfechacierre').val(), 'DD/MM/YYYY').format('DD-MM-YYYY');
                console.log(lblfechacierre);
                let lbltipocierre=$('#lbltipocierre option:selected').val();
                let lblmotivocierre=$('#lblmotivocierre option:selected').val();
                let lblestadofingestion=$('#lblestadofingestion').val();
                let lblduracionoferta=$('#lblduracionoferta option:selected').val();
                let hiddenreincidente=$('#hiddenreincidente').val();
                
                let lbldistrito = $('#lbldistrito option:selected').text();
                let arraylbldistrito = lbldistrito.split(" - ");
                let distrito = arraylbldistrito[0];
                let provincia = arraylbldistrito[1];
                let lblsegmento = $('#lblsegmento').val();

                data =  {
                  "campaign_id":309757,
                  "survey_id":336768,
                  "respondent_email": lblcorreo,
                  "respondent_name": lblnombcliente,
                  "respondent_phone": "",
                "respondent_expiration_days": 10,
                  "ncontrato": lblncliente,
                  "tipo_canal": tipocanal,
                  "motivo_aviso": lblmovitoaviso,
                  "gestor": lblasignado,
                  "fecha_cierre": lblfechacierre,
                  "tipo_cierre": lbltipocierre,
                  "motivo_cierre": lblmotivocierre,
                    "city": distrito,
                    "state_description": provincia,
                     "segmento": lblsegmento,
                  "estado_fin_gestion": lblestadofingestion,
                  "duracion_oferta": lblduracionoferta,
                  "reincidente": hiddenreincidente
                }

                console.log(data);

                fetch('https://qservus.redcalidad.com/api/addrespondent/', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Authorization': 'Token 69091bedd687e3b2da71f0d804df3853242a493c'
                        },
                        body: JSON.stringify(data),
                    })
                    .then(response => response.json())
                    .then(data => {
                      console.log('Success:', data);
                    })
                    .catch((error) => {
                      console.error('Error:', error);
                    });
        
            }
        </script>        
    </body>

</html>

<?php

$con->close();
?>
