<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
    	exit;
    }
    
    if ($_SESSION['pzvtaconsulta']==0) {
        header("location: ./denegado.php");
		exit;
    }
    
    date_default_timezone_set('America/Lima');
    
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }

    include 'config/db.php';
    include 'config/conexion.php';
    require_once 'helper/helper_validacion.php';


    if (isset($_GET['idprospectorp'])) {
        $idprospectorp = sanitizaCampo($_GET['idprospectorp'], 'sanitizeint|scapestring|htmlspecialchars',$con);
        $idprospectorp=htmlspecialchars($idprospectorp);
    }

    $fechames=date("M-Y");

    $resultado = $con->prepare("SELECT 1 FROM dbVENTAS.tblventa v WHERE v.IdProspectoRP= ? ");
    $resultado->bind_param('i',$idprospectorp);
    $resultado->execute();
    $resultado->store_result();
    $numrows=$resultado->num_rows;

    if($numrows>0){
        $sql_venta = $con->prepare("SELECT 
            u.IdUsuario,
            p.Matricula,
            p.Comercial,
            p.CC,
            p.JefeVenta,
            CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
            p.EstadoProspecto,
            p.EstadoVenta,
            p.CategoriaVenta,
            p.TipoVenta,
            p.Segmento,
            p.MesesAutorizado,
            p.NProspecto,
            p.IdCliente,
            c.NombApellido Cliente,
            c.Correo,
            c.Telefonouno,
            c.Telefonodos,
            c.Direccion,
            g.IdGeografico,
            g.Distrito,
            g.Provincia,
            g.prioridadChip,
            p.PrecioKit,
            p.TotalExtra,
            p.ResumenProspecto,
            p.ExtraAutorizado,
            p.FormaPago,
            p.N590,
            p.PAI,
            p.ComentarioProspectoRP,
            agen.InstaladoX,
            agen.MatriculaTec,
            CONCAT(t.Nombres,' ',t.Apellidos) Instalador,
            t.LN LNInstalador,
            DATE_FORMAT(agen.FechaInst, '%d/%m/%Y') FechaInst, 
            TIME_FORMAT(agen.HoraInst,'%r') HoraInst,
            agen.Comentario,
            p.HojaCertificacion,
            p.TipoKIT,
            p.ClosingPack,
            p.PrecioEspecial,
            p.CantidadExtras,
            p.ScoringRP,
            DATE_FORMAT(p.FechaVisitaRP,'%d/%m/%Y') FechaVisitaRP,
            TIME_FORMAT(p.HoraVisitaRP,'%r') HoraVisitaRP,
            p.VisitaConcertada,
            p.CheckinRP,
            p.InfoCheckInRP,
            p.CodigoOperacionScoring,
            p.IdConsultaScoring,
            p.GGCC,
            p.FormaPagoCuota,
            v.NContrato,
            p.referidoHabilitado,
            v.CategoriaPrecio, 
            v.CantidadRegalo,
            v.TotalCuotaMonitoreo,
            vc.DetalleGeneral,
            vc.DetalleExtras,
            vc.DetalleRegalos,
            pp.IdProvincial,
            pp.IdDepartamental,
            g.CodUbigeoReniec,
            v.dsctCuota,
            v.SegundaAlarma
        FROM dbVENTAS.tblventa v
            INNER JOIN dbVENTAS.tblprospectorp p on p.IdProspectoRP=v.IdProspectoRP 
            INNER JOIN dbUSUARIO.tblusuario u on v.IdUsuario=u.IdUsuario 
            INNER JOIN dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
            INNER JOIN dbUSUARIO.tblusuario m on m.Matricula=u.Manager
            INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
            INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
            INNER JOIN dbVENTAS.tblagenda agen on agen.IdVenta=v.IdVenta
            LEFT JOIN dbUSUARIO.tblusuario t on t.Matricula=agen.MatriculaTec
            LEFT JOIN dbVENTAS.tblventacotizacion vc ON v.IdVenta = vc.IdVenta
            LEFT JOIN dbVENTAS.tbldistrital dd on dd.CodUbigeoReniec=g.CodUbigeoReniec
            LEFT JOIN dbVENTAS.tblprovincial pp on pp.IdProvincial=dd.IdProvincial            
        WHERE v.IdProspectoRP=?");
        $sql_venta->bind_param('i',$idprospectorp);
        $sql_venta->execute();
        $sql_venta->store_result();
        $sql_venta->bind_result(
            $iduRow,
            $matriculaRow,
            $comercialRow,
            $dcRow,
            $matjefeRow,
            $jefeventaRow,
            $estadoprospectoRow, 
            $estadoventaRow,   
            $categoriaventaRow,  
            $tipoventaRow,
            $segmentoRow,  
            $mesesautorizadosRow,
            $nprospectoRow,  
            $idclienteRow,
            $clienteRow,
            $correoRow,
            $movilRow,
            $fijoRow,
            $direccionRow,
            $idgeograficoRow,
            $distritoRow,
            $provinciaRow,
            $prioridadChipRow,
            $preciokitRow,
            $totalextraRow,
            $resumenventaRow,
            $regaloutorizadoRow,
            $formadepagoRow,
            $n590Row,
            $PAIRow,
            $comentarioprospectoRow,
            $instaladoxRow,
            $matriculatecRow,
            $nomreinstaladorRow,
            $lninstaladorRow,
            $fechainstalacionverRow,
            $horainstalacionverRow,
            $comentarioagendaRow,
            $HojaCertificacionRow,
            $TipoKITRow,
            $ClosingPackRow,
            $PrecioEspecialRow,
            $CantidadExtrasRow,
            $ScoringRPRow,
            $fvisitaRow,
            $hvisitaRow,
            $VisitaConcertadaRow,
            $CheckinRPRow,
            $InfoCheckInRPRow,
            $CodigoOperacionScoringRow,
            $IdConsultaScoringRow,
            $GGCCRow,
            $FormaPagoCuotaRow,
            $NContratoRow,
            $referidoHabilitadoRow,
            $CategoriaPrecioRow,
            $CantidadRegaloRow,
            $TotalCuotaMonitoreoRow,
            $DetalleGeneralRow,
            $DetalleExtrasRow,
            $DetalleRegalosRow,
            $IdProvincialRow,
            $IdDepartamentalRow,
            $CodUbigeoReniecRow,
            $dsctCuotaRow,
            $SegundaAlarmaRow
        );
        $numrows_venta = $sql_venta->num_rows;
    
        if ($numrows_venta > 0) {
            while ($sql_venta->fetch()) {
                $idu=$iduRow;
                $matricula=$matriculaRow;
                $comercial=$comercialRow;
                $dc=$dcRow;
                $matjefe=$matjefeRow;
                $jefeventa=$jefeventaRow;
                $estadoprospecto=$estadoprospectoRow; 
                $estadoventa=$estadoventaRow;   
                $categoriaventa=$categoriaventaRow;  
                $tipoventa=$tipoventaRow;
                $segmento=$segmentoRow;  
                $mesesautorizados=$mesesautorizadosRow;
                $nprospecto=$nprospectoRow;  
                $idcliente=$idclienteRow;
                $cliente=$clienteRow;
                $correo=$correoRow;
                $movil=$movilRow;
                $fijo=$fijoRow;
                $direccion=$direccionRow;
                $idgeografico=$idgeograficoRow;
                $distrito=$distritoRow;
                $provincia=$provinciaRow;
                $sims = $prioridadChipRow;
                $preciokit=$preciokitRow;
                $totalextra=$totalextraRow;
                $resumenventa=$resumenventaRow;
                $regaloutorizado=$regaloutorizadoRow;
                $formadepago=$formadepagoRow;
                $n590=$n590Row;
                $PAI=$PAIRow;
                $comentarioprospecto=$comentarioprospectoRow;
                $instaladox=$instaladoxRow;
                $matriculatec=$matriculatecRow;
                $nomreinstalador=$nomreinstaladorRow;
                $lninstalador=$lninstaladorRow;
                $fechainstalacionver=$fechainstalacionverRow;
                $horainstalacionver=$horainstalacionverRow;
                $comentarioagenda=$comentarioagendaRow;
                $HojaCertificacion=$HojaCertificacionRow;
                $TipoKIT=$TipoKITRow;
                $ClosingPack=$ClosingPackRow;
                $PrecioEspecial=$PrecioEspecialRow;
                $CantidadExtras=$CantidadExtrasRow;
                $ScoringRP=$ScoringRPRow;
                $fvisita=$fvisitaRow;
                $hvisita=$hvisitaRow;
                $VisitaConcertada=$VisitaConcertadaRow;
                $CheckinRP=$CheckinRPRow;
                $InfoCheckInRP=$InfoCheckInRPRow;
                $CodigoOperacionScoring=$CodigoOperacionScoringRow;
                $IdConsultaScoring=$IdConsultaScoringRow;
                $GGCC=$GGCCRow;
                $FormaPagoCuota=$FormaPagoCuotaRow;
                $NContrato=$NContratoRow;
                $referidoHabilitado=$referidoHabilitadoRow;
                $CategoriaPrecio=$CategoriaPrecioRow;
                $CantidadRegalo=$CantidadRegaloRow;
                $TotalCuotaMonitoreo=$TotalCuotaMonitoreoRow;
                $DetalleGeneral=$DetalleGeneralRow;
                $DetalleExtras=$DetalleExtrasRow;
                $DetalleRegalos=$DetalleRegalosRow;
                $IdProvincial=$IdProvincialRow;
                $IdDepartamental=$IdDepartamentalRow;
                $CodUbigeoReniec = $CodUbigeoReniecRow;
                $dsctCuota=$dsctCuotaRow;
                $SegundaAlarma=$SegundaAlarmaRow;
        
                $comentariocallrp='';
            }
        }
    } 
    //CASO PROSPECTORP CUANDO AUN NO ES VENTA
    else{
        $sql_venta = $con->prepare("SELECT 
                                            u.IdUsuario,
                                            p.Matricula,
                                            p.Comercial,
                                            p.CC,
                                            p.JefeVenta,
                                            CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
                                            p.EstadoProspecto,
                                            p.EstadoVenta,
                                            p.CategoriaVenta,
                                            p.TipoVenta,
                                            p.Segmento,
                                            p.MesesAutorizado,
                                            p.NProspecto,
                                            p.IdCliente,
                                            c.NombApellido Cliente,
                                            c.Correo,
                                            c.Telefonouno,
                                            c.Telefonodos,
                                            c.Direccion,
                                            g.IdGeografico,
                                            g.Distrito,
                                            g.Provincia,
                                            g.prioridadChip,
                                            p.PrecioKit,
                                            p.TotalExtra,
                                            p.ResumenProspecto,
                                            p.ExtraAutorizado,
                                            p.FormaPago,
                                            p.N590,
                                            p.PAI,
                                            p.ComentarioProspectoRP,
                                            p.ComentarioCallRP,
                                            p.GestorContactRP,
                                            DATE_FORMAT(p.FechaVisitaRP,'%d/%m/%Y') FechaVisitaRP,
                                        	TIME_FORMAT(p.HoraVisitaRP,'%r') HoraVisitaRP,
                                            p.MesVisitaRP,
                                            p.TipoKIT,
                                            p.ClosingPack,
                                            p.PrecioEspecial,
                                            p.CantidadExtras,
                                            p.ScoringRP,
                                            p.VisitaConcertada,
                                            p.CheckinRP,
                                            p.InfoCheckInRP,
                                            p.CodigoOperacionScoring,
                                            p.IdConsultaScoring,
                                            p.GGCC,
                                            p.FormaPagoCuota,
                                            p.HojaCertificacion,
                                            p.referidoHabilitado,
                                            pp.IdProvincial,
                                            pp.IdDepartamental,
                                            g.CodUbigeoReniec
                                        FROM dbVENTAS.tblprospectorp p
                                        INNER JOIN dbUSUARIO.tblusuario u on p.IdUsuario=u.IdUsuario 
                                        INNER JOIN dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
                                        INNER JOIN dbUSUARIO.tblusuario m on m.Matricula=u.Manager
                                        INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
                                        INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
                                        LEFT JOIN dbVENTAS.tbldistrital dd on dd.CodUbigeoReniec=g.CodUbigeoReniec
                                        LEFT JOIN dbVENTAS.tblprovincial pp on pp.IdProvincial=dd.IdProvincial                                        
                                        WHERE p.IdProspectoRP=?");
        $sql_venta->bind_param('i',$idprospectorp);     
        $sql_venta->execute();
        $sql_venta->store_result();
        $sql_venta->bind_result(
            $iduRow,
            $matriculaRow,
            $comercialRow,
            $dcRow,
            $matjefeRow,
            $jefeventaRow,
            $estadoprospectoRow,
            $estadoventaRow,
            $categoriaventaRow,
            $tipoventaRow,
            $segmentoRow,
            $mesesautorizadosRow,
            $nprospectoRow,
            $idclienteRow,
            $clienteRow,
            $correoRow,
            $movilRow,
            $fijoRow,
            $direccionRow,
            $idgeograficoRow,
            $distritoRow,
            $provinciaRow,
            $prioridadChipRow,
            $preciokitRow,
            $totalextraRow,
            $resumenventaRow,
            $regaloutorizadoRow,
            $formadepagoRow,
            $n590Row,
            $PAIRow,
            $comentarioprospectoRow,
            $comentariocallrpRow,    
            $GestorContactRPRow,
            $fvisitaRow,
            $hvisitaRow,
            $mesvisitaRow,
            $TipoKITRow,
            $ClosingPackRow,
            $PrecioEspecialRow,
            $CantidadExtrasRow,
            $ScoringRPRow,
            $VisitaConcertadaRow,
            $CheckinRPRow,
            $InfoCheckInRPRow,
            $CodigoOperacionScoringRow,
            $IdConsultaScoringRow,
            $GGCCRow,
            $FormaPagoCuotaRow,
            $HojaCertificacionRow,
            $referidoHabilitadoRow,
            $IdProvincialRow,
            $IdDepartamentalRow,
            $CodUbigeoReniecRow
        );
                
        $numrows_venta = $sql_venta->num_rows;

    if ($numrows_venta > 0) {
        while ($sql_venta->fetch()) {
                    $idu = $iduRow;
                    $matricula = $matriculaRow;
                    $comercial = $comercialRow;
                    $dc = $dcRow;
                    $matjefe = $matjefeRow;
                    $jefeventa = $jefeventaRow;
                    $estadoprospecto = $estadoprospectoRow;
                    $estadoventa = $estadoventaRow;
                    $categoriaventa = $categoriaventaRow;
                    $tipoventa = $tipoventaRow;
                    $segmento = $segmentoRow;
                    $mesesautorizados = $mesesautorizadosRow;
                    $nprospecto = $nprospectoRow;
                    $idcliente = $idclienteRow;
                    $cliente = $clienteRow;
                    $correo = $correoRow;
                    $movil = $movilRow;
                    $fijo = $fijoRow;
                    $direccion = $direccionRow;
                    $idgeografico = $idgeograficoRow;
                    $distrito = $distritoRow;
                    $provincia = $provinciaRow;
                    $sims = $prioridadChipRow;
                    $preciokit = $preciokitRow;
                    $totalextra = $totalextraRow;
                    $resumenventa = $resumenventaRow;
                    $regaloutorizado = $regaloutorizadoRow;
                    $formadepago = $formadepagoRow;
                    $n590 = $n590Row;
                    $PAI = $PAIRow;
                    $comentarioprospecto = $comentarioprospectoRow;
                    $comentariocallrp = $comentariocallrpRow;    
                    $GestorContactRP = $GestorContactRPRow;
                    $fvisita = $fvisitaRow;
                    $hvisita = $hvisitaRow;
                    $mesvisita = $mesvisitaRow;
                    $TipoKIT = $TipoKITRow;
                    $ClosingPack = $ClosingPackRow;
                    $PrecioEspecial = $PrecioEspecialRow;
                    $CantidadExtras = $CantidadExtrasRow;
                    $ScoringRP = $ScoringRPRow;
                    $VisitaConcertada = $VisitaConcertadaRow;
                    $CheckinRP = $CheckinRPRow;
                    $InfoCheckInRP = $InfoCheckInRPRow;
                    $CodigoOperacionScoring = $CodigoOperacionScoringRow;
                    $IdConsultaScoring = $IdConsultaScoringRow;
                    $GGCC = $GGCCRow;
                    $FormaPagoCuota = $FormaPagoCuotaRow;
                    $HojaCertificacion = $HojaCertificacionRow;
                    $referidoHabilitado = $referidoHabilitadoRow;
                    $IdProvincial = $IdProvincialRow;
                    $IdDepartamental = $IdDepartamentalRow; 
                    $CodUbigeoReniec = $CodUbigeoReniecRow;
                    $lninstalador="";        
                    $idagenda=0;
                    $instaladox="";
                    $matriculatec="";
                    $nomreinstalador="";
                    $fechainstalacionver="";
                    $horainstalacionver="";
                    $comentarioagenda='';
                    $NContrato="";        
                    $CategoriaPrecio='';
                    $CantidadRegalo='';
                    $TotalCuotaMonitoreo='';
                    $DetalleGeneral='';
                    $DetalleExtras='';
                    $DetalleRegalos='';
                    $dsctCuota='';
                    $SegundaAlarma='';
        }
    }

}

    $html=NULL;

    try {
            $sql = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) JefeVenta FROM dbUSUARIO.tblusuario u  where u.CC=? AND u.LN='11' AND (u.Categoria ='JE' OR u.Categoria ='COACH' OR u.Categoria ='DEL' or u.Categoria='JE/DEL' or u.Categoria='GERENTE TERRITORIAL') LIMIT 50"); 
            $sql->bind_param('i',$dc);
            $sql->execute();
            $sql->store_result();
            $sql->bind_result(
                $MatriculaRow,
                $JefeVentaRow
                );
        
            if ($sql->num_rows> 0) {
                while ($sql->fetch()) {
                    $Matricula = $MatriculaRow;
                    $JefeVenta = $JefeVentaRow;
                    if($Matricula==$matjefe){
                           $html .= '<option value="'.$Matricula.'" selected>'.$Matricula.' - '.utf8_encode($JefeVenta).' </option>';
                    }else{
                        $html .= '<option value="'.$Matricula.'">'.$Matricula.' - '.utf8_encode($JefeVenta).' </option>';
                    }
                }
            }else{
                 $html .= '<option>No se encontraron resultado</option>';
            }
        
    } catch(\Exception $e) {
        $respuesta = array(
        'respuesta' => 'error'
        );
        
    }

    $html_tecnico=NULL;

    
        if($lninstalador=="" || empty($lninstalador)){
            $html_tecnico.= '<option></option>';
        }else{
            try {
                $sql_tecnico = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador FROM dbUSUARIO.tblusuario u INNER JOIN dbUSUARIO.tblarea a on a.IdArea=u.IdArea WHERE u.LN=?"); 
                $sql_tecnico->bind_param('i',$lninstalador);
                $sql_tecnico->execute();
                $sql_tecnico->store_result();
                $sql_tecnico->bind_result(
                    $Matricularow,
                    $Instaladorow
                );

                if ($sql_tecnico->num_rows > 0) {
                    while ($sql_tecnico->fetch()) { 
                        $matricula = $Matricularow;
                        $Instalado = $Instaladorow;               
                        if($matricula==$matriculatec){
                           $html_tecnico.= '<option value="'.$matricula.'" selected>'.$matricula.' - '.utf8_encode($Instalado).' </option>';
                        }else{
                        $html_tecnico.= '<option value="'.$matricula.'">'.$matricula.' - '.utf8_encode($Instalado).' </option>';
                        }
                    }
                }else{
                     $html_tecnico.= '<option>No se encontraron resultado</option>';
                }
            } catch(\Exception $e) {
                $respuesta = array(
                'respuesta' => 'error'
                );
                
            }    
        }
    
    
    $cantidadreferido=0;

    if($referidoHabilitado=="SI"){
        try {
            $sqlreferido = $con->prepare("SELECT COUNT(ref.IdProspectoRP) CantidadReferido FROM dbREFERIDO.tblreferido ref INNER JOIN dbREFERIDO.tblreferido_detalle detref on ref.Id= detref.Referido_ID WHERE ref.IdProspectoRP=? and ref.TipoVenta=?");  
            $sqlreferido->bind_param('is',$idprospectorp,$tipoventa);
            $sqlreferido->execute();
            $sqlreferido->store_result();
            $sqlreferido->bind_result(
                $CantidadReferidoRow
            );
        
            if ($sqlreferido->num_rows > 0) {
                while ($sqlreferido->fetch()) {     
                    $cantidadreferido=$CantidadReferidoRow;
                }
            }else{
                 $cantidadreferido=0;
            }
        } catch(\Exception $e) {
        $respuesta = array(
        'respuesta' => 'error'
        );
        
        }    
    }
    
    $IteraccionAttec = 0;
    
// INFORMACION PARA GUIA $ncontrato

$contrato_presente = 1;
if($ncontrato == ''){
    $numeroContrato = 999999999;
}else{
    $numeroContrato = $ncontrato;
}

// $ncontrato = $ncontrato =''?12345567789:$ncontrato;
    $stmtsqlguia = $con->prepare("SELECT contrato FROM dbGUIAREMISION.guia where contrato=? AND contrato_presente  = ?"); 
    $stmtsqlguia->bind_param('si',$numeroContrato,$contrato_presente);
    $stmtsqlguia->execute();
    $stmtsqlguia->store_result();
    $stmtsqlguia->bind_result(
        $contratoRow
        );
    
    if ($stmtsqlguia->num_rows> 0) {
        $icono = 'fa-check';
        $colorGuia = 'btn-success';
        $estadoGuia = 'Guia Emitida';
        $estadoGuiaRemision = 'guiaEmitida';
    }else{
        $icono = 'fa-exclamation-circle';
        $colorGuia = 'btn-danger';
        $estadoGuia = 'Guia Pendiente';
        $estadoGuiaRemision = 'guiaPendiente';
    }
    
?>

<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
       <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <!-- Bootstrap toogle-->
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
        <!-- Bootstrap toogle-->
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
         <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css"/>
         <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
        <script src="admin/bower_components/moment/modernizr-custom.js" type="text/javascript"></script>
        <!-- LEAFLET -->
        <link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css"
           integrity="sha512-xodZBNTC5n17Xt2atTPuE1HxjVMSvLVW9ocqUKLsCC5CXdbqCmblAshOMAS6/keqq/sMZMZ19scR4PsZChSR7A=="
           crossorigin=""/>
        <link rel="stylesheet" href="lib/leaflet_AwesomeMarkers/dist/leaflet.awesome-markers.css">
 
        <style>
            #map { height: 400px; }
            
            .ocultar {
                display: none;
            }

            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;              
            }
            
            #frmEditarVenta .clsreadonly{
                background-color: #fff;
                cursor: pointer;
            }

            .preloader{
                background-color:#FFF;
                width: 100%;
                height: 100%;
                position: absolute;
                z-index: 1;
            }

            .dataTables_wrapper .myfilter .dataTables_filter{float:left}
            .dataTables_wrapper .mylength .dataTables_length{float:right}
            div.dataTables_scrollBody thead th {
                vertical-align: top;
            } 
            td {
                max-width: 250px;
                overflow: hidden;
                white-space: nowrap;
                text-overflow: ellipsis;

            }
            .espacio{
                height:10px;
            }
            
           .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #frmEditarVenta .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }
            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo { 
                color: #FFFFFF; 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                color: #FFFFFF; 
                background-color: #616161;  
                border-color: #444444; 
            } 

            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                background-image: none; 
            } 

            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
                background-color: #444444; 
                border-color: #444444; 
            } 
            

            input[type=number]::-webkit-outer-spin-button,
            
            input[type=number]::-webkit-inner-spin-button {
            
                -webkit-appearance: none;
            
                margin: 0;
            
            }
            
             
            
            input[type=number] {
            
                -moz-appearance:textfield;
            
            }
        </style>
        
        <style>
            .main-header,.main-sidebar,.left-side{
                position:fixed
            }
       
            .main-header {
                top: 0;
                right: 0;
                left: 0
            }
            
            .content-wrapper, .right-side {
                padding-top: 50px
            }

            @media (max-width:767px) {
                .content-wrapper, .right-side {
                    padding-top: 100px
                }
            }

            .layout-boxed .wrapper {
                max-width: 100%
            }

            .wrapper {
                overflow: hidden
            }
            .control-sidebar {
                position: fixed;
                height: 100%;
                overflow-y: auto;
                padding-bottom: 50px
            }       
        </style>
     
        <style>
            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                   -moz-border-radius: 5px;
                        border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                   -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        
                    z-index: 1051 !important;    
            }
            
            hr {
              height: 4px;
              width: 100%;
              background-color: #ecf0f5;
            }
            
            hr {
                /* margin-top: 20px; */
                margin-bottom: 20px;
                border: 0;
                /* border-top: 1px solid #eee; */
            }
            
            hr {
                display: block;
                unicode-bidi: isolate;
                -webkit-margin-before: 0.5em;
                -webkit-margin-after: 0.5em;
                -webkit-margin-start: auto;
                -webkit-margin-end: auto;
                overflow: hidden;
                border-style: inset;
               
            }

            .box.box-custom {
                border-top-color: #ffffff;
            }

            .box {
                position: relative;
                border-radius: 3px;
                background: #ffffff;
                border-top: 3px solid #d2d6de;
                margin-bottom: 5px;
                width: 100%;
                box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            }

        </style>
        
        <style>
            .readonly_blanco {
                background-color: #fff!important;
            }
        </style>
        
        <style>
           #header-decision{
                height: auto;
                width: 100%;
                padding-top: 25px;
                padding-bottom: 25px;
            }

            #header-decision span{
              line-height: 40px;
              font-size: 18px;
            }

            .barra-informacion{
              background: rgb(82, 87, 88);
              color: white;
              padding: 0 2rem;
            
            }

            .barra-informacion ul{
              display: flex;
              justify-content: space-between;
              list-style: none;
              padding: 22px 55px;
              margin-bottom: 10px;
            }

            .barra-informacion a{
              text-decoration: none;
              color: white;
              font-weight: 600;
            }

            .main-contenido{
              display: flex;
              justify-content: space-between;
              flex-wrap: wrap;
              padding: 8rem 2rem;
            }

            .contenido-solicitante {
                padding: 0 5rem 0 5rem;
            }

            @media (min-width: 768px){
               .contenido-solicitante{
                flex-basis: calc(40% - 2rem);
              }
            
                .contenido-score{
                flex-basis: 60%;
              }
            }

            .contenido-solicitante-info{
              display: flex;
              align-items: center;
            }
            
            .icono{
              padding-right: 10px;
            }
            
            .icono i{
              font-size: 4.2rem;
              line-height: 3.8rem;
            }
            
            .info{
              line-height: 1.5rem;
              display: table-cell;
              vertical-align: top;
            }

            .score-conclusion strong{
            font-weight: 700;
            
            }
            
            #divLoading {
              background: rgba(66,118,164,0.4);
              width: 100%;
              height: 100%;
              min-height: 100%;
              position: absolute;
              top: 0;
              left: 0;
              z-index: 999999999;
              display:none;
            }

            .spinner {
              margin: 300px auto 0;
              width: 70px;
              text-align: center;
            }
            
            .spinner > div {
              background-color: #e4002b;
              width: 18px;
              height: 18px;
              border-radius: 100%;
              display: inline-block;
              -webkit-animation: sk-bouncedelay 1.4s infinite ease-in-out both;
              animation: sk-bouncedelay 1.4s infinite ease-in-out both;
            }
            
            .spinner .bounce1 {
              -webkit-animation-delay: -0.32s;
              animation-delay: -0.32s;
            }
            
            .spinner .bounce2 {
              -webkit-animation-delay: -0.16s;
              animation-delay: -0.16s;
            }

            @-webkit-keyframes sk-bouncedelay {
              0%, 80%, 100% { -webkit-transform: scale(0) }
              40% { -webkit-transform: scale(1.0) }
            }
            
            @keyframes sk-bouncedelay {
              0%, 80%, 100% {
                -webkit-transform: scale(0);
                transform: scale(0);
              } 40% {
                -webkit-transform: scale(1.0);
                transform: scale(1.0);
              }
            }
            
            .centrar-texto {
                text-align: center;
            }
            
            .m_get_started.fix {
                height: 100%;
                padding: 0;
                text-align: center;
                opacity: 1;
            }

            .callout {
                border-radius: 3px;
                margin: 0 0 20px 0;
                padding: 15px 30px 15px 15px;
                border-left: 5px solid #f03;
                -webkit-box-shadow: 10px 10px 5px -9px rgba(0,0,0,0.75);
                -moz-box-shadow: 10px 10px 5px -9px rgba(0,0,0,0.75);
                box-shadow: 10px 10px 5px -9px rgba(0,0,0,0.75);
            }
            .bg-deuda{
                color: #000;
                background-color: #ffffff !important;
            }
            
            .bg-visita{
                color: #fff;
                background-color: #008000 !important;
            }
            .bg-gestion{
             color: #fff;
            background-color: #6a6659 !important;   
            }
            .bg-televenta{
                color: #fff;
                background-color: #f39c12 !important;
            }

            input#nombres { text-transform: uppercase; }
            input#apellido_p { text-transform: uppercase; }
            input#apellido_m { text-transform: uppercase; }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }
            
            select + span.select2:focus, select + span.select2 *:focus { 	outline-color: #7d3c8c; 	outline-width: 1px; }
                       .select2-container--default.select2-container--focus, .select2-selection.select2-container--focus, .select2-container--default:focus, .select2-selection:focus, .select2-container--default:active, .select2-selection:active {
                outline: none;
                border: 1px solid #3c8dbc;
                border-radius: 4px;
            } 
            
           .btn-verisure{
                font-family: "Avenir Next LT W01 Demi", sans-serif;
                font-weight: normal !important;
                font-style: normal !important;
                box-sizing: border-box;
                -moz-box-sizing: border-box;
                font-size: 15px;
                color: #EE0008;
                border: 1px solid #eb3e3e;
                border-radius: 40px;
                display: inline-block;
                /*padding: 15px 24px 15px 44px;*/
                text-decoration: none;
                text-align: center;
                line-height: 28px;
                text-transform: uppercase;
            }
             
            .btn-verisure { 
            color: #ffffff; 
            background-color: #FF0033; 
            border-color: #FF0033; 
            } 
 
            .btn-verisure:hover, 
            .btn-verisure:focus, 
            .btn-verisure:active, 
            .btn-verisure.active, 
            .open .dropdown-toggle.btn-verisure { 
              color: #ffffff; 
              background-color: #a62828; 
              border-color: #a62828; 
            } 
 
            .btn-verisure:active, 
            .btn-verisure.active, 
            .open .dropdown-toggle.btn-verisure { 
              background-image: none; 
            } 
             
            .btn-verisure.disabled, 
            .btn-verisure[disabled], 
            fieldset[disabled] .btn-verisure, 
            .btn-verisure.disabled:hover, 
            .btn-verisure[disabled]:hover, 
            fieldset[disabled] .btn-verisure:hover, 
            .btn-verisure.disabled:focus, 
            .btn-verisure[disabled]:focus, 
            fieldset[disabled] .btn-verisure:focus, 
            .btn-verisure.disabled:active, 
            .btn-verisure[disabled]:active, 
            fieldset[disabled] .btn-verisure:active, 
            .btn-verisure.disabled.active, 
            .btn-verisure[disabled].active, 
            fieldset[disabled] .btn-verisure.active { 
              background-color: #555758; 
              border-color: #555758; 
            } 
             
            .btn-verisure .badge { 
              color: #FF0033; 
              background-color: #ffffff; 
            }

            .btn-verisurecerrar{
                font-family: "Avenir Next LT W01 Demi", sans-serif;
                font-weight: normal !important;
                font-style: normal !important;
                box-sizing: border-box;
                -moz-box-sizing: border-box;
                font-size: 15px;
                color: #444;
                border: 1px solid #ddd;
                border-radius: 40px;
                display: inline-block;
                /*padding: 15px 24px 15px 44px;*/
                text-decoration: none;
                text-align: center;
                line-height: 28px;
                text-transform: uppercase;
            }
                         
               
            .btn-verisurecerrar { 
                background-color: #f4f4f4;
                color: #444;
                border-color: #ddd;
            } 
 
            .btn-verisurecerrar:hover, 
            .btn-verisurecerrar:focus, 
            .btn-verisurecerrar:active, 
            .btn-verisurecerrar.active, 
            .open .dropdown-toggle.btn-verisurecerrar { 
                color: #333;
                background-color: #e6e6e6;
                border-color: #adadad;
            } 
 
            .btn-verisurecerrar:active, 
            .btn-verisurecerrar.active, 
            .open .dropdown-toggle.btn-verisurecerrar { 
              background-image: none; 
            } 
             
            .btn-verisurecerrar.disabled, 
            .btn-verisurecerrar[disabled], 
            fieldset[disabled] .btn-verisurecerrar, 
            .btn-verisurecerrar.disabled:hover, 
            .btn-verisurecerrar[disabled]:hover, 
            fieldset[disabled] .btn-verisurecerrar:hover, 
            .btn-verisurecerrar.disabled:focus, 
            .btn-verisurecerrar[disabled]:focus, 
            fieldset[disabled] .btn-verisurecerrar:focus, 
            .btn-verisurecerrar.disabled:active, 
            .btn-verisurecerrar[disabled]:active, 
            fieldset[disabled] .btn-verisurecerrar:active, 
            .btn-verisurecerrar.disabled.active, 
            .btn-verisurecerrar[disabled].active, 
            fieldset[disabled] .btn-verisurecerrar.active { 
              background-color: #e7e7e7; 
            } 
             
            .btn-verisurecerrar .badge { 
                background-color: #f4f4f4;
                color: #444;
            }
                    
            
            .swal2-popup {
                font-size: 1.5rem!important;
            } 

            label {
                font-weight: 400;
                font-size: 12px;
            }
            .subtitulo{
                text-decoration: underline;
                font-weight: bold;
            }            

        </style>
        
    </head>

    <body class="sidebar-collapse skin-red sidebar-mini">
      <div id="divLoading" style="display: none;height: auto; min-height: 100%;">
        <div class="spinner">
          <div class="bounce1"></div>
          <div class="bounce2"></div>
          <div class="bounce3"></div>
        </div>
     </div>
        
        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php

                $consultaventa="active";

                include 'admin/main-sidebar.php';
            ?>


            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-md-2"></div>
                        <div class="col-md-8">
                            <!-- /.box-header -->
                            <div class="box box-danger">
                                <div class="box-header">
                                     <div class="form-horizontal">
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <h3 class="col-sm-12 col-xs-12 box-title" style="text-align:left;">EDITAR</h3>
                                                        <div class="col-sm-12 col-xs-12">
                                                    <h3 class="box-title">
                                                    <select name="lblcategoria" id="lblcategoria" style="border:none;-moz-appearance:none;-webkit-appearance:none;-ms-appearance:none;-o-appearance:none;">  
                                                        <?php if($categoriaventa=="ProspectoRP"){?>
                                                            <option value="ProspectoRP"<?php if ($categoriaventa == "ProspectoRP") {echo "selected";}?>>NUEVO PROSPECTO RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="Online"<?php if ($categoriaventa == "Online") {echo "selected";}?> hidden="">VENTA ONLINE - <?php echo $idprospectorp; ?></option>
                                                            <option value="Ficha"<?php if ($categoriaventa == "Ficha") {echo "selected";}?>>VENTA FICHA - <?php echo $idprospectorp; ?></option>
                                                            <option value="Delegacion"<?php if ($categoriaventa == "Delegacion") {echo "selected";}?>>VENTA DELEGACIÓN - <?php echo $idprospectorp; ?></option>
                                                            <option value="NoVendida"<?php if ($categoriaventa == "NoVendida") {echo "selected";}?> hidden="">NO VENDIDA - <?php echo $idprospectorp; ?></option>
                                                            <option value="Cancelada"<?php if ($categoriaventa == "Cancelada") {echo "selected";}?> hidden="">CANCELADA - <?php echo $idprospectorp; ?></option>
                                                        <?php }elseif($categoriaventa=="VRPAsignada"){?>
                                                            <option value="VRPAsignada"<?php if ($categoriaventa == "VRPAsignada") {echo "selected";}?> hidden="">VISITA ASIGNADA RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="Ficha"<?php if ($categoriaventa == "Ficha") {echo "selected";}?>>VENTA FICHA - <?php echo $idprospectorp; ?></option>
                                                            <option value="Delegacion"<?php if ($categoriaventa == "Delegacion") {echo "selected";}?>>VENTA DELEGACIÓN - <?php echo $idprospectorp; ?></option>
                                                            <option value="NoVendida"<?php if ($categoriaventa == "NoVendida") {echo "selected";}?> >NO VENDIDA - <?php echo $idprospectorp; ?></option>
                                                        <?php }elseif($categoriaventa=="Ficha" || $categoriaventa=="Delegacion" || $categoriaventa=="NoVendida" || $categoriaventa=="Cancelada"){?>
                                                            <option value="Online"<?php if ($categoriaventa == "Online") {echo "selected";}?> hidden="">VENTA ONLINE - <?php echo $idprospectorp; ?></option>
                                                            <option value="Ficha"<?php if ($categoriaventa == "Ficha") {echo "selected";}?>>VENTA FICHA - <?php echo $idprospectorp; ?></option>
                                                            <option value="Delegacion"<?php if ($categoriaventa == "Delegacion") {echo "selected";}?>>VENTA DELEGACIÓN - <?php echo $idprospectorp; ?></option>
                                                            <option value="NoVendida"<?php if ($categoriaventa == "NoVendida") {echo "selected";}?> hidden="">NO VENDIDA - <?php echo $idprospectorp; ?></option>
                                                            <option value="Cancelada"<?php if ($categoriaventa == "Cancelada") {echo "selected";}?> hidden="">CANCELADA - <?php echo $idprospectorp; ?></option>   
                                                        <?php }else{?>
                                                            <option value="VisitaAceptada"<?php if ($categoriaventa == "VisitaAceptada") {echo "selected";}?> disabled="" hidden="" >GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="NoAceptaVisita"<?php if ($categoriaventa == "NoAceptaVisita") {echo "selected";}?> disabled="" hidden="" >GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="DevolverLlamada"<?php if ($categoriaventa == "DevolverLlamada") {echo "selected";}?> disabled="" hidden="" >GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="NoContesta"<?php if ($categoriaventa == "NoContesta") {echo "selected";}?> disabled="" hidden="">GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="ClienteError"<?php if ($categoriaventa == "ClienteError") {echo "selected";}?>disabled="" hidden="" >GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="TelefonoError"<?php if ($categoriaventa == "TelefonoError") {echo "selected";}?>disabled="" hidden="" >GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="ZSCC"<?php if ($categoriaventa == "ZSCC") {echo "selected";}?> disabled="" hidden="">GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="Provincia"<?php if ($categoriaventa == "Provincia") {echo "selected";}?>disabled="" hidden="">GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="Inviable"<?php if ($categoriaventa == "Inviable") {echo "selected";}?>disabled="" hidden="" >GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="Rechazada"<?php if ($categoriaventa == "Rechazada") {echo "selected";}?>disabled="" hidden="">GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="AnuladaOP"<?php if ($categoriaventa == "AnuladaOP") {echo "selected";}?>disabled="" hidden="" >GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="AnuladaCLI"<?php if ($categoriaventa == "AnuladaCLI") {echo "selected";}?>disabled="" hidden="">GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="AnuladaTEC"<?php if ($categoriaventa == "AnuladaTEC") {echo "selected";}?>disabled="" hidden="">GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="ClienteVerisure"<?php if ($categoriaventa == "ClienteVerisure") {echo "selected";}?>disabled="" hidden="">GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                        <?php }?>
                                                    </select>
                                                </h3>
                                                <input id="lblcat" name="lblcat" value="<?php echo $categoriaventa;?>" hidden="">
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                </div>   
                                    <div class="box-tools pull-right">
                                        <a class="btn <?php echo $colorGuia; ?> btn-md" id="estadoGuia" href="#"><i class="fa <?php echo $icono; ?>"></i> <?php echo $estadoGuia; ?></a>
                                        <input type="hidden" class="form-control" id="estadoGuiaRemision" name="estadoGuiaRemision" value="<?php echo htmlspecialchars($estadoGuiaRemision);?>">
                                        <?php 
                                            if($categoriaventa=="ProspectoRP"){
                                                if($dc=="154"||$dc=="156"){
                                                    if($InfoCheckInRP == ''){
                                        ?>
                                                        <button class="btn btn-warning btn-sm" id="btnCheckIn" data-toggle="modal" data-target="#modal-checkin"><i class="fa fa-map-marker"></i></button>
                                        <?php   
                                                    }
                                                }  //END IF CC
                                            } //END IF CATEGORIA VENTA 
                                            if($estadoventa=='Facturada' || $nombacceso=='test'){ }else{ 
                                        ?>
                                                <a class="btn btn-nuevo btn-sm" id="btnGuardarEditarVenta" href="#"><i class="fa fa-save"></i></a>
                                        <?php   
                                            } 
                                        ?>
                                         <a href="consultaventa.php" class="btn btn-danger btn-sm" ><i class="fa fa-reply"></i> </a>
                                    </div>
                                </div>
                            </div>
                            <form id="frmEditarVenta" method="POST">
                                <!--INFORMACION DEL COMERCIAL -->
                                <div class="box box-custom">
                                    <!-- box-header -->
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACION DEL COMERCIAL</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <!-- box-body -->
                                    <div class="box-body">
                                        <div class="form-horizontal">
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblmatricula">MATRICULA: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                   <input name="lblmatricula" id="lblmatricula" class="form-control input-sm" value="<?php echo $matricula;?>" style="width: 100%;" readonly="readonly">
                                                    <input id="lblidusuario" name="lblidusuario" value="<?php echo $idu;?>" hidden="">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcomercial">COMERCIAL: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input name="lblnombcomercial" id="lblnombcomercial" class="form-control input-sm" style="width: 100%;" value="<?php echo $comercial;?>" readonly="readonly" >
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lbldc">DC: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lbldc" id="lbldc" style="width: 100%;">
                                                        <option>Seleccione</option>
                                                        <?php if ($dc == "150") { ?>
                                                            <option value="150" <?php if ($dc == "150") {echo "selected";}?>>150</option>
                                                        <?php }else if($dc == "151") { ?>
                                                           <option value="151" <?php if ($dc == "151") {echo "selected";}?>>151</option>
                                                        <?php }else if ($dc == "152") { ?>
                                                               <option value="152" <?php if ($dc == "152") {echo "selected";}?>>152</option>
                                                        <?php }else if($dc == "153") { ?>
                                                         <option value="153" <?php if ($dc == "153") {echo "selected";}?>>153</option>
                                                        <?php }else if ($dc == "154") { ?>
                                                          <option value="154" <?php if ($dc == "154") {echo "selected";}?>>154</option>
                                                        <?php }else if($dc == "155") { ?>
                                                              <option value="155" <?php if ($dc == "155") {echo "selected";}?>>155</option>
                                                        <?php }else if($dc == "156") { ?>
                                                              <option value="156" <?php if ($dc == "156") {echo "selected";}?>>156</option>
                                                        <?php }else if($dc == "157") { ?>
                                                              <option value="157" <?php if ($dc == "157") {echo "selected";}?>>157</option>
                                                        <?php }else if($dc == "158") { ?>
                                                              <option value="158" <?php if ($dc == "158") {echo "selected";}?>>158</option>
                                                        <?php }else if($dc == "159") { ?>
                                                            <option value="159" <?php if ($dc == "159") {echo "selected";}?>>159</option>       
                                                        <?php }else if($dc == "140") { ?>
                                                            <option value="140" <?php if ($dc == "140") {echo "selected";}?>>140</option>
                                                        <?php }else if($dc == "141") { ?>
                                                              <option value="141" <?php if ($dc == "141") {echo "selected";}?>>141</option>
                                                        <?php }else if ($dc == "200") { ?>
                                                            <option value="200" <?php if ($dc == "200") {echo "selected";}?>>200</option>      
                                                        <?php }else if ($dc == "120") { ?>
                                                            <option value="120" <?php if ($dc == "120") {echo "selected";}?>>120</option>
                                                        <?php }else if ($dc == "100") { ?>
                                                            <option value="100" <?php if ($dc == "100") {echo "selected";}?>>100</option>
                                                        <?php }else if($dc == "80") { ?>
                                                              <option value="80" <?php if ($dc == "80") {echo "selected";}?>>80</option>
                                                        <?php }else if ($dc == "40") { ?>
                                                            <option value="40" <?php if ($dc == "40") {echo "selected";}?>>40</option>
                                                        <?php }else if ($dc == "41") { ?>
                                                            <option value="41" <?php if ($dc == "41") {echo "selected";}?>>41</option>
                                                        <?php }else if ($dc == "42") { ?>
                                                            <option value="42" <?php if ($dc == "42") {echo "selected";}?>>42</option>                                                            
                                                        <?php }else if ($dc == "511") { ?>
                                                          <option value="511" <?php if ($dc == "511") {echo "selected";}?>>511</option>
                                                          <?php }else if ($dc == "512") { ?>
                                                          <option value="512" <?php if ($dc == "512") {echo "selected";}?>>512</option>
                                                          <?php }else if ($dc == "513") { ?>
                                                          <option value="513" <?php if ($dc == "513") {echo "selected";}?>>513</option>                                                          
                                                        <?php }else if ($dc == "500") { ?>
                                                          <option value="500" <?php if ($dc == "500") {echo "selected";}?>>500</option>
                                                        <?php }else if ($dc == "599") { ?>
                                                          <option value="599" <?php if ($dc == "599") {echo "selected";}?>>599</option>
                                                        <?php }else if ($dc == "121") { ?>
                                                          <option value="121" <?php if ($dc == "121") {echo "selected";}?>>121</option>
                                                        <?php }else if ($dc == "250") { ?>
                                                          <option value="250" <?php if ($dc == "250") {echo "selected";}?>>250</option>
                                                        <?php }else if ($dc == "251") { ?>
                                                          <option value="251" <?php if ($dc == "251") {echo "selected";}?>>251</option>
                                                        <?php }else if ($dc == "252") { ?>
                                                          <option value="252" <?php if ($dc == "252") {echo "selected";}?>>252</option>
                                                        <?php }else if ($dc == "20") { ?>
                                                          <option value="20" <?php if ($dc == "20") {echo "selected";}?>>20</option>
														<?php } else if ($dc == "601") { ?>
														<option value="601" <?php if ($dc == "601") {echo "selected";}?>>601</option>
														<?php } else if ($dc == "701") { ?>
														<option value="701" <?php if ($dc == "701") {echo "selected";}?>>701</option>
														<?php } else if ($dc == "702") { ?>
														<option value="702" <?php if ($dc == "702") {echo "selected";}?>>702</option>
														<?php } else if ($dc == "901") { ?>
														<option value="901" <?php if ($dc == "901") {echo "selected";}?>>901</option> 
                                                        <?php } else if ($dc == "711") { ?>
        												<option value="711" <?php if ($dc == "711") {echo "selected";}?>>711</option> 
        												<?php } else if ($dc == "713") { ?>
        												<option value="713" <?php if ($dc == "713") {echo "selected";}?>>713</option>  
														<?php } else if ($dc == "130") { ?>
														<option value="130" <?php if ($dc == "130") {echo "selected";}?>>130</option>    
														<?php } else if ($dc == "230") { ?>
														<option value="230" <?php if ($dc == "230") {echo "selected";}?>>230</option>

														<?php } else if ($dc == "602") { ?>
														<option value="602" <?php if ($dc == "602") {echo "selected";}?>>602</option>
														
														<?php } else if ($dc == "60") { ?>
														<option value="60" <?php if ($dc == "60") {echo "selected";}?>>60</option>  														
														
                                                        <?php }else { ?>
                                                        <option value="" selected></option>
                                                        <?php }?>
                                                    </select>
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lbljefeventa" style="text-align:left;">JEFE VENTA: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                     <select class="form-control input-sm" name="lbljefeventa" id="lbljefeventa" style="width: 100%;">
                                                        <?php echo $html;?>
                                                    </select> 
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                        </div>
                                    </div>
                                    <!-- /.box-body -->
                                </div>
                                <!--INFORMACION DEL CLIENTE -->
                                <div class="box box-custom">
                                        <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                            <h5>INFORMACION DEL CLIENTE</h5>
                                            <div class="box-tools pull-right">
                                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                                </button>
                                            </div>
                                        </div>
                                        <!-- /.box-header -->
                                        <div class="box-body">
                                             <div class="form-horizontal">
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcliente">CLIENTE: <span style="color:red"> * </span></label>
                                                            <div class="col-sm-8 col-xs-8">
                                                        <input name="lblnombcliente" class="form-control input-sm" id="lblnombcliente" value="<?php echo $cliente;?>" style="width: 100%;"/>
                                                        <input id="lblidcliente" name="lblidcliente" value="<?php echo $idcliente;?>" hidden="">
                                                         </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">CORREO: <span style="color:red"> * </span></label>
                                                            <div class="col-sm-8 col-xs-8">
                                                            <input type="text"  class="form-control input-sm" id="lblcorreo" value="<?php echo $correo;?>" name="lblcorreo">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lbldireccion">DIRECCIÓN: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <textarea class="form-control input-sm" name="lbldireccion" id="lbldireccion" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $direccion;?></textarea>
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lbldistrito" style="text-align:left;">DISTRITO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control selectdistrito input-sm" name="lbldistrito" id="lbldistrito" style="width: 100%;">
                                                            <option value="<?php echo $idgeografico; ?>"><?php echo $distrito.' - '.$provincia; ?></option>
                                                        </select>
                                                        <input id="lblIdProvincial" name="lblIdProvincial" value="<?php echo $IdProvincial; ?>" hidden="" />
                                                        <input id="lblIdDepartamental" name="lblIdDepartamental" value="<?php echo $IdDepartamental; ?>" hidden="" />
                                                        <input id="lblCodUbigeoReniec" name="lblCodUbigeoReniec" value="<?php echo $CodUbigeoReniec; ?>" hidden="" />
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                               
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblsegmento">SEGMENTO: <span style="color:red"> * </span></label>
                                                            <div class="col-sm-8 col-xs-8">
                                                               <select class="form-control input-sm" name="lblsegmento" id="lblsegmento">
                                                            <option>Seleccione</option>
                                                            <option value="RES"<?php if ($segmento == "RES") {echo "selected";}?>>RES</option>
                                                            <option value="NEG"<?php if ($segmento == "NEG") {echo "selected";}?>>NEG</option>
                                                        </select>
                                                            </div>
                                                        </div>
                                                   </div>
                                                   <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblsims">PRIORIDAD SIMS: <span style="color:red"> * </span></label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <input name="lblsims" class="form-control input-sm" id="lblsims" value="<?php echo $sims; ?>" style="width: 100%;" disabled />
                                                            </div>
                                                        </div>
                                                    </div>
                                                
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblmovil">TELEFONO UNO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="tel" class="form-control input-sm" name="lblmovil" id="lblmovil" value="<?php echo $movil;?>"  data-inputmask='"mask": "999999999"'  data-mask readonly>
                                                        
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblfijo" style="text-align:left;">TELEFONO DOS:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="tel" class="form-control input-sm" name="lblfijo" id="lblfijo" value="<?php echo $fijo;?>" data-inputmask='"mask": "999999999"'  data-mask>  
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                
                                        </div>
                                           
                                        </div>
                                        <!-- /.box-body -->
                                </div>
                                <!-- INFORMACION DE LA VISITA -->
                                <?php
                                    //VALIDA SI LA VISITA SE ENCUENTRA EN CATEGORIA VRPAASIGNADA (VIENE DE CALL RP) O ES UNA VISITA CONCERTADA. 
                                    if ($categoriaventa == 'VRPAsignada' || $categoriaventa=="Ficha" || $categoriaventa=="Delegacion" || $categoriaventa=="NoVendida" || $categoriaventa=="Cancelada")  { 
                                ?>   
                                    <div class="box box-custom">
                                        <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                            <h5>INFORMACION DE LA VISITA</h5>
                                            
                                            <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                            </button>
                                            
                                            </div>
                                        </div>
                                        <div class="box-body">
                                            <table cellspacing="0"  style="width:100%;padding: 15px;">
                                                <tr>
                                                    <td style="width:15%;font-size: 12px"><span class="lblvervisita">MES VISITA: <span style="color:red"> * </span></span></td>
                                                    <td style="width:55%">
                                                        <div class="lblvervisita">
                                                            <input name="lblmesvisita" class="form-control input-sm" id="lblmesvisit" value="<?php if(isset($mesvisita)){ echo $mesvisita;}else{echo $fechames;}?>" style="width: 100%;" disabled />
                                                        </div>    
                                                    </td>
                                                </tr>
                                 
                                                <tr class="espacio"></tr>
                                                <tr>
                                                    <td style="width:15%;font-size: 12px">FECHA VISITA: <span style="color:red"> * </span></td>
                                                    <td style="width:55%"> 
                                                        <div class="input-group" style="width: 100%">
                                                             <input type="text" class="form-control" id="fechaVisitaConcertada" name="fechaVisitaConcertada" value="<?php echo $fvisita;?>" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask="" disabled>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr class="espacio"></tr>
                                                <tr>
                                                    <td style="width:15%;font-size: 12px">HORA VISITA: <span style="color:red"> * </span></td>
                                                    <td style="width:55%">
                                                        <div class="bootstrap-timepicker timepicker">
                                                            <div class="input-group" style="width: 100%">
                                                                <input type="text" id="horaVisitaConcertada" name="horaVisitaConcertada" value="<?php echo $hvisita;?>" class="form-control timepicker" disabled>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr class="espacio"></tr>
                                                <tr>
                                                    <td style="width:15%;font-size: 12px">COMENTARIO CALL RP: <span style="color:red"> * </span></td>
                                
                                                    <td colspan="5" style="width:55%"><textarea class="form-control input-sm" name="lblcomentariocallrp" id="lblcomentariocallrp" rows="2" style="resize:none" placeholder="Ingresar..." disabled><?php echo $comentariocallrp;?></textarea></td>
                                                </tr>
                                
                                            </table>
                                        </div>
                                    </div>      
                                <?php 
                                   }
                                    if($categoriaventa=="ProspectoRP"){
                                ?>
                                    <div class="box box-custom">
                                        <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                            <h5>INFORMACION DE LA VISITA</h5>  
                                            <div class="box-tools pull-right">
                                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                            </div>
                                        </div>
                                        <div class="box-body">

                                            
                                            <div class="form-horizontal">
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblmatricula">VISITA CONCERTADA:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                   <input type="checkbox" name="visitaConcertada" id="visitaConcertada" <?php if($VisitaConcertada=="SI"){echo 'checked';} else{echo '';}?> data-size="small"/>
                                                    <input type="hidden" name="hidVisitaConcertada" id="hidVisitaConcertada" value="<?php echo $VisitaConcertada; ?>"/>
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group datosVisitaConcertada <?php if($VisitaConcertada=="SI"){echo '';} else{echo 'ocultar';}?>" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="fechaVisitaConcertada">FECHA VISITA:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                   <div class="input-group">
                                                    <input type="text" class="form-control" id="fechaVisitaConcertada" name="fechaVisitaConcertada" value="<?php echo $fvisita;?>" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask="">
                                
                                                    <div class="input-group-addon">
                                                      <i class="fa fa-calendar"></i>
                                                    </div>
                                                </div>
                                                    
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lbljefeventa" style="text-align:left;">HORA VISITA: </label>
                                                        <div class="col-sm-8 col-xs-8">
                                                         <div class="input-group">
                                                        <input type="text" id="horaVisitaConcertada" name="horaVisitaConcertada" value="<?php echo $hvisita;?>" class="form-control timepicker">
                                    
                                                        <div class="input-group-addon">
                                                          <i class="fa fa-clock-o"></i>
                                                        </div>
                                                    </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                        </div>
                                            
                                            
                                        </div>
                                    </div>
                                <?php
                                   } //END IF CATEGORIA IGUAL A PROSPECTORP
                                ?>
                                <div class="box box-custom">
                                        <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                            <h5>INFORMACION DE REFERIDO</h5>  
                                            <div class="box-tools pull-right">
                                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                            </div>
                                        </div>
                                        <div class="box-body">

                                            
                                            <div class="form-horizontal">
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="referidoHabilitado">¿CLIENTE BRINDÓ REFERIDO?:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                         <select class="form-control input-sm" name="referidoHabilitado" id="referidoHabilitado">
                                                            <option value="" disabled selected>Seleccione</option>
                                                            <option value="SI" <?php if ($referidoHabilitado == "SI") {echo "selected";}?>>SI</option>
                                                            <option value="NO"<?php if ($referidoHabilitado == "NO") {echo "selected";}?>>NO</option>
                                                        </select>
                                                        <input type="hidden" name="hidreferidoHabilitado" id="hidreferidoHabilitado" value="<?php echo $referidoHabilitado; ?>"/>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="cantidadreferidoHabilitado" style="text-align:left;">CANTIDAD REFERIDO: </label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <input type="text" class="form-control" id="cantidadreferidoHabilitado" name="cantidadreferidoHabilitado" value="<?php echo $cantidadreferido;?>"  readonly>
                                                                <div class="input-group-addon">
                                                                  <i class="fa fa-repeat actualizarcantidadref" style="cursor: pointer;"></i> <span class="actualizarcantidadref" style="cursor: pointer;"> Actualizar # Referidos</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>                                                
                                                </div>
                                                <div class="form-group datosreferidoHabilitado <?php if($referidoHabilitado=="SI"){echo '';} else{echo 'ocultar';}?>" style="margin-bottom: 0px;">
                                                <div class="col-sm-12 col-md-12">
                                                    <div class="form-group">
                                                        <label class="col-sm-2 col-xs-4 control-label " style="text-align:left;" for="urlreferidoHabilitado">URL:</label>
                                                        <div class="col-sm-10 col-xs-8">
                                                            <div class="input-group">
                                                                <input type="text" class="form-control" id="urlreferidoHabilitado" name="urlreferidoHabilitado" value="<?php echo 'https://clientesverisure.com/apps/referidos/create/'.$idprospectorp.'/'.$matricula.'/'.$tipoventa.'/'.explode( '/', $cliente)[0].'/'.$correo;?>" readonly>
                                                                <div class="input-group-addon">
                                                                  <i class="fa fa-copy copiarurl" style="cursor: pointer;"></i>
                                                                </div>
                                                                <div class="input-group-addon">
                                                                  <i class="fa fa-external-link irurl" style="cursor: pointer;"></i>
                                                                </div>
                                                            </div>
                                                              
                                                        </div>
                                                    </div>
                                               </div>

                                                </div>
                                        </div>
                                            
                                            
                                        </div>
                                    </div>
                    
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                        <h5>INFORMACION SCORING</h5>  
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                        </div>
                                    </div>
                                    <div class="box-body">
                                        <div class="form-horizontal">
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblresultadoScoring">RESULTADO SCORING:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                         <select class="form-control input-sm" name="lblresultadoScoring" id="lblresultadoScoring" disabled>
                                                            <option value="" disabled selected>Seleccione</option>
                                                            <option value="Especial">Oferta especial</option>
                                                            <option value="Oferta">Oferta</option>
                                                            <option value="Limitada">Oferta limitada</option>
                                                            <option value="Extraordinaria">Oferta extraordinaria</option>
                                                            <option value="Unica">Oferta unica</option>                                                            
                                                        </select>  
                                                        <input type="hidden" id="valresultadoScoring" value="<?php echo $ScoringRP; ?>">
                                                        <input type="hidden" id="valcodigoOperacionScoring" value="<?php echo $CodigoOperacionScoring; ?>">
                                                     </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6 scoring">
                                                    <div class="form-group">
                                                        <div class="col-sm-6 col-xs-6">
                                                            <button type="button" class="btn btn-danger btn-block btn-sm" id="btnModalconsultascoring" data-toggle="modal" data-target="#modal-consultascoring"><i class="fa fa-cog"></i> SCORING</button>
                                                        </div>
                                                        <div class="col-sm-6 col-xs-6">
                                                            <button type="button" class="btn btn-default btn-block btn-sm" id="logconsultadoc" data-toggle="modal" data-target="#modal-logdni"><i class="fa fa-pencil-square-o"></i> CONSULTAS DOC.</button>
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                        
    
                                        </div>
                                    </div>
                                </div>                                
                                <!-- INFORMACION DE LA OFERTA -->
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                        <h5>INFORMACION DE LA OFERTA</h5>
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                            </button>
                                        </div>
                                        <input type="hidden" id="datosGeneral" value='<?php echo $DetalleGeneral; ?>'>
                                        <input type="hidden" id="datosExtras" value='<?php echo $DetalleExtras; ?>'>
                                        <input type="hidden" id="datosRegalos" value='<?php echo $DetalleRegalos; ?>'>
                                        <input type="hidden" id="datosIdProspectoRp" value='<?php echo $idprospectorp; ?>'> 
                                        
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                        <div class="form-horizontal" style="margin-bottom: 0px;">
                                            <div class="form-group">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="GGCC">GGCC:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="checkbox" name="GGCC" id="GGCC" <?php if($GGCC=="SI"){echo 'checked';} else{echo '';}?> data-size="small"/>
                                                            <input type="hidden" name="hidGGCC" id="hidGGCC" value="<?php echo $GGCC; ?>"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">RECURSO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select name="lbltipoventa" id="lbltipoventa" class="form-control input-sm" disabled>
                                                                <option>Seleccione</option>
                                                                <option value="RE"<?php if ($tipoventa == "RE") {echo "selected";}?> hidden="" disabled="disabled">RE</option>
                                                                <option value="RP"<?php if ($tipoventa == "RP") {echo "selected";}?>>RP</option>
                                                                <option value="RPPA"<?php if ($tipoventa == "RPPA") {echo "selected";}?>>RPPA</option>
                                                                <option value="RPPR"<?php if ($tipoventa == "RPPR") {echo "selected";}?>>RPPR</option>
                                                                <option value="RPTMK"<?php if ($tipoventa == "RPTMK") {echo "selected";}?>>RPTMK</option>
                                                                <option value="RPMKT"<?php if ($tipoventa == "RPMKT") {echo "selected";}?>>RPMKT</option>
                                                            </select>
                                                            <input id="lbltiventa" name="lbltiventa" value="<?php echo $tipoventa;?>"  hidden="" />
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6 lblverinstaladadel">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblestventa">N° CONTRATO:<span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="text" class="form-control input-sm" name="lblncontrato" id="lblncontrato" data-inputmask='"mask": "9999999"' value="<?php echo $NContrato;?>" data-mask readonly="readonly">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblestadoprospecto">ESTADO PROSPECTO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="text" class="form-control input-sm" name="lblestadoprospecto" id="lblestadoprospecto" value="<?php echo $estadoprospecto;?>" readonly="readonly">
                                                        </div>
                                                    </div>
                                                </div>    
                                                <div class="col-sm-6 col-md-6 lblver590">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblestventa">ESTADO VENTA: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select name="lblestventaprovicional" id="lblestventaprovicional" class="form-control input-sm" style="display:none">
                                                                <option value="AgendadaDEL">AgendadaDEL</option>
                                                                <option value="InstaladaDEL">InstaladaDEL</option>
                                                            </select>   
                                                            <input type="text" class="form-control input-sm" name="lblestventa" value="<?php echo $estadoventa;?>" id="lblestventa" readonly="readonly">
                                                     </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- CARRITO DE COMPRAS -->
                                            <!-- MESES AUTORIZADOS Y TIPO KIT -->
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblmesesautorizados">MESES AUTORIZADOS:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="number" maxlength="3" class="form-control input-sm" id="lblmesesautorizados" name="lblmesesautorizados"  value="<?php if($mesesautorizados==''){echo '0.00';}else{ echo $mesesautorizados;}?>" onkeypress="return filterFloat(event, this);" readonly>
                                                        </div>
                                                    </div>
                                                </div>
                                               <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltipokit">TIPO KIT:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" id="lbltipokit" name="lbltipokit">
                                                                <option value="" disabled selected>Seleccione</option>
                                                                <option value="Basico" <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':''; ?>>BASICO</option>
                                                                <option value="ZeroVision">ZEROVISION</option>
                                                                <option value="Reconexion" <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':''; ?>>RECONEXION</option>
                                                                <option value="Camara" <?php echo ($dc == "154" || $dc == "157" || $dc == "158" || $matriculausuario=='MGR200' || $dc == "155" || $dc == "152" || $dc == "200" || $dc == "159" || $dc == "40" || $dc == "140")?'hidden disabled':'hidden disabled'; ?> >CAMARA</option>
                                                                <option value="High Security" <?php echo ($dc == "154" || $dc == "157" || $dc == "158" || $matriculausuario=='MGR200' || $dc == "155" || $dc == "152" || $dc == "200" || $dc == "159" || $dc == "40" || $dc == "140")?'hidden disabled':'hidden disabled'; ?>>HIGH SECURITY</option>
                                                                <option value="Basico PRO" <?php if ($TipoKIT == 'Basico PRO') {
                        															echo 'selected';
                        															} ?> <?php echo ($dc == "150" || $dc == "154" || $dc == "158" || $dc == "151" || $dc == "152" || $dc == "153" || $dc == "155" || $dc == "156" || $dc == "157" || $dc == "159" || $dc == "251" || $dc == "252" || $dc == "513")?'':'hidden disabled'; ?>>BASICO PRO</option>
                                                                <option value="ZeroVision PRO" <?php if ($TipoKIT == 'ZeroVision PRO') {
                        															echo 'selected';
                        															} ?> <?php echo ($dc == "150" || $dc == "154" || $dc == "158" || $dc == "151" || $dc == "152" || $dc == "153" || $dc == "155" || $dc == "156" || $dc == "157" || $dc == "159" || $dc == "251" || $dc == "252" || $dc == "513" || $dc == "701" || $dc == "702")?'':'hidden disabled'; ?>>ZEROVISION PRO</option>
                        										<option value="ZeroVision LA CURACAO" <?php if ($TipoKIT == 'ZeroVision LA CURACAO') {
                        															echo 'selected';
                        															} ?> <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':'hidden disabled'; ?>>ZEROVISION LA CURACAO</option>                        										
                        										<option value="ZeroVision PRO LA CURACAO" <?php if ($TipoKIT == 'ZeroVision PRO LA CURACAO') {
                        															echo 'selected';
                        															} ?> <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':'hidden disabled'; ?>>ZEROVISION PRO LA CURACAO</option>
                                                                <option value="Basico LA CURACAO" <?php if ($TipoKIT == 'Basico LA CURACAO') {
                        															echo 'selected';
                        															} ?> <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':'hidden disabled'; ?>>BASICO LA CURACAO</option>                        										
                        										<option value="Basico PRO LA CURACAO" <?php if ($TipoKIT == 'Basico PRO LA CURACAO') {
                        															echo 'selected';
                        															} ?> <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':'hidden disabled'; ?>>BASICO PRO LA CURACAO</option>                        															
                                                            </select>
                                                            <input type="hidden" id="valtipokit" value="<?php echo $TipoKIT; ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- ARLO -->
                                                <div class="form-group ocultar camaraarlo" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltipocamarakit">TIPO CÁMARA KIT:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" id="lbltipocamarakit" name="lbltipocamarakit">
                                                                <option value="" disabled selected>Seleccione</option>
                                                                <option value="Camara Interna N1">CAMARA INTERNA N1</option>
                                                                <option value="Camara Interna Arlo">CAMARA INTERNA ARLO</option>
                                                                <option value="Camara Externa Arlo">CAMARA EXTERNA ARLO</option>
                                                            </select>
                                                            <input type="hidden" id="valtipocamarakit" value="">                                                        
                                                     </div>
                                                    </div>
                                                </div>
                                                </div>                                            
                                            <!-- PAI  Y CATEGORIA PRECIO -->
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblPAI">PAI: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" name="lblPAI" id="lblPAI">
                                                                <option>Seleccione</option>
                                                                <!-- <option value="BBVA-DIN"<?php //if ($PAI == "BBVA-DIN") {echo "selected";}?>>BBVA-DIN</option> -->
                                                                
        						
        														 
        														 <option value="PAI 30x36"<?php if ($PAI == "PAI 30x36") {echo "selected";}?> hidden>PAI 30x36</option>
        														 <option value="PAI 30x48"<?php if ($PAI == "PAI 30x48") {echo "selected";}?> >PAI 30x48</option>
        													                                                              
                                                                <option value="NO"<?php if ($PAI == "NO") {echo "selected";}?>>NO</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="">CATEGORIA PRECIO:</label>    
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" id="lblcategoriaprecio" name="lblcategoriaprecio">
                                                                <option value="" disabled selected>Seleccione</option>
                                                            </select>
                                                            <input type="hidden" id="hidCategoriaPrecio" value="<?php echo $CategoriaPrecio; ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <!-- SEGUNDA ALARMA-->
                                            <div class="form-group <?php if ($CategoriaPrecio != 'PRECIO SEGUNDA ALARMA') {
                                                                                        echo 'ocultar';
                                                                                    } ?> segundaalarma" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="">ESCRIBIR PRIMERA ALARMA:</label>    
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="text" class="form-control input-sm" name="lblsegundaalarma" id="lblsegundaalarma" value="<?php echo $SegundaAlarma; ?>" data-inputmask='"mask": "9999999"' data-mask>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>                                            
                                            <div class="row" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblpreciokit">PRECIO KIT:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="">S/.</i>
                                                                </div>
                                                                <input type="number" class="form-control input-sm" name="lblpreciokit" id="lblpreciokit" value="<?php echo $preciokit;?>" onkeypress="return filterFloat(event, this);">
                                                                <input type="hidden" id="precioKit__MIN">
                                                                <input type="hidden" id="precioKit__MAX">
                                                                <input type="hidden" id="hidPrecioKit" value="<?php echo $preciokit;?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblclosingpack">CLOSING PACK:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lblclosingpack" id="lblclosingpack">
                                                        <option value="" disabled selected>Seleccione</option>
                                                        <option value="Ninguno">Ninguno</option>
                                                    </select>
                                                    <input type="hidden" id="valclosingpack" value="<?php echo $ClosingPack; ?>">
                                                     </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php if($tipoventa == "RE"){
											        $mostrarEtiqueta="";
											    }else{
											        if($CategoriaPrecio == 'RENOVE' || $CategoriaPrecio == 'EXCEPCION RENOVE' || $CategoriaPrecio == 'SUPER OFERTA RENOVE'){
											            $mostrarEtiqueta="";
											        }else{
											            $mostrarEtiqueta="hidden";
											        }
											        
											    }
											    
											    ?>
                                            <div class="row" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group mostrarEtiqueta <?php echo $mostrarEtiqueta; ?>">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblpreciokit">DESCUENTO CUOTA:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" id="lblDescuentoCuota" name="lblDescuentoCuota">
                                                                <option value="" disabled selected>Seleccione</option>
                                                                <option value="ninguno" <?php if($dsctCuota == 'ninguno' || $dsctCuota == ''){echo 'selected'; } ?>>Ninguno</option>
                                                                <option value="1mes"  <?php if($dsctCuota == '1mes'){echo 'selected'; } ?>>50% DESCUENTO 1 MES</option>
                                                                <option value="2meses"  <?php if($dsctCuota == '2meses'){echo 'selected'; } ?>>50% DESCUENTO 2 MESES</option>
                                                                <option value="3meses"  <?php if($dsctCuota == '3meses'){echo 'selected'; } ?> hidden>50% DESCUENTO 3 MESES</option>
                                                            </select>
                                                            <input type="hidden" value="<?php echo $dsctCuota; ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblRenove">RENOVE</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" id="lblRenove" name="lblRenove">
                                                                <option value="" disabled selected>Seleccione</option>
                                                                <option value="SI">SI</option>
                                                                <option value="NO">NO</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>                                                
                                            </div>
                                            <div class="row" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblRcompetencia">COMPETENCIA</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" id="lblRcompetencia" name="lblRcompetencia">
                                                                <option value="" disabled selected>Seleccione</option>
                                                                <option value="Prosegur">Prosegur</option>
                                                                <option value="Boxer Alarmas">Boxer Alarmas</option>
                                                                <option value="Mapfre">Mapfre</option>
                                                                <option value="Liderman">Liderman</option>
                                                                <option value="Qido">Qido</option>
                                                                <option value="Otros">Otros</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblRvencimiento">FECHA VENCIMIENTO</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                           <input type="text" class="form-control pull-right input-sm readonly_blanco" id="lblRvencimiento" value=""  name="lblRvencimiento" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask readonly="readonly">
                                                        </div>
                                                    </div>
                                                </div>                                                
                                            </div>                                            
                                            <div class="row">
                                                <div class="col-sm-6 col-md-6">
                                                    <button type="button" class="btn btn-danger" style="margin-bottom: 15px; width: 100%" id="generarExtras">EXTRAS</button>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <button type="button" class="btn btn-danger" style="margin-bottom: 15px; width: 100%" id="generarRegalos">REGALOS</button>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblCantExtras">CANTIDAD EXTRAS:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <input type="number" class="form-control input-sm" id="lblCantExtras" name="lblCantExtras" min="0" value="<?php if($CantidadExtras == '' || $CantidadExtras == null){echo '0'; } else {echo $CantidadExtras;} ?>" disabled>       
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltotalextra">TOTAL EXTRA:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <div class="input-group">
                                                                    <div class="input-group-addon input-sm">
                                                                        <i class="">S/.</i>
                                                                    </div>
                                                                    <input type="number" class="form-control input-sm" name="lbltotalextra" id="lbltotalextra" value="<?php if($totalextra == '' || $totalextra == null){echo '0'; } else {echo $totalextra;} ?>" onkeypress="return filterFloat(event, this);" disabled>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblCantRegalos">CANTIDAD REGALOS:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="number" class="form-control input-sm col-md-8" id="lblCantRegalos" name="lblCantRegalos" min="0" value="<?php if($CantidadRegalo == '' || $CantidadRegalo == null){ echo '0';} else { echo $CantidadRegalo; } ?>" disabled>       
                                                    </div>
                                                    </div>
                                                </div>
                                            </div>
                                                
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltotalcuota">TOTAL CUOTA:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="">S/.</i>
                                                                </div>
                                                                <input type="number" class="form-control input-sm" name="lbltotalcuota" id="lbltotalcuota" value="<?php if($TotalCuotaMonitoreo == '' || $TotalCuotaMonitoreo == null){ echo '0';} else { echo $TotalCuotaMonitoreo; } ?>" onkeypress="return filterFloat(event, this);" disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblresumenventa">RESUMEN INST.:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <textarea class="form-control input-sm" name="lblresumenventa" id="lblresumenventa" rows="2" style="resize:none"  placeholder="Ingresar..." disabled><?php echo $resumenventa;?></textarea> 
                                                     </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- END CARRITO -->
                                            <div>
                                                <div class="col-sm-6 col-md-6 ocultar">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblextraautorizado">REGALO AUTORIZADO:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" name="lblextraautorizado" id="lblextraautorizado">
                                                                <option>Seleccione</option>
                                                                <option value="Ninguno"<?php if ($regaloutorizado == "Ninguno") {echo "selected";}?>>Ninguno</option>
                                                                <option value="Mando a distancia"<?php if ($regaloutorizado == "Mando a distancia") {echo "selected";}?>>Mando a distancia</option>
                                                                <option value="Magnetico"<?php if ($regaloutorizado == "Magnetico") {echo "selected";}?>>Magnetico</option>
                                                                <option value="Pulsador"<?php if ($regaloutorizado == "Pulsador") {echo "selected";}?>>Pulsador</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- FORMA DE PAGO -->
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblformadepago">FORMA DE PAGO:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lblformadepago" id="lblformadepago">
                                                        <option value="">Seleccione</option> 
                                                        <option value="Cheque" <?php if ($formadepago == "Cheque") {echo "selected";}?>>Cheque</option>
                                                        <option value="Deposito" <?php if ($formadepago == "Deposito") {echo "selected";}?>>Depósito</option>
                                                        <option value="Transferencia" <?php if ($formadepago == "Transferencia") {echo "selected";}?>>Transferencia</option>
                                                        <option value="TransferenciaInterbancaria" <?php if ($formadepago == "TransferenciaInterbancaria") {echo "selected";}?>>Transferencia Interbancaria</option>
                                                        <option value="PagoPOSVisa" <?php if ($formadepago == "PagoPOSVisa") {echo "selected";}?>>Pago POSVisa</option>
                                                        <option value="PagoPOSMC" <?php if ($formadepago == "PagoPOSMC") {echo "selected";}?>>Pago POSMC</option>
                                                        <option value="TarjetadeCredito" <?php if ($formadepago == "TarjetadeCredito") {echo "selected";}?>>Tarjeta de Crédito</option>
                                                        <option value="PagoPasarella" <?php if ($formadepago == "PagoPasarella") {echo "selected";}?>>Pago Pasarella</option>
                                                    </select>
                                                     </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- FORMA DE PAGO MONITOREO Y 590 -->
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6 ocultar">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblformapagocuota">FORMA DE PAGO MONITOREO:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm select2" name="lblformapagocuota" id="lblformapagocuota" style="width: 100%">
                                                            <option value="">Seleccione</option>
                                                            <option value="Contrafactura" <?php if ($FormaPagoCuota == "Contrafactura") {echo "selected";}?>>Contrafactura</option>
                                                            <option value="Tarjetacredito" <?php if ($FormaPagoCuota == "Tarjetacredito") {echo "selected";}?>>Tarjeta crédito</option>
                                                            <option value="Tarjetadebito" <?php if ($FormaPagoCuota == "Tarjetadebito") {echo "selected";}?>> Tarjeta débito</option>
                                                            <option value="Cuentadebito" <?php if ($FormaPagoCuota == "Cuentadebito") {echo "selected";}?>>Cuenta débito</option>
                                                        </select>
                                                     </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6 lblver590">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">590: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control pull-right input-sm"  id="mesano" data-role="date" value="<?php if(isset($n590)){ echo $n590;}else{echo $fechames;}?>" name="lbl590" readonly="readonly" >
                                                    </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- HOJA CERTIFICACION Y COMENTARIO RP -->
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="HCertificacion">HOJA CERTIFICACIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="checkbox" name="HCertificacion" id="HCertificacion" <?php if($HojaCertificacion=="SI"){echo 'checked';}else{echo '';}?> data-size="small"/>
                                                  <input type="hidden" name="hidden_HCertificacion" id="hidden_HCertificacion" value="<?php echo $HojaCertificacion; ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblobservacion">COMENTARIO RP:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <textarea class="form-control input-sm" name="lblcomentarioprospecto" id="lblcomentarioprospecto" rows="2" style="resize:none" placeholder="Ingresar..."><?php echo $comentarioprospecto;?></textarea>
                                                     </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>                                        
                                        
                                    </div>
                                    <!-- /.box-body -->
                                </div>
                                <!-- INFORMACION DE LA AGENDA -->
                                <div class="box box-custom" id="veragenda">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACION DE AGENDA</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                    <div class="form-horizontal">
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">INSTALADOX: <span style="color:red"> * </span></label>
                                                            <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lblinstaladox" id="lblinstaladox">
                                                    <option>Seleccione</option>
                                                     
                                                    <option value="DEL"<?php if ($instaladox == "DEL") {echo "selected";}?>>DEL</option>
                                                </select>
                                                
                                                <input id="lblidagenda" name="lblidagenda" value="<?php // echo $idagenda;?>" hidden=""> 
                                                <input type="hidden" name="lblIteraccionAttec" value="<?php echo $IteraccionAttec; ?>" id="lblIteraccionAttec" />
                                                         </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">TÉCNICO: <span style="color:red"> * </span></label>
                                                            <div class="col-sm-8 col-xs-8">
                                                               <select name="lbltecnico" id="lbltecnico" class="form-control cbxtecnico input-sm" style="width: 100%;">
                                                    <?php echo $html_tecnico;?>
                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">F.INSTALACIÓN: <span style="color:red"> * </span></label>
                                                            <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group" id="fi">
                                                    <div class="input-group-addon input-sm">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right input-sm readonly_blanco" id="fechainst" value="<?php echo $fechainstalacionver;?>"  name="lblfinstalacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask readonly="readonly">
                                                </div>
                                                         </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">H.INSTALACIÓN: <span style="color:red"> * </span></label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <div class="bootstrap-timepicker timepicker">
                                                 <div class="input-group">
                                                     <input type="text" class="form-control input-sm readonly_blanco" placeholder="12:00 AM" name="lblhinstalacion" id="horainst" value="<?php echo $horainstalacionver;?>" readonly="readonly">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-clock-o"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">

                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">COMENTARIO: <span style="color:red"> * </span></label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <textarea class="form-control input-sm" name="lblcomentarioagenda" id="lblcomentarioagenda" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo utf8_encode($comentarioagenda);?></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;display:none;">
                                                    <div class="col-sm-6 col-md-6 tinviable">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinviable">MOTIVO INVIABLE:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                            <textarea class="form-control input-sm" name="lblinviable" id="lblinviable" rows="1" style="resize:none" placeholder="Ingresar..."></textarea>
                                                         </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6 tcancelado">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcancelado">MOTIVO CANCELADO:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <textarea class="form-control input-sm" name="lblcancelado" id="lblcancelado" rows="1" style="resize:none" placeholder="Ingresar..."></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                            </div>
                                    </div>    
                                    
                                </div>
                                    <!-- /.box-body -->
                                </div>
                            <!-- INFORMACION DE CERTIFICACION DE VENTA -->
                            <div class="box box-custom">
                               
                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                    <h5>INFORMACION DE CERTIFICACIÓN VENTA</h5>

                                    <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>

                                    </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                    <div class="form-horizontal">

                                        <div class="box box-custom">
                                            <!-- /.box-header -->
                                            <div class="box-body">
                                                <div class="form-horizontal">
                                                  
                                                    <div class="form-group" style="margin-bottom: 0px;">
                                                        <div class="col-sm-6 col-md-8">
                                                            <div class="form-group">
            
                                                                <label class="col-md-3 col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcomentario_comercial"><span style="color:#2c3b41">RESPUESTA COMERCIAL:<span style="color:red"> * </span></span> </label>
                                                                <div class="col-md-9 col-sm-8 col-xs-8">
                                                                    <textarea class="form-control input-sm" name="lblcomentario_comercial" id="lblcomentario_comercial" rows="3" style="resize:none" placeholder="Ingresar..."></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
     
                                                    </div>                                        
            
                                                    <div class="form-group" style="margin-bottom: 0px;">
    
                                                        <div class="col-sm-6 col-md-6">
                                                            <div class="form-group">
                                                                <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltipocierre_cert">HORARIO SUGERIDO:<span style="color:red"> * </span></label> 
                                                                <div class="col-sm-8 col-xs-8">
                                                                    <select class="form-control input-sm" name="lblhorariosugerido2" id="lblhorariosugerido2">
                                                                        <option>Seleccione</option>
                                                                        <option value="9:00 am - 12 pm">9:00 am - 12 pm</option>
                                                                        <option value="12:00 pm - 3:00 pm">12:00 pm - 3:00 pm</option>
                                                                        <option value="3:00 pm - 6:00 pm">3:00 pm - 6:00 pm</option>
                                                                    </select>  
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div> 
                                                    
                                                    
                                                </div>
                                            </div>
                                            <!-- /.box-body -->
                                        </div>  
                                        
                                    </div>

                                </div>
                                <!-- /.box-body -->
                            </div>
 
                                                                        
                                
                            </form>
                        </div>
                        <!-- END COL-MD-8 -->
                        <div class="col-md-2"></div>
                    </div>
                </section>
                <!-- /.content -->
            </div>
            <!-- /.content-wrapper -->
            <div class="control-sidebar-bg"></div>
            
            <!-- MODAL CHECK IN -->
            <div class="modal fade" id="modal-checkin">
                <div class="modal-dialog modal-log">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4>Enviar Check-IN ...</h4>
                        </div>
                        <div class="modal-body">
                            <div class="" id="Informacion">
                                <input type="hidden" id="checkin" name="checkin" value="<?php echo $CheckinRP; ?>">
                                <input type="hidden" id="infocheckin" name="infocheckin" value='<?php echo $InfoCheckInRP; ?>'>
                                <input type="hidden" id="latitud" name="latitud">
                                <input type="hidden" id="longitud" name="longitud">
                            </div>
                            <div id="mapContenedor">
                                <div id="map"></div>
                            </div>
                            
                        </div>
                        <div class="modal-footer">
                            <!--<button type="button" class="btn btn-nuevo" id="btnContinuar">Continuar sin Check-IN</button> -->
                            <button type="button" class="btn btn-success" id="btnGuardarCheckIn">Enviar Ubicación</button>
                            <!--<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>-->
                        </div>  
                    </div>
                </div>
            </div>
            <div class="modal fade" id="modal-consultascoring">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4>CONSULTAR SCORING</h4>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                            <div class="col-md-6">
                            <div id="frmEditarVentaScoring" method="post">
                                <div class="box box-danger">
                                    <div class="box-header with-border">
                                        <h5>SCORING</h5>
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="box-body">
                                        <div class="form-horizontal" style="padding: 10px 20px 0">
                                        <div class="form-group">
                                                <label style="text-align: left;">TIPO DOCUMENTO:</label>
                                                    <input type="hidden" id="matriculausuario" value="<?php echo $matriculausuario;?>">
                                                    <input type="hidden" id="nombreusuario" value="<?php echo $nombreusuario;?>">
                                                    <select class="form-control input-sm" name="TipoDocumento" id="TipoDocumento">
                                                        <option value="">Seleccione</option>
                                                        <option value="1">DNI</option>
                                                        <option value="3">Carnet Extranjeria</option>
                                                        <option value="6">RUC</option>
                                                    </select>
                                        <a href="#" title="Modal de Busqueda de Documento" id="btnEquifax">(No tengo el Número de Documento)</a>
                                        
                                        </div>
                                        <div class="form-group">
                                                <label id="labeltelefono">DOCUMENTO: </label>
                                                <input type="text" class="form-control input-sm" name="Documento" id="Documento" maxlength="12" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                                        </div>
                                        <div class="form-group hidden">
                                        <label>DEPARTAMENTO: </label>
                                                 <select class="form-control input-sm select2full" name="Departamental" id="Departamental" style="width: 100%">
                                                        <option value="" selected>Seleccione</option>
                                                </select>
                                        </div>
                                        <div class="form-group hidden">
                                        <label>PROVINCIA: </label>
                                                 <select class="form-control input-sm select2full" name="Provincial" id="Provincial" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                </select>
                                        </div>
                                        <div class="form-group hidden">
                                        <label>DISTRITO: </label>
                                                 <select class="form-control input-sm select2full" name="Distrital" id="Distrital" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                </select>
                                         </div>
                                        <div class="form-group ocultar">
                                        <label>SEGMENTO: </label>
                                                 <select class="form-control input-sm" name="Segmento" id="Segmento" style="width: 100%" disabled>
                                                            <option value="">Seleccione</option>
                                                            <option value="RES">RES</option>
                                                            <option value="NEG">NEG</option>
                                                </select>
                                         </div>                                         
                                        <div class="form-group" style="margin-top:40px;">
                                                  <button class="btn  btn-block btn-verisure" id="btnScoring">Consultar Scoring</button>
                                                  <button class="btn  btn-block btn-verisure" style="display:none" id="btnNuevaScoring">Nueva Consulta</button>
                                                  <button type="button" class="btn btn-block btn-verisurecerrar" data-dismiss="modal">Cerrar</button> 
                                        </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            </div>
                            <div class="col-md-6">
                              <main class="contenedor ocultar box box-danger" id="ResultadoEquifax">
                                  <div id="resultado">
                                      <div class="callout bg-deuda">
                                    <h4><i class="fa fa-bullhorn"></i> Resultado de la Consulta:</h4>
                                    <h2 style="text-align: center;"><small class="label bg-visita"><span class="TextoAccion"></span></small><small class="label bg-televenta"><span class="TextoAccion"></span></small><small class="label bg-gestion"><span class="TextoAccion"></span></small></h2><br>
                                     <!--<strong>N°Operación: </strong><span id="NOperacion">S32012280000162</span><br>-->
                                     <strong>Fecha Consulta: </strong><span id="FechaConsulta">13/11/2019 12:24:34</span><br><br>
                                     
                                    <div class="row">
                                    <div class="col-xs-12">
                                         <strong><i class="fa fa-user text-danger"></i> Nombre del Solicitante:</strong><br><span id="NombreCompleto">DUBOIS DORIBAL DUBOIS DORIBAL GLADYS ELVIRA</span><br>
                                    <strong><i class="fa fa-folder-open text-danger"></i> <span id="TDocumento">DNI:</span></strong><br><span id="NumeroDocumento">00007039332</span><br>
                                    </div>
                                   
                                    <div class="col-xs-12" style="display:none">
                                     <div class="contenido-score">
                                          <div class="score-info">
                                              <div>
                                                 <strong>SCORE - RIESGO</strong>
                                                 <br>
                                            
                                                    <span id="Riesgo">Bajo</span>
                                              </div>
                                              <div>
                                                  <strong>SCORE - VALOR</strong>
                                                 <br>
                                                 <div id="Valor">952</div>
                                              </div>
                                              <div>
                                                  <strong>NODOS - DESCRIPCION</strong>
                                                 <br>
                                                 <div id="ValorNodo">XXX</div>
                                              </div>
                                              <div>
                                                  <strong>NODOS - ACCION</strong>
                                                 <br>
                                                 <div id="ValorNodoAccion">XXX</div>
                                              </div>                                              
                                         </div>
                        
                                      </div>
                                    </div>
                                    </div>
                                    
                        
                                        </div>
                                  </div>
                              </main>
                              </div>
                             </div> 
                        </div>

                    </div>
                </div>
            </div>
            <div class="modal fade" id="modal-logdni">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h3>DOCUMENTOS</h3>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                    <div class="col-xs-12 col-sm-12 table-responsive no-padding">
                                    <table class="table table-bordered" id="tblVentas" style="display:none;">
                                        <thead>
                                            <tr style="height:0.8vw">
                                                <td class="text-center">OPCIONES</td>
                                                <td class="text-center">FECHA CONSULTA</td>
                                                <td class="text-center">TIPO DOC.</td>
                                                <td class="text-center">DOCUMENTO</td>
                                                <td class="text-center">NOMBRES, APELLIDO PATERNO, APELLIDO MATERNO</td>
                                                
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                             </div> 
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                        </div>  

                    </div>
                </div>
            </div>
            <!-- MODAL DETALLE EXTRAS -->
            <div class="modal fade" id="modal__carritocompras">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h3>EXTRAS</h3>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="cboProducto" class="col-md-3 control-label">Extra:</label>
                                <div class="col-md-9">
                                    <select class="form-control" id="cboProducto" name="cboProducto" style="width: 100%">
                                        <option value="" disabled selected>--Seleccione--</option>
                                        <?php
                                            if($dc == "154" || $dc == "157" || $dc == "158" || $matriculausuario=='MGR200' || $dc == "120" || $dc == "150" || $dc == "41" ){
                                                $query="SELECT IdItem, CodItem, Item, Precio, CuotaMes
                                                        FROM dbVENTAS.tblitem
                                                        where CategoriaItem = 'field' and Estado = 'Activo'";
                                            }else{
                                                $query="SELECT IdItem, CodItem, Item, Precio, CuotaMes
                                                        FROM dbVENTAS.tblitem
                                                        where CategoriaItem = 'field' and Estado = 'Activo'";
                                            }
                                            $resultado=$con->query($query);
                                                    
                                            while ($data = $resultado->fetch_assoc()){                                                          
                                        ?>
                                                <option value="<?php echo $data['IdItem']; ?>"><?php echo $data['Item']." (S/. ".number_format((float)$data['Precio'], 0, '.', '').")"; ?></option>
                                        <?php } ?>
                                    </select>
                                    <input type="hidden" id="hidProducto" name="hidProducto">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="cboTipoPrecio" class="col-md-3 control-label">Tipo precio:</label>
                                <div class="col-md-9">
                                    <select class="form-control" id="cboTipoPrecio" name="cboTipoPrecio" style="width: 100%">
                                        <option value="" disabled selected>--Seleccione--</option>
                                        <option value="catalogo">CATALOGO (SIN DESCUENTO))</option>
                                        <option value="medio">MEDIO (25% DESCUENTO ) </option>
                                        <option value="autorizado">AUTORIZADO (50% DESCUENTO)</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="cantidadProductos" class="col-md-3 control-label">Precio unitario:</label>
                                <div class="col-md-9">
                                    <input type="number" class="form-control" id="precioUnitario" name="precioUnitario">
                                    <input type="hidden" id="precioMin">
                                    <input type="hidden" id="precioMax">
                                    <input type="hidden" id="cuotaMes">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="cantidadProductos" class="col-md-3 control-label">Cantidad:</label>
                                <div class="col-md-9">
                                    <input type="number" class="form-control" id="cantidadProductos" name="cantidadProductos">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <button class="btn btn-danger pull-right" id="btnAgregar" name="btnAgregar"><i class="fa fa-plus"></i>&nbsp Agregar </button>    
                                </div>
                            </div>
                            <div class="row">
                                <div id="listaExtras" class="col-md-12">
                                    
                                </div>
                            </div>
                            <!-- RESUTADO FINAL -->
                            <div class="row">
                                <div class="col-md-4"></div>
                                <div class="col-md-8">
                                    <label for="txtResumen" class="col-sm-4 control-label">Resumen:</label>
                                    <div class="col-sm-8">
                                        <textarea rows="2" id="txtResumen" name="txtResumen" style="width: 100%" disabled></textarea>
                                    </div>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4"></div>
                                <div class="col-md-8">
                                    <label for="txtCantidadExtra" class="col-sm-4 control-label">Cantidad Extras:</label>
                                    <div class="col-sm-8">
                                        <input type="number" id="txtCantidadExtra" name="txtCantidadExtra" style="width: 100%" min="0" value="0" disabled>
                                    </div>
                                </div>
                            </div>
                            <br>
                            <!--
                            <div class="row">
                                <div class="col-md-4"></div>
                                <div class="col-md-8">
                                    <label for="txtCantidadRegalo" class="col-sm-4 control-label">Cantidad Regalo:</label>
                                    <div class="col-sm-8">
                                        <input type="number" id="txtCantidadRegalo" name="txtCantidadRegalo" style="width: 100%" min="0" value="0" disabled>
                                    </div>
                                </div>
                            </div>
                            <br>
                            -->
                            <div class="row">
                                <div class="col-md-4"></div>
                                <div class="col-md-8">
                                    <label for="txtTotal" class="col-sm-4 control-label">Total:</label>
                                    <div class="col-sm-8">
                                        <input type="number" id="txtTotal" name="txtTotal" style="width: 100%" min="0" value="0.00" disabled>
                                    </div>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4"></div>
                                <div class="col-md-8">
                                    <label for="txtTotalCuota" class="col-sm-4 control-label">Total Cuota:</label>
                                    <div class="col-sm-8">
                                        <input type="number" id="txtTotalCuota" name="txtTotalCuota" style="width: 100%" min="0" value="0.00" disabled>
                                    </div>
                                </div>
                            </div>
                            
                            
                        </div>
                        
                        <div class="modal-footer">
                            <button class="btn btn-danger" id="generarOferta">Generar</button>
                        </div>
                    </div>
                    
                </div>
            </div>
            <!-- MODAL DETALLE REGALOS -->
            <div class="modal fade" id="modal__regalos">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h3>REGALOS</h3>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="cboRegalo" class="col-md-3 control-label">Regalo:</label>
                                <div class="col-md-9">
                                    <select class="form-control" id="cboRegalo" name="cboRegalo" style="width: 100%">
                                        <option value="" disabled selected>--Seleccione--</option>
                                        <?php
                                        if($dc == "154" || $dc == "157" || $dc == "158" || $matriculausuario=='MGR200' || $dc == "120" || $dc == "150" || $dc == "41"){
                                            $query="SELECT IdItem, CodItem, Item, Precio, CuotaMes
                                                    FROM dbVENTAS.tblitem
                                                    where CategoriaItem = 'fieldRegalo' and Estado = 'Activo'";
                                        }else{
                                            $query="SELECT IdItem, CodItem, Item, Precio, CuotaMes
                                                    FROM dbVENTAS.tblitem
                                                    where CategoriaItem = 'fieldRegalo' and Estado = 'Activo'";
                                        }                                               

                                            $resultado=$con->query($query);
                                                    
                                            while ($data = $resultado->fetch_assoc()){                                                          
                                        ?>
                                                <option value="<?php echo $data['IdItem']; ?>"><?php echo $data ['Item']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="cantidadProductos" class="col-md-3 control-label">Cantidad:</label>
                                <div class="col-md-9">
                                    <input type="number" class="form-control" id="cantidadProductos__Regalos" name="cantidadProductos__Regalos" min="1" >
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <button class="btn btn-danger pull-right" id="btnAgregar__Regalos" name="btnAgregar__Regalos"><i class="fa fa-plus"></i>&nbsp Agregar </button>    
                                </div>
                            </div>
                            <div class="row">
                                <div id="listaRegalos" class="col-md-12">
                                    
                                </div>
                            </div>
                            <!-- RESUTADO FINAL -->
                            <div class="row">
                                <div class="col-md-4"></div>
                                <div class="col-md-8">
                                    <label for="txtResumen" class="col-sm-4 control-label">Resumen:</label>
                                    <div class="col-sm-8">
                                        <textarea rows="2" id="txtResumen__Regalo" name="txtResumen__Regalo" style="width: 100%" disabled></textarea>
                                    </div>
                                </div>
                            </div>
                            <br>

                            <div class="row">
                                <div class="col-md-4"></div>
                                <div class="col-md-8">
                                    <label for="txtCantidadRegalo" class="col-sm-4 control-label">Cantidad Regalo:</label>
                                    <div class="col-sm-8">
                                        <input type="number" id="txtCantidadRegalo" name="txtCantidadRegalo" style="width: 100%" min="0" value="0" disabled>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4"></div>
                                <div class="col-md-8">
                                    <label for="txtTotal" class="col-sm-4 control-label">Total:</label>
                                    <div class="col-sm-8">
                                        <input type="number" id="txtTotal__Regalo" name="txtTotal__Regalo" style="width: 100%" min="0" value="0.00" disabled>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4"></div>
                                <div class="col-md-8">
                                    <label for="txtTotalCuota" class="col-sm-4 control-label">Total Cuota:</label>
                                    <div class="col-sm-8">
                                        <input type="number" id="txtTotalCuota__Regalo" name="txtTotalCuota__Regalo" style="width: 100%" min="0" value="0.00" disabled>
                                    </div>
                                </div>
                            </div>
                            
                            
                        </div>
                        
                        <div class="modal-footer">
                            <button class="btn btn-danger" id="generarOferta__Regalo">Generar</button>
                        </div>
                    </div>
                    
                </div>
            </div> 
        </div>
        <!-- ./wrapper -->

        <!-- jQuery v1.11 -->
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
        $.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
         <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- SWEET ALERT -->
        <script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <!-- Moment-->
        <script src="admin/bower_components/moment/moment.js" type="text/javascript"></script>
        <script src="admin/bower_components/bootstrap-datepicker-mobile/bootstrap-datepicker-mobile.js" type="text/javascript"></script>
        <!-- Bootstrap toogle -->
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>
        <!-- Notificaciones -->
        <script src="js/notificaciones_v3.js?v=2" type="text/javascript"></script>
        <!-- LEAFLET -->
        <script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js" integrity="sha512-XQoYMqMTK8LvdxXYG3nZ448hOEQiglfqkJs1NOQV44cWnUrBc8PkAOcXy20w0vlaXaVUearIOBhiXZ5V3ynxwA==" crossorigin=""></script>
        <script src="lib/leaflet_AwesomeMarkers/dist/leaflet.awesome-markers.js"></script>
        <!--GLOBALES -->
        <script>
            //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE REGALOS
            let arregloRegalos = [];
            //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE EXTRAS
            let arregloDatos = [];
            //ARREGLO GENERAL DE KIT, REGALOS Y EXTRAS
            let arregloGeneral = [];
            
            const listaExtras = document.querySelector('#listaExtras');
            const listaRegalos = document.querySelector('#listaRegalos');
        </script>
        <!-- SCRIPT EVENTOS -->
        <script>
            //LBLDC
            $("#lbldc").change(function () {
               $("#lbldc option:selected").each(function () {
               var lbldc = $(this).val();
                $.post("./ajax/selectJefeVenta.php", { lbldc: lbldc }, function(data){
                    $("#lbljefeventa").html(data);
                });            
                });
            });
            //lblinstaladox
            $("#lblinstaladox").change(function () {
                $("#lblinstaladox option:selected").each(function () {
                   var lblinstaladox= $(this).val();
                    $.post("./ajax/selectTecnico.php", { lblinstaladox: lblinstaladox }, function(data){
                        $("#lbltecnico").html(data);
                    });            
                });
            });
            //lblestventaprovicional
            $("#lblestventaprovicional").change(function () {
                var estadovent = $("#lblestventaprovicional").val();
                 if(estadovent=="InstaladaDEL"){
                    $('.lblverinstaladadel').show();
                    $('#lblncontrato').val("");
                        // Eliminamos el atributo de solo lectura
                        $("#lblncontrato").removeAttr("readonly");
                        // Eliminamos la clase que hace que cambie el color
                        $("#lblncontrato").removeClass("readOnly");
                }else{
                    $('.lblverinstaladadel').hide();
                    $('#lblncontrato').val("");
                    $("#lblncontrato").attr("readonly","readonly");
                    // Ponemos una clase para cambiar el color del texto y mostrar que
                    // esta deshabilitado
                   $("#lblncontrato").addClass("readOnly");                    
                }
                    $("#lblestventa").val(estadovent);

            });
            //lbltipoventa
            $("#lbltipoventa").change(function () {
               var tps= $("#lbltipoventa").val();
                $("#lbltiventa").val(tps);
            });
            //lblcategoria
            $("#lblcategoria").change(function () {
                var categoria = $("#lblcategoria").val();
                var recurso=$("#lbltiventa").val();
                 $("#lblcat").val(categoria);
                bloquearxCategoria(categoria);
                if(recurso=="RE"){
                    if(categoria =="Ficha"){
                        $("#lblestadoventa").val("PendienteAgenda");
                        $("#lblestvisita").val("Vendida");
                        $("#lblestventa").val("PendienteAgenda");
                    }
                    if(categoria =="Online"){
                        $("#lblestadoventa").val("PendienteData");
                        $("#lblestvisita").val("Vendida");
                        $("#lblestventa").val("PendienteData");
                    }
                    if(categoria =="VAsignada"){
                        $("#lblestadoventa").val("VAsignada");
                        $("#lblestvisita").val("Asignada");
                        $("#lblestventa").val("VAsignada");
                    }
                    if(categoria =="Delegacion"){
                        $("#lblestadoventa").val("AgendadaDEL");
                        $("#lblestventaprovicional").val("AgendadaDEL");
                        $("#lblestvisita").val("Vendida");
                        $("#lblestventa").val("AgendadaDEL");
                        $('#lblestadoventa')[0].disabled=true;
                    }
                    if(categoria =="NoVendida"){
                        $("#lblestadoventa").val("NoVendida");
                        $("#lblestvisita").val("NoVendida");
                        $("#lblestventa").val("NoVendida");
                        $('#lblestadoventa')[0].disabled=true;
                    }
                }else{
                    if(categoria =="ProspectoRP"){
                        $("#lblestadoprospecto").val("ProspectoRP");
                        $("#lblestventa").val("");
                        $("#lblestventa").show();
                        $("#lblestventaprovicional").hide();
                        $('.lblverinstaladadel').hide();
                        $('#lblncontrato').val("");
                    }
                    if(categoria =="Ficha"){
                        $("#lblestadoprospecto").val("Vendida");
                        $("#lblestventa").val("PendienteAgenda");
                        $("#lblestventaprovicional").val("PendienteAgenda");
                        $("#lblestventa").show();
                        $("#lblestventaprovicional").hide();  
                        $('.lblverinstaladadel').hide();
                        $('#lblncontrato').val("");
                        
                    }
                    if(categoria =="Online"){
                        $("#lblestadoprospecto").val("Vendida");
                        $("#lblestventa").val("PendienteData");
                    }
                    if(categoria =="Delegacion"){
                        $("#lblestadoprospecto").val("Vendida");
                        $("#lblestventa").val("AgendadaDEL");
                        $("#lblestventaprovicional").val("AgendadaDEL");
                        $('#lblncontrato').val("");
                        $("#lblestventa").hide();
                        $("#lblestventaprovicional").show();
                    }
                    if(categoria =="NoVendida"){
                        $("#lblestadoprospecto").val("NoVendida");
                        $("#lblestventa").val("NoVendida");
                    }   
                    if(categoria =="VRPAsignada"){
                        $("#lblestadoprospecto").val("VRPAsignada");
                        $("#lblestventa").val("");
                    }                 
                }
            });
            //lblmatricula
            $('#lblmatricula').on('keyup', function () {
                var dato = $('#lblmatricula').val();
                var url = 'ajax/findMatricula.php';
                $.ajax({
                    type: 'POST',
                    url: url,
                    data: 'dato=' + dato,
                    success: function (datos) {
                        $('.mensajematricula').html(datos);
                    }
                });
                return false;
            });
            $("#lblmatricula").autocomplete({
                source: "./ajax/selectMatricula.php",
                minLength: 2,
                select: function (event, ui) {
                    event.preventDefault();
                    $('#lblidusuario').val(ui.item.idusuario);
                    $('#lblmatricula').val(ui.item.matricula);
                    $('#lblnombcomercial').val(ui.item.comercial);
//                        $('#lbldc').val(ui.item.dc);
//                        $('#lbljefeventa').val(ui.item.jefe);
                 
                }
            });
            $("#lblmatricula").on("keydown", function (event) {
                if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE)
                {
                    $('#lblidusuario').val("");
                    $('#lblmatricula').val("");
                    $('#lblnombcomercial').val("");
//                        $('#lbldc').val("");
//                        $('#lbljefeventa').val("");

                }
                if (event.keyCode == $.ui.keyCode.DELETE) {
                    $('#lblmatricula').val("");
                    $('#lblidusuario').val("");
                    $('#lblnombcomercial').val("");
//                        $('#lbldc').val("");
//                        $('#lbljefeventa').val("");
                }
            });
            $('#HCertificacion').bootstrapToggle({
                on:'SI',
                off:'NO',
                onstyle:'success',
                offstyle:'danger'
            });
            $('#HCertificacion').change(function(){
                if($(this).prop('checked')){
                    $('#hidden_HCertificacion').val('SI');
                }else{
                    $('#hidden_HCertificacion').val('NO');
                }
            });
            $('#logcambios').click(function () {
                refresh();
            }); 
            
        </script>
        <!-- OTROS EVENTOS -->
        <script>
            $('#visitaConcertada').bootstrapToggle({
                on:'SI',
                off:'NO',
                onstyle:'success',
                offstyle:'danger'
            });
            
            $('#visitaConcertada').change(function(){
                if($(this).prop('checked')){
                    $('#hidVisitaConcertada').val('SI');
                    $('.datosVisitaConcertada').removeClass('ocultar');
                    //.classList().remove('ocultar');
                }else{
                    $('#hidVisitaConcertada').val('NO');
                    $('.datosVisitaConcertada').addClass('ocultar');
                    //.classList().add('ocultar');
                }    
            });

            $('#referidoHabilitado').change(function(){
                $("#referidoHabilitado option:selected").each(function () {
                var referidoHabilitado = $(this).val();
                    refhabilitada(referidoHabilitado);
                });
            });

            $('.copiarurl').on('click', function(){
             var content = document.getElementById('urlreferidoHabilitado');
                content.select();
                document.execCommand('copy');
                alertify.success("Copiado!");
            });
            
            $('.irurl').on('click', function(){
             var content = document.getElementById('urlreferidoHabilitado');
                window.open(content.value, '_blank').focus();
            });
            
            $('.actualizarcantidadref').on('click', function(){
                var idprospectorp=$('#datosIdProspectoRp').val();
                var tipoventa=$('#lbltiventa').val();
                var data = {idprospectorp:idprospectorp,tipoventa:tipoventa};
                fetch("./ajax/findCantidadReferidos.php",{method:'POST',body: JSON.stringify(data)})
                    .then(function(res) {return res.json();})
                    .then(function(data) {     
                        if(data.resultado=='Actualizado'){
                        Swal.fire(
                          'Actualizado!',
                          data.mensaje,
                          'success'
                            );
                        $('#cantidadreferidoHabilitado').val(data.cantidad);                        
                        }else{
                        Swal.fire(
                          'Error!',
                          data.mensaje,
                          'error'
                            );                        
                        }
                        $('#cantidadreferidoHabilitado').val(data.cantidad);
                    })
                    .catch(function(error) {
                        Swal.fire(
                          'Error!',
                          'Actualizar la página',
                          'error'
                            );  
                        
                    });            
             
            });
            
            $('#GGCC').bootstrapToggle({
                on:'SI',
                off:'NO',
                onstyle:'success',
                offstyle:'danger'
            });
            
            $('#GGCC').change(function(){
                if($(this).prop('checked')){
                    $('#hidGGCC').val('SI');
                    
                }else{
                    $('#hidGGCC').val('NO');
                }
                
                const scoring = $('#lblresultadoScoring').val();
                const tipokit = $('#lbltipokit').val();
                const PAI = $('#lblPAI').val();
                
                if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
                    return;
                } else {
                    categoriaPrecio(scoring, tipokit, PAI);
                }
            });            
            
            //Date picker
            $('#fechaVisitaConcertada').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1,
                todayHighlight: true,
                format: 'dd/mm/yyyy'
            });
                //Date picker
            $('#horaVisitaConcertada').timepicker({
                defaultTime:false,                                                                                    
                showInputs: true,
                minuteStep: 1
            });
            
            function refhabilitada(value) {
                var idprospectorp=$('#datosIdProspectoRp').val();
                var tipoventa=$('#lbltiventa').val();
                var refhabilitada = value;
                if(refhabilitada=="SI"){
                    $('.datosreferidoHabilitado').removeClass('ocultar');
                            //.classList().remove('ocultar');
                }else{
                    $('.datosreferidoHabilitado').addClass('ocultar');
                } 
                
                Swal.fire({
                    icon: 'question',
                    title: '¿Quieres guardar el cambio?',
                    showDenyButton: true,
                    showCancelButton: false,
                    confirmButtonText: `Modificar`,
                    denyButtonText: `Cancelar`,
                    allowOutsideClick: false
                }).then((result) => {
                    /* Read more about isConfirmed, isDenied below */
                    if (result.isConfirmed) {
                        if(refhabilitada=="SI"){
                            $('#hidreferidoHabilitado').val("SI");
                                    //.classList().remove('ocultar');
                        }else if(refhabilitada=="NO"){
                            $('#hidreferidoHabilitado').val("NO");
                            //.classList().add('ocultar');
                        }else{
                            $('#hidreferidoHabilitado').val("");
                                } 
                        
                        $.ajax({
                            type: 'post',
                            url: 'ajax/changeReferidoHabilitado.php',
                            data: {
                                refhabilitada: refhabilitada,
                                idprospectorp: idprospectorp,
                                tipoventa:tipoventa
                            },
                            success: function(data) {
                                console.log(data);
                                if (data == 1) {
                                    Swal.fire('Modificado!', '', 'success');
    
                                } else if (data == 0) {
                                    swal.fire(
                                        'Alerta',
                                        'Sin cambios',
                                        'warning');
                                } else {
                                    swal.fire(
                                        'Error',
                                        'Error en la actualizacion',
                                        'error');
                                }
                            }
                        });
    
                    } else if (result.isDenied) {
                        var refhabilitadaN=$('#hidreferidoHabilitado').val();
                        if (refhabilitadaN == 'SI') {
                            //$('#cotenviada').prop('checked',false);
                            //$('#referidoHabilitado option:selected').val($('#hidreferidoHabilitado').val());
                            $('.datosreferidoHabilitado').removeClass('ocultar');
                        } else if (refhabilitadaN == 'NO')  {
                            //$('#hidreferidoHabilitado').val('SI');
                            //$('#cotenviada').prop('checked',true);
                            //$('#referidoHabilitado option:selected').val('NO');
                            $('.datosreferidoHabilitado').addClass('ocultar');
                        }else{
                            $('#hidreferidoHabilitado').val('');
                            //$('#cotenviada').prop('checked',true);
                            //$('#referidoHabilitado option:selected').val('');
                            $('.datosreferidoHabilitado').addClass('ocultar');
                        }
                        $('#referidoHabilitado').val(refhabilitadaN);
                        Swal.fire('Los cambios no se guardan', '', 'info');
                    }
                })
    
    
            }            

        </script>
        <!-- SCORING DEPARTAMENTO -->
        <script>
            $(function () {

            $("#Departamental").change(function () {
                $("#Departamental option:selected").each(function () {
                    var Provincial = $(this).val();
                    var datos={
                        Provincial:Provincial
                    };
                    var provincia= $("#Provincial");
                    var distrito= $("#Distrital");
                     $.ajax({
                    data:datos,
                    url:   './ajax/selectProvincial.php',
                    type:  'POST',
                    dataType: 'json',
                    beforeSend: function () 
                    {
                        //provincia.prop('disabled', true);
                        //distrito.prop('disabled', true);
                    },
                    success:  function (r) 
                    {
                        provincia.prop('disabled', false);
                        distrito.prop('disabled', false);
                        
                        // Limpiamos el select de Provincia
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');
                        // Limpiamos el select de Distrito
                        distrito.find('option').remove();
                        distrito.append('<option value="">Seleccione</option>');
                        
                        $(r).each(function(i, v){ // indice, valor
                            provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                        })
                        
                        provincia.prop('disabled', false);
                        distrito.prop('disabled', false);
                    },
                    error: function()
                    {
                        //alert('Ocurrio un error en el servidor ..');
                        provincia.prop('disabled', false);
                        distrito.prop('disabled', false);
                    }
                });

                });
            });
            
            $("#Provincial").change(function () {
                $("#Provincial option:selected").each(function () {
                    var Provincial = $(this).val();
                    var datos={
                        Provincial:Provincial
                    };
                    var provincia= $("#Distrital");
                     $.ajax({
                    data:datos,
                    url:   './ajax/selectDistrital.php',
                    type:  'POST',
                    dataType: 'json',
                    beforeSend: function () 
                    {
                       //provincia.prop('disabled', true);
                    },
                    success:  function (r) 
                    {
                        provincia.prop('disabled', false);
                        
                        // Limpiamos el select
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');
                        
                        $(r).each(function(i, v){ // indice, valor
                            provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                        })
                        
                        provincia.prop('disabled', false);
                    },
                    error: function()
                    {
                        //alert('Ocurrio un error en el servidor ..');
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');
                        provincia.prop('disabled', false);
                    }
                });

                });
            });
            
            //Validaciones
            //nombres apellido_p apellido_m
            $("#nombres").bind('keypress', function(event) {
              var regex = new RegExp("^[a-zA-Z ]+$");
              var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
              if (!regex.test(key)) {
                event.preventDefault();
                return false;
              }
            });
            
            $("#apellido_p").bind('keypress', function(event) {
              var regex = new RegExp("^[a-zA-Z ]+$");
              var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
              if (!regex.test(key)) {
                event.preventDefault();
                return false;
              }
            });  
            $("#apellido_m").bind('keypress', function(event) {
              var regex = new RegExp("^[a-zA-Z ]+$");
              var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
              if (!regex.test(key)) {
                event.preventDefault();
                return false;
              }              
              
            });
              $("#btnModalconsultascoring").click(function(event) {
                  const modalsegmento=$("#Segmento");

                    const lbltipoventa = $('#lbltipoventa').val();
                    if(lbltipoventa=="RP" || lbltipoventa=="RPPA" || lbltipoventa=="RPPR" || lbltipoventa=="RPMKT" || lbltipoventa=="RPTMK"){
                        $("#Departamental").prop('disabled', true);
                        $("#Provincial").prop('disabled', true);
                        
                    }
                  
               $("#lblsegmento option:selected").each(function () {
                    var segmento = $(this).val();
                      modalsegmento.val(segmento);
                      modalsegmento.trigger('change');
                    });                  
            });         
            

        });
            
            


        </script>
        <!-- INCIALIZADORES -->
        <script>
            $('.selectdistrito').select2({
                    placeholder: 'Seleccione Distrito - Provincia',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {

                            return "Buscando..";
                        }
                    },
                    ajax: {
                        url: 'ajax/selectDistritoField.php',
                        dataType: 'json',
                        delay: 250,
                        processResults: function (data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    }
                });
                $('.selectdistrito').on('select2:select', function (e) {
                    var data = e.params.data;
                    $('#lblIdDepartamental').val(data.IdDepartamental);
                    $('#lblIdProvincial').val(data.IdProvincial);
                    $('#lblCodUbigeoReniec').val(data.CodUbigeoReniec);
                    
                    cargardepartamento();
                    //console.log(data);
                });                 
        
                $('.cbxtecnico').select2({
                    placeholder: 'Seleccione',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {

                            return "Buscando..";
                        }
                    }
                });
                          
                $('#datemask').inputmask('dd/mm/yyyy', {'placeholder': 'dd/mm/yyyy'});
           
                $('#lblfecharecpciondoc').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                $('#lblfechafacturacion').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                //Money Euro
                $('[data-mask]').inputmask();
                
                //Date picker
                var DP_FechaFin = new Date();
                var dias = 30; // Número de días a agregar
                DP_FechaFin.setDate(DP_FechaFin.getDate() + dias);
                
                $('#fechainst').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1,
                    todayHighlight: true,
                    format: 'dd/mm/yyyy',
                    startDate: new Date(),
                    endDate: DP_FechaFin,
                    clearBtn:true,
                    todayBtn: 'linked',
                });
                
                $('#lblRvencimiento').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1,
                    todayHighlight: true,
                    format: 'dd/mm/yyyy',
                    clearBtn:true,
                    todayBtn: 'linked',
                });                
                
                //Date picker
                $('#horainst').timepicker({
                     defaultTime:false,
                    showInputs: true,
                     minuteStep: 15
                });
                $('#mesano').datepicker({
                    autoclose: true,
                    language: 'en',
                    firstDay: 1, format: 'M-yyyy',
                    viewMode: "years",
                    minViewMode: "months"
                });

                $('.select2full').select2({
                    selectOnClose: true
                });
                                                          
                $(document).on('keydown', '.select2', function(e) {
                  if (e.originalEvent && e.which == 40) {
                    e.preventDefault();
                    $(this).siblings('select').select2('open');
                  } 
                });
                
                $(document).on("select2:close", '.select2-hidden-accessible', function () { $(this).focus(); });
        </script>
        <!-- SCRIPT DOCUMENT READY -->
        <script>
            $(document).ready(function () {
                
                //NOTIFICACIONES
                const headerCCUsuario = $('#headerCCUsuario').val();
                notificacionVisitasField(headerCCUsuario);
                                                                                
                bloquear('<?php echo $estadoventa; ?>');
                bloquearxCategoria('<?php echo $categoriaventa; ?>');
                bloquearxResultado('<?php echo $categoriaventa; ?>');
                
                //FUNCION TIPO KIT Y CLOSINGPACK
                //tipoKit();
                //closingPack();
                
                cargardepartamento();
                
                $('#lbltipokit').val($('#valtipokit').val());
                //$('#lblclosingpack').val($('#valclosingpack').val());
                //$('#lblprecioEspecial').val($('#valprecioEspecial').val());
                
                $('#lblresultadoScoring').val($('#valresultadoScoring').val());

                var alterClass = function () {
                    var ww = document.body.clientWidth;
                    if (ww < 767) {
                        $('body').removeClass('sidebar-collapse');
                    } else if (ww >= 768) {
                        $('body').addClass('sidebar-collapse');
                    }
                    ;
                };
    
                $(window).resize(function () {
                    alterClass();
                });
                //Fire it when the page first loads:
                alterClass();
                
                //************************************************************
                //--------------NUEVA FUNCIONALIDAD CARRITO DE COMPRA---------
                //************************************************************
                
                const scoring = $('#lblresultadoScoring').val();
                const tipokit = $('#lbltipokit').val();
                const PAI = $('#lblPAI').val();
                
                if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
                    return;
                } else {
                    categoriaPrecio(scoring, tipokit, PAI);
                    
                    closingPack();
                    
                    $('#lblclosingpack').val($('#valclosingpack').val());   
                }
                
                //GUARDAR DATOS EN LOS ARREGLOS GLOBALES
                
                //ARREGLO GENERAL
                if($('#datosGeneral').val() != ''){
                    arregloGeneral = JSON.parse($('#datosGeneral').val());
                }
                if($('#datosRegalos').val() != ''){
                    arregloRegalos = JSON.parse($('#datosRegalos').val());
                }
                if($('#datosExtras').val() != ''){
                    arregloDatos = JSON.parse($('#datosExtras').val());
                }
            });
        </script>
        <!-- BOTON GUARDAR -->
        <script>
            $('#btnGuardarEditarVenta').click(function () {
                var estadoGuiaRemision = $('#estadoGuiaRemision').val();
                // if(estadoGuiaRemision === 'Delegacion'){
                //     Swal.fire({
                //             title: 'Advertencia!',
                //             text: 'La Guia de Remisión esta pendiente no puedes generar la venta',
                //             icon: 'warning',
                //             showCancelButton: false,
                //             confirmButtonText: 'OK',
                //             closeOnConfirm: false,
                //             allowOutsideClick: false
                //         }).then((result) => {
                //             // Si el usuario hace clic en OK, recargar la página
                //             if (result.isConfirmed) {
                //                 // window.location.reload();
                //             }
                //         });
                // }else{
                var gestor=$('#matriculausuario').val();
                var catgventa=$('#lblcat').val();
                var idprospectorp=$('#datosIdProspectoRp').val();
                //Algunas variables por default de alertify
                alertify.defaults.theme.ok = "btn btn-nuevo";
                alertify.defaults.theme.cancel = "btn btn-danger";
                if (catgventa == 'VRPAsignada'){
                    Swal.fire(
                      'Alerta!',
                      'Debes modificar la categoria de la VENTA',
                      'warning'
                    )
                } else {
                    var lastX,lastY;
                        alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function(){ 
                            // Primero validará el formulario.
                                if (validaForm()) {
                                    //var datos = $('#frmEditarVenta').serialize();
                                    var lblmatricula = $('#lblmatricula').val();
                                    var lblidusuario = $('#lblidusuario').val();
                                    var lblnombcomercial = $('#lblnombcomercial').val();
                                    var lbldc = $('#lbldc').val();
                                    var lbljefeventa = $('#lbljefeventa').val();
                                    var lblidcliente = $('#lblidcliente').val();
                                    var lblnombcliente = $('#lblnombcliente').val();
                                    var lblcorreo = $('#lblcorreo').val();
                                    var lbldireccion = $('#lbldireccion').val();
                                    var lbldistrito = $('#lbldistrito').val();
                                    var lblmovil = $('#lblmovil').val();
                                    var lblfijo = $('#lblfijo').val();
                                    var lbltiventa = $('#lbltiventa').val();
                                    var lblsegmento = $('#lblsegmento').val();
                                    var lblestadoprospecto = $('#lblestadoprospecto').val();
                                    var lblestventa = $('#lblestventa').val();
                                    var lblmesesautorizados = $('#lblmesesautorizados').val();
                                    var lblpreciokit = $('#lblpreciokit').val();
                                    var lbltotalextra = $('#lbltotalextra').val();
                                    var lblresumenventa = $('#lblresumenventa').val();
                                    var lblextraautorizado = $('#lblextraautorizado').val();
                                    var lblformadepago = $('#lblformadepago').val();
                                    var lbl590 = $('#mesano').val();
                                    var lblPAI = $('#lblPAI').val();
                                    var lblcomentarioprospecto = $('#lblcomentarioprospecto').val();
                                    var lblidagenda = $('#lblidagenda').val();
                                    var lblcancelado = $('#lblcancelado').val();
                                    var lblinstaladox = $('#lblinstaladox').val();
                                    var lbltecnico = $('#lbltecnico').val();
                                    var lblfinstalacion = $('#fechainst').val();
                                    var lblhinstalacion = $('#horainst').val();
                                    var lblcomentarioagenda = $('#lblcomentarioagenda').val();
                                    var hidden_HCertificacion = $('#hidden_HCertificacion').val();
                                    //NUEVOS CAMPOS GENERADOS EL 02112020 PARA PILOTO ZEROVISION
                                    var lbltipokit=$('#lbltipokit').val();
                                    var lblclosingpack=$('#lblclosingpack').val();
                                    var lblprecioEspecial=$('#lblprecioEspecial').val();
                                    var lblCantExtras=$('#lblCantExtras').val();
                                    var lblresultadoScoring=$('#lblresultadoScoring').val();
                                    //NUEVOS CAMPOS GENERADOS PARA EL PILOTO CHECKINRP
                                    var hidVisitaConcertada=$('#hidVisitaConcertada').val();
                                    var fechaVisitaConcertada=$('#fechaVisitaConcertada').val();
                                    var horaVisitaConcertada=$('#horaVisitaConcertada').val();
                                    //NUEVOS CAMPOS GENERADOS PARA SCORING
                                    var valcodigoOperacionScoring=$('#valcodigoOperacionScoring').val();
                                    var hidGGCC=$('#hidGGCC').val();
                                    var lblformapagocuota='';
                                    var lblncontrato=$('#lblncontrato').val();
                                    //NUEVOS CAMPOS GENERADOS EL 03082021 PARA EXTRAS Y REGALOS
                                    const lblCantRegalos = $('#lblCantRegalos').val();
                                    const lbltotalcuota = $('#lbltotalcuota').val();
                                    const detalleExtras = JSON.stringify(arregloDatos);
                                    const detalleRegalos = JSON.stringify(arregloRegalos);
                                    const detalleGeneral = JSON.stringify(arregloGeneral);
                                    //NUEVOS CAMPOS GENERADOS PARA LA OFERTA
                                    const lblcategoriaprecio = $('#lblcategoriaprecio').val();
                                    const lblDescuentoCuota = $('#lblDescuentoCuota').val();
                                    //CAMPOS DE ARLOS
                                    const lbltipocamarakit=$('#lbltipocamarakit').val();
                                    const lblsegundaalarma=$('#lblsegundaalarma').val(); 
                                    //AUDITORIA
                                    var lblIteraccionAttec = $('#lblIteraccionAttec').val(); 
                                    
                                    var lblRenove = $('#lblRenove').val();
                                    var lblRcompetencia = $('#lblRcompetencia').val();
                                    var lblRvencimiento = $('#lblRvencimiento').val();
                                    var lblcomentario_comercial = $('#lblcomentario_comercial').val();
                                    var lblhorariosugerido2 = $('#lblhorariosugerido2').val();
    
                                    datos = {
                                        lblnombcliente:lblnombcliente,
                                        lblcorreo:lblcorreo,
                                        lbldireccion:lbldireccion,
                                        lbldistrito:lbldistrito,
                                        lblmovil:lblmovil,
                                        lblfijo:lblfijo,
                                        lblcategoria:catgventa,
                                        lblidprospectorp:idprospectorp,
                                        gestor:gestor,
                                        lblmatricula:lblmatricula,
                                        lblidusuario:lblidusuario,
                                        lblnombcomercial:lblnombcomercial,
                                        lbldc:lbldc,
                                        lbljefeventa:lbljefeventa,
                                        lblidcliente:lblidcliente,
                                        lbltiventa:lbltiventa,
                                        lblsegmento:lblsegmento,
                                        lblestadoprospecto:lblestadoprospecto,
                                        lblestventa:lblestventa,
                                        lblmesesautorizados:lblmesesautorizados,
                                        lblpreciokit:lblpreciokit,
                                        lbltotalextra:lbltotalextra,
                                        lblresumenventa:lblresumenventa,
                                        lblextraautorizado:lblextraautorizado,
                                        lblformadepago:lblformadepago,
                                        lbl590:lbl590,
                                        lblPAI:lblPAI,
                                        lblcomentarioprospecto:lblcomentarioprospecto,
                                        lblidagenda:lblidagenda,
                                        lblcancelado:lblcancelado, 
                                        lblinstaladox:lblinstaladox, 
                                        lbltecnico:lbltecnico, 
                                        lblfinstalacion:lblfinstalacion, 
                                        lblhinstalacion:lblhinstalacion, 
                                        lblcomentarioagenda:lblcomentarioagenda,
                                        hidden_HCertificacion: hidden_HCertificacion,
                                        lbltipokit: lbltipokit,
                                        lblclosingpack: lblclosingpack,
                                        lblprecioEspecial: lblprecioEspecial,
                                        lblCantExtras: lblCantExtras,
                                        lblresultadoScoring: lblresultadoScoring,
                                        hidVisitaConcertada: hidVisitaConcertada,
                                        fechaVisitaConcertada: fechaVisitaConcertada,
                                        horaVisitaConcertada: horaVisitaConcertada,
                                        valcodigoOperacionScoring:valcodigoOperacionScoring,
                                        hidGGCC:hidGGCC,
                                        lblformapagocuota:lblformapagocuota,
                                        lblncontrato:lblncontrato,
                                        lblCantRegalos: lblCantRegalos,
                                        lbltotalcuota: lbltotalcuota,
                                        detalleExtras: detalleExtras,
                                        detalleRegalos: detalleRegalos,
                                        lblcategoriaprecio: lblcategoriaprecio,
                                        detalleGeneral: detalleGeneral,
                                        lblDescuentoCuota: lblDescuentoCuota,
                                        lbltipocamarakit:lbltipocamarakit,
                                        lblsegundaalarma:lblsegundaalarma,
                                        lblIteraccionAttec:lblIteraccionAttec,
                                        lblRenove:lblRenove,
                                        lblRcompetencia:lblRcompetencia,
                                        lblRvencimiento:lblRvencimiento,
                                        lblcomentario_comercial:lblcomentario_comercial,
                                        lblhorariosugerido2:lblhorariosugerido2
                                    };
                                                        
                                    console.log(datos);
                                                       
                                    $.ajax({
                                        type: 'POST',
                                        url: 'ajax/updateProspectoRP_scoring_v2.php',
                                        data: datos,
                                        success: function (r) {
                                            console.log(r);
                                            if (r == 1) {
                                                alertify.success("Modificado con exito");
                                            }else if(r==4){
                                                alertify.warning("Se ha verificado que el resultado Scoring no se encuentra actualizado, por favor de scorear nuevamente");
                                                $("#frmEditarVenta #lblresultadoScoring").focus();
                                            }else if(r==5){
                                                alertify.success("Modificado con exito");
                                            }else if(r==6){
                                                bloquearxResultado('Ficha');
                                                alertify.success("Grabado con exito la venta");
                                            }
                                            else if(r==7){
                                                bloquearxResultado('Delegacion');
                                                alertify.success("Grabado con exito la venta");
                                            }
                                            else if(r==2){
                                                alertify.warning("No se puede realizar cambios");
                                            }
                                            else if(r==9){
                                                alertify.warning("Ya existe NContrato");
                                            }else {
                                                alertify.error("Fallo el server");
                                               
                                            }
                                        }
                                    });
                                    
                                } //END IF VALIRDAR FORM 
                            }   //END FUNCTION CONFIRMAR ALERTIFY
                            , function(){ 
                                alertify.error('No se han guardado los cambios')}
                            ).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
                                    lastX = window.scrollX;
                                    lastY = window.scrollY;
                                },'onfocus':function(){window.scrollTo(lastX, lastY);}  }).show(); 
                    } //END ELSE    
                // }
                
            }); //END BTNGUARDAR
        </script>
        <!-- SCRIPT FUNCIONES -->
        <script>
            function bloquear(condiciones){
                $('#tinviable').hide();
                $('#lblinviable').hide();
                $('#lblinviable').disabled=true;
                $('#tinviableespacio').hide();
                
                $('#tcancelado').hide();
                $('#lblcancelado').hide();
                $('#lblcancelado').disabled=true;
                $('#tcanceladoespacio').hide();
                        
                if (condiciones == "Inviable") {
                    $('#tinviable').show();
                    $('#lblinviable').show();
                    $('#lblinviable').show();
                    $('#lblinviable').disabled=false;
                    $('#tinviableespacio').show();
                }else if(condiciones=="AgendadaTEC" || condiciones=="Instalada" || condiciones=="Facturada" || condiciones=="Incidencia" || condiciones=="IncidenciaGestCorreo" || condiciones=="IncidenciaGestValija" || condiciones=="NoDoc" || condiciones=="DocEnvi" ){
                    $('#lblcategoria')[0].disabled=true;  
                }
                else if(condiciones=="Cancelado"){
                    $('#tcancelado').show();
                    $('#lblcancelado').show();
                    $('#lblcancelado').disabled=false;
                    $('#tcanceladoespacio').show();
                } 
                else {
                    $('#tinviable').hide();
                    $('#lblinviable').hide();
                    $('#lblinviable').disabled=true;
                    $('#tinviableespacio').hide();
                    $('#tcancelado').hide();
                    $('#lblcancelado').hide();
                    $('#lblcancelado').disabled=true;
                    $('#tcanceladoespacio').hide();
                }
    
            }
            
            function bloquearxResultado(categoria){
                if(categoria=="Delegacion"){
                    $('#btnGuardarEditarVenta').hide();
                    $('#lblcategoria')[0].disabled=true;
                    $('.lblver590').show();
                    $('#veragenda').show();
                    $('#lblmatricula')[0].disabled=true;
                    $('#lblnombcomercial')[0].disabled=true;
                    $('#lbldc')[0].disabled=true;
                    $('#lbljefeventa')[0].disabled=true;
                    $('#lblnombcliente')[0].disabled=true;
                    $('#lblcorreo')[0].disabled=true;
                    $('#lbldireccion')[0].disabled=true;
                    $('#lbldistrito')[0].disabled=true;
                    $('#lblmovil')[0].disabled=true;
                    $('#lblfijo')[0].disabled=true;
                    $('#lbltipoventa')[0].disabled=true;
                    $('#lblsegmento')[0].disabled=true;
                    $('#lblmesesautorizados')[0].disabled=true;
                    $('#lblpreciokit')[0].disabled=true;
                    $('#lbltotalextra')[0].disabled=true;
                    $('#lblresumenventa')[0].disabled=true;
                    $('#lblextraautorizado')[0].disabled=true;
                    $('#lblformadepago')[0].disabled=true;
                    $('#mesano')[0].disabled=true;
                    $('#lblPAI')[0].disabled=true;
                    $('#lblcomentarioprospecto')[0].disabled=true;
                    $('#lblinstaladox')[0].disabled=true;
                    $('#lbltecnico')[0].disabled=true;
                    $('#fechainst')[0].disabled=true;
                    $('#horainst')[0].disabled=true;
                    $('#lblcomentarioagenda')[0].disabled=true;
                    $('#lblinviable')[0].disabled=true;
                    //Nuevos campos
                    $('.scoring').hide();
                    
                }else if(categoria=="Ficha"){
                    $('.lblver590').show();
                    $('#veragenda').hide();
                    $('#btnGuardarEditarVenta').hide();
                    $('#lblcategoria')[0].disabled=true;
                    $('#lblmatricula')[0].disabled=true;
                    $('#lblnombcomercial')[0].disabled=true;
                    $('#lbldc')[0].disabled=true;
                    $('#lbljefeventa')[0].disabled=true;
                    $('#lblnombcliente')[0].disabled=true;
                    $('#lblcorreo')[0].disabled=true;
                    $('#lbldireccion')[0].disabled=true;
                    $('#lbldistrito')[0].disabled=true;
                    $('#lblmovil')[0].disabled=true;
                    $('#lblfijo')[0].disabled=true;
                    $('#lbltipoventa')[0].disabled=true;
                    $('#lblsegmento')[0].disabled=true;
                    $('#lblmesesautorizados')[0].disabled=true;
                    $('#lblpreciokit')[0].disabled=true;
                    $('#lbltotalextra')[0].disabled=true;
                    $('#lblresumenventa')[0].disabled=true;
                    $('#lblextraautorizado')[0].disabled=true;
                    $('#lblformadepago')[0].disabled=true;
                    $('#mesano')[0].disabled=true;
                    $('#lblPAI')[0].disabled=true;
                    $('#lblcomentarioprospecto')[0].disabled=true;
                    //Nuevos campos
                    $('.scoring').hide();
                    $('.lblverinstaladadel').hide();
                } 
                else{
                    $('.lblver590').hide();
                    $('#veragenda').hide();
                    $('#lblinstaladox')[0].disabled=true;
                    $('#lbltecnico')[0].disabled=true;
                    $('#fechainst')[0].disabled=true;
                    $('#horainst')[0].disabled=true;
                    $('#lblcomentarioagenda')[0].disabled=true;
                    $('#lblinviable')[0].disabled=true;
                    $('.lblverinstaladadel').hide();
                }
            }
            
            function bloquearxCategoria(categoria){
                if(categoria=="Delegacion"){
                    $('.lblver590').show();
                    $('#veragenda').show();
                    $('#lblinstaladox')[0].disabled=false;
                    $('#lbltecnico')[0].disabled=false;
                    $('#fechainst')[0].disabled=false;
                    $('#horainst')[0].disabled=false;
                    $('#lblcomentarioagenda')[0].disabled=false;
                    $('#lblinviable')[0].disabled=false;
                }else if(categoria=="Ficha"){
                    $('.lblver590').show();
                    $('#veragenda').hide();
                    $('#lblinstaladox')[0].disabled=true;
                    $('#lbltecnico')[0].disabled=true;
                    $('#fechainst')[0].disabled=true;
                    $('#horainst')[0].disabled=true;
                    $('#lblcomentarioagenda')[0].disabled=true;
                    $('#lblinviable')[0].disabled=true;
                } else if(categoria=="VRPAsignada"){
                    $('#lblnombcliente')[0].disabled=true;
                    $('#lblcorreo')[0].disabled=true;
                    $('#lbldireccion')[0].disabled=true;
                    $('#lbldistrito')[0].disabled=true;
                    $('#lblmovil')[0].disabled=true;
                    $('#lblfijo')[0].disabled=true;
                } else if(categoria=="ClienteError" || categoria=="TelefonoError" || categoria=="ZSCC" || categoria== "Provincia" || categoria== "Inviable" || categoria=="Rechazada" || categoria==  "AnuladaOP" || categoria== "AnuladaCLI" || categoria== "AnuladaTEC" ){
                    $('#lblnombcliente')[0].disabled=true;
                    $('#lblcorreo')[0].disabled=true;
                    $('#lbldireccion')[0].disabled=true;
                    $('#lbldistrito')[0].disabled=true;
                    $('#lblmovil')[0].disabled=true;
                    $('#lblfijo')[0].disabled=true;
                    $('#btnGuardarEditarVenta').hide();
                } else if(categoria=="VisitaAceptada"||categoria=="DevolverLlamada"||categoria=="NoContesta"){
                    $('#lblnombcliente')[0].disabled=true;
                    $('#lblcorreo')[0].disabled=true;
                    $('#lbldireccion')[0].disabled=true;
                    $('#lbldistrito')[0].disabled=true;
                    $('#lblmovil')[0].disabled=true;
                }
                else{
                    $('.lblver590').hide();
                    $('#veragenda').hide();
                    $('#lblinstaladox')[0].disabled=true;
                    $('#lbltecnico')[0].disabled=true;
                    $('#fechainst')[0].disabled=true;
                    $('#horainst')[0].disabled=true;
                    $('#lblcomentarioagenda')[0].disabled=true;
                    $('#lblinviable')[0].disabled=true;
                }

            }
            
            function validaForm() {
                
                
                // Campos de texto
                if ($("#frmEditarVenta #lblmatricula").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula correspondiente");
                    $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lblnombcomercial").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula valida");
                    $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lbldc").val() == "" || $("#frmEditarVenta #lbldc").val() == "Seleccione" ) {
                    alertify.warning("Por favor ingresar CC correcto");
                    $("#frmEditarVenta #lbldc").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lbljefeventa").val() == "" || $("#frmEditarVenta #lbljefeventa").val() == "No se encontraron resultado") {
                    alertify.warning("Por favor revisar Jefe de Estructura Comercial");
                    $("#frmEditarVenta #lbljefeventa").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lblnombcliente").val() == "") {
                    alertify.warning("Por favor ingresar Nombre del Cliente");
                    $("#frmEditarVenta #lblnombcliente").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblcorreo").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#frmEditarVenta #lblcorreo").val())) {
                    alertify.warning("Por favor ingresar correo válido");
                    $("#frmEditarVenta #lblcorreo").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lbldireccion").val() == "") {
                    alertify.warning("Por favor ingresar la Direccion del Cliente");
                    $("#frmEditarVenta #lbldireccion").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lbldistrito").val() =="") {
                    alertify.warning("Por favor ingresar Distrito correcto");
                 
                    $("#frmEditarVenta #lbldistrito").select2('open');
                    return false;
                }
                if ($("#frmEditarVenta #lblmovil").val() == "") {
                    alertify.warning("Por favor ingresar Telefono, de caso contrario digite: 0");
                    $("#frmEditarVenta #lblmovil").focus();
                    return false;
                }
                if ($("#frmEditarVenta #hidVisitaConcertada").val() == "SI"){
                    console.log($("#frmEditarVenta #fechaVisitaConcertada").val().length);
                    if ($("#frmEditarVenta #fechaVisitaConcertada").val() == "" || $("#frmEditarVenta #fechaVisitaConcertada").val().length==0){
                        alertify.warning("Por favor ingresar Fecha Visita Concertada");
                        $("#frmEditarVenta #fechaVisitaConcertada").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #horaVisitaConcertada").val() == "" || $("#frmEditarVenta #horaVisitaConcertada").val().length==0){
                        alertify.warning("Por favor ingresar Hora Visita Concertada");
                        $("#frmEditarVenta #horaVisitaConcertada").focus();
                        return false;
                    }
                }
                if ($("#frmEditarVenta #referidoHabilitado option:selected").val() == "") {
                    alertify.warning("Por favor seleccionar SI/NO en informacion de Referido");
                    $("#frmEditarVenta #referidoHabilitado").focus();
                    return false;
                }                

    
                
                //VALIDACION CUANDO EL PROSPECTO SE VENDE -- CATEGORIA FICHA
                if ($("#lblcat").val() == "Ficha") {
                    
                    if ($("#frmEditarVenta #cantidadreferidoHabilitado").val() == 0) {
                            Swal.fire(
                              '¡Advertencia!',
                              'Para continuar, debes ingresar al menos 1 referido. En caso ya hayas ingresado el referido, por favor presiona el botón Actualizar Número de Referidos',
                              'warning'
                                );
                        
                        $("#frmEditarVenta #cantidadreferidoHabilitado").focus();
                        return false;
                    }
                    
                    
                    if ($("#frmEditarVenta #lblpreciokit").val() == "") {
                        alertify.warning("Por favor ingresar Precio del KIT");
                        $("#frmEditarVenta #lblpreciokit").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lbltotalextra").val() == "") {
                        alertify.warning("Por favor ingresar Total de Extra, de caso contrario digite: 0");
                        $("#frmEditarVenta #lbltotalextra").focus();
                        return false;
                    }

                    if ($("#frmEditarVenta #lblresumenventa").val() == "") {
                        alertify.warning("Por favor ingresar Resumen de Venta");
                        $("#frmEditarVenta #lblresumenventa").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblformadepago").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Forma de Pago");
                        $("#frmEditarVenta #lblformadepago").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #mesano").val() == "") {
                        alertify.warning("Por favor ingresar 590");
                        $("#frmEditarVenta #mesano").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblPAI").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar PAI");
                        $("#frmEditarVenta #lblPAI").focus();
                        return false;
                    }

                    if ($("#frmEditarVenta #lblestadoventa").val() == "Seleccione" || $("#frmEditarVenta #lblestadoventa").val() == "") {
                        alertify.warning("Por favor ingresar Estado de Venta correcto");
                        $("#frmEditarVenta #lblestadoventa").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lbltipoventa").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Recurso correcto");
                        $("#frmEditarVenta #lbltipoventa").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblsegmento").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Segmento correcto");
                        $("#frmEditarVenta #lblsegmento").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblmesesautorizados").val() == "") {
                        alertify.warning("Por favor ingresar MesAutorizado.Si no tuviese coloque: 0");
                        $("#frmEditarVenta #lblmesesautorizados").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lbltipokit").val() == "" || $("#frmEditarVenta #lbltipokit").val() == null) {
                        alertify.warning("Por favor ingresar Tipo Kit");
                        $("#frmEditarVenta #lbltipokit").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblclosingpack").val() == "" || $("#frmEditarVenta #lblclosingpack").val() == null){
                        alertify.warning("Por favor ingresar Closing Pack");
                        $("#frmEditarVenta #lblclosingpack").focus();
                        return false;
                    }
                    /*
                    if ($("#frmEditarVenta #lblprecioEspecial").val() == "" || $("#frmEditarVenta #lblprecioEspecial").val() == null) {
                        alertify.warning("Por favor ingresar PRECIO ESPECIAL");
                        $("#frmEditarVenta #lblprecioEspecial").focus();
                        return false;
                    }
                    */
                    if ($("#frmEditarVenta #lblresultadoScoring").val() == "" || $("#frmEditarVenta #lblresultadoScoring").val() == null) {
                        alertify.warning("Por favor ingresar RESULTADO SCORING");
                        $("#frmEditarVenta #lblresultadoScoring").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #valcodigoOperacionScoring").val() == "" || $("#frmEditarVenta #valcodigoOperacionScoring").val() == null) {
                        alertify.warning("Por favor seleccionar RESULTADO SCORING, puede ver en CONSULTAS DOC.");
                        $("#frmEditarVenta #lblresultadoScoring").focus();
                        return false;
                    }
                    
                    
                    if ($("#frmEditarVenta #lblCantExtras").val() == "" ) {
                        alertify.warning("Por favor ingresar CANTIDAD EXTRAS");
                        $("#frmEditarVenta #lblCantExtras").focus();
                        return false;
                    }
                    
                    if ($("#frmEditarVenta #lblCantExtras").val() == "" ) {
                        alertify.warning("Por favor ingresar CANTIDAD EXTRAS");
                        $("#frmEditarVenta #lblCantExtras").focus();
                        return false;
                    }
                    
                    if($('#lblcategoriaprecio').val() == '' || $('#lblcategoriaprecio').val() == null){
                        alertify.warning("Por favor ingresar categoria precio");
                            Swal.fire(
                              '¡Importante!',
                              'Por favor ingresar categoria precio',
                              'warning'
                                );                        
                        $('#lblcategoriaprecio').focus();
                        return false;
                    }
                    
                    if($('#lblRenove').val() == '' || $('#lblRenove').val() == null){
                            Swal.fire(
                              '¡Importante!',
                              'Por favorseleccionar Renove',
                              'warning'
                                );                        
                        $('#lblRenove').focus();
                        return false;
                    }                    

                    if($('#lblRenove').val() == 'SI'){
                        if($('#lblRcompetencia').val() == '' || $('#lblRcompetencia').val() == null){
                            Swal.fire(
                              '¡Importante!',
                              'Por favorseleccionar Competencia',
                              'warning'
                                );                        
                            $('#lblRcompetencia').focus();
                        return false;                    
                            
                        }
    
    
                    } 
                    
                    
                    // if($('#lblDescuentoCuota').val() == '' || $('#lblDescuentoCuota').val() == null){
                    //     alertify.warning("Por favor ingresar Descuento Cuota");
                    //     $('#lblcategoriaprecio').focus();
                    //     return false;
                    // }  
                    
                    if ($("#frmEditarVenta #lblcomentario_comercial").val() == "" ) {
                        alertify.warning("Por favor ingresar RESPUESTA COMERCIAL");
                        $("#frmEditarVenta #lblcomentario_comercial").focus();
                        return false;
                    }
                    
                    if ($("#frmEditarVenta #lblhorariosugerido2").val() == "" ) {
                        alertify.warning("Por favor ingresar HORARIO SUGERIDO");
                        $("#frmEditarVenta #lblhorariosugerido2").focus();
                        return false;
                    }                      
                    

                    
                }
                //VALIDACION CUANDO EL PROSPECTO SE VENDE -- CATEGORIA FICHA
                if ($("#lblcat").val() == "Delegacion") {
                    
                    if ($("#frmEditarVenta #cantidadreferidoHabilitado").val() == 0) {
                            Swal.fire(
                              '¡Advertencia!',
                              'Para continuar, debes ingresar al menos 1 referido. En caso ya hayas ingresado el referido, por favor presiona el botón Actualizar Número de Referidos',
                              'warning'
                                );
                        
                        $("#frmEditarVenta #cantidadreferidoHabilitado").focus();
                        return false;
                    }
                    
                    if ($("#frmEditarVenta #lblpreciokit").val() == "") {
                        alertify.warning("Por favor ingresar Precio del KIT");
                        $("#frmEditarVenta #lblpreciokit").focus();
                        return false;
                    }
                    
                    if ($("#frmEditarVenta #lbltotalextra").val() == "") {
                        alertify.warning("Por favor ingresar Total de Extra, de caso contrario digite: 0");
                        $("#frmEditarVenta #lbltotalextra").focus();
                        return false;
                    }
                    
                    if ($("#frmEditarVenta #lblresumenventa").val() == "") {
                        alertify.warning("Por favor ingresar Resumen de Venta");
                        $("#frmEditarVenta #lblresumenventa").focus();
                        return false;
                    }
                    
                    if ($("#frmEditarVenta #lblformadepago").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Forma de Pago");
                        $("#frmEditarVenta #lblformadepago").focus();
                        return false;
                    }
                    
                    if ($("#frmEditarVenta #mesano").val() == "") {
                        alertify.warning("Por favor ingresar 590");
                        $("#frmEditarVenta #mesano").focus();
                        return false;
                    }
                    
                    if ($("#frmEditarVenta #lblPAI").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar PAI");
                        $("#frmEditarVenta #lblPAI").focus();
                        return false;
                    }
                    
                    if ($("#frmEditarVenta #lblestadoventa").val() == "Seleccione" || $("#frmEditarVenta #lblestadoventa").val() == "") {
                        alertify.warning("Por favor ingresar Estado de Venta correcto");
                        $("#frmEditarVenta #lblestadoventa").focus();
                        return false;
                    }
                    
                    if ($("#frmEditarVenta #lblestventa").val() == "InstaladaDEL") {
                        if ($("#frmEditarVenta #lblncontrato").val() == "") {
                            alertify.warning("Por favor ingresar N°Contrato");
                            $("#frmEditarVenta #lblncontrato").focus();
                            return false;
                        }   
                    }                    
                    
                    if ($("#frmEditarVenta #lbltipoventa").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Recurso correcto");
                        $("#frmEditarVenta #lbltipoventa").focus();
                        return false;
                    }
                    
                    if ($("#frmEditarVenta #lblsegmento").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Segmento correcto");
                        $("#frmEditarVenta #lblsegmento").focus();
                        return false;
                    }
                    
                    // if ($("#frmEditarVenta #lblmesesautorizados").val() == "") {
                    //     alertify.warning("Por favor ingresar MesAutorizado.Si no tuviese coloque: 0");
                    //     $("#frmEditarVenta #lblmesesautorizados").focus();
                    //     return false;
                    // }
                    
                    if ($("#frmEditarVenta #lblinstaladox").val() == "" || $("#frmEditarVenta #lblinstaladox").val() == "Seleccione" || $("#frmEditarVenta #lblinstaladox").val() == "TEC" ) {
                        alertify.warning("Por favor seleccionar Instaladox: DEL");
                        $("#frmEditarVenta #lblinstaladox").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lbltecnico").val() =="" || $("#frmEditarVenta #lbltecnico").val()==null) {
                        alertify.warning("Por favor seleccionar el instalador");
                        $("#frmEditarVenta #lbltecnico").select2('open');
                        return false;
                    }
                    if ($("#frmEditarVenta #fechainst").val() == "") {
                        alertify.warning("Por favor ingresar Fecha de Instalacion");
                        $("#frmEditarVenta #fechainst").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #horainst").val() == "") {
                        alertify.warning("Por favor ingresar Hora de Instalacion");
                        $("#frmEditarVenta #horainst").focus();
                        return false;
                    }
                    
                    if ($("#frmEditarVenta #lbltipokit").val() == "") {
                        alertify.warning("Por favor ingresar Tipo Kit");
                        $("#frmEditarVenta #lbltipokit").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblclosingpack").val() == "" || $("#frmEditarVenta #lblclosingpack").val() == null){
                        alertify.warning("Por favor ingresar Closing Pack");
                        $("#frmEditarVenta #lblclosingpack").focus();
                        return false;
                    }
                    /*
                    if ($("#frmEditarVenta #lblprecioEspecial").val() == "" || $("#frmEditarVenta #lblprecioEspecial").val() == null) {
                        alertify.warning("Por favor ingresar PRECIO ESPECIAL");
                        $("#frmEditarVenta #lblprecioEspecial").focus();
                        return false;
                    }
                    */
                    
                    if ($("#frmEditarVenta #lblresultadoScoring").val() == "" || $("#frmEditarVenta #lblresultadoScoring").val() == null) {
                        alertify.warning("Por favor ingresar RESULTADO SCORING");
                        $("#frmEditarVenta #lblresultadoScoring").focus();
                        return false;
                    }
                    
                    if ($("#frmEditarVenta #valcodigoOperacionScoring").val() == "" || $("#frmEditarVenta #valcodigoOperacionScoring").val() == null) {
                        alertify.warning("Por favor seleccionar RESULTADO SCORING, puede ver en CONSULTAS DOC.");
                        $("#frmEditarVenta #lblresultadoScoring").focus();
                        return false;
                    } 
                    
                    if ($("#frmEditarVenta #lblCantExtras").val() == "" ) {
                        alertify.warning("Por favor ingresar CANTIDAD EXTRAS");
                        $("#frmEditarVenta #lblCantExtras").focus();
                        return false;
                    }
                    
                    if($('#lblcategoriaprecio').val() == '' || $('#lblcategoriaprecio').val() == null){
                        alertify.warning("Por favor ingresar categoria precio");
                        $('#lblcategoriaprecio').focus();
                        return false;
                    }
                    
                    // if($('#lblDescuentoCuota').val() == '' || $('#lblDescuentoCuota').val() == null){
                    //     alertify.warning("Por favor ingresar Descuento Cuota");
                    //     $('#lblcategoriaprecio').focus();
                    //     return false;
                    // }

                    if ($("#frmEditarVenta #lblcomentario_comercial").val() == "" ) {
                        alertify.warning("Por favor ingresar RESPUESTA COMERCIAL");
                        $("#frmEditarVenta #lblcomentario_comercial").focus();
                        return false;
                    }
                    
                    if ($("#frmEditarVenta #lblhorariosugerido2").val() == "" ) {
                        alertify.warning("Por favor ingresar HORARIO SUGERIDO");
                        $("#frmEditarVenta #lblhorariosugerido2").focus();
                        return false;
                    }     


                    
                }
                return true; 
            }

    function validaFormScoring(){
                              if ($("#frmEditarVentaScoring #TipoDocumento").val() == "") {
                           alertify.warning("Por favor ingresar Tipo de Documento");
                           $("#frmEditarVentaScoring #lbldireccion").focus();
                           return false;
                        }
                                              if ($("#frmEditarVentaScoring #Documento").val() == "") {
                           alertify.warning("Por favor ingresar Número de Documento");
                           $("#frmEditarVentaScoring #Documento").focus();
                           return false;
                        }
                        //NUEVA FUNCION SI SELECCIONA DNI/RUC
                    if ($("#frmEditarVentaScoring #TipoDocumento").val() == "6") {
                            if ($("#frmEditarVentaScoring #Documento").val().length!=11) {
                                
                               alertify.warning("Por favor ingresar los 11 digitos del RUC");
                               $("#frmEditarVentaScoring #Documento").focus();
                               return false;
                            }
                            
                            if ($("#frmEditarVentaScoring #Documento").val().substr(0,2)==10 || $("#frmEditarVentaScoring #Documento").val().substr(0,2)==20 || $("#frmEditarVentaScoring #Documento").val().substr(0,2)==15 || $("#frmEditarVentaScoring #Documento").val().substr(0,2)==17) {
                              
                            }else{
                                 alertify.warning("Por favor ingresar correctamente el RUC debe comenzar 10 o 20");
                               $("#frmEditarVentaScoring #Documento").focus();
                               return false;
                            }
                            
                            
                        }
                    if ($("#frmEditarVentaScoring #TipoDocumento").val() == "1") {
                            if ($("#frmEditarVentaScoring #Documento").val().length!=8) {
                               alertify.warning("Por favor ingresar los 8 digitos del DNI");
                               $("#frmEditarVentaScoring #Documento").focus();
                               return false;
                            }
                        }                        
                    if ($("#frmEditarVentaScoring #TipoDocumento").val() == "3") {
                            if ($("#frmEditarVentaScoring #Documento").val().length==0) {
                               alertify.warning("Por favor ingresar CE");
                               $("#frmEditarVentaScoring #Documento").focus();
                               return false;
                            }
                        }
                                      if ($("#frmEditarVentaScoring #Departamental").val() == "") {
                      alertify.warning("Por favor ingresar Departamento correspondiente");
                      $("#frmEditarVentaScoring #Departamental").focus();
                      return false;
                  }
                                    if ($("#frmEditarVentaScoring #Provincial").val() == "") {
                      alertify.warning("Por favor ingresar Pronvincia correspondiente");
                      $("#frmEditarVentaScoring #Provincial").focus();
                      return false;
                  }
                                    if ($("#frmEditarVentaScoring #Distrital").val() == "") {
                      alertify.warning("Por favor ingresar Distrito correspondiente");
                      $("#frmEditarVentaScoring #Distrital").focus();
                      return false;
                  }
                                    if ($("#frmEditarVentaScoring #Segmento").val() == "") {
                      alertify.warning("Por favor seleccionar Segmento correspondiente");
                      $("#frmEditarVentaScoring #Segmento").focus();
                      return false;
                  }                      
                      
                  return true;
    } 
    function cargardepartamento(){
                    $('#TipoDocumento').val("1"); 
                    var lblIdProvincial = $("#lblIdProvincial").val();
                    var lblIdDepartamental = $("#lblIdDepartamental").val();
                    var lblCodUbigeoReniec=$('#lblCodUbigeoReniec').val();
                    var provincia= $("#Departamental");
                     $.ajax({
                    url:   './ajax/selectDepartamental.php',
                    type:  'POST',
                    dataType: 'json',
                    beforeSend: function () 
                    {
                        provincia.prop('disabled', true);
                        
                    },
                    success:  function (r) 
                    {
                        provincia.prop('disabled', true);
                        
                        // Limpiamos el select de Provincia
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');

                        $(r).each(function(i, v){ // indice, valor
                            provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                        })
                    if(lblIdDepartamental==""){
                        $("#Departamental option[value='15']").attr("selected", true);
                    }else{
                        $("#Departamental option[value='"+lblIdDepartamental+"']").attr("selected", true);
                    }
                    //$("#Departamental option[value='15']").attr("selected", true);
                        $("#Departamental option:selected").each(function () {
                    var Provincial = $(this).val();
                    var datos={
                        Provincial:Provincial
                    };
                    var provincia= $("#Provincial");
                    var distrito= $("#Distrital");
                     $.ajax({
                    data:datos,
                    url:   './ajax/selectProvincial.php',
                    type:  'POST',
                    dataType: 'json',
                    beforeSend: function () 
                    {
                        //provincia.prop('disabled', true);
                        //distrito.prop('disabled', true);
                    },
                    success:  function (r) 
                    {
                        provincia.prop('disabled', true);
                        distrito.prop('disabled', false);
                        
                        // Limpiamos el select de Provincia
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');
                        // Limpiamos el select de Distrito
                        distrito.find('option').remove();
                        distrito.append('<option value="">Seleccione</option>');
                        
                        $(r).each(function(i, v){ // indice, valor
                            provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                        })
                       if(lblIdProvincial==""){
                           $("#Provincial option[value='128']").attr("selected", true);
                       }else{
                           $("#Provincial option[value='"+lblIdProvincial+"']").attr("selected", true);
                       }
                       //$("#Provincial option[value='128']").attr("selected", true);
                        $("#Provincial option:selected").each(function () {
                    var Provincial = $(this).val();
                    var datos={
                        Provincial:Provincial
                    };
                    var provincia= $("#Distrital");
                     $.ajax({
                    data:datos,
                    url:   './ajax/selectDistrital.php',
                    type:  'POST',
                    dataType: 'json',
                    beforeSend: function () 
                    {
                       //provincia.prop('disabled', true);
                    },
                    success:  function (r) 
                    {
                        provincia.prop('disabled', false);
                        
                        // Limpiamos el select
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');
                        
                        $(r).each(function(i, v){ // indice, valor
                            provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                        })

                        if(!lblCodUbigeoReniec==""){
                            $("#Distrital option[value='"+lblCodUbigeoReniec+"']").attr("selected", true);
                        }                         
                        
                        provincia.trigger('change');
                        
                        provincia.prop('disabled', false);
                    },
                    error: function()
                    {
                        //alert('Ocurrio un error en el servidor ..');
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');
                        provincia.prop('disabled', false);
                    }
                });

                });
                        provincia.prop('disabled', false);
                        distrito.prop('disabled', false);
                    },
                    error: function()
                    {
                        //alert('Ocurrio un error en el servidor ..');
                        provincia.prop('disabled', false);
                        distrito.prop('disabled', false);
                    }
                });

                });
                        //provincia.trigger('change');
                         
                        
                        provincia.prop('disabled', false);
                        
                    },
                    error: function()
                    {
                        //alert('Ocurrio un error en el servidor ..');
                        provincia.prop('disabled', false);
                    }
                });
        
    }
            
            function calcDataTableHeight() {
                return $(window).height() * 65 / 100;
            };

            function filterFloat(evt, input) {
                // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
                var key = window.Event ? evt.which : evt.keyCode;
                var chark = String.fromCharCode(key);
                var tempValue = input.value + chark;
                if (key >= 48 && key <= 57) {
                    if (filter(tempValue) === false) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    if (key == 8 || key == 13 || key == 0) {
                        return true;
                    } else if (key == 46) {
                        if (filter(tempValue) === false) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
            }

            function filter(__val__) {
                var preg = /^([0-9]+\.?[0-9]{0,2})$/;
                if (preg.test(__val__) === true) {
                    return true;
                } else {
                    return false;
                }

            }
            
            $('#lblcategoriaprecio').on('change', function(){ 
    			var tipoventa = '<?php echo $tipoventa; ?>'; 
    			if(tipoventa=="RE"){
    			    $(".mostrarEtiqueta").removeClass("hidden");
    			}else{ 
    			    if($('#lblcategoriaprecio').val()=="RENOVE" || $('#lblcategoriaprecio').val()=="EXCEPCION RENOVE" || $('#lblcategoriaprecio').val() == 'SUPER OFERTA RENOVE'){
    			 
    			        $(".mostrarEtiqueta").removeClass("hidden");
    			        $("#lblDescuentoCuota option[value='4meses']").show();
    			    }else{
    			        
    			        $(".mostrarEtiqueta").addClass("hidden");
    			        $("#lblDescuentoCuota option[value='4meses']").hide();
    			    }
    			}
			})
        </script>
        <!-- NUEVAS FUNCIONES -->
        <script>
            const dc = $('#lbldc').val();
            
            const option = document.createElement("option");
            
            //DEPRECATED
            function tipoKit(){
                const segmento = $('#lblsegmento').val();
                const tipokit = document.getElementById("lbltipokit");
                
                limpiarDatos(tipokit)
                
                if(segmento == 'RES'){
                    //ARBOL DE DESICIONES PARA ZEROVISION
                    
                    if(dc == '150' || dc == '151' || dc == '120'){
                        let arragloKit = ['Basico', 'ZeroVision'];
                        cargarDatosKit(tipokit, arragloKit);
                    }else if(dc=='155' || dc== '153' || dc == '152'){
                        let arragloKit = ['Basico', 'ZeroVision'];
                        cargarDatosKit(tipokit, arragloKit);
                    } else {
                        let arragloKit = ['Basico', 'Premium','ZeroVision'];
                        cargarDatosKit(tipokit, arragloKit);
                    }
                    
                    //ARBOL DE DESICIONES SIN ZEROVISION
                    /*
                    let arragloKit = ['Basico', 'Premium'];
                    cargarDatosKit(tipokit, arragloKit);
                    */
                }
                else if (segmento == 'NEG'){
                    //ARBOL DE DESICIONES PARA ZEROVISION
                    
                    if(dc == '150' || dc=='151' || dc=='120'){
                        let arragloKit = ['Basico', 'ZeroVision'];
                        cargarDatosKit(tipokit, arragloKit);
                    }
                    else if (dc == '155' || dc == '153' || dc == '152'){
                        let arragloKit = ['Basico', 'ZeroVision'];
                        cargarDatosKit(tipokit, arragloKit);
                    } else {
                        let arragloKit = ['Basico', 'Premium','ZeroVision'];
                        cargarDatosKit(tipokit, arragloKit);
                    }
                    //ARBOL DE DESICIONES SIN ZEROVISION
                    /*
                    let arragloKit = ['Basico', 'Premium'];
                    cargarDatosKit(tipokit, arragloKit);
                    */
                }
            }
            
            function cargarDatosKit(tipokit, arragloKit){
                for (value in arragloKit) {
                    var option = document.createElement("option");
                    option.value = arragloKit[value];
                    option.text = arragloKit[value];
                    tipokit.add(option);
                }
            }
            
            //END DEPRECATED
            
function closingPack(){
    
			const lblcategoriaprecio = $('#hidCategoriaPrecio').val();
			const hidclosingpackAutorizados=$('#hidclosingpackAutorizados').val();
			console.log(lblcategoriaprecio);
			const lbltipokit = $('#lbltipokit').val();
			closingpack = document.getElementById("lblclosingpack");
			console.log(lbltipokit);
			const dc=$('#lbldc').val();
			
			const segmento = $('#lblsegmento').val();
			
			limpiarDatos(closingpack);
			
			if(dc==155 || dc == 153 || dc==200){

    			if(lbltipokit == 'Camara' || lbltipokit == 'High Security' || lbltipokit == 'ZeroVision PRO' || lbltipokit == 'Basico PRO'){
    			    
    			    if(segmento=='RES'){

        			    if(lblcategoriaprecio == 'MEGA SUPERVENTA' || lblcategoriaprecio == 'SUPERVENTA' || lblcategoriaprecio == 'PRECIO ALTO' || lblcategoriaprecio == 'PRECIO MEDIO'){
        			        let arregloValueClosingPack = ['Ninguno', '1Magnetico'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    } 
        			    else if(hidclosingpackAutorizados=="SI"){
        			        let arregloValueClosingPack = ['Ninguno', '1Magnetico'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
        			    }                    
        			    else {
        			        let arregloValueClosingPack = ['Ninguno'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    }
    			        
    			    }else{
    			        
        			    if(lblcategoriaprecio == 'MEGA SUPERVENTA' || lblcategoriaprecio == 'SUPERVENTA' || lblcategoriaprecio == 'PRECIO ALTO' || lblcategoriaprecio == 'PRECIO MEDIO'){
        			        let arregloValueClosingPack = ['Ninguno', '1Pulsador'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    } 
        			    else if(hidclosingpackAutorizados=="SI"){
        			        let arregloValueClosingPack = ['Ninguno', '1Pulsador'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
        			    }                    
        			    else {
        			        let arregloValueClosingPack = ['Ninguno'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    }
    			        
    			        
    			    }
    			

    			}
    			else if(hidclosingpackAutorizados=="SI"){
    			    let arregloValueClosingPack = ['Ninguno', '1FOTO'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			}
    			else {
    			    let arregloValueClosingPack = ['Ninguno'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			}				
			
			}else if(dc==154 || dc==158 || dc == 151 || dc == 152  || dc == 150 || dc == 156 || dc == 157 || dc == 159 || dc == 251 || dc == 252 || dc == 513 || dc == 701 || dc == 702){

    			if(lbltipokit == 'Camara' || lbltipokit == 'High Security' || lbltipokit == 'ZeroVision PRO' || lbltipokit == 'Basico PRO' || lbltipokit == 'ZeroVision PRO LA CURACAO' || lbltipokit == 'Basico PRO LA CURACAO'){
    			
    			    if(segmento=='RES'){

        			    if(lblcategoriaprecio == 'MEGA SUPERVENTA' || lblcategoriaprecio == 'SUPERVENTA' || lblcategoriaprecio == 'PRECIO ALTO' || lblcategoriaprecio == 'PRECIO MEDIO'){
        			        let arregloValueClosingPack = ['Ninguno', '1Magnetico'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    } 
        			    else if(hidclosingpackAutorizados=="SI"){
        			        let arregloValueClosingPack = ['Ninguno', '1Magnetico'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
        			    }                    
        			    else {
        			        let arregloValueClosingPack = ['Ninguno'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    }
    			        
    			    }else{
    			        
        			    if(lblcategoriaprecio == 'MEGA SUPERVENTA' || lblcategoriaprecio == 'SUPERVENTA' || lblcategoriaprecio == 'PRECIO ALTO' || lblcategoriaprecio == 'PRECIO MEDIO'){
        			        let arregloValueClosingPack = ['Ninguno', '1Pulsador'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    } 
        			    else if(hidclosingpackAutorizados=="SI"){
        			        let arregloValueClosingPack = ['Ninguno', '1Pulsador'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
        			    }                    
        			    else {
        			        let arregloValueClosingPack = ['Ninguno'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    }
    			        
    			        
    			    }
    			}
    			else if(hidclosingpackAutorizados=="SI"){
    			    let arregloValueClosingPack = ['Ninguno', '2Magnetico', '1Magnetico', '1FOTO'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			}
    			else {
    			    let arregloValueClosingPack = ['Ninguno'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			}			    
			    
			}else{

    			if(lbltipokit == 'ZeroVision' || lbltipokit == 'Camara' || lbltipokit == 'High Security'){
    			
    			    if(lblcategoriaprecio == 'MEGA SUPERVENTA' || lblcategoriaprecio == 'SUPERVENTA' || lblcategoriaprecio == 'PRECIO ALTO' || lblcategoriaprecio == 'PRECIO MEDIO' ){
    			        let arregloValueClosingPack = ['Ninguno', '3Magnetico', '2Magnetico', '1Magnetico', '1MG+1FOTO', '1FOTO'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			    } 
    			    else if(hidclosingpackAutorizados=="SI"){
    			        let arregloValueClosingPack = ['Ninguno', '3Magnetico', '2Magnetico', '1Magnetico', '1MG+1FOTO', '1FOTO'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			    }                    
    			    else {
    			        let arregloValueClosingPack = ['Ninguno'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			    }
    			}
    			else if(hidclosingpackAutorizados=="SI"){
    			    let arregloValueClosingPack = ['Ninguno', '3Magnetico', '2Magnetico', '1Magnetico', '1MG+1FOTO', '1FOTO','1MagneticoUpgrade'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			}
    			else {
    			    let arregloValueClosingPack = ['Ninguno'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			}
			    
			}
			

			}
            function cargarDatosClosingPack(closingpack, arregloClosingPack){
                for (value in arregloClosingPack) {
                    var option = document.createElement("option");
                    option.value = arregloClosingPack[value];
                    option.text = arregloClosingPack[value];
                    closingpack.add(option);
                }
            }

            
            function categoriaPrecio(scoring, tipokit, PAI){
                const dc=$('#lbldc').val();
                var uri;
    			if(dc == "150" || dc == "154" || dc == "158" || dc == "151" || dc == "152" || dc == "153" || dc == "155" || dc == "156" || dc == "157" || dc == "159" || dc == "251" || dc == "252" || dc == "513" || dc == "40" || dc == "120" || dc == "121" || dc == "701" || dc == "702"){
    			    //Carrito Kits Pro - Nuevos funciones
    			 uri="ajax/selectListarCategoriaPrecio_v2.php"; 
    			}else if(dc == "901" || dc == "711" || dc == "713"){
			        uri = "ajax/selectListarCategoriaPrecio_v3.php";
			    }else{
    			    //Actual Carrito
    			 uri="ajax/selectListarCategoriaPrecio.php";
    			    
    			} 
                
                const categoriaPrecio = document.getElementById("lblcategoriaprecio");
                limpiarDatos(categoriaPrecio);
                $('#lblpreciokit').val('');
                limpiarDatos(lblclosingpack);
                 
                const tipoventa = $('#lbltipoventa').val();
                console.log(tipoventa);
                if(scoring == 'Unica'){
                    scoring = 0;
                }else if(scoring == 'Limitada'){
                    scoring = 1;
                }else if(scoring == 'Oferta'){
                    scoring = 2;
                }else if(scoring == 'Especial'){
                    scoring = 3;
                }else if(scoring == 'Extraordinaria'){
                    scoring = 4;                     
                }else {
                    scoring = "NA";
                }
                
                const datos = {
                     tipoventa,
                     tipokit,
                     PAI,
                     scoring
                }
                
                console.log(datos);
                
                $.ajax({
                     type: 'POST',
                     data: datos,
                     url: uri,
                     dataType: 'JSON',
                     success: function(data){
                         console.log(data);
                         if(data.respuesta == 'exito'){
                             cargarDatosCategoria(data.datos);
                             arregloCategorias = data.datos;
                         }
                     }
                })
            }
            
            function cargarDatosCategoria(datos){
                console.log(datos);
                
                const categoriaPrecio = document.getElementById("lblcategoriaprecio");

                datos.forEach(elemento => {
                    const {Categoria, PrecioMinimo, PrecioMaximo} = elemento;
                    const option = document.createElement("option");
                    
                    option.value = Categoria;
                    option.text = `${Categoria} (S/. ${PrecioMinimo})`;
                    categoriaPrecio.add(option);
                })
                
                //AÑADIR OPCION DE GRANDES CUENTAS
                if($('#hidGGCC').val() == 'SI'){
                    //alert('Grandes Cuentas');
                    const option = document.createElement("option");
                    
                    option.value = 'GGCC';
                    option.text = 'GRANDES CUENTAS';
                    categoriaPrecio.add(option);
                } 
                
                //SET EL VALOR DE LA CATEGORIA GUARDADO PREVIAMENTE
                if($('#hidCategoriaPrecio').val() != ''){
                    $('#lblcategoriaprecio').val($('#hidCategoriaPrecio').val());
                }
                if($('#hidPrecioKit').val() != ''){
                    $('#lblpreciokit').val($('#hidPrecioKit').val());
                }
            }
            
            function asignarPrecioKit(categoriaPrecio){
                
                const lbltipoventa = $('#lbltipoventa').val();
                
                closingPack();
                
                if(categoriaPrecio == 'GGCC'){
                    $('#lblpreciokit').val('');
                    $('#precioKit__MIN').val(0);
                    $('#precioKit__MAX').val(99999);
                } else {
                
                    const datosCategoriaSeleccionada = arregloCategorias.filter(function(element){
                      return element.Categoria == categoriaPrecio;
                    });
                    
                    $('#lblpreciokit').val(datosCategoriaSeleccionada[0].PrecioMinimo);
                    $('#precioKit__MIN').val(datosCategoriaSeleccionada[0].PrecioMinimo);
                    $('#precioKit__MAX').val(datosCategoriaSeleccionada[0].PrecioMaximo);
                    
                    if(datosCategoriaSeleccionada[0].ClosingPack == 'SI'){
                        closingPack();
                    }
                }
            }
            
            function limpiarDatos(select){
                while(select.children.length > 1){
                    select.lastChild.remove();
                    
                    select.value = '';
                    
                }
            }
            
            function generarResumenInstalacion(){
                console.log(arregloGeneral);
                /*
                const lblresumenventa = $('#lblresumenventa').val();
                let nuevoResumen;

                if(lblresumenventa.indexOf('ZeroVision') !== -1){
                    nuevoResumen = lblresumenventa.replace('ZeroVision', 'Basico');
                } else {
                    nuevoResumen = lblresumenventa.replace('Basico', 'ZeroVision');
                }
                $('#lblresumenventa').val(nuevoResumen);
                */
                
                let resumen = '';
                
                //ALGORITMO PARA GENERAR EL RESUMEN DE INSTALACION PARA EXTRAS
                arregloGeneral.forEach((elemento, index) => {
                    //Si existe más de un elemento en el arreglo, por defecto el index 0 siempre es el KIT
                    if(arregloGeneral.length > 1){
                        if((arregloGeneral.length -1) == index){
                            resumen += `${elemento.descripcion} (${elemento.tipo})`;
                        } else {
                            resumen += `${elemento.descripcion} (${elemento.tipo}) + `;
                        }
                    } else {
                        //SE AGREGA EL TIPO DE KIT
                        resumen += `${elemento.descripcion}`;
                    }
                    
                })
                
                $('#lblresumenventa').val(resumen);

            }
        </script>
        <!-- FUNCIONES CHECK IN -->
        <script>
            const map = L.map('map');
            
            $('#modal-checkin').on('shown.bs.modal', function(){
                if (navigator.geolocation){
                    navigator.geolocation.getCurrentPosition(function(objPosition){

                        var lon = objPosition.coords.longitude;
                        var lat = objPosition.coords.latitude;
                        
                        map.setView([lat, lon], 16);
                        
                        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                            attribution: ''
                        }).addTo(map);
                        
                        L.marker([lat, lon], {icon: L.AwesomeMarkers.icon({icon: 'user', prefix: 'fa', markerColor: 'blue'})}).addTo(map)
                        .bindPopup('Mi Ubicación.<br> Enviar para check-IN.')
                        .openPopup();
            
                        
                        $('#longitud').val(lon);
                        $('#latitud').val(lat);
                        
                        //let miUbicacionDireccion = buscarDireccion();
                        
                    }, function(objPositionError){
                          switch (objPositionError.code)
                          {
                            case objPositionError.PERMISSION_DENIED:
                              mensaje = "No se ha permitido el acceso a la posición del usuario.";
                            break;
                            case objPositionError.POSITION_UNAVAILABLE:
                              mensaje = "No se ha podido acceder a la información de su posición.";
                            break;
                            case objPositionError.TIMEOUT:
                              mensaje = "El servicio ha tardado demasiado tiempo en responder.";
                            break;
                            default:
                              mensaje = "Error desconocido.";
                          }
                          
                        Swal.fire({
                              icon: 'error',
                              title: mensaje,
                              confirmButtonColor: '#e4002b',
                              footer: 'Comunicate con soporteIT'
                        }) 
                          
                        $('#btnGuardarCheckIn').prop('disabled', true);
                          
                        window.close();
                        $("#modal-checkin").hide();
                        $('body').removeClass('modal-open');//eliminamos la clase del body para poder hacer scroll
                        $('.modal-backdrop').remove();//eliminamos el backdrop del modal
                          
                    }, {
                        enableHighAccuracy: true,
                        timeout: 5000,
                        maximumAge: 0
                    });
                }
            })
            
            $('#btnGuardarCheckIn').on('click', function(){
                try{
                    let lat1, lon1;
                    lat1 = $('#latitud').val();
                    lon1 = $('#longitud').val();
                    //OBTENEMOS EL IDPROSPECTO
                    const parametrosURL = new URLSearchParams(window.location.search);
                    const idprospecto = parseInt( parametrosURL.get('idprospectorp') );
                    const matricula = $('#headerMatriculaUsuario').val();
                    
                    datos = {
                        idprospecto: idprospecto,
                        lat: lat1,
                        lon: lon1,
                        matricula: matricula
                    }
                    
                    let timerInterval
                    Swal.fire({
                      title: 'CHECK-IN RP',
                      html: 'Enviando CHECK-IN RP ....',
                      timer: 2000,
                      timerProgressBar: true,
                      didOpen: () => {
                        Swal.showLoading()
                        timerInterval = setInterval(() => {
                        }, 100)
                      },
                      willClose: () => {
                        clearInterval(timerInterval)
                      }
                    }).then((result) => {
                        if (result.dismiss === Swal.DismissReason.timer) {
                                
                            actualizarCheckINRP(datos);
                            
                            $('#btnCheckIn').addClass('ocultar');
                            
                            window.close();
                            $("#modal-checkin").hide();
                            $('body').removeClass('modal-open');//eliminamos la clase del body para poder hacer scroll
                            $('.modal-backdrop').remove();//eliminamos el backdrop del modal
                            
                            //$('#btnCheckIn').addClass('ocultar');
                        }
                    })
                } catch (error) {
                    console.log(error);
                }
            })
            
            async function actualizarCheckINRP(datos){
                try {
                    const respuesta = await fetch('ajax/updateCheckInRP.php', {method: 'POST', body: JSON.stringify(datos)});
                    const resultado = await respuesta.json();
                    
                    console.log(resultado);
                    if(resultado.respuesta === 'exito'){
                        
                        Swal.fire(
                          'Enviado!',
                          'Check-IN RP guardado.',
                          'success'
                        )
                    } else {
                        Swal.fire({
                              icon: 'error',
                              title: mensaje,
                              confirmButtonColor: '#e4002b',
                              footer: 'Comunicate con soporteIT'
                        }) 
                    }
                    
                } catch (error) {
                    console.log(error);
                }
            }
        </script>
        <!-- SCORING -->
        <script>
            var divLoading = $('#divLoading');

                $('#btnScoring').on('click', function(){

                    $('#btnScoring').prop('disabled', true);

                    divLoading.show();
                    var idprospectorp=$('#datosIdProspectoRp').val();
                    var matriculausuario=$('#matriculausuario').val(); 
                    var nombreusuario=$('#nombreusuario').val();
                    var TipoDocumento = $('#TipoDocumento').val();
                    var Documento = $('#Documento').val();
                    var Departamental=$("#Departamental option:selected").text();
                    var Provincial=$("#Provincial option:selected").text();
                    var Distrital=$("#Distrital option:selected").text();
                    var Ubigeo=$("#Distrital").val();
                    var Segmento=$("#Segmento option:selected").val();
        
                    var datos = {
                    matriculausuario:matriculausuario,
                    nombreusuario:nombreusuario,
                    TipoDocumento: TipoDocumento,
                    Documento: Documento,
                    Departamental:Departamental,
                    Provincial:Provincial,
                    Distrital:Distrital,
                    Ubigeo:Ubigeo,
                    idprospectorp:idprospectorp,
                    Segmento:Segmento
                    }
                    console.log(datos);
                    if(validaFormScoring()){
                        $.ajax({
                            type: "Post",
                            data: datos,
                            url: "ajax/funciones/soap2_rp_v2.php",
                            dataType: "Json",
                            success: function (data){
                              console.log(data);
                                  if (data.tipo == 'exito'){
                                    $('#FechaConsulta').html(data.fecha);
                                    var resultado = data.datos;
                                    var resultadooperacion=data.NodoAccion;
                                    //resultadooperacion=data.NodoAccion;
                                    //var resultadooperacion=resultado.respuestaSVC11Type.GrupoCampos.Campo[1].Valor;
                                    
                                    //$('.TextoAccion').html(resultadooperacion);
                                    if(resultadooperacion=="Generar Visita"){
                                        $('.bg-visita').show();
                                        $('.bg-televenta').hide();
                                        $('.bg-gestion').hide();
                                    }else if(resultadooperacion=="Pasar a base de datos-48 horas" || resultadooperacion=="Pasar a Televenta"){
                                        $('.bg-visita').hide();
                                        $('.bg-televenta').show();
                                        $('.bg-gestion').hide();
                                    }else{
                                        $('.bg-visita').hide();
                                        $('.bg-televenta').hide();
                                        $('.bg-gestion').show();
                                    }
                                    $('#Riesgo').html(resultado.respuestaSVC11Type.Scores.Score.Riesgo + ' Riesgo');
                                    if (resultado.respuestaSVC11Type.Integrante.TipoDocumento == 1){
                                    $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno +' '+resultado.respuestaSVC11Type.Integrante.ApellidoMaterno +' '+resultado.respuestaSVC11Type.Integrante.Nombres);
                                    $('#TDocumento').html("DNI:");
                                    }
                                    else if (resultado.respuestaSVC11Type.Integrante.TipoDocumento == 6){
                                    
                                    if(resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0,2)==10 || resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0,2)==15 || resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0,2)==17){
                                        $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno +' '+resultado.respuestaSVC11Type.Integrante.ApellidoMaterno +' '+resultado.respuestaSVC11Type.Integrante.Nombres);
                                    }else{
                                        $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.RazonSocial);
                                    }
                                      $('#TDocumento').html("RUC:");
                                    }else{
                                    $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno +' '+resultado.respuestaSVC11Type.Integrante.ApellidoMaterno +' '+resultado.respuestaSVC11Type.Integrante.Nombres);
                                    $('#TDocumento').html("CE:");
                                    }
                
                                    $('#NumeroDocumento').html(resultado.respuestaSVC11Type.Integrante.NumeroDocumento);
                
                
                                    $('#Valor').html(resultado.respuestaSVC11Type.Scores.Score.Valor);
                                    $('#ValorNodo').html(data.NodoScoring);
                                    $('#ValorNodoAccion').html(data.NodoAccion);
                                    
                                    
                                    $('.TextoAccion').html(resultadooperacion);
                                    if(resultadooperacion=="Oferta Limitada"){
                                        $('#lblresultadoScoring').val("Limitada");
                                        $('#valresultadoScoring').val("Limitada");
                                    }else if(resultadooperacion=="Oferta Especial"){
                                        $('#lblresultadoScoring').val("Especial");
                                        $('#valresultadoScoring').val("Especial");
                                    }else if(resultadooperacion=="Oferta Extraordinaria"){
                                        $('#lblresultadoScoring').val("Extraordinaria");
                                        $('#valresultadoScoring').val("Extraordinaria");
                                    }else if(resultadooperacion=="Oferta Unica"){
                                        $('#lblresultadoScoring').val("Unica");
                                        $('#valresultadoScoring').val("Unica");
                                    }else if(resultadooperacion=="Oferta"){
                                        $('#lblresultadoScoring').val("Oferta");
                                        $('#valresultadoScoring').val("Oferta");                                           
                                    }else{
                                        $('#lblresultadoScoring').val("");
                                        $('#valresultadoScoring').val("");
                                    }
                                    $('#valcodigoOperacionScoring').val(resultado.respuestaSVC11Type.Header.NumeroOperacion);
                                    
                                    $('#lblresultadoScoring').trigger('change');
                                   
                                    divLoading.hide();
                
                                    $('#ResultadoEquifax').show();
                                    $('#TipoDocumento').prop('disabled', true); 
                                    $('#Documento').prop('disabled', true); 
                                    $("#Departamental").prop('disabled', true); 
                                    $("#Provincial").prop('disabled', true); 
                                    $("#Distrital").prop('disabled', true);
                                    $('#btnScoring').hide();
                                    $('#btnScoring').prop('disabled', false);
                                    $('#btnNuevaScoring').show();
                                  } else {
                                    divLoading.hide();
                                    alert(data.mensaje);
                                    $('#btnScoring').show();
                                    $('#btnScoring').prop('disabled', false);
                                    $('#btnNuevaScoring').hide();
                                  }
                            }
                        })
            
                    } else{
                         divLoading.hide();
                          $('#btnScoring').prop('disabled', false);
                    }
                });
          
                $('#btnNuevaScoring').on('click',function(){
                    $('#ResultadoEquifax').hide();
                    
                    
                    /*
                    const lbltipoventa = $('#lbltipoventa').val();
                    if(lbltipoventa=="RP" || lbltipoventa=="RPPA" || lbltipoventa=="RPPR" || lbltipoventa=="RPMKT" || lbltipoventa=="RPTMK"){
                        $("#Departamental").prop('disabled', true);
                        $("#Provincial").prop('disabled', true);  
                    }else{
                        $("#Departamental").prop('disabled', false);
                        $("#Provincial").prop('disabled', false);                
                    } 
                    */
                    
                    $("#Departamental").prop('disabled', true);
                    $("#Provincial").prop('disabled', true);  
                    
                    $('#TipoDocumento').prop('disabled', false); 
                    $('#Documento').prop('disabled', false); 
                    //$("#Departamental").prop('disabled', false); 
                    //$("#Provincial").prop('disabled', false); 
                    $("#Distrital").prop('disabled', false);
                    $('#btnNuevaScoring').hide();
                    $('#btnScoring').show();
                    $('#btnScoring').prop('disabled', false);
                    
                    $('#TipoDocumento').val("1"); 
                    $('#Documento').val("");
                    //$("#Departamental").val("");
                    //$("#Provincial").find('option').remove();
                    //$("#Provincial").append('<option value="">Seleccione</option>');
                    //$("#Distrital").find('option').remove();
                    //$("#Distrital").append('<option value="">Seleccione</option>');
                    //cargardepartamento();
                    
                });

                $('#modal-logdni').on('shown.bs.modal', function(){
                    $('#logconsultadoc').prop('disabled', true);
                    divLoading.show();
                    $('#tblVentas').hide();
                    const contenedor = document.querySelector('#tblVentas tbody');
                    while (contenedor.firstChild) {
                        contenedor.removeChild(contenedor.firstChild);
                        }
        
                    var idprospectorp=$('#datosIdProspectoRp').val();
                    const lblsegmento=$('#lblsegmento option:selected').val();
                    const lblIdProvincial=$('#lblIdProvincial').val();
                    const lblCodUbigeoReniec=$('#lblCodUbigeoReniec').val();
                    var datos = {
                        idprospectorp:idprospectorp,
                        lblsegmento:lblsegmento,
                        lblIdProvincial:lblIdProvincial,
                        lblCodUbigeoReniec:lblCodUbigeoReniec
                    }
                    console.log(datos);
                     $.ajax({
                        type: "Post",
                        data: datos,
                        url: "ajax/findDataConsultaScoringRP.php",
                        dataType: "Json",
                        success: function (data){
                          console.log(data);
                          divLoading.hide();
                          $('#tblVentas').show();
                            if(data.length>0){
        
                                        for (let [llave, valor] of Object.entries(data)){
                                            var TipoDoc;
                                            if(valor.TipoDocumento==1){TipoDoc="DNI"}else if(valor.TipoDocumento==6){TipoDoc="RUC"}else{TipoDoc="CE"}
                                            const row = document.createElement('tr');
                                                row.innerHTML = `   <td class="tblBody text-center"><button type="button" class="btn btn-nuevo btnSeleccionar" id="${valor.Accion+"-"+valor.NumeroOperacion+"-"+valor.Dentromes}">Seleccionar</button></td>
                                                                    <td class="tblBody text-center">${valor.FechaHoraReg}</td> 
                                                                    <td class="tblBody text-center">${TipoDoc}</td> 
                                                                    <td class="tblBody text-center">${valor.NumeroDocumento}</td>
                                                                    <td class="tblBody text-center">${valor.Nombres +" "+ valor.ApellidoPaterno+" "+valor.ApellidoMaterno}</td>
                                                                    
                                                                `                        
                                            //Agrega el HTML del carrito en el tbody 
                                            contenedor.appendChild(row);
                                }
                                    //Desbloqueo del Boton
        $('#logconsultadoc').prop('disabled', false);                       
          $('.btnSeleccionar').on('click',function(){
            var cadena = $(this).attr("id");
            var separador = "-", // hay un "-"
                arregloDeSubCadenas = cadena.split(separador);
            var Accion=arregloDeSubCadenas[0];
            var NumeroOperacion=arregloDeSubCadenas[1];
            var Dentromes=arregloDeSubCadenas[2];
            if(Dentromes=="NO"){
                    Swal.fire(
                      '¡Scoring Desactualizado!',
                      'Por favor volver a scorear',
                      'warning'
                    );
            }else{

                                    if(Accion=="Oferta Limitada"){
                                        $('#lblresultadoScoring').val("Limitada");
                                        $('#valresultadoScoring').val("Limitada");
                                    }else if(Accion=="Oferta Especial"){
                                        $('#lblresultadoScoring').val("Especial");
                                        $('#valresultadoScoring').val("Especial");
                                    }else if(Accion=="Oferta Extraordinaria"){
                                        $('#lblresultadoScoring').val("Extraordinaria");
                                        $('#valresultadoScoring').val("Extraordinaria");
                                    }else if(Accion=="Oferta Unica"){
                                        $('#lblresultadoScoring').val("Unica");
                                        $('#valresultadoScoring').val("Unica");
                                    }else if(Accion=="Oferta"){
                                        $('#lblresultadoScoring').val("Oferta");
                                        $('#valresultadoScoring').val("Oferta");                                           
                                    }else{
                                        $('#lblresultadoScoring').val("");
                                        $('#valresultadoScoring').val("");
                                    }                                    
                    $('#lblresultadoScoring').trigger('change');
                    $('#valcodigoOperacionScoring').val(NumeroOperacion);
             
              $('#modal-logdni').modal('hide');
            }

          });
                            }else{
                                const row = document.createElement('tr');
                                        row.innerHTML = `<td colspan="5" class="tblBody text-center"> No se encontró resultado</td>` 
                                    //Agrega el HTML del carrito en el tbody 
                                    contenedor.appendChild(row);
                                     $('#logconsultadoc').prop('disabled', false); 
                            }
                }
             });
                })          

                $('#btnEquifax').click(function(){
                    window.open('https://soluciones.equifax.com.pe/efx-portal-web/', '_blank');
                });     
        </script>
        <!-- CARRITO DE COMPRAS -->
        <script>
            //Evento que identifica cuando un extra es modificado
            $('#cboProducto').on('change', function(){
                const Producto = $('#cboProducto option:selected').val();
                const tipokit = $('#lbltipokit').val();
                //CODIGO USADO PARA REMOVER EL PRECIO DE REFERENCIA ENTRE PARENTESIS PARA OBTENER EL NOMBRE DEL PRODUCTO
                const txtProducto = $('#cboProducto option:selected').text().split(' (', 1)[0];
                $('#hidProducto').val(txtProducto);
                
                $('#cboTipoPrecio').val('').trigger('change');
                
                $("#cboTipoPrecio option[value='PrimeraUnidad']").remove();
                $("#cboTipoPrecio option[value='SegundaUnidadKitZV']").remove();
                
                //NUEVO CATEGORIA ITEM 20220601 CAMARA ARLO Y N1
                $("#cboTipoPrecio option[value='Camaraton']").remove();
                
                //NUEVO CATEGORIA ITEM 20220817 OPDI Y PACKSENSE
                $("#cboTipoPrecio option[value='PrecioEspecial']").remove();
                
                if(Producto == 70){
                    $('#cboTipoPrecio').append($("<option>", {
                        value: 'PrimeraUnidad',
                        text: 'PRIMERA UNIDAD'
                    }));
                }
                
                if(tipokit == 'ZeroVision'){
                    if(Producto == 84){
                        $('#cboTipoPrecio').append($("<option>", {
                            value: 'SegundaUnidadKitZV',
                            text: 'SEGUNDA UNIDAD KIT ZEROVISION'
                        }));
                    }
                }
            //NUEVO CATEGORIA ITEM 20220601 CAMARA ARLO Y N1
                if(Producto ==111){
                    $('#cboTipoPrecio').append($("<option>", {
                        value: 'Camaraton',
                        text: 'CAMARATÓN'
                    }));
                }
                if(Producto == 110){
                    $('#cboTipoPrecio').append($("<option>", {
                        value: 'Camaraton',
                        text: 'CAMARATÓN'
                    }));
                }
                if(Producto ==82){
                    $('#cboTipoPrecio').append($("<option>", {
                        value: 'Camaraton',
                        text: 'CAMARATÓN'
                    }));
                }
                //OPDI
                if(Producto ==80){
                    $('#cboTipoPrecio').append($("<option>", {
                        value: 'PrecioEspecial',
                        text: 'PRECIO ESPECIAL'
                    }));
                }
                //PACK SENSE
                if(Producto ==131){
                    $('#cboTipoPrecio').append($("<option>", {
                        value: 'PrecioEspecial',
                        text: 'PRECIO ESPECIAL'
                    }));
                }                
                
                
            })
            
            $('#cboTipoPrecio').on('change', function(){
                //RESETEAR VARIABLES DE CANTIDAD
                $('#cantidadProductos').val('');
                $('#cantidadProductos').prop('disabled', false);
                //RESETEAR VARIABLES DE PRECIO
                $('#precioUnitario').val('');
                $('#precioUnitario').prop('disabled', false);
                
                const Producto = $('#cboProducto option:selected').val();
                const TipoPrecio = $('#cboTipoPrecio option:selected').val();
                
                var data = {Producto : Producto};
                
                fetch('ajax/selectListarExtrasField.php', {method: 'POST', body: JSON.stringify(data)})
                    .then(function(res) {
                        return res.json();
                    })
                    .then(function(datos) {
                        
                        const {IdItem, Item, Precio, CuotaMes} = datos;
                        
                        let precioTotal, descuento, precioMax;
                        
                        //SI EL PRODUCTO ES UN MANDO
                        if(Producto == '70'){
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            } else if(TipoPrecio == 'PrimeraUnidad'){
                                precioTotal = 49;
                                
                                $('#cantidadProductos').val(1);
                                $('#precioUnitario').prop('disabled', true);
                                $('#cantidadProductos').prop('disabled', true);
                            }
                        } else if(Producto == '75'){
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        } else if(Producto == '84'){
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            } else if(TipoPrecio == 'SegundaUnidadKitZV'){
                                precioTotal = 400;
                                $('#cantidadProductos').val(1);
                                $('#precioUnitario').prop('disabled', true);
                                $('#cantidadProductos').prop('disabled', true);
                            }
                        } // si el producto es llave
                        else if (Producto == '68') {
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                precioTotal =  15.50;
                                precioMax = Precio*0.75;
                            }
                        } else if(Producto == '85'){
                            if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal =  299;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        } else if(Producto == '86'){
                            if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal =  449;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        } else if(Producto == '87'){
                            if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal =  799;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        }
                        else if(Producto == '88'){
                            if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal =  549;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        }
                        else if(Producto == '89'){
                            if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal =  1399;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        }
                        else if(Producto == '90'){
                            if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal =  1399;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        }
                        else if(Producto == '91'){
                            if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal =  1499;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        }
                        //CAMARATON
                        else if(Producto == '110' || Producto =='111' || Producto =='82'){
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            } else if(TipoPrecio == 'Camaraton'){
                                precioTotal = 250;
                                $('#cantidadProductos').val(1);
                                $('#precioUnitario').prop('disabled', true);
                            }                            
                        }      
                        else if(Producto == '80'){
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            } else if(TipoPrecio == 'PrecioEspecial'){
                                precioTotal = 299;
                                $('#cantidadProductos').val(1);
                                $('#precioUnitario').prop('disabled', true);
                            }                                
                        }
                        else if(Producto =='131'){
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            } else if(TipoPrecio == 'PrecioEspecial'){
                                precioTotal = 399;
                                $('#cantidadProductos').val(1);
                                $('#precioUnitario').prop('disabled', true);
                            }                                
                        }   
                        else {
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        } 

                        $('#precioUnitario').val(precioTotal)
                        $('#cuotaMes').val(CuotaMes);
                        
                        $('#precioMin').val(precioTotal);
                        $('#precioMax').val(precioMax);
                        

                    })
                
            })
            
            $('#precioUnitario').on('blur', function(){
                //alert($('#precioUnitario').val());
                
                const precio = parseFloat($(this).val());
                const TipoPrecio = $('#cboTipoPrecio').val();
                
                let max, min;
                
                if(TipoPrecio == 'catalogo'){
                    
                    min = parseFloat($('#precioMin').val());
                    max = parseFloat($('#precioMax').val());
                    
                    if(precio < min || precio > max){
                        Swal.fire('Alerta!', `El precio no puede ser menor a ${min} o mayor a ${max}.`, 'warning');
                        $(this).val('');
                    }
                    
                } else if(TipoPrecio == 'medio') {
                    min = parseFloat($('#precioMin').val());
                    max = parseFloat($('#precioMax').val());
                    
                    if(precio < min || precio >= max){
                        Swal.fire('Alerta!', `El precio no puede ser menor a ${min} o mayor igual a ${max}.`, 'warning');
                        $(this).val('');
                    }
                    
                } else if(TipoPrecio == 'autorizado') {
                    min = parseFloat($('#precioMin').val());
                    max = parseFloat($('#precioMax').val());
                    
                    if(precio < min || precio >= max){
                        Swal.fire('Alerta!', `El precio no puede ser menor a ${min} o mayor igual a ${max}.`, 'warning');
                        $(this).val('');
                    }
                    
                }
                
                
            })
            
            function getRandomInt(min, max) {
              return Math.floor(Math.random() * (max - min)) + min;
            }

            $('#btnAgregar').on('click', function(e){
                const IdItem = $('#cboProducto').val();
                const Producto = $('#cboProducto option:selected').val();
                const Item = $('#hidProducto').val();
                const TipoPrecio = $('#cboTipoPrecio option:selected').val();
                const cantidadProductos = $('#cantidadProductos').val();
                const precioUnitario = $('#precioUnitario').val();
                const cuotaMes = $('#cuotaMes').val();
                
                const datos = {Producto, TipoPrecio, cantidadProductos, precioUnitario};
                
                let numAleatorio = getRandomInt(10000, 99999);
                const dataID = `${Item}-${numAleatorio}`;
                
                if(validarProductoUnico(datos)){
                
                    if(!validarProducto(datos)){
                        Swal.fire(
                          '¡Formulario incompleto!',
                          'Por favor, completar todos los datos',
                          'warning'
                        );
                        return;
                    }
                    
                    let totalProductos, totalCuota;
                    
                    totalProductos = precioUnitario*cantidadProductos;
                    totalCuota = cuotaMes*cantidadProductos;
                    
                    var data = {
                            CodItem: IdItem,
                            Item: Item,
                            TipoPrecio: TipoPrecio,
                            cantidadProductos: cantidadProductos,
                            Precio: precioUnitario,
                            CuotaMes: cuotaMes,
                            totalProductos: totalProductos,
                            totalCuota: totalCuota,
                            dataID: dataID
                        };
                        
                    arregloDatos = [...arregloDatos, data];
                    
                    const datosExtra = {
                            tipo: 'extra',
                            descripcion: Item,
                            dataID: dataID
                        }
                        
                    arregloGeneral = [...arregloGeneral, datosExtra];
                        
                    generarHtml();
                    
                    $('#cboProducto').val('');
                    $('#cboTipoPrecio').val('');
                    $('#cantidadProductos').val('');
                    $('#precioUnitario').val('');
                } else {
                    Swal.fire(
                      '¡Extra repetido!',
                      'Imposible vender dos extras',
                      'warning'
                    );
                }
                
            })
            
            function validarProductoUnico(datos){
                const {Producto, TipoPrecio} = datos;
                
                if (arregloDatos.length > 0){
                    const resultado = arregloDatos.find(elemento => elemento.CodItem === Producto);
                    
                    if(resultado == undefined){
                        return true;
                    } else {
                    
                        if(TipoPrecio == resultado.TipoPrecio){
                            return false;
                        } else {
                            return true;
                        }

                    }
                    
                } else {
                
                    return true;
                }
            }
            
            function validarProducto(datos){
  
                const {Producto, TipoPrecio, cantidadProductos, precioUnitario} = datos;
              
                if(Producto == '' || Producto == null){
                    return false;
                }
                if(TipoPrecio == '' || TipoPrecio == null){
                    return false;
                }
                if(cantidadProductos == '' || cantidadProductos == 0){
                    return false;
                }
                if(precioUnitario == '' || precioUnitario == 0 ){
                    return false;
                }
                
                return true;
            }
            
            function generarHtml(){
                
                limpiarHTML(listaExtras);
                
                let cantidadExtras= 0;
                let resumen = '';
                let subtotal = 0;
                let subtotalCuota = 0;
                
                
                if(arregloDatos.length > 0){
                    arregloDatos.forEach(datos => {
                        console.log(datos);
                        
                        const {CodItem, CuotaMes, Item, Precio, TipoPrecio, cantidadProductos,  totalProductos, totalCuota, dataID} = datos;
                        
                        let CuotaMes_Round = parseFloat(CuotaMes);
                        let Precio_Round = parseFloat(Precio);
                        
                        listaExtras.innerHTML += `
                                <div class="row" style="margin-top: 20px;">
                                    <div class="col-md-12">
                                        <div class="info-box bg-gray">
                                            <p class="info-box-icon" style="width: 50%; font-size: 15px; height: 100px; line-height: 100px; font-weight: bold;">${Item} <button class="btn borrar-extra" data-id="${dataID}" style="color: red; background-color: transparent;">X</button> </p>
                                            <div class="info-box-content" style="text-align: right;">
                                                <span class="info-box-text">S/. ${Precio_Round} - S/. ${CuotaMes_Round}</span>
                                                <span class="info-box-text">${cantidadProductos}</span>
                                                <span class="info-box-number">Total: ${totalProductos}</span>
                                                <span class="info-box-number">Total cuota: ${totalCuota}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            `;
                        
                        let cantidad;
                        
                        cantidad = parseInt(cantidadProductos);
                        cantidadExtras += cantidad;
                        
                        subtotal += totalProductos;
                        subtotalCuota += totalCuota;
                        
                        
                        
                    })
                }
                
                //ALGORITMO PARA GENERAR EL RESUMEN DE INSTALACION PARA EXTRAS
                arregloGeneral.forEach((elemento, index) => {
                    //Si existe más de un elemento en el arreglo
                    if(arregloGeneral.length > 1){
                        if((arregloGeneral.length -1) == index){
                            resumen += `${elemento.descripcion} (${elemento.tipo})`;
                        } else {
                            resumen += `${elemento.descripcion} (${elemento.tipo}) + `;
                        }
                    } else {
                        resumen += `${elemento.descripcion}`;
                    }
                    
                })
                
                $('#txtResumen').val(resumen);
                        
                $('#txtCantidadExtra').val(cantidadExtras);
                
                $('#txtTotal').val(subtotal);
                $('#txtTotalCuota').val(subtotalCuota);
                
            }
            
            function generarHtmlRegalos(){
                
                limpiarHTML(listaRegalos);
                
                //const resumenventa = $('#lblresumenventa').val();
                
                let resumen = '';
                
                let cantidadRegalos=0;
                
                let subtotal = 0;
                let subtotalCuota = 0;
                
                if(arregloRegalos.length > 0){
                    arregloRegalos.forEach(datos => {
                    
                        const {CodItem, CuotaMes, Item, Precio, cantidad,  totalProductos, totalCuota, dataID} = datos;
                        
                        listaRegalos.innerHTML += `
                                                <div class="row" style="margin-top: 20px;">
                                                    <div class="col-md-12">
                                                        <div class="info-box bg-gray">
                                                            <p class="info-box-icon" style="width: 50%; font-size: 15px; height: 100px; line-height: 100px; font-weight: bold;">${Item} <button class="btn borrar-regalo" data-id="${dataID}" style="color: red; background-color: transparent;">X</button> </p>
                                                            <div class="info-box-content" style="text-align: right;">
                                                                <span class="info-box-text"> Cuota - S/. ${CuotaMes}</span>
                                                                <span class="info-box-text">${cantidad}</span>
                                                                <span class="info-box-number">Total cuota: ${totalCuota}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>`;
                                                    
                        
    
                        let auxCantProductos = parseInt(cantidad)
                        
                        cantidadRegalos += auxCantProductos;
                        subtotalCuota += totalCuota;
    
                    })
                }
                
                console.log(arregloGeneral);
                //ALGORITMO PARA GENERAR EL RESUMEN DE INSTALACION PARA EXTRAS
                arregloGeneral.forEach((elemento, index) => {
                    //Si existe más de un elemento en el arreglo, por defecto el index 0 siempre es el KIT
                    if(arregloGeneral.length > 1){
                        if((arregloGeneral.length -1) == index){
                            resumen += `${elemento.descripcion} (${elemento.tipo})`;
                        } else {
                            resumen += `${elemento.descripcion} (${elemento.tipo}) + `;
                        }
                    } else {
                        //SE AGREGA EL TIPO DE KIT
                        resumen += `${elemento.descripcion}`;
                    }
                    
                })
                
                $('#txtResumen__Regalo').val(resumen);
                $('#txtCantidadRegalo').val(cantidadRegalos);
                $('#txtTotalCuota__Regalo').val(subtotalCuota);
                
            }
            
            function limpiarHTML(cont) {
                //forma recomendada
                while (cont.firstChild) {
                    cont.removeChild(cont.firstChild);
                }
                
                $('#txtResumen').val('');
                $('#txtCantidad').val('');
                $('#txtTotal').val('');
            }

        function validarProductoARLO(datos){
                var valArloI=0;
                var valArloE=0;
                const {Producto} = datos;
                if(Producto=="113"){
                    if (arregloDatos.length > 0){
                        const resultadoCamaraInternaArlo = arregloDatos.find(elemento => elemento.CodItem == 110);
                        const resultadoCamaraExternaArlo = arregloDatos.find(elemento => elemento.CodItem == 111);
                        console.log(resultadoCamaraInternaArlo);
                        if(resultadoCamaraInternaArlo == undefined){
                            valArloI=0;
                        } else {
                            console.log(resultadoCamaraInternaArlo.TipoPrecio);
                            if(resultadoCamaraInternaArlo.TipoPrecio=='catalogo'){
                                valArloI=1;
                            } else {
                                valArloI=0;
                            }
    
                        }
                        if(resultadoCamaraExternaArlo == undefined){
                            valArloE=0;
                        } else {
                            if(resultadoCamaraExternaArlo.TipoPrecio=='catalogo'){
                                valArloE=1;
                            } else {
                                valArloE=0;
                            }
    
                        }
                    var sumaAR=(valArloI+valArloE);
                    console.log(sumaAR);
                      if(sumaAR==0){
                          return true;
                      }else{
                          return false;
                      }
                        
                    }else{
                        return true;
                    }
                  
                }else{
                    return false;
                }
            }  

			function validarProductoSMARTHUB(){
			    var valArloI=0;
			    var lbltipokit=$('#lbltipokit').val();
			    console.log(arregloDatos);
			        if (arregloDatos.length > 0){
			            
			            const resultadoArloSmartHUB = arregloDatos.find(elemento => elemento.CodItem == 112);
			            
			            const resultadoCamaraArloInterior = arregloDatos.find(elemento => elemento.CodItem == 138);
			            const resultadoCamaraArloExterior = arregloDatos.find(elemento => elemento.CodItem == 140);
			            
			            const resultadoPackCamaraArloInterior= arregloDatos.find(elemento => elemento.CodItem == 142);
			            const resultadoPackCamaraArloExterior = arregloDatos.find(elemento => elemento.CodItem == 143);
			            
			            console.log(resultadoCamaraArloInterior);
			            
			            if(lbltipokit=='Basico PRO' || lbltipokit=='ZeroVision PRO'){
			                valArloI+=1;
			            }
			            
			            if(resultadoCamaraArloInterior !== undefined){
			                valArloI+=resultadoCamaraArloInterior.cantidadProductos;
			                
			            }
			            
			            if(resultadoCamaraArloExterior !== undefined){
			                valArloI+=resultadoCamaraArloExterior.cantidadProductos;
			                
			            }
			            
			            if(resultadoPackCamaraArloInterior !== undefined){
			                valArloI+=2;
			            }
			            if(resultadoPackCamaraArloExterior !== undefined){
			                valArloI+=2;
			            }
			            
    			        if(valArloI>=2){
    			            if(resultadoArloSmartHUB !== undefined){
    			                return false;
    			            }			            
    			          return true;
    			        }else{
    			          return false;
    			        }
			        
			        }else{
			            return false;
			        }			    

			}
			              
            //EXTRAS
            $('#generarOferta').on('click', function(e){
                
                const txtResumen = $('#txtResumen').val();
                const txtCantidadExtra = $('#txtCantidadExtra').val();
                const txtTotal = $('#txtTotal').val();
                const txtTotalCuota = $('#txtTotalCuota').val();
                
                const datos = {
                    arregloDatos,
                    txtResumen,
                    txtCantidadRegalo,
                    txtTotal,
                    txtTotalCuota
                }
                
                //SET DATOS EN EL FORMULARIO
                $('#lbltotalextra').val(txtTotal);
                $('#lbltotalcuota').val(txtTotalCuota);
                $('#lblCantExtras').val(txtCantidadExtra);
                $('#lblresumenventa').val(txtResumen);

			    if(validarProductoSMARTHUB()){
    			    Swal.fire({
    			        icon: 'warning',
    			        title:'¡Recuerda!',
    			        text: 'Una instalación con 2 cámaras o más requiere la instalación de ARLO SMART HUB.Agrégalo dentro de la lista de extras',
    			        confirmButtonColor: '#e4002b'
    			    }).then((result) => {
    			        
    			    })
			        
			        return;
			    }                
                
                
                Swal.fire({
                    icon: 'success',
                    text: 'Datos generados correctamente',
                    confirmButtonColor: '#e4002b'
                }).then((result) => {
                     $('#modal__carritocompras').modal('hide');
                })
                
            })
            
            $('#generarOferta__Regalo').on('click', function(e){
                
                const txtResumen__Regalo = $('#txtResumen__Regalo').val();
                const txtCantidadRegalo = $('#txtCantidadRegalo').val();
                const txtTotalCuota__Regalo = parseFloat($('#txtTotalCuota__Regalo').val());
                let lbltotalcuota = parseFloat($('#lbltotalcuota').val());
                
                lbltotalcuota += txtTotalCuota__Regalo;
                
                $('#lblresumenventa').val(txtResumen__Regalo);
                $('#lblCantRegalos').val(txtCantidadRegalo);
                $('#lbltotalcuota').val(lbltotalcuota);
                
                Swal.fire({
                    icon: 'success',
                    text: 'Datos generados correctamente',
                    confirmButtonColor: '#e4002b'
                }).then((result) => {
                     $('#modal__regalos').modal('hide');
                })
            })
            
            $('#listaExtras').click(function(e){
                if (e.target.classList.contains('borrar-extra')) {
                    const dataID = e.target.getAttribute('data-id');
                    
                    //Elimina del arreglo de articulosCarrito por el data-id
                    arregloDatos = arregloDatos.filter(datos => datos.dataID != dataID);
                    arregloGeneral = arregloGeneral.filter(datos => datos.dataID != dataID);
                    
                    generarHtml();
                
                    
                   swal.fire('Extra eliminado', 'Se elimino el extra correctamente', 'success');
                }
            })
            
            $('#listaRegalos').click(function(e){
                if (e.target.classList.contains('borrar-regalo')) {
                    const dataID = e.target.getAttribute('data-id');
                    //Elimina del arreglo de articulosCarrito por el data-id
                    arregloRegalos = arregloRegalos.filter(datos => datos.dataID != dataID);
                    arregloGeneral = arregloGeneral.filter(datos => datos.dataID != dataID);
                    
                    generarHtmlRegalos();
   
                    swal.fire('Regalo eliminado', 'Se elimino el regalo correctamente', 'success');
                }
                             
            })
            

            
        </script>
        <!-- EVENTOS CARRITOS DE COMPRAS -->
        <script>
            $('#generarExtras').on('click', function(e){
                
                e.preventDefault();
                
                if ($('#lbltipokit').val() != '' && $('#lbltipokit').val() != null){
                    generarHtml();
                    $('#modal__carritocompras').modal('show');
                } else {
                    Swal.fire(
                      'SELECCIONAR KIT',
                      'Por favor seleccionar kit',
                      'warning'
                    );
                }
                
                
            })
            
            $('#generarRegalos').on('click', function(e){
                e.preventDefault();
                
                if ($('#lbltipokit').val() != '' && $('#lbltipokit').val() != null){
                    generarHtmlRegalos();
                    $('#modal__regalos').modal('show');
                    
                } else {
                    Swal.fire(
                      'SELECCIONAR KIT',
                      'Por favor seleccionar kit',
                      'warning'
                    );
                }
                
            })
            
            $('#lblresultadoScoring').on('change', function(){
                const scoring = $('#lblresultadoScoring').val();
                const tipokit = $('#lbltipokit').val();
                const PAI = $('#lblPAI').val();
                
                    /*
                    if(scoring=="Unica"){
                        $('#lblPAI option[value="PAI 30x36"]').hide();
                        $('#lblPAI option[value="PAI 30x36"]').prop('disabled',true);
                    }else{
                        $('#lblPAI option[value="PAI 30x36"]').show();
                        $('#lblPAI option[value="PAI 30x36"]').prop('disabled',false);
                    }
                    */
                
                if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
                    return;
                } else {
                    categoriaPrecio(scoring, tipokit, PAI);
                }
            })
            
            $('#lbltipokit').on('change', async function(){
                //const resultadoScoring = $('#valresultadoScoring').val();
                const scoring = $('#lblresultadoScoring').val();
                const tipokit = $('#lbltipokit').val();
                const PAI = $('#lblPAI').val();
                const tipoventa=$('#lbltipoventa').val();
                
                if(tipoventa == 'RPPA' || tipoventa == 'RPPR' || tipoventa == 'RPMKT' || tipoventa == 'RPTMK' || tipoventa == 'RP'){
                    if(scoring=="Unica" && tipokit!=='Reconexion'){
                        $('#lblPAI option[value="PAI 30x36"]').hide();
                        $('#lblPAI option[value="PAI 30x36"]').prop('disabled',true);
                    }else{
                        $('#lblPAI option[value="PAI 30x36"]').show();
                        $('#lblPAI option[value="PAI 30x36"]').prop('disabled',false);
                    }
                }                
                
                console.log('await');
                const validadorZerovision = await validarZeroVisionSegundoDispostivo();
                console.log(validadorZerovision);
                
                if(validadorZerovision){
                    return;
                }
                
                console.log('Cambio de kit en el arreglo General');
                //ALGORITMO QUE GUARDA EL ULTIMO TIPO DE KIT MODIFICADO
                var data = {
                    tipo: 'kit',
                    descripcion: tipokit
                };
                
                console.log(arregloGeneral);
                if(arregloGeneral.length > 0){
                    arregloGeneral.some((elemento,index) => {
                        if(elemento.tipo == 'kit'){
                            arregloGeneral.splice(index, 0);
                            
                            arregloGeneral[index] = data;
                        }
                    })
                } else {
                    arregloGeneral = [...arregloGeneral, data];
                }
                //FIN ALGORITMO
                
                generarResumenInstalacion();
                
                //AGREGAR FUNCION DE OCULTAR ARLO
                if(tipokit=='Camara' || tipokit=='High Security'){
                    $('.camaraarlo').removeClass('ocultar');
                    //PARA REGALO DE SMARTHUB NO ACTIVO
                    $('#cboRegalo option[value="113"]').hide();
                    $('#cboRegalo option[value="113"]').prop('disabled',true);                    
                }else{
                    $('.camaraarlo').addClass('ocultar');
                    //PARA REGALO DE SMARTHUB ACTIVO
                    $('#cboRegalo option[value="113"]').show();
                    $('#cboRegalo option[value="113"]').prop('disabled',false);                    
                }                
                
                if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
                    return;
                } else {
                    categoriaPrecio(scoring, tipokit, PAI);
                }
            })
            
            async function validarZeroVisionSegundoDispostivo(){
                //AWAIT QUE ESPERA HASRTA QUE EL FOR TERMINE PARA CONTINUAR LA EJECUCION
                for await  (const datos of arregloDatos){
                    console.log(datos);
                    //const contents = await fs.readFile(file, 'utf8');
                    if(datos.Item == 'ZEROVISION'){
                        if(datos.TipoPrecio == 'SegundaUnidadKitZV'){
                            swal.fire('Error', 'No puede modificar el tipo de kit porque existe un extra que requiere el tipo de kit ZEROVISION', 'error');
                            $('#lbltipokit').val('ZeroVision');
                            //generarResumenInstalacion();
                            return true;
                        }
                    }
                    
                }
                
                return false;
            }
            
            $('#lblPAI').on('change', function(){
                //const resultadoScoring = $('#valresultadoScoring').val();
                const scoring = $('#lblresultadoScoring').val();
                const tipokit = $('#lbltipokit').val();
                const PAI = $('#lblPAI').val();
                
                if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
                    return;
                } else {
                    categoriaPrecio(scoring, tipokit, PAI);
                }
            })
            
            $('#lblcategoriaprecio').on('change', function(){
                const categoriaPrecio = $('#lblcategoriaprecio').val();
                
                if(categoriaPrecio== '' || categoriaPrecio == null){
                    return;
                } else {
                    $('#hidCategoriaPrecio').val(categoriaPrecio);
                    asignarPrecioKit(categoriaPrecio);
                    if(categoriaPrecio== 'PRECIO SEGUNDA ALARMA'){
                        $('.segundaalarma').removeClass('ocultar');
                    }else{
                        $('.segundaalarma').addClass('ocultar');
                    }
                }
            })
            $('#lbldistrito').on('change', function(){
                //Limpiar todos los datos
               $('#lblresultadoScoring').val("");
               $('#valcodigoOperacionScoring').val("");
               $('#valresultadoScoring').val("");
               
               
               $('#lbltipokit').val("");
               $('#lblPAI').val("");
               $('#lbltipocamarakit').val("");
               $('#lblcategoriaprecio').val("");
               $('#hidCategoriaPrecio').val("");
               $('#lblpreciokit').val("");
               $('#precioKit__MIN').val("");
               $('#precioKit__MAX').val("");
               $('#hidPrecioKit').val("");
               $('#lblCantExtras').val("");
               $('#lbltotalextra').val("");
               $('#lblclosingpack').val("");
               $('#valclosingpack').val("");
               $('#lblresumenventa').val("");
               $('#lblCantRegalos').val("");
               $('#lblDescuentoCuota').val("");
               $('#lbltotalcuota').val("");
               $('#lblextraautorizado').val("");
               closingpack = document.getElementById("lblclosingpack");
               categoriaprecio = document.getElementById("lblcategoriaprecio");
               limpiarDatos(closingpack);
               limpiarDatos(categoriaprecio);
               
               //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE REGALOS
               arregloRegalos = [];
               //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE EXTRAS
               arregloDatos = [];
               //ARREGLO GENERAL DE KIT, REGALOS Y EXTRAS
               arregloGeneral = []; 
               
               var idGeografico = $(this).val();
			   
			   var datos = {
			        idGeografico: idGeografico
			    }
			   
			 //  console.log(idGeografico);
			    var url = 'ajax/findSims.php';
			    $.ajax({
			        type: 'POST',
			        url: url,
			        data: datos,
			        success: function(datos) {
			            console.log(datos);
			         //   $('.mensajematricula').html(datos);
			         $("#lblsims").val(datos);
			        }
			    });
               
            })             
            
            
            $('#lblsegmento').on('change', function(){
                //Limpiar todos los datos
               $('#lblresultadoScoring').val("");
               $('#valcodigoOperacionScoring').val("");
               $('#valresultadoScoring').val("");
               
               
               $('#lbltipokit').val("");
               $('#lblPAI').val("");
               $('#lbltipocamarakit').val("");
               $('#lblcategoriaprecio').val("");
               $('#hidCategoriaPrecio').val("");
               $('#lblpreciokit').val("");
               $('#precioKit__MIN').val("");
               $('#precioKit__MAX').val("");
               $('#hidPrecioKit').val("");
               $('#lblCantExtras').val("");
               $('#lbltotalextra').val("");
               $('#lblclosingpack').val("");
               $('#valclosingpack').val("");
               $('#lblresumenventa').val("");
               $('#lblCantRegalos').val("");
               $('#lblDescuentoCuota').val("");
               $('#lbltotalcuota').val("");
               $('#lblextraautorizado').val("");
               closingpack = document.getElementById("lblclosingpack");
               categoriaprecio = document.getElementById("lblcategoriaprecio");
               limpiarDatos(closingpack);
               limpiarDatos(categoriaprecio);
               
               //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE REGALOS
               arregloRegalos = [];
               //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE EXTRAS
               arregloDatos = [];
               //ARREGLO GENERAL DE KIT, REGALOS Y EXTRAS
               arregloGeneral = [];                    
               
            })            
            
            
            
            $('#btnAgregar__Regalos').on('click', function(){
                const regalo = $('#cboRegalo').val();
                const cantidad = parseInt($('#cantidadProductos__Regalos').val());
                const datos = {Producto : regalo};
                
                if($('#cantidadProductos__Regalos').val() == '' || $('#cantidadProductos__Regalos').val() == null || $('#cantidadProductos__Regalos').val() <= 0) {
                   swal.fire('Error', 'Indicar la cantidad de regalos', 'error');
                   return;
                }else{
                if(validarProductoARLO(datos)){
                    swal.fire('Error', 'Verificar que hayas añadido Extra Camara Interna o Externa ARLO a precio catálogo', 'error');
                    return;
                }   
                
                fetch('ajax/selectListarExtrasField.php', {method: 'POST', body: JSON.stringify(datos)})
                    .then(function(res) {
                        return res.json();
                    })
                    .then(function(datos) {
                        
                        console.log(datos);
                        
                        const {CodItem, Item, CuotaMes, Precio} = datos;
                        
                        let totalRegalo = Precio*cantidad;
                        let totalCuota = CuotaMes*cantidad;
                        
                        let numAleatorio = getRandomInt(10000, 99999);
                        const dataID = `${Item}-${numAleatorio}`;
                        
                       var data = {
                                CodItem: CodItem,
                                Item: Item,
                                cantidad: cantidad,
                                Precio: Precio,
                                CuotaMes: CuotaMes,
                                totalProductos: totalRegalo,
                                totalCuota: totalCuota,
                                dataID: dataID
                            };
                            
                            
                        arregloRegalos = [...arregloRegalos, data];
                        
                        const datosExtra = {
                            tipo: 'regalo',
                            descripcion: Item,
                            dataID: dataID
                        }
                        
                        arregloGeneral = [...arregloGeneral, datosExtra];
                        
                        generarHtmlRegalos();
                    })
                }
                
            })
            
            $('#lblpreciokit').on('blur', function(){
                const precio = parseFloat($('#lblpreciokit').val());
                const max = parseFloat($('#precioKit__MAX').val());
                const min = parseFloat($('#precioKit__MIN').val());
                
                if(precio > max || precio < min){
                    Swal.fire('Alerta!', 'El precio del kit no se encuentra en el rango, por favor, VERIFICAR', 'warning')
                    $('#lblpreciokit').val('');
                }
                
            })
            
            $('#lblclosingpack').on('change', function(){
                const lblclosingpack = $('#lblclosingpack').val();
                console.log('Inicia closing pack');
                console.log(lblclosingpack);
                //ALGORITMO QUE ELIMINA EL CLOSING PACK ESCOGIDO ANTES
                arregloGeneral.forEach((elemento, index) => {
                    console.log(elemento);
                    if(elemento.tipo == 'CP'){
                        arregloGeneral.splice(index, 1);
                    }
                })
                //FIN ALGORITMO
                
                if(lblclosingpack == '' || lblclosingpack == null || lblclosingpack == 'Ninguno'){
                    
                } else {
                    var data = {
                        tipo: 'CP',
                        descripcion: lblclosingpack
                    };
                    
                    arregloGeneral = [...arregloGeneral, data];
                }
                
                console.log(arregloGeneral);
                
                generarResumenInstalacion();
            })
            
            $('#lbltipoventa').on('change', function(){

                //const resultadoScoring = $('#valresultadoScoring').val();
                const scoring = $('#lblresultadoScoring').val();
                const tipokit = $('#lbltipokit').val();
                const PAI = $('#lblPAI').val();
                
                if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
                    return;
                } else {
                    categoriaPrecio(scoring, tipokit, PAI);
                }
            })
            $('#lblDescuentoCuota').on('change', function(){

                //const resultadoScoring = $('#valresultadoScoring').val();
                const DescuentoCuota = $('#lblDescuentoCuota').val();
                if(DescuentoCuota == '2meses'){
                    $('#lblmesesautorizados').val('2.00');
                }else if(DescuentoCuota == '3meses'){
                    $('#lblmesesautorizados').val('3.00');
                }else if(DescuentoCuota == '1mes'){
                    $('#lblmesesautorizados').val('1.00');
                    
                }else{
                    $('#lblmesesautorizados').val('0.00');
                }
            })
            
            
//*************GUIA REMISION*************//         
            
$(document).ready(function() {
    $('#lblncontrato').on('input', function() {
        var valorContrato = $(this).val(); // Obtener el valor ingresado en lblncontrato
        var valorCategoria = $('#lblcategoria').val(); // Obtener el valor de lblcategoria
        var estadoVenta = $('#lblestventaprovicional').val();

        // Obtener la longitud del valor sin tener en cuenta los caracteres de la máscara
        var longitudReal = valorContrato.replace(/_/g, '').length;

        // Verificar si la longitud del valor ingresado es igual a 7 y la categoría es 'Delegacion'
        if (longitudReal === 7 && valorCategoria === 'Delegacion' && estadoVenta ==='InstaladaDEL') {
            // console.log("Se han ingresado 7 dígitos en lblncontrato:", valorContrato);
            // console.log(valorCategoria);
                        // Enviar los datos al servidor a través de una solicitud AJAX
            var datos = {
                         ncontrato:valorContrato,
                         categoria:valorCategoria
                        }                
            $.ajax({
                type: 'POST',
                url: 'ajax/consultaContratoGuia.php',
                data: datos,
                dataType: "Json",
                success: function (data) {
                    console.log(data);
                    if (data.respuesta == 'exito') {
                        // Si la respuesta del servidor es un éxito, mostrar un mensaje de éxito
                        alertify.success("El Número Contrato esta vinculado con la Guia de Remisión");

                    } else if (data.respuesta == 'Denegado') {
                        Swal.fire({
                            title: 'Advertencia!',
                            text: 'El número ingresado no esta vinculado con la Guia de Remisión',
                            icon: 'warning',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                            closeOnConfirm: false,
                            allowOutsideClick: false
                        }).then((result) => {
                            // Si el usuario hace clic en OK, recargar la página
                            if (result.isConfirmed) {
                                // window.location.reload();
                                $('#lblncontrato').val('');
                            }
                        });
                        // Si no hay cambios, mostrar un mensaje de advertencia
                        

                    } else {
                        // Si hay un error en el servidor, mostrar un mensaje de error
                        alertify.error("Fallo del servidor");

                    }
                }
            });
        }
    });
});
        </script>
    </body>
</html>