<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
    }

    date_default_timezone_set('America/Lima');
    
    include 'config/db.php';
    include 'config/conexion.php';

    $fechadiahoy=date("M-Y");
    $fechames="May-2018";
    $fechconvercion=date('Y-m-d', strtotime($fechadiahoy));

    $dias=date("d");
    $mes=date("m");
    $ano=date("Y");    

    
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verisure | VeriSmart</title>
    
    <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" />
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
            folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
    <!-- daterange picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-daterangepicker/daterangepicker.css">
    <!-- Date Picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
    <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
    <!-- Alertifyjs -->
    <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <!--Hoja de estilos de la pagina dashboard visita *No usuar stilos en la misma pagina-->
    <link rel="stylesheet" href="css/dashboardvisita.css">
    
    <link rel="stylesheet" href="admin/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
    
    <style>

        table tbody tr th{
            text-align: center;
        }
        .tblSubHeader, .Row__titulo{
            text-transform: uppercase;
        }
        
        .block{
            display: block!important;
        }
        
        .ocultar{
            display: none;
        }
        
        .bajo{
            background-color: #e4002b;
            color: white;
        }
        
        .medio{
            background-color: orange;
            color: white;
        }
        
        .alto{
            background-color: green;
            color: white;
        }
        
        .tblfooter{
            background-color: gray;
            color: white;
        }
        
        .big{
            width: 20%;
        }
        
        .mid{
            width: 15%;
        }
        
        .small{
            width: 8%;
        }
        
        .tblheadValue{
            background-color: gray;
            text-align: center;
            color: white;
        }
    </style>
    
    <style>
        .table-sortable th {
          cursor: pointer;
        }
        
        .table-sortable .th-sort-asc::after {
          content: "\25b4";
        }
        
        .table-sortable .th-sort-desc::after {
          content: "\25be";
        }
        
        .table-sortable .th-sort-asc::after,
        .table-sortable .th-sort-desc::after {
          margin-left: 5px;
        }
        
        .table-sortable .th-sort-asc,
        .table-sortable .th-sort-desc {
          background: #A62828;
        }
        
        .sizetr{
            height:3vw!important;
        }

    </style>
</head>
<body class="skin-red sidebar-mini sidebar-collapse">
    <div id="divLoading" class="ocultar">
        <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
        </div>
    </div>
    <div class="wrapper">
        <!-- Header -->
        <?php include 'admin/header.php'; ?>
        <!-- Left side column. contains the logo and sidebar -->
        <?php
            include 'admin/main-sidebar.php';
        ?>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div style="font-size:180%;"> DASHBOARD&nbsp <span style="font-size:80%;color:#DAD8D4"> | &nbsp <span style="font-size:80%;color:#8D8A80">CALCULADORA MAQUETA DE COMISIONES</span></span> </div>              
                <ol class="breadcrumb">
                    <li><a class="text-left"><font color="red">Dia: <?php echo $dias."/".$mes."/".$ano;?></font></a></li>
                </ol>
            </section>
            <!-- Main content -->
            <section class="content">
                <div class="box box-danger" >
                    <div class="box-header"> 
                        <i class="fa fa-bar-chart-o"></i> 
                        <h3 class="box-title"> MES -  | 
                            <input type="text" style="font-size:100%;color:#444; background-color: #fff;border: 0;"  id="lblmesvisit" name="lblmesvisita">
                        </h3>
                        
                    </div>
                    
                    <div class="box-body">
                        <div class="ocultar" id="divTable">
                            <table class="table table-hover table-striped" id="generalLeadsDIA">
                                <thead>
                                        
                                </thead>
                                <tbody>
                                    
                                </tbody>
                            </table>
                        </div>
                        
                    </div>
                    
                </div>
                
            </section>
            <?php include 'modalpassword.php';?>
            
        </div>
    </div>
    <!-- jQuery 3 -->
    <script src="admin/bower_components/jquery/dist/jquery.min.js"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <!-- Bootstrap 3.3.7 -->
    <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- SELECT 2 -->
    <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
    <!-- date-range-picker -->
    <script src="admin/bower_components/moment/min/moment.min.js"></script>
    <script src="admin/bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
    <!-- datepicker -->
    <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>

    <!-- Bootstrap WYSIHTML5 -->
    <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
    <!-- Slimscroll -->
    <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <!-- FastClick -->
    <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
    <!-- AdminLTE App -->
    <script src="admin/dist/js/adminlte.min.js"></script>
    <!-- SWEET ALERT -->
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- CHARTS -->
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    
    <script src="admin/bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="admin/bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
    <!-- GLOBALES -->
    <script>
        const perfilUsuario = $('#headerPerfilUsuario').val();
        const MatriculaUsuario = $('#headerMatriculaUsuario').val();
        
    </script>
    <!-- INICIALIZADORES -->
    <script>
        $('#lblmesvisit').datepicker({
            autoclose: true,
            language: 'en',
            firstDay: 1, format: 'M-yyyy',
            viewMode: "years",
            minViewMode: "months"
        }).datepicker("setDate", new Date());          
        
    </script>
    <!-- EVENTOS -->
    <script>

        $("#lblmesvisit").on("change", function(){
            generarTablaDiaHead();
            generarTablaDiaBody();
                
        });        
        
        
    </script>
    <!-- document ready -->
    <script>
        $(document).ready(() => {
            $('#divLoading').removeClass('ocultar');
            $('#divLoading').addClass('block');
            //GENERAR TABLA DEL DIA
            generarTablaDiaHead();
            generarTablaDiaBody();

          
            
            setTimeout(function(){
                $('#divLoading').addClass('ocultar');
                $('#divLoading').removeClass('block');
                
                $('#divTable').removeClass('ocultar');
            }, 4200);

        })
    </script>
    <!-- Funciones -->
    <script>
    
        function generarTablaDiaHead(){
            const contenedorLeadsDiaHead = document.querySelector('#generalLeadsDIA thead');
            limpiarHTML(contenedorLeadsDiaHead);
            //CABECERA DE HORAS
            const row = document.createElement('tr');
            row.innerHTML += '<th style="position: sticky; top: 0; z-index: 1;"></th>';
            
            row.innerHTML += '<th class="tblSubHeader text-center" style="position: sticky; top: 0; z-index: 1;">Sem 01</th>';
            row.innerHTML += '<th class="tblSubHeader text-center" style="position: sticky; top: 0; z-index: 1;">Sem 02</th>';
            row.innerHTML += '<th class="tblSubHeader text-center" style="position: sticky; top: 0; z-index: 1;">Sem 03</th>';
            row.innerHTML += '<th class="tblSubHeader text-center" style="position: sticky; top: 0; z-index: 1;">Sem 04</th>';
            row.innerHTML += '<th class="tblSubHeader text-center" style="position: sticky; top: 0; z-index: 1;">Sem 05</th>';
            
            row.innerHTML += '<th class="tblSubHeader text-center" style="position: sticky; top: 0; z-index: 1;">TOTAL</th>';
            contenedorLeadsDiaHead.appendChild(row);

        }
        
        function generarTablaDiaBody(){
            const contenedorLeadsDiaHead = document.querySelector('#generalLeadsDIA tbody');
            limpiarHTML(contenedorLeadsDiaHead);
            
            //LEADS
            const rowVisita = document.createElement('tr');
            const rowVisitaLS = document.createElement('tr');
            const rowVisitaELS = document.createElement('tr');
            rowVisita.innerHTML += '<th class="tblSubHeader">VISITA</th>';
            rowVisitaLS.innerHTML += '<th class="tblSubHeader">VISITA L a S </th>';
            rowVisitaELS.innerHTML += '<th class="tblSubHeader">VISITA EXPRÉS L a S</th>';

            const fechaMes = moment($('#lblmesvisit').val(), "MMM-YYYY").format("YYYY-MM-01");
            console.log($('#lblmesvisit').val());
            console.log(fechaMes);
            

        

            console.log(perfilUsuario);
            console.log(MatriculaUsuario);

            
            $.ajax({
                type: 'Post',
                url: 'ajax/dataDashboardVisitasOperador.php',
                data: {fechaMes: fechaMes,perfilUsuario:perfilUsuario,MatriculaUsuario:MatriculaUsuario},
                dataType: 'json',
                success: function(data){
                    console.log(data);
                    let arregloVisitas = data.Visitas;
                    let totalVisitas = 0;
                    let arregloVisitasLS = data.VisitasLS;
                    let totalVisitasLS = 0;
                    let arregloVisitasELS = data.VisitasELS;
                    let totalVisitasELS = 0;                      
                    const arrayCC = ['W1','W2','W3','W4','W5'];
                    arrayCC.forEach(function(valor, indice, array) {
                        console.log("En el índice " + indice + " hay este valor: " + valor);
                        
                        let resultadoVisitas = arregloVisitas.find( elemento => elemento.Week == valor);
                        if(resultadoVisitas){
                         rowVisita.innerHTML += `<th>${resultadoVisitas.TOTAL}</th>`;
                         totalVisitas += parseInt(resultadoVisitas.TOTAL);
                        } else {
                         rowVisita.innerHTML += `<th>0</th>`;
                        }
                        
                        let resultadoVisitasLS = arregloVisitasLS.find( elemento => elemento.Week == valor);
                        if(resultadoVisitasLS){
                         rowVisitaLS.innerHTML += `<th>${resultadoVisitasLS.TOTAL}</th>`;
                         totalVisitasLS += parseInt(resultadoVisitasLS.TOTAL);
                        } else {
                         rowVisitaLS.innerHTML += `<th>0</th>`;
                        } 
                        
                        let resultadoVisitasELS = arregloVisitasELS.find( elemento => elemento.Week == valor);
                        if(resultadoVisitasELS){
                         rowVisitaELS.innerHTML += `<th>${resultadoVisitasELS.TOTAL}</th>`;
                         totalVisitasELS += parseInt(resultadoVisitasELS.TOTAL);
                        } else {
                         rowVisitaELS.innerHTML += `<th>0</th>`;
                        }                         
                        
                        
                    });
                    rowVisita.innerHTML += `<th class="tblBody text-center">${totalVisitas}</th>`;
                    rowVisitaLS.innerHTML += `<th class="tblBody text-center">${totalVisitasLS}</th>`;
                    rowVisitaELS.innerHTML += `<th class="tblBody text-center">${totalVisitasELS}</th>`;
                    
                       
                }
            })
            
           
            
            contenedorLeadsDiaHead.appendChild(rowVisita);
            contenedorLeadsDiaHead.appendChild(rowVisitaLS);
            contenedorLeadsDiaHead.appendChild(rowVisitaELS);
           
        }
        
        function limpiarHTML(cont) {
            //forma recomendada
            while (cont.firstChild) {
                cont.removeChild(cont.firstChild);
            }
        }
    </script>
    
</body>
</html>