<?php

include('is_logged.php');
date_default_timezone_set('America/Lima');
//FUNCIONES UFT8 Y Fecha
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}
//CONEXION A LA BASE DE DATOS
require '../config/db.php';
require '../config/conexion.php';

//VALIDAR
$habilitado = $_POST['habilitado'];
$IdVenta = $_POST['IdVenta'];

//LOG DE SEGURIDAD Y TRANSACCION
include 'log/insertLog.php';
include 'log/insertLogTeleventa.php';

//$arrayActual = consultaHabilitarTV($selectrows);

try{
    $stmt = $con->prepare("UPDATE tblventa SET HabilitadoTV = ? WHERE IdVenta=?");
    $stmt->bind_param('ss', $habilitado, $IdVenta);
    $stmt->execute();
    if ($stmt->affected_rows > 0) {
        $respuesta = array(
            'respuesta' => 'exito',
            'id_actualizado' => $IdVenta,
            'tipo' => 'televenta'
        );
    } else {
        $respuesta = array(
            'respuesta' => 'nada',
            'id_actualizado' => $IdVenta,
            'tipo' => 'televenta'
        );
    }
    $stmt->close();
    
} catch (\Exception $e) {
    $respuesta = array(
        'respuesta' => 'error',
        'mensaje' => $e->getMessage(),
        'tipo' => 'televenta'
    );
}

echo json_encode($respuesta);