<?php

include('is_logged.php');

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

//AGREGAR FUNCIONES LOG
include 'log/insertLog.php';
include 'log/insertLogMDP.php';


if (isset($_POST['idmdp'])) {
   $idmdp = sanitizaCampo($_POST['idmdp'], 'sanitizeint|scapestring|htmlspecialchars',$con);
   $idmdp = htmlspecialchars($idmdp);
   
   $updatemdp= $con->prepare("UPDATE dbVENTAS.tblmdp m SET m.EstadoURL='Inactivo' where m.IdMdp=? ");
   $updatemdp->bind_param('i',$idmdp);
   $updatemdp->execute();
   $updatemdp->store_result();
   
}else{
    $idmdp=NULL;
}

   $lblidmdpe = sanitizaCampo($_POST['lblidmdpe'], 'sanitizeint|scapestring|htmlspecialchars',$con);
   $lblidmdpe = htmlspecialchars($lblidmdpe);
   
//$lblurl=$_POST['lblurle'];

$lblfvencimiento = sanitizaCampo($_POST['lblfvencimientoe'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblfvencimiento = htmlspecialchars($lblfvencimiento);

$hidden_lblestadourl = sanitizaCampo($_POST['hidden_lblEditarestadourle'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$hidden_lblestadourl = htmlspecialchars($hidden_lblestadourl);

$lblhvencimiento = sanitizaCampo($_POST['lblhvencimientoe'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblhvencimiento = htmlspecialchars($lblhvencimiento);

$lblcanttransaccion = sanitizaCampo($_POST['lblcanttransaccione'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$lblcanttransaccion = htmlspecialchars($lblcanttransaccion);

$lblarea = sanitizaCampo($_POST['lblareae'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblarea = htmlspecialchars($lblarea);

$fechaconvertvencimiento=  myUrlEncode($lblfvencimiento);
$fechagrabarvencimiento=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertvencimiento));

$horaconvertvencimiento=  myUrlEncode($lblhvencimiento);
$horagrabarvencimiento=  date("H:i", strtotime(str_replace("+"," ",$horaconvertvencimiento)));
$horagrabarcompararvencimiento=date("H:i:s", strtotime(str_replace("+"," ",$horaconvertvencimiento)));

$arrayMDP=consultaMDP($lblidmdpe);

$sqlmdp= $con->prepare("UPDATE dbVENTAS.tblmdp m SET m.EstadoURL=?,m.FechaVencimiento=?,m.HoraVencimiento=?,m.CantidadTransaccion=?,m.Area=? where m.IdMdp=? ");
$sqlmdp->bind_param('sssisi',$hidden_lblestadourl,$fechagrabarvencimiento,$horagrabarvencimiento,$lblcanttransaccion,$lblarea,$lblidmdpe);
$sqlmdp->execute();
$sqlmdp->store_result();

$affectedrowMDP = $sqlmdp->affected_rows;

if($affectedrowMDP > 0){
// $result_exec= $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES ('".$_SERVER['REMOTE_ADDR']."','".$_SESSION['usuariosesion']."','".$fecharegistro ."','".$_SERVER['REQUEST_URI'].'=>IdMdp='.$lblidmdpe."','Modificar','".$_SERVER['HTTP_USER_AGENT']."')");
// $idLogSeg = $con->insert_id;

$Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
$Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$UrlLog = sanitizaCampo($_SERVER['REQUEST_URI'], 'sanitizeurl|scapestring|htmlspecialchars',$con);
if(!empty($Url)){
	$UrlLog = $Url.'=>IdMdp='.$lblidmdpe;
}
$Modificar = 'Modificar';
$Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                
try{
	$result_exec= $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fecharegistro,$UrlLog,$Modificar,$Navegador);
	$result_exec->execute();
	$idLogSeg = $con->insert_id;
	$result_exec->close();
} catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
}

insertLogMDP($idLogSeg, $arrayMDP);
echo 1;
    }

// echo $sqlmdp;

$sqlmdp->close();
