<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

$html=NULL;

if (isset($_POST['lbldc'])) {
    $lbldc = sanitizaCampo($_POST['lbldc'], 'sanitizeint|scapestring|htmlspecialchars', $con);
}else{
    exit;
}


    try{
        $stmt = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) JefeVenta FROM dbUSUARIO.tblusuario u  where u.CC=? AND u.LN='11' AND (u.Categoria ='JE' OR u.Categoria ='COACH' OR u.Categoria ='DEL' OR u.Categoria ='JE/DEL' or u.Categoria='GERENTE TERRITORIAL') LIMIT 50");
        $stmt->bind_param('i', $lbldc);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($Matricula,$JefeVenta);
        if($stmt->num_rows>0){
            while ($stmt->fetch()){
            $html .= '<option value="'.$Matricula.'">'.$Matricula.' - '.$JefeVenta.' </option>';
    	    }            
        }else{
            $html .= '<option value="">No se encontraron resultado</option>';
        }

	    
        $stmt->close();

    } catch(PDOException $e) {
        $html .= '<option value="">No se encontraron resultado</option>';
    }


echo $html;