<?php

date_default_timezone_set('America/Lima');
include('is_logged.php');

function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require_once '../config/db.php';
require_once '../config/conexion.php';

$fechaFiltro = $_POST['fecha'];
//$fechaFiltro = '08/01/2020';

$totalGestion = consultaTotalGestion($fechaFiltro);
$totalCDP = consultaTotalCDP($fechaFiltro);
$Gestores = consultaGestores();
$GestionesXGestor = consultaGestionesxGestor($fechaFiltro);
$GestionesXGestorEstado = consultaGestionesxGestorEstado($fechaFiltro);
$consultaGestionxGestor_v2 = consultaGestionxGestor_v2($fechaFiltro);

$array = [
        'TotalGestion' => $totalGestion,
        'TotalCDP' => $totalCDP,
        'Gestores' => $Gestores,
        'DatosGestor' => $GestionesXGestor,
        'DatosGestorEstado' => $GestionesXGestorEstado,
        'DatosV2' => $consultaGestionxGestor_v2
    ];
    
echo json_encode($array);

$con->close();

function consultaTotalGestion($fechaFiltro){
    
    global $con;
    
    $sql = "SELECT count(*) Cantidad FROM `tblgestioncobranza` WHERE DATE_FORMAT(FechaHoraREG, '%d/%m/%Y') = '".$fechaFiltro."'";
    $resultado = $con->query($sql);
    
    while($data = $resultado->fetch_assoc()){
        $total = $data['Cantidad'];
    };
    
    return $total;
}

function consultaTotalCDP($fechaFiltro){
    
    global $con;
    
    $sql = "SELECT count(*) Cantidad FROM `tblgestioncobranza` WHERE Gestion = 'CDP' AND DATE_FORMAT(FechaHoraREG, '%d/%m/%Y') = '".$fechaFiltro."'";
    $resultado = $con->query($sql);
    
    while($data = $resultado->fetch_assoc()){
        $total = $data['Cantidad'];
    };
    
    return $total;
}

function consultaGestores(){
    
    global $con;
    
    $sql = "SELECT IdUsuario, Matricula, Nombres, Apellidos 
    FROM dbUSUARIO.tblusuario 
    WHERE (IdPerfil = 47 OR IdPerfil = 48) AND Estado = 'Activo' ORDER BY Apellidos";
    $resultado = $con->query($sql);
    
    $gestores = array();
    $i = 0;
    
    while($data = $resultado->fetch_assoc()){
        $gestores[$i] = [
            /*
                'IdUsuario' => $data['IdUsuario'],
                'Matricula' => $data['Matricula'],
                'Nombres' => $data['Nombres'],
                'Apellidos' => $data['Apellidos'],
                */
                $data['Nombres'].' '.$data['Apellidos']
            ];
            
        $i++;
    };
    
    return $gestores;
    
}

function consultaGestionesxGestorEstado($fechaFiltro){
    
    global $con;
    
    $sql = "SELECT IdUsuario, Matricula, Nombres, Apellidos FROM dbUSUARIO.tblusuario WHERE IdPerfil = 47 OR IdPerfil = 48 ORDER BY Apellidos";
    $resultado = $con->query($sql);
    
    $gestores = array();
    $i = 0;
    
    while($data = $resultado->fetch_assoc()){
        $gestores[$i] = [
            
                'IdUsuario' => $data['IdUsuario'],
                'Matricula' => $data['Matricula'],
                'Nombres' => $data['Nombres'],
                'Apellidos' => $data['Apellidos'],
            ];
            
        $i++;
    };
    
    $array = [];
    $estados = ['PAG', 'CDP', 'CPP', 'CNC', 'CSP', 'DMT', 'DMB', 'CNL', 'CNE', 'ADM', 'SEG'];
    
    foreach($estados as $val){
        
        //array_push($array, $val);
        
        $array[$val] = [];

        foreach($gestores as $Gest){
            $Matricula = $Gest['Matricula'];
            $sql = "SELECT count(*) Cantidad FROM tblgestioncobranza WHERE Gestor = '".$Matricula."' AND Gestion = '".$val."' AND DATE_FORMAT(FechaHoraREG, '%d/%m/%Y') = '".$fechaFiltro."'";
            $resultado = $con->query($sql);
            
            while ($cantidad = $resultado->fetch_assoc()){
                array_push($array[$val], intval($cantidad['Cantidad']));
            }
            
        }
    }
    
    return $array;
}

function consultaGestionesxGestor($fechaFiltro){
    global $con;
    
    $sql = "SELECT IdUsuario, Usuario, Matricula, Nombres, Apellidos 
    FROM dbUSUARIO.tblusuario WHERE (IdPerfil = 47 OR IdPerfil = 48) AND Estado = 'Activo' 
    ORDER BY Apellidos";
    $resultado = $con->query($sql);
    
    $array = array();
    $i = 0;
    
    while($data = $resultado->fetch_assoc()){
        $gestores[$i] = [
            
                'IdUsuario' => $data['IdUsuario'],
                'Usuario' => $data['Usuario'],
                'Matricula' => $data['Matricula'],
                'Nombres' => $data['Nombres'],
                'Apellidos' => $data['Apellidos'],
            ];
            
        $i++;
    };
    
    foreach($gestores as $Gest){
        $Usuario = $Gest['Usuario'];
        $sql = "SELECT count(*) Cantidad FROM tblgestioncobranza WHERE UsuarioREG = '".$Usuario."' AND DATE_FORMAT(FechaHoraREG, '%d/%m/%Y') = '".$fechaFiltro."'";
        $resultado = $con->query($sql);
        
        while ($cantidad = $resultado->fetch_assoc()){
            array_push($array, intval($cantidad['Cantidad']));
        }
    }
    
    return $array;
    
    
}

function consultaGestionxGestor_v2($fechaFiltro){
    
    global $con;
    
    $sql = "SELECT IdUsuario, Usuario, Matricula, Nombres, Apellidos, count(Usuario) as 'Cantidad'
    FROM dbUSUARIO.tblusuario U 
    LEFT JOIN dbVENTAS.tblgestioncobranza GC ON U.Usuario = GC.UsuarioREG
    WHERE (IdPerfil = 47 OR IdPerfil = 48) AND Estado = 'Activo' AND DATE_FORMAT(GC.FechaHoraREG, '%d/%m/%Y') = '".$fechaFiltro."'
   	GROUP BY Usuario
    ORDER BY Cantidad DESC";
    
    $resultado = $con->query($sql);
    
    $array = [
            'NombreCompleto' => [],
            'Cantidad' => []
        ];
    
    while($data = $resultado->fetch_assoc()){
        array_push(
            $array['NombreCompleto'],
            $data['Nombres'].' '.$data['Apellidos']
        );
        
        array_push(
            $array['Cantidad'],
            intval($data['Cantidad'])
        );
    }
    
    return $array;
    
}


?>