<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include dirname(__DIR__).'/helper/helper_validacion.php';

$q=NULL;

if (isset($_GET['q'])) {
    $q=sanitizaCampo($_GET['q'],'sanitizestring|scapestring|htmlspecialchars',$con);
}

    try{
        $q = "%{$q}%";
        $stmt = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Gestor FROM dbUSUARIO.tblusuario u  INNER JOIN dbUSUARIO.tblarea a on a.IdArea=u.IdArea
		WHERE (u.Matricula LIKE ? or u.Nombres LIKE ?) AND (u.CC='150' or  u.CC='151' or u.CC='152' or u.CC='153' or u.CC='154' or u.CC='155' or u.CC='120' or u.CC='40' or u.CC='41' or u.CC='200' or u.CC='156' or u.CC='157' or u.CC='158' or u.CC='159' or u.CC='100' or u.CC='140'
OR u.CC='121' OR u.CC='250' OR u.CC='251' OR u.CC='80' OR u.CC='141' OR u.CC='42' OR u.CC='252' OR u.CC='20') and u.Estado='Activo'");
        $stmt->bind_param('ss', $q,$q);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($Matricula,$Gestor);
        $json = [];        
        while ($stmt->fetch()){
        $json[] = array_map("utf8_encode",['id'=>$Matricula, 'text'=>$Matricula." - ".$Gestor]);            
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
echo json_encode($json);    
