<?php
include('is_logged.php');

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}

require_once '../config/db.php';
require_once '../config/conexion.php';

//LOGS TRANSACCCIONALES
include 'log/insertLog.php'; //LOG TRANSAC
include 'log/insertLogCliente.php'; //LOG CLIENTE
include 'log/insertLogTeleventa.php'; //LOG TELEVENTA
include 'log/insertLogFacturacion.php'; //LOG FACTURACION
include 'log/insertLogAgenda.php'; //LOG AGENDA

$ingresokit=0;
$ingresoextras=0;
$ingresototal=0;

$matriculausuario = htmlspecialchars($_POST['gestorbackoffice']);
$categoria=NULL;
$TCTipoVenta='Telecierre';
$tipotvz=htmlspecialchars($_POST['lbltipotvz']);

$matricula=htmlspecialchars($_POST['lblmatriculaz']);
$nombcomercial=htmlspecialchars($_POST['lblnombcomercialz']);
$dc=htmlspecialchars($_POST['lbldcz']);
$jefeventa=htmlspecialchars($_POST['lbljefeventaz']);
$tipoventa=htmlspecialchars($_POST['lbltipoventaz']);
$asignado=htmlspecialchars($_POST['lblasignadoz']);
$segmento=htmlspecialchars($_POST['lblsegmentoz']);
$estadoventa=NULL;
$direccion=NULL;
$distrito=htmlspecialchars($_POST['lbldistritoz']);
$nprospecto=htmlspecialchars($_POST['lblnprospectoz']);
$mesesautorizados=0;
$preciokit=0;
$totalextra=0;
$extraautorizado=NULL;
$formadepago=NULL;
$n590=NULL;
$PAI=NULL;
$leadid=NULL;

$estadotelecierre=NULL;

$fecharegistroagenda = date("Y-m-d H:i:s");
$fecharegistrofacturacion = date("Y-m-d H:i:s");
$fecharegistroventa = date("Y-m-d H:i:s");

$GestionOrigen = 'VENTA';

$nombcliente=htmlspecialchars($_POST['lblnombclientez']);
$telefonouno=htmlspecialchars($_POST['lblmovilz']);
$telefonodos=htmlspecialchars($_POST['lblfijoz']);
$correo=NULL;
$idusuario=htmlspecialchars($_POST['lblidusuarioz']);
$resumenventa=NULL;

$mesteleventa=NULL;

$prioridad= "Alta";
$HabilitadoTV = "SI";

$respuesta = array(); //creamos un array
//SI SE CREA EL PROSPECTO SIN NUMERO 
if($nprospecto=="" || empty($nprospecto)){
    $arrayCliente = consultaClienteI();
    if($telefonodos=="" || empty($telefonodos)){
        $sqlcliente = "INSERT INTO dbVENTAS.tblcliente(IdGeografico, NombApellido, Telefonouno, Correo, Direccion,Segmento) VALUES (?, ?, ?, ?, ?, ?)";
        
        try{
            $stmt = $con->prepare($sqlcliente);
            $stmt->bind_param('ssisss', $distrito,$nombcliente,$telefonouno,$correo,$direccion,$segmento);
            $stmt->execute();
            $idCli = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }  
    }else{
        $sqlcliente= ("INSERT INTO dbVENTAS.tblcliente(IdGeografico, NombApellido, Telefonouno, Telefonodos, Correo, Direccion,Segmento) VALUES (?, ?, ?, ?, ?, ?, ?)");
                
        try{
            $stmt = $con->prepare($sqlcliente);
            $stmt->bind_param('ssiisss', $distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,$segmento);
            $stmt->execute();
            $idCli = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }  
    }
    $arrayAgenda=consultaAgendaI();
    $arrayFacturacion=consultaFacturacionI();
    $arrayTeleventa=consultaTeleventaI();
    
    //INSERTAR A LA TABLA VENTA
    $sqlventa="INSERT INTO dbVENTAS.tblventa(IdUsuario,IdCliente,Matricula,Comercial,CC,JefeVenta,CategoriaVenta,TipoVenta,Segmento,NProspectoCC,
    PrecioKit,TotalExtra,IngresoKIT,IngresoExtras,IngresoTotal,EstadoVenta,ExtraAutorizado,MesesAutorizado,N590,FormaPago,PAI,ResumenVenta,FechaHoraREG,GestorOrigen,
    CCOriginal,PrecioKITOriginal,TotalExtraOriginal,ExtraAutorizadoOriginal,MesesAutorizadoOriginal,FormaPagoOriginal,PAIOriginal,ResumenVentaOriginal,TCTipoVenta,TCGestor,
    EstadoTelecierre,TipoTV,GestorMKT,MesTeleventa,LeadID,Prioridad,HabilitadoTV) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";   
    
    try{
        $stmt = $con->prepare($sqlventa);
        $stmt->bind_param('iisssssssssssssssssssssssssssssssssssssss', $idusuario,$idCli,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,
    $tipoventa,$segmento,$nprospecto,$preciokit,$totalextra,$ingresokit,$ingresoextras,$ingresototal,$estadoventa,$extraautorizado,$mesesautorizados,$n590,
    $formadepago,$PAI,$resumenventa,$fecharegistroventa,$matriculausuario,$dc,$preciokit,$totalextra,$extraautorizado,$mesesautorizados,$formadepago,$PAI,
    $resumenventa,$TCTipoVenta,$matricula,$estadotelecierre,$tipotvz,$asignado,$mesteleventa,$leadid,$prioridad, $HabilitadoTV);
        $stmt->execute();
        $idVen = $con->insert_id;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
    } 
    
    //INSERTAR A LA TABLA AGENDA
    $sqlagenda = "INSERT INTO dbVENTAS.tblagenda(IdVenta, FechaHoraREG, GestionOrigen) VALUES(?, ?, ?)";
    
    try{
        $stmt = $con->prepare($sqlagenda);
        $stmt->bind_param('iss', $idVen,$fecharegistroagenda,$GestionOrigen);
        $stmt->execute();
        $respuesta = $con->insert_id;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
    }    
    
    //INSERTAR A LA TABLA FACTURACION
    $sqlfacturacion = "INSERT INTO dbVENTAS.tblfacturacion(IdVenta, FechaHoraREG, GestionOrigen) VALUES(?, ?, ?)";
    
    try{
        $stmt = $con->prepare($sqlfacturacion);
        $stmt->bind_param('iss', $idVen,$fecharegistrofacturacion,$GestionOrigen);
        $stmt->execute();
        $respuesta = $con->insert_id;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
    }      
    
    
    
    //INSERTAR EN LA TABLA LOG
    $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
    $usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
    $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI'].'=>IdVenta='.$idVen);
    $Acceso='Registrar';
    $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
            
    try {
        $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
        $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistroventa, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
        $stmt->execute();
        $idLogSeg = $con->insert_id;
        $stmt->close();
    } catch (\Exception $e) {
             echo $e->getMessage();
    }    
    
    //INSERTAR AL LOG TRANSACCIONAL CLIENTE, TELEVENTA, AGENDA Y FACTURACION
    insertarLogI($idLogSeg, $arrayCliente);
    insertLogTeleventaI($idLogSeg, $arrayTeleventa);
    insertLogAgendaI($idLogSeg, $arrayAgenda);
    insertLogFacutracionI($idLogSeg, $arrayFacturacion);
    
    if($tipotvz=="RegistroNuevo" || $tipotvz=="VentaDoble"){
       // echo ($sqlventa*2);
        $respuesta=array(
            "ID"=>$idVen,
            "resultado"=>2
        );
    }else{
      // echo $sqlventa;
        $respuesta=array(
            "ID"=>$idVen,
            "resultado"=>1
        );
    }
}else{
    //BUSCA SI EL NUMERO DE PROSPECTO EXISTE
    /*$query = "SELECT 1 FROM dbVENTAS.tblventa v WHERE v.NProspectoCC= ? or v.NProspecto=? limit 1";    
	
	try{       
        $stmt = $con->prepare($query);
        $stmt->bind_param('ii', $nprospecto, $nprospecto);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($result);
        $numrows = $stmt->num_rows;
        $stmt->fetch();
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }    

    if($numrows>0){
        $respuesta=array(
            "ID"=>'vacio',
            "resultado"=>3
        );
    }else{*/

        $arrayCliente = consultaClienteI();

        if($telefonodos=="" || empty($telefonodos)){
            $sqlcliente = "INSERT INTO dbVENTAS.tblcliente(IdGeografico, NombApellido, Telefonouno, Correo, Direccion,Segmento) VALUES (?, ?, ?, ?, ?, ?)";
            
            try{
                $stmt = $con->prepare($sqlcliente);
                $stmt->bind_param('isssss', $distrito,$nombcliente,$telefonouno,$correo,$direccion,$segmento);
                $stmt->execute();
                $idCli = $con->insert_id;
                $stmt->close();
            } catch (\Exception $e) {
                $respuesta = array(
                    'respuesta' => 'error'
                );
            }
        }else{
            $sqlcliente= "INSERT INTO dbVENTAS.tblcliente(IdGeografico, NombApellido, Telefonouno, Telefonodos, Correo, Direccion,Segmento) VALUES (?, ?, ?, ?, ?, ?, ?)";
                    
            try{
                $stmt = $con->prepare($sqlcliente);
                $stmt->bind_param('issssss', $distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,$segmento);
                $stmt->execute();
                $idCli = $con->insert_id;
                $stmt->close();
            } catch (\Exception $e) {
                $respuesta = array(
                    'respuesta' => 'error'
                );
            }
        }

        $arrayAgenda=consultaAgendaI();
        $arrayFacturacion=consultaFacturacionI();
        $arrayTeleventa=consultaTeleventaI();

        $sqlventa="INSERT INTO dbVENTAS.tblventa(IdUsuario,IdCliente,Matricula,Comercial,CC,JefeVenta,CategoriaVenta,TipoVenta,Segmento,NProspectoCC,
        PrecioKit,TotalExtra,IngresoKIT,IngresoExtras,IngresoTotal,EstadoVenta,ExtraAutorizado,MesesAutorizado,N590,FormaPago,PAI,ResumenVenta,FechaHoraREG,GestorOrigen,
        CCOriginal,PrecioKITOriginal,TotalExtraOriginal,ExtraAutorizadoOriginal,MesesAutorizadoOriginal,FormaPagoOriginal,PAIOriginal,ResumenVentaOriginal,TCTipoVenta,TCGestor,
        EstadoTelecierre,TipoTV,GestorMKT,MesTeleventa,LeadID,Prioridad,HabilitadoTV) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";   
        
        try{
            $stmt = $con->prepare($sqlventa);
            $stmt->bind_param('iisssssssssssssssssssssssssssssssssssssss', $idusuario,$idCli,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,
        $tipoventa,$segmento,$nprospecto,$preciokit,$totalextra,$ingresokit,$ingresoextras,$ingresototal,$estadoventa,$extraautorizado,$mesesautorizados,$n590,
        $formadepago,$PAI,$resumenventa,$fecharegistroventa,$matriculausuario,$dc,$preciokit,$totalextra,$extraautorizado,$mesesautorizados,$formadepago,$PAI,
        $resumenventa,$TCTipoVenta,$matricula,$estadotelecierre,$tipotvz,$asignado,$mesteleventa,$leadid,$prioridad, $HabilitadoTV);
            $stmt->execute();
            $idVen = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
        
        
        $sqlagenda = "INSERT INTO dbVENTAS.tblagenda(IdVenta, FechaHoraREG, GestionOrigen) VALUES(?, ?, ?)";
        
        try{
            $stmt = $con->prepare($sqlagenda);
            $stmt->bind_param('iss', $idVen,$fecharegistroagenda,$GestionOrigen);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        } 
        
        $sqlfacturacion = "INSERT INTO dbVENTAS.tblfacturacion(IdVenta, FechaHoraREG, GestionOrigen) VALUES(?, ?, ?)";
        
        try{
            $stmt = $con->prepare($sqlfacturacion);
            $stmt->bind_param('iss', $idVen,$fecharegistrofacturacion,$GestionOrigen);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        } 
        
        
        $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
        $usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
        $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI'].'=>IdVenta='.$idVen);
        $Acceso='Registrar';
        $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
                
        try {
            $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
            $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistroventa, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
            $stmt->execute();
            $idLogSeg = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
                 echo $e->getMessage();
        }
        
        
        $idLogSeg = $con->insert_id;
        insertarLogI($idLogSeg, $arrayCliente);
        insertLogTeleventaI($idLogSeg, $arrayTeleventa);
        insertLogAgendaI($idLogSeg, $arrayAgenda);
        insertLogFacutracionI($idLogSeg, $arrayFacturacion);

        if($tipotvz=="RegistroNuevo" || $tipotvz=="VentaDoble"){
           // echo ($sqlventa*2);
        
            $respuesta=array(
                "ID"=>$idVen,
                "resultado"=>2
            );
        }else{
          // echo $sqlventa;
               $respuesta=array(
                "ID"=>$idVen,
                "resultado"=>1
            );
        }

    /*}*/

}

echo json_encode($respuesta);

$buscarnumero=$telefonouno;
$contador=0;
    
$query="SELECT * FROM (SELECT v.IdVenta ID,v.FechaHoraREG,v.Matricula,v.Comercial,v.CC,v.NProspecto,v.TipoVenta,c.Telefonouno,c.Telefonodos,'Visita' OrigenVista FROM tblventa v 
INNER JOIN tblcliente c on c.IdCliente=v.IdCliente
WHERE (v.TipoVenta='RE' and v.CCOriginal!='511' and v.CCOriginal!='512')
and (v.EstadoVenta='PendienteData' or v.EstadoVenta='PendienteAgenda' or v.EstadoVenta='AgendadaTEC' or v.EstadoVenta='AgendadaDEL' or v.EstadoVenta='NoVendida' or v.EstadoVenta='Cancelada' or v.EstadoVenta='Inviable' or v.EstadoVenta='Ilocalizable' or v.EstadoVenta='VAsignada') 
and DATEDIFF(curdate(), v.FechaHoraREG) <=105 and
(c.Telefonouno=? or c.Telefonodos=?)
UNION
SELECT v.IdVenta ID,v.FechaHoraREG,v.Matricula,v.Comercial,v.CC,v.NProspecto,v.TipoVenta,c.Telefonouno,c.Telefonodos,'Televenta' FROM tblventa v 
INNER JOIN tblcliente c on c.IdCliente=v.IdCliente
WHERE v.TipoVenta='RE' and v.TCTipoVenta='TeleVenta'
and (v.EstadoVenta='' or v.EstadoVenta='PendienteData' or v.EstadoVenta='PendienteAgenda' or v.EstadoVenta='AgendadaTEC' or v.EstadoVenta='AgendadaDEL' or v.EstadoVenta='NoVendida' or v.EstadoVenta='Cancelada' or v.EstadoVenta='Inviable' or v.EstadoVenta='Ilocalizable' or v.EstadoVenta='VAsignada') 
and DATEDIFF(curdate(), v.FechaHoraREG) <=105 and
(c.Telefonouno=? or c.Telefonodos=?)
UNION
SELECT v.IdVenta,v.FechaHoraREG,v.Matricula,v.Comercial,v.CC,v.NProspecto,v.TipoVenta,c.Telefonouno,c.Telefonodos,'Venta' FROM tblventa v 
INNER JOIN tblcliente c on c.IdCliente=v.IdCliente
WHERE (v.TipoVenta='RP' OR v.TipoVenta='RPPR' OR v.TipoVenta='RPPA')   
and (v.EstadoVenta='PendienteData' or v.EstadoVenta='PendienteAgenda' or v.EstadoVenta='AgendadaTEC' or v.EstadoVenta='AgendadaDEL' or v.EstadoVenta='NoVendida' or v.EstadoVenta='Cancelada' or v.EstadoVenta='Inviable' or v.EstadoVenta='Ilocalizable' or v.EstadoVenta='VAsignada') 
and DATEDIFF(curdate(), v.FechaHoraREG) <=105 and
(c.Telefonouno=? or c.Telefonodos=?)
UNION
SELECT p.IdProspectoRP,p.FechaHoraREG,p.Matricula,p.Comercial,p.CC,p.NProspecto,p.TipoVenta,c1.Telefonouno,c1.Telefonodos,'ProspectoRP' FROM tblprospectorp p 
INNER JOIN tblcliente c1 on c1.IdCliente=p.IdCliente
WHERE (p.TipoVenta='RP' OR p.TipoVenta='RPPR' OR p.TipoVenta='RPPA') 
and p.EstadoProspecto='ProspectoRP' 
and DATEDIFF(curdate(), p.FechaHoraREG) <=105 and
(c1.Telefonouno=? or c1.Telefonodos=?)) t
ORDER BY t.FechaHoraREG DESC";

	try{       
        $stmt = $con->prepare($query);
        $stmt->bind_param('iiiiiiii', $buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($ID, $FechaHoraREG, $Matricula, $Comercial, $CC, $NProspecto, $TipoVenta, $Telefonouno, $Telefonodos, $OrigenVista);
        $stmt->fetch();
        

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

$numrows=$stmt->num_rows;

if($numrows<=1){
    
}else{ 
    
    $queryUsuario = "SELECT u.Matricula,CONCAT(u.Nombres,' ', u.Apellidos) Usuario,u.CC,u.Manager,um.Correo as CorreoManager FROM dbUSUARIO.tblusuario u INNER JOIN dbUSUARIO.tblusuario um on um.CC=u.CC and um.Categoria='DEL' and um.Estado='Activo' WHERE u.Matricula=? LIMIT 1";
	
	try{       
        $stmt = $con->prepare($queryUsuario);
        $stmt->bind_param('s', $matriculausuario);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($Matricula,$Usuario,$CC,$Manager,$CorreoManager);
        $stmt->fetch();
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }    
    
    $USU=$Usuario;
    $USUCC=$CC;
    $correo_administrativo5=$CorreoManager;
    
    $correo_administrativo="lorena.pardo@verisure.pe";
    $correo_administrativo1="josel.rodriguez@securitasdirect.es";
    $correo_administrativo2="backoffice@verisure.pe";
    $correo_administrativo3="diego.delabarra@verisure.pe";
    
    //COPIA CORREO SUPERVISORES DE TELEVENTA
    
    $correo_administrativo4="diego.delabarra@verisure.pe";
    $correo_administrativo6="alessandra.reupo@verisure.pe";
    $correo_administrativo8="alejandro.delsante@verisure.pe";


    if($USUCC == 150 || $USUCC == 100 ||  $USUCC == 152 || $USUCC == 157 || $USUCC == 159  || $USUCC == 251 || $USUCC == 252){
            $correo_administrativo7="renzobranchi.branez@verisure.pe";
    } else if ($USUCC == 151 || $USUCC == 200  || $USUCC == 154 || $USUCC == 156 || $USUCC == 120 || $USUCC == 121 || $USUCC == 140 || $USUCC == 141 || $USUCC == 20){
            $correo_administrativo7="joseenrique.nanquen@verisure.pe";
    } else if ($USUCC == 40 || $USUCC == 41 || $USUCC == 153 || $USUCC == 155  || $USUCC == 158 || $USUCC == 250 || $USUCC == 80){
            $correo_administrativo7="monicamaria.sanchez@verisure.pe";
    }else{
        $correo_administrativo5="";
        $correo_administrativo7="";
    }


    //CORREO PRUEBA
    $correo_prueba="joseenrique.nanquen@verisure.pe";
    
    //PARA PRUEBA
    //$para = $correo_prueba;
    //PARA PRUDCCION
    $para = "" .$correo_administrativo1.", ".$correo_administrativo2.", ".$correo_administrativo3.", ".$correo_administrativo4.", ".$correo_administrativo5.", ".$correo_administrativo6.", ".$correo_administrativo7.", ".$correo_administrativo8.", ".$correo_prueba." " ;

    $titulo = "NOTIFICACION DE DUPLICIDAD";


$mensaje ='
<html>

<head>

<style>
    @font-face{
        font-family:Helvetica;
    	panose-1:2 11 6 4 2 2 2 2 2 4;
    	mso-font-charset:0;
    	mso-generic-font-family:swiss;
    	mso-font-pitch:variable;
    	mso-font-signature:-536859905 -1073711037 9 0 511 0;
    }

    p.MsoNormal, li.MsoNormal, div.MsoNormal{
        mso-style-unhide:no;
    	mso-style-qformat:yes;
            mso-style-parent:"";
    	margin:0cm;
    	margin-bottom:.0001pt;
    	mso-pagination:widow-orphan;
    	font-size:12.0pt;
    	font-family:"Times New Roman","serif";
    	mso-fareast-font-family:Calibri;
    	mso-fareast-theme-font:minor-latin;
    }
    h3{
        mso-style-priority:9;
    	mso-style-unhide:no;
    	mso-style-qformat:yes;
    	mso-style-link:"Título 3 Car";
    	mso-margin-top-alt:auto;
    	margin-right:0cm;
    	mso-margin-bottom-alt:auto;
    	margin-left:0cm;
    	mso-pagination:widow-orphan;
    	mso-outline-level:3;
    	font-size:13.5pt;
    	font-family:"Times New Roman","serif";
    	mso-fareast-font-family:Calibri;
    	mso-fareast-theme-font:minor-latin;
    }
    a:link, span.MsoHyperlink{
        mso-style-noshow:yes;
    	mso-style-priority:99;
    	color:blue;
    	text-decoration:underline;
    	text-underline:single;
    }
    a:visited, span.MsoHyperlinkFollowed{
        mso-style-noshow:yes;
    	mso-style-priority:99;
    	color:purple;
    	text-decoration:underline;
    	text-underline:single;
    }
    span.Ttulo3Car{
        mso-style-name:"Título 3 Car";
    	mso-style-noshow:yes;
    	mso-style-priority:9;
    	mso-style-unhide:no;
    	mso-style-locked:yes;
    	mso-style-link:"Título 3";
    	mso-ansi-font-size:12.0pt;
    	mso-bidi-font-size:12.0pt;
    	font-family:"Calibri Light","sans-serif";
    	mso-ascii-font-family:"Calibri Light";
    	mso-ascii-theme-font:major-latin;
    	mso-fareast-font-family:"Helvetica";
    	mso-fareast-theme-font:major-fareast;
    	mso-hansi-font-family:"Calibri Light";
    	mso-hansi-theme-font:major-latin;
    	mso-bidi-font-family:"Times New Roman";
    	mso-bidi-theme-font:major-bidi;
    	color:#1F4D78;
    	mso-themecolor:accent1;
    	mso-themeshade:127;
    }
    .MsoChpDefault{
        mso-style-type:export-only;
    	mso-default-props:yes;
    	font-size:10.0pt;
    	mso-ansi-font-size:10.0pt;
    	mso-bidi-font-size:10.0pt;
    }
    @page WordSection1{
        size:612.0pt 792.0pt;
    	margin:70.85pt 3.0cm 70.85pt 3.0cm;
    	mso-header-margin:36.0pt;
    	mso-footer-margin:36.0pt;
    	mso-paper-source:0;
    }
    div.WordSection1{
        page:WordSection1;
    }

</style>
</head>

<body bgcolor="#F2F2F2" lang=ES-PE link=blue vlink=purple style="tab-interval:35.4pt">
    <div class=WordSection1>
        <p class=MsoNormal><o:p>&nbsp;</o:p></p>
        <div align=center>

            <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width="100%"
             style="width:100.0%;background:#F2F2F2;border-collapse:collapse;mso-yfti-tbllook:
             1184;mso-padding-alt:0cm 0cm 0cm 0cm">
             <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
              <td width="100%" valign=top style="width:100.0%;padding:15.0pt 15.0pt 15.0pt 15.0pt">
              <div align=center>
              <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=600
               style="width:650.0pt;border-collapse:collapse;mso-yfti-tbllook:1184;
               mso-padding-alt:0cm 0cm 0cm 0cm">
               <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes">
                <td valign=top style="padding:0cm 0cm 0cm 0cm">
                <div align=center>
                <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=600
                 style="width:650.0pt;background:white;border-collapse:collapse;mso-yfti-tbllook:
                 1184;mso-padding-alt:0cm 0cm 0cm 0cm">
                 <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
                  <td valign=top style="border-top:solid #D8D8D8 4.5pt;border-left:none;
                  border-bottom:none;border-right:none;padding:6.75pt 0cm 0cm 0cm">
                  <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
                   width="100%" style="width:100.0%;border-collapse:collapse;mso-yfti-tbllook:
                   1184;mso-padding-alt:0cm 0cm 0cm 0cm">
                   <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
                    <td valign=top style="padding:6.75pt 6.75pt 6.75pt 6.75pt">
                    <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
                     align=center width="100%" style="width:100.0%;border-collapse:collapse;
                     mso-yfti-tbllook:1184;mso-table-lspace:2.25pt;mso-table-rspace:2.25pt;
                     mso-table-anchor-vertical:paragraph;mso-table-anchor-horizontal:column;
                     mso-table-left:left;mso-padding-alt:0cm 0cm 0cm 0cm">
                     <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:
                      yes">
                      <td valign=top style="padding:0cm 6.75pt 0cm 6.75pt">
                      <p class=MsoNormal><span><img
                      width=118 height=73 id="_x0000_i1025"
                      src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png"
                      alt="Logo Verisure Peru"><o:p></o:p></span></p>
                      </td>
                     </tr>
                    </table>
                    </td>
                   </tr>
                  </table>
                  </td>
                 </tr>
                </table>
                </div>
                </td>
               </tr>
               <tr style="mso-yfti-irow:1;mso-yfti-lastrow:yes">
                <td valign=top style="padding:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
                -webkit-text-size-adjust: 100%">
                <div align=center>
                <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=600
                 style="width:650.0pt;background:white;border-collapse:collapse;mso-yfti-tbllook:
                 1184;mso-padding-alt:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
                 -webkit-text-size-adjust: 100%;min-width: 100%" id=templateHeader>
                 <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
                  <td valign=top style="padding:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
                  -webkit-text-size-adjust: 100%;min-width: 100%">
                  <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
                   width="100%" style="width:100.0%;border-collapse:collapse;mso-yfti-tbllook:
                   1184;mso-padding-alt:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
                   -webkit-text-size-adjust: 100%;min-width: 100%">
                   <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
                    <td valign=top style="padding:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
                    -webkit-text-size-adjust: 100%">
                    <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
                     width="100%" style="width:100.0%;background:#F2F2F2;border-collapse:
                     collapse;mso-yfti-tbllook:1184;mso-padding-alt:0cm 0cm 0cm 0cm;
                     -ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%"
                     id=bodyTable>
                     <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:
                      yes">
                      <td valign=top style="padding:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
                      -webkit-text-size-adjust: 100%">
                      <div align=center>
                      <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
                       width=600 style="width:650.0pt;background:#DC0000;border-collapse:
                       collapse;mso-yfti-tbllook:1184;mso-padding-alt:0cm 0cm 0cm 0cm;
                       -ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%"
                       id=emailContainer>
                       <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:
                        yes">
                        <td valign=top style="padding:3.0pt 3.0pt 3.0pt 3.0pt;-ms-text-size-adjust: 100%;
                        -webkit-text-size-adjust: 100%">
                        <h3 align=center style="text-align:center"><span style="font-family:
                        Helvetica,sans-serif;
                        color:white">NOTIFICACI&Oacute;N VERISMART<o:p></o:p></span></h3>
                        </td>
                       </tr>
                      </table>
                      </div>
                      </td>
                     </tr>
                    </table>
                    </td>
                   </tr>
                  </table>
                  <p class=MsoNormal><span style="
                  display:none;mso-hide:all"><o:p>&nbsp;</o:p></span></p>
                  <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
                   width="100%" style="width:100.0%;border-collapse:collapse;mso-yfti-tbllook:
                   1184;mso-padding-alt:0cm 0cm 0cm 0cm;min-width: 100%;-ms-text-size-adjust: 100%;
                   -webkit-text-size-adjust: 100%">
                   <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
                    <td valign=top style="padding:6.75pt 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
                    -webkit-text-size-adjust: 100%">
                    <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
                     align=left width="100%" style="width:100.0%;border-collapse:collapse;
                     mso-yfti-tbllook:1184;margin-left:-2.25pt;margin-right:-2.25pt;
                     mso-table-anchor-vertical:paragraph;mso-table-anchor-horizontal:column;
                     mso-table-left:left;mso-padding-alt:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
                     -webkit-text-size-adjust: 100%">
                     <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:
                      yes">
                      <td width=600 valign=top style="width:650.0pt;padding:0cm 0cm 0cm 0cm;
                      -ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
                      <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
                       align=left width="100%" style="width:100.0%;border-collapse:collapse;
                       mso-yfti-tbllook:1184;mso-table-lspace:2.25pt;mso-table-rspace:2.25pt;
                       mso-table-anchor-vertical:paragraph;mso-table-anchor-horizontal:
                       column;mso-table-left:left;mso-padding-alt:0cm 0cm 0cm 0cm;
                       -ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
                       <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:
                        yes">
                        <td valign=top style="padding:0cm 13.5pt 6.75pt 13.5pt;max-width: 100%;
                        min-width: 100%;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
                        <p class=MsoNormal style="mso-margin-top-alt:auto;mso-margin-bottom-alt:
                        auto;line-height:150%">
                         <strong>
                            <span style="font-size:11.0pt;
                        line-height:150%;font-family:Helvetica,sans-serif;color:#606060">Estimado(s) Sr(es) </span>
                        </strong>
                     
                            <br>
                            
                      
                             <span style="font-size:9.0pt;
                        line-height:150%;font-family:Helvetica,sans-serif;color:#606060">Se detalla la informacion sobre los PROSPECTOS/VISITAS asociadas al n&#250;mero <strong>'.$buscarnumero.'</strong> ingresado por:</span>
                       <br>
                       <br>
                       <table cellspacing="0" border="1" align="center" bordercolor="#ddd" style="width: 45%; text-align: left; font-size: 10pt;">
                                                                 <tr>
                                        <th style="width: 10%;font-size:9.0pt;line-height:150%;font-family:
                        Helvetica,sans-serif;color:#606060; text-align: center;">MATRICULA</th>
                                            <th style="width: 30%;font-size:9.0pt;line-height:150%;font-family:
                        Helvetica,sans-serif;color:#606060; text-align: center;">COMERCIAL</th>
                                           <th style="width: 5%;font-size:9.0pt;line-height:150%;font-family:
                        Helvetica,sans-serif;color:#606060; text-align: center;">CC</th>
                                        </tr>
                                        <tr>
                                        
                          <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;
                        color:#606060">'.$matriculausuario.'</td>
                           <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;
                        color:#606060">'.$USU.'</td>
                          <td  style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;
                        color:#606060">'.$USUCC.'</td>
                        
                        </tr>
                                        
                          </table>
                       
                      <br>
                
                                <strong><span style="font-size:9.0pt;line-height:150%;font-family:
                        Helvetica,sans-serif;color:#606060">Total de registros ('.$numrows.'):</span></strong>
                      <br>
                     <br>
                       
                      <table cellspacing="0" border="1" align="center" bordercolor="#ddd" style="width: 95%; text-align: left; font-size: 10pt;">
                                                                 <tr>
                                       <th style="width: 5%;font-size:9.0pt;line-height:150%;font-family:
                        Helvetica,sans-serif;color:#606060; text-align: center;">N&#176; ID</th>
                                            <th style="width: 9.5%;font-size:9.0pt;line-height:150%;font-family:
                        Helvetica,sans-serif;color:#606060; text-align: center;">N&#176; PROSPECTO</th>
                                           <th style="width: 14%;font-size:9.0pt;line-height:150%;font-family:
                        Helvetica,sans-serif;color:#606060; text-align: center;">FECHA REGISTRO</th>
                                            <th style="width: 9.5%;font-size:9.0pt;line-height:150%;font-family:
                        Helvetica,sans-serif;color:#606060; text-align: center;">MATRICULA</th>
                                            <th style="width: 18.5%;font-size:9.0pt;line-height:150%;font-family:
                        Helvetica,sans-serif;color:#606060; text-align: center;">COMERCIAL</th>
                        
                                                        <th style="width: 5%;font-size:9.0pt;line-height:150%;font-family:
                        Helvetica,sans-serif;color:#606060; text-align: center;">CC</th>
                                           <th style="width: 5%;font-size:9.0pt;line-height:150%;font-family:
                        Helvetica,sans-serif;color:#606060; text-align: center;">TIPO VENTA</th>
                                            <th style="width:9.5%;font-size:9.0pt;line-height:150%;font-family:
                        Helvetica,sans-serif;color:#606060; text-align: center;">TELEFONO UNO</th>
                                            <th style="width: 9.5%;font-size:9.0pt;line-height:150%;font-family:
                        Helvetica,sans-serif;color:#606060; text-align: center;">TELEFONO DOS</th>
                                                        <th style="width:9.5%;font-size:9.0pt;line-height:150%;font-family:
                        Helvetica,sans-serif;color:#606060; text-align: center;">ORIGEN VISTA</th>
                                    <th style="width:5%;font-size:8.0pt;line-height:150%;font-family:
                        Helvetica,sans-serif;color:#606060; text-align: center;"></th>
                                        </tr>
                                       ';
                           
                  
        while ($row = $stmt->fetch()) {
            
            $contador++;
            
            if($contador==1){
                $Nu='<span style="font-family:Helvetica,sans-serif;background-color: #d9534f;display: inline;
                    padding: .2em .6em .3em;
                    font-size: 95%;
                    font-weight: 700;
                    line-height: 1;
                    color: #fff;
                    text-align: center;
                    white-space: nowrap;
                    vertical-align: baseline;
                    border-radius: .25em;">Nuevo</span>';
            }else{
                $Nu='-';
            }
            
            $mensaje.='
            <tr>
                <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$ID.'</td>
                <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$NProspecto.'</td>
                <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$FechaHoraREG.'</td>
                <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$Matricula.'</td>
                <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$Comercial.'</td>
                <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$CC.'</td>
                <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$TipoVenta.'</td>
                <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$Telefonouno.'</td>
                <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$Telefonodos.'</td>
                <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$OrigenVista.'</td>
                <td style="text-align: center;font-size:8.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$Nu.'</td>
            </tr>';
        }
        
$mensaje.='
        </table>
 
        <br> 
            <span style="font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif; color:#606060">Por seguridad, Verisure Per&#250; te informa:</span>
        <br>
        <div style="text-align: justify">
            <span style="font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif; color:#606060">
                Este correo electr&#243;nico contiene informaci&#243;n legal confidencial y privilegiada. Si Usted no es el destinatario a quien se desea enviar este mensaje, tendr&#225; prohibido darlo a conocer a persona alguna, as&#237; como a reproducirlo o copiarlo. Si recibe este mensaje por error, favor de notificarlo al remitente de inmediato y desecharlo de su sistema..
            </span>
        </div>
        <br>         
        <br>
                <strong>
                <span style="font-size:10.5pt;line-height:150%;font-family:Trebuchet MS,Helvetica,sans-serif;
                color:#ff0033">Verisure Per&uacute; SAC.</span></strong><br>
                <span style="font-size:8.5pt;line-height:150%;font-family:Trebuchet MS,Helvetica,sans-serif;
                      color:#606060">Av. Primavera 1050,Of.401 Santiago de Surco<br>
                15037,Lima, Per&uacute;</span></p>
                </td>
               </tr>
              </table>
              </td>
             </tr>
            </table>
            </td>
           </tr>
          </table>
          </td>
         </tr>
        </table>
        </div>
        </td>
        </tr>
        </table>
        </div>
        </td>
        </tr>
        </table>
    </div>

    <p class=MsoNormal><span ><o:p>&nbsp;</o:p></span></p>

    </div>

</body>

</html>';

    //para el envío en formato HTML 
    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/html; charset=utf-8\r\n";

    //dirección del remitente 
    $headers .= "From: VERISMART - Verisure Perú <notificacion.verismart@verismart.com.pe>\r\n";

    //dirección de respuesta, si queremos que sea distinta que la del remitente 
    $headers .= "Reply-To: notificacion.verismart@verisure.pe\r\n";

    //ruta del mensaje desde origen a destino 
    $headers .= "Return-path: notificacion.verismart@verismart.com.pe\r\n";

    //direcciones que recibián copia 
    $headers .= "Cc: notificacion.verismart@verisure.pe\r\n";
    
    

//direcciones que recibirán copia oculta 
//$headers .= "Bcc: joecnan14@gmail.com\r\n"; 

mail($para, $titulo, $mensaje, $headers);

}

// $resultado->close();

// mysqli_close($con);

//mysqli_close($consec);

