<?php

    require_once '../config/db.php';
    require_once '../config/conexion.php';
    require_once '../helper/helper_validacion.php';

    date_default_timezone_set('America/Lima');
    
    $fileContent = $_FILES['inputRemarketing'];
    $fileContent = file_get_contents($fileContent['tmp_name']);
    
    $fileContent = explode("\n", $fileContent);
    $fileContent = array_filter($fileContent);
    
    foreach ($fileContent as $fila){
        $leads[] = explode(",", $fila);
    }
    

    
    if(count($leads) > 1){
        $i =0;
        foreach ($leads as $data){
            if($i > 0){
                if(true){
                    $respuesta = actualizarDatos($data);
                    $resultadoFinal[] = $respuesta;
                } else {
                    $respuesta = array(
                        'respuesta' => 'error',
                    );
                    die($respuesta);
                }
            }
            $i++; 
        }       
    } else {
        $respuesta = array(
            respuesta => 'Sindatos'
        );
        
        die($respuesta);
    }
    
    echo json_encode(array('respuesta'=>'procesado','totalprocesado'=>count($resultadoFinal)),JSON_UNESCAPED_UNICODE);
    
    // echo json_encode($resultadoFinal, JSON_UNESCAPED_UNICODE);
    
    function actualizarDatos($data){

     
        
        global $con;

        $IdVenta = sanitizaCampo($data[0], 'sanitizeint|scapestring|htmlspecialchars',$con);
        $TCTipoVenta = sanitizaCampo($data[1], 'sanitizestring|scapestring|htmlspecialchars',$con);
        $Visibilidad = sanitizaCampo($data[2], 'sanitizestring|scapestring|htmlspecialchars',$con);
        
  

        if($Visibilidad=='' || empty($Visibilidad)){
            $Visibilidad=NULL;
        }

        if($TCTipoVenta=='' || empty($TCTipoVenta)){
            $TCTipoVenta='Telecierre';
        }
        
        

        if($TCTipoVenta=='Telecierre2'){
            $FechaHoraTransferenciaTelecierredos = date("Y-m-d H:i:s");

        try{
            $stmt = $con->prepare("UPDATE tblventa SET TCTipoVenta=?,Visibilidad=?,FechaHoraTransferenciaTelecierredos=? WHERE IdVenta = ?");
            $stmt->bind_param('sssi', $TCTipoVenta, $Visibilidad,$FechaHoraTransferenciaTelecierredos, $IdVenta);
            $stmt->execute();
            
            $rows = $stmt->affected_rows;
            
            if($rows > 0){
                $respuesta = array(
                        'respuesta' => 'exito',
                        'id' => $IdVenta,
                        'data' => $data
                    );
                    
            } else {
                $respuesta = array(
                    'respuesta' => 'sincambios',
                    'id' => $IdVenta,
                    'error' => $con->error,
                );
            }
            $stmt->close();
            
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error',
                'mensaje' => $e,
                'data' => $data
            );
        }
        
        }else if($TCTipoVenta=='TCRemarketing'){
            $FechaHoraTransferenciaTCRemarketing = date("Y-m-d H:i:s");
            
        try{
            $stmt = $con->prepare("UPDATE tblventa SET TCTipoVenta=?,Visibilidad=?,FechaHoraTransferenciaTCRemarketing=? WHERE IdVenta = ?");
            $stmt->bind_param('sssi', $TCTipoVenta, $Visibilidad,$FechaHoraTransferenciaTCRemarketing, $IdVenta);
            $stmt->execute();
            
            $rows = $stmt->affected_rows;
            
            if($rows > 0){
                $respuesta = array(
                        'respuesta' => 'exito',
                        'id' => $IdVenta,
                        'data' => $data
                    );
                    
            } else {
                $respuesta = array(
                    'respuesta' => 'sincambios',
                    'id' => $IdVenta,
                    'error' => $con->error,
                );
            }
            $stmt->close();
            
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error',
                'mensaje' => $e,
                'data' => $data
            );
        }        
            
        }else{
            
            $respuesta = array(
                'respuesta' => 'exito',
                'id' => $IdVenta,
                'data' => $data
            );

        }  



        
        return $respuesta;
        
    }
    
    
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
        
    }
    
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }