<?php

    require_once '../config/db.php';
    require_once '../config/conexion.php';
    //LOG
    require_once 'log/insertLog.php';
    //LIBRERIA DE EXPORTACION
    
    require_once 'libreria/Spout/Autoloader/autoload.php';
    
    use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
    use Box\Spout\Common\Entity\Row;
    
    $fileName = 'CotizacionDetalle.csv';
    
    $writer = WriterEntityFactory::createCSVWriter();
    
    $writer->openToBrowser($fileName);
        
    $head = array(
        'IdCotDet',
        'IdCotizacion',
        'Iditem',
        'Item',
        'Precio',
        'CuotaMes',
        'Unidades',
        'PrecioCotDetalle',
        'TipoPrecio',
        'DsctoCta',
        'Subtotal',
        'Subtotal_cuotaMes',
        'DetReq',
        'ManoObra',
        'SuministroCable',
        'PrecioTotalxCamara',
        'PrecioTotalCableado'
    );
    
    $rowFromValues = WriterEntityFactory::createRowFromArray($head);
    $writer->addRow($rowFromValues);
    
    date_default_timezone_set('America/Lima');
    
    $fecharegistro=date("Y-m-d H:i:s");
    
    //$result_exec = StmtInsertarLogSeguridad_General('Exportar', $fecharegistro, '', '');
    
    $query="
        SELECT 
        IFNULL(ctz.IdCotDet, '') IdCotDet, 
        IFNULL(ctz.IdCotizacion, '') IdCotizacion, 
        IFNULL(ctz.Iditem, '') Iditem, 
        IFNULL(i.Item, '') Item, 
        IFNULL(i.Precio, '') Precio, 
        IFNULL(i.CuotaMes, '') CuotaMes, 
        IFNULL(ctz.Unidades, '') Unidades, 
        IFNULL(ctz.PrecioCotDetalle, '') PrecioCotDetalle, 
        IFNULL(ctz.TipoPrecio, '') TipoPrecio, 
        IFNULL(ctz.DsctoCta, '') DsctoCta, 
        IFNULL(ctz.Subtotal, '') Subtotal, 
        IFNULL(ctz.Subtotal_cuotaMes, '') Subtotal_cuotaMes,
        IFNULL(ctz.DetReq, '') DetReq
        FROM tblcotizaciondetalle ctz
        INNER JOIN tblitem i ON ctz.Iditem = i.IdItem
    ";
    
    $result = $con->query($query);
    
    while ($datos = $result->fetch_assoc()){
        /*
        if(!empty($Venta['DetReq'])){
            $DetalleReq = json_decode($Venta['DetReq']);
            for($i=0; $i<count($DetalleReq); $i++){
            $DetalleCamara=$DetalleReq->{'DetalleCamara'};
             $Venta += ['Manodeobra' => $DetalleCamara];
            }
            
            
        }
        */
        
        //$arreglo[] = $datos;
        
        $IdCotDet = $datos['IdCotDet'];
        $IdCotizacion = $datos['IdCotizacion'];
        $Iditem = $datos['Iditem'];
        $Item =  $datos['Item'];
        $Precio= $datos['Precio'];
        $CuotaMes= $datos['CuotaMes'];
        $Unidades= $datos['Unidades'];
        $PrecioCotDetalle= $datos['PrecioCotDetalle'];
        $TipoPrecio= $datos['TipoPrecio'];
        $DsctoCta= $datos['DsctoCta'];
        $Subtotal= $datos['Subtotal'];
        $Subtotal_cuotaMes= $datos['Subtotal_cuotaMes'];
        $DetReqJson = $datos['DetReq'];
        $Manodeobra='';
        $SuministroCable='';
        $PrecioTotalxCamara='';
        $PrecioTotalCableado=0;
        $DetReq = json_decode($datos['DetReq'], true);
        
        $DetalleCamara = $DetReq['DetalleCamara'];
        
        $PrecioTotalxCamara=$DetReq['PrecioCotDetalle'];
        $PrecioTotalCableado+=$PrecioTotalxCamara;
        
        for($i=0; $i<count($DetalleCamara); $i++){
            if($DetalleCamara[$i][0] == 'Mano de obra'){
                $Manodeobra = $DetalleCamara[$i][1];
                $PrecioTotalCableado+=$Manodeobra;
            }
            if($DetalleCamara[$i][0] == 'Suministro de cable'){
                $SuministroCable = $DetalleCamara[$i][1];
                $PrecioTotalCableado+=$SuministroCable;
            }
        }
        
        
        $arreglo[] = array(
                'IdCotDet' => $IdCotDet,
                'IdCotizacion' => $IdCotizacion,
                'Iditem' => $Iditem,
                'Item' => $Item,
                'Precio' => $Precio,
                'CuotaMes' => $CuotaMes,
                'Unidades' => $Unidades,
                'PrecioCotDetalle' => $PrecioCotDetalle,
                'TipoPrecio' => $TipoPrecio,
                'DsctoCta'=>$DsctoCta,
                'Subtotal'=>$Subtotal,
                'Subtotal_cuotaMes'=>$Subtotal_cuotaMes,
                'DetReq' => $DetReqJson,
                'ManoObra' => $Manodeobra,
                'SuministroCable' => $SuministroCable,
                'PrecioTotalxCamara'=>$PrecioTotalxCamara,
                'PrecioTotalCableado'=>$PrecioTotalCableado
            );
    }
    
    for($i=0; $i<count($arreglo); $i++){
        $rowData = WriterEntityFactory::createRowFromArray($arreglo[$i]);
        $writer->addRow($rowData);
    }
    
    $result->close();
    
    $writer->close();
    
    
    $con->close();

?>

