<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';

date_default_timezone_set('America/Lima');

//LOG
$fecharegistro=date("Y-m-d H:i:s");
        $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
        $usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
        $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI']);
        $Acceso='Exportar';
        $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
        
        try {
                
          $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
          $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
          $stmt->execute();
          $stmt->close();
          
        } catch (\Exception $e) {
          echo $e->getMessage();
        }
//LIBRERIA DE EXPORTACION
require_once 'libreria/Spout/Autoloader/autoload.php';

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

$fileName = 'leads.csv';

$writer = WriterEntityFactory::createCSVWriter();

$writer->openToBrowser($fileName);

$head = array(
    'IDLead',
    'Matricula',
    'NombreGestor',
    'FechaHoraReg',
    'FechaHoraCotizacion',
    'Gestion',
    'ResultadoGestion',
    'Campaña',
    'Nombres',
    'Apellidos',
    'Telefono',
    'Telefono2',
    'Origen',
    'LeadID',
    'Departamento',
    'Provincia',
    'Distrito',
    'Observaciones',
    'Segmento',
    'NLocales',
    'GGCC',
    'NDocumento',
    'Vueltas',
    'FechaUltimaGestion',
    'Remarketing',
    'MatriculaRMKT',
    'RMKTNombreGestor',
    'FechaHoraRemarketing',
    'Gestionable',
    'SubTipificacion',
    'ultimoGestor',
    'ultimoNombreGestor',
    'Zonas',
    'Canal',
    'IdVenta',
    'TipoVenta',
    'GestorTV',
    'EstadoVisita',
    'FechaCreacionVisita',
    'FechaVisita',
    'NProspecto',
     'visePiso',
     'rubroNeg',
     'puertaCalle',
     'nobleParedes',
     'nobleTecho',
     'metros',
     'motivoInteres',
     'conSistema',
     'empresaSistema',
     'bancarizado'      
);
$rowFromValues = WriterEntityFactory::createRowFromArray($head);
$writer->addRow($rowFromValues);


$query = "SELECT 
                l.IdLeadCC, 
                u.Matricula,
                Concat(u.Nombres,' ',u.Apellidos) as NombreGestor,
                l.FechaHoraReg,
                l.FechaHoraCotizacion,
                l.Gestion,
                l.ResultadoGestion,
                l.Campaña,
                l.Nombres,
                l.Apellidos,
                l.Telefono,
                l.Telefono2,
                l.Origen,
                l.LeadID,
                l.Departamento,
                l.Provincia,
                l.Distrito,
                l.Observaciones,
                l.Segmento,
                l.NLocales,
                l.GGCC,
                l.NDocumento,
                l.Vueltas,
                l.FechaUltimaGestion,
                l.Remarketing,
                uRMKT.Matricula as MatriculaRMKT,
                Concat(uRMKT.Nombres,' ',uRMKT.Apellidos) as RMKTNombreGestor,
                l.FechaHoraRemarketing,
                gl.Gestionable,
                gl.SubTipificacion,
                uGest.Matricula as ultimoGestor,
                Concat(uGest.Nombres,' ',uGest.Apellidos) as ultimoNombreGestor,
                d.Zonas,
                CASE
                    WHEN l.Gestion = 'inbound' THEN o.Canal
                ELSE 
	                CASE WHEN l.Origen ='GOOGLE_MARCA' THEN 'SEM MARCA' WHEN l.Origen ='SEO' THEN 'SEO' ELSE o.Canal END
                END AS Canal,
                v.IdVenta,
                v.TipoVenta,
                l.GestorTV,
                v.EstadoVisita,
                v.FechaHoraREG as FechaCreacionVisita,
                v.FechaVisita,
                v.NProspecto,
                l.visePiso,
                l.rubroNeg,
                l.puertaCalle,
                l.nobleParedes,
                l.nobleTecho,
                l.metros,
                l.motivoInteres,
                l.conSistema,
                l.empresaSistema,
                l.bancarizado                
            FROM dbVENTAS.tblLeadCC l
            INNER JOIN dbUSUARIO.tblusuario u ON l.IdUsuario = u.IdUsuario
            LEFT JOIN dbVENTAS.tblGestionLead gl on gl.IdGestionLead=l.UltimaGestion
            LEFT JOIN dbUSUARIO.tblusuario uGest on gl.IdUsuario = uGest.IdUsuario
            LEFT JOIN dbVENTAS.tbldistrital d ON d.CodUbigeoReniec=l.CodigoUbigeo
            LEFT JOIN dbVENTAS.tblorigen o on o.Origen=l.Origen
            LEFT JOIN dbUSUARIO.tblusuario uRMKT on l.IdUsuarioRemarketing = uRMKT.IdUsuario
            LEFT JOIN (SELECT * FROM dbVENTAS.tblventa WHERE IdLead IS NOT NULL) v ON l.IdLeadCC = v.IdLead
            LEFT JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
            ";
            
            
$result = $con->query($query);
//CONTADOR i para las filas de la consulta

while ($datos = $result->fetch_assoc()){
    $arreglo[] = $datos;

}

for($i=0; $i<count($arreglo); $i++){
    $rowData = WriterEntityFactory::createRowFromArray($arreglo[$i]);
    $writer->addRow($rowData);
}

$result->close();

$writer->close();

$con->close();

?>