<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require '../config/db.php';
require '../config/conexion.php';

$IdCotDet = $_POST['IdCotDet'];

$IdCotizacion = $_POST['IdCotizacion'];

$Nsubtotal = $_POST['Nsubtotal'];
$NTotalCuota = $_POST['NTotalCuota'];

$respuestaIdCotDet = eliminarItemCotizacion($IdCotDet);

if ($respuestaIdCotDet > 0){
    $respuestaCotizacion = actualizarCampos($IdCotizacion);
    echo $respuestaCotizacion;
}else {
    echo 'error';
}

/*
$respuestaItem = eliminarItem($idItem);
$respuestaItemCotizacion = eliminarItemCotizacion($idItem);

if ($respuestaItem > 0 && $respuestaItemCotizacion > 0){
    actualizarCampos($IdCotizacion);
    echo 1;
} else {
    echo 'error';
}
*/


function actualizarCampos($IdCotizacion){
    global $con;
    
    global $Nsubtotal;
    global $NTotalCuota;
    
    try{
        $stmt = $con->prepare("UPDATE tblcotizacion SET TotalCuota = ?, TotalPrecio=? WHERE IdCotizacion = ?");
        $stmt->bind_param('ddi', $NTotalCuota, $Nsubtotal, $IdCotizacion);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
     return $respuesta;
}

function eliminarItemCotizacion($IdCotDet){
    
    global $con;
    
    try{
        $stmt = $con->prepare("DELETE FROM tblcotizaciondetalle WHERE IdCotDet = ?");
        $stmt->bind_param('i', $IdCotDet);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
}
