<?php

    require_once '../config/db.php';
    require_once '../config/conexion.php';
    
    date_default_timezone_set('America/Lima');
    
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }
    
    if(isset($_POST['fechaCotizacion']) || !empty($_POST['fechaCotizacion'])){
        $fechaCotizacion = $_POST['fechaCotizacion'];
    } else {
        $fechaCotizacion = "2022-01-20";
    }
    
    if(isset($_POST['fechaFin']) || !empty($_POST['fechaFin'])){
        $fechaFin = $_POST['fechaFin'].' 23:59';
    } else {
        $fechaFin = $fechaCotizacion.' 23:59';
    }
    
    $fechaInicio = $fechaCotizacion;
    //$fechaFin = $fechaCotizacion.' 23:59';
    
    $date = new DateTime($fechaInicio);
    $fechaConvertidaInicio = $date->format('Y-m-d H:i:s');
    
    $fechaConvertidaFin = date('Y-m-d H:i', strtotime($fechaFin));

    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."' and ResultadoGestion<>'prueba'
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leads[] = $data;
        }
        
        $respuesta['Leads'] = $leads;
    } else {
        $respuesta['Leads'] = array();
    }

    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') AND Gestion = 'inbound' and ResultadoGestion<>'prueba'
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
             $leadsInbound[] = $data;
        }
        
       $respuesta['LeadsInbound'] = $leadsInbound;
    } else {
        $respuesta['LeadsInbound'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') AND Gestion = 'internet'
    group by hora";
    
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
             $leadsInternet[] = $data;
        }
        
       $respuesta['LeadsInternet'] = $leadsInternet;
    } else {
        $respuesta['LeadsInternet'] = array();
    }

    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') AND Gestion = 'correo'
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsCorreo[] = $data;
        }
        
        $respuesta['LeadsCorreo'] = $leadsCorreo;
    } else {
        $respuesta['LeadsCorreo'] = array();
    }
    
    $respuesta['Fecha'] = $fechaConvertidaFin;
    
    //VISITA ACEPTADA
    
    /*
    $sql = "SELECT HOUR(FechaHoraREG) hora, count(*) Total
    FROM tblventa v 
    WHERE IdLead IS NOT NULL 
    AND EstadoVisita IN ('Asignada', 'Vendida', 'NoVendida', 'VGenerada') AND TipoVenta IN ('RE','REGGCC')
    AND (FechaHoraREG BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    GROUP BY hora";
    */
    
    $sql = "SELECT HOUR(FechaHoraREG) hora, count(*) Total
    FROM tblventa v 
    WHERE ((IdLead IS NOT NULL 
    AND EstadoVisita IN ('Asignada', 'Vendida', 'NoVendida', 'VGenerada') AND TipoVenta IN ('RE','REGGCC')
    AND FechaHoraREG BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    OR (IdVentaVREL IS NOT NULL 
    AND EstadoVisita IN ('Asignada', 'Vendida', 'NoVendida', 'VGenerada') AND TipoVenta IN ('RE','REGGCC')
    AND FechaHoraREG BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."'))
    GROUP BY hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsVisitaAceptada[] = $data;
        }
        
        $respuesta['LeadsVisitaAceptada'] = $leadsVisitaAceptada;
    } else {
        $respuesta['LeadsVisitaAceptada'] = array();
    }
    
    //VISITA RELACIONADA
    
    $sql = "SELECT HOUR(FechaHoraREG) hora, count(*) Total
    FROM tblventa v 
    WHERE IdVentaVREL IS NOT NULL 
    AND EstadoVisita IN ('Asignada', 'Vendida', 'NoVendida', 'VGenerada') AND TipoVenta IN ('RE','REGGCC')
    AND FechaHoraREG BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."'
    GROUP BY hora";
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsVisitaRelacionada[] = $data;
        }
        
        $respuesta['LeadsVisitaRelacionada'] = $leadsVisitaRelacionada;
    } else {
        $respuesta['LeadsVisitaRelacionada'] = array();
    }
 
    
    //VISITA ACEPTADA INTERNET

    $sql = "SELECT HOUR(v.FechaHoraREG) hora, count(*) Total
            FROM 
                (SELECT * FROM tblventa 
                WHERE IdLead IS NOT NULL 
                AND EstadoVisita IN ('Asignada', 'Vendida', 'NoVendida', 'VGenerada') AND TipoVenta IN ('RE','REGGCC') 
                AND (FechaHoraREG BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')) v
            INNER JOIN tblLeadCC l ON v.IdLead = l.IdLeadCC
            WHERE Gestion = 'internet'
            GROUP BY hora";
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsVisitaAceptadaInternet[] = $data;
        }
        
        $respuesta['LeadsVisitaAceptadaInternet'] = $leadsVisitaAceptadaInternet;
    } else {
        $respuesta['LeadsVisitaAceptadaInternet'] = array();
    }
    
    //VISITA ACEPTADA INTERNET PRIMER INTENTO
    /*
    $sql = "SELECT HOUR(v.FechaHoraREG) hora, count(*) Total
            FROM 
                (SELECT * FROM tblventa 
                WHERE IdLead IS NOT NULL 
                AND EstadoVisita IN ('Asignada', 'Vendida', 'NoVendida', 'VGenerada') AND TipoVenta IN ('RE','REGGCC')
                AND (FechaHoraREG BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')) v
            INNER JOIN tblLeadCC l ON v.IdLead = l.IdLeadCC
            WHERE Gestion = 'internet' AND Campaña = 'Primer intento'
            GROUP BY hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsVisitaAceptadaInternetPrimerIntento[] = $data;
        }
        
        $respuesta['LeadsVisitaAceptadaInternetPrimerIntento'] = $leadsVisitaAceptadaInternetPrimerIntento;
    } else {
        $respuesta['LeadsVisitaAceptadaInternetPrimerIntento'] = array();
    }
    
    //VISITA ACEPTADA INTERNET RECOVERY
    
    $sql = "SELECT HOUR(v.FechaHoraREG) hora, count(*) Total
            FROM 
                (SELECT * FROM tblventa 
                WHERE IdLead IS NOT NULL 
                AND EstadoVisita IN ('Asignada', 'Vendida', 'NoVendida', 'VGenerada') AND TipoVenta IN ('RE','REGGCC')
                AND (FechaHoraREG BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')) v
            INNER JOIN tblLeadCC l ON v.IdLead = l.IdLeadCC
            WHERE Gestion = 'internet' AND Campaña = 'recovery'
            GROUP BY hora";
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsVisitaAceptadaInternetRecovery[] = $data;
        }
        
        $respuesta['LeadsVisitaAceptadaInternetRecovery'] = $leadsVisitaAceptadaInternetRecovery;
    } else {
        $respuesta['LeadsVisitaAceptadaInternetRecovery'] = array();
    }
    */
    //VISITA ACEPTADA INBOUND
    $sql = "SELECT HOUR(v.FechaHoraREG) hora, count(*) Total
            FROM 
                (SELECT * FROM tblventa 
                WHERE IdLead IS NOT NULL 
                AND EstadoVisita IN ('Asignada', 'Vendida', 'NoVendida', 'VGenerada') AND TipoVenta IN ('RE','REGGCC')
                AND (FechaHoraREG BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')) v
            INNER JOIN tblLeadCC l ON v.IdLead = l.IdLeadCC
            WHERE Gestion = 'inbound' and ResultadoGestion<>'prueba'
            GROUP BY hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsVisitaAceptadaInbound[] = $data;
        }
        
        $respuesta['LeadsVisitaAceptadaInbound'] = $leadsVisitaAceptadaInbound;
    } else {
        $respuesta['LeadsVisitaAceptadaInbound'] = array();
    }
    
    //VISITA ACEPTADA INBOUND PRIMER INTENTO
    /*
    $sql = "SELECT HOUR(v.FechaHoraREG) hora, count(*) Total
            FROM 
                (SELECT * FROM tblventa 
                WHERE IdLead IS NOT NULL 
                AND EstadoVisita IN ('Asignada', 'Vendida', 'NoVendida', 'VGenerada') AND TipoVenta IN ('RE','REGGCC')
                AND (FechaHoraREG BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')) v
            INNER JOIN tblLeadCC l ON v.IdLead = l.IdLeadCC
            WHERE Gestion = 'inbound' AND Campaña = 'Primer intento'
            GROUP BY hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsVisitaAceptadaInboundPrimerIntento[] = $data;
        }
        
        $respuesta['LeadsVisitaAceptadaInboundPrimerIntento'] = $leadsVisitaAceptadaInboundPrimerIntento;
    } else {
        $respuesta['LeadsVisitaAceptadaInboundPrimerIntento'] = array();
    }
    
    //VISITA ACEPTADA Inbound RECOVERY
    $sql = "SELECT HOUR(v.FechaHoraREG) hora, count(*) Total
            FROM 
                (SELECT * FROM tblventa 
                WHERE IdLead IS NOT NULL 
                AND EstadoVisita IN ('Asignada', 'Vendida', 'NoVendida', 'VGenerada') AND TipoVenta IN ('RE','REGGCC')
                AND (FechaHoraREG BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')) v
            INNER JOIN tblLeadCC l ON v.IdLead = l.IdLeadCC
            WHERE Gestion = 'inbound' AND Campaña = 'recovery'
            GROUP BY hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsVisitaAceptadaInboundRecovery[] = $data;
        }
        
        $respuesta['LeadsVisitaAceptadaInboundRecovery'] = $leadsVisitaAceptadaInboundRecovery;
    } else {
        $respuesta['LeadsVisitaAceptadaInboundRecovery'] = array();
    }
    */
    //VISITA ACEPTADA CORREO
    $sql = "SELECT HOUR(v.FechaHoraREG) hora, count(*) Total
            FROM 
                (SELECT * FROM tblventa 
                WHERE IdLead IS NOT NULL 
                AND EstadoVisita IN ('Asignada', 'Vendida', 'NoVendida', 'VGenerada') AND TipoVenta IN ('RE','REGGCC')
                AND (FechaHoraREG BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')) v
            INNER JOIN tblLeadCC l ON v.IdLead = l.IdLeadCC
            WHERE Gestion = 'correo'
            GROUP BY hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsVisitaAceptadaCorreo[] = $data;
        }
        
        $respuesta['LeadsVisitaAceptadaCorreo'] = $leadsVisitaAceptadaCorreo;
    } else {
        $respuesta['LeadsVisitaAceptadaCorreo'] = array();
    }
    
    //VISITA ACEPTADA CORREO PRIMER INTENTO
    /*
    $sql = "SELECT HOUR(v.FechaHoraREG) hora, count(*) Total
            FROM 
                (SELECT * FROM tblventa 
                WHERE IdLead IS NOT NULL 
                AND EstadoVisita IN ('Asignada', 'Vendida', 'NoVendida', 'VGenerada') AND TipoVenta IN ('RE','REGGCC')
                AND (FechaHoraREG BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')) v
            INNER JOIN tblLeadCC l ON v.IdLead = l.IdLeadCC
            WHERE Gestion = 'correo' AND Campaña = 'Primer intento'
            GROUP BY hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsVisitaAceptadaCorreoPrimerIntento[] = $data;
        }
        
        $respuesta['LeadsVisitaAceptadaCorreoPrimerIntento'] = $leadsVisitaAceptadaCorreoPrimerIntento;
    } else {
        $respuesta['LeadsVisitaAceptadaCorreoPrimerIntento'] = array();
    }
    
    //VISITA ACEPTADA Correo RECOVERY
    
    $sql = "SELECT HOUR(v.FechaHoraREG) hora, count(*) Total
            FROM 
                (SELECT * FROM tblventa 
                WHERE IdLead IS NOT NULL 
                AND EstadoVisita IN ('Asignada', 'Vendida', 'NoVendida', 'VGenerada') AND TipoVenta IN ('RE','REGGCC')
                AND (FechaHoraREG BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')) v
            INNER JOIN tblLeadCC l ON v.IdLead = l.IdLeadCC
            WHERE Gestion = 'correo' AND Campaña = 'recovery'
            GROUP BY hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsVisitaAceptadaCorreoRecovery[] = $data;
        }
        
        $respuesta['LeadsVisitaAceptadaCorreoRecovery'] = $leadsVisitaAceptadaCorreoRecovery;
    } else {
        $respuesta['LeadsVisitaAceptadaCorreoRecovery'] = array();
    }
    */
    
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."'
    AND ResultadoGestion IN ('apagado', 'contestaCorta', 'noContacto')
    group by hora";
    
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoContacto[] = $data;
        }
        
        $respuesta['LeadsNoContacto'] = $leadsNoContacto;
    } else {
        $respuesta['LeadsNoContacto']  = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."'
    AND ResultadoGestion IN ('Televenta' , 'clienteError', 'Duplicado', 'Inviable', 'PROV' , 'ZSCC' , 'Llamada Vacia' , 'telefonoError' ,
                                'noCotizo' , 'Número equivocado' , 'atc' , 'otros' , 'backoffice')
    group by hora";
    
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoGestionable[] = $data;
        }
        
        $respuesta['LeadsNoGestionable'] = $leadsNoGestionable;
    } else {
        $respuesta['LeadsNoGestionable']  = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."'
    AND ResultadoGestion IN ('devolverLlamada' ,
                                'noAceptaVisita' ,
                                'visitaAceptada' ,
                                'visitaReconfirmar'
                                )
    group by hora";
    
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsGestionable[] = $data;
        }
        
        $respuesta['LeadsGestionable'] = $leadsGestionable;
    } else {
        $respuesta['LeadsGestionable']  = array();
    }

    $respuesta['Fecha'] = $fechaConvertidaFin;
    
    //NO CONTACTO
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('apagado')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoContactoApagado[] = $data;
        }
        
        $respuesta['LeadsNoContactoApagado'] = $leadsNoContactoApagado;
    } else {
        $respuesta['LeadsNoContactoApagado'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('contestaCorta')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoContactoContestaCorta[] = $data;
        }
        
        $respuesta['LeadsNoContactoContestaCorta'] = $leadsNoContactoContestaCorta;
    } else {
        $respuesta['LeadsNoContactoContestaCorta'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('noContacto')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoContactoNoContacto[] = $data;
        }
        
        $respuesta['LeadsNoContactoNoContacto'] = $leadsNoContactoNoContacto;
    } else {
        $respuesta['LeadsNoContactoNoContacto'] = array();
    }
    
    //ESPECIFICA TIPIFICACIONES NO GESTIONABLES
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('Televenta')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoGestionableTeleventa[] = $data;
        }
        
        $respuesta['LeadsNoGestionableTeleventa'] = $leadsNoGestionableTeleventa;
    } else {
        $respuesta['LeadsNoGestionableTeleventa'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('clienteError')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoGestionableClienteError[] = $data;
        }
        
        $respuesta['LeadsNoGestionableClienteError'] = $leadsNoGestionableClienteError;
    } else {
        $respuesta['LeadsNoGestionableClienteError'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('Duplicado')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoGestionableDuplicado[] = $data;
        }
        
        $respuesta['LeadsNoGestionableDuplicado'] = $leadsNoGestionableDuplicado;
    } else {
        $respuesta['LeadsNoGestionableDuplicado'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('Inviable')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoGestionableInviable[] = $data;
        }
        
        $respuesta['LeadsNoGestionableInviable'] = $leadsNoGestionableInviable;
    } else {
        $respuesta['LeadsNoGestionableInviable'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('PROV')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoGestionablePROV[] = $data;
        }
        
        $respuesta['LeadsNoGestionablePROV'] = $leadsNoGestionablePROV;
    } else {
        $respuesta['LeadsNoGestionablePROV'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('ZSCC')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoGestionableZSCC[] = $data;
        }
        
        $respuesta['LeadsNoGestionableZSCC'] = $leadsNoGestionableZSCC;
    } else {
        $respuesta['LeadsNoGestionableZSCC'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('telefonoError')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoGestionableTelefonoError[] = $data;
        }
        
        $respuesta['LeadsNoGestionableTelefonoError'] = $leadsNoGestionableTelefonoError;
    } else {
        $respuesta['LeadsNoGestionableTelefonoError'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('noCotizo')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoGestionableNoCotizo[] = $data;
        }
        
        $respuesta['LeadsNoGestionableNoCotizo'] = $leadsNoGestionableNoCotizo;
    } else {
        $respuesta['LeadsNoGestionableNoCotizo'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('atc')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoGestionableATC[] = $data;
        }
        
        $respuesta['LeadsNoGestionableATC'] = $leadsNoGestionableATC;
    } else {
        $respuesta['LeadsNoGestionableATC'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('otros')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoGestionableOtros[] = $data;
        }
        
        $respuesta['LeadsNoGestionableOtros'] = $leadsNoGestionableOtros;
    } else {
        $respuesta['LeadsNoGestionableOtros'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('backoffice')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsNoGestionableBackoffice[] = $data;
        }
        
        $respuesta['LeadsNoGestionableBackoffice'] = $leadsNoGestionableBackoffice;
    } else {
        $respuesta['LeadsNoGestionableBackoffice'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('devolverLlamada')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsGestionableDevolverLlamada[] = $data;
        }
        
        $respuesta['LeadsGestionableDevolverLlamada'] = $leadsGestionableDevolverLlamada;
    } else {
        $respuesta['LeadsGestionableDevolverLlamada'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('noAceptaVisita')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsGestionableNoAceptaVisita[] = $data;
        }
        
        $respuesta['LeadsGestionableNoAceptaVisita'] = $leadsGestionableNoAceptaVisita;
    } else {
        $respuesta['LeadsGestionableNoAceptaVisita'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('visitaAceptada')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsGestionableVisitaAceptada[] = $data;
        }
        
        $respuesta['LeadsGestionableVisitaAceptada'] = $leadsGestionableVisitaAceptada;
    } else {
        $respuesta['LeadsGestionableVisitaAceptada'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."') 
    AND ResultadoGestion IN ('visitaReconfirmar')
    group by hora";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsGestionableVisitaReconfirmar[] = $data;
        }
        
        $respuesta['LeadsGestionableVisitaReconfirmar'] = $leadsGestionableVisitaReconfirmar;
    } else {
        $respuesta['LeadsGestionableVisitaReconfirmar'] = array();
    }
    /*
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC l
    LEFT JOIN dbVENTAS.tblorigen o on l.Origen = o.Origen
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    AND o.Canal IN ('FACEBOOK',
                'FACEBOOK LN',
                'AFILIADOS',
                'DISPLAY',
                'EMAIL',
                'GDN',
                'SEM MARCA',
                'SEM GENERICO',
                'SEO',
                'INBOUND'
                )
    group by hora";
    */
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM leads l
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    AND l.Canal IN ('FACEBOOK',
                'FACEBOOK LN',
                'AFILIADOS',
                'DISPLAY',
                'EMAIL',
                'GDN',
                'SEM MARCA',
                'SEM GENERICO',
                'SEO',
                'INBOUND',
                'TIKTOK'
                )
    group by hora";    
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsCanal[] = $data;
        }
        
        $respuesta['LeadsCanal'] = $leadsCanal;
    } else {
        $respuesta['LeadsCanal'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC l
    LEFT JOIN dbVENTAS.tblorigen o on l.Origen = o.Origen
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    AND o.Canal IN ('FACEBOOK')
    group by hora";
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsCanalFacebook[] = $data;
        }
        
        $respuesta['LeadsCanalFacebook'] = $leadsCanalFacebook;
    } else {
        $respuesta['LeadsCanalFacebook'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC l
    LEFT JOIN dbVENTAS.tblorigen o on l.Origen = o.Origen
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    AND o.Canal IN ('FACEBOOK LN')
    group by hora";
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsCanalFacebook_LN[] = $data;
        }
        
        $respuesta['LeadsCanalFacebook_LN'] = $leadsCanalFacebook_LN;
    } else {
        $respuesta['LeadsCanalFacebook_LN'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC l
    LEFT JOIN dbVENTAS.tblorigen o on l.Origen = o.Origen
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    AND o.Canal IN ('AFILIADOS')
    group by hora";
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsCanalAfiliados[] = $data;
        }
        
        $respuesta['LeadsCanalAfiliados'] = $leadsCanalAfiliados;
    } else {
        $respuesta['LeadsCanalAfiliados'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC l
    LEFT JOIN dbVENTAS.tblorigen o on l.Origen = o.Origen
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    AND o.Canal IN ('DISPLAY')
    group by hora";
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsCanalDisplay[] = $data;
        }
        
        $respuesta['LeadsCanalDisplay'] = $leadsCanalDisplay;
    } else {
        $respuesta['LeadsCanalDisplay'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC l
    LEFT JOIN dbVENTAS.tblorigen o on l.Origen = o.Origen
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    AND o.Canal IN ('Email')
    group by hora";
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsCanalEmail[] = $data;
        }
        
        $respuesta['LeadsCanalEmail'] = $leadsCanalEmail;
    } else {
        $respuesta['LeadsCanalEmail'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC l
    LEFT JOIN dbVENTAS.tblorigen o on l.Origen = o.Origen
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    AND o.Canal IN ('GDN'
                )
    group by hora";
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsCanalGDN[] = $data;
        }
        
        $respuesta['LeadsCanalGDN'] = $leadsCanalGDN;
    } else {
        $respuesta['LeadsCanalGDN'] = array();
    }
    /*
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC l
    LEFT JOIN dbVENTAS.tblorigen o on l.Origen = o.Origen
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    AND o.Canal IN ('SEM MARCA')
    group by hora";
    */
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM leads l
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    AND l.Canal IN ('SEM MARCA')
    group by hora";    
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsCanalSEMMARCA[] = $data;
        }
        
        $respuesta['LeadsCanalSEMMARCA'] = $leadsCanalSEMMARCA;
    } else {
        $respuesta['LeadsCanalSEMMARCA'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC l
    LEFT JOIN dbVENTAS.tblorigen o on l.Origen = o.Origen
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    AND o.Canal IN ('SEM GENERICO')
    group by hora";
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsCanalSEMGENERICO[] = $data;
        }
        
        $respuesta['LeadsCanalSEMGENERICO'] = $leadsCanalSEMGENERICO;
    } else {
        $respuesta['LeadsCanalSEMGENERICO'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC l
    LEFT JOIN dbVENTAS.tblorigen o on l.Origen = o.Origen
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    AND o.Canal IN ('SEO')
    group by hora";
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsCanalSEO[] = $data;
        }
        
        $respuesta['LeadsCanalSEO'] = $leadsCanalSEO;
    } else {
        $respuesta['LeadsCanalSEO'] = array();
    }
    /*
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC l
    LEFT JOIN dbVENTAS.tblorigen o on l.Origen = o.Origen
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    AND o.Canal IN ('INBOUND')
    group by hora";
    */
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM leads l
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    AND l.Canal IN ('INBOUND') and ResultadoGestion<>'prueba'
    group by hora";    
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsCanalINBOUND[] = $data;
        }
        
        $respuesta['LeadsCanalINBOUND'] = $leadsCanalINBOUND;
    } else {
        $respuesta['LeadsCanalINBOUND'] = array();
    }
    

    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, count(*) Total
    FROM tblLeadCC l
    LEFT JOIN dbVENTAS.tblorigen o on l.Origen = o.Origen
    WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
    AND o.Canal IN ('TIKTOK')
    group by hora";   
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $leadsCanalTIKTOK[] = $data;
        }
        
        $respuesta['LeadsCanalTiktok'] = $leadsCanalTIKTOK;
    } else {
        $respuesta['LeadsCanalTiktok'] = array();
    }    


    
    
    //VISITA ACEPTADA INTERNET, INBOUND Y CORREO POR CAMPAÑA
    
    $sql = "SELECT Gestion, Campaña, HOUR(v.FechaHoraREG) hora, count(*) Total
            FROM 
                (SELECT * FROM tblventa 
                WHERE IdLead IS NOT NULL 
                AND EstadoVisita IN ('Asignada', 'Vendida', 'NoVendida', 'VGenerada') AND TipoVenta IN ('RE','REGGCC')
                AND (FechaHoraREG BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')) v
            INNER JOIN tblLeadCC l ON v.IdLead = l.IdLeadCC
            GROUP BY Gestion, Campaña, hora
            ";
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
        
        $LeadVisitaAceptadaInternetPrimerIntento = array();
        $LeadVisitaAceptadaInternetRecovery = array();
        $LeadVisitaAceptadaInboundPrimerIntento= array();
        $LeadVisitaAceptadaInboundRecovery= array();
        $LeadVisitaAceptadaCorreoPrimerIntento= array();
        $LeadVisitaAceptadaCorreoRecovery= array();
        
        while($data = $resultado->fetch_assoc()){
            //$leadsVA_NUEVO[] = $data;
            
            if($data['Gestion'] == 'internet'){
                if($data['Campaña'] == 'Primer intento'){
                    $LeadVisitaAceptadaInternetPrimerIntento[] = array(
                            'hora' => $data['hora'],
                            'Total' => $data['Total']
                        );
                } 
                
                if($data['Campaña'] == 'recovery'){
                    $LeadVisitaAceptadaInternetRecovery[] = array(
                            'hora' => $data['hora'],
                            'Total' => $data['Total']
                        );
                }
                
                
            }
            
            if($data['Gestion'] == 'inbound'){
                if($data['Campaña'] == 'Primer intento'){
                    $LeadVisitaAceptadaInboundPrimerIntento[] = array(
                            'hora' => $data['hora'],
                            'Total' => $data['Total']
                        );
                }
                if($data['Campaña'] == 'recovery'){
                    $LeadVisitaAceptadaInboundRecovery[] = array(
                            'hora' => $data['hora'],
                            'Total' => $data['Total']
                        );
                }
            }
            
            if($data['Gestion'] == 'correo'){
                if($data['Campaña'] == 'Primer intento'){
                    $LeadVisitaAceptadaCorreoPrimerIntento[] = array(
                            'hora' => $data['hora'],
                            'Total' => $data['Total']
                        );
                }
                if($data['Campaña'] == 'recovery'){
                    $LeadVisitaAceptadaCorreoRecovery[] = array(
                            'hora' => $data['hora'],
                            'Total' => $data['Total']
                        );
                }
            }
        }
        
        $respuesta['LeadsVisitaAceptadaInternetPrimerIntento'] = $LeadVisitaAceptadaInternetPrimerIntento;
        $respuesta['LeadsVisitaAceptadaInternetRecovery'] = $LeadVisitaAceptadaInternetRecovery;
        $respuesta['LeadsVisitaAceptadaInboundPrimerIntento'] = $LeadVisitaAceptadaInboundPrimerIntento;
        $respuesta['LeadsVisitaAceptadaInboundRecovery'] = $LeadVisitaAceptadaInboundRecovery;
        $respuesta['LeadsVisitaAceptadaCorreoPrimerIntento'] = $LeadVisitaAceptadaCorreoPrimerIntento;
        $respuesta['LeadsVisitaAceptadaCorreoRecovery'] = $LeadVisitaAceptadaCorreoRecovery;
        
    } else {
        $respuesta['LeadsVisitaAceptadaInternetPrimerIntento'] = array();
        $respuesta['LeadsVisitaAceptadaInternetRecovery'] = array();
        $respuesta['LeadsVisitaAceptadaInboundPrimerIntento'] = array();
        $respuesta['LeadsVisitaAceptadaInboundRecovery'] = array();
        $respuesta['LeadsVisitaAceptadaCorreoPrimerIntento'] = array();
        $respuesta['LeadsVisitaAceptadaCorreoRecovery'] = array();
    }
    
    
    
    $sql = "SELECT ResultadoGestion, AVG(Vueltas) PromVueltas
            FROM `tblLeadCC` 
            WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
            GROUP by ResultadoGestion";
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
        while($data = $resultado->fetch_assoc()){
            $leadsPromVueltas[] = $data;
        }
        
        $respuesta['LeadsPromVueltas'] = $leadsPromVueltas;
    } else {
        $respuesta['LeadsPromVueltas'] = array();
    }
    
    $sql = "SELECT HOUR(FechaUltimaGestion) hora, count(*) Total
            FROM tblLeadCC l
            WHERE (FechaUltimaGestion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
            AND ResultadoGestion IN ('televenta')
            GROUP By hora";
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
        while($data = $resultado->fetch_assoc()){
            $leadsTransferenciaTeleventa[] = $data;
        }
        
        $respuesta['LeadsTrasnferenciaTeleventa'] = $leadsTransferenciaTeleventa;
    } else {
        $respuesta['LeadsTrasnferenciaTeleventa'] = array();
    }
    
    $sql = "SELECT HOUR(FechaHoraCotizacion) hora, avg(l.Vueltas) Promedio
            FROM tblLeadCC l
            WHERE (FechaHoraCotizacion BETWEEN '".$fechaConvertidaInicio."' AND '".$fechaConvertidaFin."')
            AND ResultadoGestion IN ('apagado','contestaCorta', 'nocontacto') 
            GROUP BY hora";
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    
    if($rows > 0){
        while($data = $resultado->fetch_assoc()){
            $leadsVueltasNoContacto[] = $data;
        }
        
        $respuesta['LeadsVueltasNoContacto'] = $leadsVueltasNoContacto;
    } else {
        $respuesta['LeadsVueltasNoContacto'] = array();
    }
    
    echo json_encode($respuesta);