<?php
header("Content-Type: text/html;charset=utf-8");
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require '../config/db.php';
require '../config/conexion.php';

//DATOS DE AMPLIACION
$idAmpl = stringtonull($_POST['idAmpl']);
$valbackoffice = stringtonull($_POST['valbackoffice']);
$resultadoAmpliacion = actualizarAmpliacion($idAmpl);
if($resultadoAmpliacion>0){
    echo 1;
}else{
    echo 0;
}

function actualizarAmpliacion($idAmpl){
    
    global $con;
    
    global $valbackoffice;

    try{
        $stmt = $con->prepare("UPDATE tblampliacion SET ValidadoBackOffice=? WHERE IdAmp = ?");
        $stmt->bind_param('si', $valbackoffice, $idAmpl);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();    
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}
function stringtonull($val){
    
    if ($val == '' || empty($val)){
        $resultado = NULL;
    }
    else if(!isset($val)){
        $resultado = NULL;
    }
    else {
        $resultado = $val;
    }
    
    return $resultado;
}
