<?php
header("Content-Type: text/html;charset=utf-8");
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require '../config/db.php';
require '../config/conexion.php';

//DATOS DE AMPLIACION
$idven = stringtonull($_POST['idven']);
$tipoventa = stringtonull($_POST['tipoventa']);
$refhabilitada = stringtonull($_POST['refhabilitada']);

$resultadoAmpliacion = actualizarVenta($idven);


if($resultadoAmpliacion>0){
    echo 1;
}else{
    echo 0;
}

function actualizarProspectoRP($idprospectorp){
    
    global $con;
    
    global $refhabilitada;

    try{
        $stmt = $con->prepare("UPDATE tblprospectorp SET referidoHabilitado=? WHERE IdProspectoRP = ?");
        $stmt->bind_param('si', $refhabilitada, $idprospectorp);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();    
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function actualizarVenta($idven){
    
    global $con;
    
    global $refhabilitada;

    try{
        $stmt = $con->prepare("UPDATE tblventa SET referidoHabilitadoTVTC=? WHERE IdVenta = ?");
        $stmt->bind_param('si', $refhabilitada, $idven);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();    
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function actualizarVentaRP($idprospectorp){
    
    global $con;
    
    global $refhabilitada;

    try{
        $stmt = $con->prepare("UPDATE tblventa SET referidoHabilitado=? WHERE IdProspectoRP = ?");
        $stmt->bind_param('si', $refhabilitada, $idprospectorp);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();    
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}


function stringtonull($val){
    
    if ($val == '' || empty($val)){
        $resultado = NULL;
    }
    else if(!isset($val)){
        $resultado = NULL;
    }
    else {
        $resultado = $val;
    }
    
    return $resultado;
}
