<?php

include('is_logged.php');

date_default_timezone_set('America/Lima');
require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

$fecharegistro=date("Y-m-d H:i:s");
$gestororigen=stringtonull($_POST['lblmatricula']);
$ccusuario=stringtonull($_POST['lblcc']);


$REMOTE_ADDR=sanitizaCampo($_SERVER['REMOTE_ADDR'],'sanitizeip|htmlspecialchars',$con);
$usuariosesion=$_SESSION['usuariosesion'];
$REQUEST_URI=sanitizaCampo($_SERVER['REQUEST_URI'],'sanitizeurl|scapestring|htmlspecialchars',$con);
$Acceso='Acceso';
$HTTP_USER_AGENT=sanitizaCampo($_SERVER['HTTP_USER_AGENT'],'sanitizestring|scapestring|htmlspecialchars',$con);

try {
        
  $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
  $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
  $stmt->execute();
  
  $idLogSeg = $con->insert_id;
  $stmt->close();
  
} catch (\Exception $e) {

  $e->getMessage();
  $idLogSeg=0;
}


if($idLogSeg>0){
    $idform=insertarform();
    if($idform>0){
        echo 1;
    }else{
        echo 2;
    }
    
}else{
    echo 2;
}


function insertarform(){
    global $con;
    
    global $fecharegistro;
    global $gestororigen;
    global $ccusuario;

    try{
    
        $stmt = $con->prepare("INSERT INTO dbVENTAS.tblformacion(FechaHoraREG,GestorOrigen,CCOrigen) VALUES(?, ?, ?)");
        $stmt->bind_param('sss', $fecharegistro, $gestororigen, $ccusuario);
        $stmt->execute();
        
        $idVen = $con->insert_id;

        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
    }
    
    return $idVen;
    
}


function stringtonull($val){
    
    if ($val == '' || empty($val)){
        $resultado = NULL;
    }
    else if(!isset($val)){
        $resultado = NULL;
    }
    else {
        $resultado = $val;
    }
    
    return $resultado;
}


$con->close();

