<?php

    date_default_timezone_set('America/Lima');
    
    session_start();
    
    require_once '../config/db.php';
    require_once '../config/conexion.php';
    include '../helper/helper_validacion.php';
    

    $ip_acceso = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
    $ip_acceso = htmlspecialchars($ip_acceso);
    $fecharegistro = date("Y-m-d H:i:s");
    
    $usuario = sanitizaCampo($_POST['username'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $usuario = htmlspecialchars($usuario);
    
    $password = sanitizaCampo($_POST['password'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $password = htmlspecialchars($password);    

    $result_pass = $con->prepare("SELECT 
        u.IdUsuario,
        u.Token,
        CONCAT(u.Nombres,' ',u.Apellidos) NombUsuario,
        u.Matricula, 
        u.Usuario,
        u.CC,
        u.Password,
        u.Estado,
        IFNULL(u.FechaHoraMODIF,'0') FechaHoraMODIF,
        IF(DATE_ADD(u.FechaHoraMODIF,INTERVAL 6 MONTH)<= DATE_ADD(SYSDATE(),INTERVAL 2 HOUR),'SI','NO') FechaHora6MES,
        p.IdPerfil,
        p.NombrePerfil Perfil,
        p.Privilegio,
        a.IdAcceso,
        a.NombreAcceso Acceso,
        a.PZ_WB_1,
        a.PZ_WB_2,
        a.PZ_WB_3,
        a.PZ_WB_FactuFoto,
        a.PZ_WB_Jefatura,
        a.PZ_WB_Visitas,
        a.PZ_WB_Agenda,
        a.PZ_VTA_General,
        a.PZ_VTA_150,
        a.PZ_VTA_151,
        a.PZ_VTA_152,
        a.PZ_VTA_153,
        a.PZ_VTA_154,
        a.PZ_VTA_155,
        a.PZ_VTA_156,
        a.PZ_VTA_120,
        a.PZ_VTA_40,
        a.PZ_VTA_41,
        a.PZ_VTA_Tc,
        a.PZ_MTK_Marketing,
        a.PZ_MKT_TCGestionados,
        a.PZ_MKT_Televenta,
        a.PZ_MKT_TVGestionados,
        a.PZ_AGE_Agenda,
        a.PZ_AGE_PDTE,
        a.PZ_AGE_Gestionados,
        a.PZ_TEC_ATTEC,
        a.PZ_TEC_Pendiente,
        a.PZ_TEC_Consulta,
        a.PZ_FAC_Instaladas,
        a.PZ_FAC_NoDoc,
        a.PZ_FAC_DocEnvi,
        a.PZ_FAC_Incidencia,
        a.PZ_FAC_IncidenciagestValija,
        a.PZ_FAC_IncidenciagestCorreo,
        a.PZ_FAC_PorFacturar,
        a.PZ_FAC_310,
        a.PZ_FAC_590,
        a.PZ_FAC_Facturacion,
        a.OC_Acceso,
        a.VS_Configuracion,
        a.VS_Config_Ucom ConfigE,
        a.PZ_VTA_Consulta,
        a.PZ_VTA_Documento,
        a.PZ_VTA_Multimedia,
        a.PZ_VTA_Reporte,
        a.PZ_MDP_General,
        a.PZ_MDP_Transaccion,
        a.PZ_FOR_Consulta,
        a.PZ_CALLRP_PorContactar,
        a.PZ_CALLRP_PorAsignar,
        a.PZ_CALLRP_Backlog,
        a.PZ_CALLRP_Gestionado,
        a.AMP_General,
        a.PZ_MKT_ContactExterno,
        a.PZ_MKT_PorAsignar,
        a.VS_COB_Porfolio,
        a.VS_COB_Cartera,
        a.VS_COB_Pago,
        a.MKTCLI_VTA_Certi,
        a.MDP_RPA,
        a.PZ_MTK_LeadRMKT,
        u.RMKT,
        u.TCTV,
        u.RemarketingTV,
        u.TC,
        u.Push,
        u.Pull,
        u.Equipo,
        u.RemarketingTC
        FROM dbUSUARIO.tblusuario u 
        INNER JOIN dbUSUARIO.tblperfil p on p.IdPerfil=u.IdPerfil
        INNER JOIN dbUSUARIO.tblacceso a on a.IdAcceso=p.IdAcceso
    WHERE u.Usuario = ?");
    $result_pass->bind_param('s',$usuario);
    $result_pass->execute();
    $result_pass->store_result();
    $result_pass->bind_result(
		$IdUsuarioRow,
		$TokenURow,
        $NombUsuarioRow,
        $MatriculaRow, 
        $UsuarioRow,
        $CCRow,
        $PasswordRow,
        $EstadoRow,
        $FechaHoraMODIFRow,
        $FechaHora6MESRow,
        $IdPerfilRow,
        $PerfilRow,
        $PrivilegioRow,
        $IdAccesoRow,
        $AccesoRow,
        $PZ_WB_1Row,
        $PZ_WB_2Row,
        $PZ_WB_3Row,
        $PZ_WB_FactuFotoRow,
        $PZ_WB_JefaturaRow,
        $PZ_WB_VisitasRow,
        $PZ_WB_AgendaRow,
        $PZ_VTA_GeneralRow,
        $PZ_VTA_150Row,
        $PZ_VTA_151Row,
        $PZ_VTA_152Row,
        $PZ_VTA_153Row,
        $PZ_VTA_154Row,
        $PZ_VTA_155Row,
        $PZ_VTA_156Row,
        $PZ_VTA_120Row,
        $PZ_VTA_40Row,
        $PZ_VTA_41Row,
        $PZ_VTA_TcRow,
        $PZ_MTK_MarketingRow,
        $PZ_MKT_TCGestionadosRow,
        $PZ_MKT_TeleventaRow,
        $PZ_MKT_TVGestionadosRow,
        $PZ_AGE_AgendaRow,
        $PZ_AGE_PDTERow,
        $PZ_AGE_GestionadosRow,
        $PZ_TEC_ATTECRow,
        $PZ_TEC_PendienteRow,
        $PZ_TEC_ConsultaRow,
        $PZ_FAC_InstaladasRow,
        $PZ_FAC_NoDocRow,
        $PZ_FAC_DocEnviRow,
        $PZ_FAC_IncidenciaRow,
        $PZ_FAC_IncidenciagestValijaRow,
        $PZ_FAC_IncidenciagestCorreoRow,
        $PZ_FAC_PorFacturarRow,
        $PZ_FAC_310Row,
        $PZ_FAC_590Row,
        $PZ_FAC_FacturacionRow,
        $OC_AccesoRow,
        $VS_ConfiguracionRow,
        $ConfigERow,
        $PZ_VTA_ConsultaRow,
        $PZ_VTA_DocumentoRow,
        $PZ_VTA_MultimediaRow,
        $PZ_VTA_ReporteRow,
        $PZ_MDP_GeneralRow,
        $PZ_MDP_TransaccionRow,
        $PZ_FOR_ConsultaRow,
        $PZ_CALLRP_PorContactarRow,
        $PZ_CALLRP_PorAsignarRow,
        $PZ_CALLRP_BacklogRow,
        $PZ_CALLRP_GestionadoRow,
        $AMP_GeneralRow,
        $PZ_MKT_ContactExternoRow,
        $PZ_MKT_PorAsignarRow,
        $VS_COB_PorfolioRow,
        $VS_COB_CarteraRow,
        $VS_COB_PagoRow,
        $MKTCLI_VTA_CertiRow,
        $MDP_RPARow,
        $PZ_MTK_LeadRMKTRow,
        $RMKTRow,
        $TCTVRow,
        $RemarketingTVRow,
        $TCRow,
        $PushRow,
        $PullRow,
        $EquipoRow,
        $RemarketingTCRow
        );
    
    // $pass_hash = $row['Password'];
    // $estadousuario=$row['Estado'];
    
    $numrows=  $result_pass->num_rows;


    if($numrows>0){
        if($result_pass->fetch()){
            $pass_hash = $PasswordRow;
            $estadousuario=$EstadoRow;
            if($estadousuario==='Activo'){
                if (password_verify($password, $pass_hash)) {
                $_SESSION['id_usuario'] = $IdUsuarioRow;
                $_SESSION['tokenU'] = $TokenURow;
                $_SESSION['usuariosesion'] = $UsuarioRow;
                $_SESSION['nombusuario'] = $NombUsuarioRow;
                $_SESSION['matriculausuario'] = $MatriculaRow;
                $_SESSION['ccusuario'] = $CCRow;
                $_SESSION['id_perfil'] = $IdPerfilRow;
                $_SESSION['nomb_perfil'] = $PerfilRow;
                $_SESSION['tipo_usuario'] = $PrivilegioRow;
                $_SESSION['id_acceso'] = $IdAccesoRow;
                $_SESSION['NombreAcceso'] = $AccesoRow;
        		$_SESSION['pzwb1'] = $PZ_WB_1Row;
        		$_SESSION['pzwb2'] = $PZ_WB_2Row;
        		$_SESSION['pzwb3'] = $PZ_WB_3Row;
        		$_SESSION['pzwbfactufoto'] = $PZ_WB_FactuFotoRow;
        		$_SESSION['pzwbjefatura'] = $PZ_WB_JefaturaRow;
        		$_SESSION['pzwbvisitas'] = $PZ_WB_VisitasRow;
        		$_SESSION['pzwbagenda'] = $PZ_WB_AgendaRow;
        		$_SESSION['pzvtageneral'] = $PZ_VTA_GeneralRow;
        		$_SESSION['pzvta150'] = $PZ_VTA_150Row;
        		$_SESSION['pzvta151'] = $PZ_VTA_151Row;
        		$_SESSION['pzvta152'] = $PZ_VTA_152Row;
        		$_SESSION['pzvta153'] = $PZ_VTA_153Row;
        		$_SESSION['pzvta154'] = $PZ_VTA_154Row;
        		$_SESSION['pzvta155'] = $PZ_VTA_155Row;
        		$_SESSION['pzvta156'] = $PZ_VTA_156Row;
        		$_SESSION['pzvta120'] = $PZ_VTA_120Row;
        		$_SESSION['pzvta40'] = $PZ_VTA_40Row;
        		$_SESSION['pzvta41'] = $PZ_VTA_41Row;
        		$_SESSION['pzvtatc'] = $PZ_VTA_TcRow;
        		$_SESSION['pzmktmarketing'] = $PZ_MTK_MarketingRow;
        		$_SESSION['pzmktcgestionados'] = $PZ_MKT_TCGestionadosRow;
        		$_SESSION['pzmktteleventa'] = $PZ_MKT_TeleventaRow;
        		$_SESSION['pzmkttvgestionados'] = $PZ_MKT_TVGestionadosRow;
        		$_SESSION['pzageagenda'] = $PZ_AGE_AgendaRow;
        		$_SESSION['pzageagendapendiente'] = $PZ_AGE_PDTERow;
        		$_SESSION['pzfacfacturacion'] = $PZ_FAC_FacturacionRow;
        		$_SESSION['ocacceso'] = $OC_AccesoRow;
        		$_SESSION['vsconfiguracion'] = $VS_ConfiguracionRow;
        		$_SESSION['vsconfigestructura'] = $ConfigERow;
        		$_SESSION['pzvtaconsulta'] = $PZ_VTA_ConsultaRow;
                $_SESSION['user_login_status'] = 1;
                 
        		$FechaHoraMODIF=$FechaHoraMODIFRow;
        		$FechaHora6MES=$FechaHora6MESRow;
        		$_SESSION['pzagegestionados'] = $PZ_AGE_GestionadosRow;
        		$_SESSION['pztecattec'] = $PZ_TEC_ATTECRow;
        		$_SESSION['pztecpendiente'] = $PZ_TEC_PendienteRow;
        		$_SESSION['pztecconsulta']=$PZ_TEC_ConsultaRow;
        		$_SESSION['pzfacinstaladas'] = $PZ_FAC_InstaladasRow;
        		$_SESSION['pzfacnodoc'] = $PZ_FAC_NoDocRow;
        		$_SESSION['pzfacdocenvi'] = $PZ_FAC_DocEnviRow;
        		$_SESSION['pzfacincidencia'] = $PZ_FAC_IncidenciaRow;
        		$_SESSION['pzfacincidenciagestvalija'] = $PZ_FAC_IncidenciagestValijaRow;
        		$_SESSION['pzfacincidenciagestcorreo'] = $PZ_FAC_IncidenciagestCorreoRow;
        		$_SESSION['pzfacporfacturar'] = $PZ_FAC_PorFacturarRow;
        		$_SESSION['pzfac310'] = $PZ_FAC_310Row;
        		$_SESSION['pzfac590'] = $PZ_FAC_590Row;
        		$_SESSION['pzvtadocumento'] = $PZ_VTA_DocumentoRow;
        		$_SESSION['pzvtamultimedia'] = $PZ_VTA_MultimediaRow;
        		$_SESSION['pzvtareporte'] = $PZ_VTA_ReporteRow;
        		$_SESSION['pzmdpgeneral'] = $PZ_MDP_GeneralRow;
        		$_SESSION['pzmdptransaccion'] = $PZ_MDP_TransaccionRow;
        		$_SESSION['pzforconsulta'] = $PZ_FOR_ConsultaRow;
        		$_SESSION['pzcallrpporcontactar'] = $PZ_CALLRP_PorContactarRow;
        		$_SESSION['pzcallrpporasignar'] = $PZ_CALLRP_PorAsignarRow;
        		$_SESSION['pzcallrpbacklog'] = $PZ_CALLRP_BacklogRow;
        		$_SESSION['pzcallrpgestionado'] = $PZ_CALLRP_GestionadoRow;
        		$_SESSION['ampgeneral'] = $AMP_GeneralRow;
        		$_SESSION['pzmktb12'] = $PZ_MKT_ContactExternoRow;
        		$_SESSION['pzmktporasignar'] = $PZ_MKT_PorAsignarRow;
        		$_SESSION['vscobporfolio'] = $VS_COB_PorfolioRow;
        		$_SESSION['vscobcartera'] = $VS_COB_CarteraRow;
        		$_SESSION['vscobpago'] = $VS_COB_PagoRow;
        		$_SESSION['mktclivtacerti'] = $MKTCLI_VTA_CertiRow;
                $_SESSION['token'] = md5(uniqid(mt_rand(), true));
                $_SESSION['sessionArray'] = array(
                            'MDP_RPA'=>$MDP_RPARow,
                            'PZ_MTK_LeadRMKT'=>$PZ_MTK_LeadRMKTRow,
                            'RMKT'=>$RMKTRow,
                            'TCTV' =>$TCTVRow,
                            'RemarketingTV' =>$RemarketingTVRow,
                            'TC' =>$TCRow,
                            'Push' =>$PushRow,
                            'Pull' =>$PullRow,
                            'Equipo' =>$EquipoRow,
                            'RemarketingTC'=>$RemarketingTCRow
                    );
                    

                    
                /* GUARDAR TOKEN EN BASE */
                $token = $_SESSION['token'];
                try{
                    $sqlpassword = $con->prepare("UPDATE dbUSUARIO.tblusuario u SET u.Token=? WHERE u.IdUsuario=?");
                    $sqlpassword->bind_param('si', $token, $IdUsuarioRow);
                    $sqlpassword->execute();
                    $respuesta = $sqlpassword->affected_rows;
                    $sqlpassword->close();
                } catch (\Exception $e) {
                    $respuesta = 0;
                }                    
                
                
    
                if ($_SESSION['id_perfil'] == 47 ){
                   
                        if($FechaHoraMODIF=='0' || $FechaHora6MES=='SI'){
?>
                            <div class="alert alert-warning" id="mensaje">
                                <button class="close" data-dismiss="alert"></button>
                                Para continuar debe cambiar su password, presiona <a style="color:red" href="#" onclick="loging(<?php echo $_SESSION['id_usuario']; ?>);return false;"  id="forget-pass">aquí</a>.
                            </div>
<?php
       
                        }else{
                            echo "<script>
                                var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                               
                                if (r == true) {
                                    location.href = '../reclamos.php'
                                } else {
                                    var   txt = 'You pressed Cancel!';
                                }
                                
                                </script>";
                        }
            
                    
        
                } //END IF PERFIL 47
                
                else if ($_SESSION['id_perfil'] == 12 ){
                    /*
                    if ($ip_acceso == '181.65.164.123' || $ip_acceso=='190.236.161.142'){
                    */
                    echo "<script>
                          var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                          if (r == true) {
                              location.href = '../ventadc511.php'
                          } else {
                           var   txt = 'You pressed Cancel!';
                          }
                        </script>";
                    /*
        } else {
          echo "<script>

              alert('ACCESO DENEGADO. Estas ingresando desde una red no corporativa de VERISURE. Comunicate con el administrador!');

              </script>";
        }
         */
         
                                 
                }else if($_SESSION['matriculausuario']=="MKTTEL"){
                                
                                echo "<script> 
                        
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                        if (r == true) {
                                            location.href = '../tvbasexterna.php'
                                        } else {
                                         var   txt = 'You pressed Cancel!';
                                        }
                                    
                                    </script>";    
         
                }else if ($_SESSION['id_perfil'] == 36 ){

                    //if ($ip_acceso == '181.65.164.123' || $ip_acceso=='190.236.161.142'){

                          echo "<script>
                
                              var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                
                              if (r == true) {
                                  location.href = '../televenta_v5.php'
                              } else {
                               var   txt = 'You pressed Cancel!';
                              }
                
                              </script>";

                    /*
            
                } 
       
        else {
          echo "<script>

              alert('ACCESO DENEGADO. Estas ingresando desde una red no corporativa de VERISURE. Comunicate con el administrador!');

              </script>";
        }
        */

    }
    
                else if ($_SESSION['id_perfil'] == 55 ){

                    //if ($ip_acceso == '181.65.164.123' || $ip_acceso=='190.236.161.142'){
            
                      echo "<script>
            
                          var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
            
                          if (r == true) {
                              location.href = '../consultadireccion.php'
                          } else {
                           var   txt = 'You pressed Cancel!';
                          }
            
                          </script>";
            
                 /*
                        
                    } 
       
                else {
                  echo "<script>
        
                      alert('ACCESO DENEGADO. Estas ingresando desde una red no corporativa de VERISURE. Comunicate con el administrador!');
        
                      </script>";
                }
                */

                }

                else if ($_SESSION['id_perfil'] == 56 || $_SESSION['id_perfil'] == 57){
            
                    echo "<script>
            
                          var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
            
                          if (r == true) {
                              location.href = '../retencion.php'
                          } else {
                           var   txt = 'You pressed Cancel!';
                          }
            
                          </script>";
            
            
                } 
                
                else if ($_SESSION['id_perfil'] == 66){
            
                    echo "<script>
            
                          var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
            
                          if (r == true) {
                              location.href = '../rpa.php'
                          } else {
                           var txt = 'You pressed Cancel!';
                          }
            
                          </script>";
            
            
                }                 
    
                else {
    
                    if($FechaHoraMODIF=='0' || $FechaHora6MES=='SI'){

?>
                        <div class="alert alert-warning" id="mensaje">
                            <button class="close" data-dismiss="alert"></button>
                            Para continuar debe cambiar su password, presiona <a style="color:red" href="#" onclick="loging(<?php echo $_SESSION['id_usuario']; ?>);return false;"  id="forget-pass">aquí</a>.
                        </div>
<?php
       
                    }else{

                       if($_SESSION['pzwb1']==1){
                            echo "<script> 
                    
                                var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                if (r == true) {
                                    location.href = '../dashboard1.php'
                                } else {
                                 var   txt = 'You pressed Cancel!';
                                }
        
        
                                </script>";
                        }else if($_SESSION['pzwb2']==1){
                            echo "<script> 
    
                            var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                            if (r == true) {
                                location.href = '../dashboard2.php'
                            } else {
                             var   txt = 'You pressed Cancel!';
                            }


                            </script>";

                        }else if($_SESSION['pzwb3']==1){
                                echo "<script> 
                        
                            var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                            if (r == true) {
                                location.href = '../dashboard3.php'
                            } else {
                             var   txt = 'You pressed Cancel!';
                            }
                        
                        
                        </script>";
                        
                        
                        }else if($_SESSION['pzwbfactufoto']==1){
                            echo "<script> 
                                var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                if (r == true) {
                                    location.href = '../dashboardfactufoto.php'
                                } else {
                                 var   txt = 'You pressed Cancel!';
                                }
                            
                            
                            </script>";
                        }else if($_SESSION['pzwbjefatura']==1){
                            if($_SESSION['ccusuario']==599){
                                echo "<script> 
                    
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                    if (r == true) {
                                        location.href = '../dashboard1.php'
                                    } else {
                                     var   txt = 'You pressed Cancel!';
                                    }
                                
                                </script>";            
                            }
                           else if($_SESSION['matriculausuario']=="CD4231" || $_SESSION['matriculausuario']=="HA6658" || $_SESSION['matriculausuario']=="MF6331" || $_SESSION['matriculausuario']=="BK8947" || $_SESSION['matriculausuario']=="DF3030" || $_SESSION['matriculausuario']=="F45995" || $_SESSION['matriculausuario']=="RF6290" || $_SESSION['matriculausuario']=="C37264" || $_SESSION['matriculausuario']=='MJ4599' || $_SESSION['matriculausuario']=='J20612' || $_SESSION['matriculausuario']=='CI8027' || $_SESSION['matriculausuario']=='JS7240' || $_SESSION['matriculausuario']=='J36506' || $_SESSION['matriculausuario']=='JD9721' || $_SESSION['matriculausuario']=='RT5569' || $_SESSION['matriculausuario']=='M76986' || $_SESSION['matriculausuario']=='OK0952' || $_SESSION['matriculausuario']=='CB8533' || $_SESSION['matriculausuario']=='AJ1066'){
                                echo "<script> 
                    
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                    if (r == true) {
                                        location.href = '../dashboard1.php'
                                    } else {
                                     var   txt = 'You pressed Cancel!';
                                    }
                                
                                </script>";            
                            }                            
                            
                            
                            else{
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                        if (r == true) {
                                            location.href = '../jefaturas_v2_pre.php'
                                        } else {
                                         var   txt = 'You pressed Cancel!';
                                        }
                                    
                                    </script>";            
                            }


                        }else if($_SESSION['pzwbvisitas']==1){
                            echo "<script> 

                            var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                if (r == true) {
                                    location.href = '../dashboardvisitas.php'
                                } else {
                                 var   txt = 'You pressed Cancel!';
                                }
                            
                            </script>";

                        }else if($_SESSION['pzwbagenda']==1){
                            echo "<script> 

                            var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                if (r == true) {
                                     location.href = '../dashboardagenda.php'
                                } else {
                                 var   txt = 'You pressed Cancel!';
                                }
                            </script>";

                        }else if($_SESSION['pzvtageneral']==1){
                            echo "<script> 
                            var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                if (r == true) {
                                     location.href = '../venta.php'
                                } else {
                                 var   txt = 'You pressed Cancel!';
                                }
                            
                            </script>";
                        }else if($_SESSION['pzvta150']==1){
                            echo "<script> 
                    
                                var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                    if (r == true) {
                                       location.href = '../ventadc150.php'
                                    } else {
                                     var   txt = 'You pressed Cancel!';
                                    }
                                
                                
                                </script>";
                        }else if($_SESSION['pzvta151']==1){
                            echo "<script> 
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                        if (r == true) {
                                             location.href = '../ventadc151.php'
                                        } else {
                                         var   txt = 'You pressed Cancel!';
                                        }
                                    
                                    </script>";
                        }else if($_SESSION['pzvta152']==1){
                            echo "<script> 
                    
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                        if (r == true) {
                                            location.href = '../ventadc152.php'
                                        } else {
                                         var   txt = 'You pressed Cancel!';
                                        }
                                    
                                    </script>";
                        }else if($_SESSION['pzvta153']==1){
                            echo "<script> 

                            var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                if (r == true) {
                                     location.href = '../ventadc153.php'
                                } else {
                                 var   txt = 'You pressed Cancel!';
                                }
                            
                            </script>";
                            }else if($_SESSION['pzvta154']==1){
                                echo "<script> 
                        
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                        if (r == true) {
                                            location.href = '../ventadc154.php'
                                        } else {
                                         var   txt = 'You pressed Cancel!';
                                        }
                                    
                                    </script>";
                            }else if($_SESSION['pzvta155']==1){
                                echo "<script> 

                                var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                    if (r == true) {
                                        location.href = '../ventadc155.php'
                                    } else {
                                     var   txt = 'You pressed Cancel!';
                                    }
                                
                                </script>";
   
                            }else if($_SESSION['pzvta156']==1){
                                echo "<script> 
                        
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                    if (r == true) {
                                        location.href = '../ventadc156.php'
                                    } else {
                                     var   txt = 'You pressed Cancel!';
                                    }

                                    </script>";
   
                            }else if($_SESSION['pzvta120']==1){
                                echo "<script> 
                        
                                var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                    if (r == true) {
                                        location.href = '../ventadc120.php'
                                    } else {
                                     var   txt = 'You pressed Cancel!';
                                    }
                                
                                </script>";
                            }else if($_SESSION['pzvta40']==1){
                                echo "<script> 
                        
                                var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                    if (r == true) {
                                        location.href = '../ventadc40.php'
                                    } else {
                                     var   txt = 'You pressed Cancel!';
                                    }
                                
                                </script>";
                        
                            }else if($_SESSION['pzvta41']==1){
                                echo "<script> 
                        
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                        if (r == true) {
                                            location.href = '../ventadc41.php'
                                        } else {
                                         var   txt = 'You pressed Cancel!';
                                        }
                                    
                                    </script>";
                        
                            }else if($_SESSION['pzvtatc']==1){
                                echo "<script> 
                        
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                        if (r == true) {
                                            location.href = '../ventadc511.php'
                                        } else {
                                         var   txt = 'You pressed Cancel!';
                                        }
                                    
                                    </script>";
                            }else if($_SESSION['pzmktmarketing']==1){
                                echo "<script> 
                        
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                        if (r == true) {
                                            location.href = '../visita.php'
                                        } else {
                                         var   txt = 'You pressed Cancel!';
                                        }
                                    
                                    </script>"; 
                            }else if($_SESSION['pzmktcgestionados']==1){
                                echo "<script> 
                        
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                        if (r == true) {
                                            location.href = '../tcgestionados.php'
                                        } else {
                                         var   txt = 'You pressed Cancel!';
                                        }
                                    
                                    </script>";
                        
                            }else if($_SESSION['pzmktteleventa']==1){
                                echo "<script> 
                        
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                        if (r == true) {
                                            location.href = '../televenta_v5.php'
                                        } else {
                                         var   txt = 'You pressed Cancel!';
                                        }
                                    
                                    </script>";
                        
                        
                            }else if($_SESSION['pzmkttvgestionados']==1){
                                echo "<script> 
                        
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                        if (r == true) {
                                            location.href = '../tvgestionados.php'
                                        } else {
                                         var   txt = 'You pressed Cancel!';
                                        }
                                    
                                    </script>";
                        
                            
                            }else if($_SESSION['pzageagenda']==1){
                                echo "<script> 
                        
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                        if (r == true) {
                                            location.href = '../agenda.php'
                                        } else {
                                         var   txt = 'You pressed Cancel!';
                                        }
                                    
                                    </script>";
                            }else if($_SESSION['pzageagendapendiente']==1){
                                echo "<script> 
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../agendapendiente.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                            }else if($_SESSION['pzfacfacturacion']==1){
                                    echo "<script> 
                            
                                            var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                                if (r == true) {
                                                    location.href = '../facturacion.php'
                                                } else {
                                                 var   txt = 'You pressed Cancel!';
                                                }
                                            
                                            </script>";
                            }else if($_SESSION['ampgeneral']==1){
                                    echo "<script> 
                            
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../amp.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                            
                            }else if($_SESSION['mktclivtacerti']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../ventacertificada.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                        
                            }else if($_SESSION['ocacceso']==1){
                                echo "<script> 
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../dashboard1.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        
                                        
                                        </script>";
                            }else if($_SESSION['vsconfiguracion']==1){
                                echo "<script> 
                        
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                        if (r == true) {
                                            location.href = '../usuarios.php'
                                        } else {
                                         var   txt = 'You pressed Cancel!';
                                        }
                                    
                                    </script>";
                        
                            }else if($_SESSION['vsconfigestructura']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../usuarioscom.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                        
                            }else if($_SESSION['pzvtaconsulta']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../consultaventa.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                            }else if($_SESSION['pzagegestionados']==1){
                                echo "<script> 
                            
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                        if (r == true) {
                                            location.href = '../agendagestionados.php'
                                        } else {
                                         var   txt = 'You pressed Cancel!';
                                        }
                                    
                                    </script>";
                            }else if($_SESSION['pztecattec']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../attec.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                            }else if($_SESSION['pztecpendiente']==1){
                                echo "<script> 
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../attecpendiente.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                        
                            }else if($_SESSION['pztecconsulta']==1){
                                echo "<script> 
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../consultatecnica.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                        
                        
                            }else if($_SESSION['pzfacinstaladas']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../facturacioninst.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                            }else if($_SESSION['pzfacnodoc']==1){
                                echo "<script> 
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../facturacionnodoc.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                            }else if($_SESSION['pzfacdocenvi']==1){
                                echo "<script> 
                                var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                    if (r == true) {
                                        location.href = '../facturaciondocenvi.php'
                                    } else {
                                     var   txt = 'You pressed Cancel!';
                                    }
                                
                                </script>";
                            }else if($_SESSION['pzfacincidencia']==1){
                                echo "<script> 
                        
                                var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                    if (r == true) {
                                        location.href = '../facturacionincidencia.php'
                                    } else {
                                     var   txt = 'You pressed Cancel!';
                                    }
                                
                                </script>";
                            }else if($_SESSION['pzfacincidenciagestvalija']==1){
                                echo "<script> 
                        
                                var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                    if (r == true) {
                                        location.href = '../facturacionincivalija.php'
                                    } else {
                                     var   txt = 'You pressed Cancel!';
                                    }
                                
                                </script>";
                            }else if($_SESSION['pzfacincidenciagestcorreo']==1){
                                echo "<script> 
                        
                                var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                    if (r == true) {
                                        location.href = '../facturacionincicorreo.php'
                                    } else {
                                     var   txt = 'You pressed Cancel!';
                                    }
                                
                                </script>";
                            }else if($_SESSION['pzfacporfacturar']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../facturacionporfact.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                            }else if($_SESSION['pzfac310']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../facturacion310.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                        
                        
                            }else if($_SESSION['pzfac590']==1){
                                echo "<script> 
                        
                                            var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                                if (r == true) {
                                                    location.href = '../facturacion590.php'
                                                } else {
                                                 var   txt = 'You pressed Cancel!';
                                                }
                                            
                                            </script>";
                        
                        
                            }else if($_SESSION['pzvtadocumento']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../documentos.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                        
                        
                            }else if($_SESSION['pzmdpgeneral']==1){
                                echo "<script> 
                        
                                            var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                                if (r == true) {
                                                    location.href = '../mediodepagos.php'
                                                } else {
                                                 var   txt = 'You pressed Cancel!';
                                                }
                                            
                                            </script>";
                        
                            }else if($_SESSION['pzmdptransaccion']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../mdptransaccion.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                        
                        
                            }else if($_SESSION['pzcallrpporcontactar']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../callrpreferidos.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                        
                            }else if($_SESSION['pzcallrpporasignar']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../callrpporasignar.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                        
                            }else if($_SESSION['pzcallrpbacklog']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../callrpbacklog.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                        
                            }else if($_SESSION['pzcallrpgestionado']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../callrpgestionados.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                        
                        
                            }else if($_SESSION['pzmktb12']==1){
                                echo "<script> 
                        
                                    var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                        if (r == true) {
                                            location.href = '../visitaexterna.php'
                                        } else {
                                         var   txt = 'You pressed Cancel!';
                                        }
                                    
                                    </script>";
                        
                        
                            }else if($_SESSION['pzmktporasignar']==1){
                                echo "<script> 
                        
                                var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                    if (r == true) {
                                        location.href = '../asignarvisita.php'
                                    } else {
                                     var   txt = 'You pressed Cancel!';
                                    }
                                
                                </script>";
                        
                            }else if($_SESSION['pzvtareporte']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../reportes.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                        
                        
                            }else if($_SESSION['pzvtamultimedia']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../multimedia.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                            }else if($_SESSION['vscobporfolio']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../porfolio.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                        
                            }else if($_SESSION['vscobcartera']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../reclamos.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                            }else if($_SESSION['vscobpago']==1){
                                echo "<script> 
                        
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../carterapago.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        
                                        </script>";
                        
                            }else if($_SESSION['pzforconsulta']==1){
                                echo "<script> 
                                        var r = confirm('Está accediendo a un sistema propiedad de VERISURE PERU SAC. Necesita tener autorización antes de usarlo, estando usted estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a este sistema o el uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente.Si usted revela información interna de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa, que podría incluso suponer la posible comisión de un delito o falta.','Modified title');
                                            if (r == true) {
                                                location.href = '../consultaformador.php'
                                            } else {
                                             var   txt = 'You pressed Cancel!';
                                            }
                                        </script>";
                            }else {
        
                            }

                            $Url = sanitizaCampo($_SERVER['REQUEST_URI'], 'sanitizeurl|scapestring|htmlspecialchars',$con);
                            $Modificar = 'Login';
                            $Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                            
                            $result_exec= $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
                            $result_exec->bind_param('ssssss',$ip_acceso,$_SESSION['usuariosesion'],$fecharegistro,$Url,$Modificar,$Navegador);
                            $result_exec->execute();
                            $result_exec->close();


    }
                } //END IF PERFIL COBRANZA
            } //END PASSWORD VERIFY
            else {
?>
                <div class="alert alert-warning">
                    <button class="close" data-dismiss="alert"></button>
                    <span>El password es incorrecto.</span>
                </div>
<?php
            }

        } //END ESTADO USUARIO
 
        else if($estadousuario==='Bloqueado'){
?>
            <div class="alert alert-danger">
                <button class="close" data-dismiss="alert"></button>
                <span>Su cuenta ha sido bloqueada.</span>
            </div>
<?php 
        }
        else{
?>
            <div class="alert alert-danger">
                <button class="close" data-dismiss="alert"></button>
                <span>Su cuenta ha sido deshabilitada.</span>
            </div>
            <?php 
        }
        }

    } //END ROWS MAYOR QUE 0
    else{
?>
        <div class="alert alert-warning">
            <button class="close" data-dismiss="alert"></button>
            <span>No se encontró ningún usuario.</span>
        </div>
<?php
  
    }
    
    $result_pass->close();
    
?>