// Type definitions for ag-grid v15.0.0
// Project: http://www.ag-grid.com/
// Definitions by: Niall Crosby <https://github.com/ag-grid/>
import { BorderLayout } from "../layout/borderLayout";
import { LoggerFactory } from "../logger";
import { BeanStub } from "../context/beanStub";
import { RowContainerComponent } from "../rendering/rowContainerComponent";
export interface RowContainerComponents {
    fullWidth: RowContainerComponent;
    body: RowContainerComponent;
    pinnedLeft: RowContainerComponent;
    pinnedRight: RowContainerComponent;
    floatingTop: RowContainerComponent;
    floatingTopPinnedLeft: RowContainerComponent;
    floatingTopPinnedRight: RowContainerComponent;
    floatingTopFullWidth: RowContainerComponent;
    floatingBottom: RowContainerComponent;
    floatingBottomPinnedLeft: RowContainerComponent;
    floatingBottomPinnedRight: RowContainerComponent;
    floatingBottomFullWith: RowContainerComponent;
}
export declare class GridPanel extends BeanStub {
    private alignedGridsService;
    private gridOptionsWrapper;
    private columnController;
    private rowRenderer;
    private pinnedRowModel;
    private eventService;
    private context;
    private animationFrameService;
    private navigationService;
    private paginationProxy;
    private columnApi;
    private gridApi;
    private rangeController;
    private dragService;
    private selectionController;
    private clipboardService;
    private csvCreator;
    private mouseEventService;
    private focusedCellController;
    private $scope;
    private scrollVisibleService;
    private contextMenuFactory;
    private frameworkFactory;
    private valueService;
    private componentRecipes;
    private layout;
    private logger;
    private eBodyViewport;
    private eRoot;
    private eBody;
    private rowContainerComponents;
    private eBodyContainer;
    private ePinnedLeftColsContainer;
    private ePinnedRightColsContainer;
    private eFullWidthCellViewport;
    private eFullWidthCellContainer;
    private ePinnedLeftColsViewport;
    private ePinnedRightColsViewport;
    private eBodyViewportWrapper;
    private eHeaderContainer;
    private eHeaderOverlay;
    private ePinnedLeftHeader;
    private ePinnedRightHeader;
    private eHeader;
    private eHeaderViewport;
    private eFloatingTop;
    private ePinnedLeftFloatingTop;
    private ePinnedRightFloatingTop;
    private eFloatingTopContainer;
    private eFloatingTopViewport;
    private eFloatingTopFullWidthCellContainer;
    private eFloatingBottom;
    private ePinnedLeftFloatingBottom;
    private ePinnedRightFloatingBottom;
    private eFloatingBottomContainer;
    private eFloatingBottomViewport;
    private eFloatingBottomFullWidthCellContainer;
    private eAllCellContainers;
    private scrollLeft;
    private nextScrollLeft;
    private scrollTop;
    private nextScrollTop;
    private verticalRedrawNeeded;
    private bodyHeight;
    private enableRtl;
    private forPrint;
    private autoHeight;
    private scrollWidth;
    private pinningRight;
    private pinningLeft;
    private useAnimationFrame;
    agWire(loggerFactory: LoggerFactory): void;
    getVerticalPixelRange(): {
        top: number;
        bottom: number;
    };
    destroy(): void;
    private onRowDataChanged();
    private showOrHideOverlay();
    getLayout(): BorderLayout;
    private init();
    private addStopEditingWhenGridLosesFocus();
    private addAngularApplyCheck();
    private disableBrowserDragging();
    private addEventListeners();
    private addDragListeners();
    private addMouseListeners();
    private addKeyboardEvents();
    private addBodyViewportListener();
    private getRowForEvent(event);
    private processKeyboardEvent(eventName, keyboardEvent);
    scrollToTop(): void;
    private processMouseEvent(eventName, mouseEvent);
    private mockContextMenuForIPad();
    private handleContextMenuMouseEvent(mouseEvent, touchEvent, rowComp, cellComp);
    private onContextMenu(mouseEvent, touchEvent, rowNode, column, value);
    private preventDefaultOnContextMenu(mouseEvent);
    private addShortcutKeyListeners();
    private onCtrlAndA(event);
    private onCtrlAndC(event);
    private onCtrlAndV(event);
    private onCtrlAndD(event);
    ensureIndexVisible(index: any, position?: string): void;
    getPrimaryScrollViewport(): HTMLElement;
    getCenterWidth(): number;
    isHorizontalScrollShowing(): boolean;
    private isVerticalScrollShowing();
    private isBodyVerticalScrollShowing();
    periodicallyCheck(): void;
    private setScrollShowing();
    private setBottomPaddingOnPinnedRight();
    private setMarginOnFullWidthCellContainer();
    ensureColumnVisible(key: any): void;
    showLoadingOverlay(): void;
    showNoRowsOverlay(): void;
    hideOverlay(): void;
    private getWidthForSizeColsToFit();
    sizeColumnsToFit(nextTimeout?: number): void;
    getBodyContainer(): HTMLElement;
    getDropTargetBodyContainers(): HTMLElement[];
    getBodyViewport(): HTMLElement;
    getDropTargetLeftContainers(): HTMLElement[];
    getDropTargetPinnedRightContainers(): HTMLElement[];
    getHeaderContainer(): HTMLElement;
    getHeaderOverlay(): HTMLElement;
    getRoot(): HTMLElement;
    getPinnedLeftHeader(): HTMLElement;
    getPinnedRightHeader(): HTMLElement;
    private queryHtmlElement(selector);
    private loadTemplate();
    private findElements();
    private suppressScrollOnFloatingRow();
    getRowContainers(): RowContainerComponents;
    private addMouseWheelEventListeners();
    getHeaderViewport(): HTMLElement;
    private centerMouseWheelListener(event);
    genericMouseWheelListener(event: any): boolean;
    private generalMouseWheelListener(event, targetPanel);
    onDisplayedColumnsChanged(): void;
    private onDisplayedColumnsWidthChanged();
    private onScrollVisibilityChanged();
    private setWidthsOfContainers();
    private setPinnedLeftWidth();
    private setPinnedRightWidth();
    private setPinnedContainersVisible();
    setBodyAndHeaderHeights(): void;
    getBodyHeight(): number;
    setHorizontalScrollPosition(hScrollPosition: number): void;
    scrollHorizontally(pixels: number): number;
    private addScrollListener();
    private onBodyScroll();
    private onBodyHorizontalScroll();
    private doHorizontalScroll();
    private onBodyVerticalScroll();
    private onVerticalScroll(sourceElement);
    executeFrame(): boolean;
    private redrawRowsAfterScroll();
    private isBodyVerticalScrollActive();
    private addIEPinFix(onPinnedRightScroll, onPinnedLeftScroll);
    setLeftAndRightBounds(): void;
    getBodyViewportScrollLeft(): number;
    setBodyViewportScrollLeft(value: number): void;
    horizontallyScrollHeaderCenterAndFloatingCenter(): void;
    private fakeVerticalScroll(position);
    private setFakeScroll(eContainer, pixels);
    addScrollEventListener(listener: () => void): void;
    removeScrollEventListener(listener: () => void): void;
}
