<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}

$ingresokit=0;
$ingresoextras=0;
$ingresototal=0;

require '../config/db.php';
require '../config/conexion.php';
//LOGS TRANSACCCIONALES
include 'log/insertLog.php'; //LOG TRANSAC
include 'log/insertLogCliente.php'; //LOG CLIENTE
include 'log/insertLogProsectoRP.php'; //LOG PROSPECTORP
include 'log/insertLogFacturacion.php'; //LOG FACTURACION
include 'log/insertLogAgenda.php'; //LOG AGENDA
include 'log/insertLogVenta.php'; //LOG VENTA

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

$categoria=htmlspecialchars($_POST['lblcategoria']); //listo
$idprospectorp=htmlspecialchars($_POST['lblidprospectorp']);//listo
$gestor=htmlspecialchars($_POST['gestor']);//listo

$matricula=htmlspecialchars($_POST['lblmatricula']);//listo
$idusuario=htmlspecialchars($_POST['lblidusuario']);//listo
$nombcomercial=htmlspecialchars($_POST['lblnombcomercial']);//listo
$dc=htmlspecialchars($_POST['lbldc']);//listo
$jefeventa=htmlspecialchars($_POST['lbljefeventa']);//listo
$estadoprospecto=htmlspecialchars($_POST['lblestadoprospecto']);
$estadoventa=htmlspecialchars($_POST['lblestventa']);
$tipoventa=htmlspecialchars($_POST['lbltiventa']);
$segmento=htmlspecialchars($_POST['lblsegmento']);

$mesesautorizados=htmlspecialchars($_POST['lblmesesautorizados']);
$preciokit=htmlspecialchars($_POST['lblpreciokit']);
$totalextra=htmlspecialchars($_POST['lbltotalextra']);
$resumenventa=htmlspecialchars($_POST['lblresumenventa']);
$extraautorizado=htmlspecialchars($_POST['lblextraautorizado']);
$formadepago=htmlspecialchars($_POST['lblformadepago']);
//INFORMACION ADICIONAL DE LA VENTA AGREGADA POR PILOTO ZEROVISION
$lbltipokit=htmlspecialchars($_POST['lbltipokit']);
$lblclosingpack=htmlspecialchars($_POST['lblclosingpack']);
$lblprecioEspecial=htmlspecialchars($_POST['lblprecioEspecial']);
$lblCantExtras=htmlspecialchars($_POST['lblCantExtras']);
$lblresultadoScoring=htmlspecialchars($_POST['lblresultadoScoring']);
//FIN INFORMACION ADICIONAL
$PAI=htmlspecialchars($_POST['lblPAI']);   
$comentarioprospecto=$_POST['lblcomentarioprospecto'];
//---Fechas_de_registros--
$GestionOrigen = 'VENTA';
$fecharegistro = date("Y-m-d H:i:s");
//ARRAY DATOS DEL PROSPECTO A MODIFICAR
$arrayProspectoRP = consultaProspectoRP($idprospectorp);
$lbljsonresumenventa=$_POST['lbljsonresumenventa'];
$GGCC=htmlspecialchars($_POST['hidGGCC']);

$IdDocRP=htmlspecialchars($_POST['IdDocRP']);
$tipodoc=htmlspecialchars($_POST['lbltipodoc']);
$documento=htmlspecialchars($_POST['lbldocumento']);

//DOCUMENTO
if ($IdDocRP == NULL){
     $resultadoDocumento = insertarDocumento();
     if ($resultadoDocumento > 0){
     $IdDocRP=$resultadoDocumento;
     }else{
     $IdDocRP=NULL;  
     }
     
}else{
    $resultadoDocumento = actualizarDocumento($IdDocRP);
    if ($resultadoDocumento > 0){
    }else{
    }
}

if($categoria=='ProspectoRP'){
    
    //---Cliente--
    $idcliente=$_POST['lblidcliente'];
    $nombcliente=$_POST['lblnombcliente'];
    $correo=$_POST['lblcorreo'];
    $direccion=$_POST['lbldireccion'];
    $distrito=$_POST['lbldistrito'];
    $telefonouno=$_POST['lblmovil'];
    $telefonodos=$_POST['lblfijo'];
    $representante=$_POST['lblrepresentante'];
    
    //---Termina Cliente---
    
    //CREACION DEL ARRAY QUE TRAE DATOS DEL CLIENTE
    $arrayCliente = consultaCliente($idcliente);
    
    //ACTUALIZA DATOS DEL CLIENTE RP
    if($telefonodos=="" || empty($telefonodos)){
        //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
        $affectedrowCliente=actualizarCliente($distrito,$nombcliente,$telefonouno,NULL,$correo,$direccion,$representante,$idcliente);

    }else{
        //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
        $affectedrowCliente=actualizarCliente($distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,$representante,$idcliente);
    }
    
    //ACTUALIZA DATOS EN LA TABLA PROSPECTORP
    $affectedrowProspectoRP =updateProspectoRP($idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,NULL,$extraautorizado,$mesesautorizados,NULL,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$lbljsonresumenventa,$GGCC,$idprospectorp);    
    //INSERTA LOG DE SEGURIDA POR TRANSACCION (MODIFICAR)
    
    if($affectedrowCliente > 0 || $affectedrowProspectoRP > 0 ){

            $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
            $usuariosesion=$_SESSION['usuariosesion'];
            $REQUEST_URI=$_SERVER['REQUEST_URI'].'=>IdProspectoRP='.$idprospectorp;
            $Acceso='Modificar';
            $HTTP_USER_AGENT=$_SERVER['HTTP_USER_AGENT'];
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              
              $idLogSeg = $con->insert_id;
              
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            }  
        
        if($affectedrowCliente > 0){
            insertarLog($idLogSeg, $arrayCliente);
        }
        if($affectedrowProspectoRP > 0){
            insertLogProspectoRP($idLogSeg, $arrayProspectoRP);
        }

        $respuesta = array(
                        'respuesta' => 5
                    );
        die(json_encode($respuesta));
    }else{
             $respuesta = array(
                        'respuesta' => 20
                    );
        die(json_encode($respuesta));
    }
}
else if($categoria=='Ficha' || $categoria=='Evaluacion' || $categoria=='Cotizacion'){
    $n590=$_POST['lbl590'];
    //---Cliente--
    $idcliente=$_POST['lblidcliente'];
    $nombcliente=$_POST['lblnombcliente'];
    $correo=$_POST['lblcorreo'];
    $direccion=$_POST['lbldireccion'];
    $distrito=$_POST['lbldistrito'];
    $telefonouno=$_POST['lblmovil'];
    $telefonodos=$_POST['lblfijo'];
    $representante=$_POST['lblrepresentante'];
    //---Termina Cliente---
    
    //CREACION DEL ARRAY QUE TRAE DATOS DEL CLIENTE
    $arrayCliente = consultaCliente($idcliente);
    
    //VERIFICA QUE EXISTA EL ID PROSPECTO EN LA TABLA VENTA

   try{
        $stmtValP = $con->prepare( "SELECT 1 FROM dbVENTAS.tblventa v WHERE v.IdProspectoRP= ?");
        $stmtValP->bind_param('i', $idprospectorp);
        $stmtValP->execute();
        $stmtValP->store_result();
        $stmtValP->bind_result($num);
        $numrows=$stmtValP->num_rows;
        $stmtValP->fetch();       
        $stmtValP->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    } 
    
    if($numrows>0){
              $respuesta = array(
                        'respuesta' => 2
                    );
        die(json_encode($respuesta));
    }else{
        
        //ACTUALIZA DATOS DEL CLIENTE RP
        if($telefonodos=="" || empty($telefonodos)){
            $affectedrowCliente=actualizarCliente($distrito,$nombcliente,$telefonouno,NULL,$correo,$direccion,$representante,$idcliente);
        }
        else{
            $affectedrowCliente=actualizarCliente($distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,$representante,$idcliente);
        }  
        
         //ACTUALIZA DATOS DEL PROSPECTORP EN LA TABLA PROSPECTORP

        $affectedrowProspectoRP =updateProspectoRP($idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,$estadoventa,$extraautorizado,$mesesautorizados,$n590=null,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$lbljsonresumenventa,$GGCC,$idprospectorp);
        
        $arrayVenta = consultaVentaIProspecto();
        //INSERTA DATOS DEL PROSPECTORP EN LA TABLA VENTAS
        $idVen = insertarVenta($idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$ingresokit,$ingresoextras,$ingresototal,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$fecharegistro,$gestor,$dc,$preciokit,$totalextra,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$idprospectorp, $lbltipokit, $lblCantExtras, $lbltipokit, $lblclosingpack, $lblprecioEspecial, $lblCantExtras, $lblresultadoScoring,$lbljsonresumenventa,$GGCC);
        
        $arrayAgenda=consultaAgendaI();
        //INSERTA DATOS DEL PROSPECTORP EN LA TABLA AGENDA
           try{
                $stmtAgenda = $con->prepare( "INSERT INTO dbVENTAS.tblagenda(IdVenta,FechaHoraREG, GestionOrigen) VALUES (?,?, ?)");
                $stmtAgenda->bind_param('iss', $idVen,$fecharegistro,$GestionOrigen);
                $stmtAgenda->execute();
                $stmtAgenda->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            } 
        
        
        $arrayFactu=consultaFacturacionI();
        //INSERTA DATOS DEL PROSPECTORP EN LA TABLA FACTURACION
           try{
                $stmtFact = $con->prepare( "INSERT INTO dbVENTAS.tblfacturacion(IdVenta, FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
                $stmtFact->bind_param('iss', $idVen,$fecharegistro,$GestionOrigen);
                $stmtFact->execute();
                $stmtFact->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }  
        
        
        if($affectedrowCliente > 0 || $affectedrowProspectoRP > 0 ){
        //GENERA LOG DE PROSPECTO HISTORICO
           try{
                $stmtProshist = $con->prepare( "INSERT INTO dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,Gestor) values(?,?,?,?,?,?)");
                $stmtProshist->bind_param('isssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$gestor);
                $stmtProshist->execute();
                $stmtProshist->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }        
        
        
        //GENERA LOG DE SEGURIDAD
            $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
            $usuariosesion=$_SESSION['usuariosesion'];
            $REQUEST_URI=$_SERVER['REQUEST_URI'].'=>IdVenta='.$idVen;
            $Acceso='Modificar';
            $HTTP_USER_AGENT=$_SERVER['HTTP_USER_AGENT'];
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              
              $idLogSeg = $con->insert_id;
              
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            }       

        
        if($affectedrowCliente > 0){
            insertarLog($idLogSeg, $arrayCliente);
        }
        if($affectedrowProspectoRP > 0){
            insertLogProspectoRP($idLogSeg, $arrayProspectoRP);
        }
        
        insertLogVentaIProspecto($idLogSeg, $arrayVenta);

        insertLogAgendaI($idLogSeg, $arrayAgenda);
        insertLogFacutracionI($idLogSeg, $arrayFactu);
        
        //ENVIA RESULTADO    
                $respuesta = array(
                        'respuesta' => 6,
                        'idventa'=>$idVen
                    );
        die(json_encode($respuesta));        
        
        }

    }
    //CIERRA CONSULTA
    $resultado->close();
}
else if($categoria=='Delegacion'){
    $n590=$_POST['lbl590'];
    //---Cliente--
    $idcliente=$_POST['lblidcliente'];
    $nombcliente=$_POST['lblnombcliente'];
    $correo=$_POST['lblcorreo'];
    $direccion=$_POST['lbldireccion'];
    $distrito=$_POST['lbldistrito'];
    $telefonouno=$_POST['lblmovil'];
    $telefonodos=$_POST['lblfijo'];
    $representante=$_POST['lblrepresentante'];
    //---Termina Cliente---    
    
    //---Agenda--
    $instaladox=$_POST['lblinstaladox'];
    $tecnico=$_POST['lbltecnico'];
    $finstalacion=$_POST['lblfinstalacion'];
    $hinstalacion=$_POST['lblhinstalacion'];
    $fechaconvert=  myUrlEncode($finstalacion);
    $fechagrabar=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvert));
    $horaconvert=  myUrlEncode($hinstalacion);
    $horagrabar=  date("H:i", strtotime(str_replace("+"," ",$horaconvert)));
    $horagrabarcomparar=  date("H:i:s", strtotime(str_replace("+"," ",$horaconvert)));
    $comentarioagenda=$_POST['lblcomentarioagenda'];
    //---Termina Agenda---
    
    //CREACION DEL ARRAY QUE TRAE DATOS DEL CLIENTE
    $arrayCliente = consultaCliente($idcliente);
    
    
    
    
    //VALIDA QUE EXISTE EL PROSECTO EN LA TABLA VENTAS

   try{
        $stmtValP = $con->prepare( "SELECT 1 FROM dbVENTAS.tblventa v WHERE v.IdProspectoRP= ?");
        $stmtValP->bind_param('i', $idprospectorp);
        $stmtValP->execute();
        $stmtValP->store_result();
        $stmtValP->bind_result($num);
        $numrows=$stmtValP->num_rows;
        $stmtValP->fetch();       
        $stmtValP->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }     
    
    if($numrows>0){
              $respuesta = array(
                        'respuesta' => 2
                    );
        die(json_encode($respuesta));
    }else{
        
        //ACTUALIZA DATOS DEL PROSPECTORP EN LA TABLA PROSPECTORP
        $affectedrowProspectoRP =updateProspectoRP($idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$lbljsonresumenventa,$GGCC,$idprospectorp);
        //ACTUALIZA DATOS DEL CLIENTE
        if($telefonodos=="" || empty($telefonodos)){
            $affectedrowCliente=actualizarCliente($distrito,$nombcliente,$telefonouno,NULL,$correo,$direccion,$representante,$idcliente);
        }
        else{
            $affectedrowCliente=actualizarCliente($distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,$representante,$idcliente);
            
        }
        
        //INSERTA DATOS DEL PROSPECTORP EN LA TABLA VENTAS
        $arrayVenta = consultaVentaIProspecto();
        
        $idVen = insertarVenta($idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$ingresokit,$ingresoextras,$ingresototal,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$fecharegistro,$gestor,$dc,$preciokit,$totalextra,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$idprospectorp, $lbltipokit, $lblCantExtras, $lbltipokit, $lblclosingpack, $lblprecioEspecial, $lblCantExtras, $lblresultadoScoring,$lbljsonresumenventa,$GGCC);
        
        //INSERTA DATOS EN LA TABLA AGENDA (NUEVO REGISTRO)
        
        if(empty($finstalacion) && empty($hinstalacion) ){
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA AGENDA
            $arrayAgenda=consultaAgendaProspectoRP();
            
            $idagendahis=registrarAgenda($idVen,NULL,NULL,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa, $GestionOrigen);
            $sqlagendahist=registrarAgendaHistorico($idagendahis,$idVen,NULL,NULL,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa);

            
        }else if(empty($finstalacion)){
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA AGENDA
            $arrayAgenda=consultaAgendaProspectoRP();
            $idagendahis=registrarAgenda($idVen,$fechagrabar,NULL,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa, $GestionOrigen);
            $sqlagendahist=registrarAgendaHistorico($idagendahis,$idVen,$fechagrabar,NULL,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa);
                
        }else if(empty($hinstalacion)){
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA AGENDA
            $arrayAgenda=consultaAgendaProspectoRP();

            $idagendahis=registrarAgenda($idVen,NULL,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa, $GestionOrigen);
            $sqlagendahist=registrarAgendaHistorico($idagendahis,$idVen,NULL,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa);        
            
        }else{
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA AGENDA
            $arrayAgenda=consultaAgendaProspectoRP();

            $idagendahis=registrarAgenda($idVen,$fechagrabar,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa, $GestionOrigen);
            $sqlagendahist=registrarAgendaHistorico($idagendahis,$idVen,$fechagrabar,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa);  
        
        }
        
        //INSERTA DATOS DEL PROSECTORP EN LA TABLA FACTURACION
        $arrayFactu=consultaFacturacionI();
           try{
                $stmtFact = $con->prepare( "INSERT INTO dbVENTAS.tblfacturacion(IdVenta, FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
                $stmtFact->bind_param('iss', $idVen,$fecharegistro,$GestionOrigen);
                $stmtFact->execute();
                $stmtFact->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }  
        
        
        //GENERA LOG DE HISTORICO DE PROSPECTORP
           try{
                $stmtProshist = $con->prepare( "INSERT INTO dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,Gestor) values(?,?,?,?,?,?)");
                $stmtProshist->bind_param('isssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$gestor);
                $stmtProshist->execute();
                $stmtProshist->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }   
    
        //GENERA LOG DE SEGURIDAD
            $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
            $usuariosesion=$_SESSION['usuariosesion'];
            $REQUEST_URI=$_SERVER['REQUEST_URI'].'=>IdVenta='.$idVen;
            $Acceso='Modificar';
            $HTTP_USER_AGENT=$_SERVER['HTTP_USER_AGENT'];
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              
              $idLogSeg = $con->insert_id;
              
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            } 
        
        
               
    if($affectedrowProspectoRP > 0){
        insertLogProspectoRP($idLogSeg, $arrayProspectoRP);
    }    
    if($affectedrowCliente > 0){
        insertarLog($idLogSeg, $arrayCliente);
    }
    
        insertLogVentaIProspecto($idLogSeg, $arrayVenta);
        insertLogAgendaProspectoRP($idLogSeg, $arrayAgenda);
        insertLogFacutracionI($idLogSeg, $arrayFactu);

        //ENVIA RESULTADO    
                $respuesta = array(
                        'respuesta' => 7,
                        'idventa'=>$idVen
                    );
        die(json_encode($respuesta));
        
    }
    //CIERRA CONSULTA
    $resultado->close();
}
else if($categoria=='NoVendida'){
    
    //---Cliente--
    $idcliente=$_POST['lblidcliente'];
    $nombcliente=$_POST['lblnombcliente'];
    $correo=$_POST['lblcorreo'];
    $direccion=$_POST['lbldireccion'];
    $distrito=$_POST['lbldistrito'];
    $telefonouno=$_POST['lblmovil'];
    $telefonodos=$_POST['lblfijo'];
    $representante=$_POST['lblrepresentante'];
    //---Termina Cliente---
    
    //CREACION DEL ARRAY QUE TRAE DATOS DEL CLIENTE
    $arrayCliente = consultaCliente($idcliente);
    
    //ACTUALIZA DATOS DEL PROSPECTORP EN LA TABLA CLIENTE
    if($telefonodos=="" || empty($telefonodos)){
        $affectedrowCliente=actualizarCliente($distrito,$nombcliente,$telefonouno,NULL,$correo,$direccion,$representante,$idcliente);
    }else{
        $affectedrowCliente=actualizarCliente($distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,$representante,$idcliente);
    }
    
    //ACTUALIZA DATOS DEL PROSPECTORP EN LA TABLA PROSPECTORP
    $affectedrowProspectoRP =updateProspectoRP($idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,NULL,$extraautorizado,$mesesautorizados,NULL,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$lbljsonresumenventa,$GGCC,$idprospectorp);
    
    //GENERA LOG DE SEGURIDAD
    if($affectedrowCliente > 0 || $affectedrowProspectoRP > 0 ){
    //GENERA HISTORICO DEL PROSPECTORP
           try{
                $stmtProshist = $con->prepare( "INSERT INTO dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,Gestor) values(?,?,?,?,?,?)");
                $stmtProshist->bind_param('isssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$gestor);
                $stmtProshist->execute();
                $stmtProshist->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            } 

            $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
            $usuariosesion=$_SESSION['usuariosesion'];
            $REQUEST_URI=$_SERVER['REQUEST_URI'].'=>IdProspectoRP='.$idprospectorp;
            $Acceso='Modificar';
            $HTTP_USER_AGENT=$_SERVER['HTTP_USER_AGENT'];
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              
              $idLogSeg = $con->insert_id;
              
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            }     
    
    
    if($affectedrowCliente > 0){
    insertarLog($idLogSeg, $arrayCliente);
    }
    if($affectedrowProspectoRP > 0){
        insertLogProspectoRP($idLogSeg, $arrayProspectoRP);
    }

        //ENVIA RESULTADO    
                $respuesta = array(
                        'respuesta' => 5,
                        'idventa'=>$idVen
                    );
        die(json_encode($respuesta));    

    }else{
             //ENVIA RESULTADO    
                $respuesta = array(
                        'respuesta' => 20
                    );
        die(json_encode($respuesta));
    }
}


function actualizarCliente($distrito,$nombcliente,$telefonouno,$telefonodos=null,$correo,$direccion,$representante,$idcliente){
global $con;

  try{
        $stmt = $con->prepare("UPDATE dbVENTAS.tblcliente c SET c.IdGeografico=?,c.NombApellido=?,c.Telefonouno=?,c.Telefonodos=?,c.Correo=?,c.Direccion=?,c.Representante=? WHERE c.IdCliente=?");
        $stmt->bind_param('issssssi', $distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,$representante,$idcliente);
        
        $stmt->execute();

        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 0;
    }
    return $respuesta;

}

function updateProspectoRP($idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,$estadoventa=null,$extraautorizado,$mesesautorizados,$n590=null,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$lbljsonresumenventa,$GGCC,$idprospectorp){
global $con;
  try{
        $stmt = $con->prepare("UPDATE dbVENTAS.tblprospectorp p SET 
p.IdUsuario=?,
p.IdCliente=?,
p.Matricula=?,
p.Comercial=?,
p.CC=?,
p.JefeVenta=?,
p.CategoriaVenta=?,
p.TipoVenta=?,
p.Segmento=?,
p.PrecioKit=?,
p.TotalExtra=?,
p.EstadoProspecto=?,
p.EstadoVenta=?,
p.ExtraAutorizado=?,
p.MesesAutorizado=?,
p.N590=?,
p.FormaPago=?,
p.PAI=?,
p.ResumenProspecto=?,
p.ComentarioProspectoRP=?,
p.TipoKIT=?,
p.ClosingPack=?,
p.PrecioEspecial=?,
p.CantidadExtras=?,
p.ScoringRP=?,
p.objCotizacion=?,
p.GGCC=?
 WHERE p.IdProspectoRP=?");
        $stmt->bind_param('iississssddssssssssssssssssi', $idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$lbljsonresumenventa,$GGCC,$idprospectorp);
        
        $stmt->execute();

        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 0;
    }
    return $respuesta;

}


//Funcion nueva Documento
function insertarDocumento(){
    global $con;
    global $tipodoc, $documento, $fecharegistro;
    if(empty($tipodoc) && empty($documento)){
        return 0;
    }else{
        try {
    
          $stmt = $con->prepare("INSERT INTO dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES(?, ?, ?)");
          $stmt->bind_param('sss', $tipodoc,$documento,$fecharegistro);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
    
        return $respuesta;
    }

}

function actualizarDocumento($IdDocRP){
    global $con;
    global $tipodoc, $documento;
    if(empty($tipodoc) && empty($documento)){
        return 0;
    }else{
          try{
        $stmt = $con->prepare("UPDATE tbldocumento SET TipoDocumento=?, Documento=? WHERE IdDoc = ?");
        $stmt->bind_param('ssi', $tipodoc, $documento, $IdDocRP);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();  
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    return $respuesta;  
    }
}


//Funcion nueva Cliente
function actualizarClienteDoc($idcliente){
    global $con;

    global $nombcliente, $correo, $direccion, $distrito, $telefonouno, $telefonodos, $segmento,$IdDocRP, $Referencia, $interior, $objGeofinder;

    try{
        $stmt = $con->prepare("UPDATE dbVENTAS.tblcliente SET IdGeografico = ?, NombApellido = ?, Correo = ?, Direccion = ?, Telefonouno = ?, Telefonodos=?, Segmento=?,IdDocVisita=?, Referencia=?, Interior=?, objGeofinder=? WHERE IdCliente = ?");
        $stmt->bind_param("issssssisssi", $distrito, $nombcliente, $correo, $direccion, $telefonouno, $telefonodos, $segmento,$IdDocRP, $Referencia, $interior, $objGeofinder, $idcliente);
        $stmt->execute();

        $rows = $stmt->affected_rows;

        if ($rows > 0) {
            $respuesta = array(
                'respuesta' => 'exito',
                'id_actualizado' => $idcliente,
                'tipo' => 'cliente'
            );
        } else {
            $respuesta = array(
                'respuesta' => 'nada',
                'tipo' => 'cliente'
            );
        }
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error',
            'mensaje' => $e->getMessage(),
            'tipo' => 'cliente'
        );
    }

    return $respuesta;
}

function insertarVenta($idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$ingresokit,$ingresoextras,$ingresototal,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$fecharegistro,$gestor,$dc,$preciokit,$totalextra,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$idprospectorp, $lbltipokit, $lblCantExtras, $lbltipokit, $lblclosingpack, $lblprecioEspecial, $lblCantExtras, $lblresultadoScoring,$lbljsonresumenventa,$GGCC){
    global $con;
        try {
    
          $stmt = $con->prepare("INSERT INTO dbVENTAS.tblventa(IdUsuario,IdCliente,Matricula,Comercial,CC,JefeVenta,CategoriaVenta,TipoVenta,Segmento,PrecioKit,TotalExtra,IngresoKIT,IngresoExtras,IngresoTotal,EstadoVenta,ExtraAutorizado,MesesAutorizado,N590,FormaPago,PAI,ResumenVenta,FechaHoraREG,GestorOrigen,CCOriginal,PrecioKITOriginal,TotalExtraOriginal,ExtraAutorizadoOriginal,MesesAutorizadoOriginal,FormaPagoOriginal,PAIOriginal,ResumenVentaOriginal,IdProspectoRP, TipoKIT, CantidadExtras, TipoKITOriginal, ClosingPack, PrecioEspecial, CantidadExtrasOriginal, ScoringRP,objCotizacion,GGCC) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
          $stmt->bind_param('iississssdddddsssssssssiddsssssisissdssss', $idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$ingresokit,$ingresoextras,$ingresototal,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$fecharegistro,$gestor,$dc,$preciokit,$totalextra,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$idprospectorp, $lbltipokit, $lblCantExtras, $lbltipokit, $lblclosingpack, $lblprecioEspecial, $lblCantExtras, $lblresultadoScoring,$lbljsonresumenventa,$GGCC);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
        return $respuesta;
}

function registrarAgenda($idVen,$fechagrabar=NULL,$horagrabar=NULL,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa, $GestionOrigen){
global $con;
  try{
        $stmt = $con->prepare("INSERT INTO dbVENTAS.tblagenda(IdVenta,FechaInst,HoraInst, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta,GestionOrigen) VALUES (?,?,?,?,?,?,?,?,?, ?)");
        $stmt->bind_param('isssssssss', $idVen,$fechagrabar,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa, $GestionOrigen);
        
        $stmt->execute();

        $respuesta = $con->insert_id;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 0;
    }
    return $respuesta;

}

function registrarAgendaHistorico($idagendahis,$idVen,$fechagrabar=NULL,$horagrabar=NULL,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa){
global $con;
  try{
        $stmt = $con->prepare("INSERT INTO dbVENTAS.tblagendahist(IdAgenda, IdVenta,FechaInst,HoraInst, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES (?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iissssssss', $idagendahis,$idVen,$fechagrabar,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa);
        
        $stmt->execute();

        $respuesta = $con->insert_id;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 0;
    }
    return $respuesta;

}

