<?php

    //SCRIPT PARA REGISTRAR LEADS DE CALL CENTER EN LA TABLA TBLLEADCC
    //NO CONFUNDIR CON LA TABLA LEADS DE TRANSFERENCIA
    include('is_logged.php');
    date_default_timezone_set('America/Lima');
    //Funciones para codificar al momento de grabar en Mysql
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }
    
    require_once '../config/db.php';
    require_once '../config/conexion.php';
    
    include_once 'log/insertLog.php';
    include_once 'log/insertLogLead.php';
    include_once 'Correo/correoNotificacionLeadGestionRemarketing.php';
    
    mysqli_set_charset($con, 'utf8');
    
    include_once 'funciones/Televenta_transferenciaLead.php';
    
    $fecharegistro = date("Y-m-d H:i:s");
    
    $tipo = $_POST['tipo'];
    
    if($tipo == 'gestion'){
    
        $IdLeadCC = $_POST['IdLeadCC'];
        
        $matriculaOrigen = $_POST['matriculaOrigen'];
        $AgenteOrigen = $_POST['AgenteOrigen'];
        
        $matriculaAgente = $_POST['matriculaAgente'];
        $Agente = $_POST['Agente'];
        
        $remarketing = $_POST['remarketing'];
        //OBTENER IDUSUARIO DEL AGENTE
        $idUsuario = obtenerIdUsuario($matriculaAgente);
        
        $gestion = $_POST['gestion'];
        
        $contacto = $_POST['contacto'];
        
        $contactado = $_POST['Contactado'];
        $devolverLlamada = $_POST['DevolverLlamada'];
        
        if($contacto=='SI' || $contactado=='SI'){
            $contactado='SI';
        }
        

        $gestionable = $_POST['gestionable'];
        $tipificacion = $_POST['tipificacion'];
        $motivo = $_POST['motivo'];

        if($tipificacion == 'devolverLlamada'){
            $devolverLlamada='SI';
        }
        
        if(!empty($_POST['fechahoraRellamada'])){
            $fechahoraRellamada = $_POST['fechahoraRellamada'];
            $fechahoraRellamada =  date("Y-m-d H:i:s", strtotime(str_replace('/', '-', $fechahoraRellamada)));
        } else {
            $fechahoraRellamada = null;
        }
        
        $vueltas = $_POST['vueltas'];
        $vueltasRemarketing = $_POST['vueltasRemarketing'];
        $vueltage=null;
        if($remarketing == 'SI'){
            if($vueltasRemarketing==''){
                $vueltasRemarketing=0;
            }
            $vueltasRemarketing++;
            
        $vueltage=$vueltasRemarketing;
        } else {
            $vueltas++;
        $vueltage=$vueltas;
        }

        //if(($gestion == 'internet' || $gestion=='correo') && $vueltas >= 2){
        if($vueltas >= 2){
            $campaña = 'recovery';
        } 
        
        $observaciones = $_POST['observaciones'];
        
        if($tipificacion == 'televenta'){
            $gestorTV = $_POST['gestorTV'];
            $tipotransf=$_POST['tipotransf'];
            $observaciontransf = $_POST['observaciontransf'];
             if($tipotransf=='EnLinea'){
                 $estado = 'Transferido';
             }else{
                 $estado = null;
             }
             
            $fechaAsignacion = date("Y-m-d H:i:s");
        } else{
            $gestorTV = null;
            $tipotransf=null;
            $estado = null;
            $fechaAsignacion = null;
            $observaciontransf=null;
        }
    
        $nombres = $_POST['nombres'];
        $apellidos = $_POST['apellidos'];
        $telefono = $_POST['telefono'];
        $telefono2 = $_POST['telefono2'];
        $origen = trim($_POST['origen']);
        $leadid = $_POST['leadid'];
        $segmento = $_POST['segmento'];
        $ndocumento = $_POST['ndocumento'];
        $tipoDocumento = convertirtipoDocumentoEquifax($_POST['tipoDocumentoLead']);
        
        $direccionCliente = $_POST['direccionCliente'];
        
        $IdDireccion = $_POST['IdDireccion'];
        $idResultadoScoring = $_POST['idResultadoScoring'];
        $CodigoUbigeo = $_POST['CodigoUbigeo'];
        $Departamental = $_POST['Departamental'];
        $Provincial = $_POST['Provincial'];
        $Distrital = $_POST['Distrital'];
        
        $UltimaGestion=$_POST['UltimaGestion'];
        $fechaUltimaGestion=$_POST['fechaUltimaGestion'];

        $UltimaGestionCC=$_POST['UltimaGestionCC'];
        $fechaUltimaGestionCC=$_POST['fechaUltimaGestionCC'];

        
        $UltimaGestionRemarketing=null;
        
        $tipocamara= $_POST['tipocamara'];
        
       
        //VALIDA IDLEAD ANTES DE REGISTRAR
        
            if(isset($IdLeadCC)){
               if(validarTerminoGestion($IdLeadCC) > 0){
                    $resultado = array('respuesta' => 'terminargestion');
                    dd(json_encode($resultado));
                    exit;
                }
            } 
        
        
        try {
            $stmt = $con->prepare("INSERT INTO tblGestionLead (IdLead, IdUsuario, FechaHoraReg, Vueltas, ResultadoGestion,  FechaHoraRellamada, Observaciones, SubTipificacion, Contacto, Gestionable, Remarketing,TipoCamara) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)");
            $stmt->bind_param('iisissssssss', $IdLeadCC, $idUsuario, $fecharegistro, $vueltage, $tipificacion, $fechahoraRellamada, $observaciones, $motivo, $contacto, $gestionable, $remarketing,$tipocamara);
            $stmt->execute();
            
            $respuesta = $con->insert_id;
            
            
            
            if($respuesta > 0){
                
                $IdLogSeg = StmtInsertarLogSeguridad_General('Registrar', $fecharegistro, $respuesta, "IdGestionLead");
                insertLogGestionLeadTransac_RegLead($IdLogSeg, $respuesta);
                $UltimaGestionRemarketing=$respuesta;
                $respuestaGestion = actualizarGestion($IdLeadCC);
                
                $datosResultado = consultarDatos($respuesta);
                
                if($tipificacion == 'televenta'){
                    //GENERAR DATOS DEL CLIENTE
                    // -- PRIMERO SE DEBE GENERAR EL IDGEOGRAFICO DEL CLIENTE
                    $idGeografico = generarIdGeografico($CodigoUbigeo);
                    // -- REGISTRAR ID DOCUMENTO --
                    $idDocTV = registrarDocumento($tipoDocumento, $ndocumento);
                    
                    $NombreCompleto = $nombres.' '.$apellidos;
                    
                    $idCli = registrarCliente($idGeografico, $NombreCompleto, $telefono, $segmento, $idDocTV);
                    
                    //DATOS DEL GESTOR DE TELEVENTA
                    
                    $datosGestorTV = consultaDatosGestor($gestorTV);
                    
                    //GENERAR VENTA
                    
                    $IdVenta = generarVenta($idCli, $datosGestorTV, $segmento, $gestorTV,$matriculaAgente);
                    
                    $resultado = array(
                        'respuesta' => 'exito',
                        'respuestaGestion' => $respuestaGestion,
                        'idLeadGestion' => $respuesta,
                        'datosResultadoGestion' => $datosResultado,
                        'gestion' => $gestion,
                        'FechaRellamada' => $fechahoraRellamada,
                        'idCli' => $idCli,
                        'IdVenta' => $IdVenta
                    ); 
                } else {
                    $resultado = array(
                        'respuesta' => 'exito',
                        'respuestaGestion' => $respuestaGestion,
                        'idLeadGestion' => $respuesta,
                        'datosResultadoGestion' => $datosResultado,
                        'gestion' => $gestion,
                        'FechaRellamada' => $fechahoraRellamada,
                        
                    ); 
                }
                
                // if($remarketing == 'SI'){
                //     // if($matriculaOrigen != $matriculaAgente){
                //     //     correoNotificacionGestionRemarketing($IdLeadCC, $matriculaOrigen, $matriculaAgente);
                //     // }
                // }
            } else {
                $resultado = array('respuesta' => 'error');
            }
            
        } catch (\Exception $e) {
            $resultado = array('respuesta' => 'error');
        }
    
    }
    
    if($tipo == 'informacion'){
        $IdLeadCC = $_POST['IdLeadCC'];
        
        //SUPERVISOR
        $gestion = $_POST['gestion'];
        
        $nombres = $_POST['nombres'];
        $apellidos = $_POST['apellidos'];
        $telefono = $_POST['telefono'];
        $telefono2 = $_POST['telefono2'];
        $Departamental = $_POST['Departamental'];
        $Provincial = $_POST['Provincial'];
        $Distrital = $_POST['Distrital'];
        $CodigoUbigeo=$_POST['CodigoUbigeo'];
        $segmento = $_POST['segmento'];
        $nlocales = $_POST['nlocales'];
        $direccionCliente = $_POST['direccionCliente'];
        
        $npiso=$_POST['npiso'];
        if($npiso==""){
            $npiso=null;
        }
        $tiposegmento=$_POST['tiposegmento'];  
        if($tiposegmento==""){
            $tiposegmento=null;
        }
        
        if($nlocales >= 5){
            $ggcc = 'SI';
        } else {
            $ggcc = null;
        }
        
        $ndocumento = $_POST['ndocumento'];
        
        //OTROS
        if(empty($_POST['IdDireccion'])){
            $IdDireccion = null;
        } else {
            $IdDireccion = $_POST['IdDireccion'];
        }
        
        //$idResultadoScoring = $_POST['idResultadoScoring'];
        $origen = trim($_POST['origen']);
        $leadid = $_POST['leadid'];
        $observaciones = $_POST['observaciones'];
        $fechahoraCotizacion = $_POST['fechahoraCotizacion'];
        $fechahoraCotizacion =  date("Y-m-d H:i:s", strtotime(str_replace('/', '-', $fechahoraCotizacion)));
        
        $visePiso=$_POST['visePiso'];
        if($visePiso==""){
            $visePiso=null;
        }        
        $rubroNeg=$_POST['rubroNeg'];
        if($rubroNeg==""){
            $rubroNeg=null;
        }          
        $puertaCalle=$_POST['puertaCalle'];
        if($puertaCalle==""){
            $puertaCalle=null;
        }         
        $nobleParedes=$_POST['nobleParedes'];
        if($nobleParedes==""){
            $nobleParedes=null;
        }         
        $nobleTecho=$_POST['nobleTecho'];
        if($nobleTecho==""){
            $nobleTecho=null;
        }         
        $mcuadrados=$_POST['mcuadrados'];
        if($mcuadrados==""){
            $mcuadrados=null;
        }          
        $motivoInteres=$_POST['motivoInteres'];
        if($motivoInteres==""){
            $motivoInteres=null;
        }         
        $conSistema=$_POST['conSistema'];
        if($conSistema==""){
            $conSistema=null;
        }        
        $empresaSistema=$_POST['empresaSistema'];
        if($empresaSistema==""){
            $empresaSistema=null;
        }        
        $bancarizado=$_POST['bancarizado'];
        if($bancarizado==""){
            $bancarizado=null;
        }       
        
        try {
            $stmt = $con->prepare("UPDATE tblLeadCC 
                                    SET Nombres=?, 
                                        Apellidos=?, 
                                        Telefono2=?, 
                                        Departamento=?, 
                                        Provincia=?, 
                                        Distrito=?,
                                        CodigoUbigeo=?,
                                        Segmento=?, 
                                        NLocales=?, 
                                        Gestion=?, 
                                        IdDireccion=?, 
                                        Origen=?, 
                                        LeadID=?, 
                                        Observaciones=?, 
                                        FechaHoraCotizacion=?, 
                                        NDocumento=?, 
                                        Telefono=?,
                                        GGCC=?,
                                        DireccionLead=?,
                                        NPiso=?,
                                        TipoSegmento=?,
                                        visePiso=?,
                                        rubroNeg=?,
                                        puertaCalle=?,
                                        nobleParedes=?,
                                        nobleTecho=?,
                                        metros=?,
                                        motivoInteres=?,
                                        conSistema=?,
                                        empresaSistema=?,
                                        bancarizado=?
                                    WHERE IdLeadCC=?");
            $stmt->bind_param('ssssssssssissssssssissssssdssssi',$nombres, $apellidos, $telefono2, $Departamental, $Provincial, $Distrital,$CodigoUbigeo, $segmento, $nlocales, $gestion, $IdDireccion, $origen, $leadid, $observaciones, $fechahoraCotizacion, $ndocumento, $telefono, $ggcc, $direccionCliente,$npiso,$tiposegmento,$visePiso,$rubroNeg,$puertaCalle,$nobleParedes,$nobleTecho,$mcuadrados,$motivoInteres,$conSistema,$empresaSistema,$bancarizado, $IdLeadCC);
            $stmt->execute();
            
            $respuesta = $stmt->affected_rows;
            
            if($respuesta > 0){
                $resultado = array(
                    'respuesta' => 'exito',
                    'IdDireccion' => $IdDireccion
                );
            } else {
                $resultado = array(
                    'respuesta' => 'sinCambios',
                    'mensaje' => $stmt->error
                );
            }
        } catch (\Exception $e) {
            $respuesta = 'error';
        }
    }
    
    echo json_encode($resultado);
    
    function actualizarGestion($IdLeadCC){
        global $con;
        global $gestion;
        global $fecharegistro;
        global $tipificacion;
        global $campaña;
        global $vueltas;
        global $gestorTV;
        global $estado;
        global $fechaAsignacion;
        global $tipotransf;
        global $observaciontransf;
        
        global $IdDireccion;
        global $idResultadoScoring;
        
        global $nombres;
        global $apellidos;
        global $telefono2;
        global $segmento;
        global $direccionCliente;
        global $Departamental;
        global $Provincial;
        global $Distrital;
        global $CodigoUbigeo;
        global $observaciones;
        global $ndocumento;
        
        global $vueltasRemarketing;
        global $remarketing;
        global $UltimaGestion;
        global $fechaUltimaGestion;
        
        global $UltimaGestionRemarketing;
        global $contactado;
        
        global $UltimaGestionCC;
        global $fechaUltimaGestionCC;
        global $devolverLlamada;

        try {
            // if($tipificacion == "apagado" || $tipificacion == "noContacto"){
            //     if($remarketing=='SI'){
            //     $stmt = $con->prepare("UPDATE tblLeadCC 
            //                                             SET Gestion=?, 
            //                                                 ResultadoGestionRemarketing=?, 
            //                                                 FechaUltimaGestionRemarketing=?, 
            //                                                 Campaña=?, 
            //                                                 VueltasRemarketing=?, 
            //                                                 GestorTV=?, 
            //                                                 EstadoLead=?, 
            //                                                 FechaHoraAsignacion=?, 
            //                                                 TipoTransferencia=?, 
            //                                                 IdDireccion=?, 
            //                                                 IdScoring=?,
            //                                                 Nombres=?,
            //                                                 Apellidos=?,
            //                                                 Telefono2=?,
            //                                                 Segmento=?,
            //                                                 DireccionLead=?,
            //                                                 Departamento=?,
            //                                                 Provincia=?,
            //                                                 Distrito=?,
            //                                                 CodigoUbigeo=?,
            //                                                 NDocumento=?,
            //                                                 ObsTransferencia=?,
            //                                                 UltimaGestion=?,
            //                                                 FechaUltimaGestion=?,
            //                                                 Vueltas=?,
            //                                                 UltimaGestionRemarketing=?,
            //                                                 Contactado=?,
            //                                                 DevolverLlamada=?
            //                                         WHERE IdLeadCC=?");
            //     $stmt->bind_param('ssssissssiisssssssssssissi', $gestion, $tipificacion, $fecharegistro, $campaña, $vueltasRemarketing, $gestorTV, $estado, $fechaAsignacion, $tipotransf, $IdDireccion, $idResultadoScoring, $nombres, $apellidos, $telefono2, $segmento, $direccionCliente, $Departamental, $Provincial, $Distrital, $CodigoUbigeo, $ndocumento,$observaciontransf,$UltimaGestion,$fechaUltimaGestionCC,$vueltas,$UltimaGestionRemarketing,$contactado,$devolverLlamada, $IdLeadCC);
            //     $stmt->execute();
            //     $respuesta = $stmt->affected_rows;            
                    
                    
            //     }else{
            //     $stmt = $con->prepare("UPDATE tblLeadCC 
            //                                             SET Gestion=?, 
            //                                                 ResultadoGestion=?, 
            //                                                 FechaUltimaGestion=?, 
            //                                                 Campaña=?, 
            //                                                 Vueltas=?, 
            //                                                 GestorTV=?, 
            //                                                 EstadoLead=?, 
            //                                                 FechaHoraAsignacion=?, 
            //                                                 TipoTransferencia=?, 
            //                                                 IdDireccion=?, 
            //                                                 IdScoring=?,
            //                                                 Nombres=?,
            //                                                 Apellidos=?,
            //                                                 Telefono2=?,
            //                                                 Segmento=?,
            //                                                 DireccionLead=?,
            //                                                 Departamento=?,
            //                                                 Provincia=?,
            //                                                 Distrito=?,
            //                                                 CodigoUbigeo=?,
            //                                                 NDocumento=?,
            //                                                 ObsTransferencia=?,
            //                                                 Contactado=?,
            //                                                 DevolverLlamada=?
            //                                         WHERE IdLeadCC=?");
            //     $stmt->bind_param('ssssissssiisssssssssssssi', $gestion, $tipificacion, $fecharegistro, $campaña, $vueltas, $gestorTV, $estado, $fechaAsignacion, $tipotransf, $IdDireccion, $idResultadoScoring, $nombres, $apellidos, $telefono2, $segmento, $direccionCliente, $Departamental, $Provincial, $Distrital, $CodigoUbigeo, $ndocumento,$observaciontransf,$contactado,$devolverLlamada, $IdLeadCC);
            //     $stmt->execute();
            //     $respuesta = $stmt->affected_rows;
        
            //     }
            // }else{
                if($remarketing=='SI'){
        
        
                $stmt = $con->prepare("UPDATE tblLeadCC 
                                                        SET Gestion=?, 
                                                            ResultadoGestionRemarketing=?, 
                                                            FechaUltimaGestionRemarketing=?, 
                                                            Campaña=?, 
                                                            VueltasRemarketing=?, 
                                                            GestorTV=?, 
                                                            EstadoLead=?, 
                                                            FechaHoraAsignacion=?, 
                                                            TipoTransferencia=?, 
                                                            IdDireccion=?, 
                                                            IdScoring=?,
                                                            Nombres=?,
                                                            Apellidos=?,
                                                            Telefono2=?,
                                                            Segmento=?,
                                                            DireccionLead=?,
                                                            Departamento=?,
                                                            Provincia=?,
                                                            Distrito=?,
                                                            CodigoUbigeo=?,
                                                            Observaciones=?,
                                                            NDocumento=?,
                                                            ObsTransferencia=?,
                                                            UltimaGestion=?,
                                                            FechaUltimaGestion=?,
                                                            Vueltas=?,
                                                            UltimaGestionRemarketing=?,
                                                            Contactado=?,
                                                            DevolverLlamada=?
                                                    WHERE IdLeadCC=?");
                $stmt->bind_param('ssssissssiissssssssssssssiissi', $gestion, $tipificacion, $fecharegistro, $campaña, $vueltasRemarketing, $gestorTV, $estado, $fechaAsignacion, $tipotransf, $IdDireccion, $idResultadoScoring, $nombres, $apellidos, $telefono2, $segmento, $direccionCliente, $Departamental, $Provincial, $Distrital, $CodigoUbigeo, $observaciones, $ndocumento,$observaciontransf,$UltimaGestion,$fechaUltimaGestionCC,$vueltas,$UltimaGestionRemarketing,$contactado,$devolverLlamada, $IdLeadCC);
                $stmt->execute();
                $respuesta = $stmt->affected_rows;            
                    
                    
                }else{
        
                    
                $stmt = $con->prepare("UPDATE tblLeadCC 
                                                        SET Gestion=?, 
                                                            ResultadoGestion=?, 
                                                            FechaUltimaGestion=?, 
                                                            Campaña=?, 
                                                            Vueltas=?, 
                                                            GestorTV=?, 
                                                            EstadoLead=?, 
                                                            FechaHoraAsignacion=?, 
                                                            TipoTransferencia=?, 
                                                            IdDireccion=?, 
                                                            IdScoring=?,
                                                            Nombres=?,
                                                            Apellidos=?,
                                                            Telefono2=?,
                                                            Segmento=?,
                                                            DireccionLead=?,
                                                            Departamento=?,
                                                            Provincia=?,
                                                            Distrito=?,
                                                            CodigoUbigeo=?,
                                                            Observaciones=?,
                                                            NDocumento=?,
                                                            ObsTransferencia=?,
                                                            Contactado=?,
                                                            DevolverLlamada=?
                                                    WHERE IdLeadCC=?");
                $stmt->bind_param('ssssissssiissssssssssssssi', $gestion, $tipificacion, $fecharegistro, $campaña, $vueltas, $gestorTV, $estado, $fechaAsignacion, $tipotransf, $IdDireccion, $idResultadoScoring, $nombres, $apellidos, $telefono2, $segmento, $direccionCliente, $Departamental, $Provincial, $Distrital, $CodigoUbigeo, $observaciones, $ndocumento,$observaciontransf,$contactado,$devolverLlamada, $IdLeadCC);
                $stmt->execute();
                $respuesta = $stmt->affected_rows;
        
                }
            //}
            
        } catch (\Exception $e) {
            $respuesta = 'error';
        }
        
        return $respuesta;
    }
    
    function consultarDatos($IdLeadGestion){
        global $con;
        
        $sql = "SELECT * FROM tblGestionLead WHERE IdGestionLead = '".$IdLeadGestion."'";
        $resultado = $con->query($sql);
        
        while ($fila = $resultado->fetch_assoc()){
            $respuesta = $fila;
        }
        
        return $respuesta;
    }
    
    function obtenerIdUsuario($matriculaAgente){
        global $con;
        
        $sql = "SELECT IdUsuario FROM dbUSUARIO.tblusuario WHERE Matricula = '".$matriculaAgente."'";
        $resultado = $con->query($sql);
        
        $dataUsuario = mysqli_fetch_assoc($resultado);
        $idUsuario=$dataUsuario['IdUsuario'];
        
        return $idUsuario;
        
    }
    
    function convertirtipoDocumentoEquifax($tipoDocumento){
        $tipodocumentoconvertido=NULL;
        if($tipoDocumento==1){
            $tipodocumentoconvertido='DNI';
        }else if($tipoDocumento==6){
            $tipodocumentoconvertido='RUC';
        }else if($tipoDocumento==3){
            $tipodocumentoconvertido='CE';
        }else{
            $tipodocumentoconvertido='';
        }
        return $tipodocumentoconvertido;
    }
    
    function validarTerminoGestion($id){
        global $con;
        
        $sql = "SELECT * FROM tblLeadCC WHERE (resultadoGestion='Televenta' or resultadoGestion='VisitaAceptada') and IdLeadCC =".$id;
        $resultado = $con->query($sql);
        $row_cnt = $resultado->num_rows;
        if($row_cnt>0){
            return $row_cnt;
        }else{
            return 0;
        }
        
    }    
    