<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}

function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require '../config/db.php';
require '../config/conexion.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

$gestor = htmlspecialchars($_POST['gestor']);
//AGREGAR FUNCIONES LOG
include 'log/insertLog.php';
include 'log/insertLogAgenda.php';
include 'log/insertLogAgendaVenta.php';
include 'Correo/correoNotificacionAttec.php';

$estadoventa=htmlspecialchars($_POST['lblestadoventa']);

$ncontrato=htmlspecialchars($_POST['lblncontrato']);

$comentarioagenda=htmlspecialchars($_POST['lblcomentarioagenda']);
$comentarioattec=htmlspecialchars($_POST['lblcomentarioattec']);


$fecharegistroagenda = date("Y-m-d H:i:s");

$fecharegistroventa = date("Y-m-d H:i:s");


$matriculacomercial=htmlspecialchars($_POST['matriculacomercial']);
$cccomercial=htmlspecialchars($_POST['cccomercial']);
$matriculajefe=htmlspecialchars($_POST['matriculajefe']);
$tcgestor=htmlspecialchars($_POST['tcgestor']);


$idventa=htmlspecialchars($_POST['lblidventa']);
$idagenda=htmlspecialchars($_POST['lblidagenda']);
$idcliente=htmlspecialchars($_POST['lblidcliente']);

if ($_POST['FechaGestion'] == ''){
    $FechaGestion = NULL;
} else {
    $FechaGestion=htmlspecialchars($_POST['FechaGestion']);
}

if ($_POST['FechaAgendamiento'] == ''){
    $FechaAgendamiento = NULL;
} else {
    $FechaAgendamiento=htmlspecialchars($_POST['FechaAgendamiento']);
}

if ($_POST['FechaInstalacion'] == ''){
    $FechaInstalacion = NULL;
} else {
    $FechaInstalacion=htmlspecialchars($_POST['FechaInstalacion']);
}

if ($_POST['lblIdAgenRepor'] == ''){
    $lblIdAgenRepor = NULL;
} else {
    $lblIdAgenRepor=htmlspecialchars($_POST['lblIdAgenRepor']);
}

if ($_POST['FechaCancelada'] == ''){
    $FechaCancelada = NULL;
} else {
    $FechaCancelada=htmlspecialchars($_POST['FechaCancelada']);
}

if ($_POST['FechaInviable'] == ''){
    $FechaInviable = NULL;
} else {
    $FechaInviable=htmlspecialchars($_POST['FechaInviable']);
}

if ($_POST['FechaIlocalizable'] == ''){
    $FechaIlocalizable = NULL;
} else {
    $FechaIlocalizable=htmlspecialchars($_POST['FechaIlocalizable']);
}

//DATOS DE AUDITORIA

if (empty($_POST['idattec']) || $_POST['idattec'] == ''){
    $idattec = NULL;
} else {
    $idattec=htmlspecialchars($_POST['idattec']);
}

if ($_POST['lblfechaautidoria'] == '' || empty($_POST['lblfechaautidoria'])){
    $lblfechaautidoria = NULL;
} else {
    $lblfechaautidoria=htmlspecialchars($_POST['lblfechaautidoria']);
    $lblfechaautidoria=myUrlEncode($lblfechaautidoria);
    $lblfechaautidoria=format_date_Y_mm_dd(str_replace('/', '-', $lblfechaautidoria));    
}
if ($_POST['lblestadoattec'] == ''){
    $lblestadoattec = NULL;
} else {
    $lblestadoattec=htmlspecialchars($_POST['lblestadoattec']);
}
if ($_POST['hidden_datossbn'] == ''){
    $hidden_datossbn = NULL;
} else {
    $hidden_datossbn=htmlspecialchars($_POST['hidden_datossbn']);
}

if ($_POST['lbldatossbncorreccion'] == ''){
    $lbldatossbncorreccion = NULL;
} else {
    $lbldatossbncorreccion=htmlspecialchars($_POST['lbldatossbncorreccion']);
}

if ($_POST['lblfechacorrecion_datossbn'] == ''){
    $lblfechacorrecion_datossbn = NULL;
} else {
    $lblfechacorrecion_datossbn=htmlspecialchars($_POST['lblfechacorrecion_datossbn']);
    $lblfechacorrecion_datossbn=myUrlEncode($lblfechacorrecion_datossbn);
    $lblfechacorrecion_datossbn=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_datossbn));    
}
if ($_POST['hidden_segincorrecto'] == ''){
    $hidden_segincorrecto = NULL;
} else {
    $hidden_segincorrecto=htmlspecialchars($_POST['hidden_segincorrecto']);
}
if ($_POST['lblsegmentocorreccion'] == ''){
    $lblsegmentocorreccion = NULL;
} else {
    $lblsegmentocorreccion=htmlspecialchars($_POST['lblsegmentocorreccion']);
}
if ($_POST['lblfechacorrecion_segincorrecto'] == ''){
    $lblfechacorrecion_segincorrecto = NULL;
} else {
    $lblfechacorrecion_segincorrecto=htmlspecialchars($_POST['lblfechacorrecion_segincorrecto']);
    $lblfechacorrecion_segincorrecto=myUrlEncode($lblfechacorrecion_segincorrecto);
    $lblfechacorrecion_segincorrecto=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_segincorrecto));     
}
if ($_POST['hidden_imagen'] == ''){
    $hidden_imagen = NULL;
} else {
    $hidden_imagen=htmlspecialchars($_POST['hidden_imagen']);
}
if ($_POST['lblimagen_motivo'] == ''){
    $lblimagen_motivo = NULL;
} else {
    $lblimagen_motivo=htmlspecialchars($_POST['lblimagen_motivo']);
}
if ($_POST['lblfechacorrecion_imagen'] == ''){
    $lblfechacorrecion_imagen = NULL;
} else {
    $lblfechacorrecion_imagen=htmlspecialchars($_POST['lblfechacorrecion_imagen']);
    $lblfechacorrecion_imagen=myUrlEncode($lblfechacorrecion_imagen);
    $lblfechacorrecion_imagen=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_imagen));       
}
if ($_POST['hidden_ingresoprogramacion'] == ''){
    $hidden_ingresoprogramacion = NULL;
} else {
    $hidden_ingresoprogramacion=htmlspecialchars($_POST['hidden_ingresoprogramacion']);
}
if ($_POST['lblfechacorrecion_ingresoprogramacion'] == ''){
    $lblfechacorrecion_ingresoprogramacion = NULL;
} else {
    $lblfechacorrecion_ingresoprogramacion=htmlspecialchars($_POST['lblfechacorrecion_ingresoprogramacion']);
    $lblfechacorrecion_ingresoprogramacion=myUrlEncode($lblfechacorrecion_ingresoprogramacion);
    $lblfechacorrecion_ingresoprogramacion=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_ingresoprogramacion));      
}
if ($_POST['hidden_falloscomunicacion'] == ''){
    $hidden_falloscomunicacion = NULL;
} else {
    $hidden_falloscomunicacion=htmlspecialchars($_POST['hidden_falloscomunicacion']);
}
if ($_POST['lblfechacorrecion_falloscomunicacion'] == ''){
    $lblfechacorrecion_falloscomunicacion = NULL;
} else {
    $lblfechacorrecion_falloscomunicacion=htmlspecialchars($_POST['lblfechacorrecion_falloscomunicacion']);
    $lblfechacorrecion_falloscomunicacion=myUrlEncode($lblfechacorrecion_falloscomunicacion);
    $lblfechacorrecion_falloscomunicacion=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_falloscomunicacion));      
}
if ($_POST['hidden_missingtest'] == ''){
    $hidden_missingtest = NULL;
} else {
    $hidden_missingtest=htmlspecialchars($_POST['hidden_missingtest']);
}
if ($_POST['lblfechacorrecion_missingtest'] == ''){
    $lblfechacorrecion_missingtest = NULL;
} else {
    $lblfechacorrecion_missingtest=htmlspecialchars($_POST['lblfechacorrecion_missingtest']);
    $lblfechacorrecion_missingtest=myUrlEncode($lblfechacorrecion_missingtest);
    $lblfechacorrecion_missingtest=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_missingtest));    
}
if ($_POST['hidden_zerovision'] == ''){
    $hidden_zerovision = NULL;
} else {
    $hidden_zerovision=htmlspecialchars($_POST['hidden_zerovision']);
}
if ($_POST['lblfechacorrecion_zerovision'] == ''){
    $lblfechacorrecion_zerovision = NULL;
} else {
    $lblfechacorrecion_zerovision=htmlspecialchars($_POST['lblfechacorrecion_zerovision']);
    $lblfechacorrecion_zerovision=myUrlEncode($lblfechacorrecion_zerovision);
    $lblfechacorrecion_zerovision=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_zerovision));      
}
if ($_POST['hidden_fallosupervision'] == ''){
    $hidden_fallosupervision = NULL;
} else {
    $hidden_fallosupervision=htmlspecialchars($_POST['hidden_fallosupervision']);
}
if ($_POST['lblfechacorrecion_fallosupervision'] == ''){
    $lblfechacorrecion_fallosupervision = NULL;
} else {
    $lblfechacorrecion_fallosupervision=htmlspecialchars($_POST['lblfechacorrecion_fallosupervision']);
    $lblfechacorrecion_fallosupervision=myUrlEncode($lblfechacorrecion_fallosupervision);
    $lblfechacorrecion_fallosupervision=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_fallosupervision));      
}

if ($_POST['hidden_MG_01_retardo'] == ''){
    $hidden_MG_01_retardo = NULL;
} else {
    $hidden_MG_01_retardo=htmlspecialchars($_POST['hidden_MG_01_retardo']);
}
if ($_POST['lblfechacorrecion_MG_01_retardo'] == ''){
    $lblfechacorrecion_MG_01_retardo = NULL;
} else {
    $lblfechacorrecion_MG_01_retardo=htmlspecialchars($_POST['lblfechacorrecion_MG_01_retardo']);
    $lblfechacorrecion_MG_01_retardo=myUrlEncode($lblfechacorrecion_MG_01_retardo);
    $lblfechacorrecion_MG_01_retardo=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_MG_01_retardo));      
}



$detalleFallosSupervision=htmlspecialchars($_POST['detalleFallosSupervision']);

if ($_POST['hidden_tamper'] == ''){
    $hidden_tamper = NULL;
} else {
    $hidden_tamper=htmlspecialchars($_POST['hidden_tamper']);
}
if ($_POST['lblfechacorrecion_tamper'] == ''){
    $lblfechacorrecion_tamper = NULL;
} else {
    $lblfechacorrecion_tamper=htmlspecialchars($_POST['lblfechacorrecion_tamper']);
    $lblfechacorrecion_tamper=myUrlEncode($lblfechacorrecion_tamper);
    $lblfechacorrecion_tamper=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_tamper));     
}

$detalleExtras=htmlspecialchars($_POST['detalleExtras']);

if ($_POST['lblzerovisioncorreccion'] == ''){
    $lblzerovisioncorreccion = NULL;
} else {
    $lblzerovisioncorreccion=htmlspecialchars($_POST['lblzerovisioncorreccion']);
}

$finstalacion=htmlspecialchars($_POST['lblfinstalacion']);
$hinstalacion=htmlspecialchars($_POST['lblhinstalacion']);

if ($finstalacion == '' || empty($finstalacion)){
    $fechagrabar = NULL;
} else {
    $fechaconvert=  myUrlEncode($finstalacion);
    $fechagrabar=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvert));
}

if ($hinstalacion == '' || empty($hinstalacion)){
    $horagrabarcomparar = NULL;
} else {
    $horaconvert=  myUrlEncode($hinstalacion);
    $horagrabar=  date("H:i", strtotime(str_replace("+"," ",$horaconvert)));
    $horagrabarcomparar=  date("H:i:s", strtotime(str_replace("+"," ",$horaconvert)));
}


if ($_POST['lblIdAttecRepor'] == ''){
    $lblIdAttecRepor = NULL;
} else {
    $lblIdAttecRepor=htmlspecialchars($_POST['lblIdAttecRepor']);
}

if ($_POST['FechaGestionAttec'] == ''){
    $FechaGestionAttec = NULL;
} else {
    $FechaGestionAttec=htmlspecialchars($_POST['FechaGestionAttec']);
}
if ($_POST['FechaAuditadaOK'] == ''){
    $FechaAuditadaOK = NULL;
} else {
    $FechaAuditadaOK=htmlspecialchars($_POST['FechaAuditadaOK']);
}
if ($_POST['FechaObservada'] == ''){
    $FechaObservada = NULL;
} else {
    $FechaObservada=htmlspecialchars($_POST['FechaObservada']);
}
if ($_POST['FechaAuditadaResuelta'] == ''){
    $FechaAuditadaResuelta = NULL;
} else {
    $FechaAuditadaResuelta=htmlspecialchars($_POST['FechaAuditadaResuelta']);
}
if ($_POST['FechaInstaladaSinAuditar'] == ''){
    $FechaInstaladaSinAuditar = NULL;
} else {
    $FechaInstaladaSinAuditar=htmlspecialchars($_POST['FechaInstaladaSinAuditar']);
}
if ($_POST['FechaNoInstalada'] == ''){
    $FechaNoInstalada = NULL;
} else {
    $FechaNoInstalada=htmlspecialchars($_POST['FechaNoInstalada']);
}
if ($_POST['FechaObservadaInstalada'] == ''){
    $FechaObservadaInstalada = NULL;
} else {
    $FechaObservadaInstalada=htmlspecialchars($_POST['FechaObservadaInstalada']);
}
if ($_POST['FechaDesmontada'] == ''){
    $FechaDesmontada = NULL;
} else {
    $FechaDesmontada=htmlspecialchars($_POST['FechaDesmontada']);
}



//ARRAY QUE TRAE LOS DATOS DE AGENDA DE LA TABLA VENTA
$resultadoAgendaVenta = consultaAgendaVenta($idventa);

if(isset($ncontrato) && $ncontrato <> $resultadoAgendaVenta['NContrato']){
   if(validarNContrato($ncontrato) > 0){
        die('2');
    }
}


    /* CONSULTA PREPARADA N°09 */
    $sqlventa = "UPDATE dbVENTAS.tblventa v SET v.EstadoVenta=?,v.NContrato=? WHERE v.IdVenta=?";
    
    try{
        $stmt = $con->prepare($sqlventa);
        $stmt->bind_param('ssi', $estadoventa, $ncontrato, $idventa);
        $stmt->execute();
        $respuesta = $stmt->affected_rows;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    /* CONSULTA PREPARADA N°09 */
    $sqlclientecontrato = "UPDATE dbVENTAS.tblcliente c SET c.NCliente=? WHERE c.IdCliente=?";
    
    try{
        $stmt = $con->prepare($sqlclientecontrato);
        $stmt->bind_param('ss', $ncontrato, $idcliente);
        $stmt->execute();
        $respuesta2 = $stmt->affected_rows;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }    

//VALIDA QUE SE ACTUALIZARON DATOS DE AGENDA EN LA TABLA VENTA
$affectedrowAgendaVenta = $respuesta;

//ARRAY DE DATOS DE LA TABLA AGENDA
$resultadoAgenda=consultaAgendaAttec($idventa);
$resultadoAttec=consultaAttecAuditoria($idventa);
  
//CAMPO RETIRADO 
/*agen.FechaHoraMODIF='".$fecharegistroagenda."',*/
//VALIDA QUE SE ACTUALIZARON DATOS DE AGENDA EN LA TABLA AGENDA
$affectedrowAgenda = actualizarAgenda($idventa);

if ($idattec == NULL){
    $idattec = insertarATTEC();
    if($idattec>0){
       $affectattec=$idattec;
       //die(json_encode(array('respuesta' => 'exito', 'id_registro' => $idattec)));
    }else{
        $affectattec=0;
        //die(json_encode(array('respuesta' => 'error')));
    }
    
}else{
    $affectattec= actualizarATTEC($idattec);
}


if ($affectedrowAgendaVenta > 0 || $affectedrowAgenda > 0 || $affectattec>0){

//LOG DE AGENDA - ATTEC
$sqlagendahist=insertarAgendaHist($idagenda,$comentarioattec,$idattec);
   
//LOG DE SEGURIDAD    

            $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
            $usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
            $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa);
            $Acceso='Modificar';
            $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistroagenda, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              $idLogSeg = $con->insert_id;
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            }


    if($affectedrowAgendaVenta > 0){
        insertLogAgendaVenta($idLogSeg, $resultadoAgendaVenta);
    }
    if($affectedrowAgenda > 0){
        insertLogAgendaAttec($idLogSeg, $resultadoAgenda);
    }
    if($affectattec> 0){
        if(isset($comentarioattec) && $comentarioattec <> $resultadoAttec['Comentario']){
            if($estadoventa=="IncidenciaAuditoria"){
             enviarNotifiacionCorreo_test_v2($idventa,$comentarioattec,$cccomercial);    
            }
        }        
    }    

echo $sqlagendahist;

} else {
    echo 0;
}

function validarNContrato($val){
    global $con;
    
    $sql = "SELECT * FROM tblcliente WHERE NCliente =".$val;
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    return $row_cnt;
    
}

function actualizarAgenda($idventa){
    
    global $con;
    
    global $comentarioagenda;

    global $gestor;
    global $ncontrato;
    global $estadoventa;
    
    global $FechaGestion;
    global $FechaAgendamiento;
    global $FechaInstalacion;
    global $lblIdAgenRepor;
    global $FechaCancelada;
    global $FechaInviable;
    global $FechaIlocalizable;
    global $fechagrabar;
    global $horagrabar;
    
 
    if($estadoventa=='AgendadaTEC'){
        if ($FechaAgendamiento == ''){
            $FechaAgendamiento=date("Y-m-d H:i:s");
        }else{
            $FechaAgendamiento=$FechaAgendamiento;
            
        }
        
    }    
    if($estadoventa=='Instalada'){
        if ($FechaInstalacion == ''){
            $FechaInstalacion=date("Y-m-d H:i:s");
        }else{
            $FechaInstalacion=$FechaInstalacion;
            
        }
        
    }
    if($estadoventa=='Cancelada'){
        if ($FechaCancelada == ''){
            $FechaCancelada=date("Y-m-d H:i:s");
        }else{
            $FechaCancelada=$FechaCancelada;
            
        }
    }    
  
    

    if($lblIdAgenRepor>0){
        $actualiaragendareporte=actualizarAgendaReporte($lblIdAgenRepor,$FechaInstalacion,$FechaCancelada,$fechagrabar,$horagrabar);
    }    

    
    try{
        
        $stmt = $con->prepare("UPDATE dbVENTAS.tblagenda SET Comentario=?, GestorAgenda=?, EstadoVenta=?,NContrato=?,FechaGestion=?,FechaAgendamiento=?,FechaInstalacion=?,FechaInst=?,HoraInst=? WHERE IdVenta=?");
        $stmt->bind_param('sssssssssi', $comentarioagenda, $gestor, $estadoventa,$ncontrato,$FechaGestion,$FechaAgendamiento,$FechaInstalacion,$fechagrabar,$horagrabar, $idventa);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}


function actualizarAgendaReporte($idagendarorte,$FechaInstalacion,$FechaCancelada,$fechagrabar,$horagrabar){
    
    global $con;
    /*
    global $FechaGestion;
    global $FechaAgendamiento;
    global $FechaInstalacion;
    global $fechagrabar;
    global $horagrabar;
    */
        if ($fechagrabar == '' || empty($fechagrabar)){
            $FechaProgramacion = NULL;
        } else {
            $FechaProgramacion=$fechagrabar.' '.$horagrabar;
        }
    
    try{
        
        $stmt = $con->prepare("UPDATE dbVENTAS.tblagendareporte SET FechaInstalada= ?,FechaCancelada=?,FechaProgramacion=? WHERE IdAgenRepor=?");
        $stmt->bind_param('sssi', $FechaInstalacion,$FechaCancelada,$FechaProgramacion, $idagendarorte);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function actualizarATTEC($idattec){
    
    global $con;
    global $idventa;
    global $lblfechaautidoria;
    global $lblestadoattec;
    global $hidden_datossbn;
    global $lbldatossbncorreccion;
    global $lblfechacorrecion_datossbn;
    global $hidden_segincorrecto;
    global $lblsegmentocorreccion;
    global $lblfechacorrecion_segincorrecto;
    global $hidden_imagen;
    global $lblimagen_motivo;
    global $lblfechacorrecion_imagen;
    global $hidden_ingresoprogramacion;
    global $lblfechacorrecion_ingresoprogramacion;
    global $hidden_falloscomunicacion;
    global $lblfechacorrecion_falloscomunicacion;
    global $hidden_missingtest;
    global $lblfechacorrecion_missingtest;
    global $hidden_zerovision;
    global $lblfechacorrecion_zerovision;
    global $hidden_fallosupervision;
    global $lblfechacorrecion_fallosupervision;
    global $detalleFallosSupervision;
    global $hidden_tamper;
    global $lblfechacorrecion_tamper;
    global $detalleExtras;
    global $fecharegistroventa;
    global $comentarioattec;
    global $lblzerovisioncorreccion;
    
    global $hidden_MG_01_retardo;
    global $lblfechacorrecion_MG_01_retardo;

    try{
        $stmt = $con->prepare("UPDATE dbVENTAS.tblattec SET FechaAuditoria=?,EstadoAttec=?,DatosSbn=?,DatosSbn_NoCoincide=?,F_CorreccionDatosSbn=?,SegIncorrecto=?,F_CorreccionSegIncorrecto=?,Seg_DebeDecir=?,Imagen=?,F_Imagen=?,Imagen_Motivo=?,IngresoProgramacion=?,F_CorreccionIngresoProgramacion=?,FallosCobertura=?,F_CorreccionFallosCobertura=?,MissingTest=?,F_CorreccionMissingTest=?,ZeroVision=?,F_CorreccionZeroVision=?,FalloSupervision=?,F_CorreccionFalloSupervision=?,FalloSupervision_Dispotivos=?,Tamper=?,F_CorreccionTamper=?,Tamper_Dispotivos=?,Comentario=?,Zerovision_motivo=?,MG_01_retardo=?,F_CorreccionMG_01_retardo=? WHERE IdAttec=?");
        $stmt->bind_param('sssssssssssssssssssssssssssssi',  $lblfechaautidoria,$lblestadoattec,$hidden_datossbn,$lbldatossbncorreccion,$lblfechacorrecion_datossbn,$hidden_segincorrecto,$lblfechacorrecion_segincorrecto,$lblsegmentocorreccion,$hidden_imagen,$lblfechacorrecion_imagen,$lblimagen_motivo,$hidden_ingresoprogramacion,$lblfechacorrecion_ingresoprogramacion,$hidden_falloscomunicacion,$lblfechacorrecion_falloscomunicacion,$hidden_missingtest,$lblfechacorrecion_missingtest,$hidden_zerovision,$lblfechacorrecion_zerovision,$hidden_fallosupervision,$lblfechacorrecion_fallosupervision,$detalleFallosSupervision,$hidden_tamper,$lblfechacorrecion_tamper,$detalleExtras,$comentarioattec,$lblzerovisioncorreccion,$hidden_MG_01_retardo,$lblfechacorrecion_MG_01_retardo,$idattec);
        $stmt->execute();
    
        $respuesta = $stmt->affected_rows;
            
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
}


function insertarATTEC(){
    
    global $con;
    
    global $idventa;
    global $lblfechaautidoria;
    global $lblestadoattec;
    global $hidden_datossbn;
    global $lblfechacorrecion_datossbn;
    global $hidden_segincorrecto;
    global $lblsegmentocorreccion;
    global $lblfechacorrecion_segincorrecto;
    global $hidden_imagen;
    global $lblimagen_motivo;
    global $lblfechacorrecion_imagen;
    global $hidden_ingresoprogramacion;
    global $lblfechacorrecion_ingresoprogramacion;
    global $hidden_falloscomunicacion;
    global $lblfechacorrecion_falloscomunicacion;
    global $hidden_missingtest;
    global $lblfechacorrecion_missingtest;
    global $hidden_zerovision;
    global $lblfechacorrecion_zerovision;
    global $hidden_fallosupervision;
    global $lblfechacorrecion_fallosupervision;
    global $detalleFallosSupervision;
    global $hidden_tamper;
    global $lblfechacorrecion_tamper;
    global $detalleExtras;
    global $fecharegistroventa;
    global $comentarioattec;
    global $lblzerovisioncorreccion;
    global $lbldatossbncorreccion;
    global $hidden_MG_01_retardo;
    global $lblfechacorrecion_MG_01_retardo;
    

    try {
        
        $stmt = $con->prepare("INSERT INTO tblattec(IdVenta, FechaAuditoria, EstadoAttec, DatosSbn, F_CorreccionDatosSbn, SegIncorrecto, F_CorreccionSegIncorrecto, Seg_DebeDecir, Imagen, F_Imagen, Imagen_Motivo, IngresoProgramacion, F_CorreccionIngresoProgramacion, FallosCobertura, F_CorreccionFallosCobertura, MissingTest, F_CorreccionMissingTest, ZeroVision, F_CorreccionZeroVision, FalloSupervision, F_CorreccionFalloSupervision, FalloSupervision_Dispotivos, Tamper, F_CorreccionTamper, Tamper_Dispotivos, FechaHoraREG,Comentario,Zerovision_motivo,DatosSbn_NoCoincide,MG_01_retardo,F_CorreccionMG_01_retardo) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('issssssssssssssssssssssssssssss',  $idventa,$lblfechaautidoria,$lblestadoattec,$hidden_datossbn,$lblfechacorrecion_datossbn,$hidden_segincorrecto,$lblfechacorrecion_segincorrecto,$lblsegmentocorreccion,$hidden_imagen,$lblfechacorrecion_imagen,$lblimagen_motivo,$hidden_ingresoprogramacion,$lblfechacorrecion_ingresoprogramacion,$hidden_falloscomunicacion,$lblfechacorrecion_falloscomunicacion,$hidden_missingtest,$lblfechacorrecion_missingtest,$hidden_zerovision,$lblfechacorrecion_zerovision,$hidden_fallosupervision,$lblfechacorrecion_fallosupervision,$detalleFallosSupervision,$hidden_tamper,$lblfechacorrecion_tamper,$detalleExtras,$fecharegistroventa,$comentarioattec,$lblzerovisioncorreccion,$lbldatossbncorreccion,$hidden_MG_01_retardo,$lblfechacorrecion_MG_01_retardo);
        $stmt->execute();
        
        $respuesta = $con->insert_id;

        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
    }
    
    return $respuesta;
}

function insertarAgendaHist($idagenda,$comentarioagenda,$idattec){
    global $con;
    
    global $idventa;
    global $fecharegistroagenda;
    global $gestor;
    global $estadoventa;
    global $ncontrato;
    
    global $fechagrabar;
    global $horagrabar;
    //AUDITORIA
    
    global $lblfechaautidoria;
    global $lblestadoattec;
    global $hidden_datossbn;
    global $lblfechacorrecion_datossbn;
    global $hidden_segincorrecto;
    global $lblsegmentocorreccion;
    global $lblfechacorrecion_segincorrecto;
    global $hidden_imagen;
    global $lblimagen_motivo;
    global $lblfechacorrecion_imagen;
    global $hidden_ingresoprogramacion;
    global $lblfechacorrecion_ingresoprogramacion;
    global $hidden_falloscomunicacion;
    global $lblfechacorrecion_falloscomunicacion;
    global $hidden_missingtest;
    global $lblfechacorrecion_missingtest;
    global $hidden_zerovision;
    global $lblfechacorrecion_zerovision;
    global $hidden_fallosupervision;
    global $lblfechacorrecion_fallosupervision;
    global $hidden_tamper;
    global $lblfechacorrecion_tamper;
    global $lblzerovisioncorreccion;
    global $hidden_MG_01_retardo;
    global $lblfechacorrecion_MG_01_retardo;    

    try{
        
        $stmt = $con->prepare("INSERT INTO dbVENTAS.tblagendahist(IdAgenda,IdVenta,Comentario,FechaHoraREG,GestorAgenda,EstadoVenta,NContrato,FechaInst,HoraInst,IdAttec,FechaAuditoria,EstadoAttec,DatosSbn,F_CorreccionDatosSbn,SegIncorrecto,F_CorreccionSegIncorrecto,Seg_DebeDecir,Imagen,F_Imagen,Imagen_Motivo,IngresoProgramacion,F_CorreccionIngresoProgramacion,FallosCobertura,F_CorreccionFallosCobertura,MissingTest,F_CorreccionMissingTest,ZeroVision,F_CorreccionZeroVision,FalloSupervision,F_CorreccionFalloSupervision,Tamper,F_CorreccionTamper,Zerovision_motivo,MG_01_retardo,F_CorreccionMG_01_retardo) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iisssssssisssssssssssssssssssssssss',$idagenda,$idventa,$comentarioagenda,$fecharegistroagenda,$gestor,$estadoventa,$ncontrato,$fechagrabar,$horagrabar,$idattec,$lblfechaautidoria,$lblestadoattec,$hidden_datossbn,$lblfechacorrecion_datossbn,$hidden_segincorrecto,$lblfechacorrecion_segincorrecto,$lblsegmentocorreccion,$hidden_imagen,$lblfechacorrecion_imagen,$lblimagen_motivo,$hidden_ingresoprogramacion,$lblfechacorrecion_ingresoprogramacion,$hidden_falloscomunicacion,$lblfechacorrecion_falloscomunicacion,$hidden_missingtest,$lblfechacorrecion_missingtest,$hidden_zerovision,$lblfechacorrecion_zerovision,$hidden_fallosupervision,$lblfechacorrecion_fallosupervision,$hidden_tamper,$lblfechacorrecion_tamper,$lblzerovisioncorreccion,$hidden_MG_01_retardo,$lblfechacorrecion_MG_01_retardo);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}



function actualizarATTECReporte($lblIdAttecRepor,$FechaInstalacion,$FechaGestionAttec,$fechagrabar,$horagrabar,$FechaAuditadaOK,$FechaObservada,$FechaAuditadaResuelta,$FechaInstaladaSinAuditar,$FechaNoInstalada,$FechaObservadaInstalada,$FechaDesmontada){
    
    global $con;
    /*
    global $FechaGestion;
    global $FechaAgendamiento;
    global $FechaInstalacion;
    global $fechagrabar;
    global $horagrabar;
    */
        if ($fechagrabar == '' || empty($fechagrabar)){
            $FechaProgramacion = NULL;
        } else {
            $FechaProgramacion=$fechagrabar.' '.$horagrabar;
        }
    
    try{
        
        $stmt = $con->prepare("UPDATE dbVENTAS.tblattecreporte SET FechaInstalada= ?,FechaPrimeraGestion=?,FechaAuditadaOK=?,FechaObservada=?,FechaAuditadaResuelta=?,FechaInstaladaSinAuditar=?,FechaProgramacion=?,FechaNoInstalada=?,FechaObservadaInstalada=?,FechaDesmontada=? WHERE IdAttecRepor=?");
        $stmt->bind_param('ssssssssssi', $FechaInstalacion,$FechaGestionAttec,$FechaAuditadaOK,$FechaObservada,$FechaAuditadaResuelta,$FechaInstaladaSinAuditar,$FechaProgramacion,$FechaNoInstalada,$FechaObservadaInstalada,$FechaDesmontada,$lblIdAttecRepor);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

