<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require '../config/db.php';
require '../config/conexion.php';

$idAmpl = $_POST['idAmpl'];
$EstadoAmpliacion = $_POST['EstadoAmpliacion'];
//DATOS COTIZACION
$IdCotizacion = $_POST['IdCotizacion'];
$TotalUnidad = $_POST['TotalUnidad'];
$TotalPrecio = $_POST['TotalPrecio'];
//DATOS DETALLE COTIZACION
$iddetcotizacioninstalacion = $_POST['iddetcotizacioninstalacion'];
$Puertos = $_POST['Puertos'];
$PuntosCorriente = $_POST['PuntosCorriente'];
$VelocidadSubida = $_POST['VelocidadSubida'];
$Provincia = $_POST['Provincia'];
$Herramientas = $_POST['Herramientas'];
$Materiales=$_POST['Materiales'];
$InstaladoX=$_POST['InstaladoX'];
$Compatibilidad = $_POST['Compatibilidad'];
$Comentarios = $_POST['ComentarioCamara'];

$DetCotCam = $_POST['DetCotCam'];
$CotizacionTecnica = $_POST['CotizacionTecnica'];

$DetalleCamara = $CotizacionTecnica['DetalleCamara'];
$PrecioCotDetalle = $CotizacionTecnica["TotalInstalacion"];

$DetReq = generarJSON();


if(actualizarAmpliacion($idAmpl) > 0){

    //INSERTAR LOG DE TRANSACCION AMPLIACION -- MODIFICACION DE ESTADO
    
    //ACTUALIZAR COTIZACION
    
    if (empty($iddetcotizacioninstalacion)){
        $IdCotizacionDetalle = insertCotizacionDetalle($IdCotizacion);
        if ($IdCotizacionDetalle > 0 ){
            
            if  (actualizarCotizacion($IdCotizacion) >= 0){
                $resultado = array(
                    'respuesta' => 'Exito',
                    'tipo' => 'Insertar',
                    'IdCotDetalle' => $IdCotizacionDetalle
                );
            } else {
                $resultado = array(
                    'respuesta' => 'Error'
                );     
            }
            
        } else {
            $resultado = array(
                'respuesta' => 'Error'
            );     
        }    
    } else {
        $ActualizarCotDet = updateCotizacionDetalle($iddetcotizacioninstalacion);
        if ($ActualizarCotDet > 0 ){
            $ActualizarCotizacion = actualizarCotizacion($IdCotizacion);
            if  ($ActualizarCotizacion > 0){
                $resultado = array(
                    'respuesta' => 'Exito',
                    'tipo' => 'Actualizacion',
                    'IdCotDet' => $iddetcotizacioninstalacion
                );
            }
            else if ($ActualizarCotizacion == 0){
                $resultado = array(
                    'respuesta' => 'SinCambios',
                    'tipo' => 'Actualizacion',
                    'IdCotDet' => $iddetcotizacioninstalacion
                );
            }
            else {
                $resultado = array(
                    'respuesta' => 'Error'
                );
            }
        }
        else if ($ActualizarCotDet == 0){
            $resultado = array(
                'respuesta' => 'SinCambios',
                'tipo' => 'Actualizacion',
                'IdCotDet' => $iddetcotizacioninstalacion
            );
        }
        else {
            $resultado = array(
                'respuesta' => 'Error'
            );
        }   
    }
    
}
else if (actualizarAmpliacion($idAmpl) == 0){
    
    if (empty($iddetcotizacioninstalacion)){
        
        if (insertCotizacionDetalle($IdCotizacion) > 0 ){
            $iddetcotizacioninstalacion = actualizarCotizacion($IdCotizacion);
            if  ($iddetcotizacioninstalacion >= 0){
                $resultado = array(
                    'respuesta' => 'Exito',
                    'tipo' => 'Registro',
                    'IdCotDet' => $iddetcotizacioninstalacion
                );
            } else {
                $resultado = array(
                    'respuesta' => 'Error'
                );     
            }
        
        } else {
            $resultado = array(
                'respuesta' => 'Error'
            );
        }
            
    } else {
        $ActualizarCotDet = updateCotizacionDetalle($iddetcotizacioninstalacion);
        
        
        if ($ActualizarCotDet > 0 ){
            $ActualizarCotizacion = actualizarCotizacion($IdCotizacion);
            
            $resultado = array(
                    'respuesta' => 'Exito',
                    'tipo' => 'Actualizacion',
                    'IdCotDet' => $iddetcotizacioninstalacion
                );
        }
        else if ($ActualizarCotDet == 0){
            $resultado = array(
                'respuesta' => 'SinCambios',
                'tipo' => 'Actualizacion',
                'IdCotDet' => $iddetcotizacioninstalacion
            );
        }
        else {
            $resultado = array(
                'respuesta' => 'Error'
            );
        }
    }

}
else {
    $resultado = array(
        'respuesta' => 'Error'
    );    
}


$resultado = json_encode($resultado);

die($resultado);


function actualizarAmpliacion($idAmpl){
    
    global $con;
    
    global $EstadoAmpliacion;
    
    try{
        $stmt = $con->prepare("UPDATE tblampliacion SET EstadoAmp=? WHERE IdAmp=?");
        $stmt->bind_param('si', $EstadoAmpliacion, $idAmpl);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
}

function actualizarCotizacion($IdCotizacion){
    global $con;
    
    global $TotalUnidad;
    global $TotalPrecio;
    
    try{
        $stmt = $con->prepare("UPDATE tblcotizacion SET TotalUnidad=?, TotalPrecio=? WHERE IdCotizacion=?");
        $stmt->bind_param('idi', $TotalUnidad, $TotalPrecio, $IdCotizacion);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
}

function insertCotizacionDetalle($IdCotizacion){
    
    global $con;
    
    $Iditem = 31;
    $Unidades = 1;
    global $PrecioCotDetalle;
    $TipoPrecio = 'CATALOGO';
    $DsctoCta = 1.00;
    $Subtotal_cuotaMes = 0.0000;
    global $DetReq;
    
    try{
        $stmt = $con->prepare("INSERT INTO tblcotizaciondetalle(IdCotizacion, Iditem, Unidades, PrecioCotDetalle, TipoPrecio, DsctoCta, Subtotal, Subtotal_cuotaMes, DetReq)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param('iiidsddds', $IdCotizacion, $Iditem, $Unidades, $PrecioCotDetalle, $TipoPrecio, $DsctoCta, $PrecioCotDetalle, $Subtotal_cuotaMes, $DetReq);
        $stmt->execute();
        
        $respuesta = $con->insert_id;
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;

}

function updateCotizacionDetalle($iddetcotizacioninstalacion){
    global $con;
    
    global $PrecioCotDetalle;
    global $DetReq;
    
    try{
        
        $stmt = $con->prepare("UPDATE tblcotizaciondetalle SET PrecioCotDetalle = ?, Subtotal=?, DetReq=? WHERE IdCotDet=?");
        $stmt->bind_param('ddsi', $PrecioCotDetalle, $PrecioCotDetalle, $DetReq, $iddetcotizacioninstalacion);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
    
}

function generarJSON(){
    global $Puertos;
    global $PuntosCorriente;
    global $VelocidadSubida;
    global $Provincia;
    global $Herramientas;
    global $Materiales;
    global $InstaladoX;
    global $Compatibilidad;
    global $PrecioCotDetalle;
    global $Comentarios;
    
    global $DetCotCam;
    
    global $DetalleCamara;
    
    $DetReq = array(
            'Generales' => [
                    'Puertos' => $Puertos,
                    'PuntosCorriente' => $PuntosCorriente,
                    'VelocidadSubida' => $VelocidadSubida,
                    'Provincia' => $Provincia,
                    'Herramientas' => $Herramientas,
                    'Materiales'=>$Materiales,
                    'InstaladoX'=>$InstaladoX,
                    'Compatibilidad'=>$Compatibilidad,
                    'Comentarios'=>$Comentarios
                ],
            'DetCotCam' => $DetCotCam,
            'DetalleCamara' => $DetalleCamara,
            'PrecioCotDetalle' => $PrecioCotDetalle
        );
        
    $DetReq = json_encode($DetReq);
    
    return $DetReq;
}

function stringtonull($val){
    
    if ($val == '' || empty($val)){
        $resultado = NULL;
    }
    else if(!isset($val)){
        $resultado = NULL;
    }
    else {
        $resultado = $val;
    }
    
    return $resultado;
}













?>