<?php

include('is_logged.php');

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';


//LOGS TRANSACCCIONALES
include 'log/insertLog.php'; //LOG TRANSAC
include 'log/insertLogMDP.php'; //LOG MDP



if (isset($_POST['idmdp'])) {
   $idmdp = sanitizaCampo($_POST['idmdp'], 'sanitizeint|scapestring|htmlspecialchars',$con);
   $idmdp= htmlspecialchars($idmdp);
   $updatemdp = $con->prepare("UPDATE dbVENTAS.tblmdp SET EstadoURL='Inactivo' where IdMdp=?");
   $updatemdp->bind_param('i',$idmdp);
   $updatemdp->execute();
   
}else{
    $idmdp=NULL;
}

$lblurl = sanitizaCampo($_POST['lblurl'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblurl= htmlspecialchars($lblurl);

$lblfvencimiento = sanitizaCampo($_POST['lblfvencimiento'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblfvencimiento= htmlspecialchars($lblfvencimiento);

// $lblestadourl = sanitizaCampo($_POST['lblestadourl'], 'sanitizestring|scapestring|htmlspecialchars',$con);
// $lblestadourl= htmlspecialchars($lblestadourl);

$hidden_lblestadourl = sanitizaCampo($_POST['hidden_lblestadourl'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$hidden_lblestadourl= htmlspecialchars($hidden_lblestadourl);

$lblhvencimiento = sanitizaCampo($_POST['lblhvencimiento'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblhvencimiento= htmlspecialchars($lblhvencimiento);

$lblcanttransaccion = sanitizaCampo($_POST['lblcanttransaccion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$lblcanttransaccion= htmlspecialchars($lblcanttransaccion);

$lblarea = sanitizaCampo($_POST['lblarea'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblarea= htmlspecialchars($lblhvencimiento);

$fechaconvertvencimiento=  myUrlEncode($lblfvencimiento);
$fechagrabarvencimiento=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertvencimiento));

$horaconvertvencimiento=  myUrlEncode($lblhvencimiento);
$horagrabarvencimiento=  date("H:i", strtotime(str_replace("+"," ",$horaconvertvencimiento)));

// if(!empty($_POST['gestororigen'])){
//     $matriculausuario = sanitizaCampo($_POST['gestororigen'], 'sanitizestring|scapestring|htmlspecialchars',$con);
//     $matriculausuario= htmlspecialchars($matriculausuario);
// }else{
    $matriculausuario = "";
// }



$fecharegistro= date("Y-m-d H:i:s");

$arrayMDP=consultaMDPI();

$sql = $con->prepare("SELECT CONCAT('URL',YEAR(CURDATE()),AUTO_INCREMENT) as last FROM information_schema.TABLES WHERE TABLE_SCHEMA='dbVENTAS' AND TABLE_NAME='tblmdp'");
$sql->execute();
$sql->store_result();
$sql->bind_result(
    $lastRow
    );
while($sql->fetch()){
    $sqlejecutado = $lastRow;
}
// $sqlejecutado = $sql->execute();

try{
    $sqlmdp= $con->prepare("INSERT INTO dbVENTAS.tblmdp(URL, FechaHoraREG, FechaVencimiento, EstadoURL,CodigoMDP,HoraVencimiento,GestorOrigen,CantidadTransaccion,Area) VALUES (?,?,?,?,?,?,?,?,?)");
    $sqlmdp->bind_param('sssssssis',$lblurl,$fecharegistro,$fechagrabarvencimiento,$hidden_lblestadourl,$sqlejecutado,$horagrabarvencimiento,$matriculausuario,$lblcanttransaccion,$lblarea);
    $sqlmdp->execute();
    $sqlmdp->store_result();
    $idIdMdp=$con->insert_id;
    
    if($idIdMdp>0){
        $respuesta = 1;
    }
} catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
}
// echo $sqlmdp;
echo $respuesta;

$Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
$Ip = htmlspecialchars($Ip);

$Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$Usuario = htmlspecialchars($Usuario);

$Url = sanitizaCampo($_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa, 'sanitizeurl|scapestring|htmlspecialchars',$con);
$Url = htmlspecialchars($Url);

$Modificar = 'Registrar';

$Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$Navegador = htmlspecialchars($Navegador);


try{
	$result_exec= $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fecharegistro,$UrlLog,$Modificar,$Navegador);
	$result_exec->execute();
	$idLogSeg = $con->insert_id;
	$result_exec->close();
} catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
}

insertLogMDPI($idLogSeg, $arrayMDP);

