<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require '../config/db.php';
require '../config/conexion.php';

$fecharegistro = date("Y-m-d H:i:s");

//DATOS DE AMPLIACION
$idAmpl = stringtonull($_POST['idAmpl']);
$estadoAmp = $_POST['estadoAmp'];

$totalund = NULL;
$subtotal = stringtonull($_POST['subtotal']);
$TotalCuota = stringtonull($_POST['TotalCuota']);

if ($idAmpl > 0){
    if (empty($_POST['IdCotizacion'])){
        
        $IdCotizacion = generarCotizacion();
        
        if ($IdCotizacion > 0){
            $respuestaAmpliacion = actualizarAmpliacionIdCotizacion($idAmpl, $IdCotizacion);
            
            if ($respuestaAmpliacion > 0){
                $respuestaItem = insertarItems($IdCotizacion);
                if ($respuestaItem > 0){
                    actualizarCotizacion($IdCotizacion); //ACTUALIZA TOTALES EN LA TABLA COTIZACION
                    $respuesta = array('respuesta' => 'exito', 'idregistro' => $IdCotizacion, 'iditem' => $respuestaItem);
                    die(json_encode($respuesta));
                    //INSERTA LOG DE SEGURIDAD
                } else {
                    $respuesta = array('respuesta' => 'error');
                    die(json_encode($respuesta));
                }                
            } else {
                $respuesta = array('respuesta' => 'error');
                die(json_encode($respuesta));
            }
            
        } else {
            $respuesta = array('respuesta' => 'error'); 
            die(json_encode($respuesta));
        }
        
    } else {
        $IdCotizacion = $_POST['IdCotizacion'];
        
        $respuestaItem = insertarItems($IdCotizacion);
        
        if ($respuestaItem > 0){
            actualizarCotizacion($IdCotizacion);
            $respuesta = array('respuesta' => 'exito', 'idregistro' => $IdCotizacion, 'iditem' => $respuestaItem);
            die(json_encode($respuesta));
            //INSERTA LOG DE SEGURIDAD
        } else {
            $respuesta = array('respuesta' => 'error');
            die(json_encode($respuesta));
        }       
        
    }
} else {
    $respuesta = array('respuesta' => 'SinAmpliacion');
    die(json_encode($respuesta));
}

function generarCotizacion(){
    
    global $con;
    global $fecharegistro;
    
    
    try{
        $stmt = $con->prepare("INSERT INTO tblcotizacion(FechaHoraREG, UsuarioREG) VALUES (?, ?)");
        $stmt->bind_param('ss', $fecharegistro, $_SESSION['usuariosesion']);
        $stmt->execute();
        
        $IdCotizacion = $con->insert_id;
        
        $respuesta = $IdCotizacion;
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
}

function actualizarAmpliacionIdCotizacion($idAmpl, $IdCotizacion){
    
    global $con;
    
    global $estadoAmp;
    
        try{
        $stmt = $con->prepare("UPDATE tblampliacion SET IdCotizacion=?, EstadoAmp=? WHERE IdAmp = ?");
        $stmt->bind_param('isi', $IdCotizacion, $estadoAmp,  $idAmpl);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();    
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function insertarItems($IdCotizacion){
    
    global $con;
    
    if (isset($_POST['items']) || !empty($_POST['items'])){
        $arrayItems = $_POST['items'];
    }
    
    if(empty($arrayItems)){
        return 0;
    } else {
        foreach ($arrayItems as $v){
            $item = $v[0];
            $cantidad = $v[1];
            $precio = $v[2];
            $tipoPrecio = $v[3];
            $dsctoCuota = $v[4];
            $subtotal = $v[5];
            $cuotaMes = $v[6];
            
            try{
                $stmt = $con->prepare("INSERT INTO tblcotizaciondetalle(IdCotizacion, Iditem, Unidades,	TipoPrecio, DsctoCta, Subtotal, Subtotal_cuotaMes,PrecioCotDetalle) VALUES (?, ?, ?, ?, ?, ?, ?,?)");
                $stmt->bind_param('iiisdddd', $IdCotizacion, $item, $cantidad, $tipoPrecio, $dsctoCuota, $subtotal, $cuotaMes,$precio);
                $stmt->execute();
                
                $respuesta = $con->insert_id;
                
                $stmt->close();
            } catch (\Exception $e) {
                $respuesta = 'error';
            }
            
        }
        
        return $respuesta;
    }
    
}

function stringtonull($val){
    
    if ($val == '' || empty($val)){
        $resultado = NULL;
    }
    else if(!isset($val)){
        $resultado = NULL;
    }
    else {
        $resultado = $val;
    }
    
    return $resultado;
}

function actualizarCotizacion($IdCotizacion){
    global $con;
    
    global $totalund;
    global $subtotal;
    global $TotalCuota;
    
    try{
        $stmt = $con->prepare("UPDATE tblcotizacion SET TotalUnidad=?, TotalPrecio=?, TotalCuota=? WHERE IdCotizacion = ?");
        $stmt->bind_param('iddi', $totalund, $subtotal, $TotalCuota, $IdCotizacion);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();  
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
    
}
