<?php

    require_once '../config/db.php';
    require_once '../config/conexion.php';

    date_default_timezone_set('America/Lima');
    
    $fileContent = $_FILES['inputPlantilla'];
    $fileContent = file_get_contents($fileContent['tmp_name']);
    
    $fileContent = explode("\n", $fileContent);
    $fileContent = array_filter($fileContent);
    
    foreach ($fileContent as $fila){
        $solicitudes[] = explode(",", $fila);
    }
    
    if(sizeof($solicitudes) > 1){
        $i =0;
        foreach ($solicitudes as $data){
            if($i > 0){
                if(true){
                    $respuesta = insertDatos($data);
                    
                    $resultadoFinal[] = $respuesta;

                } else {
                    $respuesta = array(
                        'respuesta' => 'error',
                    );
                    
                    die(json_encode($respuesta));
                }
            }
            $i++; 
        }       
    } else {
        $respuesta = array(
            respuesta => 'Sindatos'
        );
        
        die(json_encode($respuesta));
    }
    
    echo json_encode($resultadoFinal, JSON_UNESCAPED_UNICODE);
    
    
    function insertDatos($data){
        
        global $con;
        
        $idSolicitud = $data[0];
        $estado = trim($data[1]);
        
        $fecharegistro = date("Y-m-d H:i:s");
        $id_usuario = $_SESSION['id_usuario'];
        
        try{
            $stmt = $con->prepare("UPDATE tblsolicitudesDetalle SET Estado = ?, FechaHoraModificacion=?, UsuarioModifica=? WHERE IdDetalleSolicitud = ?");
            $stmt->bind_param('ssii', $estado, $fecharegistro, $id_usuario, $idSolicitud);
            $stmt->execute();
            
            $rows = $stmt->affected_rows;
            
            if($rows > 0){
                $respuesta = array(
                        'respuesta' => 'exito',
                        'id' => $idSolicitud,
                        'data' => $data
                    );
                    
            } else {
                $respuesta = array(
                    'respuesta' => 'sincambios',
                    'id' => $idSolicitud,
                    'error' => $con->error,
                );
            }
            $stmt->close();
            
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error',
                'mensaje' => $e,
                'data' => $data
            );
        }
        
        return $respuesta;
    };
    
    
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
        
    }
    
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }

?>