<?php  
require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

$area = sanitizaCampo($_POST['area'],'sanitizestring|scapestring|htmlspecialchars',$con);
$query = $con->prepare("SELECT m.IdMdp, m.URL,m.CodigoMDP, COUNT(m.IdMdp) as cantidad FROM dbVENTAS.tblmdp m WHERE m.EstadoURL = 'Activo' and m.Area=?");
$query->bind_param('s',$area);
$query->execute();
$query->store_result();
$query->bind_result(
    $IdMdpRow,
    $URLRow,
    $CodigoMDPRow,
    $cantidadRow
    );
$return_arr = array();
if($query->num_rows > 0){
    
    while($query->fetch()){
     $row_array['IdMdp'] =$IdMdpRow;
     $row_array['URL'] =$URLRow;
     $row_array['CodigoMDP'] =$CodigoMDPRow;
     $row_array['cantidad'] =$cantidadRow;
     array_push($return_arr,array_map("utf8_encode",$row_array));
    }
    
}
echo json_encode($return_arr[0]);
$query->close();
?>