<?php

include('is_logged.php');
require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';


$numero = sanitizaCampo($_GET['numero'],'sanitizestring|scapestring|htmlspecialchars|stringtonull',$con);

    try{
        $stmt = $con->prepare( "SELECT 1 
FROM dbVENTAS.tblventa v INNER JOIN dbUSUARIO.tblusuario u ON u.IdUsuario=v.IdUsuario 
INNER JOIN dbVENTAS.tblagenda a ON a.IdVenta=v.IdVenta 
INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
WHERE (a.MatriculaTec=? and (v.EstadoVenta='AgendadaDEL' or v.EstadoVenta='AgendadaTEC')) or (a.AsignadoTEC=? and v.EstadoVenta='AsignadaEvalTEC') Limit 1");
        $stmt->bind_param('ss', $numero,$numero);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($num);

        if($stmt->num_rows>0){
            echo 1;
        }else{
            echo '<div class="callout bg-gray">
                <span class="pull-left">
                    <img src="admin/dist/img/noresults-img.png" style="width: 70%">
                </span>
                <h4><i class="fa fa-search"></i> &nbsp <span> Seleccionar el bot&oacuten de la Lupa para verificar los agendamientos.</span></h4> 
                <br>
                <p>En caso presentes problemas, comun&iacutecate con Soporte IT Per&uacute:</p>
                <p><i class="fa fa-phone"></i>&nbsp 514 7309</p>
                <p><i class="fa fa-envelope-o"></i><a href="mailto:soporteit@verisure.pe">&nbsp soporteit@verisure.pe </a></p>
                <br>
                </div>';
        }
        $stmt->fetch();
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

