<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';


date_default_timezone_set('America/Lima');

$fecharegistro=date("Y-m-d H:i:s");

        $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
        $usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
        $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI']);
        $Acceso='Exportar';
        $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
        
        try {
                
          $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
          $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
          $stmt->execute();
          $stmt->close();
          
        } catch (\Exception $e) {
          echo $e->getMessage();
        } 

  try{

        $stmtmdp = $con->prepare( "select t.IdTransaccion, t.FechaHoraREG, u.CC AS Del, t.GestorOrigen, t.TipoPago, 
t.CorreoBilling, t.TarjetaMarca , v.NContrato, v.NProspecto, m.URL, 
m.CodigoMDP,(v.Preciokit+v.TotalExtra) MontoTotal 
from tbltransaccion t inner join tblventa v on t.IdVenta=v.IdVenta 
inner join tblmdp m ON t.IdMdp=m.IdMdp 
INNER JOIN dbUSUARIO.tblusuario u on u.Matricula=t.GestorOrigen 
order by t.fechaHoraREG DESC
");
        $stmtmdp->execute();
        $stmtmdp->store_result();
        $stmtmdp->bind_result($IdTransaccion,
$FechaHoraREG,
$Del,
$GestorOrigen,
$TipoPago,
$CorreoBilling,
$TarjetaMarca ,
$NContrato,
$NProspecto,
$URL,
$CodigoMDP,
$MontoTotal);
        $transaccion = [];        
        while ($stmtmdp->fetch()){
        $transaccion[] = array_map("utf8_encode",['IdTransaccion'=>$IdTransaccion,
'FechaHoraREG'=>$FechaHoraREG,
'Del'=>$Del,
'GestorOrigen'=>$GestorOrigen,
'TipoPago'=>$TipoPago,
'CorreoBilling'=>$CorreoBilling,
'TarjetaMarca '=>$TarjetaMarca ,
'NContrato'=>$NContrato,
'NProspecto'=>$NProspecto,
'URL'=>$URL,
'CodigoMDP'=>$CodigoMDP,
'MontoTotal'=>$MontoTotal
]);            
	    }
	    
        $stmtmdp->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename=transaccionesMDP.csv');
$output = fopen('php://output', 'w');
fputcsv($output, array('IdTransaccion',
'FechaHoraREG',
'Del',
'GestorOrigen',
'TipoPago',
'CorreoBilling',
'TarjetaMarca ',
'NContrato',
'NProspecto',
'URL',
'CodigoMDP',
'MontoTotal'));

if (count($transaccion) > 0) {
    foreach ($transaccion as $row) {
        fputcsv($output, $row);
    }
}

?>