 <?php
include('is_logged.php');

require '../config/db.php';
require '../config/conexion.php';
require_once '../helper/helper_validacion.php';

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

$correocliente = (string) sanitizaCampo($_POST['correo'], 'sanitizeemail|scapestring|htmlspecialchars',$con);
$correocliente = htmlspecialchars($correocliente);
$contrato = (string) sanitizaCampo($_POST['contrato'],'sanitizestring|scapestring|htmlspecialchars',$con);
$contrato = htmlspecialchars($contrato);
$nombrecompleto = (string) sanitizaCampo($_POST['nombrecompleto'],'sanitizestring|scapestring',$con);
$nombrecompleto=htmlspecialchars($nombrecompleto);
$url = (string) sanitizaCampo($_POST['url'], 'sanitizeurl|scapestring|htmlspecialchars',$con);
$url = htmlspecialchars($url);


$ObjCorreoM=EnvioCorreoAfiliacion($correocliente,$contrato,$nombrecompleto,$url);
if($ObjCorreoM=='error'){
   $respuesta = array(
                'respuesta' => 'error'
            ); 
}else{
   $respuesta = array(
                'respuesta' => 'exito'
            ); 
}

            die(json_encode($respuesta));

  function EnvioCorreoAfiliacion($correocliente,$contrato,$nombrecompleto,$url){
        $texto="Verisure Perú - Solicitud de Afiliación ".$contrato;
        $opts = array(
        'http'=>array(
        'method'=>"GET",
        'header'=>"User-Agent: api script\r\n"
        ));
        
        $context = stream_context_create($opts);
        
        $curl = curl_init();
        
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => 'Administración - Verisure Perú',
            'From' => 'administracion@verisure.pe',
            'To' => 
            array (
              'Email' => 
              array (
                0 => $correocliente
              )
            ),
            'Cc' => 
            array (
              'Email' => 
              array (
                0 => '',
              )
            ),
            'Bcc' => 
            array (
              'Email' => 
              array (
                0 => 'joseenrique.nanquen@verisure.pe',
              )
            ),
            'Message' => 
            array (
              'Subject' => $texto,
              'Classification' => 'C',
              'Body' => 
              array (
                'Format' => 'html',
                'Value' => file_get_contents("https://verismart.com.pe/verismart/plantilla_afiliacion.php?contrato=".$contrato."&nombrecompleto=".$nombrecompleto."&url=".$url,false,$context),
              )
            ),
            'Options' => 
            array (
              'OpenTracking' => 'true',
              'ClickTracking' => 'true',
              'TextHtmlTracking' => 'true',
              'AutoTextBody' => 'false',
            )
          )
        );
        
        $dataSC_string = json_encode($dataSC);
        
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 60,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => $dataSC_string,
          CURLOPT_HTTPHEADER => array(
            "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
            "cache-control: no-cache",
            "content-type: application/json"
          ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
          return "error";
        } else {
          return $response;
        }
            
    
    }    