<?php
header("Content-Type: text/html;charset=utf-8");
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}



require '../config/db.php';
require '../config/conexion.php';
require_once '../helper/helper_validacion.php';

$idafiliacion = sanitizaCampo($_POST['idafiliacion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$lblstatusafiliacion = sanitizaCampo($_POST['lblstatusafiliacion'],'sanitizestring|scapestring|htmlspecialchars',$con);
$lblmotivoafiliacion = sanitizaCampo($_POST['lblmotivoafiliacion'],'sanitizestring|scapestring|htmlspecialchars',$con);
$lblncontrato = sanitizaCampo($_POST['lblncontrato'],'sanitizestring|scapestring|htmlspecialchars',$con);

$correoenviomdp = sanitizaCampo($_POST['correoenviomdp'], 'sanitizeemail|scapestring|htmlspecialchars',$con);
$url = sanitizaCampo($_POST['url'], 'sanitizeurl|scapestring|htmlspecialchars',$con);

$fechahoramod = date("Y-m-d H:i:s");

$resultadoAfiliacion = actualizarAfiliacion($idafiliacion);
if($resultadoAfiliacion>0){
    $resultado=array('respuesta'=>'exito');
}else{
    $resultado=array('respuesta'=>'error');
}

$afiliacionotros=findAfiliacionOtros($lblncontrato);
if($afiliacionotros>0){
    $resultadoAfiliacionOtros=actualizarAfiliacionOtros($afiliacionotros);
}

if(isset($correoenviomdp) && !empty($correoenviomdp)){
    EnvioCorreo_Respuesta($lblncontrato,$correoenviomdp,$lblstatusafiliacion);    
}


echo json_encode($resultado);

function actualizarAfiliacion($idafiliacion){
    
    global $con;
    
    global $lblstatusafiliacion,$lblmotivoafiliacion,$fechahoramod;

    try{
        $stmt = $con->prepare("UPDATE dbREFERIDO.tblmdpafiliacion SET status=?,motivo=?,fechahoramod=? WHERE id = ?");
        $stmt->bind_param('sssi', $lblstatusafiliacion,$lblmotivoafiliacion,$fechahoramod,$idafiliacion);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();    
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function actualizarAfiliacionOtros($idafiliacionotros){
    
    global $con;
    
    global $lblstatusafiliacion;

    try{
        $stmt = $con->prepare("UPDATE dbREFERIDO.tblafiliacionotros SET status=? WHERE id = ?");
        $stmt->bind_param('si', $lblstatusafiliacion,$idafiliacionotros);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();    
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}


  function findAfiliacionOtros($ncontrato){
    global $con;
    $sql = "SELECT id FROM dbREFERIDO.tblafiliacionotros WHERE contrato='".$ncontrato."' order by 1 desc limit 1"; 
    $resultado = $con->query($sql);
    if($resultado->num_rows>0){
        while($columna = $resultado->fetch_assoc()){
        $data = $columna['id'];
        }
    }else{
        $data=0;
    }

    return $data;
      
  }



function stringtonull($val){
    
    if ($val == '' || empty($val)){
        $resultado = NULL;
    }
    else if(!isset($val)){
        $resultado = NULL;
    }
    else {
        $resultado = $val;
    }
    
    return $resultado;
}

    function EnvioCorreo_Respuesta($contrato,$correocliente,$status){
        //ESTRUCTURA DEL CORREO ACTUALIZADO
        //DELEGADO
        //VARIABLES GLOBALES
        global $lblmotivoafiliacion;
        global $url;
        
        if($status=="RECHAZADO"){
        $titulo = "Solicitud de Afiliación Rechazada - Verisure Perú " . $contrato;
        $codigo=400;
        $concatenado=$codigo."/".rawurlencode($lblmotivoafiliacion)."/".$url;
        }else if($status=="AFILIADO"){
        $titulo = "Solicitud de Afiliación Aprobada - Verisure Perú " . $contrato;
        $codigo=201;
        $concatenado=$codigo;
        }else{
        $titulo = "Solicitud de Afiliación En Proceso - Verisure Perú " . $contrato;
        $codigo=200;
        $concatenado=$codigo;
        }
        
        $opts = array(
            'http'=>array(
            'method'=>"GET",
            'header'=>"User-Agent: api script\r\n"
        ));
        $context = stream_context_create($opts);
    
        $curl = curl_init();
        
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => 'Administración - Verisure Perú',
            'From' => 'administracion@verisure.pe',
            'To' => 
                array (
                  'Email' => 
                  array (
                    0 => $correocliente
                  )
                ),
            'Cc' => 
                array (
                  'Email' => 
                    array (
                        0 => '',
                    )
                ),
            'Bcc' => 
                array (
                    'Email' => 
                        array (
                            0 => 'administracion@verisure.pe',
                            1 => 'incidenciasfact@verisure.pe',
                        )
                ),
            'Message' => 
                array (
                    'Subject' => $titulo,
                    'Classification' => 'C',
                    'Body' => 
                        array (
                            'Format' => 'html',
                            'Value' => file_get_contents("https://clientesverisure.com/apps/afiliacion-otros/email-otros/$concatenado",false,$context),
                        )
                ),
            'Options' => 
                array (
                  'OpenTracking' => 'true',
                  'ClickTracking' => 'true',
                  'TextHtmlTracking' => 'true',
                  'AutoTextBody' => 'false',
                )
          )
        );
        
        $dataSC_string = json_encode($dataSC);
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $dataSC_string,
            CURLOPT_HTTPHEADER => array(
                "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
                "cache-control: no-cache",
                "content-type: application/json"
            ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
          return "cURL Error #:" . $err;
        } else {
          return $response;
        }    
    
    }


