<?php

class ConexionAmpliacion
{


	private $db;
	private $usuario;

	function __construct()
	{

		$this->db =  Database::connect();

	}

	public function obtenerInformacionCliente($contrato)
	{
        $query = $this->db->prepare("SELECT 
                        c.IdCliente,
                        c.NCliente,
                        c.NombApellido Cliente,
                        c.Telefonouno,
                        c.Telefonodos,
                        c.Correo,
                        c.Direccion,
                        d.condicionAmpliar,
                        d.formaPago,
                        d.fechaUltimaModificacion,
                        d.montoDeuda
                        FROM tblcliente c 
                        LEFT JOIN tbldeudas d on c.NCliente=d.contrato
                        WHERE c.NCliente=?");
        $query->execute(array($contrato));
        
		$retorno = [];
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}
		return $retorno;
	}
	
	public function obtenerHistorialCotizacion($contrato)
	{
        $query = $this->db->prepare("SELECT
        a.IdAmp,
        c.NCliente,
        a.FechaHoraCotizacion,
        a.EstadoCotizacion,
        a.Tecnico,
        a.EstadoAmp
        FROM tblampliacion a 
        INNER JOIN tblcliente c on c.IdCliente=a.IdCliente 
        WHERE c.NCliente=? and a.FechaHoraCotizacion >= DATE_SUB(CURDATE(), INTERVAL 6 MONTH)");
        $query->execute(array($contrato));
        
		$retorno = [];
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}
		return $retorno;
	}
	
	public function obtenerDatosItem($q)
	{
	    
	    $q = "%{$q}%";
        $query = $this->db->prepare("SELECT IdItem, 
        CodItem, 
        Item, 
        Precio, 
        CuotaMes,
        P_CATALOGO, 
        P_ALTO, 
        P_MEDIO, 
        P_BAJO, 
        P_SUPERVISOR      
        FROM tblitem
        where Item like ? and CategoriaItem = 'cotizacion' and Estado = 'Activo'");
        $query->execute(array($q));
		$retorno = [];
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}
		return $retorno;
	}	

	public function obtenerDatosUnItem($q)
	{
	    
        $query = $this->db->prepare("SELECT IdItem, 
        CodItem, 
        Item, 
        Precio, 
        CuotaMes,
        P_CATALOGO, 
        P_ALTO, 
        P_MEDIO, 
        P_BAJO, 
        P_SUPERVISOR      
        FROM tblitem
        where IdItem=?");
        $query->execute(array($q));
		$retorno = [];
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}
		return $retorno;
	}	

	public function obtenerDatosEnvioCorreo($idAmp)
	{
	    
        $query = $this->db->prepare("SELECT 
C.IdCliente,
C.IdGeografico,
G.Distrito,
G.Provincia,
C.NombApellido,
C.Telefonouno,
C.Telefonodos,
C.Correo,
C.Direccion,
C.NCliente,
C.Correodos,
A.NAviso,
C.Segmento,
agen.NMantenimiento,
A.GestorUpselling,
Concat(t.Nombres,' ',t.Apellidos) NombreGestor,
t.Correo CorreoGestor,
A.Tecnico,
Concat(t2.Nombres,' ',t2.Apellidos) NombreTecnico,
t2.Correo CorreoTecnico,
t2.Telefono TelefonoTecnico,
A.Canal,
A.TipoCanal,
A.EstadoAmp,
A.Campana,
A.ComentarioAmp,
A.MesAmp,
CTZ.IdCotizacion,
CTZ.FormaPago,
CTZ.PAI,
CTZ.ExtraAutorizado,
CTZ.MesesAutorizado,
CTZ.TotalUnidad,
CTZ.TotalPrecio,
CTZ.TotalCuota,
A.ObjCotizacion,
A.TotalExtra,
A.CantidadExtras,
DATE_FORMAT(A.FechaPosibleVisita, '%d/%m/%Y') FechaPosibleVisita
FROM tblampliacion A
INNER JOIN tblcliente C ON A.IdCliente = C.IdCliente
INNER JOIN tblgeografico G ON C.IdGeografico = G.IdGeografico
LEFT JOIN tblcotizacion CTZ ON A.IdCotizacion = CTZ.IdCotizacion
INNER JOIN dbVENTAS.tblagenda agen on agen.IdAmp=A.IdAmp
INNER JOIN dbVENTAS.tblfacturacion f on f.IdAmp=A.IdAmp
LEFT JOIN dbUSUARIO.tblusuario t on t.Matricula=A.GestorUpselling
LEFT JOIN dbUSUARIO.tblusuario t2 on t2.Matricula=A.Tecnico
WHERE A.IdAmp = ?");
        $query->execute(array($idAmp));
		$retorno = [];
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}
		return $retorno;
	}

    /* LISTAR COTIZACIONES*/
	public function mostrarTodosCotizaciones($function)
	{
        $new_total_rows = 0;
        $contador=1;
        
        $pagenum=htmlspecialchars(filter_var($function->pagenum, FILTER_SANITIZE_NUMBER_INT));
        $pagesize=htmlspecialchars(filter_var($function->pagesize, FILTER_SANITIZE_NUMBER_INT));
        
        $starts = $pagenum * $pagesize;
        

        $queryexec="SELECT
A.IdAmp,
G.Distrito,
G.Provincia,
C.NombApellido,
C.Telefonouno,
C.Direccion,
C.NCliente,
A.Canal,
A.TipoCanal,
A.Campana,
A.EstadoAmp,
A.ComentarioAmp,
A.MesAmp,
A.Tecnico,
DATE_FORMAT(A.FechaPosibleVisita, '%d/%m/%Y') FechaPosibleVisita,
A.EstadoCotizacion,
A.FechaHoraCotizacion
FROM tblampliacion A
INNER JOIN tblcliente C ON A.IdCliente = C.IdCliente
INNER JOIN tblgeografico G ON C.IdGeografico = G.IdGeografico
INNER JOIN dbVENTAS.tblagenda agen on agen.IdAmp=A.IdAmp
INNER JOIN dbVENTAS.tblfacturacion f on f.IdAmp=A.IdAmp
INNER JOIN dbUSUARIO.tblusuario t2 on t2.Matricula=A.Tecnico";
        
        $query = $queryexec." LIMIT :starts,:pagesize";


        $where="";
        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = htmlspecialchars($function->filterscount);
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = htmlspecialchars($function->{"filtervalue".$i});
        			// get the filter's condition.
        			$filtercondition =htmlspecialchars($function->{"filtercondition".$i});
        			// get the filter's column.
        			$filterdatafield =htmlspecialchars($function->{"filterdatafield".$i});
        			// get the filter's operator.
        			$filteroperator =htmlspecialchars($function->{"filteroperator".$i});
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        				case "NULL":
        					$where .= " " . $filterdatafield . " IS NULL";
        					break;
        				case "NOT_NULL":
        					$where .= " " . $filterdatafield . " NOT NULL";
        					break;
        				case "GREATER_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ." 00:00:00'";
        					break;
        				case "LESS_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ." 23:59:59'";
        					break;
        					
        					
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }
        if (isset($function->sortdatafield)){
        	$sortfield = htmlspecialchars($function->sortdatafield);
        	$sortorder = htmlspecialchars($function->sortorder);
        	$filterscount = htmlspecialchars($function->filterscount);
        	if ($sortorder != '')
        		{
        		if ($filterscount == 0)
        			{
        			if ($sortorder == "desc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}

        			}
        		else
        			{
        			if ($sortorder == "desc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}
        			$query = $queryexec." " .$where.$filterquery;
        			}
        		}
        }



		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(
'IdAmp' => $row['IdAmp'],
'Distrito' => $row['Distrito'],
'Provincia' => $row['Provincia'],
'NombApellido' => $row['NombApellido'],
'Telefonouno' => $row['Telefonouno'],
'Direccion' => $row['Direccion'],
'NCliente' => $row['NCliente'],
'Canal' => $row['Canal'],
'TipoCanal' => $row['TipoCanal'],
'Campana' => $row['Campana'],
'EstadoAmp' => $row['EstadoAmp'],
'ComentarioAmp' => $row['ComentarioAmp'],
'MesAmp' => $row['MesAmp'],
'Tecnico' => $row['Tecnico'],
'FechaPosibleVisita' => $row['FechaPosibleVisita'],
'EstadoCotizacion'=>$row['EstadoCotizacion']
                	);
$contador++;                	
            
        }
        
	    $query = "SELECT COUNT(*) AS found_rows FROM tblampliacion A
INNER JOIN tblcliente C ON A.IdCliente = C.IdCliente
INNER JOIN tblgeografico G ON C.IdGeografico = G.IdGeografico
INNER JOIN dbVENTAS.tblagenda agen on agen.IdAmp=A.IdAmp
INNER JOIN dbVENTAS.tblfacturacion f on f.IdAmp=A.IdAmp
INNER JOIN dbUSUARIO.tblusuario t2 on t2.Matricula=A.Tecnico ".$where;
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	} 

	public function obtenerItemImagenesCotizacion()
	{
        $query = $this->db->prepare("SELECT IdItem,
        Imagen,PDF
        FROM tblitem
        where CategoriaItem = 'cotizacion' and Estado = 'Activo'");
        $query->execute();
		$retorno = [];
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}
		return $retorno;
	}


    public function obtenerTotalAmpliacionesRealizadas($matricula,$perfil){

        if($perfil=='Administrador'){

        $query = $this->db->prepare("SELECT
        COUNT(A.IdAmp) as TotalAmpRealizadas
        FROM tblampliacion A
        WHERE
        A.EstadoCotizacion ='AmpliacionRealizada'");
        $query->execute();
		$retorno = 0;
		
		$rows=$query->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['TotalAmpRealizadas'];

        if ($total_rows > 0){
        	$retorno=$total_rows;
            
        }
		
		return $retorno;
            
        }else{
        $query = $this->db->prepare("SELECT
        COUNT(A.IdAmp) as TotalAmpRealizadas
        FROM tblampliacion A
        INNER JOIN dbUSUARIO.tblusuario t2 on t2.Matricula=A.Tecnico
        WHERE
        A.EstadoCotizacion ='AmpliacionRealizada' and  A.Tecnico=?");
        $query->execute(array($matricula));
		$retorno = 0;
		$rows=$query->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['TotalAmpRealizadas'];

        if ($total_rows > 0){
        	$retorno=$total_rows;
            
        }
		
		return $retorno;
        }
        
    }
    
    public function obtenerTotalPendienteRespuesta($matricula,$perfil){
        
        if($perfil=='Administrador'){

        $query = $this->db->prepare("SELECT
        COUNT(A.IdAmp) as TotalAmpRealizadas
        FROM tblampliacion A
        WHERE
        A.EstadoCotizacion ='PendienteRespuesta'");
        $query->execute();
		$retorno = 0;
		$rows=$query->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['TotalAmpRealizadas'];

        if ($total_rows > 0){
        	$retorno=$total_rows;
            
        }
		return $retorno;
            
        }else{
        $query = $this->db->prepare("SELECT
        COUNT(A.IdAmp) as TotalAmpRealizadas
        FROM tblampliacion A
        INNER JOIN dbUSUARIO.tblusuario t2 on t2.Matricula=A.Tecnico
        WHERE
        A.EstadoCotizacion ='PendienteRespuesta' and  A.Tecnico=?");
        $query->execute(array($matricula));
		$retorno = 0;
		$rows=$query->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['TotalAmpRealizadas'];

        if ($total_rows > 0){
        	$retorno=$total_rows;
            
        }
		
		return $retorno;
        }
    }
    
    public function obtenerTotalPendienteInstalacion($matricula,$perfil){
        
        if($perfil=='Administrador'){

        $query = $this->db->prepare("SELECT
        COUNT(A.IdAmp) as TotalAmpRealizadas
        FROM tblampliacion A
        WHERE
        A.EstadoCotizacion ='PendienteInstalacion'");
        $query->execute();
		$retorno = 0;
		$rows=$query->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['TotalAmpRealizadas'];

        if ($total_rows > 0){
        	$retorno=$total_rows;
            
        }
		
		return $retorno;        
            
        }else{

        $query = $this->db->prepare("SELECT
        COUNT(A.IdAmp) as TotalAmpRealizadas
        FROM tblampliacion A
        INNER JOIN dbUSUARIO.tblusuario t2 on t2.Matricula=A.Tecnico
        WHERE
        A.EstadoCotizacion ='PendienteInstalacion' and  A.Tecnico=?");
        $query->execute(array($matricula));
		$retorno = 0;
		$rows=$query->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['TotalAmpRealizadas'];

        if ($total_rows > 0){
        	$retorno=$total_rows;
            
        }
		
		return $retorno;
        }
        
    }
    
    
    
    


}
